/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/workflows/executions/v1beta/executions.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.workflows.executions.v1beta;

/**
 *
 *
 * <pre>
 * A running instance of a [Workflow][google.cloud.workflows.v1beta.Workflow].
 * </pre>
 *
 * Protobuf type {@code google.cloud.workflows.executions.v1beta.Execution}
 */
public final class Execution extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.workflows.executions.v1beta.Execution)
    ExecutionOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use Execution.newBuilder() to construct.
  private Execution(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Execution() {
    name_ = "";
    state_ = 0;
    argument_ = "";
    result_ = "";
    workflowRevisionId_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Execution();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.workflows.executions.v1beta.ExecutionsProto
        .internal_static_google_cloud_workflows_executions_v1beta_Execution_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.workflows.executions.v1beta.ExecutionsProto
        .internal_static_google_cloud_workflows_executions_v1beta_Execution_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.workflows.executions.v1beta.Execution.class,
            com.google.cloud.workflows.executions.v1beta.Execution.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Describes the current state of the execution. More states may be added
   * in the future.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.workflows.executions.v1beta.Execution.State}
   */
  public enum State implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Invalid state.
     * </pre>
     *
     * <code>STATE_UNSPECIFIED = 0;</code>
     */
    STATE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * The execution is in progress.
     * </pre>
     *
     * <code>ACTIVE = 1;</code>
     */
    ACTIVE(1),
    /**
     *
     *
     * <pre>
     * The execution finished successfully.
     * </pre>
     *
     * <code>SUCCEEDED = 2;</code>
     */
    SUCCEEDED(2),
    /**
     *
     *
     * <pre>
     * The execution failed with an error.
     * </pre>
     *
     * <code>FAILED = 3;</code>
     */
    FAILED(3),
    /**
     *
     *
     * <pre>
     * The execution was stopped intentionally.
     * </pre>
     *
     * <code>CANCELLED = 4;</code>
     */
    CANCELLED(4),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Invalid state.
     * </pre>
     *
     * <code>STATE_UNSPECIFIED = 0;</code>
     */
    public static final int STATE_UNSPECIFIED_VALUE = 0;

    /**
     *
     *
     * <pre>
     * The execution is in progress.
     * </pre>
     *
     * <code>ACTIVE = 1;</code>
     */
    public static final int ACTIVE_VALUE = 1;

    /**
     *
     *
     * <pre>
     * The execution finished successfully.
     * </pre>
     *
     * <code>SUCCEEDED = 2;</code>
     */
    public static final int SUCCEEDED_VALUE = 2;

    /**
     *
     *
     * <pre>
     * The execution failed with an error.
     * </pre>
     *
     * <code>FAILED = 3;</code>
     */
    public static final int FAILED_VALUE = 3;

    /**
     *
     *
     * <pre>
     * The execution was stopped intentionally.
     * </pre>
     *
     * <code>CANCELLED = 4;</code>
     */
    public static final int CANCELLED_VALUE = 4;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static State valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static State forNumber(int value) {
      switch (value) {
        case 0:
          return STATE_UNSPECIFIED;
        case 1:
          return ACTIVE;
        case 2:
          return SUCCEEDED;
        case 3:
          return FAILED;
        case 4:
          return CANCELLED;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<State> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<State> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<State>() {
          public State findValueByNumber(int number) {
            return State.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.workflows.executions.v1beta.Execution.getDescriptor()
          .getEnumTypes()
          .get(0);
    }

    private static final State[] VALUES = values();

    public static State valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private State(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.workflows.executions.v1beta.Execution.State)
  }

  public interface ErrorOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.workflows.executions.v1beta.Execution.Error)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Error payload returned by the execution, represented as a JSON string.
     * </pre>
     *
     * <code>string payload = 1;</code>
     *
     * @return The payload.
     */
    java.lang.String getPayload();

    /**
     *
     *
     * <pre>
     * Error payload returned by the execution, represented as a JSON string.
     * </pre>
     *
     * <code>string payload = 1;</code>
     *
     * @return The bytes for payload.
     */
    com.google.protobuf.ByteString getPayloadBytes();

    /**
     *
     *
     * <pre>
     * Human readable error context, helpful for debugging purposes.
     * </pre>
     *
     * <code>string context = 2;</code>
     *
     * @return The context.
     */
    java.lang.String getContext();

    /**
     *
     *
     * <pre>
     * Human readable error context, helpful for debugging purposes.
     * </pre>
     *
     * <code>string context = 2;</code>
     *
     * @return The bytes for context.
     */
    com.google.protobuf.ByteString getContextBytes();
  }

  /**
   *
   *
   * <pre>
   * Error describes why the execution was abnormally terminated.
   * </pre>
   *
   * Protobuf type {@code google.cloud.workflows.executions.v1beta.Execution.Error}
   */
  public static final class Error extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.workflows.executions.v1beta.Execution.Error)
      ErrorOrBuilder {
    private static final long serialVersionUID = 0L;

    // Use Error.newBuilder() to construct.
    private Error(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Error() {
      payload_ = "";
      context_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Error();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.workflows.executions.v1beta.ExecutionsProto
          .internal_static_google_cloud_workflows_executions_v1beta_Execution_Error_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.workflows.executions.v1beta.ExecutionsProto
          .internal_static_google_cloud_workflows_executions_v1beta_Execution_Error_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.workflows.executions.v1beta.Execution.Error.class,
              com.google.cloud.workflows.executions.v1beta.Execution.Error.Builder.class);
    }

    public static final int PAYLOAD_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object payload_ = "";

    /**
     *
     *
     * <pre>
     * Error payload returned by the execution, represented as a JSON string.
     * </pre>
     *
     * <code>string payload = 1;</code>
     *
     * @return The payload.
     */
    @java.lang.Override
    public java.lang.String getPayload() {
      java.lang.Object ref = payload_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        payload_ = s;
        return s;
      }
    }

    /**
     *
     *
     * <pre>
     * Error payload returned by the execution, represented as a JSON string.
     * </pre>
     *
     * <code>string payload = 1;</code>
     *
     * @return The bytes for payload.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getPayloadBytes() {
      java.lang.Object ref = payload_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        payload_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int CONTEXT_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private volatile java.lang.Object context_ = "";

    /**
     *
     *
     * <pre>
     * Human readable error context, helpful for debugging purposes.
     * </pre>
     *
     * <code>string context = 2;</code>
     *
     * @return The context.
     */
    @java.lang.Override
    public java.lang.String getContext() {
      java.lang.Object ref = context_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        context_ = s;
        return s;
      }
    }

    /**
     *
     *
     * <pre>
     * Human readable error context, helpful for debugging purposes.
     * </pre>
     *
     * <code>string context = 2;</code>
     *
     * @return The bytes for context.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getContextBytes() {
      java.lang.Object ref = context_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        context_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(payload_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, payload_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(context_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, context_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(payload_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, payload_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(context_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, context_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.workflows.executions.v1beta.Execution.Error)) {
        return super.equals(obj);
      }
      com.google.cloud.workflows.executions.v1beta.Execution.Error other =
          (com.google.cloud.workflows.executions.v1beta.Execution.Error) obj;

      if (!getPayload().equals(other.getPayload())) return false;
      if (!getContext().equals(other.getContext())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + PAYLOAD_FIELD_NUMBER;
      hash = (53 * hash) + getPayload().hashCode();
      hash = (37 * hash) + CONTEXT_FIELD_NUMBER;
      hash = (53 * hash) + getContext().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.workflows.executions.v1beta.Execution.Error parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.workflows.executions.v1beta.Execution.Error parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.workflows.executions.v1beta.Execution.Error parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.workflows.executions.v1beta.Execution.Error parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.workflows.executions.v1beta.Execution.Error parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.workflows.executions.v1beta.Execution.Error parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.workflows.executions.v1beta.Execution.Error parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.workflows.executions.v1beta.Execution.Error parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.workflows.executions.v1beta.Execution.Error parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.workflows.executions.v1beta.Execution.Error parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.workflows.executions.v1beta.Execution.Error parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.workflows.executions.v1beta.Execution.Error parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.workflows.executions.v1beta.Execution.Error prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * Error describes why the execution was abnormally terminated.
     * </pre>
     *
     * Protobuf type {@code google.cloud.workflows.executions.v1beta.Execution.Error}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.workflows.executions.v1beta.Execution.Error)
        com.google.cloud.workflows.executions.v1beta.Execution.ErrorOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.workflows.executions.v1beta.ExecutionsProto
            .internal_static_google_cloud_workflows_executions_v1beta_Execution_Error_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.workflows.executions.v1beta.ExecutionsProto
            .internal_static_google_cloud_workflows_executions_v1beta_Execution_Error_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.workflows.executions.v1beta.Execution.Error.class,
                com.google.cloud.workflows.executions.v1beta.Execution.Error.Builder.class);
      }

      // Construct using com.google.cloud.workflows.executions.v1beta.Execution.Error.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        payload_ = "";
        context_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.workflows.executions.v1beta.ExecutionsProto
            .internal_static_google_cloud_workflows_executions_v1beta_Execution_Error_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.workflows.executions.v1beta.Execution.Error
          getDefaultInstanceForType() {
        return com.google.cloud.workflows.executions.v1beta.Execution.Error.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.workflows.executions.v1beta.Execution.Error build() {
        com.google.cloud.workflows.executions.v1beta.Execution.Error result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.workflows.executions.v1beta.Execution.Error buildPartial() {
        com.google.cloud.workflows.executions.v1beta.Execution.Error result =
            new com.google.cloud.workflows.executions.v1beta.Execution.Error(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.workflows.executions.v1beta.Execution.Error result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.payload_ = payload_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.context_ = context_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.workflows.executions.v1beta.Execution.Error) {
          return mergeFrom((com.google.cloud.workflows.executions.v1beta.Execution.Error) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.workflows.executions.v1beta.Execution.Error other) {
        if (other
            == com.google.cloud.workflows.executions.v1beta.Execution.Error.getDefaultInstance())
          return this;
        if (!other.getPayload().isEmpty()) {
          payload_ = other.payload_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (!other.getContext().isEmpty()) {
          context_ = other.context_;
          bitField0_ |= 0x00000002;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  payload_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  context_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object payload_ = "";

      /**
       *
       *
       * <pre>
       * Error payload returned by the execution, represented as a JSON string.
       * </pre>
       *
       * <code>string payload = 1;</code>
       *
       * @return The payload.
       */
      public java.lang.String getPayload() {
        java.lang.Object ref = payload_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          payload_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Error payload returned by the execution, represented as a JSON string.
       * </pre>
       *
       * <code>string payload = 1;</code>
       *
       * @return The bytes for payload.
       */
      public com.google.protobuf.ByteString getPayloadBytes() {
        java.lang.Object ref = payload_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          payload_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Error payload returned by the execution, represented as a JSON string.
       * </pre>
       *
       * <code>string payload = 1;</code>
       *
       * @param value The payload to set.
       * @return This builder for chaining.
       */
      public Builder setPayload(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        payload_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Error payload returned by the execution, represented as a JSON string.
       * </pre>
       *
       * <code>string payload = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearPayload() {
        payload_ = getDefaultInstance().getPayload();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Error payload returned by the execution, represented as a JSON string.
       * </pre>
       *
       * <code>string payload = 1;</code>
       *
       * @param value The bytes for payload to set.
       * @return This builder for chaining.
       */
      public Builder setPayloadBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        payload_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private java.lang.Object context_ = "";

      /**
       *
       *
       * <pre>
       * Human readable error context, helpful for debugging purposes.
       * </pre>
       *
       * <code>string context = 2;</code>
       *
       * @return The context.
       */
      public java.lang.String getContext() {
        java.lang.Object ref = context_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          context_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Human readable error context, helpful for debugging purposes.
       * </pre>
       *
       * <code>string context = 2;</code>
       *
       * @return The bytes for context.
       */
      public com.google.protobuf.ByteString getContextBytes() {
        java.lang.Object ref = context_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          context_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Human readable error context, helpful for debugging purposes.
       * </pre>
       *
       * <code>string context = 2;</code>
       *
       * @param value The context to set.
       * @return This builder for chaining.
       */
      public Builder setContext(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        context_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Human readable error context, helpful for debugging purposes.
       * </pre>
       *
       * <code>string context = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearContext() {
        context_ = getDefaultInstance().getContext();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Human readable error context, helpful for debugging purposes.
       * </pre>
       *
       * <code>string context = 2;</code>
       *
       * @param value The bytes for context to set.
       * @return This builder for chaining.
       */
      public Builder setContextBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        context_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.workflows.executions.v1beta.Execution.Error)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.workflows.executions.v1beta.Execution.Error)
    private static final com.google.cloud.workflows.executions.v1beta.Execution.Error
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.workflows.executions.v1beta.Execution.Error();
    }

    public static com.google.cloud.workflows.executions.v1beta.Execution.Error
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Error> PARSER =
        new com.google.protobuf.AbstractParser<Error>() {
          @java.lang.Override
          public Error parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<Error> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Error> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.workflows.executions.v1beta.Execution.Error
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int bitField0_;
  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";

  /**
   *
   *
   * <pre>
   * Output only. The resource name of the execution.
   * Format:
   * projects/{project}/locations/{location}/workflows/{workflow}/executions/{execution}
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Output only. The resource name of the execution.
   * Format:
   * projects/{project}/locations/{location}/workflows/{workflow}/executions/{execution}
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int START_TIME_FIELD_NUMBER = 2;
  private com.google.protobuf.Timestamp startTime_;

  /**
   *
   *
   * <pre>
   * Output only. Marks the beginning of execution.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp start_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the startTime field is set.
   */
  @java.lang.Override
  public boolean hasStartTime() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * Output only. Marks the beginning of execution.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp start_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The startTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getStartTime() {
    return startTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : startTime_;
  }

  /**
   *
   *
   * <pre>
   * Output only. Marks the beginning of execution.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp start_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getStartTimeOrBuilder() {
    return startTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : startTime_;
  }

  public static final int END_TIME_FIELD_NUMBER = 3;
  private com.google.protobuf.Timestamp endTime_;

  /**
   *
   *
   * <pre>
   * Output only. Marks the end of execution, successful or not.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp end_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the endTime field is set.
   */
  @java.lang.Override
  public boolean hasEndTime() {
    return ((bitField0_ & 0x00000002) != 0);
  }

  /**
   *
   *
   * <pre>
   * Output only. Marks the end of execution, successful or not.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp end_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The endTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getEndTime() {
    return endTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : endTime_;
  }

  /**
   *
   *
   * <pre>
   * Output only. Marks the end of execution, successful or not.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp end_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getEndTimeOrBuilder() {
    return endTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : endTime_;
  }

  public static final int STATE_FIELD_NUMBER = 4;
  private int state_ = 0;

  /**
   *
   *
   * <pre>
   * Output only. Current state of the execution.
   * </pre>
   *
   * <code>
   * .google.cloud.workflows.executions.v1beta.Execution.State state = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The enum numeric value on the wire for state.
   */
  @java.lang.Override
  public int getStateValue() {
    return state_;
  }

  /**
   *
   *
   * <pre>
   * Output only. Current state of the execution.
   * </pre>
   *
   * <code>
   * .google.cloud.workflows.executions.v1beta.Execution.State state = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The state.
   */
  @java.lang.Override
  public com.google.cloud.workflows.executions.v1beta.Execution.State getState() {
    com.google.cloud.workflows.executions.v1beta.Execution.State result =
        com.google.cloud.workflows.executions.v1beta.Execution.State.forNumber(state_);
    return result == null
        ? com.google.cloud.workflows.executions.v1beta.Execution.State.UNRECOGNIZED
        : result;
  }

  public static final int ARGUMENT_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private volatile java.lang.Object argument_ = "";

  /**
   *
   *
   * <pre>
   * Input parameters of the execution represented as a JSON string.
   * The size limit is 32KB.
   * </pre>
   *
   * <code>string argument = 5;</code>
   *
   * @return The argument.
   */
  @java.lang.Override
  public java.lang.String getArgument() {
    java.lang.Object ref = argument_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      argument_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Input parameters of the execution represented as a JSON string.
   * The size limit is 32KB.
   * </pre>
   *
   * <code>string argument = 5;</code>
   *
   * @return The bytes for argument.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getArgumentBytes() {
    java.lang.Object ref = argument_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      argument_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int RESULT_FIELD_NUMBER = 6;

  @SuppressWarnings("serial")
  private volatile java.lang.Object result_ = "";

  /**
   *
   *
   * <pre>
   * Output only. Output of the execution represented as a JSON string. The
   * value can only be present if the execution's state is `SUCCEEDED`.
   * </pre>
   *
   * <code>string result = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The result.
   */
  @java.lang.Override
  public java.lang.String getResult() {
    java.lang.Object ref = result_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      result_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Output only. Output of the execution represented as a JSON string. The
   * value can only be present if the execution's state is `SUCCEEDED`.
   * </pre>
   *
   * <code>string result = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for result.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getResultBytes() {
    java.lang.Object ref = result_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      result_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ERROR_FIELD_NUMBER = 7;
  private com.google.cloud.workflows.executions.v1beta.Execution.Error error_;

  /**
   *
   *
   * <pre>
   * Output only. The error which caused the execution to finish prematurely.
   * The value is only present if the execution's state is `FAILED`
   * or `CANCELLED`.
   * </pre>
   *
   * <code>
   * .google.cloud.workflows.executions.v1beta.Execution.Error error = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the error field is set.
   */
  @java.lang.Override
  public boolean hasError() {
    return ((bitField0_ & 0x00000004) != 0);
  }

  /**
   *
   *
   * <pre>
   * Output only. The error which caused the execution to finish prematurely.
   * The value is only present if the execution's state is `FAILED`
   * or `CANCELLED`.
   * </pre>
   *
   * <code>
   * .google.cloud.workflows.executions.v1beta.Execution.Error error = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The error.
   */
  @java.lang.Override
  public com.google.cloud.workflows.executions.v1beta.Execution.Error getError() {
    return error_ == null
        ? com.google.cloud.workflows.executions.v1beta.Execution.Error.getDefaultInstance()
        : error_;
  }

  /**
   *
   *
   * <pre>
   * Output only. The error which caused the execution to finish prematurely.
   * The value is only present if the execution's state is `FAILED`
   * or `CANCELLED`.
   * </pre>
   *
   * <code>
   * .google.cloud.workflows.executions.v1beta.Execution.Error error = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.workflows.executions.v1beta.Execution.ErrorOrBuilder getErrorOrBuilder() {
    return error_ == null
        ? com.google.cloud.workflows.executions.v1beta.Execution.Error.getDefaultInstance()
        : error_;
  }

  public static final int WORKFLOW_REVISION_ID_FIELD_NUMBER = 8;

  @SuppressWarnings("serial")
  private volatile java.lang.Object workflowRevisionId_ = "";

  /**
   *
   *
   * <pre>
   * Output only. Revision of the workflow this execution is using.
   * </pre>
   *
   * <code>string workflow_revision_id = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The workflowRevisionId.
   */
  @java.lang.Override
  public java.lang.String getWorkflowRevisionId() {
    java.lang.Object ref = workflowRevisionId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      workflowRevisionId_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Output only. Revision of the workflow this execution is using.
   * </pre>
   *
   * <code>string workflow_revision_id = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for workflowRevisionId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getWorkflowRevisionIdBytes() {
    java.lang.Object ref = workflowRevisionId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      workflowRevisionId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(2, getStartTime());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(3, getEndTime());
    }
    if (state_
        != com.google.cloud.workflows.executions.v1beta.Execution.State.STATE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(4, state_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(argument_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, argument_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(result_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, result_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(7, getError());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(workflowRevisionId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 8, workflowRevisionId_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getStartTime());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getEndTime());
    }
    if (state_
        != com.google.cloud.workflows.executions.v1beta.Execution.State.STATE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(4, state_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(argument_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, argument_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(result_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, result_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, getError());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(workflowRevisionId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(8, workflowRevisionId_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.workflows.executions.v1beta.Execution)) {
      return super.equals(obj);
    }
    com.google.cloud.workflows.executions.v1beta.Execution other =
        (com.google.cloud.workflows.executions.v1beta.Execution) obj;

    if (!getName().equals(other.getName())) return false;
    if (hasStartTime() != other.hasStartTime()) return false;
    if (hasStartTime()) {
      if (!getStartTime().equals(other.getStartTime())) return false;
    }
    if (hasEndTime() != other.hasEndTime()) return false;
    if (hasEndTime()) {
      if (!getEndTime().equals(other.getEndTime())) return false;
    }
    if (state_ != other.state_) return false;
    if (!getArgument().equals(other.getArgument())) return false;
    if (!getResult().equals(other.getResult())) return false;
    if (hasError() != other.hasError()) return false;
    if (hasError()) {
      if (!getError().equals(other.getError())) return false;
    }
    if (!getWorkflowRevisionId().equals(other.getWorkflowRevisionId())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    if (hasStartTime()) {
      hash = (37 * hash) + START_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getStartTime().hashCode();
    }
    if (hasEndTime()) {
      hash = (37 * hash) + END_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getEndTime().hashCode();
    }
    hash = (37 * hash) + STATE_FIELD_NUMBER;
    hash = (53 * hash) + state_;
    hash = (37 * hash) + ARGUMENT_FIELD_NUMBER;
    hash = (53 * hash) + getArgument().hashCode();
    hash = (37 * hash) + RESULT_FIELD_NUMBER;
    hash = (53 * hash) + getResult().hashCode();
    if (hasError()) {
      hash = (37 * hash) + ERROR_FIELD_NUMBER;
      hash = (53 * hash) + getError().hashCode();
    }
    hash = (37 * hash) + WORKFLOW_REVISION_ID_FIELD_NUMBER;
    hash = (53 * hash) + getWorkflowRevisionId().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.workflows.executions.v1beta.Execution parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.workflows.executions.v1beta.Execution parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.workflows.executions.v1beta.Execution parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.workflows.executions.v1beta.Execution parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.workflows.executions.v1beta.Execution parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.workflows.executions.v1beta.Execution parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.workflows.executions.v1beta.Execution parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.workflows.executions.v1beta.Execution parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.workflows.executions.v1beta.Execution parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.workflows.executions.v1beta.Execution parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.workflows.executions.v1beta.Execution parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.workflows.executions.v1beta.Execution parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.workflows.executions.v1beta.Execution prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * A running instance of a [Workflow][google.cloud.workflows.v1beta.Workflow].
   * </pre>
   *
   * Protobuf type {@code google.cloud.workflows.executions.v1beta.Execution}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.workflows.executions.v1beta.Execution)
      com.google.cloud.workflows.executions.v1beta.ExecutionOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.workflows.executions.v1beta.ExecutionsProto
          .internal_static_google_cloud_workflows_executions_v1beta_Execution_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.workflows.executions.v1beta.ExecutionsProto
          .internal_static_google_cloud_workflows_executions_v1beta_Execution_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.workflows.executions.v1beta.Execution.class,
              com.google.cloud.workflows.executions.v1beta.Execution.Builder.class);
    }

    // Construct using com.google.cloud.workflows.executions.v1beta.Execution.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getStartTimeFieldBuilder();
        getEndTimeFieldBuilder();
        getErrorFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      startTime_ = null;
      if (startTimeBuilder_ != null) {
        startTimeBuilder_.dispose();
        startTimeBuilder_ = null;
      }
      endTime_ = null;
      if (endTimeBuilder_ != null) {
        endTimeBuilder_.dispose();
        endTimeBuilder_ = null;
      }
      state_ = 0;
      argument_ = "";
      result_ = "";
      error_ = null;
      if (errorBuilder_ != null) {
        errorBuilder_.dispose();
        errorBuilder_ = null;
      }
      workflowRevisionId_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.workflows.executions.v1beta.ExecutionsProto
          .internal_static_google_cloud_workflows_executions_v1beta_Execution_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.workflows.executions.v1beta.Execution getDefaultInstanceForType() {
      return com.google.cloud.workflows.executions.v1beta.Execution.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.workflows.executions.v1beta.Execution build() {
      com.google.cloud.workflows.executions.v1beta.Execution result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.workflows.executions.v1beta.Execution buildPartial() {
      com.google.cloud.workflows.executions.v1beta.Execution result =
          new com.google.cloud.workflows.executions.v1beta.Execution(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.workflows.executions.v1beta.Execution result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.startTime_ = startTimeBuilder_ == null ? startTime_ : startTimeBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.endTime_ = endTimeBuilder_ == null ? endTime_ : endTimeBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.state_ = state_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.argument_ = argument_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.result_ = result_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.error_ = errorBuilder_ == null ? error_ : errorBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.workflowRevisionId_ = workflowRevisionId_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.workflows.executions.v1beta.Execution) {
        return mergeFrom((com.google.cloud.workflows.executions.v1beta.Execution) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.workflows.executions.v1beta.Execution other) {
      if (other == com.google.cloud.workflows.executions.v1beta.Execution.getDefaultInstance())
        return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.hasStartTime()) {
        mergeStartTime(other.getStartTime());
      }
      if (other.hasEndTime()) {
        mergeEndTime(other.getEndTime());
      }
      if (other.state_ != 0) {
        setStateValue(other.getStateValue());
      }
      if (!other.getArgument().isEmpty()) {
        argument_ = other.argument_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      if (!other.getResult().isEmpty()) {
        result_ = other.result_;
        bitField0_ |= 0x00000020;
        onChanged();
      }
      if (other.hasError()) {
        mergeError(other.getError());
      }
      if (!other.getWorkflowRevisionId().isEmpty()) {
        workflowRevisionId_ = other.workflowRevisionId_;
        bitField0_ |= 0x00000080;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getStartTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getEndTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 32:
              {
                state_ = input.readEnum();
                bitField0_ |= 0x00000008;
                break;
              } // case 32
            case 42:
              {
                argument_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            case 50:
              {
                result_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000020;
                break;
              } // case 50
            case 58:
              {
                input.readMessage(getErrorFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000040;
                break;
              } // case 58
            case 66:
              {
                workflowRevisionId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000080;
                break;
              } // case 66
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";

    /**
     *
     *
     * <pre>
     * Output only. The resource name of the execution.
     * Format:
     * projects/{project}/locations/{location}/workflows/{workflow}/executions/{execution}
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. The resource name of the execution.
     * Format:
     * projects/{project}/locations/{location}/workflows/{workflow}/executions/{execution}
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. The resource name of the execution.
     * Format:
     * projects/{project}/locations/{location}/workflows/{workflow}/executions/{execution}
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The resource name of the execution.
     * Format:
     * projects/{project}/locations/{location}/workflows/{workflow}/executions/{execution}
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The resource name of the execution.
     * Format:
     * projects/{project}/locations/{location}/workflows/{workflow}/executions/{execution}
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp startTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        startTimeBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. Marks the beginning of execution.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the startTime field is set.
     */
    public boolean hasStartTime() {
      return ((bitField0_ & 0x00000002) != 0);
    }

    /**
     *
     *
     * <pre>
     * Output only. Marks the beginning of execution.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The startTime.
     */
    public com.google.protobuf.Timestamp getStartTime() {
      if (startTimeBuilder_ == null) {
        return startTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : startTime_;
      } else {
        return startTimeBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Marks the beginning of execution.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setStartTime(com.google.protobuf.Timestamp value) {
      if (startTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        startTime_ = value;
      } else {
        startTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Marks the beginning of execution.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setStartTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (startTimeBuilder_ == null) {
        startTime_ = builderForValue.build();
      } else {
        startTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Marks the beginning of execution.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeStartTime(com.google.protobuf.Timestamp value) {
      if (startTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && startTime_ != null
            && startTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getStartTimeBuilder().mergeFrom(value);
        } else {
          startTime_ = value;
        }
      } else {
        startTimeBuilder_.mergeFrom(value);
      }
      if (startTime_ != null) {
        bitField0_ |= 0x00000002;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Marks the beginning of execution.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearStartTime() {
      bitField0_ = (bitField0_ & ~0x00000002);
      startTime_ = null;
      if (startTimeBuilder_ != null) {
        startTimeBuilder_.dispose();
        startTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Marks the beginning of execution.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getStartTimeBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getStartTimeFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Output only. Marks the beginning of execution.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getStartTimeOrBuilder() {
      if (startTimeBuilder_ != null) {
        return startTimeBuilder_.getMessageOrBuilder();
      } else {
        return startTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : startTime_;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Marks the beginning of execution.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getStartTimeFieldBuilder() {
      if (startTimeBuilder_ == null) {
        startTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getStartTime(), getParentForChildren(), isClean());
        startTime_ = null;
      }
      return startTimeBuilder_;
    }

    private com.google.protobuf.Timestamp endTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        endTimeBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. Marks the end of execution, successful or not.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the endTime field is set.
     */
    public boolean hasEndTime() {
      return ((bitField0_ & 0x00000004) != 0);
    }

    /**
     *
     *
     * <pre>
     * Output only. Marks the end of execution, successful or not.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The endTime.
     */
    public com.google.protobuf.Timestamp getEndTime() {
      if (endTimeBuilder_ == null) {
        return endTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : endTime_;
      } else {
        return endTimeBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Marks the end of execution, successful or not.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setEndTime(com.google.protobuf.Timestamp value) {
      if (endTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        endTime_ = value;
      } else {
        endTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Marks the end of execution, successful or not.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setEndTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (endTimeBuilder_ == null) {
        endTime_ = builderForValue.build();
      } else {
        endTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Marks the end of execution, successful or not.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeEndTime(com.google.protobuf.Timestamp value) {
      if (endTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && endTime_ != null
            && endTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getEndTimeBuilder().mergeFrom(value);
        } else {
          endTime_ = value;
        }
      } else {
        endTimeBuilder_.mergeFrom(value);
      }
      if (endTime_ != null) {
        bitField0_ |= 0x00000004;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Marks the end of execution, successful or not.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearEndTime() {
      bitField0_ = (bitField0_ & ~0x00000004);
      endTime_ = null;
      if (endTimeBuilder_ != null) {
        endTimeBuilder_.dispose();
        endTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Marks the end of execution, successful or not.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getEndTimeBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getEndTimeFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Output only. Marks the end of execution, successful or not.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getEndTimeOrBuilder() {
      if (endTimeBuilder_ != null) {
        return endTimeBuilder_.getMessageOrBuilder();
      } else {
        return endTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : endTime_;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Marks the end of execution, successful or not.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getEndTimeFieldBuilder() {
      if (endTimeBuilder_ == null) {
        endTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getEndTime(), getParentForChildren(), isClean());
        endTime_ = null;
      }
      return endTimeBuilder_;
    }

    private int state_ = 0;

    /**
     *
     *
     * <pre>
     * Output only. Current state of the execution.
     * </pre>
     *
     * <code>
     * .google.cloud.workflows.executions.v1beta.Execution.State state = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for state.
     */
    @java.lang.Override
    public int getStateValue() {
      return state_;
    }

    /**
     *
     *
     * <pre>
     * Output only. Current state of the execution.
     * </pre>
     *
     * <code>
     * .google.cloud.workflows.executions.v1beta.Execution.State state = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The enum numeric value on the wire for state to set.
     * @return This builder for chaining.
     */
    public Builder setStateValue(int value) {
      state_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Current state of the execution.
     * </pre>
     *
     * <code>
     * .google.cloud.workflows.executions.v1beta.Execution.State state = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The state.
     */
    @java.lang.Override
    public com.google.cloud.workflows.executions.v1beta.Execution.State getState() {
      com.google.cloud.workflows.executions.v1beta.Execution.State result =
          com.google.cloud.workflows.executions.v1beta.Execution.State.forNumber(state_);
      return result == null
          ? com.google.cloud.workflows.executions.v1beta.Execution.State.UNRECOGNIZED
          : result;
    }

    /**
     *
     *
     * <pre>
     * Output only. Current state of the execution.
     * </pre>
     *
     * <code>
     * .google.cloud.workflows.executions.v1beta.Execution.State state = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The state to set.
     * @return This builder for chaining.
     */
    public Builder setState(com.google.cloud.workflows.executions.v1beta.Execution.State value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000008;
      state_ = value.getNumber();
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Current state of the execution.
     * </pre>
     *
     * <code>
     * .google.cloud.workflows.executions.v1beta.Execution.State state = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearState() {
      bitField0_ = (bitField0_ & ~0x00000008);
      state_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object argument_ = "";

    /**
     *
     *
     * <pre>
     * Input parameters of the execution represented as a JSON string.
     * The size limit is 32KB.
     * </pre>
     *
     * <code>string argument = 5;</code>
     *
     * @return The argument.
     */
    public java.lang.String getArgument() {
      java.lang.Object ref = argument_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        argument_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Input parameters of the execution represented as a JSON string.
     * The size limit is 32KB.
     * </pre>
     *
     * <code>string argument = 5;</code>
     *
     * @return The bytes for argument.
     */
    public com.google.protobuf.ByteString getArgumentBytes() {
      java.lang.Object ref = argument_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        argument_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Input parameters of the execution represented as a JSON string.
     * The size limit is 32KB.
     * </pre>
     *
     * <code>string argument = 5;</code>
     *
     * @param value The argument to set.
     * @return This builder for chaining.
     */
    public Builder setArgument(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      argument_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Input parameters of the execution represented as a JSON string.
     * The size limit is 32KB.
     * </pre>
     *
     * <code>string argument = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearArgument() {
      argument_ = getDefaultInstance().getArgument();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Input parameters of the execution represented as a JSON string.
     * The size limit is 32KB.
     * </pre>
     *
     * <code>string argument = 5;</code>
     *
     * @param value The bytes for argument to set.
     * @return This builder for chaining.
     */
    public Builder setArgumentBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      argument_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private java.lang.Object result_ = "";

    /**
     *
     *
     * <pre>
     * Output only. Output of the execution represented as a JSON string. The
     * value can only be present if the execution's state is `SUCCEEDED`.
     * </pre>
     *
     * <code>string result = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The result.
     */
    public java.lang.String getResult() {
      java.lang.Object ref = result_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        result_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Output of the execution represented as a JSON string. The
     * value can only be present if the execution's state is `SUCCEEDED`.
     * </pre>
     *
     * <code>string result = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for result.
     */
    public com.google.protobuf.ByteString getResultBytes() {
      java.lang.Object ref = result_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        result_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Output of the execution represented as a JSON string. The
     * value can only be present if the execution's state is `SUCCEEDED`.
     * </pre>
     *
     * <code>string result = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The result to set.
     * @return This builder for chaining.
     */
    public Builder setResult(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      result_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Output of the execution represented as a JSON string. The
     * value can only be present if the execution's state is `SUCCEEDED`.
     * </pre>
     *
     * <code>string result = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearResult() {
      result_ = getDefaultInstance().getResult();
      bitField0_ = (bitField0_ & ~0x00000020);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Output of the execution represented as a JSON string. The
     * value can only be present if the execution's state is `SUCCEEDED`.
     * </pre>
     *
     * <code>string result = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for result to set.
     * @return This builder for chaining.
     */
    public Builder setResultBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      result_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    private com.google.cloud.workflows.executions.v1beta.Execution.Error error_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.workflows.executions.v1beta.Execution.Error,
            com.google.cloud.workflows.executions.v1beta.Execution.Error.Builder,
            com.google.cloud.workflows.executions.v1beta.Execution.ErrorOrBuilder>
        errorBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. The error which caused the execution to finish prematurely.
     * The value is only present if the execution's state is `FAILED`
     * or `CANCELLED`.
     * </pre>
     *
     * <code>
     * .google.cloud.workflows.executions.v1beta.Execution.Error error = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the error field is set.
     */
    public boolean hasError() {
      return ((bitField0_ & 0x00000040) != 0);
    }

    /**
     *
     *
     * <pre>
     * Output only. The error which caused the execution to finish prematurely.
     * The value is only present if the execution's state is `FAILED`
     * or `CANCELLED`.
     * </pre>
     *
     * <code>
     * .google.cloud.workflows.executions.v1beta.Execution.Error error = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The error.
     */
    public com.google.cloud.workflows.executions.v1beta.Execution.Error getError() {
      if (errorBuilder_ == null) {
        return error_ == null
            ? com.google.cloud.workflows.executions.v1beta.Execution.Error.getDefaultInstance()
            : error_;
      } else {
        return errorBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. The error which caused the execution to finish prematurely.
     * The value is only present if the execution's state is `FAILED`
     * or `CANCELLED`.
     * </pre>
     *
     * <code>
     * .google.cloud.workflows.executions.v1beta.Execution.Error error = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setError(com.google.cloud.workflows.executions.v1beta.Execution.Error value) {
      if (errorBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        error_ = value;
      } else {
        errorBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The error which caused the execution to finish prematurely.
     * The value is only present if the execution's state is `FAILED`
     * or `CANCELLED`.
     * </pre>
     *
     * <code>
     * .google.cloud.workflows.executions.v1beta.Execution.Error error = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setError(
        com.google.cloud.workflows.executions.v1beta.Execution.Error.Builder builderForValue) {
      if (errorBuilder_ == null) {
        error_ = builderForValue.build();
      } else {
        errorBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The error which caused the execution to finish prematurely.
     * The value is only present if the execution's state is `FAILED`
     * or `CANCELLED`.
     * </pre>
     *
     * <code>
     * .google.cloud.workflows.executions.v1beta.Execution.Error error = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeError(com.google.cloud.workflows.executions.v1beta.Execution.Error value) {
      if (errorBuilder_ == null) {
        if (((bitField0_ & 0x00000040) != 0)
            && error_ != null
            && error_
                != com.google.cloud.workflows.executions.v1beta.Execution.Error
                    .getDefaultInstance()) {
          getErrorBuilder().mergeFrom(value);
        } else {
          error_ = value;
        }
      } else {
        errorBuilder_.mergeFrom(value);
      }
      if (error_ != null) {
        bitField0_ |= 0x00000040;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The error which caused the execution to finish prematurely.
     * The value is only present if the execution's state is `FAILED`
     * or `CANCELLED`.
     * </pre>
     *
     * <code>
     * .google.cloud.workflows.executions.v1beta.Execution.Error error = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearError() {
      bitField0_ = (bitField0_ & ~0x00000040);
      error_ = null;
      if (errorBuilder_ != null) {
        errorBuilder_.dispose();
        errorBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The error which caused the execution to finish prematurely.
     * The value is only present if the execution's state is `FAILED`
     * or `CANCELLED`.
     * </pre>
     *
     * <code>
     * .google.cloud.workflows.executions.v1beta.Execution.Error error = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.workflows.executions.v1beta.Execution.Error.Builder getErrorBuilder() {
      bitField0_ |= 0x00000040;
      onChanged();
      return getErrorFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Output only. The error which caused the execution to finish prematurely.
     * The value is only present if the execution's state is `FAILED`
     * or `CANCELLED`.
     * </pre>
     *
     * <code>
     * .google.cloud.workflows.executions.v1beta.Execution.Error error = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.workflows.executions.v1beta.Execution.ErrorOrBuilder
        getErrorOrBuilder() {
      if (errorBuilder_ != null) {
        return errorBuilder_.getMessageOrBuilder();
      } else {
        return error_ == null
            ? com.google.cloud.workflows.executions.v1beta.Execution.Error.getDefaultInstance()
            : error_;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. The error which caused the execution to finish prematurely.
     * The value is only present if the execution's state is `FAILED`
     * or `CANCELLED`.
     * </pre>
     *
     * <code>
     * .google.cloud.workflows.executions.v1beta.Execution.Error error = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.workflows.executions.v1beta.Execution.Error,
            com.google.cloud.workflows.executions.v1beta.Execution.Error.Builder,
            com.google.cloud.workflows.executions.v1beta.Execution.ErrorOrBuilder>
        getErrorFieldBuilder() {
      if (errorBuilder_ == null) {
        errorBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.workflows.executions.v1beta.Execution.Error,
                com.google.cloud.workflows.executions.v1beta.Execution.Error.Builder,
                com.google.cloud.workflows.executions.v1beta.Execution.ErrorOrBuilder>(
                getError(), getParentForChildren(), isClean());
        error_ = null;
      }
      return errorBuilder_;
    }

    private java.lang.Object workflowRevisionId_ = "";

    /**
     *
     *
     * <pre>
     * Output only. Revision of the workflow this execution is using.
     * </pre>
     *
     * <code>string workflow_revision_id = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The workflowRevisionId.
     */
    public java.lang.String getWorkflowRevisionId() {
      java.lang.Object ref = workflowRevisionId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        workflowRevisionId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Revision of the workflow this execution is using.
     * </pre>
     *
     * <code>string workflow_revision_id = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for workflowRevisionId.
     */
    public com.google.protobuf.ByteString getWorkflowRevisionIdBytes() {
      java.lang.Object ref = workflowRevisionId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        workflowRevisionId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Revision of the workflow this execution is using.
     * </pre>
     *
     * <code>string workflow_revision_id = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The workflowRevisionId to set.
     * @return This builder for chaining.
     */
    public Builder setWorkflowRevisionId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      workflowRevisionId_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Revision of the workflow this execution is using.
     * </pre>
     *
     * <code>string workflow_revision_id = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearWorkflowRevisionId() {
      workflowRevisionId_ = getDefaultInstance().getWorkflowRevisionId();
      bitField0_ = (bitField0_ & ~0x00000080);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Revision of the workflow this execution is using.
     * </pre>
     *
     * <code>string workflow_revision_id = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for workflowRevisionId to set.
     * @return This builder for chaining.
     */
    public Builder setWorkflowRevisionIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      workflowRevisionId_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.workflows.executions.v1beta.Execution)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.workflows.executions.v1beta.Execution)
  private static final com.google.cloud.workflows.executions.v1beta.Execution DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.workflows.executions.v1beta.Execution();
  }

  public static com.google.cloud.workflows.executions.v1beta.Execution getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Execution> PARSER =
      new com.google.protobuf.AbstractParser<Execution>() {
        @java.lang.Override
        public Execution parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Execution> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Execution> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.workflows.executions.v1beta.Execution getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
