/*
 * Copyright 2026 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// NO CHECKED-IN PROTOBUF GENCODE
// source: google/storage/v2/storage.proto
// Protobuf Java Version: 4.33.2

package com.google.storage.v2;

@com.google.protobuf.Generated
public interface MoveObjectRequestOrBuilder
    extends
    // @@protoc_insertion_point(interface_extends:google.storage.v2.MoveObjectRequest)
    com.google.protobuf.MessageOrBuilder {

  /**
   *
   *
   * <pre>
   * Required. Name of the bucket in which the object resides.
   * </pre>
   *
   * <code>
   * string bucket = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bucket.
   */
  java.lang.String getBucket();

  /**
   *
   *
   * <pre>
   * Required. Name of the bucket in which the object resides.
   * </pre>
   *
   * <code>
   * string bucket = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for bucket.
   */
  com.google.protobuf.ByteString getBucketBytes();

  /**
   *
   *
   * <pre>
   * Required. Name of the source object.
   * </pre>
   *
   * <code>string source_object = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The sourceObject.
   */
  java.lang.String getSourceObject();

  /**
   *
   *
   * <pre>
   * Required. Name of the source object.
   * </pre>
   *
   * <code>string source_object = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for sourceObject.
   */
  com.google.protobuf.ByteString getSourceObjectBytes();

  /**
   *
   *
   * <pre>
   * Required. Name of the destination object.
   * </pre>
   *
   * <code>string destination_object = 3 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The destinationObject.
   */
  java.lang.String getDestinationObject();

  /**
   *
   *
   * <pre>
   * Required. Name of the destination object.
   * </pre>
   *
   * <code>string destination_object = 3 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for destinationObject.
   */
  com.google.protobuf.ByteString getDestinationObjectBytes();

  /**
   *
   *
   * <pre>
   * Optional. Makes the operation conditional on whether the source object's
   * current generation matches the given value. `if_source_generation_match`
   * and `if_source_generation_not_match` conditions are mutually exclusive:
   * it's an error for both of them to be set in the request.
   * </pre>
   *
   * <code>optional int64 if_source_generation_match = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the ifSourceGenerationMatch field is set.
   */
  boolean hasIfSourceGenerationMatch();

  /**
   *
   *
   * <pre>
   * Optional. Makes the operation conditional on whether the source object's
   * current generation matches the given value. `if_source_generation_match`
   * and `if_source_generation_not_match` conditions are mutually exclusive:
   * it's an error for both of them to be set in the request.
   * </pre>
   *
   * <code>optional int64 if_source_generation_match = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The ifSourceGenerationMatch.
   */
  long getIfSourceGenerationMatch();

  /**
   *
   *
   * <pre>
   * Optional. Makes the operation conditional on whether the source object's
   * current generation does not match the given value.
   * `if_source_generation_match` and `if_source_generation_not_match`
   * conditions are mutually exclusive: it's an error for both of them to be set
   * in the request.
   * </pre>
   *
   * <code>
   * optional int64 if_source_generation_not_match = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the ifSourceGenerationNotMatch field is set.
   */
  boolean hasIfSourceGenerationNotMatch();

  /**
   *
   *
   * <pre>
   * Optional. Makes the operation conditional on whether the source object's
   * current generation does not match the given value.
   * `if_source_generation_match` and `if_source_generation_not_match`
   * conditions are mutually exclusive: it's an error for both of them to be set
   * in the request.
   * </pre>
   *
   * <code>
   * optional int64 if_source_generation_not_match = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The ifSourceGenerationNotMatch.
   */
  long getIfSourceGenerationNotMatch();

  /**
   *
   *
   * <pre>
   * Optional. Makes the operation conditional on whether the source object's
   * current metageneration matches the given value.
   * `if_source_metageneration_match` and `if_source_metageneration_not_match`
   * conditions are mutually exclusive: it's an error for both of them to be set
   * in the request.
   * </pre>
   *
   * <code>
   * optional int64 if_source_metageneration_match = 6 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the ifSourceMetagenerationMatch field is set.
   */
  boolean hasIfSourceMetagenerationMatch();

  /**
   *
   *
   * <pre>
   * Optional. Makes the operation conditional on whether the source object's
   * current metageneration matches the given value.
   * `if_source_metageneration_match` and `if_source_metageneration_not_match`
   * conditions are mutually exclusive: it's an error for both of them to be set
   * in the request.
   * </pre>
   *
   * <code>
   * optional int64 if_source_metageneration_match = 6 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The ifSourceMetagenerationMatch.
   */
  long getIfSourceMetagenerationMatch();

  /**
   *
   *
   * <pre>
   * Optional. Makes the operation conditional on whether the source object's
   * current metageneration does not match the given value.
   * `if_source_metageneration_match` and `if_source_metageneration_not_match`
   * conditions are mutually exclusive: it's an error for both of them to be set
   * in the request.
   * </pre>
   *
   * <code>
   * optional int64 if_source_metageneration_not_match = 7 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the ifSourceMetagenerationNotMatch field is set.
   */
  boolean hasIfSourceMetagenerationNotMatch();

  /**
   *
   *
   * <pre>
   * Optional. Makes the operation conditional on whether the source object's
   * current metageneration does not match the given value.
   * `if_source_metageneration_match` and `if_source_metageneration_not_match`
   * conditions are mutually exclusive: it's an error for both of them to be set
   * in the request.
   * </pre>
   *
   * <code>
   * optional int64 if_source_metageneration_not_match = 7 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The ifSourceMetagenerationNotMatch.
   */
  long getIfSourceMetagenerationNotMatch();

  /**
   *
   *
   * <pre>
   * Optional. Makes the operation conditional on whether the destination
   * object's current generation matches the given value. Setting to 0 makes the
   * operation succeed only if there are no live versions of the object.
   * `if_generation_match` and `if_generation_not_match` conditions are mutually
   * exclusive: it's an error for both of them to be set in the request.
   * </pre>
   *
   * <code>optional int64 if_generation_match = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return Whether the ifGenerationMatch field is set.
   */
  boolean hasIfGenerationMatch();

  /**
   *
   *
   * <pre>
   * Optional. Makes the operation conditional on whether the destination
   * object's current generation matches the given value. Setting to 0 makes the
   * operation succeed only if there are no live versions of the object.
   * `if_generation_match` and `if_generation_not_match` conditions are mutually
   * exclusive: it's an error for both of them to be set in the request.
   * </pre>
   *
   * <code>optional int64 if_generation_match = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The ifGenerationMatch.
   */
  long getIfGenerationMatch();

  /**
   *
   *
   * <pre>
   * Optional. Makes the operation conditional on whether the destination
   * object's current generation does not match the given value. If no live
   * object exists, the precondition fails. Setting to 0 makes the operation
   * succeed only if there is a live version of the object.
   * `if_generation_match` and `if_generation_not_match` conditions are mutually
   * exclusive: it's an error for both of them to be set in the request.
   * </pre>
   *
   * <code>optional int64 if_generation_not_match = 9 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the ifGenerationNotMatch field is set.
   */
  boolean hasIfGenerationNotMatch();

  /**
   *
   *
   * <pre>
   * Optional. Makes the operation conditional on whether the destination
   * object's current generation does not match the given value. If no live
   * object exists, the precondition fails. Setting to 0 makes the operation
   * succeed only if there is a live version of the object.
   * `if_generation_match` and `if_generation_not_match` conditions are mutually
   * exclusive: it's an error for both of them to be set in the request.
   * </pre>
   *
   * <code>optional int64 if_generation_not_match = 9 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The ifGenerationNotMatch.
   */
  long getIfGenerationNotMatch();

  /**
   *
   *
   * <pre>
   * Optional. Makes the operation conditional on whether the destination
   * object's current metageneration matches the given value.
   * `if_metageneration_match` and `if_metageneration_not_match` conditions are
   * mutually exclusive: it's an error for both of them to be set in the
   * request.
   * </pre>
   *
   * <code>optional int64 if_metageneration_match = 10 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the ifMetagenerationMatch field is set.
   */
  boolean hasIfMetagenerationMatch();

  /**
   *
   *
   * <pre>
   * Optional. Makes the operation conditional on whether the destination
   * object's current metageneration matches the given value.
   * `if_metageneration_match` and `if_metageneration_not_match` conditions are
   * mutually exclusive: it's an error for both of them to be set in the
   * request.
   * </pre>
   *
   * <code>optional int64 if_metageneration_match = 10 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The ifMetagenerationMatch.
   */
  long getIfMetagenerationMatch();

  /**
   *
   *
   * <pre>
   * Optional. Makes the operation conditional on whether the destination
   * object's current metageneration does not match the given value.
   * `if_metageneration_match` and `if_metageneration_not_match` conditions are
   * mutually exclusive: it's an error for both of them to be set in the
   * request.
   * </pre>
   *
   * <code>
   * optional int64 if_metageneration_not_match = 11 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the ifMetagenerationNotMatch field is set.
   */
  boolean hasIfMetagenerationNotMatch();

  /**
   *
   *
   * <pre>
   * Optional. Makes the operation conditional on whether the destination
   * object's current metageneration does not match the given value.
   * `if_metageneration_match` and `if_metageneration_not_match` conditions are
   * mutually exclusive: it's an error for both of them to be set in the
   * request.
   * </pre>
   *
   * <code>
   * optional int64 if_metageneration_not_match = 11 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The ifMetagenerationNotMatch.
   */
  long getIfMetagenerationNotMatch();
}
