/*
 * Copyright 2026 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/resourcemanager/v3/tag_holds.proto

// Protobuf Java Version: 3.25.8
package com.google.cloud.resourcemanager.v3;

/**
 *
 *
 * <pre>
 * A TagHold represents the use of a TagValue that is not captured by
 * TagBindings. If a TagValue has any TagHolds, deletion will be blocked.
 * This resource is intended to be created in the same cloud location as the
 * `holder`.
 * </pre>
 *
 * Protobuf type {@code google.cloud.resourcemanager.v3.TagHold}
 */
public final class TagHold extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.resourcemanager.v3.TagHold)
    TagHoldOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use TagHold.newBuilder() to construct.
  private TagHold(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private TagHold() {
    name_ = "";
    holder_ = "";
    origin_ = "";
    helpLink_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new TagHold();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.resourcemanager.v3.TagHoldsProto
        .internal_static_google_cloud_resourcemanager_v3_TagHold_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.resourcemanager.v3.TagHoldsProto
        .internal_static_google_cloud_resourcemanager_v3_TagHold_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.resourcemanager.v3.TagHold.class,
            com.google.cloud.resourcemanager.v3.TagHold.Builder.class);
  }

  private int bitField0_;
  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";

  /**
   *
   *
   * <pre>
   * Output only. The resource name of a TagHold. This is a String of the form:
   * `tagValues/{tag-value-id}/tagHolds/{tag-hold-id}`
   * (e.g. `tagValues/123/tagHolds/456`). This resource name is generated by
   * the server.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Output only. The resource name of a TagHold. This is a String of the form:
   * `tagValues/{tag-value-id}/tagHolds/{tag-hold-id}`
   * (e.g. `tagValues/123/tagHolds/456`). This resource name is generated by
   * the server.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int HOLDER_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object holder_ = "";

  /**
   *
   *
   * <pre>
   * Required. The name of the resource where the TagValue is being used. Must
   * be less than 200 characters. E.g.
   * `//compute.googleapis.com/compute/projects/myproject/regions/us-east-1/instanceGroupManagers/instance-group`
   * </pre>
   *
   * <code>string holder = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The holder.
   */
  @java.lang.Override
  public java.lang.String getHolder() {
    java.lang.Object ref = holder_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      holder_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Required. The name of the resource where the TagValue is being used. Must
   * be less than 200 characters. E.g.
   * `//compute.googleapis.com/compute/projects/myproject/regions/us-east-1/instanceGroupManagers/instance-group`
   * </pre>
   *
   * <code>string holder = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for holder.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getHolderBytes() {
    java.lang.Object ref = holder_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      holder_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ORIGIN_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object origin_ = "";

  /**
   *
   *
   * <pre>
   * Optional. An optional string representing the origin of this request. This
   * field should include human-understandable information to distinguish
   * origins from each other. Must be less than 200 characters. E.g.
   * `migs-35678234`
   * </pre>
   *
   * <code>string origin = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The origin.
   */
  @java.lang.Override
  public java.lang.String getOrigin() {
    java.lang.Object ref = origin_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      origin_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Optional. An optional string representing the origin of this request. This
   * field should include human-understandable information to distinguish
   * origins from each other. Must be less than 200 characters. E.g.
   * `migs-35678234`
   * </pre>
   *
   * <code>string origin = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for origin.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getOriginBytes() {
    java.lang.Object ref = origin_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      origin_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int HELP_LINK_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private volatile java.lang.Object helpLink_ = "";

  /**
   *
   *
   * <pre>
   * Optional. A URL where an end user can learn more about removing this hold.
   * E.g.
   * `https://cloud.google.com/resource-manager/docs/tags/tags-creating-and-managing`
   * </pre>
   *
   * <code>string help_link = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The helpLink.
   */
  @java.lang.Override
  public java.lang.String getHelpLink() {
    java.lang.Object ref = helpLink_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      helpLink_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Optional. A URL where an end user can learn more about removing this hold.
   * E.g.
   * `https://cloud.google.com/resource-manager/docs/tags/tags-creating-and-managing`
   * </pre>
   *
   * <code>string help_link = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for helpLink.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getHelpLinkBytes() {
    java.lang.Object ref = helpLink_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      helpLink_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 5;
  private com.google.protobuf.Timestamp createTime_;

  /**
   *
   *
   * <pre>
   * Output only. The time this TagHold was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * Output only. The time this TagHold was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }

  /**
   *
   *
   * <pre>
   * Output only. The time this TagHold was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(holder_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, holder_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(origin_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, origin_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(helpLink_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, helpLink_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(5, getCreateTime());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(holder_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, holder_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(origin_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, origin_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(helpLink_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, helpLink_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getCreateTime());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.resourcemanager.v3.TagHold)) {
      return super.equals(obj);
    }
    com.google.cloud.resourcemanager.v3.TagHold other =
        (com.google.cloud.resourcemanager.v3.TagHold) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getHolder().equals(other.getHolder())) return false;
    if (!getOrigin().equals(other.getOrigin())) return false;
    if (!getHelpLink().equals(other.getHelpLink())) return false;
    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + HOLDER_FIELD_NUMBER;
    hash = (53 * hash) + getHolder().hashCode();
    hash = (37 * hash) + ORIGIN_FIELD_NUMBER;
    hash = (53 * hash) + getOrigin().hashCode();
    hash = (37 * hash) + HELP_LINK_FIELD_NUMBER;
    hash = (53 * hash) + getHelpLink().hashCode();
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.resourcemanager.v3.TagHold parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.resourcemanager.v3.TagHold parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.resourcemanager.v3.TagHold parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.resourcemanager.v3.TagHold parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.resourcemanager.v3.TagHold parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.resourcemanager.v3.TagHold parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.resourcemanager.v3.TagHold parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.resourcemanager.v3.TagHold parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.resourcemanager.v3.TagHold parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.resourcemanager.v3.TagHold parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.resourcemanager.v3.TagHold parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.resourcemanager.v3.TagHold parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.resourcemanager.v3.TagHold prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * A TagHold represents the use of a TagValue that is not captured by
   * TagBindings. If a TagValue has any TagHolds, deletion will be blocked.
   * This resource is intended to be created in the same cloud location as the
   * `holder`.
   * </pre>
   *
   * Protobuf type {@code google.cloud.resourcemanager.v3.TagHold}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.resourcemanager.v3.TagHold)
      com.google.cloud.resourcemanager.v3.TagHoldOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.resourcemanager.v3.TagHoldsProto
          .internal_static_google_cloud_resourcemanager_v3_TagHold_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.resourcemanager.v3.TagHoldsProto
          .internal_static_google_cloud_resourcemanager_v3_TagHold_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.resourcemanager.v3.TagHold.class,
              com.google.cloud.resourcemanager.v3.TagHold.Builder.class);
    }

    // Construct using com.google.cloud.resourcemanager.v3.TagHold.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getCreateTimeFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      holder_ = "";
      origin_ = "";
      helpLink_ = "";
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.resourcemanager.v3.TagHoldsProto
          .internal_static_google_cloud_resourcemanager_v3_TagHold_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.resourcemanager.v3.TagHold getDefaultInstanceForType() {
      return com.google.cloud.resourcemanager.v3.TagHold.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.resourcemanager.v3.TagHold build() {
      com.google.cloud.resourcemanager.v3.TagHold result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.resourcemanager.v3.TagHold buildPartial() {
      com.google.cloud.resourcemanager.v3.TagHold result =
          new com.google.cloud.resourcemanager.v3.TagHold(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.resourcemanager.v3.TagHold result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.holder_ = holder_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.origin_ = origin_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.helpLink_ = helpLink_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.createTime_ = createTimeBuilder_ == null ? createTime_ : createTimeBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.resourcemanager.v3.TagHold) {
        return mergeFrom((com.google.cloud.resourcemanager.v3.TagHold) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.resourcemanager.v3.TagHold other) {
      if (other == com.google.cloud.resourcemanager.v3.TagHold.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getHolder().isEmpty()) {
        holder_ = other.holder_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.getOrigin().isEmpty()) {
        origin_ = other.origin_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (!other.getHelpLink().isEmpty()) {
        helpLink_ = other.helpLink_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                holder_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                origin_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                helpLink_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 42:
              {
                input.readMessage(getCreateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";

    /**
     *
     *
     * <pre>
     * Output only. The resource name of a TagHold. This is a String of the form:
     * `tagValues/{tag-value-id}/tagHolds/{tag-hold-id}`
     * (e.g. `tagValues/123/tagHolds/456`). This resource name is generated by
     * the server.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. The resource name of a TagHold. This is a String of the form:
     * `tagValues/{tag-value-id}/tagHolds/{tag-hold-id}`
     * (e.g. `tagValues/123/tagHolds/456`). This resource name is generated by
     * the server.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. The resource name of a TagHold. This is a String of the form:
     * `tagValues/{tag-value-id}/tagHolds/{tag-hold-id}`
     * (e.g. `tagValues/123/tagHolds/456`). This resource name is generated by
     * the server.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The resource name of a TagHold. This is a String of the form:
     * `tagValues/{tag-value-id}/tagHolds/{tag-hold-id}`
     * (e.g. `tagValues/123/tagHolds/456`). This resource name is generated by
     * the server.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The resource name of a TagHold. This is a String of the form:
     * `tagValues/{tag-value-id}/tagHolds/{tag-hold-id}`
     * (e.g. `tagValues/123/tagHolds/456`). This resource name is generated by
     * the server.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object holder_ = "";

    /**
     *
     *
     * <pre>
     * Required. The name of the resource where the TagValue is being used. Must
     * be less than 200 characters. E.g.
     * `//compute.googleapis.com/compute/projects/myproject/regions/us-east-1/instanceGroupManagers/instance-group`
     * </pre>
     *
     * <code>string holder = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The holder.
     */
    public java.lang.String getHolder() {
      java.lang.Object ref = holder_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        holder_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The name of the resource where the TagValue is being used. Must
     * be less than 200 characters. E.g.
     * `//compute.googleapis.com/compute/projects/myproject/regions/us-east-1/instanceGroupManagers/instance-group`
     * </pre>
     *
     * <code>string holder = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for holder.
     */
    public com.google.protobuf.ByteString getHolderBytes() {
      java.lang.Object ref = holder_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        holder_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The name of the resource where the TagValue is being used. Must
     * be less than 200 characters. E.g.
     * `//compute.googleapis.com/compute/projects/myproject/regions/us-east-1/instanceGroupManagers/instance-group`
     * </pre>
     *
     * <code>string holder = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The holder to set.
     * @return This builder for chaining.
     */
    public Builder setHolder(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      holder_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The name of the resource where the TagValue is being used. Must
     * be less than 200 characters. E.g.
     * `//compute.googleapis.com/compute/projects/myproject/regions/us-east-1/instanceGroupManagers/instance-group`
     * </pre>
     *
     * <code>string holder = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearHolder() {
      holder_ = getDefaultInstance().getHolder();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The name of the resource where the TagValue is being used. Must
     * be less than 200 characters. E.g.
     * `//compute.googleapis.com/compute/projects/myproject/regions/us-east-1/instanceGroupManagers/instance-group`
     * </pre>
     *
     * <code>string holder = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for holder to set.
     * @return This builder for chaining.
     */
    public Builder setHolderBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      holder_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object origin_ = "";

    /**
     *
     *
     * <pre>
     * Optional. An optional string representing the origin of this request. This
     * field should include human-understandable information to distinguish
     * origins from each other. Must be less than 200 characters. E.g.
     * `migs-35678234`
     * </pre>
     *
     * <code>string origin = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The origin.
     */
    public java.lang.String getOrigin() {
      java.lang.Object ref = origin_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        origin_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. An optional string representing the origin of this request. This
     * field should include human-understandable information to distinguish
     * origins from each other. Must be less than 200 characters. E.g.
     * `migs-35678234`
     * </pre>
     *
     * <code>string origin = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for origin.
     */
    public com.google.protobuf.ByteString getOriginBytes() {
      java.lang.Object ref = origin_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        origin_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. An optional string representing the origin of this request. This
     * field should include human-understandable information to distinguish
     * origins from each other. Must be less than 200 characters. E.g.
     * `migs-35678234`
     * </pre>
     *
     * <code>string origin = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The origin to set.
     * @return This builder for chaining.
     */
    public Builder setOrigin(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      origin_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. An optional string representing the origin of this request. This
     * field should include human-understandable information to distinguish
     * origins from each other. Must be less than 200 characters. E.g.
     * `migs-35678234`
     * </pre>
     *
     * <code>string origin = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearOrigin() {
      origin_ = getDefaultInstance().getOrigin();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. An optional string representing the origin of this request. This
     * field should include human-understandable information to distinguish
     * origins from each other. Must be less than 200 characters. E.g.
     * `migs-35678234`
     * </pre>
     *
     * <code>string origin = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for origin to set.
     * @return This builder for chaining.
     */
    public Builder setOriginBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      origin_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private java.lang.Object helpLink_ = "";

    /**
     *
     *
     * <pre>
     * Optional. A URL where an end user can learn more about removing this hold.
     * E.g.
     * `https://cloud.google.com/resource-manager/docs/tags/tags-creating-and-managing`
     * </pre>
     *
     * <code>string help_link = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The helpLink.
     */
    public java.lang.String getHelpLink() {
      java.lang.Object ref = helpLink_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        helpLink_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. A URL where an end user can learn more about removing this hold.
     * E.g.
     * `https://cloud.google.com/resource-manager/docs/tags/tags-creating-and-managing`
     * </pre>
     *
     * <code>string help_link = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for helpLink.
     */
    public com.google.protobuf.ByteString getHelpLinkBytes() {
      java.lang.Object ref = helpLink_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        helpLink_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. A URL where an end user can learn more about removing this hold.
     * E.g.
     * `https://cloud.google.com/resource-manager/docs/tags/tags-creating-and-managing`
     * </pre>
     *
     * <code>string help_link = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The helpLink to set.
     * @return This builder for chaining.
     */
    public Builder setHelpLink(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      helpLink_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. A URL where an end user can learn more about removing this hold.
     * E.g.
     * `https://cloud.google.com/resource-manager/docs/tags/tags-creating-and-managing`
     * </pre>
     *
     * <code>string help_link = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearHelpLink() {
      helpLink_ = getDefaultInstance().getHelpLink();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. A URL where an end user can learn more about removing this hold.
     * E.g.
     * `https://cloud.google.com/resource-manager/docs/tags/tags-creating-and-managing`
     * </pre>
     *
     * <code>string help_link = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for helpLink to set.
     * @return This builder for chaining.
     */
    public Builder setHelpLinkBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      helpLink_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. The time this TagHold was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return ((bitField0_ & 0x00000010) != 0);
    }

    /**
     *
     *
     * <pre>
     * Output only. The time this TagHold was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. The time this TagHold was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
      } else {
        createTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The time this TagHold was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The time this TagHold was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)
            && createTime_ != null
            && createTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getCreateTimeBuilder().mergeFrom(value);
        } else {
          createTime_ = value;
        }
      } else {
        createTimeBuilder_.mergeFrom(value);
      }
      if (createTime_ != null) {
        bitField0_ |= 0x00000010;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The time this TagHold was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearCreateTime() {
      bitField0_ = (bitField0_ & ~0x00000010);
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The time this TagHold was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {
      bitField0_ |= 0x00000010;
      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Output only. The time this TagHold was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. The time this TagHold was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.resourcemanager.v3.TagHold)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.resourcemanager.v3.TagHold)
  private static final com.google.cloud.resourcemanager.v3.TagHold DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.resourcemanager.v3.TagHold();
  }

  public static com.google.cloud.resourcemanager.v3.TagHold getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<TagHold> PARSER =
      new com.google.protobuf.AbstractParser<TagHold>() {
        @java.lang.Override
        public TagHold parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<TagHold> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<TagHold> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.resourcemanager.v3.TagHold getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
