/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/resourcemanager/v3/tag_keys.proto

// Protobuf Java Version: 3.25.8
package com.google.cloud.resourcemanager.v3;

/**
 *
 *
 * <pre>
 * A purpose for each policy engine requiring such an integration. A single
 * policy engine may have multiple purposes defined, however a TagKey may only
 * specify a single purpose.
 * </pre>
 *
 * Protobuf enum {@code google.cloud.resourcemanager.v3.Purpose}
 */
public enum Purpose implements com.google.protobuf.ProtocolMessageEnum {
  /**
   *
   *
   * <pre>
   * Unspecified purpose.
   * </pre>
   *
   * <code>PURPOSE_UNSPECIFIED = 0;</code>
   */
  PURPOSE_UNSPECIFIED(0),
  /**
   *
   *
   * <pre>
   * Purpose for Compute Engine firewalls.
   * A corresponding `purpose_data` should be set for the network the tag is
   * intended for. The key should be `network` and the value should be in
   * either of these two formats:
   *
   * -
   * `https://www.googleapis.com/compute/{compute_version}/projects/{project_id}/global/networks/{network_id}`
   * - `{project_id}/{network_name}`
   *
   * Examples:
   *
   * -
   * `https://www.googleapis.com/compute/staging_v1/projects/fail-closed-load-testing/global/networks/6992953698831725600`
   * - `fail-closed-load-testing/load-testing-network`
   * </pre>
   *
   * <code>GCE_FIREWALL = 1;</code>
   */
  GCE_FIREWALL(1),
  UNRECOGNIZED(-1),
  ;

  /**
   *
   *
   * <pre>
   * Unspecified purpose.
   * </pre>
   *
   * <code>PURPOSE_UNSPECIFIED = 0;</code>
   */
  public static final int PURPOSE_UNSPECIFIED_VALUE = 0;

  /**
   *
   *
   * <pre>
   * Purpose for Compute Engine firewalls.
   * A corresponding `purpose_data` should be set for the network the tag is
   * intended for. The key should be `network` and the value should be in
   * either of these two formats:
   *
   * -
   * `https://www.googleapis.com/compute/{compute_version}/projects/{project_id}/global/networks/{network_id}`
   * - `{project_id}/{network_name}`
   *
   * Examples:
   *
   * -
   * `https://www.googleapis.com/compute/staging_v1/projects/fail-closed-load-testing/global/networks/6992953698831725600`
   * - `fail-closed-load-testing/load-testing-network`
   * </pre>
   *
   * <code>GCE_FIREWALL = 1;</code>
   */
  public static final int GCE_FIREWALL_VALUE = 1;

  public final int getNumber() {
    if (this == UNRECOGNIZED) {
      throw new java.lang.IllegalArgumentException(
          "Can't get the number of an unknown enum value.");
    }
    return value;
  }

  /**
   * @param value The numeric wire value of the corresponding enum entry.
   * @return The enum associated with the given numeric wire value.
   * @deprecated Use {@link #forNumber(int)} instead.
   */
  @java.lang.Deprecated
  public static Purpose valueOf(int value) {
    return forNumber(value);
  }

  /**
   * @param value The numeric wire value of the corresponding enum entry.
   * @return The enum associated with the given numeric wire value.
   */
  public static Purpose forNumber(int value) {
    switch (value) {
      case 0:
        return PURPOSE_UNSPECIFIED;
      case 1:
        return GCE_FIREWALL;
      default:
        return null;
    }
  }

  public static com.google.protobuf.Internal.EnumLiteMap<Purpose> internalGetValueMap() {
    return internalValueMap;
  }

  private static final com.google.protobuf.Internal.EnumLiteMap<Purpose> internalValueMap =
      new com.google.protobuf.Internal.EnumLiteMap<Purpose>() {
        public Purpose findValueByNumber(int number) {
          return Purpose.forNumber(number);
        }
      };

  public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
    if (this == UNRECOGNIZED) {
      throw new java.lang.IllegalStateException(
          "Can't get the descriptor of an unrecognized enum value.");
    }
    return getDescriptor().getValues().get(ordinal());
  }

  public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
    return getDescriptor();
  }

  public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
    return com.google.cloud.resourcemanager.v3.TagKeysProto.getDescriptor().getEnumTypes().get(0);
  }

  private static final Purpose[] VALUES = values();

  public static Purpose valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
    if (desc.getType() != getDescriptor()) {
      throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
    }
    if (desc.getIndex() == -1) {
      return UNRECOGNIZED;
    }
    return VALUES[desc.getIndex()];
  }

  private final int value;

  private Purpose(int value) {
    this.value = value;
  }

  // @@protoc_insertion_point(enum_scope:google.cloud.resourcemanager.v3.Purpose)
}
