/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/firestore/admin/v1/schedule.proto

// Protobuf Java Version: 3.25.8
package com.google.firestore.admin.v1;

/**
 *
 *
 * <pre>
 * A backup schedule for a Cloud Firestore Database.
 *
 * This resource is owned by the database it is backing up, and is deleted along
 * with the database. The actual backups are not though.
 * </pre>
 *
 * Protobuf type {@code google.firestore.admin.v1.BackupSchedule}
 */
public final class BackupSchedule extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.firestore.admin.v1.BackupSchedule)
    BackupScheduleOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use BackupSchedule.newBuilder() to construct.
  private BackupSchedule(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private BackupSchedule() {
    name_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new BackupSchedule();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.firestore.admin.v1.ScheduleProto
        .internal_static_google_firestore_admin_v1_BackupSchedule_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.firestore.admin.v1.ScheduleProto
        .internal_static_google_firestore_admin_v1_BackupSchedule_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.firestore.admin.v1.BackupSchedule.class,
            com.google.firestore.admin.v1.BackupSchedule.Builder.class);
  }

  private int bitField0_;
  private int recurrenceCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object recurrence_;

  public enum RecurrenceCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    DAILY_RECURRENCE(7),
    WEEKLY_RECURRENCE(8),
    RECURRENCE_NOT_SET(0);
    private final int value;

    private RecurrenceCase(int value) {
      this.value = value;
    }

    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static RecurrenceCase valueOf(int value) {
      return forNumber(value);
    }

    public static RecurrenceCase forNumber(int value) {
      switch (value) {
        case 7:
          return DAILY_RECURRENCE;
        case 8:
          return WEEKLY_RECURRENCE;
        case 0:
          return RECURRENCE_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public RecurrenceCase getRecurrenceCase() {
    return RecurrenceCase.forNumber(recurrenceCase_);
  }

  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";

  /**
   *
   *
   * <pre>
   * Output only. The unique backup schedule identifier across all locations and
   * databases for the given project.
   *
   * This will be auto-assigned.
   *
   * Format is
   * `projects/{project}/databases/{database}/backupSchedules/{backup_schedule}`
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Output only. The unique backup schedule identifier across all locations and
   * databases for the given project.
   *
   * This will be auto-assigned.
   *
   * Format is
   * `projects/{project}/databases/{database}/backupSchedules/{backup_schedule}`
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 3;
  private com.google.protobuf.Timestamp createTime_;

  /**
   *
   *
   * <pre>
   * Output only. The timestamp at which this backup schedule was created and
   * effective since.
   *
   * No backups will be created for this schedule before this time.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * Output only. The timestamp at which this backup schedule was created and
   * effective since.
   *
   * No backups will be created for this schedule before this time.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }

  /**
   *
   *
   * <pre>
   * Output only. The timestamp at which this backup schedule was created and
   * effective since.
   *
   * No backups will be created for this schedule before this time.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }

  public static final int UPDATE_TIME_FIELD_NUMBER = 10;
  private com.google.protobuf.Timestamp updateTime_;

  /**
   *
   *
   * <pre>
   * Output only. The timestamp at which this backup schedule was most recently
   * updated. When a backup schedule is first created, this is the same as
   * create_time.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the updateTime field is set.
   */
  @java.lang.Override
  public boolean hasUpdateTime() {
    return ((bitField0_ & 0x00000002) != 0);
  }

  /**
   *
   *
   * <pre>
   * Output only. The timestamp at which this backup schedule was most recently
   * updated. When a backup schedule is first created, this is the same as
   * create_time.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The updateTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getUpdateTime() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }

  /**
   *
   *
   * <pre>
   * Output only. The timestamp at which this backup schedule was most recently
   * updated. When a backup schedule is first created, this is the same as
   * create_time.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }

  public static final int RETENTION_FIELD_NUMBER = 6;
  private com.google.protobuf.Duration retention_;

  /**
   *
   *
   * <pre>
   * At what relative time in the future, compared to its creation time,
   * the backup should be deleted, e.g. keep backups for 7 days.
   *
   * The maximum supported retention period is 14 weeks.
   * </pre>
   *
   * <code>.google.protobuf.Duration retention = 6;</code>
   *
   * @return Whether the retention field is set.
   */
  @java.lang.Override
  public boolean hasRetention() {
    return ((bitField0_ & 0x00000004) != 0);
  }

  /**
   *
   *
   * <pre>
   * At what relative time in the future, compared to its creation time,
   * the backup should be deleted, e.g. keep backups for 7 days.
   *
   * The maximum supported retention period is 14 weeks.
   * </pre>
   *
   * <code>.google.protobuf.Duration retention = 6;</code>
   *
   * @return The retention.
   */
  @java.lang.Override
  public com.google.protobuf.Duration getRetention() {
    return retention_ == null ? com.google.protobuf.Duration.getDefaultInstance() : retention_;
  }

  /**
   *
   *
   * <pre>
   * At what relative time in the future, compared to its creation time,
   * the backup should be deleted, e.g. keep backups for 7 days.
   *
   * The maximum supported retention period is 14 weeks.
   * </pre>
   *
   * <code>.google.protobuf.Duration retention = 6;</code>
   */
  @java.lang.Override
  public com.google.protobuf.DurationOrBuilder getRetentionOrBuilder() {
    return retention_ == null ? com.google.protobuf.Duration.getDefaultInstance() : retention_;
  }

  public static final int DAILY_RECURRENCE_FIELD_NUMBER = 7;

  /**
   *
   *
   * <pre>
   * For a schedule that runs daily.
   * </pre>
   *
   * <code>.google.firestore.admin.v1.DailyRecurrence daily_recurrence = 7;</code>
   *
   * @return Whether the dailyRecurrence field is set.
   */
  @java.lang.Override
  public boolean hasDailyRecurrence() {
    return recurrenceCase_ == 7;
  }

  /**
   *
   *
   * <pre>
   * For a schedule that runs daily.
   * </pre>
   *
   * <code>.google.firestore.admin.v1.DailyRecurrence daily_recurrence = 7;</code>
   *
   * @return The dailyRecurrence.
   */
  @java.lang.Override
  public com.google.firestore.admin.v1.DailyRecurrence getDailyRecurrence() {
    if (recurrenceCase_ == 7) {
      return (com.google.firestore.admin.v1.DailyRecurrence) recurrence_;
    }
    return com.google.firestore.admin.v1.DailyRecurrence.getDefaultInstance();
  }

  /**
   *
   *
   * <pre>
   * For a schedule that runs daily.
   * </pre>
   *
   * <code>.google.firestore.admin.v1.DailyRecurrence daily_recurrence = 7;</code>
   */
  @java.lang.Override
  public com.google.firestore.admin.v1.DailyRecurrenceOrBuilder getDailyRecurrenceOrBuilder() {
    if (recurrenceCase_ == 7) {
      return (com.google.firestore.admin.v1.DailyRecurrence) recurrence_;
    }
    return com.google.firestore.admin.v1.DailyRecurrence.getDefaultInstance();
  }

  public static final int WEEKLY_RECURRENCE_FIELD_NUMBER = 8;

  /**
   *
   *
   * <pre>
   * For a schedule that runs weekly on a specific day.
   * </pre>
   *
   * <code>.google.firestore.admin.v1.WeeklyRecurrence weekly_recurrence = 8;</code>
   *
   * @return Whether the weeklyRecurrence field is set.
   */
  @java.lang.Override
  public boolean hasWeeklyRecurrence() {
    return recurrenceCase_ == 8;
  }

  /**
   *
   *
   * <pre>
   * For a schedule that runs weekly on a specific day.
   * </pre>
   *
   * <code>.google.firestore.admin.v1.WeeklyRecurrence weekly_recurrence = 8;</code>
   *
   * @return The weeklyRecurrence.
   */
  @java.lang.Override
  public com.google.firestore.admin.v1.WeeklyRecurrence getWeeklyRecurrence() {
    if (recurrenceCase_ == 8) {
      return (com.google.firestore.admin.v1.WeeklyRecurrence) recurrence_;
    }
    return com.google.firestore.admin.v1.WeeklyRecurrence.getDefaultInstance();
  }

  /**
   *
   *
   * <pre>
   * For a schedule that runs weekly on a specific day.
   * </pre>
   *
   * <code>.google.firestore.admin.v1.WeeklyRecurrence weekly_recurrence = 8;</code>
   */
  @java.lang.Override
  public com.google.firestore.admin.v1.WeeklyRecurrenceOrBuilder getWeeklyRecurrenceOrBuilder() {
    if (recurrenceCase_ == 8) {
      return (com.google.firestore.admin.v1.WeeklyRecurrence) recurrence_;
    }
    return com.google.firestore.admin.v1.WeeklyRecurrence.getDefaultInstance();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(3, getCreateTime());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(6, getRetention());
    }
    if (recurrenceCase_ == 7) {
      output.writeMessage(7, (com.google.firestore.admin.v1.DailyRecurrence) recurrence_);
    }
    if (recurrenceCase_ == 8) {
      output.writeMessage(8, (com.google.firestore.admin.v1.WeeklyRecurrence) recurrence_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(10, getUpdateTime());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getCreateTime());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, getRetention());
    }
    if (recurrenceCase_ == 7) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              7, (com.google.firestore.admin.v1.DailyRecurrence) recurrence_);
    }
    if (recurrenceCase_ == 8) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              8, (com.google.firestore.admin.v1.WeeklyRecurrence) recurrence_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(10, getUpdateTime());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.firestore.admin.v1.BackupSchedule)) {
      return super.equals(obj);
    }
    com.google.firestore.admin.v1.BackupSchedule other =
        (com.google.firestore.admin.v1.BackupSchedule) obj;

    if (!getName().equals(other.getName())) return false;
    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (hasUpdateTime() != other.hasUpdateTime()) return false;
    if (hasUpdateTime()) {
      if (!getUpdateTime().equals(other.getUpdateTime())) return false;
    }
    if (hasRetention() != other.hasRetention()) return false;
    if (hasRetention()) {
      if (!getRetention().equals(other.getRetention())) return false;
    }
    if (!getRecurrenceCase().equals(other.getRecurrenceCase())) return false;
    switch (recurrenceCase_) {
      case 7:
        if (!getDailyRecurrence().equals(other.getDailyRecurrence())) return false;
        break;
      case 8:
        if (!getWeeklyRecurrence().equals(other.getWeeklyRecurrence())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    if (hasUpdateTime()) {
      hash = (37 * hash) + UPDATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getUpdateTime().hashCode();
    }
    if (hasRetention()) {
      hash = (37 * hash) + RETENTION_FIELD_NUMBER;
      hash = (53 * hash) + getRetention().hashCode();
    }
    switch (recurrenceCase_) {
      case 7:
        hash = (37 * hash) + DAILY_RECURRENCE_FIELD_NUMBER;
        hash = (53 * hash) + getDailyRecurrence().hashCode();
        break;
      case 8:
        hash = (37 * hash) + WEEKLY_RECURRENCE_FIELD_NUMBER;
        hash = (53 * hash) + getWeeklyRecurrence().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.firestore.admin.v1.BackupSchedule parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.firestore.admin.v1.BackupSchedule parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.firestore.admin.v1.BackupSchedule parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.firestore.admin.v1.BackupSchedule parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.firestore.admin.v1.BackupSchedule parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.firestore.admin.v1.BackupSchedule parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.firestore.admin.v1.BackupSchedule parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.firestore.admin.v1.BackupSchedule parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.firestore.admin.v1.BackupSchedule parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.firestore.admin.v1.BackupSchedule parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.firestore.admin.v1.BackupSchedule parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.firestore.admin.v1.BackupSchedule parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.firestore.admin.v1.BackupSchedule prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * A backup schedule for a Cloud Firestore Database.
   *
   * This resource is owned by the database it is backing up, and is deleted along
   * with the database. The actual backups are not though.
   * </pre>
   *
   * Protobuf type {@code google.firestore.admin.v1.BackupSchedule}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.firestore.admin.v1.BackupSchedule)
      com.google.firestore.admin.v1.BackupScheduleOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.firestore.admin.v1.ScheduleProto
          .internal_static_google_firestore_admin_v1_BackupSchedule_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.firestore.admin.v1.ScheduleProto
          .internal_static_google_firestore_admin_v1_BackupSchedule_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.firestore.admin.v1.BackupSchedule.class,
              com.google.firestore.admin.v1.BackupSchedule.Builder.class);
    }

    // Construct using com.google.firestore.admin.v1.BackupSchedule.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getCreateTimeFieldBuilder();
        getUpdateTimeFieldBuilder();
        getRetentionFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      retention_ = null;
      if (retentionBuilder_ != null) {
        retentionBuilder_.dispose();
        retentionBuilder_ = null;
      }
      if (dailyRecurrenceBuilder_ != null) {
        dailyRecurrenceBuilder_.clear();
      }
      if (weeklyRecurrenceBuilder_ != null) {
        weeklyRecurrenceBuilder_.clear();
      }
      recurrenceCase_ = 0;
      recurrence_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.firestore.admin.v1.ScheduleProto
          .internal_static_google_firestore_admin_v1_BackupSchedule_descriptor;
    }

    @java.lang.Override
    public com.google.firestore.admin.v1.BackupSchedule getDefaultInstanceForType() {
      return com.google.firestore.admin.v1.BackupSchedule.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.firestore.admin.v1.BackupSchedule build() {
      com.google.firestore.admin.v1.BackupSchedule result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.firestore.admin.v1.BackupSchedule buildPartial() {
      com.google.firestore.admin.v1.BackupSchedule result =
          new com.google.firestore.admin.v1.BackupSchedule(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.firestore.admin.v1.BackupSchedule result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.createTime_ = createTimeBuilder_ == null ? createTime_ : createTimeBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.updateTime_ = updateTimeBuilder_ == null ? updateTime_ : updateTimeBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.retention_ = retentionBuilder_ == null ? retention_ : retentionBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      result.bitField0_ |= to_bitField0_;
    }

    private void buildPartialOneofs(com.google.firestore.admin.v1.BackupSchedule result) {
      result.recurrenceCase_ = recurrenceCase_;
      result.recurrence_ = this.recurrence_;
      if (recurrenceCase_ == 7 && dailyRecurrenceBuilder_ != null) {
        result.recurrence_ = dailyRecurrenceBuilder_.build();
      }
      if (recurrenceCase_ == 8 && weeklyRecurrenceBuilder_ != null) {
        result.recurrence_ = weeklyRecurrenceBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.firestore.admin.v1.BackupSchedule) {
        return mergeFrom((com.google.firestore.admin.v1.BackupSchedule) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.firestore.admin.v1.BackupSchedule other) {
      if (other == com.google.firestore.admin.v1.BackupSchedule.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      if (other.hasUpdateTime()) {
        mergeUpdateTime(other.getUpdateTime());
      }
      if (other.hasRetention()) {
        mergeRetention(other.getRetention());
      }
      switch (other.getRecurrenceCase()) {
        case DAILY_RECURRENCE:
          {
            mergeDailyRecurrence(other.getDailyRecurrence());
            break;
          }
        case WEEKLY_RECURRENCE:
          {
            mergeWeeklyRecurrence(other.getWeeklyRecurrence());
            break;
          }
        case RECURRENCE_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 26:
              {
                input.readMessage(getCreateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 26
            case 50:
              {
                input.readMessage(getRetentionFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 50
            case 58:
              {
                input.readMessage(getDailyRecurrenceFieldBuilder().getBuilder(), extensionRegistry);
                recurrenceCase_ = 7;
                break;
              } // case 58
            case 66:
              {
                input.readMessage(
                    getWeeklyRecurrenceFieldBuilder().getBuilder(), extensionRegistry);
                recurrenceCase_ = 8;
                break;
              } // case 66
            case 82:
              {
                input.readMessage(getUpdateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 82
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int recurrenceCase_ = 0;
    private java.lang.Object recurrence_;

    public RecurrenceCase getRecurrenceCase() {
      return RecurrenceCase.forNumber(recurrenceCase_);
    }

    public Builder clearRecurrence() {
      recurrenceCase_ = 0;
      recurrence_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";

    /**
     *
     *
     * <pre>
     * Output only. The unique backup schedule identifier across all locations and
     * databases for the given project.
     *
     * This will be auto-assigned.
     *
     * Format is
     * `projects/{project}/databases/{database}/backupSchedules/{backup_schedule}`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. The unique backup schedule identifier across all locations and
     * databases for the given project.
     *
     * This will be auto-assigned.
     *
     * Format is
     * `projects/{project}/databases/{database}/backupSchedules/{backup_schedule}`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. The unique backup schedule identifier across all locations and
     * databases for the given project.
     *
     * This will be auto-assigned.
     *
     * Format is
     * `projects/{project}/databases/{database}/backupSchedules/{backup_schedule}`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The unique backup schedule identifier across all locations and
     * databases for the given project.
     *
     * This will be auto-assigned.
     *
     * Format is
     * `projects/{project}/databases/{database}/backupSchedules/{backup_schedule}`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The unique backup schedule identifier across all locations and
     * databases for the given project.
     *
     * This will be auto-assigned.
     *
     * Format is
     * `projects/{project}/databases/{database}/backupSchedules/{backup_schedule}`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. The timestamp at which this backup schedule was created and
     * effective since.
     *
     * No backups will be created for this schedule before this time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return ((bitField0_ & 0x00000002) != 0);
    }

    /**
     *
     *
     * <pre>
     * Output only. The timestamp at which this backup schedule was created and
     * effective since.
     *
     * No backups will be created for this schedule before this time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. The timestamp at which this backup schedule was created and
     * effective since.
     *
     * No backups will be created for this schedule before this time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
      } else {
        createTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The timestamp at which this backup schedule was created and
     * effective since.
     *
     * No backups will be created for this schedule before this time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The timestamp at which this backup schedule was created and
     * effective since.
     *
     * No backups will be created for this schedule before this time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && createTime_ != null
            && createTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getCreateTimeBuilder().mergeFrom(value);
        } else {
          createTime_ = value;
        }
      } else {
        createTimeBuilder_.mergeFrom(value);
      }
      if (createTime_ != null) {
        bitField0_ |= 0x00000002;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The timestamp at which this backup schedule was created and
     * effective since.
     *
     * No backups will be created for this schedule before this time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearCreateTime() {
      bitField0_ = (bitField0_ & ~0x00000002);
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The timestamp at which this backup schedule was created and
     * effective since.
     *
     * No backups will be created for this schedule before this time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Output only. The timestamp at which this backup schedule was created and
     * effective since.
     *
     * No backups will be created for this schedule before this time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. The timestamp at which this backup schedule was created and
     * effective since.
     *
     * No backups will be created for this schedule before this time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private com.google.protobuf.Timestamp updateTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        updateTimeBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. The timestamp at which this backup schedule was most recently
     * updated. When a backup schedule is first created, this is the same as
     * create_time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the updateTime field is set.
     */
    public boolean hasUpdateTime() {
      return ((bitField0_ & 0x00000004) != 0);
    }

    /**
     *
     *
     * <pre>
     * Output only. The timestamp at which this backup schedule was most recently
     * updated. When a backup schedule is first created, this is the same as
     * create_time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The updateTime.
     */
    public com.google.protobuf.Timestamp getUpdateTime() {
      if (updateTimeBuilder_ == null) {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      } else {
        return updateTimeBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. The timestamp at which this backup schedule was most recently
     * updated. When a backup schedule is first created, this is the same as
     * create_time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        updateTime_ = value;
      } else {
        updateTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The timestamp at which this backup schedule was most recently
     * updated. When a backup schedule is first created, this is the same as
     * create_time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (updateTimeBuilder_ == null) {
        updateTime_ = builderForValue.build();
      } else {
        updateTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The timestamp at which this backup schedule was most recently
     * updated. When a backup schedule is first created, this is the same as
     * create_time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && updateTime_ != null
            && updateTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getUpdateTimeBuilder().mergeFrom(value);
        } else {
          updateTime_ = value;
        }
      } else {
        updateTimeBuilder_.mergeFrom(value);
      }
      if (updateTime_ != null) {
        bitField0_ |= 0x00000004;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The timestamp at which this backup schedule was most recently
     * updated. When a backup schedule is first created, this is the same as
     * create_time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearUpdateTime() {
      bitField0_ = (bitField0_ & ~0x00000004);
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The timestamp at which this backup schedule was most recently
     * updated. When a backup schedule is first created, this is the same as
     * create_time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getUpdateTimeBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getUpdateTimeFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Output only. The timestamp at which this backup schedule was most recently
     * updated. When a backup schedule is first created, this is the same as
     * create_time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
      if (updateTimeBuilder_ != null) {
        return updateTimeBuilder_.getMessageOrBuilder();
      } else {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. The timestamp at which this backup schedule was most recently
     * updated. When a backup schedule is first created, this is the same as
     * create_time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getUpdateTimeFieldBuilder() {
      if (updateTimeBuilder_ == null) {
        updateTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getUpdateTime(), getParentForChildren(), isClean());
        updateTime_ = null;
      }
      return updateTimeBuilder_;
    }

    private com.google.protobuf.Duration retention_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        retentionBuilder_;

    /**
     *
     *
     * <pre>
     * At what relative time in the future, compared to its creation time,
     * the backup should be deleted, e.g. keep backups for 7 days.
     *
     * The maximum supported retention period is 14 weeks.
     * </pre>
     *
     * <code>.google.protobuf.Duration retention = 6;</code>
     *
     * @return Whether the retention field is set.
     */
    public boolean hasRetention() {
      return ((bitField0_ & 0x00000008) != 0);
    }

    /**
     *
     *
     * <pre>
     * At what relative time in the future, compared to its creation time,
     * the backup should be deleted, e.g. keep backups for 7 days.
     *
     * The maximum supported retention period is 14 weeks.
     * </pre>
     *
     * <code>.google.protobuf.Duration retention = 6;</code>
     *
     * @return The retention.
     */
    public com.google.protobuf.Duration getRetention() {
      if (retentionBuilder_ == null) {
        return retention_ == null ? com.google.protobuf.Duration.getDefaultInstance() : retention_;
      } else {
        return retentionBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * At what relative time in the future, compared to its creation time,
     * the backup should be deleted, e.g. keep backups for 7 days.
     *
     * The maximum supported retention period is 14 weeks.
     * </pre>
     *
     * <code>.google.protobuf.Duration retention = 6;</code>
     */
    public Builder setRetention(com.google.protobuf.Duration value) {
      if (retentionBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        retention_ = value;
      } else {
        retentionBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * At what relative time in the future, compared to its creation time,
     * the backup should be deleted, e.g. keep backups for 7 days.
     *
     * The maximum supported retention period is 14 weeks.
     * </pre>
     *
     * <code>.google.protobuf.Duration retention = 6;</code>
     */
    public Builder setRetention(com.google.protobuf.Duration.Builder builderForValue) {
      if (retentionBuilder_ == null) {
        retention_ = builderForValue.build();
      } else {
        retentionBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * At what relative time in the future, compared to its creation time,
     * the backup should be deleted, e.g. keep backups for 7 days.
     *
     * The maximum supported retention period is 14 weeks.
     * </pre>
     *
     * <code>.google.protobuf.Duration retention = 6;</code>
     */
    public Builder mergeRetention(com.google.protobuf.Duration value) {
      if (retentionBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && retention_ != null
            && retention_ != com.google.protobuf.Duration.getDefaultInstance()) {
          getRetentionBuilder().mergeFrom(value);
        } else {
          retention_ = value;
        }
      } else {
        retentionBuilder_.mergeFrom(value);
      }
      if (retention_ != null) {
        bitField0_ |= 0x00000008;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * At what relative time in the future, compared to its creation time,
     * the backup should be deleted, e.g. keep backups for 7 days.
     *
     * The maximum supported retention period is 14 weeks.
     * </pre>
     *
     * <code>.google.protobuf.Duration retention = 6;</code>
     */
    public Builder clearRetention() {
      bitField0_ = (bitField0_ & ~0x00000008);
      retention_ = null;
      if (retentionBuilder_ != null) {
        retentionBuilder_.dispose();
        retentionBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * At what relative time in the future, compared to its creation time,
     * the backup should be deleted, e.g. keep backups for 7 days.
     *
     * The maximum supported retention period is 14 weeks.
     * </pre>
     *
     * <code>.google.protobuf.Duration retention = 6;</code>
     */
    public com.google.protobuf.Duration.Builder getRetentionBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getRetentionFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * At what relative time in the future, compared to its creation time,
     * the backup should be deleted, e.g. keep backups for 7 days.
     *
     * The maximum supported retention period is 14 weeks.
     * </pre>
     *
     * <code>.google.protobuf.Duration retention = 6;</code>
     */
    public com.google.protobuf.DurationOrBuilder getRetentionOrBuilder() {
      if (retentionBuilder_ != null) {
        return retentionBuilder_.getMessageOrBuilder();
      } else {
        return retention_ == null ? com.google.protobuf.Duration.getDefaultInstance() : retention_;
      }
    }

    /**
     *
     *
     * <pre>
     * At what relative time in the future, compared to its creation time,
     * the backup should be deleted, e.g. keep backups for 7 days.
     *
     * The maximum supported retention period is 14 weeks.
     * </pre>
     *
     * <code>.google.protobuf.Duration retention = 6;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        getRetentionFieldBuilder() {
      if (retentionBuilder_ == null) {
        retentionBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Duration,
                com.google.protobuf.Duration.Builder,
                com.google.protobuf.DurationOrBuilder>(
                getRetention(), getParentForChildren(), isClean());
        retention_ = null;
      }
      return retentionBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.firestore.admin.v1.DailyRecurrence,
            com.google.firestore.admin.v1.DailyRecurrence.Builder,
            com.google.firestore.admin.v1.DailyRecurrenceOrBuilder>
        dailyRecurrenceBuilder_;

    /**
     *
     *
     * <pre>
     * For a schedule that runs daily.
     * </pre>
     *
     * <code>.google.firestore.admin.v1.DailyRecurrence daily_recurrence = 7;</code>
     *
     * @return Whether the dailyRecurrence field is set.
     */
    @java.lang.Override
    public boolean hasDailyRecurrence() {
      return recurrenceCase_ == 7;
    }

    /**
     *
     *
     * <pre>
     * For a schedule that runs daily.
     * </pre>
     *
     * <code>.google.firestore.admin.v1.DailyRecurrence daily_recurrence = 7;</code>
     *
     * @return The dailyRecurrence.
     */
    @java.lang.Override
    public com.google.firestore.admin.v1.DailyRecurrence getDailyRecurrence() {
      if (dailyRecurrenceBuilder_ == null) {
        if (recurrenceCase_ == 7) {
          return (com.google.firestore.admin.v1.DailyRecurrence) recurrence_;
        }
        return com.google.firestore.admin.v1.DailyRecurrence.getDefaultInstance();
      } else {
        if (recurrenceCase_ == 7) {
          return dailyRecurrenceBuilder_.getMessage();
        }
        return com.google.firestore.admin.v1.DailyRecurrence.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * For a schedule that runs daily.
     * </pre>
     *
     * <code>.google.firestore.admin.v1.DailyRecurrence daily_recurrence = 7;</code>
     */
    public Builder setDailyRecurrence(com.google.firestore.admin.v1.DailyRecurrence value) {
      if (dailyRecurrenceBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        recurrence_ = value;
        onChanged();
      } else {
        dailyRecurrenceBuilder_.setMessage(value);
      }
      recurrenceCase_ = 7;
      return this;
    }

    /**
     *
     *
     * <pre>
     * For a schedule that runs daily.
     * </pre>
     *
     * <code>.google.firestore.admin.v1.DailyRecurrence daily_recurrence = 7;</code>
     */
    public Builder setDailyRecurrence(
        com.google.firestore.admin.v1.DailyRecurrence.Builder builderForValue) {
      if (dailyRecurrenceBuilder_ == null) {
        recurrence_ = builderForValue.build();
        onChanged();
      } else {
        dailyRecurrenceBuilder_.setMessage(builderForValue.build());
      }
      recurrenceCase_ = 7;
      return this;
    }

    /**
     *
     *
     * <pre>
     * For a schedule that runs daily.
     * </pre>
     *
     * <code>.google.firestore.admin.v1.DailyRecurrence daily_recurrence = 7;</code>
     */
    public Builder mergeDailyRecurrence(com.google.firestore.admin.v1.DailyRecurrence value) {
      if (dailyRecurrenceBuilder_ == null) {
        if (recurrenceCase_ == 7
            && recurrence_ != com.google.firestore.admin.v1.DailyRecurrence.getDefaultInstance()) {
          recurrence_ =
              com.google.firestore.admin.v1.DailyRecurrence.newBuilder(
                      (com.google.firestore.admin.v1.DailyRecurrence) recurrence_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          recurrence_ = value;
        }
        onChanged();
      } else {
        if (recurrenceCase_ == 7) {
          dailyRecurrenceBuilder_.mergeFrom(value);
        } else {
          dailyRecurrenceBuilder_.setMessage(value);
        }
      }
      recurrenceCase_ = 7;
      return this;
    }

    /**
     *
     *
     * <pre>
     * For a schedule that runs daily.
     * </pre>
     *
     * <code>.google.firestore.admin.v1.DailyRecurrence daily_recurrence = 7;</code>
     */
    public Builder clearDailyRecurrence() {
      if (dailyRecurrenceBuilder_ == null) {
        if (recurrenceCase_ == 7) {
          recurrenceCase_ = 0;
          recurrence_ = null;
          onChanged();
        }
      } else {
        if (recurrenceCase_ == 7) {
          recurrenceCase_ = 0;
          recurrence_ = null;
        }
        dailyRecurrenceBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * For a schedule that runs daily.
     * </pre>
     *
     * <code>.google.firestore.admin.v1.DailyRecurrence daily_recurrence = 7;</code>
     */
    public com.google.firestore.admin.v1.DailyRecurrence.Builder getDailyRecurrenceBuilder() {
      return getDailyRecurrenceFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * For a schedule that runs daily.
     * </pre>
     *
     * <code>.google.firestore.admin.v1.DailyRecurrence daily_recurrence = 7;</code>
     */
    @java.lang.Override
    public com.google.firestore.admin.v1.DailyRecurrenceOrBuilder getDailyRecurrenceOrBuilder() {
      if ((recurrenceCase_ == 7) && (dailyRecurrenceBuilder_ != null)) {
        return dailyRecurrenceBuilder_.getMessageOrBuilder();
      } else {
        if (recurrenceCase_ == 7) {
          return (com.google.firestore.admin.v1.DailyRecurrence) recurrence_;
        }
        return com.google.firestore.admin.v1.DailyRecurrence.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * For a schedule that runs daily.
     * </pre>
     *
     * <code>.google.firestore.admin.v1.DailyRecurrence daily_recurrence = 7;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.firestore.admin.v1.DailyRecurrence,
            com.google.firestore.admin.v1.DailyRecurrence.Builder,
            com.google.firestore.admin.v1.DailyRecurrenceOrBuilder>
        getDailyRecurrenceFieldBuilder() {
      if (dailyRecurrenceBuilder_ == null) {
        if (!(recurrenceCase_ == 7)) {
          recurrence_ = com.google.firestore.admin.v1.DailyRecurrence.getDefaultInstance();
        }
        dailyRecurrenceBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.firestore.admin.v1.DailyRecurrence,
                com.google.firestore.admin.v1.DailyRecurrence.Builder,
                com.google.firestore.admin.v1.DailyRecurrenceOrBuilder>(
                (com.google.firestore.admin.v1.DailyRecurrence) recurrence_,
                getParentForChildren(),
                isClean());
        recurrence_ = null;
      }
      recurrenceCase_ = 7;
      onChanged();
      return dailyRecurrenceBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.firestore.admin.v1.WeeklyRecurrence,
            com.google.firestore.admin.v1.WeeklyRecurrence.Builder,
            com.google.firestore.admin.v1.WeeklyRecurrenceOrBuilder>
        weeklyRecurrenceBuilder_;

    /**
     *
     *
     * <pre>
     * For a schedule that runs weekly on a specific day.
     * </pre>
     *
     * <code>.google.firestore.admin.v1.WeeklyRecurrence weekly_recurrence = 8;</code>
     *
     * @return Whether the weeklyRecurrence field is set.
     */
    @java.lang.Override
    public boolean hasWeeklyRecurrence() {
      return recurrenceCase_ == 8;
    }

    /**
     *
     *
     * <pre>
     * For a schedule that runs weekly on a specific day.
     * </pre>
     *
     * <code>.google.firestore.admin.v1.WeeklyRecurrence weekly_recurrence = 8;</code>
     *
     * @return The weeklyRecurrence.
     */
    @java.lang.Override
    public com.google.firestore.admin.v1.WeeklyRecurrence getWeeklyRecurrence() {
      if (weeklyRecurrenceBuilder_ == null) {
        if (recurrenceCase_ == 8) {
          return (com.google.firestore.admin.v1.WeeklyRecurrence) recurrence_;
        }
        return com.google.firestore.admin.v1.WeeklyRecurrence.getDefaultInstance();
      } else {
        if (recurrenceCase_ == 8) {
          return weeklyRecurrenceBuilder_.getMessage();
        }
        return com.google.firestore.admin.v1.WeeklyRecurrence.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * For a schedule that runs weekly on a specific day.
     * </pre>
     *
     * <code>.google.firestore.admin.v1.WeeklyRecurrence weekly_recurrence = 8;</code>
     */
    public Builder setWeeklyRecurrence(com.google.firestore.admin.v1.WeeklyRecurrence value) {
      if (weeklyRecurrenceBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        recurrence_ = value;
        onChanged();
      } else {
        weeklyRecurrenceBuilder_.setMessage(value);
      }
      recurrenceCase_ = 8;
      return this;
    }

    /**
     *
     *
     * <pre>
     * For a schedule that runs weekly on a specific day.
     * </pre>
     *
     * <code>.google.firestore.admin.v1.WeeklyRecurrence weekly_recurrence = 8;</code>
     */
    public Builder setWeeklyRecurrence(
        com.google.firestore.admin.v1.WeeklyRecurrence.Builder builderForValue) {
      if (weeklyRecurrenceBuilder_ == null) {
        recurrence_ = builderForValue.build();
        onChanged();
      } else {
        weeklyRecurrenceBuilder_.setMessage(builderForValue.build());
      }
      recurrenceCase_ = 8;
      return this;
    }

    /**
     *
     *
     * <pre>
     * For a schedule that runs weekly on a specific day.
     * </pre>
     *
     * <code>.google.firestore.admin.v1.WeeklyRecurrence weekly_recurrence = 8;</code>
     */
    public Builder mergeWeeklyRecurrence(com.google.firestore.admin.v1.WeeklyRecurrence value) {
      if (weeklyRecurrenceBuilder_ == null) {
        if (recurrenceCase_ == 8
            && recurrence_ != com.google.firestore.admin.v1.WeeklyRecurrence.getDefaultInstance()) {
          recurrence_ =
              com.google.firestore.admin.v1.WeeklyRecurrence.newBuilder(
                      (com.google.firestore.admin.v1.WeeklyRecurrence) recurrence_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          recurrence_ = value;
        }
        onChanged();
      } else {
        if (recurrenceCase_ == 8) {
          weeklyRecurrenceBuilder_.mergeFrom(value);
        } else {
          weeklyRecurrenceBuilder_.setMessage(value);
        }
      }
      recurrenceCase_ = 8;
      return this;
    }

    /**
     *
     *
     * <pre>
     * For a schedule that runs weekly on a specific day.
     * </pre>
     *
     * <code>.google.firestore.admin.v1.WeeklyRecurrence weekly_recurrence = 8;</code>
     */
    public Builder clearWeeklyRecurrence() {
      if (weeklyRecurrenceBuilder_ == null) {
        if (recurrenceCase_ == 8) {
          recurrenceCase_ = 0;
          recurrence_ = null;
          onChanged();
        }
      } else {
        if (recurrenceCase_ == 8) {
          recurrenceCase_ = 0;
          recurrence_ = null;
        }
        weeklyRecurrenceBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * For a schedule that runs weekly on a specific day.
     * </pre>
     *
     * <code>.google.firestore.admin.v1.WeeklyRecurrence weekly_recurrence = 8;</code>
     */
    public com.google.firestore.admin.v1.WeeklyRecurrence.Builder getWeeklyRecurrenceBuilder() {
      return getWeeklyRecurrenceFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * For a schedule that runs weekly on a specific day.
     * </pre>
     *
     * <code>.google.firestore.admin.v1.WeeklyRecurrence weekly_recurrence = 8;</code>
     */
    @java.lang.Override
    public com.google.firestore.admin.v1.WeeklyRecurrenceOrBuilder getWeeklyRecurrenceOrBuilder() {
      if ((recurrenceCase_ == 8) && (weeklyRecurrenceBuilder_ != null)) {
        return weeklyRecurrenceBuilder_.getMessageOrBuilder();
      } else {
        if (recurrenceCase_ == 8) {
          return (com.google.firestore.admin.v1.WeeklyRecurrence) recurrence_;
        }
        return com.google.firestore.admin.v1.WeeklyRecurrence.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * For a schedule that runs weekly on a specific day.
     * </pre>
     *
     * <code>.google.firestore.admin.v1.WeeklyRecurrence weekly_recurrence = 8;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.firestore.admin.v1.WeeklyRecurrence,
            com.google.firestore.admin.v1.WeeklyRecurrence.Builder,
            com.google.firestore.admin.v1.WeeklyRecurrenceOrBuilder>
        getWeeklyRecurrenceFieldBuilder() {
      if (weeklyRecurrenceBuilder_ == null) {
        if (!(recurrenceCase_ == 8)) {
          recurrence_ = com.google.firestore.admin.v1.WeeklyRecurrence.getDefaultInstance();
        }
        weeklyRecurrenceBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.firestore.admin.v1.WeeklyRecurrence,
                com.google.firestore.admin.v1.WeeklyRecurrence.Builder,
                com.google.firestore.admin.v1.WeeklyRecurrenceOrBuilder>(
                (com.google.firestore.admin.v1.WeeklyRecurrence) recurrence_,
                getParentForChildren(),
                isClean());
        recurrence_ = null;
      }
      recurrenceCase_ = 8;
      onChanged();
      return weeklyRecurrenceBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.firestore.admin.v1.BackupSchedule)
  }

  // @@protoc_insertion_point(class_scope:google.firestore.admin.v1.BackupSchedule)
  private static final com.google.firestore.admin.v1.BackupSchedule DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.firestore.admin.v1.BackupSchedule();
  }

  public static com.google.firestore.admin.v1.BackupSchedule getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<BackupSchedule> PARSER =
      new com.google.protobuf.AbstractParser<BackupSchedule>() {
        @java.lang.Override
        public BackupSchedule parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<BackupSchedule> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<BackupSchedule> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.firestore.admin.v1.BackupSchedule getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
