/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/dataform/v1/dataform.proto

// Protobuf Java Version: 3.25.8
package com.google.cloud.dataform.v1;

/**
 *
 *
 * <pre>
 * Represents a single invocation of a compilation result.
 * </pre>
 *
 * Protobuf type {@code google.cloud.dataform.v1.WorkflowInvocation}
 */
public final class WorkflowInvocation extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.dataform.v1.WorkflowInvocation)
    WorkflowInvocationOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use WorkflowInvocation.newBuilder() to construct.
  private WorkflowInvocation(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private WorkflowInvocation() {
    name_ = "";
    state_ = 0;
    resolvedCompilationResult_ = "";
    internalMetadata_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new WorkflowInvocation();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.dataform.v1.DataformProto
        .internal_static_google_cloud_dataform_v1_WorkflowInvocation_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.dataform.v1.DataformProto
        .internal_static_google_cloud_dataform_v1_WorkflowInvocation_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.dataform.v1.WorkflowInvocation.class,
            com.google.cloud.dataform.v1.WorkflowInvocation.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Represents the current state of a workflow invocation.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.dataform.v1.WorkflowInvocation.State}
   */
  public enum State implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Default value. This value is unused.
     * </pre>
     *
     * <code>STATE_UNSPECIFIED = 0;</code>
     */
    STATE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * The workflow invocation is currently running.
     * </pre>
     *
     * <code>RUNNING = 1;</code>
     */
    RUNNING(1),
    /**
     *
     *
     * <pre>
     * The workflow invocation succeeded. A terminal state.
     * </pre>
     *
     * <code>SUCCEEDED = 2;</code>
     */
    SUCCEEDED(2),
    /**
     *
     *
     * <pre>
     * The workflow invocation was cancelled. A terminal state.
     * </pre>
     *
     * <code>CANCELLED = 3;</code>
     */
    CANCELLED(3),
    /**
     *
     *
     * <pre>
     * The workflow invocation failed. A terminal state.
     * </pre>
     *
     * <code>FAILED = 4;</code>
     */
    FAILED(4),
    /**
     *
     *
     * <pre>
     * The workflow invocation is being cancelled, but some actions are still
     * running.
     * </pre>
     *
     * <code>CANCELING = 5;</code>
     */
    CANCELING(5),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Default value. This value is unused.
     * </pre>
     *
     * <code>STATE_UNSPECIFIED = 0;</code>
     */
    public static final int STATE_UNSPECIFIED_VALUE = 0;

    /**
     *
     *
     * <pre>
     * The workflow invocation is currently running.
     * </pre>
     *
     * <code>RUNNING = 1;</code>
     */
    public static final int RUNNING_VALUE = 1;

    /**
     *
     *
     * <pre>
     * The workflow invocation succeeded. A terminal state.
     * </pre>
     *
     * <code>SUCCEEDED = 2;</code>
     */
    public static final int SUCCEEDED_VALUE = 2;

    /**
     *
     *
     * <pre>
     * The workflow invocation was cancelled. A terminal state.
     * </pre>
     *
     * <code>CANCELLED = 3;</code>
     */
    public static final int CANCELLED_VALUE = 3;

    /**
     *
     *
     * <pre>
     * The workflow invocation failed. A terminal state.
     * </pre>
     *
     * <code>FAILED = 4;</code>
     */
    public static final int FAILED_VALUE = 4;

    /**
     *
     *
     * <pre>
     * The workflow invocation is being cancelled, but some actions are still
     * running.
     * </pre>
     *
     * <code>CANCELING = 5;</code>
     */
    public static final int CANCELING_VALUE = 5;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static State valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static State forNumber(int value) {
      switch (value) {
        case 0:
          return STATE_UNSPECIFIED;
        case 1:
          return RUNNING;
        case 2:
          return SUCCEEDED;
        case 3:
          return CANCELLED;
        case 4:
          return FAILED;
        case 5:
          return CANCELING;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<State> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<State> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<State>() {
          public State findValueByNumber(int number) {
            return State.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.dataform.v1.WorkflowInvocation.getDescriptor().getEnumTypes().get(0);
    }

    private static final State[] VALUES = values();

    public static State valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private State(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.dataform.v1.WorkflowInvocation.State)
  }

  private int bitField0_;
  private int compilationSourceCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object compilationSource_;

  public enum CompilationSourceCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    COMPILATION_RESULT(2),
    WORKFLOW_CONFIG(6),
    COMPILATIONSOURCE_NOT_SET(0);
    private final int value;

    private CompilationSourceCase(int value) {
      this.value = value;
    }

    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static CompilationSourceCase valueOf(int value) {
      return forNumber(value);
    }

    public static CompilationSourceCase forNumber(int value) {
      switch (value) {
        case 2:
          return COMPILATION_RESULT;
        case 6:
          return WORKFLOW_CONFIG;
        case 0:
          return COMPILATIONSOURCE_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public CompilationSourceCase getCompilationSourceCase() {
    return CompilationSourceCase.forNumber(compilationSourceCase_);
  }

  public static final int COMPILATION_RESULT_FIELD_NUMBER = 2;

  /**
   *
   *
   * <pre>
   * Immutable. The name of the compilation result to use for this invocation.
   * Must be in the format
   * `projects/&#42;&#47;locations/&#42;&#47;repositories/&#42;&#47;compilationResults/&#42;`.
   * </pre>
   *
   * <code>
   * string compilation_result = 2 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return Whether the compilationResult field is set.
   */
  public boolean hasCompilationResult() {
    return compilationSourceCase_ == 2;
  }

  /**
   *
   *
   * <pre>
   * Immutable. The name of the compilation result to use for this invocation.
   * Must be in the format
   * `projects/&#42;&#47;locations/&#42;&#47;repositories/&#42;&#47;compilationResults/&#42;`.
   * </pre>
   *
   * <code>
   * string compilation_result = 2 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The compilationResult.
   */
  public java.lang.String getCompilationResult() {
    java.lang.Object ref = "";
    if (compilationSourceCase_ == 2) {
      ref = compilationSource_;
    }
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      if (compilationSourceCase_ == 2) {
        compilationSource_ = s;
      }
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Immutable. The name of the compilation result to use for this invocation.
   * Must be in the format
   * `projects/&#42;&#47;locations/&#42;&#47;repositories/&#42;&#47;compilationResults/&#42;`.
   * </pre>
   *
   * <code>
   * string compilation_result = 2 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for compilationResult.
   */
  public com.google.protobuf.ByteString getCompilationResultBytes() {
    java.lang.Object ref = "";
    if (compilationSourceCase_ == 2) {
      ref = compilationSource_;
    }
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      if (compilationSourceCase_ == 2) {
        compilationSource_ = b;
      }
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int WORKFLOW_CONFIG_FIELD_NUMBER = 6;

  /**
   *
   *
   * <pre>
   * Immutable. The name of the workflow config to invoke. Must be in the
   * format `projects/&#42;&#47;locations/&#42;&#47;repositories/&#42;&#47;workflowConfigs/&#42;`.
   * </pre>
   *
   * <code>
   * string workflow_config = 6 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return Whether the workflowConfig field is set.
   */
  public boolean hasWorkflowConfig() {
    return compilationSourceCase_ == 6;
  }

  /**
   *
   *
   * <pre>
   * Immutable. The name of the workflow config to invoke. Must be in the
   * format `projects/&#42;&#47;locations/&#42;&#47;repositories/&#42;&#47;workflowConfigs/&#42;`.
   * </pre>
   *
   * <code>
   * string workflow_config = 6 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The workflowConfig.
   */
  public java.lang.String getWorkflowConfig() {
    java.lang.Object ref = "";
    if (compilationSourceCase_ == 6) {
      ref = compilationSource_;
    }
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      if (compilationSourceCase_ == 6) {
        compilationSource_ = s;
      }
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Immutable. The name of the workflow config to invoke. Must be in the
   * format `projects/&#42;&#47;locations/&#42;&#47;repositories/&#42;&#47;workflowConfigs/&#42;`.
   * </pre>
   *
   * <code>
   * string workflow_config = 6 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for workflowConfig.
   */
  public com.google.protobuf.ByteString getWorkflowConfigBytes() {
    java.lang.Object ref = "";
    if (compilationSourceCase_ == 6) {
      ref = compilationSource_;
    }
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      if (compilationSourceCase_ == 6) {
        compilationSource_ = b;
      }
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";

  /**
   *
   *
   * <pre>
   * Output only. The workflow invocation's name.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Output only. The workflow invocation's name.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int INVOCATION_CONFIG_FIELD_NUMBER = 3;
  private com.google.cloud.dataform.v1.InvocationConfig invocationConfig_;

  /**
   *
   *
   * <pre>
   * Immutable. If left unset, a default InvocationConfig will be used.
   * </pre>
   *
   * <code>
   * .google.cloud.dataform.v1.InvocationConfig invocation_config = 3 [(.google.api.field_behavior) = IMMUTABLE];
   * </code>
   *
   * @return Whether the invocationConfig field is set.
   */
  @java.lang.Override
  public boolean hasInvocationConfig() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * Immutable. If left unset, a default InvocationConfig will be used.
   * </pre>
   *
   * <code>
   * .google.cloud.dataform.v1.InvocationConfig invocation_config = 3 [(.google.api.field_behavior) = IMMUTABLE];
   * </code>
   *
   * @return The invocationConfig.
   */
  @java.lang.Override
  public com.google.cloud.dataform.v1.InvocationConfig getInvocationConfig() {
    return invocationConfig_ == null
        ? com.google.cloud.dataform.v1.InvocationConfig.getDefaultInstance()
        : invocationConfig_;
  }

  /**
   *
   *
   * <pre>
   * Immutable. If left unset, a default InvocationConfig will be used.
   * </pre>
   *
   * <code>
   * .google.cloud.dataform.v1.InvocationConfig invocation_config = 3 [(.google.api.field_behavior) = IMMUTABLE];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dataform.v1.InvocationConfigOrBuilder getInvocationConfigOrBuilder() {
    return invocationConfig_ == null
        ? com.google.cloud.dataform.v1.InvocationConfig.getDefaultInstance()
        : invocationConfig_;
  }

  public static final int STATE_FIELD_NUMBER = 4;
  private int state_ = 0;

  /**
   *
   *
   * <pre>
   * Output only. This workflow invocation's current state.
   * </pre>
   *
   * <code>
   * .google.cloud.dataform.v1.WorkflowInvocation.State state = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The enum numeric value on the wire for state.
   */
  @java.lang.Override
  public int getStateValue() {
    return state_;
  }

  /**
   *
   *
   * <pre>
   * Output only. This workflow invocation's current state.
   * </pre>
   *
   * <code>
   * .google.cloud.dataform.v1.WorkflowInvocation.State state = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The state.
   */
  @java.lang.Override
  public com.google.cloud.dataform.v1.WorkflowInvocation.State getState() {
    com.google.cloud.dataform.v1.WorkflowInvocation.State result =
        com.google.cloud.dataform.v1.WorkflowInvocation.State.forNumber(state_);
    return result == null
        ? com.google.cloud.dataform.v1.WorkflowInvocation.State.UNRECOGNIZED
        : result;
  }

  public static final int INVOCATION_TIMING_FIELD_NUMBER = 5;
  private com.google.type.Interval invocationTiming_;

  /**
   *
   *
   * <pre>
   * Output only. This workflow invocation's timing details.
   * </pre>
   *
   * <code>.google.type.Interval invocation_timing = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the invocationTiming field is set.
   */
  @java.lang.Override
  public boolean hasInvocationTiming() {
    return ((bitField0_ & 0x00000002) != 0);
  }

  /**
   *
   *
   * <pre>
   * Output only. This workflow invocation's timing details.
   * </pre>
   *
   * <code>.google.type.Interval invocation_timing = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The invocationTiming.
   */
  @java.lang.Override
  public com.google.type.Interval getInvocationTiming() {
    return invocationTiming_ == null
        ? com.google.type.Interval.getDefaultInstance()
        : invocationTiming_;
  }

  /**
   *
   *
   * <pre>
   * Output only. This workflow invocation's timing details.
   * </pre>
   *
   * <code>.google.type.Interval invocation_timing = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.type.IntervalOrBuilder getInvocationTimingOrBuilder() {
    return invocationTiming_ == null
        ? com.google.type.Interval.getDefaultInstance()
        : invocationTiming_;
  }

  public static final int RESOLVED_COMPILATION_RESULT_FIELD_NUMBER = 7;

  @SuppressWarnings("serial")
  private volatile java.lang.Object resolvedCompilationResult_ = "";

  /**
   *
   *
   * <pre>
   * Output only. The resolved compilation result that was used to create this
   * invocation. Will be in the format
   * `projects/&#42;&#47;locations/&#42;&#47;repositories/&#42;&#47;compilationResults/&#42;`.
   * </pre>
   *
   * <code>
   * string resolved_compilation_result = 7 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The resolvedCompilationResult.
   */
  @java.lang.Override
  public java.lang.String getResolvedCompilationResult() {
    java.lang.Object ref = resolvedCompilationResult_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      resolvedCompilationResult_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Output only. The resolved compilation result that was used to create this
   * invocation. Will be in the format
   * `projects/&#42;&#47;locations/&#42;&#47;repositories/&#42;&#47;compilationResults/&#42;`.
   * </pre>
   *
   * <code>
   * string resolved_compilation_result = 7 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for resolvedCompilationResult.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getResolvedCompilationResultBytes() {
    java.lang.Object ref = resolvedCompilationResult_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      resolvedCompilationResult_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DATA_ENCRYPTION_STATE_FIELD_NUMBER = 8;
  private com.google.cloud.dataform.v1.DataEncryptionState dataEncryptionState_;

  /**
   *
   *
   * <pre>
   * Output only. Only set if the repository has a KMS Key.
   * </pre>
   *
   * <code>
   * .google.cloud.dataform.v1.DataEncryptionState data_encryption_state = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the dataEncryptionState field is set.
   */
  @java.lang.Override
  public boolean hasDataEncryptionState() {
    return ((bitField0_ & 0x00000004) != 0);
  }

  /**
   *
   *
   * <pre>
   * Output only. Only set if the repository has a KMS Key.
   * </pre>
   *
   * <code>
   * .google.cloud.dataform.v1.DataEncryptionState data_encryption_state = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The dataEncryptionState.
   */
  @java.lang.Override
  public com.google.cloud.dataform.v1.DataEncryptionState getDataEncryptionState() {
    return dataEncryptionState_ == null
        ? com.google.cloud.dataform.v1.DataEncryptionState.getDefaultInstance()
        : dataEncryptionState_;
  }

  /**
   *
   *
   * <pre>
   * Output only. Only set if the repository has a KMS Key.
   * </pre>
   *
   * <code>
   * .google.cloud.dataform.v1.DataEncryptionState data_encryption_state = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dataform.v1.DataEncryptionStateOrBuilder
      getDataEncryptionStateOrBuilder() {
    return dataEncryptionState_ == null
        ? com.google.cloud.dataform.v1.DataEncryptionState.getDefaultInstance()
        : dataEncryptionState_;
  }

  public static final int INTERNAL_METADATA_FIELD_NUMBER = 9;

  @SuppressWarnings("serial")
  private volatile java.lang.Object internalMetadata_ = "";

  /**
   *
   *
   * <pre>
   * Output only. All the metadata information that is used internally to serve
   * the resource. For example: timestamps, flags, status fields, etc. The
   * format of this field is a JSON string.
   * </pre>
   *
   * <code>optional string internal_metadata = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the internalMetadata field is set.
   */
  @java.lang.Override
  public boolean hasInternalMetadata() {
    return ((bitField0_ & 0x00000008) != 0);
  }

  /**
   *
   *
   * <pre>
   * Output only. All the metadata information that is used internally to serve
   * the resource. For example: timestamps, flags, status fields, etc. The
   * format of this field is a JSON string.
   * </pre>
   *
   * <code>optional string internal_metadata = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The internalMetadata.
   */
  @java.lang.Override
  public java.lang.String getInternalMetadata() {
    java.lang.Object ref = internalMetadata_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      internalMetadata_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Output only. All the metadata information that is used internally to serve
   * the resource. For example: timestamps, flags, status fields, etc. The
   * format of this field is a JSON string.
   * </pre>
   *
   * <code>optional string internal_metadata = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The bytes for internalMetadata.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getInternalMetadataBytes() {
    java.lang.Object ref = internalMetadata_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      internalMetadata_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (compilationSourceCase_ == 2) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, compilationSource_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(3, getInvocationConfig());
    }
    if (state_
        != com.google.cloud.dataform.v1.WorkflowInvocation.State.STATE_UNSPECIFIED.getNumber()) {
      output.writeEnum(4, state_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(5, getInvocationTiming());
    }
    if (compilationSourceCase_ == 6) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, compilationSource_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(resolvedCompilationResult_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 7, resolvedCompilationResult_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(8, getDataEncryptionState());
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 9, internalMetadata_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (compilationSourceCase_ == 2) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, compilationSource_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getInvocationConfig());
    }
    if (state_
        != com.google.cloud.dataform.v1.WorkflowInvocation.State.STATE_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(4, state_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getInvocationTiming());
    }
    if (compilationSourceCase_ == 6) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, compilationSource_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(resolvedCompilationResult_)) {
      size +=
          com.google.protobuf.GeneratedMessageV3.computeStringSize(7, resolvedCompilationResult_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(8, getDataEncryptionState());
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(9, internalMetadata_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.dataform.v1.WorkflowInvocation)) {
      return super.equals(obj);
    }
    com.google.cloud.dataform.v1.WorkflowInvocation other =
        (com.google.cloud.dataform.v1.WorkflowInvocation) obj;

    if (!getName().equals(other.getName())) return false;
    if (hasInvocationConfig() != other.hasInvocationConfig()) return false;
    if (hasInvocationConfig()) {
      if (!getInvocationConfig().equals(other.getInvocationConfig())) return false;
    }
    if (state_ != other.state_) return false;
    if (hasInvocationTiming() != other.hasInvocationTiming()) return false;
    if (hasInvocationTiming()) {
      if (!getInvocationTiming().equals(other.getInvocationTiming())) return false;
    }
    if (!getResolvedCompilationResult().equals(other.getResolvedCompilationResult())) return false;
    if (hasDataEncryptionState() != other.hasDataEncryptionState()) return false;
    if (hasDataEncryptionState()) {
      if (!getDataEncryptionState().equals(other.getDataEncryptionState())) return false;
    }
    if (hasInternalMetadata() != other.hasInternalMetadata()) return false;
    if (hasInternalMetadata()) {
      if (!getInternalMetadata().equals(other.getInternalMetadata())) return false;
    }
    if (!getCompilationSourceCase().equals(other.getCompilationSourceCase())) return false;
    switch (compilationSourceCase_) {
      case 2:
        if (!getCompilationResult().equals(other.getCompilationResult())) return false;
        break;
      case 6:
        if (!getWorkflowConfig().equals(other.getWorkflowConfig())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    if (hasInvocationConfig()) {
      hash = (37 * hash) + INVOCATION_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getInvocationConfig().hashCode();
    }
    hash = (37 * hash) + STATE_FIELD_NUMBER;
    hash = (53 * hash) + state_;
    if (hasInvocationTiming()) {
      hash = (37 * hash) + INVOCATION_TIMING_FIELD_NUMBER;
      hash = (53 * hash) + getInvocationTiming().hashCode();
    }
    hash = (37 * hash) + RESOLVED_COMPILATION_RESULT_FIELD_NUMBER;
    hash = (53 * hash) + getResolvedCompilationResult().hashCode();
    if (hasDataEncryptionState()) {
      hash = (37 * hash) + DATA_ENCRYPTION_STATE_FIELD_NUMBER;
      hash = (53 * hash) + getDataEncryptionState().hashCode();
    }
    if (hasInternalMetadata()) {
      hash = (37 * hash) + INTERNAL_METADATA_FIELD_NUMBER;
      hash = (53 * hash) + getInternalMetadata().hashCode();
    }
    switch (compilationSourceCase_) {
      case 2:
        hash = (37 * hash) + COMPILATION_RESULT_FIELD_NUMBER;
        hash = (53 * hash) + getCompilationResult().hashCode();
        break;
      case 6:
        hash = (37 * hash) + WORKFLOW_CONFIG_FIELD_NUMBER;
        hash = (53 * hash) + getWorkflowConfig().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.dataform.v1.WorkflowInvocation parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dataform.v1.WorkflowInvocation parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dataform.v1.WorkflowInvocation parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dataform.v1.WorkflowInvocation parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dataform.v1.WorkflowInvocation parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dataform.v1.WorkflowInvocation parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dataform.v1.WorkflowInvocation parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dataform.v1.WorkflowInvocation parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dataform.v1.WorkflowInvocation parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.dataform.v1.WorkflowInvocation parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dataform.v1.WorkflowInvocation parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dataform.v1.WorkflowInvocation parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.dataform.v1.WorkflowInvocation prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * Represents a single invocation of a compilation result.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dataform.v1.WorkflowInvocation}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.dataform.v1.WorkflowInvocation)
      com.google.cloud.dataform.v1.WorkflowInvocationOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dataform.v1.DataformProto
          .internal_static_google_cloud_dataform_v1_WorkflowInvocation_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dataform.v1.DataformProto
          .internal_static_google_cloud_dataform_v1_WorkflowInvocation_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dataform.v1.WorkflowInvocation.class,
              com.google.cloud.dataform.v1.WorkflowInvocation.Builder.class);
    }

    // Construct using com.google.cloud.dataform.v1.WorkflowInvocation.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getInvocationConfigFieldBuilder();
        getInvocationTimingFieldBuilder();
        getDataEncryptionStateFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      invocationConfig_ = null;
      if (invocationConfigBuilder_ != null) {
        invocationConfigBuilder_.dispose();
        invocationConfigBuilder_ = null;
      }
      state_ = 0;
      invocationTiming_ = null;
      if (invocationTimingBuilder_ != null) {
        invocationTimingBuilder_.dispose();
        invocationTimingBuilder_ = null;
      }
      resolvedCompilationResult_ = "";
      dataEncryptionState_ = null;
      if (dataEncryptionStateBuilder_ != null) {
        dataEncryptionStateBuilder_.dispose();
        dataEncryptionStateBuilder_ = null;
      }
      internalMetadata_ = "";
      compilationSourceCase_ = 0;
      compilationSource_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.dataform.v1.DataformProto
          .internal_static_google_cloud_dataform_v1_WorkflowInvocation_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.dataform.v1.WorkflowInvocation getDefaultInstanceForType() {
      return com.google.cloud.dataform.v1.WorkflowInvocation.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.dataform.v1.WorkflowInvocation build() {
      com.google.cloud.dataform.v1.WorkflowInvocation result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.dataform.v1.WorkflowInvocation buildPartial() {
      com.google.cloud.dataform.v1.WorkflowInvocation result =
          new com.google.cloud.dataform.v1.WorkflowInvocation(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.dataform.v1.WorkflowInvocation result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.name_ = name_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.invocationConfig_ =
            invocationConfigBuilder_ == null ? invocationConfig_ : invocationConfigBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.state_ = state_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.invocationTiming_ =
            invocationTimingBuilder_ == null ? invocationTiming_ : invocationTimingBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.resolvedCompilationResult_ = resolvedCompilationResult_;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.dataEncryptionState_ =
            dataEncryptionStateBuilder_ == null
                ? dataEncryptionState_
                : dataEncryptionStateBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.internalMetadata_ = internalMetadata_;
        to_bitField0_ |= 0x00000008;
      }
      result.bitField0_ |= to_bitField0_;
    }

    private void buildPartialOneofs(com.google.cloud.dataform.v1.WorkflowInvocation result) {
      result.compilationSourceCase_ = compilationSourceCase_;
      result.compilationSource_ = this.compilationSource_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.dataform.v1.WorkflowInvocation) {
        return mergeFrom((com.google.cloud.dataform.v1.WorkflowInvocation) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.dataform.v1.WorkflowInvocation other) {
      if (other == com.google.cloud.dataform.v1.WorkflowInvocation.getDefaultInstance())
        return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (other.hasInvocationConfig()) {
        mergeInvocationConfig(other.getInvocationConfig());
      }
      if (other.state_ != 0) {
        setStateValue(other.getStateValue());
      }
      if (other.hasInvocationTiming()) {
        mergeInvocationTiming(other.getInvocationTiming());
      }
      if (!other.getResolvedCompilationResult().isEmpty()) {
        resolvedCompilationResult_ = other.resolvedCompilationResult_;
        bitField0_ |= 0x00000040;
        onChanged();
      }
      if (other.hasDataEncryptionState()) {
        mergeDataEncryptionState(other.getDataEncryptionState());
      }
      if (other.hasInternalMetadata()) {
        internalMetadata_ = other.internalMetadata_;
        bitField0_ |= 0x00000100;
        onChanged();
      }
      switch (other.getCompilationSourceCase()) {
        case COMPILATION_RESULT:
          {
            compilationSourceCase_ = 2;
            compilationSource_ = other.compilationSource_;
            onChanged();
            break;
          }
        case WORKFLOW_CONFIG:
          {
            compilationSourceCase_ = 6;
            compilationSource_ = other.compilationSource_;
            onChanged();
            break;
          }
        case COMPILATIONSOURCE_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 10
            case 18:
              {
                java.lang.String s = input.readStringRequireUtf8();
                compilationSourceCase_ = 2;
                compilationSource_ = s;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(
                    getInvocationConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 26
            case 32:
              {
                state_ = input.readEnum();
                bitField0_ |= 0x00000010;
                break;
              } // case 32
            case 42:
              {
                input.readMessage(
                    getInvocationTimingFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000020;
                break;
              } // case 42
            case 50:
              {
                java.lang.String s = input.readStringRequireUtf8();
                compilationSourceCase_ = 6;
                compilationSource_ = s;
                break;
              } // case 50
            case 58:
              {
                resolvedCompilationResult_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000040;
                break;
              } // case 58
            case 66:
              {
                input.readMessage(
                    getDataEncryptionStateFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000080;
                break;
              } // case 66
            case 74:
              {
                internalMetadata_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000100;
                break;
              } // case 74
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int compilationSourceCase_ = 0;
    private java.lang.Object compilationSource_;

    public CompilationSourceCase getCompilationSourceCase() {
      return CompilationSourceCase.forNumber(compilationSourceCase_);
    }

    public Builder clearCompilationSource() {
      compilationSourceCase_ = 0;
      compilationSource_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    /**
     *
     *
     * <pre>
     * Immutable. The name of the compilation result to use for this invocation.
     * Must be in the format
     * `projects/&#42;&#47;locations/&#42;&#47;repositories/&#42;&#47;compilationResults/&#42;`.
     * </pre>
     *
     * <code>
     * string compilation_result = 2 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return Whether the compilationResult field is set.
     */
    @java.lang.Override
    public boolean hasCompilationResult() {
      return compilationSourceCase_ == 2;
    }

    /**
     *
     *
     * <pre>
     * Immutable. The name of the compilation result to use for this invocation.
     * Must be in the format
     * `projects/&#42;&#47;locations/&#42;&#47;repositories/&#42;&#47;compilationResults/&#42;`.
     * </pre>
     *
     * <code>
     * string compilation_result = 2 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The compilationResult.
     */
    @java.lang.Override
    public java.lang.String getCompilationResult() {
      java.lang.Object ref = "";
      if (compilationSourceCase_ == 2) {
        ref = compilationSource_;
      }
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (compilationSourceCase_ == 2) {
          compilationSource_ = s;
        }
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Immutable. The name of the compilation result to use for this invocation.
     * Must be in the format
     * `projects/&#42;&#47;locations/&#42;&#47;repositories/&#42;&#47;compilationResults/&#42;`.
     * </pre>
     *
     * <code>
     * string compilation_result = 2 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for compilationResult.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getCompilationResultBytes() {
      java.lang.Object ref = "";
      if (compilationSourceCase_ == 2) {
        ref = compilationSource_;
      }
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        if (compilationSourceCase_ == 2) {
          compilationSource_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Immutable. The name of the compilation result to use for this invocation.
     * Must be in the format
     * `projects/&#42;&#47;locations/&#42;&#47;repositories/&#42;&#47;compilationResults/&#42;`.
     * </pre>
     *
     * <code>
     * string compilation_result = 2 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The compilationResult to set.
     * @return This builder for chaining.
     */
    public Builder setCompilationResult(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      compilationSourceCase_ = 2;
      compilationSource_ = value;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Immutable. The name of the compilation result to use for this invocation.
     * Must be in the format
     * `projects/&#42;&#47;locations/&#42;&#47;repositories/&#42;&#47;compilationResults/&#42;`.
     * </pre>
     *
     * <code>
     * string compilation_result = 2 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCompilationResult() {
      if (compilationSourceCase_ == 2) {
        compilationSourceCase_ = 0;
        compilationSource_ = null;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Immutable. The name of the compilation result to use for this invocation.
     * Must be in the format
     * `projects/&#42;&#47;locations/&#42;&#47;repositories/&#42;&#47;compilationResults/&#42;`.
     * </pre>
     *
     * <code>
     * string compilation_result = 2 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for compilationResult to set.
     * @return This builder for chaining.
     */
    public Builder setCompilationResultBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      compilationSourceCase_ = 2;
      compilationSource_ = value;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Immutable. The name of the workflow config to invoke. Must be in the
     * format `projects/&#42;&#47;locations/&#42;&#47;repositories/&#42;&#47;workflowConfigs/&#42;`.
     * </pre>
     *
     * <code>
     * string workflow_config = 6 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return Whether the workflowConfig field is set.
     */
    @java.lang.Override
    public boolean hasWorkflowConfig() {
      return compilationSourceCase_ == 6;
    }

    /**
     *
     *
     * <pre>
     * Immutable. The name of the workflow config to invoke. Must be in the
     * format `projects/&#42;&#47;locations/&#42;&#47;repositories/&#42;&#47;workflowConfigs/&#42;`.
     * </pre>
     *
     * <code>
     * string workflow_config = 6 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The workflowConfig.
     */
    @java.lang.Override
    public java.lang.String getWorkflowConfig() {
      java.lang.Object ref = "";
      if (compilationSourceCase_ == 6) {
        ref = compilationSource_;
      }
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (compilationSourceCase_ == 6) {
          compilationSource_ = s;
        }
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Immutable. The name of the workflow config to invoke. Must be in the
     * format `projects/&#42;&#47;locations/&#42;&#47;repositories/&#42;&#47;workflowConfigs/&#42;`.
     * </pre>
     *
     * <code>
     * string workflow_config = 6 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for workflowConfig.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getWorkflowConfigBytes() {
      java.lang.Object ref = "";
      if (compilationSourceCase_ == 6) {
        ref = compilationSource_;
      }
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        if (compilationSourceCase_ == 6) {
          compilationSource_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Immutable. The name of the workflow config to invoke. Must be in the
     * format `projects/&#42;&#47;locations/&#42;&#47;repositories/&#42;&#47;workflowConfigs/&#42;`.
     * </pre>
     *
     * <code>
     * string workflow_config = 6 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The workflowConfig to set.
     * @return This builder for chaining.
     */
    public Builder setWorkflowConfig(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      compilationSourceCase_ = 6;
      compilationSource_ = value;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Immutable. The name of the workflow config to invoke. Must be in the
     * format `projects/&#42;&#47;locations/&#42;&#47;repositories/&#42;&#47;workflowConfigs/&#42;`.
     * </pre>
     *
     * <code>
     * string workflow_config = 6 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearWorkflowConfig() {
      if (compilationSourceCase_ == 6) {
        compilationSourceCase_ = 0;
        compilationSource_ = null;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Immutable. The name of the workflow config to invoke. Must be in the
     * format `projects/&#42;&#47;locations/&#42;&#47;repositories/&#42;&#47;workflowConfigs/&#42;`.
     * </pre>
     *
     * <code>
     * string workflow_config = 6 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for workflowConfig to set.
     * @return This builder for chaining.
     */
    public Builder setWorkflowConfigBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      compilationSourceCase_ = 6;
      compilationSource_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object name_ = "";

    /**
     *
     *
     * <pre>
     * Output only. The workflow invocation's name.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. The workflow invocation's name.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. The workflow invocation's name.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The workflow invocation's name.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The workflow invocation's name.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private com.google.cloud.dataform.v1.InvocationConfig invocationConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dataform.v1.InvocationConfig,
            com.google.cloud.dataform.v1.InvocationConfig.Builder,
            com.google.cloud.dataform.v1.InvocationConfigOrBuilder>
        invocationConfigBuilder_;

    /**
     *
     *
     * <pre>
     * Immutable. If left unset, a default InvocationConfig will be used.
     * </pre>
     *
     * <code>
     * .google.cloud.dataform.v1.InvocationConfig invocation_config = 3 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @return Whether the invocationConfig field is set.
     */
    public boolean hasInvocationConfig() {
      return ((bitField0_ & 0x00000008) != 0);
    }

    /**
     *
     *
     * <pre>
     * Immutable. If left unset, a default InvocationConfig will be used.
     * </pre>
     *
     * <code>
     * .google.cloud.dataform.v1.InvocationConfig invocation_config = 3 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @return The invocationConfig.
     */
    public com.google.cloud.dataform.v1.InvocationConfig getInvocationConfig() {
      if (invocationConfigBuilder_ == null) {
        return invocationConfig_ == null
            ? com.google.cloud.dataform.v1.InvocationConfig.getDefaultInstance()
            : invocationConfig_;
      } else {
        return invocationConfigBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Immutable. If left unset, a default InvocationConfig will be used.
     * </pre>
     *
     * <code>
     * .google.cloud.dataform.v1.InvocationConfig invocation_config = 3 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public Builder setInvocationConfig(com.google.cloud.dataform.v1.InvocationConfig value) {
      if (invocationConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        invocationConfig_ = value;
      } else {
        invocationConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Immutable. If left unset, a default InvocationConfig will be used.
     * </pre>
     *
     * <code>
     * .google.cloud.dataform.v1.InvocationConfig invocation_config = 3 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public Builder setInvocationConfig(
        com.google.cloud.dataform.v1.InvocationConfig.Builder builderForValue) {
      if (invocationConfigBuilder_ == null) {
        invocationConfig_ = builderForValue.build();
      } else {
        invocationConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Immutable. If left unset, a default InvocationConfig will be used.
     * </pre>
     *
     * <code>
     * .google.cloud.dataform.v1.InvocationConfig invocation_config = 3 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public Builder mergeInvocationConfig(com.google.cloud.dataform.v1.InvocationConfig value) {
      if (invocationConfigBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && invocationConfig_ != null
            && invocationConfig_
                != com.google.cloud.dataform.v1.InvocationConfig.getDefaultInstance()) {
          getInvocationConfigBuilder().mergeFrom(value);
        } else {
          invocationConfig_ = value;
        }
      } else {
        invocationConfigBuilder_.mergeFrom(value);
      }
      if (invocationConfig_ != null) {
        bitField0_ |= 0x00000008;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Immutable. If left unset, a default InvocationConfig will be used.
     * </pre>
     *
     * <code>
     * .google.cloud.dataform.v1.InvocationConfig invocation_config = 3 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public Builder clearInvocationConfig() {
      bitField0_ = (bitField0_ & ~0x00000008);
      invocationConfig_ = null;
      if (invocationConfigBuilder_ != null) {
        invocationConfigBuilder_.dispose();
        invocationConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Immutable. If left unset, a default InvocationConfig will be used.
     * </pre>
     *
     * <code>
     * .google.cloud.dataform.v1.InvocationConfig invocation_config = 3 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public com.google.cloud.dataform.v1.InvocationConfig.Builder getInvocationConfigBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getInvocationConfigFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Immutable. If left unset, a default InvocationConfig will be used.
     * </pre>
     *
     * <code>
     * .google.cloud.dataform.v1.InvocationConfig invocation_config = 3 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public com.google.cloud.dataform.v1.InvocationConfigOrBuilder getInvocationConfigOrBuilder() {
      if (invocationConfigBuilder_ != null) {
        return invocationConfigBuilder_.getMessageOrBuilder();
      } else {
        return invocationConfig_ == null
            ? com.google.cloud.dataform.v1.InvocationConfig.getDefaultInstance()
            : invocationConfig_;
      }
    }

    /**
     *
     *
     * <pre>
     * Immutable. If left unset, a default InvocationConfig will be used.
     * </pre>
     *
     * <code>
     * .google.cloud.dataform.v1.InvocationConfig invocation_config = 3 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dataform.v1.InvocationConfig,
            com.google.cloud.dataform.v1.InvocationConfig.Builder,
            com.google.cloud.dataform.v1.InvocationConfigOrBuilder>
        getInvocationConfigFieldBuilder() {
      if (invocationConfigBuilder_ == null) {
        invocationConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dataform.v1.InvocationConfig,
                com.google.cloud.dataform.v1.InvocationConfig.Builder,
                com.google.cloud.dataform.v1.InvocationConfigOrBuilder>(
                getInvocationConfig(), getParentForChildren(), isClean());
        invocationConfig_ = null;
      }
      return invocationConfigBuilder_;
    }

    private int state_ = 0;

    /**
     *
     *
     * <pre>
     * Output only. This workflow invocation's current state.
     * </pre>
     *
     * <code>
     * .google.cloud.dataform.v1.WorkflowInvocation.State state = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for state.
     */
    @java.lang.Override
    public int getStateValue() {
      return state_;
    }

    /**
     *
     *
     * <pre>
     * Output only. This workflow invocation's current state.
     * </pre>
     *
     * <code>
     * .google.cloud.dataform.v1.WorkflowInvocation.State state = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The enum numeric value on the wire for state to set.
     * @return This builder for chaining.
     */
    public Builder setStateValue(int value) {
      state_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. This workflow invocation's current state.
     * </pre>
     *
     * <code>
     * .google.cloud.dataform.v1.WorkflowInvocation.State state = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The state.
     */
    @java.lang.Override
    public com.google.cloud.dataform.v1.WorkflowInvocation.State getState() {
      com.google.cloud.dataform.v1.WorkflowInvocation.State result =
          com.google.cloud.dataform.v1.WorkflowInvocation.State.forNumber(state_);
      return result == null
          ? com.google.cloud.dataform.v1.WorkflowInvocation.State.UNRECOGNIZED
          : result;
    }

    /**
     *
     *
     * <pre>
     * Output only. This workflow invocation's current state.
     * </pre>
     *
     * <code>
     * .google.cloud.dataform.v1.WorkflowInvocation.State state = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The state to set.
     * @return This builder for chaining.
     */
    public Builder setState(com.google.cloud.dataform.v1.WorkflowInvocation.State value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000010;
      state_ = value.getNumber();
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. This workflow invocation's current state.
     * </pre>
     *
     * <code>
     * .google.cloud.dataform.v1.WorkflowInvocation.State state = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearState() {
      bitField0_ = (bitField0_ & ~0x00000010);
      state_ = 0;
      onChanged();
      return this;
    }

    private com.google.type.Interval invocationTiming_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.type.Interval,
            com.google.type.Interval.Builder,
            com.google.type.IntervalOrBuilder>
        invocationTimingBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. This workflow invocation's timing details.
     * </pre>
     *
     * <code>
     * .google.type.Interval invocation_timing = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the invocationTiming field is set.
     */
    public boolean hasInvocationTiming() {
      return ((bitField0_ & 0x00000020) != 0);
    }

    /**
     *
     *
     * <pre>
     * Output only. This workflow invocation's timing details.
     * </pre>
     *
     * <code>
     * .google.type.Interval invocation_timing = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The invocationTiming.
     */
    public com.google.type.Interval getInvocationTiming() {
      if (invocationTimingBuilder_ == null) {
        return invocationTiming_ == null
            ? com.google.type.Interval.getDefaultInstance()
            : invocationTiming_;
      } else {
        return invocationTimingBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. This workflow invocation's timing details.
     * </pre>
     *
     * <code>
     * .google.type.Interval invocation_timing = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setInvocationTiming(com.google.type.Interval value) {
      if (invocationTimingBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        invocationTiming_ = value;
      } else {
        invocationTimingBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. This workflow invocation's timing details.
     * </pre>
     *
     * <code>
     * .google.type.Interval invocation_timing = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setInvocationTiming(com.google.type.Interval.Builder builderForValue) {
      if (invocationTimingBuilder_ == null) {
        invocationTiming_ = builderForValue.build();
      } else {
        invocationTimingBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. This workflow invocation's timing details.
     * </pre>
     *
     * <code>
     * .google.type.Interval invocation_timing = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeInvocationTiming(com.google.type.Interval value) {
      if (invocationTimingBuilder_ == null) {
        if (((bitField0_ & 0x00000020) != 0)
            && invocationTiming_ != null
            && invocationTiming_ != com.google.type.Interval.getDefaultInstance()) {
          getInvocationTimingBuilder().mergeFrom(value);
        } else {
          invocationTiming_ = value;
        }
      } else {
        invocationTimingBuilder_.mergeFrom(value);
      }
      if (invocationTiming_ != null) {
        bitField0_ |= 0x00000020;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. This workflow invocation's timing details.
     * </pre>
     *
     * <code>
     * .google.type.Interval invocation_timing = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearInvocationTiming() {
      bitField0_ = (bitField0_ & ~0x00000020);
      invocationTiming_ = null;
      if (invocationTimingBuilder_ != null) {
        invocationTimingBuilder_.dispose();
        invocationTimingBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. This workflow invocation's timing details.
     * </pre>
     *
     * <code>
     * .google.type.Interval invocation_timing = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.type.Interval.Builder getInvocationTimingBuilder() {
      bitField0_ |= 0x00000020;
      onChanged();
      return getInvocationTimingFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Output only. This workflow invocation's timing details.
     * </pre>
     *
     * <code>
     * .google.type.Interval invocation_timing = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.type.IntervalOrBuilder getInvocationTimingOrBuilder() {
      if (invocationTimingBuilder_ != null) {
        return invocationTimingBuilder_.getMessageOrBuilder();
      } else {
        return invocationTiming_ == null
            ? com.google.type.Interval.getDefaultInstance()
            : invocationTiming_;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. This workflow invocation's timing details.
     * </pre>
     *
     * <code>
     * .google.type.Interval invocation_timing = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.type.Interval,
            com.google.type.Interval.Builder,
            com.google.type.IntervalOrBuilder>
        getInvocationTimingFieldBuilder() {
      if (invocationTimingBuilder_ == null) {
        invocationTimingBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.type.Interval,
                com.google.type.Interval.Builder,
                com.google.type.IntervalOrBuilder>(
                getInvocationTiming(), getParentForChildren(), isClean());
        invocationTiming_ = null;
      }
      return invocationTimingBuilder_;
    }

    private java.lang.Object resolvedCompilationResult_ = "";

    /**
     *
     *
     * <pre>
     * Output only. The resolved compilation result that was used to create this
     * invocation. Will be in the format
     * `projects/&#42;&#47;locations/&#42;&#47;repositories/&#42;&#47;compilationResults/&#42;`.
     * </pre>
     *
     * <code>
     * string resolved_compilation_result = 7 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The resolvedCompilationResult.
     */
    public java.lang.String getResolvedCompilationResult() {
      java.lang.Object ref = resolvedCompilationResult_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        resolvedCompilationResult_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. The resolved compilation result that was used to create this
     * invocation. Will be in the format
     * `projects/&#42;&#47;locations/&#42;&#47;repositories/&#42;&#47;compilationResults/&#42;`.
     * </pre>
     *
     * <code>
     * string resolved_compilation_result = 7 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for resolvedCompilationResult.
     */
    public com.google.protobuf.ByteString getResolvedCompilationResultBytes() {
      java.lang.Object ref = resolvedCompilationResult_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        resolvedCompilationResult_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. The resolved compilation result that was used to create this
     * invocation. Will be in the format
     * `projects/&#42;&#47;locations/&#42;&#47;repositories/&#42;&#47;compilationResults/&#42;`.
     * </pre>
     *
     * <code>
     * string resolved_compilation_result = 7 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The resolvedCompilationResult to set.
     * @return This builder for chaining.
     */
    public Builder setResolvedCompilationResult(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      resolvedCompilationResult_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The resolved compilation result that was used to create this
     * invocation. Will be in the format
     * `projects/&#42;&#47;locations/&#42;&#47;repositories/&#42;&#47;compilationResults/&#42;`.
     * </pre>
     *
     * <code>
     * string resolved_compilation_result = 7 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearResolvedCompilationResult() {
      resolvedCompilationResult_ = getDefaultInstance().getResolvedCompilationResult();
      bitField0_ = (bitField0_ & ~0x00000040);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The resolved compilation result that was used to create this
     * invocation. Will be in the format
     * `projects/&#42;&#47;locations/&#42;&#47;repositories/&#42;&#47;compilationResults/&#42;`.
     * </pre>
     *
     * <code>
     * string resolved_compilation_result = 7 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for resolvedCompilationResult to set.
     * @return This builder for chaining.
     */
    public Builder setResolvedCompilationResultBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      resolvedCompilationResult_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    private com.google.cloud.dataform.v1.DataEncryptionState dataEncryptionState_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dataform.v1.DataEncryptionState,
            com.google.cloud.dataform.v1.DataEncryptionState.Builder,
            com.google.cloud.dataform.v1.DataEncryptionStateOrBuilder>
        dataEncryptionStateBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. Only set if the repository has a KMS Key.
     * </pre>
     *
     * <code>
     * .google.cloud.dataform.v1.DataEncryptionState data_encryption_state = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the dataEncryptionState field is set.
     */
    public boolean hasDataEncryptionState() {
      return ((bitField0_ & 0x00000080) != 0);
    }

    /**
     *
     *
     * <pre>
     * Output only. Only set if the repository has a KMS Key.
     * </pre>
     *
     * <code>
     * .google.cloud.dataform.v1.DataEncryptionState data_encryption_state = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The dataEncryptionState.
     */
    public com.google.cloud.dataform.v1.DataEncryptionState getDataEncryptionState() {
      if (dataEncryptionStateBuilder_ == null) {
        return dataEncryptionState_ == null
            ? com.google.cloud.dataform.v1.DataEncryptionState.getDefaultInstance()
            : dataEncryptionState_;
      } else {
        return dataEncryptionStateBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Only set if the repository has a KMS Key.
     * </pre>
     *
     * <code>
     * .google.cloud.dataform.v1.DataEncryptionState data_encryption_state = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setDataEncryptionState(com.google.cloud.dataform.v1.DataEncryptionState value) {
      if (dataEncryptionStateBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        dataEncryptionState_ = value;
      } else {
        dataEncryptionStateBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Only set if the repository has a KMS Key.
     * </pre>
     *
     * <code>
     * .google.cloud.dataform.v1.DataEncryptionState data_encryption_state = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setDataEncryptionState(
        com.google.cloud.dataform.v1.DataEncryptionState.Builder builderForValue) {
      if (dataEncryptionStateBuilder_ == null) {
        dataEncryptionState_ = builderForValue.build();
      } else {
        dataEncryptionStateBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Only set if the repository has a KMS Key.
     * </pre>
     *
     * <code>
     * .google.cloud.dataform.v1.DataEncryptionState data_encryption_state = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeDataEncryptionState(
        com.google.cloud.dataform.v1.DataEncryptionState value) {
      if (dataEncryptionStateBuilder_ == null) {
        if (((bitField0_ & 0x00000080) != 0)
            && dataEncryptionState_ != null
            && dataEncryptionState_
                != com.google.cloud.dataform.v1.DataEncryptionState.getDefaultInstance()) {
          getDataEncryptionStateBuilder().mergeFrom(value);
        } else {
          dataEncryptionState_ = value;
        }
      } else {
        dataEncryptionStateBuilder_.mergeFrom(value);
      }
      if (dataEncryptionState_ != null) {
        bitField0_ |= 0x00000080;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Only set if the repository has a KMS Key.
     * </pre>
     *
     * <code>
     * .google.cloud.dataform.v1.DataEncryptionState data_encryption_state = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearDataEncryptionState() {
      bitField0_ = (bitField0_ & ~0x00000080);
      dataEncryptionState_ = null;
      if (dataEncryptionStateBuilder_ != null) {
        dataEncryptionStateBuilder_.dispose();
        dataEncryptionStateBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Only set if the repository has a KMS Key.
     * </pre>
     *
     * <code>
     * .google.cloud.dataform.v1.DataEncryptionState data_encryption_state = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.dataform.v1.DataEncryptionState.Builder
        getDataEncryptionStateBuilder() {
      bitField0_ |= 0x00000080;
      onChanged();
      return getDataEncryptionStateFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Output only. Only set if the repository has a KMS Key.
     * </pre>
     *
     * <code>
     * .google.cloud.dataform.v1.DataEncryptionState data_encryption_state = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.dataform.v1.DataEncryptionStateOrBuilder
        getDataEncryptionStateOrBuilder() {
      if (dataEncryptionStateBuilder_ != null) {
        return dataEncryptionStateBuilder_.getMessageOrBuilder();
      } else {
        return dataEncryptionState_ == null
            ? com.google.cloud.dataform.v1.DataEncryptionState.getDefaultInstance()
            : dataEncryptionState_;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Only set if the repository has a KMS Key.
     * </pre>
     *
     * <code>
     * .google.cloud.dataform.v1.DataEncryptionState data_encryption_state = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dataform.v1.DataEncryptionState,
            com.google.cloud.dataform.v1.DataEncryptionState.Builder,
            com.google.cloud.dataform.v1.DataEncryptionStateOrBuilder>
        getDataEncryptionStateFieldBuilder() {
      if (dataEncryptionStateBuilder_ == null) {
        dataEncryptionStateBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dataform.v1.DataEncryptionState,
                com.google.cloud.dataform.v1.DataEncryptionState.Builder,
                com.google.cloud.dataform.v1.DataEncryptionStateOrBuilder>(
                getDataEncryptionState(), getParentForChildren(), isClean());
        dataEncryptionState_ = null;
      }
      return dataEncryptionStateBuilder_;
    }

    private java.lang.Object internalMetadata_ = "";

    /**
     *
     *
     * <pre>
     * Output only. All the metadata information that is used internally to serve
     * the resource. For example: timestamps, flags, status fields, etc. The
     * format of this field is a JSON string.
     * </pre>
     *
     * <code>optional string internal_metadata = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the internalMetadata field is set.
     */
    public boolean hasInternalMetadata() {
      return ((bitField0_ & 0x00000100) != 0);
    }

    /**
     *
     *
     * <pre>
     * Output only. All the metadata information that is used internally to serve
     * the resource. For example: timestamps, flags, status fields, etc. The
     * format of this field is a JSON string.
     * </pre>
     *
     * <code>optional string internal_metadata = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The internalMetadata.
     */
    public java.lang.String getInternalMetadata() {
      java.lang.Object ref = internalMetadata_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        internalMetadata_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. All the metadata information that is used internally to serve
     * the resource. For example: timestamps, flags, status fields, etc. The
     * format of this field is a JSON string.
     * </pre>
     *
     * <code>optional string internal_metadata = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The bytes for internalMetadata.
     */
    public com.google.protobuf.ByteString getInternalMetadataBytes() {
      java.lang.Object ref = internalMetadata_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        internalMetadata_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. All the metadata information that is used internally to serve
     * the resource. For example: timestamps, flags, status fields, etc. The
     * format of this field is a JSON string.
     * </pre>
     *
     * <code>optional string internal_metadata = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The internalMetadata to set.
     * @return This builder for chaining.
     */
    public Builder setInternalMetadata(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      internalMetadata_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. All the metadata information that is used internally to serve
     * the resource. For example: timestamps, flags, status fields, etc. The
     * format of this field is a JSON string.
     * </pre>
     *
     * <code>optional string internal_metadata = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearInternalMetadata() {
      internalMetadata_ = getDefaultInstance().getInternalMetadata();
      bitField0_ = (bitField0_ & ~0x00000100);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. All the metadata information that is used internally to serve
     * the resource. For example: timestamps, flags, status fields, etc. The
     * format of this field is a JSON string.
     * </pre>
     *
     * <code>optional string internal_metadata = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The bytes for internalMetadata to set.
     * @return This builder for chaining.
     */
    public Builder setInternalMetadataBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      internalMetadata_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.dataform.v1.WorkflowInvocation)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.dataform.v1.WorkflowInvocation)
  private static final com.google.cloud.dataform.v1.WorkflowInvocation DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.dataform.v1.WorkflowInvocation();
  }

  public static com.google.cloud.dataform.v1.WorkflowInvocation getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<WorkflowInvocation> PARSER =
      new com.google.protobuf.AbstractParser<WorkflowInvocation>() {
        @java.lang.Override
        public WorkflowInvocation parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<WorkflowInvocation> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<WorkflowInvocation> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.dataform.v1.WorkflowInvocation getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
