/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/dataform/v1/dataform.proto

// Protobuf Java Version: 3.25.8
package com.google.cloud.dataform.v1;

/**
 *
 *
 * <pre>
 * `FetchFileGitStatuses` response message.
 * </pre>
 *
 * Protobuf type {@code google.cloud.dataform.v1.FetchFileGitStatusesResponse}
 */
public final class FetchFileGitStatusesResponse extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.dataform.v1.FetchFileGitStatusesResponse)
    FetchFileGitStatusesResponseOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use FetchFileGitStatusesResponse.newBuilder() to construct.
  private FetchFileGitStatusesResponse(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private FetchFileGitStatusesResponse() {
    uncommittedFileChanges_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new FetchFileGitStatusesResponse();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.dataform.v1.DataformProto
        .internal_static_google_cloud_dataform_v1_FetchFileGitStatusesResponse_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.dataform.v1.DataformProto
        .internal_static_google_cloud_dataform_v1_FetchFileGitStatusesResponse_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.dataform.v1.FetchFileGitStatusesResponse.class,
            com.google.cloud.dataform.v1.FetchFileGitStatusesResponse.Builder.class);
  }

  public interface UncommittedFileChangeOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.dataform.v1.FetchFileGitStatusesResponse.UncommittedFileChange)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The file's full path including filename, relative to the workspace root.
     * </pre>
     *
     * <code>string path = 1;</code>
     *
     * @return The path.
     */
    java.lang.String getPath();

    /**
     *
     *
     * <pre>
     * The file's full path including filename, relative to the workspace root.
     * </pre>
     *
     * <code>string path = 1;</code>
     *
     * @return The bytes for path.
     */
    com.google.protobuf.ByteString getPathBytes();

    /**
     *
     *
     * <pre>
     * Output only. Indicates the status of the file.
     * </pre>
     *
     * <code>
     * .google.cloud.dataform.v1.FetchFileGitStatusesResponse.UncommittedFileChange.State state = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for state.
     */
    int getStateValue();

    /**
     *
     *
     * <pre>
     * Output only. Indicates the status of the file.
     * </pre>
     *
     * <code>
     * .google.cloud.dataform.v1.FetchFileGitStatusesResponse.UncommittedFileChange.State state = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The state.
     */
    com.google.cloud.dataform.v1.FetchFileGitStatusesResponse.UncommittedFileChange.State
        getState();
  }

  /**
   *
   *
   * <pre>
   * Represents the Git state of a file with uncommitted changes.
   * </pre>
   *
   * Protobuf type {@code
   * google.cloud.dataform.v1.FetchFileGitStatusesResponse.UncommittedFileChange}
   */
  public static final class UncommittedFileChange extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.dataform.v1.FetchFileGitStatusesResponse.UncommittedFileChange)
      UncommittedFileChangeOrBuilder {
    private static final long serialVersionUID = 0L;

    // Use UncommittedFileChange.newBuilder() to construct.
    private UncommittedFileChange(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private UncommittedFileChange() {
      path_ = "";
      state_ = 0;
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new UncommittedFileChange();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dataform.v1.DataformProto
          .internal_static_google_cloud_dataform_v1_FetchFileGitStatusesResponse_UncommittedFileChange_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dataform.v1.DataformProto
          .internal_static_google_cloud_dataform_v1_FetchFileGitStatusesResponse_UncommittedFileChange_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dataform.v1.FetchFileGitStatusesResponse.UncommittedFileChange.class,
              com.google.cloud.dataform.v1.FetchFileGitStatusesResponse.UncommittedFileChange
                  .Builder.class);
    }

    /**
     *
     *
     * <pre>
     * Indicates the status of an uncommitted file change.
     * </pre>
     *
     * Protobuf enum {@code
     * google.cloud.dataform.v1.FetchFileGitStatusesResponse.UncommittedFileChange.State}
     */
    public enum State implements com.google.protobuf.ProtocolMessageEnum {
      /**
       *
       *
       * <pre>
       * Default value. This value is unused.
       * </pre>
       *
       * <code>STATE_UNSPECIFIED = 0;</code>
       */
      STATE_UNSPECIFIED(0),
      /**
       *
       *
       * <pre>
       * The file has been newly added.
       * </pre>
       *
       * <code>ADDED = 1;</code>
       */
      ADDED(1),
      /**
       *
       *
       * <pre>
       * The file has been deleted.
       * </pre>
       *
       * <code>DELETED = 2;</code>
       */
      DELETED(2),
      /**
       *
       *
       * <pre>
       * The file has been modified.
       * </pre>
       *
       * <code>MODIFIED = 3;</code>
       */
      MODIFIED(3),
      /**
       *
       *
       * <pre>
       * The file contains merge conflicts.
       * </pre>
       *
       * <code>HAS_CONFLICTS = 4;</code>
       */
      HAS_CONFLICTS(4),
      UNRECOGNIZED(-1),
      ;

      /**
       *
       *
       * <pre>
       * Default value. This value is unused.
       * </pre>
       *
       * <code>STATE_UNSPECIFIED = 0;</code>
       */
      public static final int STATE_UNSPECIFIED_VALUE = 0;

      /**
       *
       *
       * <pre>
       * The file has been newly added.
       * </pre>
       *
       * <code>ADDED = 1;</code>
       */
      public static final int ADDED_VALUE = 1;

      /**
       *
       *
       * <pre>
       * The file has been deleted.
       * </pre>
       *
       * <code>DELETED = 2;</code>
       */
      public static final int DELETED_VALUE = 2;

      /**
       *
       *
       * <pre>
       * The file has been modified.
       * </pre>
       *
       * <code>MODIFIED = 3;</code>
       */
      public static final int MODIFIED_VALUE = 3;

      /**
       *
       *
       * <pre>
       * The file contains merge conflicts.
       * </pre>
       *
       * <code>HAS_CONFLICTS = 4;</code>
       */
      public static final int HAS_CONFLICTS_VALUE = 4;

      public final int getNumber() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalArgumentException(
              "Can't get the number of an unknown enum value.");
        }
        return value;
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static State valueOf(int value) {
        return forNumber(value);
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       */
      public static State forNumber(int value) {
        switch (value) {
          case 0:
            return STATE_UNSPECIFIED;
          case 1:
            return ADDED;
          case 2:
            return DELETED;
          case 3:
            return MODIFIED;
          case 4:
            return HAS_CONFLICTS;
          default:
            return null;
        }
      }

      public static com.google.protobuf.Internal.EnumLiteMap<State> internalGetValueMap() {
        return internalValueMap;
      }

      private static final com.google.protobuf.Internal.EnumLiteMap<State> internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<State>() {
            public State findValueByNumber(int number) {
              return State.forNumber(number);
            }
          };

      public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalStateException(
              "Can't get the descriptor of an unrecognized enum value.");
        }
        return getDescriptor().getValues().get(ordinal());
      }

      public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
        return getDescriptor();
      }

      public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
        return com.google.cloud.dataform.v1.FetchFileGitStatusesResponse.UncommittedFileChange
            .getDescriptor()
            .getEnumTypes()
            .get(0);
      }

      private static final State[] VALUES = values();

      public static State valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
        if (desc.getType() != getDescriptor()) {
          throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
        }
        if (desc.getIndex() == -1) {
          return UNRECOGNIZED;
        }
        return VALUES[desc.getIndex()];
      }

      private final int value;

      private State(int value) {
        this.value = value;
      }

      // @@protoc_insertion_point(enum_scope:google.cloud.dataform.v1.FetchFileGitStatusesResponse.UncommittedFileChange.State)
    }

    public static final int PATH_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object path_ = "";

    /**
     *
     *
     * <pre>
     * The file's full path including filename, relative to the workspace root.
     * </pre>
     *
     * <code>string path = 1;</code>
     *
     * @return The path.
     */
    @java.lang.Override
    public java.lang.String getPath() {
      java.lang.Object ref = path_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        path_ = s;
        return s;
      }
    }

    /**
     *
     *
     * <pre>
     * The file's full path including filename, relative to the workspace root.
     * </pre>
     *
     * <code>string path = 1;</code>
     *
     * @return The bytes for path.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getPathBytes() {
      java.lang.Object ref = path_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        path_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int STATE_FIELD_NUMBER = 2;
    private int state_ = 0;

    /**
     *
     *
     * <pre>
     * Output only. Indicates the status of the file.
     * </pre>
     *
     * <code>
     * .google.cloud.dataform.v1.FetchFileGitStatusesResponse.UncommittedFileChange.State state = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for state.
     */
    @java.lang.Override
    public int getStateValue() {
      return state_;
    }

    /**
     *
     *
     * <pre>
     * Output only. Indicates the status of the file.
     * </pre>
     *
     * <code>
     * .google.cloud.dataform.v1.FetchFileGitStatusesResponse.UncommittedFileChange.State state = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The state.
     */
    @java.lang.Override
    public com.google.cloud.dataform.v1.FetchFileGitStatusesResponse.UncommittedFileChange.State
        getState() {
      com.google.cloud.dataform.v1.FetchFileGitStatusesResponse.UncommittedFileChange.State result =
          com.google.cloud.dataform.v1.FetchFileGitStatusesResponse.UncommittedFileChange.State
              .forNumber(state_);
      return result == null
          ? com.google.cloud.dataform.v1.FetchFileGitStatusesResponse.UncommittedFileChange.State
              .UNRECOGNIZED
          : result;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(path_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, path_);
      }
      if (state_
          != com.google.cloud.dataform.v1.FetchFileGitStatusesResponse.UncommittedFileChange.State
              .STATE_UNSPECIFIED
              .getNumber()) {
        output.writeEnum(2, state_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(path_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, path_);
      }
      if (state_
          != com.google.cloud.dataform.v1.FetchFileGitStatusesResponse.UncommittedFileChange.State
              .STATE_UNSPECIFIED
              .getNumber()) {
        size += com.google.protobuf.CodedOutputStream.computeEnumSize(2, state_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof
          com.google.cloud.dataform.v1.FetchFileGitStatusesResponse.UncommittedFileChange)) {
        return super.equals(obj);
      }
      com.google.cloud.dataform.v1.FetchFileGitStatusesResponse.UncommittedFileChange other =
          (com.google.cloud.dataform.v1.FetchFileGitStatusesResponse.UncommittedFileChange) obj;

      if (!getPath().equals(other.getPath())) return false;
      if (state_ != other.state_) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + PATH_FIELD_NUMBER;
      hash = (53 * hash) + getPath().hashCode();
      hash = (37 * hash) + STATE_FIELD_NUMBER;
      hash = (53 * hash) + state_;
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.dataform.v1.FetchFileGitStatusesResponse.UncommittedFileChange
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dataform.v1.FetchFileGitStatusesResponse.UncommittedFileChange
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dataform.v1.FetchFileGitStatusesResponse.UncommittedFileChange
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dataform.v1.FetchFileGitStatusesResponse.UncommittedFileChange
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dataform.v1.FetchFileGitStatusesResponse.UncommittedFileChange
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dataform.v1.FetchFileGitStatusesResponse.UncommittedFileChange
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dataform.v1.FetchFileGitStatusesResponse.UncommittedFileChange
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dataform.v1.FetchFileGitStatusesResponse.UncommittedFileChange
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dataform.v1.FetchFileGitStatusesResponse.UncommittedFileChange
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.dataform.v1.FetchFileGitStatusesResponse.UncommittedFileChange
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dataform.v1.FetchFileGitStatusesResponse.UncommittedFileChange
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dataform.v1.FetchFileGitStatusesResponse.UncommittedFileChange
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.dataform.v1.FetchFileGitStatusesResponse.UncommittedFileChange prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * Represents the Git state of a file with uncommitted changes.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.dataform.v1.FetchFileGitStatusesResponse.UncommittedFileChange}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.dataform.v1.FetchFileGitStatusesResponse.UncommittedFileChange)
        com.google.cloud.dataform.v1.FetchFileGitStatusesResponse.UncommittedFileChangeOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.dataform.v1.DataformProto
            .internal_static_google_cloud_dataform_v1_FetchFileGitStatusesResponse_UncommittedFileChange_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.dataform.v1.DataformProto
            .internal_static_google_cloud_dataform_v1_FetchFileGitStatusesResponse_UncommittedFileChange_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.dataform.v1.FetchFileGitStatusesResponse.UncommittedFileChange
                    .class,
                com.google.cloud.dataform.v1.FetchFileGitStatusesResponse.UncommittedFileChange
                    .Builder.class);
      }

      // Construct using
      // com.google.cloud.dataform.v1.FetchFileGitStatusesResponse.UncommittedFileChange.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        path_ = "";
        state_ = 0;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.dataform.v1.DataformProto
            .internal_static_google_cloud_dataform_v1_FetchFileGitStatusesResponse_UncommittedFileChange_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.dataform.v1.FetchFileGitStatusesResponse.UncommittedFileChange
          getDefaultInstanceForType() {
        return com.google.cloud.dataform.v1.FetchFileGitStatusesResponse.UncommittedFileChange
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.dataform.v1.FetchFileGitStatusesResponse.UncommittedFileChange
          build() {
        com.google.cloud.dataform.v1.FetchFileGitStatusesResponse.UncommittedFileChange result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.dataform.v1.FetchFileGitStatusesResponse.UncommittedFileChange
          buildPartial() {
        com.google.cloud.dataform.v1.FetchFileGitStatusesResponse.UncommittedFileChange result =
            new com.google.cloud.dataform.v1.FetchFileGitStatusesResponse.UncommittedFileChange(
                this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.dataform.v1.FetchFileGitStatusesResponse.UncommittedFileChange result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.path_ = path_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.state_ = state_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof
            com.google.cloud.dataform.v1.FetchFileGitStatusesResponse.UncommittedFileChange) {
          return mergeFrom(
              (com.google.cloud.dataform.v1.FetchFileGitStatusesResponse.UncommittedFileChange)
                  other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.dataform.v1.FetchFileGitStatusesResponse.UncommittedFileChange other) {
        if (other
            == com.google.cloud.dataform.v1.FetchFileGitStatusesResponse.UncommittedFileChange
                .getDefaultInstance()) return this;
        if (!other.getPath().isEmpty()) {
          path_ = other.path_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (other.state_ != 0) {
          setStateValue(other.getStateValue());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  path_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 16:
                {
                  state_ = input.readEnum();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 16
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object path_ = "";

      /**
       *
       *
       * <pre>
       * The file's full path including filename, relative to the workspace root.
       * </pre>
       *
       * <code>string path = 1;</code>
       *
       * @return The path.
       */
      public java.lang.String getPath() {
        java.lang.Object ref = path_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          path_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * The file's full path including filename, relative to the workspace root.
       * </pre>
       *
       * <code>string path = 1;</code>
       *
       * @return The bytes for path.
       */
      public com.google.protobuf.ByteString getPathBytes() {
        java.lang.Object ref = path_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          path_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * The file's full path including filename, relative to the workspace root.
       * </pre>
       *
       * <code>string path = 1;</code>
       *
       * @param value The path to set.
       * @return This builder for chaining.
       */
      public Builder setPath(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        path_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The file's full path including filename, relative to the workspace root.
       * </pre>
       *
       * <code>string path = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearPath() {
        path_ = getDefaultInstance().getPath();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The file's full path including filename, relative to the workspace root.
       * </pre>
       *
       * <code>string path = 1;</code>
       *
       * @param value The bytes for path to set.
       * @return This builder for chaining.
       */
      public Builder setPathBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        path_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private int state_ = 0;

      /**
       *
       *
       * <pre>
       * Output only. Indicates the status of the file.
       * </pre>
       *
       * <code>
       * .google.cloud.dataform.v1.FetchFileGitStatusesResponse.UncommittedFileChange.State state = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return The enum numeric value on the wire for state.
       */
      @java.lang.Override
      public int getStateValue() {
        return state_;
      }

      /**
       *
       *
       * <pre>
       * Output only. Indicates the status of the file.
       * </pre>
       *
       * <code>
       * .google.cloud.dataform.v1.FetchFileGitStatusesResponse.UncommittedFileChange.State state = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @param value The enum numeric value on the wire for state to set.
       * @return This builder for chaining.
       */
      public Builder setStateValue(int value) {
        state_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Output only. Indicates the status of the file.
       * </pre>
       *
       * <code>
       * .google.cloud.dataform.v1.FetchFileGitStatusesResponse.UncommittedFileChange.State state = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return The state.
       */
      @java.lang.Override
      public com.google.cloud.dataform.v1.FetchFileGitStatusesResponse.UncommittedFileChange.State
          getState() {
        com.google.cloud.dataform.v1.FetchFileGitStatusesResponse.UncommittedFileChange.State
            result =
                com.google.cloud.dataform.v1.FetchFileGitStatusesResponse.UncommittedFileChange
                    .State.forNumber(state_);
        return result == null
            ? com.google.cloud.dataform.v1.FetchFileGitStatusesResponse.UncommittedFileChange.State
                .UNRECOGNIZED
            : result;
      }

      /**
       *
       *
       * <pre>
       * Output only. Indicates the status of the file.
       * </pre>
       *
       * <code>
       * .google.cloud.dataform.v1.FetchFileGitStatusesResponse.UncommittedFileChange.State state = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @param value The state to set.
       * @return This builder for chaining.
       */
      public Builder setState(
          com.google.cloud.dataform.v1.FetchFileGitStatusesResponse.UncommittedFileChange.State
              value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000002;
        state_ = value.getNumber();
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Output only. Indicates the status of the file.
       * </pre>
       *
       * <code>
       * .google.cloud.dataform.v1.FetchFileGitStatusesResponse.UncommittedFileChange.State state = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearState() {
        bitField0_ = (bitField0_ & ~0x00000002);
        state_ = 0;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.dataform.v1.FetchFileGitStatusesResponse.UncommittedFileChange)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.dataform.v1.FetchFileGitStatusesResponse.UncommittedFileChange)
    private static final com.google.cloud.dataform.v1.FetchFileGitStatusesResponse
            .UncommittedFileChange
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.dataform.v1.FetchFileGitStatusesResponse.UncommittedFileChange();
    }

    public static com.google.cloud.dataform.v1.FetchFileGitStatusesResponse.UncommittedFileChange
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<UncommittedFileChange> PARSER =
        new com.google.protobuf.AbstractParser<UncommittedFileChange>() {
          @java.lang.Override
          public UncommittedFileChange parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<UncommittedFileChange> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<UncommittedFileChange> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.dataform.v1.FetchFileGitStatusesResponse.UncommittedFileChange
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public static final int UNCOMMITTED_FILE_CHANGES_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private java.util.List<
          com.google.cloud.dataform.v1.FetchFileGitStatusesResponse.UncommittedFileChange>
      uncommittedFileChanges_;

  /**
   *
   *
   * <pre>
   * A list of all files which have uncommitted Git changes. There will only be
   * a single entry for any given file.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dataform.v1.FetchFileGitStatusesResponse.UncommittedFileChange uncommitted_file_changes = 1;
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          com.google.cloud.dataform.v1.FetchFileGitStatusesResponse.UncommittedFileChange>
      getUncommittedFileChangesList() {
    return uncommittedFileChanges_;
  }

  /**
   *
   *
   * <pre>
   * A list of all files which have uncommitted Git changes. There will only be
   * a single entry for any given file.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dataform.v1.FetchFileGitStatusesResponse.UncommittedFileChange uncommitted_file_changes = 1;
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends
              com.google.cloud.dataform.v1.FetchFileGitStatusesResponse
                  .UncommittedFileChangeOrBuilder>
      getUncommittedFileChangesOrBuilderList() {
    return uncommittedFileChanges_;
  }

  /**
   *
   *
   * <pre>
   * A list of all files which have uncommitted Git changes. There will only be
   * a single entry for any given file.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dataform.v1.FetchFileGitStatusesResponse.UncommittedFileChange uncommitted_file_changes = 1;
   * </code>
   */
  @java.lang.Override
  public int getUncommittedFileChangesCount() {
    return uncommittedFileChanges_.size();
  }

  /**
   *
   *
   * <pre>
   * A list of all files which have uncommitted Git changes. There will only be
   * a single entry for any given file.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dataform.v1.FetchFileGitStatusesResponse.UncommittedFileChange uncommitted_file_changes = 1;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dataform.v1.FetchFileGitStatusesResponse.UncommittedFileChange
      getUncommittedFileChanges(int index) {
    return uncommittedFileChanges_.get(index);
  }

  /**
   *
   *
   * <pre>
   * A list of all files which have uncommitted Git changes. There will only be
   * a single entry for any given file.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dataform.v1.FetchFileGitStatusesResponse.UncommittedFileChange uncommitted_file_changes = 1;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dataform.v1.FetchFileGitStatusesResponse.UncommittedFileChangeOrBuilder
      getUncommittedFileChangesOrBuilder(int index) {
    return uncommittedFileChanges_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    for (int i = 0; i < uncommittedFileChanges_.size(); i++) {
      output.writeMessage(1, uncommittedFileChanges_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    for (int i = 0; i < uncommittedFileChanges_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              1, uncommittedFileChanges_.get(i));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.dataform.v1.FetchFileGitStatusesResponse)) {
      return super.equals(obj);
    }
    com.google.cloud.dataform.v1.FetchFileGitStatusesResponse other =
        (com.google.cloud.dataform.v1.FetchFileGitStatusesResponse) obj;

    if (!getUncommittedFileChangesList().equals(other.getUncommittedFileChangesList()))
      return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getUncommittedFileChangesCount() > 0) {
      hash = (37 * hash) + UNCOMMITTED_FILE_CHANGES_FIELD_NUMBER;
      hash = (53 * hash) + getUncommittedFileChangesList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.dataform.v1.FetchFileGitStatusesResponse parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dataform.v1.FetchFileGitStatusesResponse parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dataform.v1.FetchFileGitStatusesResponse parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dataform.v1.FetchFileGitStatusesResponse parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dataform.v1.FetchFileGitStatusesResponse parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dataform.v1.FetchFileGitStatusesResponse parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dataform.v1.FetchFileGitStatusesResponse parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dataform.v1.FetchFileGitStatusesResponse parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dataform.v1.FetchFileGitStatusesResponse parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.dataform.v1.FetchFileGitStatusesResponse parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dataform.v1.FetchFileGitStatusesResponse parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dataform.v1.FetchFileGitStatusesResponse parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.dataform.v1.FetchFileGitStatusesResponse prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * `FetchFileGitStatuses` response message.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dataform.v1.FetchFileGitStatusesResponse}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.dataform.v1.FetchFileGitStatusesResponse)
      com.google.cloud.dataform.v1.FetchFileGitStatusesResponseOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dataform.v1.DataformProto
          .internal_static_google_cloud_dataform_v1_FetchFileGitStatusesResponse_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dataform.v1.DataformProto
          .internal_static_google_cloud_dataform_v1_FetchFileGitStatusesResponse_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dataform.v1.FetchFileGitStatusesResponse.class,
              com.google.cloud.dataform.v1.FetchFileGitStatusesResponse.Builder.class);
    }

    // Construct using com.google.cloud.dataform.v1.FetchFileGitStatusesResponse.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (uncommittedFileChangesBuilder_ == null) {
        uncommittedFileChanges_ = java.util.Collections.emptyList();
      } else {
        uncommittedFileChanges_ = null;
        uncommittedFileChangesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000001);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.dataform.v1.DataformProto
          .internal_static_google_cloud_dataform_v1_FetchFileGitStatusesResponse_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.dataform.v1.FetchFileGitStatusesResponse getDefaultInstanceForType() {
      return com.google.cloud.dataform.v1.FetchFileGitStatusesResponse.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.dataform.v1.FetchFileGitStatusesResponse build() {
      com.google.cloud.dataform.v1.FetchFileGitStatusesResponse result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.dataform.v1.FetchFileGitStatusesResponse buildPartial() {
      com.google.cloud.dataform.v1.FetchFileGitStatusesResponse result =
          new com.google.cloud.dataform.v1.FetchFileGitStatusesResponse(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.dataform.v1.FetchFileGitStatusesResponse result) {
      if (uncommittedFileChangesBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          uncommittedFileChanges_ = java.util.Collections.unmodifiableList(uncommittedFileChanges_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.uncommittedFileChanges_ = uncommittedFileChanges_;
      } else {
        result.uncommittedFileChanges_ = uncommittedFileChangesBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.dataform.v1.FetchFileGitStatusesResponse result) {
      int from_bitField0_ = bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.dataform.v1.FetchFileGitStatusesResponse) {
        return mergeFrom((com.google.cloud.dataform.v1.FetchFileGitStatusesResponse) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.dataform.v1.FetchFileGitStatusesResponse other) {
      if (other == com.google.cloud.dataform.v1.FetchFileGitStatusesResponse.getDefaultInstance())
        return this;
      if (uncommittedFileChangesBuilder_ == null) {
        if (!other.uncommittedFileChanges_.isEmpty()) {
          if (uncommittedFileChanges_.isEmpty()) {
            uncommittedFileChanges_ = other.uncommittedFileChanges_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureUncommittedFileChangesIsMutable();
            uncommittedFileChanges_.addAll(other.uncommittedFileChanges_);
          }
          onChanged();
        }
      } else {
        if (!other.uncommittedFileChanges_.isEmpty()) {
          if (uncommittedFileChangesBuilder_.isEmpty()) {
            uncommittedFileChangesBuilder_.dispose();
            uncommittedFileChangesBuilder_ = null;
            uncommittedFileChanges_ = other.uncommittedFileChanges_;
            bitField0_ = (bitField0_ & ~0x00000001);
            uncommittedFileChangesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getUncommittedFileChangesFieldBuilder()
                    : null;
          } else {
            uncommittedFileChangesBuilder_.addAllMessages(other.uncommittedFileChanges_);
          }
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                com.google.cloud.dataform.v1.FetchFileGitStatusesResponse.UncommittedFileChange m =
                    input.readMessage(
                        com.google.cloud.dataform.v1.FetchFileGitStatusesResponse
                            .UncommittedFileChange.parser(),
                        extensionRegistry);
                if (uncommittedFileChangesBuilder_ == null) {
                  ensureUncommittedFileChangesIsMutable();
                  uncommittedFileChanges_.add(m);
                } else {
                  uncommittedFileChangesBuilder_.addMessage(m);
                }
                break;
              } // case 10
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.util.List<
            com.google.cloud.dataform.v1.FetchFileGitStatusesResponse.UncommittedFileChange>
        uncommittedFileChanges_ = java.util.Collections.emptyList();

    private void ensureUncommittedFileChangesIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        uncommittedFileChanges_ =
            new java.util.ArrayList<
                com.google.cloud.dataform.v1.FetchFileGitStatusesResponse.UncommittedFileChange>(
                uncommittedFileChanges_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.dataform.v1.FetchFileGitStatusesResponse.UncommittedFileChange,
            com.google.cloud.dataform.v1.FetchFileGitStatusesResponse.UncommittedFileChange.Builder,
            com.google.cloud.dataform.v1.FetchFileGitStatusesResponse
                .UncommittedFileChangeOrBuilder>
        uncommittedFileChangesBuilder_;

    /**
     *
     *
     * <pre>
     * A list of all files which have uncommitted Git changes. There will only be
     * a single entry for any given file.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataform.v1.FetchFileGitStatusesResponse.UncommittedFileChange uncommitted_file_changes = 1;
     * </code>
     */
    public java.util.List<
            com.google.cloud.dataform.v1.FetchFileGitStatusesResponse.UncommittedFileChange>
        getUncommittedFileChangesList() {
      if (uncommittedFileChangesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(uncommittedFileChanges_);
      } else {
        return uncommittedFileChangesBuilder_.getMessageList();
      }
    }

    /**
     *
     *
     * <pre>
     * A list of all files which have uncommitted Git changes. There will only be
     * a single entry for any given file.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataform.v1.FetchFileGitStatusesResponse.UncommittedFileChange uncommitted_file_changes = 1;
     * </code>
     */
    public int getUncommittedFileChangesCount() {
      if (uncommittedFileChangesBuilder_ == null) {
        return uncommittedFileChanges_.size();
      } else {
        return uncommittedFileChangesBuilder_.getCount();
      }
    }

    /**
     *
     *
     * <pre>
     * A list of all files which have uncommitted Git changes. There will only be
     * a single entry for any given file.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataform.v1.FetchFileGitStatusesResponse.UncommittedFileChange uncommitted_file_changes = 1;
     * </code>
     */
    public com.google.cloud.dataform.v1.FetchFileGitStatusesResponse.UncommittedFileChange
        getUncommittedFileChanges(int index) {
      if (uncommittedFileChangesBuilder_ == null) {
        return uncommittedFileChanges_.get(index);
      } else {
        return uncommittedFileChangesBuilder_.getMessage(index);
      }
    }

    /**
     *
     *
     * <pre>
     * A list of all files which have uncommitted Git changes. There will only be
     * a single entry for any given file.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataform.v1.FetchFileGitStatusesResponse.UncommittedFileChange uncommitted_file_changes = 1;
     * </code>
     */
    public Builder setUncommittedFileChanges(
        int index,
        com.google.cloud.dataform.v1.FetchFileGitStatusesResponse.UncommittedFileChange value) {
      if (uncommittedFileChangesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureUncommittedFileChangesIsMutable();
        uncommittedFileChanges_.set(index, value);
        onChanged();
      } else {
        uncommittedFileChangesBuilder_.setMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * A list of all files which have uncommitted Git changes. There will only be
     * a single entry for any given file.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataform.v1.FetchFileGitStatusesResponse.UncommittedFileChange uncommitted_file_changes = 1;
     * </code>
     */
    public Builder setUncommittedFileChanges(
        int index,
        com.google.cloud.dataform.v1.FetchFileGitStatusesResponse.UncommittedFileChange.Builder
            builderForValue) {
      if (uncommittedFileChangesBuilder_ == null) {
        ensureUncommittedFileChangesIsMutable();
        uncommittedFileChanges_.set(index, builderForValue.build());
        onChanged();
      } else {
        uncommittedFileChangesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * A list of all files which have uncommitted Git changes. There will only be
     * a single entry for any given file.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataform.v1.FetchFileGitStatusesResponse.UncommittedFileChange uncommitted_file_changes = 1;
     * </code>
     */
    public Builder addUncommittedFileChanges(
        com.google.cloud.dataform.v1.FetchFileGitStatusesResponse.UncommittedFileChange value) {
      if (uncommittedFileChangesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureUncommittedFileChangesIsMutable();
        uncommittedFileChanges_.add(value);
        onChanged();
      } else {
        uncommittedFileChangesBuilder_.addMessage(value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * A list of all files which have uncommitted Git changes. There will only be
     * a single entry for any given file.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataform.v1.FetchFileGitStatusesResponse.UncommittedFileChange uncommitted_file_changes = 1;
     * </code>
     */
    public Builder addUncommittedFileChanges(
        int index,
        com.google.cloud.dataform.v1.FetchFileGitStatusesResponse.UncommittedFileChange value) {
      if (uncommittedFileChangesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureUncommittedFileChangesIsMutable();
        uncommittedFileChanges_.add(index, value);
        onChanged();
      } else {
        uncommittedFileChangesBuilder_.addMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * A list of all files which have uncommitted Git changes. There will only be
     * a single entry for any given file.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataform.v1.FetchFileGitStatusesResponse.UncommittedFileChange uncommitted_file_changes = 1;
     * </code>
     */
    public Builder addUncommittedFileChanges(
        com.google.cloud.dataform.v1.FetchFileGitStatusesResponse.UncommittedFileChange.Builder
            builderForValue) {
      if (uncommittedFileChangesBuilder_ == null) {
        ensureUncommittedFileChangesIsMutable();
        uncommittedFileChanges_.add(builderForValue.build());
        onChanged();
      } else {
        uncommittedFileChangesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * A list of all files which have uncommitted Git changes. There will only be
     * a single entry for any given file.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataform.v1.FetchFileGitStatusesResponse.UncommittedFileChange uncommitted_file_changes = 1;
     * </code>
     */
    public Builder addUncommittedFileChanges(
        int index,
        com.google.cloud.dataform.v1.FetchFileGitStatusesResponse.UncommittedFileChange.Builder
            builderForValue) {
      if (uncommittedFileChangesBuilder_ == null) {
        ensureUncommittedFileChangesIsMutable();
        uncommittedFileChanges_.add(index, builderForValue.build());
        onChanged();
      } else {
        uncommittedFileChangesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * A list of all files which have uncommitted Git changes. There will only be
     * a single entry for any given file.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataform.v1.FetchFileGitStatusesResponse.UncommittedFileChange uncommitted_file_changes = 1;
     * </code>
     */
    public Builder addAllUncommittedFileChanges(
        java.lang.Iterable<
                ? extends
                    com.google.cloud.dataform.v1.FetchFileGitStatusesResponse.UncommittedFileChange>
            values) {
      if (uncommittedFileChangesBuilder_ == null) {
        ensureUncommittedFileChangesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, uncommittedFileChanges_);
        onChanged();
      } else {
        uncommittedFileChangesBuilder_.addAllMessages(values);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * A list of all files which have uncommitted Git changes. There will only be
     * a single entry for any given file.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataform.v1.FetchFileGitStatusesResponse.UncommittedFileChange uncommitted_file_changes = 1;
     * </code>
     */
    public Builder clearUncommittedFileChanges() {
      if (uncommittedFileChangesBuilder_ == null) {
        uncommittedFileChanges_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        uncommittedFileChangesBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * A list of all files which have uncommitted Git changes. There will only be
     * a single entry for any given file.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataform.v1.FetchFileGitStatusesResponse.UncommittedFileChange uncommitted_file_changes = 1;
     * </code>
     */
    public Builder removeUncommittedFileChanges(int index) {
      if (uncommittedFileChangesBuilder_ == null) {
        ensureUncommittedFileChangesIsMutable();
        uncommittedFileChanges_.remove(index);
        onChanged();
      } else {
        uncommittedFileChangesBuilder_.remove(index);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * A list of all files which have uncommitted Git changes. There will only be
     * a single entry for any given file.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataform.v1.FetchFileGitStatusesResponse.UncommittedFileChange uncommitted_file_changes = 1;
     * </code>
     */
    public com.google.cloud.dataform.v1.FetchFileGitStatusesResponse.UncommittedFileChange.Builder
        getUncommittedFileChangesBuilder(int index) {
      return getUncommittedFileChangesFieldBuilder().getBuilder(index);
    }

    /**
     *
     *
     * <pre>
     * A list of all files which have uncommitted Git changes. There will only be
     * a single entry for any given file.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataform.v1.FetchFileGitStatusesResponse.UncommittedFileChange uncommitted_file_changes = 1;
     * </code>
     */
    public com.google.cloud.dataform.v1.FetchFileGitStatusesResponse.UncommittedFileChangeOrBuilder
        getUncommittedFileChangesOrBuilder(int index) {
      if (uncommittedFileChangesBuilder_ == null) {
        return uncommittedFileChanges_.get(index);
      } else {
        return uncommittedFileChangesBuilder_.getMessageOrBuilder(index);
      }
    }

    /**
     *
     *
     * <pre>
     * A list of all files which have uncommitted Git changes. There will only be
     * a single entry for any given file.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataform.v1.FetchFileGitStatusesResponse.UncommittedFileChange uncommitted_file_changes = 1;
     * </code>
     */
    public java.util.List<
            ? extends
                com.google.cloud.dataform.v1.FetchFileGitStatusesResponse
                    .UncommittedFileChangeOrBuilder>
        getUncommittedFileChangesOrBuilderList() {
      if (uncommittedFileChangesBuilder_ != null) {
        return uncommittedFileChangesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(uncommittedFileChanges_);
      }
    }

    /**
     *
     *
     * <pre>
     * A list of all files which have uncommitted Git changes. There will only be
     * a single entry for any given file.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataform.v1.FetchFileGitStatusesResponse.UncommittedFileChange uncommitted_file_changes = 1;
     * </code>
     */
    public com.google.cloud.dataform.v1.FetchFileGitStatusesResponse.UncommittedFileChange.Builder
        addUncommittedFileChangesBuilder() {
      return getUncommittedFileChangesFieldBuilder()
          .addBuilder(
              com.google.cloud.dataform.v1.FetchFileGitStatusesResponse.UncommittedFileChange
                  .getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * A list of all files which have uncommitted Git changes. There will only be
     * a single entry for any given file.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataform.v1.FetchFileGitStatusesResponse.UncommittedFileChange uncommitted_file_changes = 1;
     * </code>
     */
    public com.google.cloud.dataform.v1.FetchFileGitStatusesResponse.UncommittedFileChange.Builder
        addUncommittedFileChangesBuilder(int index) {
      return getUncommittedFileChangesFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.dataform.v1.FetchFileGitStatusesResponse.UncommittedFileChange
                  .getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * A list of all files which have uncommitted Git changes. There will only be
     * a single entry for any given file.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataform.v1.FetchFileGitStatusesResponse.UncommittedFileChange uncommitted_file_changes = 1;
     * </code>
     */
    public java.util.List<
            com.google.cloud.dataform.v1.FetchFileGitStatusesResponse.UncommittedFileChange.Builder>
        getUncommittedFileChangesBuilderList() {
      return getUncommittedFileChangesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.dataform.v1.FetchFileGitStatusesResponse.UncommittedFileChange,
            com.google.cloud.dataform.v1.FetchFileGitStatusesResponse.UncommittedFileChange.Builder,
            com.google.cloud.dataform.v1.FetchFileGitStatusesResponse
                .UncommittedFileChangeOrBuilder>
        getUncommittedFileChangesFieldBuilder() {
      if (uncommittedFileChangesBuilder_ == null) {
        uncommittedFileChangesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.dataform.v1.FetchFileGitStatusesResponse.UncommittedFileChange,
                com.google.cloud.dataform.v1.FetchFileGitStatusesResponse.UncommittedFileChange
                    .Builder,
                com.google.cloud.dataform.v1.FetchFileGitStatusesResponse
                    .UncommittedFileChangeOrBuilder>(
                uncommittedFileChanges_,
                ((bitField0_ & 0x00000001) != 0),
                getParentForChildren(),
                isClean());
        uncommittedFileChanges_ = null;
      }
      return uncommittedFileChangesBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.dataform.v1.FetchFileGitStatusesResponse)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.dataform.v1.FetchFileGitStatusesResponse)
  private static final com.google.cloud.dataform.v1.FetchFileGitStatusesResponse DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.dataform.v1.FetchFileGitStatusesResponse();
  }

  public static com.google.cloud.dataform.v1.FetchFileGitStatusesResponse getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<FetchFileGitStatusesResponse> PARSER =
      new com.google.protobuf.AbstractParser<FetchFileGitStatusesResponse>() {
        @java.lang.Override
        public FetchFileGitStatusesResponse parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<FetchFileGitStatusesResponse> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<FetchFileGitStatusesResponse> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.dataform.v1.FetchFileGitStatusesResponse getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
