/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/dataform/v1/dataform.proto

// Protobuf Java Version: 3.25.8
package com.google.cloud.dataform.v1;

/**
 *
 *
 * <pre>
 * Represents the result of compiling a Dataform project.
 * </pre>
 *
 * Protobuf type {@code google.cloud.dataform.v1.CompilationResult}
 */
public final class CompilationResult extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.dataform.v1.CompilationResult)
    CompilationResultOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use CompilationResult.newBuilder() to construct.
  private CompilationResult(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private CompilationResult() {
    name_ = "";
    resolvedGitCommitSha_ = "";
    dataformCoreVersion_ = "";
    compilationErrors_ = java.util.Collections.emptyList();
    internalMetadata_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new CompilationResult();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.dataform.v1.DataformProto
        .internal_static_google_cloud_dataform_v1_CompilationResult_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.dataform.v1.DataformProto
        .internal_static_google_cloud_dataform_v1_CompilationResult_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.dataform.v1.CompilationResult.class,
            com.google.cloud.dataform.v1.CompilationResult.Builder.class);
  }

  public interface CompilationErrorOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.dataform.v1.CompilationResult.CompilationError)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Output only. The error's top level message.
     * </pre>
     *
     * <code>string message = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The message.
     */
    java.lang.String getMessage();

    /**
     *
     *
     * <pre>
     * Output only. The error's top level message.
     * </pre>
     *
     * <code>string message = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for message.
     */
    com.google.protobuf.ByteString getMessageBytes();

    /**
     *
     *
     * <pre>
     * Output only. The error's full stack trace.
     * </pre>
     *
     * <code>string stack = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The stack.
     */
    java.lang.String getStack();

    /**
     *
     *
     * <pre>
     * Output only. The error's full stack trace.
     * </pre>
     *
     * <code>string stack = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for stack.
     */
    com.google.protobuf.ByteString getStackBytes();

    /**
     *
     *
     * <pre>
     * Output only. The path of the file where this error occurred, if
     * available, relative to the project root.
     * </pre>
     *
     * <code>string path = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The path.
     */
    java.lang.String getPath();

    /**
     *
     *
     * <pre>
     * Output only. The path of the file where this error occurred, if
     * available, relative to the project root.
     * </pre>
     *
     * <code>string path = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for path.
     */
    com.google.protobuf.ByteString getPathBytes();

    /**
     *
     *
     * <pre>
     * Output only. The identifier of the action where this error occurred, if
     * available.
     * </pre>
     *
     * <code>
     * .google.cloud.dataform.v1.Target action_target = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the actionTarget field is set.
     */
    boolean hasActionTarget();

    /**
     *
     *
     * <pre>
     * Output only. The identifier of the action where this error occurred, if
     * available.
     * </pre>
     *
     * <code>
     * .google.cloud.dataform.v1.Target action_target = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The actionTarget.
     */
    com.google.cloud.dataform.v1.Target getActionTarget();

    /**
     *
     *
     * <pre>
     * Output only. The identifier of the action where this error occurred, if
     * available.
     * </pre>
     *
     * <code>
     * .google.cloud.dataform.v1.Target action_target = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    com.google.cloud.dataform.v1.TargetOrBuilder getActionTargetOrBuilder();
  }

  /**
   *
   *
   * <pre>
   * An error encountered when attempting to compile a Dataform project.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dataform.v1.CompilationResult.CompilationError}
   */
  public static final class CompilationError extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.dataform.v1.CompilationResult.CompilationError)
      CompilationErrorOrBuilder {
    private static final long serialVersionUID = 0L;

    // Use CompilationError.newBuilder() to construct.
    private CompilationError(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private CompilationError() {
      message_ = "";
      stack_ = "";
      path_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new CompilationError();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dataform.v1.DataformProto
          .internal_static_google_cloud_dataform_v1_CompilationResult_CompilationError_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dataform.v1.DataformProto
          .internal_static_google_cloud_dataform_v1_CompilationResult_CompilationError_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dataform.v1.CompilationResult.CompilationError.class,
              com.google.cloud.dataform.v1.CompilationResult.CompilationError.Builder.class);
    }

    private int bitField0_;
    public static final int MESSAGE_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object message_ = "";

    /**
     *
     *
     * <pre>
     * Output only. The error's top level message.
     * </pre>
     *
     * <code>string message = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The message.
     */
    @java.lang.Override
    public java.lang.String getMessage() {
      java.lang.Object ref = message_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        message_ = s;
        return s;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. The error's top level message.
     * </pre>
     *
     * <code>string message = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for message.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getMessageBytes() {
      java.lang.Object ref = message_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        message_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int STACK_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private volatile java.lang.Object stack_ = "";

    /**
     *
     *
     * <pre>
     * Output only. The error's full stack trace.
     * </pre>
     *
     * <code>string stack = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The stack.
     */
    @java.lang.Override
    public java.lang.String getStack() {
      java.lang.Object ref = stack_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        stack_ = s;
        return s;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. The error's full stack trace.
     * </pre>
     *
     * <code>string stack = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for stack.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getStackBytes() {
      java.lang.Object ref = stack_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        stack_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int PATH_FIELD_NUMBER = 3;

    @SuppressWarnings("serial")
    private volatile java.lang.Object path_ = "";

    /**
     *
     *
     * <pre>
     * Output only. The path of the file where this error occurred, if
     * available, relative to the project root.
     * </pre>
     *
     * <code>string path = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The path.
     */
    @java.lang.Override
    public java.lang.String getPath() {
      java.lang.Object ref = path_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        path_ = s;
        return s;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. The path of the file where this error occurred, if
     * available, relative to the project root.
     * </pre>
     *
     * <code>string path = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for path.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getPathBytes() {
      java.lang.Object ref = path_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        path_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int ACTION_TARGET_FIELD_NUMBER = 4;
    private com.google.cloud.dataform.v1.Target actionTarget_;

    /**
     *
     *
     * <pre>
     * Output only. The identifier of the action where this error occurred, if
     * available.
     * </pre>
     *
     * <code>
     * .google.cloud.dataform.v1.Target action_target = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the actionTarget field is set.
     */
    @java.lang.Override
    public boolean hasActionTarget() {
      return ((bitField0_ & 0x00000001) != 0);
    }

    /**
     *
     *
     * <pre>
     * Output only. The identifier of the action where this error occurred, if
     * available.
     * </pre>
     *
     * <code>
     * .google.cloud.dataform.v1.Target action_target = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The actionTarget.
     */
    @java.lang.Override
    public com.google.cloud.dataform.v1.Target getActionTarget() {
      return actionTarget_ == null
          ? com.google.cloud.dataform.v1.Target.getDefaultInstance()
          : actionTarget_;
    }

    /**
     *
     *
     * <pre>
     * Output only. The identifier of the action where this error occurred, if
     * available.
     * </pre>
     *
     * <code>
     * .google.cloud.dataform.v1.Target action_target = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.dataform.v1.TargetOrBuilder getActionTargetOrBuilder() {
      return actionTarget_ == null
          ? com.google.cloud.dataform.v1.Target.getDefaultInstance()
          : actionTarget_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(message_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, message_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(stack_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, stack_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(path_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 3, path_);
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(4, getActionTarget());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(message_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, message_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(stack_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, stack_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(path_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, path_);
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getActionTarget());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.dataform.v1.CompilationResult.CompilationError)) {
        return super.equals(obj);
      }
      com.google.cloud.dataform.v1.CompilationResult.CompilationError other =
          (com.google.cloud.dataform.v1.CompilationResult.CompilationError) obj;

      if (!getMessage().equals(other.getMessage())) return false;
      if (!getStack().equals(other.getStack())) return false;
      if (!getPath().equals(other.getPath())) return false;
      if (hasActionTarget() != other.hasActionTarget()) return false;
      if (hasActionTarget()) {
        if (!getActionTarget().equals(other.getActionTarget())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + MESSAGE_FIELD_NUMBER;
      hash = (53 * hash) + getMessage().hashCode();
      hash = (37 * hash) + STACK_FIELD_NUMBER;
      hash = (53 * hash) + getStack().hashCode();
      hash = (37 * hash) + PATH_FIELD_NUMBER;
      hash = (53 * hash) + getPath().hashCode();
      if (hasActionTarget()) {
        hash = (37 * hash) + ACTION_TARGET_FIELD_NUMBER;
        hash = (53 * hash) + getActionTarget().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.dataform.v1.CompilationResult.CompilationError parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dataform.v1.CompilationResult.CompilationError parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dataform.v1.CompilationResult.CompilationError parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dataform.v1.CompilationResult.CompilationError parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dataform.v1.CompilationResult.CompilationError parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dataform.v1.CompilationResult.CompilationError parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dataform.v1.CompilationResult.CompilationError parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dataform.v1.CompilationResult.CompilationError parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dataform.v1.CompilationResult.CompilationError
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.dataform.v1.CompilationResult.CompilationError
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dataform.v1.CompilationResult.CompilationError parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dataform.v1.CompilationResult.CompilationError parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.dataform.v1.CompilationResult.CompilationError prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * An error encountered when attempting to compile a Dataform project.
     * </pre>
     *
     * Protobuf type {@code google.cloud.dataform.v1.CompilationResult.CompilationError}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.dataform.v1.CompilationResult.CompilationError)
        com.google.cloud.dataform.v1.CompilationResult.CompilationErrorOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.dataform.v1.DataformProto
            .internal_static_google_cloud_dataform_v1_CompilationResult_CompilationError_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.dataform.v1.DataformProto
            .internal_static_google_cloud_dataform_v1_CompilationResult_CompilationError_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.dataform.v1.CompilationResult.CompilationError.class,
                com.google.cloud.dataform.v1.CompilationResult.CompilationError.Builder.class);
      }

      // Construct using
      // com.google.cloud.dataform.v1.CompilationResult.CompilationError.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getActionTargetFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        message_ = "";
        stack_ = "";
        path_ = "";
        actionTarget_ = null;
        if (actionTargetBuilder_ != null) {
          actionTargetBuilder_.dispose();
          actionTargetBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.dataform.v1.DataformProto
            .internal_static_google_cloud_dataform_v1_CompilationResult_CompilationError_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.dataform.v1.CompilationResult.CompilationError
          getDefaultInstanceForType() {
        return com.google.cloud.dataform.v1.CompilationResult.CompilationError.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.dataform.v1.CompilationResult.CompilationError build() {
        com.google.cloud.dataform.v1.CompilationResult.CompilationError result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.dataform.v1.CompilationResult.CompilationError buildPartial() {
        com.google.cloud.dataform.v1.CompilationResult.CompilationError result =
            new com.google.cloud.dataform.v1.CompilationResult.CompilationError(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.dataform.v1.CompilationResult.CompilationError result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.message_ = message_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.stack_ = stack_;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.path_ = path_;
        }
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000008) != 0)) {
          result.actionTarget_ =
              actionTargetBuilder_ == null ? actionTarget_ : actionTargetBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.dataform.v1.CompilationResult.CompilationError) {
          return mergeFrom((com.google.cloud.dataform.v1.CompilationResult.CompilationError) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.dataform.v1.CompilationResult.CompilationError other) {
        if (other
            == com.google.cloud.dataform.v1.CompilationResult.CompilationError.getDefaultInstance())
          return this;
        if (!other.getMessage().isEmpty()) {
          message_ = other.message_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (!other.getStack().isEmpty()) {
          stack_ = other.stack_;
          bitField0_ |= 0x00000002;
          onChanged();
        }
        if (!other.getPath().isEmpty()) {
          path_ = other.path_;
          bitField0_ |= 0x00000004;
          onChanged();
        }
        if (other.hasActionTarget()) {
          mergeActionTarget(other.getActionTarget());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  message_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  stack_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              case 26:
                {
                  path_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000004;
                  break;
                } // case 26
              case 34:
                {
                  input.readMessage(getActionTargetFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000008;
                  break;
                } // case 34
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object message_ = "";

      /**
       *
       *
       * <pre>
       * Output only. The error's top level message.
       * </pre>
       *
       * <code>string message = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return The message.
       */
      public java.lang.String getMessage() {
        java.lang.Object ref = message_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          message_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Output only. The error's top level message.
       * </pre>
       *
       * <code>string message = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return The bytes for message.
       */
      public com.google.protobuf.ByteString getMessageBytes() {
        java.lang.Object ref = message_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          message_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Output only. The error's top level message.
       * </pre>
       *
       * <code>string message = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @param value The message to set.
       * @return This builder for chaining.
       */
      public Builder setMessage(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        message_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Output only. The error's top level message.
       * </pre>
       *
       * <code>string message = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearMessage() {
        message_ = getDefaultInstance().getMessage();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Output only. The error's top level message.
       * </pre>
       *
       * <code>string message = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @param value The bytes for message to set.
       * @return This builder for chaining.
       */
      public Builder setMessageBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        message_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private java.lang.Object stack_ = "";

      /**
       *
       *
       * <pre>
       * Output only. The error's full stack trace.
       * </pre>
       *
       * <code>string stack = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return The stack.
       */
      public java.lang.String getStack() {
        java.lang.Object ref = stack_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          stack_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Output only. The error's full stack trace.
       * </pre>
       *
       * <code>string stack = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return The bytes for stack.
       */
      public com.google.protobuf.ByteString getStackBytes() {
        java.lang.Object ref = stack_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          stack_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Output only. The error's full stack trace.
       * </pre>
       *
       * <code>string stack = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @param value The stack to set.
       * @return This builder for chaining.
       */
      public Builder setStack(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        stack_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Output only. The error's full stack trace.
       * </pre>
       *
       * <code>string stack = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearStack() {
        stack_ = getDefaultInstance().getStack();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Output only. The error's full stack trace.
       * </pre>
       *
       * <code>string stack = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @param value The bytes for stack to set.
       * @return This builder for chaining.
       */
      public Builder setStackBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        stack_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      private java.lang.Object path_ = "";

      /**
       *
       *
       * <pre>
       * Output only. The path of the file where this error occurred, if
       * available, relative to the project root.
       * </pre>
       *
       * <code>string path = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return The path.
       */
      public java.lang.String getPath() {
        java.lang.Object ref = path_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          path_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Output only. The path of the file where this error occurred, if
       * available, relative to the project root.
       * </pre>
       *
       * <code>string path = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return The bytes for path.
       */
      public com.google.protobuf.ByteString getPathBytes() {
        java.lang.Object ref = path_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          path_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Output only. The path of the file where this error occurred, if
       * available, relative to the project root.
       * </pre>
       *
       * <code>string path = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @param value The path to set.
       * @return This builder for chaining.
       */
      public Builder setPath(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        path_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Output only. The path of the file where this error occurred, if
       * available, relative to the project root.
       * </pre>
       *
       * <code>string path = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearPath() {
        path_ = getDefaultInstance().getPath();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Output only. The path of the file where this error occurred, if
       * available, relative to the project root.
       * </pre>
       *
       * <code>string path = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @param value The bytes for path to set.
       * @return This builder for chaining.
       */
      public Builder setPathBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        path_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      private com.google.cloud.dataform.v1.Target actionTarget_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.dataform.v1.Target,
              com.google.cloud.dataform.v1.Target.Builder,
              com.google.cloud.dataform.v1.TargetOrBuilder>
          actionTargetBuilder_;

      /**
       *
       *
       * <pre>
       * Output only. The identifier of the action where this error occurred, if
       * available.
       * </pre>
       *
       * <code>
       * .google.cloud.dataform.v1.Target action_target = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return Whether the actionTarget field is set.
       */
      public boolean hasActionTarget() {
        return ((bitField0_ & 0x00000008) != 0);
      }

      /**
       *
       *
       * <pre>
       * Output only. The identifier of the action where this error occurred, if
       * available.
       * </pre>
       *
       * <code>
       * .google.cloud.dataform.v1.Target action_target = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return The actionTarget.
       */
      public com.google.cloud.dataform.v1.Target getActionTarget() {
        if (actionTargetBuilder_ == null) {
          return actionTarget_ == null
              ? com.google.cloud.dataform.v1.Target.getDefaultInstance()
              : actionTarget_;
        } else {
          return actionTargetBuilder_.getMessage();
        }
      }

      /**
       *
       *
       * <pre>
       * Output only. The identifier of the action where this error occurred, if
       * available.
       * </pre>
       *
       * <code>
       * .google.cloud.dataform.v1.Target action_target = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder setActionTarget(com.google.cloud.dataform.v1.Target value) {
        if (actionTargetBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          actionTarget_ = value;
        } else {
          actionTargetBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Output only. The identifier of the action where this error occurred, if
       * available.
       * </pre>
       *
       * <code>
       * .google.cloud.dataform.v1.Target action_target = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder setActionTarget(com.google.cloud.dataform.v1.Target.Builder builderForValue) {
        if (actionTargetBuilder_ == null) {
          actionTarget_ = builderForValue.build();
        } else {
          actionTargetBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Output only. The identifier of the action where this error occurred, if
       * available.
       * </pre>
       *
       * <code>
       * .google.cloud.dataform.v1.Target action_target = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder mergeActionTarget(com.google.cloud.dataform.v1.Target value) {
        if (actionTargetBuilder_ == null) {
          if (((bitField0_ & 0x00000008) != 0)
              && actionTarget_ != null
              && actionTarget_ != com.google.cloud.dataform.v1.Target.getDefaultInstance()) {
            getActionTargetBuilder().mergeFrom(value);
          } else {
            actionTarget_ = value;
          }
        } else {
          actionTargetBuilder_.mergeFrom(value);
        }
        if (actionTarget_ != null) {
          bitField0_ |= 0x00000008;
          onChanged();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Output only. The identifier of the action where this error occurred, if
       * available.
       * </pre>
       *
       * <code>
       * .google.cloud.dataform.v1.Target action_target = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder clearActionTarget() {
        bitField0_ = (bitField0_ & ~0x00000008);
        actionTarget_ = null;
        if (actionTargetBuilder_ != null) {
          actionTargetBuilder_.dispose();
          actionTargetBuilder_ = null;
        }
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Output only. The identifier of the action where this error occurred, if
       * available.
       * </pre>
       *
       * <code>
       * .google.cloud.dataform.v1.Target action_target = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public com.google.cloud.dataform.v1.Target.Builder getActionTargetBuilder() {
        bitField0_ |= 0x00000008;
        onChanged();
        return getActionTargetFieldBuilder().getBuilder();
      }

      /**
       *
       *
       * <pre>
       * Output only. The identifier of the action where this error occurred, if
       * available.
       * </pre>
       *
       * <code>
       * .google.cloud.dataform.v1.Target action_target = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public com.google.cloud.dataform.v1.TargetOrBuilder getActionTargetOrBuilder() {
        if (actionTargetBuilder_ != null) {
          return actionTargetBuilder_.getMessageOrBuilder();
        } else {
          return actionTarget_ == null
              ? com.google.cloud.dataform.v1.Target.getDefaultInstance()
              : actionTarget_;
        }
      }

      /**
       *
       *
       * <pre>
       * Output only. The identifier of the action where this error occurred, if
       * available.
       * </pre>
       *
       * <code>
       * .google.cloud.dataform.v1.Target action_target = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.dataform.v1.Target,
              com.google.cloud.dataform.v1.Target.Builder,
              com.google.cloud.dataform.v1.TargetOrBuilder>
          getActionTargetFieldBuilder() {
        if (actionTargetBuilder_ == null) {
          actionTargetBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.dataform.v1.Target,
                  com.google.cloud.dataform.v1.Target.Builder,
                  com.google.cloud.dataform.v1.TargetOrBuilder>(
                  getActionTarget(), getParentForChildren(), isClean());
          actionTarget_ = null;
        }
        return actionTargetBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.dataform.v1.CompilationResult.CompilationError)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.dataform.v1.CompilationResult.CompilationError)
    private static final com.google.cloud.dataform.v1.CompilationResult.CompilationError
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.dataform.v1.CompilationResult.CompilationError();
    }

    public static com.google.cloud.dataform.v1.CompilationResult.CompilationError
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<CompilationError> PARSER =
        new com.google.protobuf.AbstractParser<CompilationError>() {
          @java.lang.Override
          public CompilationError parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<CompilationError> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<CompilationError> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.dataform.v1.CompilationResult.CompilationError
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int bitField0_;
  private int sourceCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object source_;

  public enum SourceCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    GIT_COMMITISH(2),
    WORKSPACE(3),
    RELEASE_CONFIG(7),
    SOURCE_NOT_SET(0);
    private final int value;

    private SourceCase(int value) {
      this.value = value;
    }

    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static SourceCase valueOf(int value) {
      return forNumber(value);
    }

    public static SourceCase forNumber(int value) {
      switch (value) {
        case 2:
          return GIT_COMMITISH;
        case 3:
          return WORKSPACE;
        case 7:
          return RELEASE_CONFIG;
        case 0:
          return SOURCE_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public SourceCase getSourceCase() {
    return SourceCase.forNumber(sourceCase_);
  }

  public static final int GIT_COMMITISH_FIELD_NUMBER = 2;

  /**
   *
   *
   * <pre>
   * Immutable. Git commit/tag/branch name at which the repository should be
   * compiled. Must exist in the remote repository. Examples:
   * - a commit SHA: `12ade345`
   * - a tag: `tag1`
   * - a branch name: `branch1`
   * </pre>
   *
   * <code>string git_commitish = 2 [(.google.api.field_behavior) = IMMUTABLE];</code>
   *
   * @return Whether the gitCommitish field is set.
   */
  public boolean hasGitCommitish() {
    return sourceCase_ == 2;
  }

  /**
   *
   *
   * <pre>
   * Immutable. Git commit/tag/branch name at which the repository should be
   * compiled. Must exist in the remote repository. Examples:
   * - a commit SHA: `12ade345`
   * - a tag: `tag1`
   * - a branch name: `branch1`
   * </pre>
   *
   * <code>string git_commitish = 2 [(.google.api.field_behavior) = IMMUTABLE];</code>
   *
   * @return The gitCommitish.
   */
  public java.lang.String getGitCommitish() {
    java.lang.Object ref = "";
    if (sourceCase_ == 2) {
      ref = source_;
    }
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      if (sourceCase_ == 2) {
        source_ = s;
      }
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Immutable. Git commit/tag/branch name at which the repository should be
   * compiled. Must exist in the remote repository. Examples:
   * - a commit SHA: `12ade345`
   * - a tag: `tag1`
   * - a branch name: `branch1`
   * </pre>
   *
   * <code>string git_commitish = 2 [(.google.api.field_behavior) = IMMUTABLE];</code>
   *
   * @return The bytes for gitCommitish.
   */
  public com.google.protobuf.ByteString getGitCommitishBytes() {
    java.lang.Object ref = "";
    if (sourceCase_ == 2) {
      ref = source_;
    }
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      if (sourceCase_ == 2) {
        source_ = b;
      }
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int WORKSPACE_FIELD_NUMBER = 3;

  /**
   *
   *
   * <pre>
   * Immutable. The name of the workspace to compile. Must be in the format
   * `projects/&#42;&#47;locations/&#42;&#47;repositories/&#42;&#47;workspaces/&#42;`.
   * </pre>
   *
   * <code>
   * string workspace = 3 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return Whether the workspace field is set.
   */
  public boolean hasWorkspace() {
    return sourceCase_ == 3;
  }

  /**
   *
   *
   * <pre>
   * Immutable. The name of the workspace to compile. Must be in the format
   * `projects/&#42;&#47;locations/&#42;&#47;repositories/&#42;&#47;workspaces/&#42;`.
   * </pre>
   *
   * <code>
   * string workspace = 3 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The workspace.
   */
  public java.lang.String getWorkspace() {
    java.lang.Object ref = "";
    if (sourceCase_ == 3) {
      ref = source_;
    }
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      if (sourceCase_ == 3) {
        source_ = s;
      }
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Immutable. The name of the workspace to compile. Must be in the format
   * `projects/&#42;&#47;locations/&#42;&#47;repositories/&#42;&#47;workspaces/&#42;`.
   * </pre>
   *
   * <code>
   * string workspace = 3 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for workspace.
   */
  public com.google.protobuf.ByteString getWorkspaceBytes() {
    java.lang.Object ref = "";
    if (sourceCase_ == 3) {
      ref = source_;
    }
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      if (sourceCase_ == 3) {
        source_ = b;
      }
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int RELEASE_CONFIG_FIELD_NUMBER = 7;

  /**
   *
   *
   * <pre>
   * Immutable. The name of the release config to compile. Must be in the
   * format `projects/&#42;&#47;locations/&#42;&#47;repositories/&#42;&#47;releaseConfigs/&#42;`.
   * </pre>
   *
   * <code>
   * string release_config = 7 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return Whether the releaseConfig field is set.
   */
  public boolean hasReleaseConfig() {
    return sourceCase_ == 7;
  }

  /**
   *
   *
   * <pre>
   * Immutable. The name of the release config to compile. Must be in the
   * format `projects/&#42;&#47;locations/&#42;&#47;repositories/&#42;&#47;releaseConfigs/&#42;`.
   * </pre>
   *
   * <code>
   * string release_config = 7 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The releaseConfig.
   */
  public java.lang.String getReleaseConfig() {
    java.lang.Object ref = "";
    if (sourceCase_ == 7) {
      ref = source_;
    }
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      if (sourceCase_ == 7) {
        source_ = s;
      }
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Immutable. The name of the release config to compile. Must be in the
   * format `projects/&#42;&#47;locations/&#42;&#47;repositories/&#42;&#47;releaseConfigs/&#42;`.
   * </pre>
   *
   * <code>
   * string release_config = 7 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for releaseConfig.
   */
  public com.google.protobuf.ByteString getReleaseConfigBytes() {
    java.lang.Object ref = "";
    if (sourceCase_ == 7) {
      ref = source_;
    }
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      if (sourceCase_ == 7) {
        source_ = b;
      }
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";

  /**
   *
   *
   * <pre>
   * Output only. The compilation result's name.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Output only. The compilation result's name.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CODE_COMPILATION_CONFIG_FIELD_NUMBER = 4;
  private com.google.cloud.dataform.v1.CodeCompilationConfig codeCompilationConfig_;

  /**
   *
   *
   * <pre>
   * Immutable. If set, fields of `code_compilation_config` override the default
   * compilation settings that are specified in dataform.json.
   * </pre>
   *
   * <code>
   * .google.cloud.dataform.v1.CodeCompilationConfig code_compilation_config = 4 [(.google.api.field_behavior) = IMMUTABLE];
   * </code>
   *
   * @return Whether the codeCompilationConfig field is set.
   */
  @java.lang.Override
  public boolean hasCodeCompilationConfig() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * Immutable. If set, fields of `code_compilation_config` override the default
   * compilation settings that are specified in dataform.json.
   * </pre>
   *
   * <code>
   * .google.cloud.dataform.v1.CodeCompilationConfig code_compilation_config = 4 [(.google.api.field_behavior) = IMMUTABLE];
   * </code>
   *
   * @return The codeCompilationConfig.
   */
  @java.lang.Override
  public com.google.cloud.dataform.v1.CodeCompilationConfig getCodeCompilationConfig() {
    return codeCompilationConfig_ == null
        ? com.google.cloud.dataform.v1.CodeCompilationConfig.getDefaultInstance()
        : codeCompilationConfig_;
  }

  /**
   *
   *
   * <pre>
   * Immutable. If set, fields of `code_compilation_config` override the default
   * compilation settings that are specified in dataform.json.
   * </pre>
   *
   * <code>
   * .google.cloud.dataform.v1.CodeCompilationConfig code_compilation_config = 4 [(.google.api.field_behavior) = IMMUTABLE];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dataform.v1.CodeCompilationConfigOrBuilder
      getCodeCompilationConfigOrBuilder() {
    return codeCompilationConfig_ == null
        ? com.google.cloud.dataform.v1.CodeCompilationConfig.getDefaultInstance()
        : codeCompilationConfig_;
  }

  public static final int RESOLVED_GIT_COMMIT_SHA_FIELD_NUMBER = 8;

  @SuppressWarnings("serial")
  private volatile java.lang.Object resolvedGitCommitSha_ = "";

  /**
   *
   *
   * <pre>
   * Output only. The fully resolved Git commit SHA of the code that was
   * compiled. Not set for compilation results whose source is a workspace.
   * </pre>
   *
   * <code>string resolved_git_commit_sha = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The resolvedGitCommitSha.
   */
  @java.lang.Override
  public java.lang.String getResolvedGitCommitSha() {
    java.lang.Object ref = resolvedGitCommitSha_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      resolvedGitCommitSha_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Output only. The fully resolved Git commit SHA of the code that was
   * compiled. Not set for compilation results whose source is a workspace.
   * </pre>
   *
   * <code>string resolved_git_commit_sha = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for resolvedGitCommitSha.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getResolvedGitCommitShaBytes() {
    java.lang.Object ref = resolvedGitCommitSha_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      resolvedGitCommitSha_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DATAFORM_CORE_VERSION_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private volatile java.lang.Object dataformCoreVersion_ = "";

  /**
   *
   *
   * <pre>
   * Output only. The version of `&#64;dataform/core` that was used for compilation.
   * </pre>
   *
   * <code>string dataform_core_version = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The dataformCoreVersion.
   */
  @java.lang.Override
  public java.lang.String getDataformCoreVersion() {
    java.lang.Object ref = dataformCoreVersion_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      dataformCoreVersion_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Output only. The version of `&#64;dataform/core` that was used for compilation.
   * </pre>
   *
   * <code>string dataform_core_version = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for dataformCoreVersion.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDataformCoreVersionBytes() {
    java.lang.Object ref = dataformCoreVersion_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      dataformCoreVersion_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int COMPILATION_ERRORS_FIELD_NUMBER = 6;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.dataform.v1.CompilationResult.CompilationError>
      compilationErrors_;

  /**
   *
   *
   * <pre>
   * Output only. Errors encountered during project compilation.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dataform.v1.CompilationResult.CompilationError compilation_errors = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.dataform.v1.CompilationResult.CompilationError>
      getCompilationErrorsList() {
    return compilationErrors_;
  }

  /**
   *
   *
   * <pre>
   * Output only. Errors encountered during project compilation.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dataform.v1.CompilationResult.CompilationError compilation_errors = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends com.google.cloud.dataform.v1.CompilationResult.CompilationErrorOrBuilder>
      getCompilationErrorsOrBuilderList() {
    return compilationErrors_;
  }

  /**
   *
   *
   * <pre>
   * Output only. Errors encountered during project compilation.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dataform.v1.CompilationResult.CompilationError compilation_errors = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public int getCompilationErrorsCount() {
    return compilationErrors_.size();
  }

  /**
   *
   *
   * <pre>
   * Output only. Errors encountered during project compilation.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dataform.v1.CompilationResult.CompilationError compilation_errors = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dataform.v1.CompilationResult.CompilationError getCompilationErrors(
      int index) {
    return compilationErrors_.get(index);
  }

  /**
   *
   *
   * <pre>
   * Output only. Errors encountered during project compilation.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dataform.v1.CompilationResult.CompilationError compilation_errors = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dataform.v1.CompilationResult.CompilationErrorOrBuilder
      getCompilationErrorsOrBuilder(int index) {
    return compilationErrors_.get(index);
  }

  public static final int DATA_ENCRYPTION_STATE_FIELD_NUMBER = 9;
  private com.google.cloud.dataform.v1.DataEncryptionState dataEncryptionState_;

  /**
   *
   *
   * <pre>
   * Output only. Only set if the repository has a KMS Key.
   * </pre>
   *
   * <code>
   * .google.cloud.dataform.v1.DataEncryptionState data_encryption_state = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the dataEncryptionState field is set.
   */
  @java.lang.Override
  public boolean hasDataEncryptionState() {
    return ((bitField0_ & 0x00000002) != 0);
  }

  /**
   *
   *
   * <pre>
   * Output only. Only set if the repository has a KMS Key.
   * </pre>
   *
   * <code>
   * .google.cloud.dataform.v1.DataEncryptionState data_encryption_state = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The dataEncryptionState.
   */
  @java.lang.Override
  public com.google.cloud.dataform.v1.DataEncryptionState getDataEncryptionState() {
    return dataEncryptionState_ == null
        ? com.google.cloud.dataform.v1.DataEncryptionState.getDefaultInstance()
        : dataEncryptionState_;
  }

  /**
   *
   *
   * <pre>
   * Output only. Only set if the repository has a KMS Key.
   * </pre>
   *
   * <code>
   * .google.cloud.dataform.v1.DataEncryptionState data_encryption_state = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dataform.v1.DataEncryptionStateOrBuilder
      getDataEncryptionStateOrBuilder() {
    return dataEncryptionState_ == null
        ? com.google.cloud.dataform.v1.DataEncryptionState.getDefaultInstance()
        : dataEncryptionState_;
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 10;
  private com.google.protobuf.Timestamp createTime_;

  /**
   *
   *
   * <pre>
   * Output only. The timestamp of when the compilation result was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return ((bitField0_ & 0x00000004) != 0);
  }

  /**
   *
   *
   * <pre>
   * Output only. The timestamp of when the compilation result was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }

  /**
   *
   *
   * <pre>
   * Output only. The timestamp of when the compilation result was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }

  public static final int INTERNAL_METADATA_FIELD_NUMBER = 11;

  @SuppressWarnings("serial")
  private volatile java.lang.Object internalMetadata_ = "";

  /**
   *
   *
   * <pre>
   * Output only. All the metadata information that is used internally to serve
   * the resource. For example: timestamps, flags, status fields, etc. The
   * format of this field is a JSON string.
   * </pre>
   *
   * <code>optional string internal_metadata = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the internalMetadata field is set.
   */
  @java.lang.Override
  public boolean hasInternalMetadata() {
    return ((bitField0_ & 0x00000008) != 0);
  }

  /**
   *
   *
   * <pre>
   * Output only. All the metadata information that is used internally to serve
   * the resource. For example: timestamps, flags, status fields, etc. The
   * format of this field is a JSON string.
   * </pre>
   *
   * <code>optional string internal_metadata = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The internalMetadata.
   */
  @java.lang.Override
  public java.lang.String getInternalMetadata() {
    java.lang.Object ref = internalMetadata_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      internalMetadata_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Output only. All the metadata information that is used internally to serve
   * the resource. For example: timestamps, flags, status fields, etc. The
   * format of this field is a JSON string.
   * </pre>
   *
   * <code>optional string internal_metadata = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The bytes for internalMetadata.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getInternalMetadataBytes() {
    java.lang.Object ref = internalMetadata_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      internalMetadata_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (sourceCase_ == 2) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, source_);
    }
    if (sourceCase_ == 3) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, source_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(4, getCodeCompilationConfig());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(dataformCoreVersion_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, dataformCoreVersion_);
    }
    for (int i = 0; i < compilationErrors_.size(); i++) {
      output.writeMessage(6, compilationErrors_.get(i));
    }
    if (sourceCase_ == 7) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 7, source_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(resolvedGitCommitSha_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 8, resolvedGitCommitSha_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(9, getDataEncryptionState());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(10, getCreateTime());
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 11, internalMetadata_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (sourceCase_ == 2) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, source_);
    }
    if (sourceCase_ == 3) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, source_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(4, getCodeCompilationConfig());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(dataformCoreVersion_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, dataformCoreVersion_);
    }
    for (int i = 0; i < compilationErrors_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(6, compilationErrors_.get(i));
    }
    if (sourceCase_ == 7) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(7, source_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(resolvedGitCommitSha_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(8, resolvedGitCommitSha_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(9, getDataEncryptionState());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(10, getCreateTime());
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(11, internalMetadata_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.dataform.v1.CompilationResult)) {
      return super.equals(obj);
    }
    com.google.cloud.dataform.v1.CompilationResult other =
        (com.google.cloud.dataform.v1.CompilationResult) obj;

    if (!getName().equals(other.getName())) return false;
    if (hasCodeCompilationConfig() != other.hasCodeCompilationConfig()) return false;
    if (hasCodeCompilationConfig()) {
      if (!getCodeCompilationConfig().equals(other.getCodeCompilationConfig())) return false;
    }
    if (!getResolvedGitCommitSha().equals(other.getResolvedGitCommitSha())) return false;
    if (!getDataformCoreVersion().equals(other.getDataformCoreVersion())) return false;
    if (!getCompilationErrorsList().equals(other.getCompilationErrorsList())) return false;
    if (hasDataEncryptionState() != other.hasDataEncryptionState()) return false;
    if (hasDataEncryptionState()) {
      if (!getDataEncryptionState().equals(other.getDataEncryptionState())) return false;
    }
    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (hasInternalMetadata() != other.hasInternalMetadata()) return false;
    if (hasInternalMetadata()) {
      if (!getInternalMetadata().equals(other.getInternalMetadata())) return false;
    }
    if (!getSourceCase().equals(other.getSourceCase())) return false;
    switch (sourceCase_) {
      case 2:
        if (!getGitCommitish().equals(other.getGitCommitish())) return false;
        break;
      case 3:
        if (!getWorkspace().equals(other.getWorkspace())) return false;
        break;
      case 7:
        if (!getReleaseConfig().equals(other.getReleaseConfig())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    if (hasCodeCompilationConfig()) {
      hash = (37 * hash) + CODE_COMPILATION_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getCodeCompilationConfig().hashCode();
    }
    hash = (37 * hash) + RESOLVED_GIT_COMMIT_SHA_FIELD_NUMBER;
    hash = (53 * hash) + getResolvedGitCommitSha().hashCode();
    hash = (37 * hash) + DATAFORM_CORE_VERSION_FIELD_NUMBER;
    hash = (53 * hash) + getDataformCoreVersion().hashCode();
    if (getCompilationErrorsCount() > 0) {
      hash = (37 * hash) + COMPILATION_ERRORS_FIELD_NUMBER;
      hash = (53 * hash) + getCompilationErrorsList().hashCode();
    }
    if (hasDataEncryptionState()) {
      hash = (37 * hash) + DATA_ENCRYPTION_STATE_FIELD_NUMBER;
      hash = (53 * hash) + getDataEncryptionState().hashCode();
    }
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    if (hasInternalMetadata()) {
      hash = (37 * hash) + INTERNAL_METADATA_FIELD_NUMBER;
      hash = (53 * hash) + getInternalMetadata().hashCode();
    }
    switch (sourceCase_) {
      case 2:
        hash = (37 * hash) + GIT_COMMITISH_FIELD_NUMBER;
        hash = (53 * hash) + getGitCommitish().hashCode();
        break;
      case 3:
        hash = (37 * hash) + WORKSPACE_FIELD_NUMBER;
        hash = (53 * hash) + getWorkspace().hashCode();
        break;
      case 7:
        hash = (37 * hash) + RELEASE_CONFIG_FIELD_NUMBER;
        hash = (53 * hash) + getReleaseConfig().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.dataform.v1.CompilationResult parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dataform.v1.CompilationResult parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dataform.v1.CompilationResult parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dataform.v1.CompilationResult parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dataform.v1.CompilationResult parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dataform.v1.CompilationResult parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dataform.v1.CompilationResult parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dataform.v1.CompilationResult parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dataform.v1.CompilationResult parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.dataform.v1.CompilationResult parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dataform.v1.CompilationResult parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dataform.v1.CompilationResult parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.dataform.v1.CompilationResult prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * Represents the result of compiling a Dataform project.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dataform.v1.CompilationResult}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.dataform.v1.CompilationResult)
      com.google.cloud.dataform.v1.CompilationResultOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dataform.v1.DataformProto
          .internal_static_google_cloud_dataform_v1_CompilationResult_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dataform.v1.DataformProto
          .internal_static_google_cloud_dataform_v1_CompilationResult_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dataform.v1.CompilationResult.class,
              com.google.cloud.dataform.v1.CompilationResult.Builder.class);
    }

    // Construct using com.google.cloud.dataform.v1.CompilationResult.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getCodeCompilationConfigFieldBuilder();
        getCompilationErrorsFieldBuilder();
        getDataEncryptionStateFieldBuilder();
        getCreateTimeFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      codeCompilationConfig_ = null;
      if (codeCompilationConfigBuilder_ != null) {
        codeCompilationConfigBuilder_.dispose();
        codeCompilationConfigBuilder_ = null;
      }
      resolvedGitCommitSha_ = "";
      dataformCoreVersion_ = "";
      if (compilationErrorsBuilder_ == null) {
        compilationErrors_ = java.util.Collections.emptyList();
      } else {
        compilationErrors_ = null;
        compilationErrorsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000080);
      dataEncryptionState_ = null;
      if (dataEncryptionStateBuilder_ != null) {
        dataEncryptionStateBuilder_.dispose();
        dataEncryptionStateBuilder_ = null;
      }
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      internalMetadata_ = "";
      sourceCase_ = 0;
      source_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.dataform.v1.DataformProto
          .internal_static_google_cloud_dataform_v1_CompilationResult_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.dataform.v1.CompilationResult getDefaultInstanceForType() {
      return com.google.cloud.dataform.v1.CompilationResult.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.dataform.v1.CompilationResult build() {
      com.google.cloud.dataform.v1.CompilationResult result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.dataform.v1.CompilationResult buildPartial() {
      com.google.cloud.dataform.v1.CompilationResult result =
          new com.google.cloud.dataform.v1.CompilationResult(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.cloud.dataform.v1.CompilationResult result) {
      if (compilationErrorsBuilder_ == null) {
        if (((bitField0_ & 0x00000080) != 0)) {
          compilationErrors_ = java.util.Collections.unmodifiableList(compilationErrors_);
          bitField0_ = (bitField0_ & ~0x00000080);
        }
        result.compilationErrors_ = compilationErrors_;
      } else {
        result.compilationErrors_ = compilationErrorsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.dataform.v1.CompilationResult result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.name_ = name_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.codeCompilationConfig_ =
            codeCompilationConfigBuilder_ == null
                ? codeCompilationConfig_
                : codeCompilationConfigBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.resolvedGitCommitSha_ = resolvedGitCommitSha_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.dataformCoreVersion_ = dataformCoreVersion_;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.dataEncryptionState_ =
            dataEncryptionStateBuilder_ == null
                ? dataEncryptionState_
                : dataEncryptionStateBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.createTime_ = createTimeBuilder_ == null ? createTime_ : createTimeBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000400) != 0)) {
        result.internalMetadata_ = internalMetadata_;
        to_bitField0_ |= 0x00000008;
      }
      result.bitField0_ |= to_bitField0_;
    }

    private void buildPartialOneofs(com.google.cloud.dataform.v1.CompilationResult result) {
      result.sourceCase_ = sourceCase_;
      result.source_ = this.source_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.dataform.v1.CompilationResult) {
        return mergeFrom((com.google.cloud.dataform.v1.CompilationResult) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.dataform.v1.CompilationResult other) {
      if (other == com.google.cloud.dataform.v1.CompilationResult.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (other.hasCodeCompilationConfig()) {
        mergeCodeCompilationConfig(other.getCodeCompilationConfig());
      }
      if (!other.getResolvedGitCommitSha().isEmpty()) {
        resolvedGitCommitSha_ = other.resolvedGitCommitSha_;
        bitField0_ |= 0x00000020;
        onChanged();
      }
      if (!other.getDataformCoreVersion().isEmpty()) {
        dataformCoreVersion_ = other.dataformCoreVersion_;
        bitField0_ |= 0x00000040;
        onChanged();
      }
      if (compilationErrorsBuilder_ == null) {
        if (!other.compilationErrors_.isEmpty()) {
          if (compilationErrors_.isEmpty()) {
            compilationErrors_ = other.compilationErrors_;
            bitField0_ = (bitField0_ & ~0x00000080);
          } else {
            ensureCompilationErrorsIsMutable();
            compilationErrors_.addAll(other.compilationErrors_);
          }
          onChanged();
        }
      } else {
        if (!other.compilationErrors_.isEmpty()) {
          if (compilationErrorsBuilder_.isEmpty()) {
            compilationErrorsBuilder_.dispose();
            compilationErrorsBuilder_ = null;
            compilationErrors_ = other.compilationErrors_;
            bitField0_ = (bitField0_ & ~0x00000080);
            compilationErrorsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getCompilationErrorsFieldBuilder()
                    : null;
          } else {
            compilationErrorsBuilder_.addAllMessages(other.compilationErrors_);
          }
        }
      }
      if (other.hasDataEncryptionState()) {
        mergeDataEncryptionState(other.getDataEncryptionState());
      }
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      if (other.hasInternalMetadata()) {
        internalMetadata_ = other.internalMetadata_;
        bitField0_ |= 0x00000400;
        onChanged();
      }
      switch (other.getSourceCase()) {
        case GIT_COMMITISH:
          {
            sourceCase_ = 2;
            source_ = other.source_;
            onChanged();
            break;
          }
        case WORKSPACE:
          {
            sourceCase_ = 3;
            source_ = other.source_;
            onChanged();
            break;
          }
        case RELEASE_CONFIG:
          {
            sourceCase_ = 7;
            source_ = other.source_;
            onChanged();
            break;
          }
        case SOURCE_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 10
            case 18:
              {
                java.lang.String s = input.readStringRequireUtf8();
                sourceCase_ = 2;
                source_ = s;
                break;
              } // case 18
            case 26:
              {
                java.lang.String s = input.readStringRequireUtf8();
                sourceCase_ = 3;
                source_ = s;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(
                    getCodeCompilationConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000010;
                break;
              } // case 34
            case 42:
              {
                dataformCoreVersion_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000040;
                break;
              } // case 42
            case 50:
              {
                com.google.cloud.dataform.v1.CompilationResult.CompilationError m =
                    input.readMessage(
                        com.google.cloud.dataform.v1.CompilationResult.CompilationError.parser(),
                        extensionRegistry);
                if (compilationErrorsBuilder_ == null) {
                  ensureCompilationErrorsIsMutable();
                  compilationErrors_.add(m);
                } else {
                  compilationErrorsBuilder_.addMessage(m);
                }
                break;
              } // case 50
            case 58:
              {
                java.lang.String s = input.readStringRequireUtf8();
                sourceCase_ = 7;
                source_ = s;
                break;
              } // case 58
            case 66:
              {
                resolvedGitCommitSha_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000020;
                break;
              } // case 66
            case 74:
              {
                input.readMessage(
                    getDataEncryptionStateFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000100;
                break;
              } // case 74
            case 82:
              {
                input.readMessage(getCreateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000200;
                break;
              } // case 82
            case 90:
              {
                internalMetadata_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000400;
                break;
              } // case 90
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int sourceCase_ = 0;
    private java.lang.Object source_;

    public SourceCase getSourceCase() {
      return SourceCase.forNumber(sourceCase_);
    }

    public Builder clearSource() {
      sourceCase_ = 0;
      source_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    /**
     *
     *
     * <pre>
     * Immutable. Git commit/tag/branch name at which the repository should be
     * compiled. Must exist in the remote repository. Examples:
     * - a commit SHA: `12ade345`
     * - a tag: `tag1`
     * - a branch name: `branch1`
     * </pre>
     *
     * <code>string git_commitish = 2 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return Whether the gitCommitish field is set.
     */
    @java.lang.Override
    public boolean hasGitCommitish() {
      return sourceCase_ == 2;
    }

    /**
     *
     *
     * <pre>
     * Immutable. Git commit/tag/branch name at which the repository should be
     * compiled. Must exist in the remote repository. Examples:
     * - a commit SHA: `12ade345`
     * - a tag: `tag1`
     * - a branch name: `branch1`
     * </pre>
     *
     * <code>string git_commitish = 2 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return The gitCommitish.
     */
    @java.lang.Override
    public java.lang.String getGitCommitish() {
      java.lang.Object ref = "";
      if (sourceCase_ == 2) {
        ref = source_;
      }
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (sourceCase_ == 2) {
          source_ = s;
        }
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Immutable. Git commit/tag/branch name at which the repository should be
     * compiled. Must exist in the remote repository. Examples:
     * - a commit SHA: `12ade345`
     * - a tag: `tag1`
     * - a branch name: `branch1`
     * </pre>
     *
     * <code>string git_commitish = 2 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return The bytes for gitCommitish.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getGitCommitishBytes() {
      java.lang.Object ref = "";
      if (sourceCase_ == 2) {
        ref = source_;
      }
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        if (sourceCase_ == 2) {
          source_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Immutable. Git commit/tag/branch name at which the repository should be
     * compiled. Must exist in the remote repository. Examples:
     * - a commit SHA: `12ade345`
     * - a tag: `tag1`
     * - a branch name: `branch1`
     * </pre>
     *
     * <code>string git_commitish = 2 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @param value The gitCommitish to set.
     * @return This builder for chaining.
     */
    public Builder setGitCommitish(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      sourceCase_ = 2;
      source_ = value;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Immutable. Git commit/tag/branch name at which the repository should be
     * compiled. Must exist in the remote repository. Examples:
     * - a commit SHA: `12ade345`
     * - a tag: `tag1`
     * - a branch name: `branch1`
     * </pre>
     *
     * <code>string git_commitish = 2 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearGitCommitish() {
      if (sourceCase_ == 2) {
        sourceCase_ = 0;
        source_ = null;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Immutable. Git commit/tag/branch name at which the repository should be
     * compiled. Must exist in the remote repository. Examples:
     * - a commit SHA: `12ade345`
     * - a tag: `tag1`
     * - a branch name: `branch1`
     * </pre>
     *
     * <code>string git_commitish = 2 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @param value The bytes for gitCommitish to set.
     * @return This builder for chaining.
     */
    public Builder setGitCommitishBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      sourceCase_ = 2;
      source_ = value;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Immutable. The name of the workspace to compile. Must be in the format
     * `projects/&#42;&#47;locations/&#42;&#47;repositories/&#42;&#47;workspaces/&#42;`.
     * </pre>
     *
     * <code>
     * string workspace = 3 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return Whether the workspace field is set.
     */
    @java.lang.Override
    public boolean hasWorkspace() {
      return sourceCase_ == 3;
    }

    /**
     *
     *
     * <pre>
     * Immutable. The name of the workspace to compile. Must be in the format
     * `projects/&#42;&#47;locations/&#42;&#47;repositories/&#42;&#47;workspaces/&#42;`.
     * </pre>
     *
     * <code>
     * string workspace = 3 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The workspace.
     */
    @java.lang.Override
    public java.lang.String getWorkspace() {
      java.lang.Object ref = "";
      if (sourceCase_ == 3) {
        ref = source_;
      }
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (sourceCase_ == 3) {
          source_ = s;
        }
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Immutable. The name of the workspace to compile. Must be in the format
     * `projects/&#42;&#47;locations/&#42;&#47;repositories/&#42;&#47;workspaces/&#42;`.
     * </pre>
     *
     * <code>
     * string workspace = 3 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for workspace.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getWorkspaceBytes() {
      java.lang.Object ref = "";
      if (sourceCase_ == 3) {
        ref = source_;
      }
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        if (sourceCase_ == 3) {
          source_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Immutable. The name of the workspace to compile. Must be in the format
     * `projects/&#42;&#47;locations/&#42;&#47;repositories/&#42;&#47;workspaces/&#42;`.
     * </pre>
     *
     * <code>
     * string workspace = 3 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The workspace to set.
     * @return This builder for chaining.
     */
    public Builder setWorkspace(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      sourceCase_ = 3;
      source_ = value;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Immutable. The name of the workspace to compile. Must be in the format
     * `projects/&#42;&#47;locations/&#42;&#47;repositories/&#42;&#47;workspaces/&#42;`.
     * </pre>
     *
     * <code>
     * string workspace = 3 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearWorkspace() {
      if (sourceCase_ == 3) {
        sourceCase_ = 0;
        source_ = null;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Immutable. The name of the workspace to compile. Must be in the format
     * `projects/&#42;&#47;locations/&#42;&#47;repositories/&#42;&#47;workspaces/&#42;`.
     * </pre>
     *
     * <code>
     * string workspace = 3 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for workspace to set.
     * @return This builder for chaining.
     */
    public Builder setWorkspaceBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      sourceCase_ = 3;
      source_ = value;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Immutable. The name of the release config to compile. Must be in the
     * format `projects/&#42;&#47;locations/&#42;&#47;repositories/&#42;&#47;releaseConfigs/&#42;`.
     * </pre>
     *
     * <code>
     * string release_config = 7 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return Whether the releaseConfig field is set.
     */
    @java.lang.Override
    public boolean hasReleaseConfig() {
      return sourceCase_ == 7;
    }

    /**
     *
     *
     * <pre>
     * Immutable. The name of the release config to compile. Must be in the
     * format `projects/&#42;&#47;locations/&#42;&#47;repositories/&#42;&#47;releaseConfigs/&#42;`.
     * </pre>
     *
     * <code>
     * string release_config = 7 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The releaseConfig.
     */
    @java.lang.Override
    public java.lang.String getReleaseConfig() {
      java.lang.Object ref = "";
      if (sourceCase_ == 7) {
        ref = source_;
      }
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (sourceCase_ == 7) {
          source_ = s;
        }
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Immutable. The name of the release config to compile. Must be in the
     * format `projects/&#42;&#47;locations/&#42;&#47;repositories/&#42;&#47;releaseConfigs/&#42;`.
     * </pre>
     *
     * <code>
     * string release_config = 7 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for releaseConfig.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getReleaseConfigBytes() {
      java.lang.Object ref = "";
      if (sourceCase_ == 7) {
        ref = source_;
      }
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        if (sourceCase_ == 7) {
          source_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Immutable. The name of the release config to compile. Must be in the
     * format `projects/&#42;&#47;locations/&#42;&#47;repositories/&#42;&#47;releaseConfigs/&#42;`.
     * </pre>
     *
     * <code>
     * string release_config = 7 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The releaseConfig to set.
     * @return This builder for chaining.
     */
    public Builder setReleaseConfig(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      sourceCase_ = 7;
      source_ = value;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Immutable. The name of the release config to compile. Must be in the
     * format `projects/&#42;&#47;locations/&#42;&#47;repositories/&#42;&#47;releaseConfigs/&#42;`.
     * </pre>
     *
     * <code>
     * string release_config = 7 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearReleaseConfig() {
      if (sourceCase_ == 7) {
        sourceCase_ = 0;
        source_ = null;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Immutable. The name of the release config to compile. Must be in the
     * format `projects/&#42;&#47;locations/&#42;&#47;repositories/&#42;&#47;releaseConfigs/&#42;`.
     * </pre>
     *
     * <code>
     * string release_config = 7 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for releaseConfig to set.
     * @return This builder for chaining.
     */
    public Builder setReleaseConfigBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      sourceCase_ = 7;
      source_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object name_ = "";

    /**
     *
     *
     * <pre>
     * Output only. The compilation result's name.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. The compilation result's name.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. The compilation result's name.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The compilation result's name.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The compilation result's name.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private com.google.cloud.dataform.v1.CodeCompilationConfig codeCompilationConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dataform.v1.CodeCompilationConfig,
            com.google.cloud.dataform.v1.CodeCompilationConfig.Builder,
            com.google.cloud.dataform.v1.CodeCompilationConfigOrBuilder>
        codeCompilationConfigBuilder_;

    /**
     *
     *
     * <pre>
     * Immutable. If set, fields of `code_compilation_config` override the default
     * compilation settings that are specified in dataform.json.
     * </pre>
     *
     * <code>
     * .google.cloud.dataform.v1.CodeCompilationConfig code_compilation_config = 4 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @return Whether the codeCompilationConfig field is set.
     */
    public boolean hasCodeCompilationConfig() {
      return ((bitField0_ & 0x00000010) != 0);
    }

    /**
     *
     *
     * <pre>
     * Immutable. If set, fields of `code_compilation_config` override the default
     * compilation settings that are specified in dataform.json.
     * </pre>
     *
     * <code>
     * .google.cloud.dataform.v1.CodeCompilationConfig code_compilation_config = 4 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @return The codeCompilationConfig.
     */
    public com.google.cloud.dataform.v1.CodeCompilationConfig getCodeCompilationConfig() {
      if (codeCompilationConfigBuilder_ == null) {
        return codeCompilationConfig_ == null
            ? com.google.cloud.dataform.v1.CodeCompilationConfig.getDefaultInstance()
            : codeCompilationConfig_;
      } else {
        return codeCompilationConfigBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Immutable. If set, fields of `code_compilation_config` override the default
     * compilation settings that are specified in dataform.json.
     * </pre>
     *
     * <code>
     * .google.cloud.dataform.v1.CodeCompilationConfig code_compilation_config = 4 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public Builder setCodeCompilationConfig(
        com.google.cloud.dataform.v1.CodeCompilationConfig value) {
      if (codeCompilationConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        codeCompilationConfig_ = value;
      } else {
        codeCompilationConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Immutable. If set, fields of `code_compilation_config` override the default
     * compilation settings that are specified in dataform.json.
     * </pre>
     *
     * <code>
     * .google.cloud.dataform.v1.CodeCompilationConfig code_compilation_config = 4 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public Builder setCodeCompilationConfig(
        com.google.cloud.dataform.v1.CodeCompilationConfig.Builder builderForValue) {
      if (codeCompilationConfigBuilder_ == null) {
        codeCompilationConfig_ = builderForValue.build();
      } else {
        codeCompilationConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Immutable. If set, fields of `code_compilation_config` override the default
     * compilation settings that are specified in dataform.json.
     * </pre>
     *
     * <code>
     * .google.cloud.dataform.v1.CodeCompilationConfig code_compilation_config = 4 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public Builder mergeCodeCompilationConfig(
        com.google.cloud.dataform.v1.CodeCompilationConfig value) {
      if (codeCompilationConfigBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)
            && codeCompilationConfig_ != null
            && codeCompilationConfig_
                != com.google.cloud.dataform.v1.CodeCompilationConfig.getDefaultInstance()) {
          getCodeCompilationConfigBuilder().mergeFrom(value);
        } else {
          codeCompilationConfig_ = value;
        }
      } else {
        codeCompilationConfigBuilder_.mergeFrom(value);
      }
      if (codeCompilationConfig_ != null) {
        bitField0_ |= 0x00000010;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Immutable. If set, fields of `code_compilation_config` override the default
     * compilation settings that are specified in dataform.json.
     * </pre>
     *
     * <code>
     * .google.cloud.dataform.v1.CodeCompilationConfig code_compilation_config = 4 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public Builder clearCodeCompilationConfig() {
      bitField0_ = (bitField0_ & ~0x00000010);
      codeCompilationConfig_ = null;
      if (codeCompilationConfigBuilder_ != null) {
        codeCompilationConfigBuilder_.dispose();
        codeCompilationConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Immutable. If set, fields of `code_compilation_config` override the default
     * compilation settings that are specified in dataform.json.
     * </pre>
     *
     * <code>
     * .google.cloud.dataform.v1.CodeCompilationConfig code_compilation_config = 4 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public com.google.cloud.dataform.v1.CodeCompilationConfig.Builder
        getCodeCompilationConfigBuilder() {
      bitField0_ |= 0x00000010;
      onChanged();
      return getCodeCompilationConfigFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Immutable. If set, fields of `code_compilation_config` override the default
     * compilation settings that are specified in dataform.json.
     * </pre>
     *
     * <code>
     * .google.cloud.dataform.v1.CodeCompilationConfig code_compilation_config = 4 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public com.google.cloud.dataform.v1.CodeCompilationConfigOrBuilder
        getCodeCompilationConfigOrBuilder() {
      if (codeCompilationConfigBuilder_ != null) {
        return codeCompilationConfigBuilder_.getMessageOrBuilder();
      } else {
        return codeCompilationConfig_ == null
            ? com.google.cloud.dataform.v1.CodeCompilationConfig.getDefaultInstance()
            : codeCompilationConfig_;
      }
    }

    /**
     *
     *
     * <pre>
     * Immutable. If set, fields of `code_compilation_config` override the default
     * compilation settings that are specified in dataform.json.
     * </pre>
     *
     * <code>
     * .google.cloud.dataform.v1.CodeCompilationConfig code_compilation_config = 4 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dataform.v1.CodeCompilationConfig,
            com.google.cloud.dataform.v1.CodeCompilationConfig.Builder,
            com.google.cloud.dataform.v1.CodeCompilationConfigOrBuilder>
        getCodeCompilationConfigFieldBuilder() {
      if (codeCompilationConfigBuilder_ == null) {
        codeCompilationConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dataform.v1.CodeCompilationConfig,
                com.google.cloud.dataform.v1.CodeCompilationConfig.Builder,
                com.google.cloud.dataform.v1.CodeCompilationConfigOrBuilder>(
                getCodeCompilationConfig(), getParentForChildren(), isClean());
        codeCompilationConfig_ = null;
      }
      return codeCompilationConfigBuilder_;
    }

    private java.lang.Object resolvedGitCommitSha_ = "";

    /**
     *
     *
     * <pre>
     * Output only. The fully resolved Git commit SHA of the code that was
     * compiled. Not set for compilation results whose source is a workspace.
     * </pre>
     *
     * <code>string resolved_git_commit_sha = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The resolvedGitCommitSha.
     */
    public java.lang.String getResolvedGitCommitSha() {
      java.lang.Object ref = resolvedGitCommitSha_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        resolvedGitCommitSha_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. The fully resolved Git commit SHA of the code that was
     * compiled. Not set for compilation results whose source is a workspace.
     * </pre>
     *
     * <code>string resolved_git_commit_sha = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for resolvedGitCommitSha.
     */
    public com.google.protobuf.ByteString getResolvedGitCommitShaBytes() {
      java.lang.Object ref = resolvedGitCommitSha_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        resolvedGitCommitSha_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. The fully resolved Git commit SHA of the code that was
     * compiled. Not set for compilation results whose source is a workspace.
     * </pre>
     *
     * <code>string resolved_git_commit_sha = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The resolvedGitCommitSha to set.
     * @return This builder for chaining.
     */
    public Builder setResolvedGitCommitSha(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      resolvedGitCommitSha_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The fully resolved Git commit SHA of the code that was
     * compiled. Not set for compilation results whose source is a workspace.
     * </pre>
     *
     * <code>string resolved_git_commit_sha = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearResolvedGitCommitSha() {
      resolvedGitCommitSha_ = getDefaultInstance().getResolvedGitCommitSha();
      bitField0_ = (bitField0_ & ~0x00000020);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The fully resolved Git commit SHA of the code that was
     * compiled. Not set for compilation results whose source is a workspace.
     * </pre>
     *
     * <code>string resolved_git_commit_sha = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for resolvedGitCommitSha to set.
     * @return This builder for chaining.
     */
    public Builder setResolvedGitCommitShaBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      resolvedGitCommitSha_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    private java.lang.Object dataformCoreVersion_ = "";

    /**
     *
     *
     * <pre>
     * Output only. The version of `&#64;dataform/core` that was used for compilation.
     * </pre>
     *
     * <code>string dataform_core_version = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The dataformCoreVersion.
     */
    public java.lang.String getDataformCoreVersion() {
      java.lang.Object ref = dataformCoreVersion_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        dataformCoreVersion_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. The version of `&#64;dataform/core` that was used for compilation.
     * </pre>
     *
     * <code>string dataform_core_version = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for dataformCoreVersion.
     */
    public com.google.protobuf.ByteString getDataformCoreVersionBytes() {
      java.lang.Object ref = dataformCoreVersion_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        dataformCoreVersion_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. The version of `&#64;dataform/core` that was used for compilation.
     * </pre>
     *
     * <code>string dataform_core_version = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The dataformCoreVersion to set.
     * @return This builder for chaining.
     */
    public Builder setDataformCoreVersion(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      dataformCoreVersion_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The version of `&#64;dataform/core` that was used for compilation.
     * </pre>
     *
     * <code>string dataform_core_version = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDataformCoreVersion() {
      dataformCoreVersion_ = getDefaultInstance().getDataformCoreVersion();
      bitField0_ = (bitField0_ & ~0x00000040);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The version of `&#64;dataform/core` that was used for compilation.
     * </pre>
     *
     * <code>string dataform_core_version = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for dataformCoreVersion to set.
     * @return This builder for chaining.
     */
    public Builder setDataformCoreVersionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      dataformCoreVersion_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.dataform.v1.CompilationResult.CompilationError>
        compilationErrors_ = java.util.Collections.emptyList();

    private void ensureCompilationErrorsIsMutable() {
      if (!((bitField0_ & 0x00000080) != 0)) {
        compilationErrors_ =
            new java.util.ArrayList<
                com.google.cloud.dataform.v1.CompilationResult.CompilationError>(
                compilationErrors_);
        bitField0_ |= 0x00000080;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.dataform.v1.CompilationResult.CompilationError,
            com.google.cloud.dataform.v1.CompilationResult.CompilationError.Builder,
            com.google.cloud.dataform.v1.CompilationResult.CompilationErrorOrBuilder>
        compilationErrorsBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. Errors encountered during project compilation.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataform.v1.CompilationResult.CompilationError compilation_errors = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<com.google.cloud.dataform.v1.CompilationResult.CompilationError>
        getCompilationErrorsList() {
      if (compilationErrorsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(compilationErrors_);
      } else {
        return compilationErrorsBuilder_.getMessageList();
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Errors encountered during project compilation.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataform.v1.CompilationResult.CompilationError compilation_errors = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public int getCompilationErrorsCount() {
      if (compilationErrorsBuilder_ == null) {
        return compilationErrors_.size();
      } else {
        return compilationErrorsBuilder_.getCount();
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Errors encountered during project compilation.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataform.v1.CompilationResult.CompilationError compilation_errors = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.dataform.v1.CompilationResult.CompilationError getCompilationErrors(
        int index) {
      if (compilationErrorsBuilder_ == null) {
        return compilationErrors_.get(index);
      } else {
        return compilationErrorsBuilder_.getMessage(index);
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Errors encountered during project compilation.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataform.v1.CompilationResult.CompilationError compilation_errors = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCompilationErrors(
        int index, com.google.cloud.dataform.v1.CompilationResult.CompilationError value) {
      if (compilationErrorsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureCompilationErrorsIsMutable();
        compilationErrors_.set(index, value);
        onChanged();
      } else {
        compilationErrorsBuilder_.setMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Errors encountered during project compilation.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataform.v1.CompilationResult.CompilationError compilation_errors = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCompilationErrors(
        int index,
        com.google.cloud.dataform.v1.CompilationResult.CompilationError.Builder builderForValue) {
      if (compilationErrorsBuilder_ == null) {
        ensureCompilationErrorsIsMutable();
        compilationErrors_.set(index, builderForValue.build());
        onChanged();
      } else {
        compilationErrorsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Errors encountered during project compilation.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataform.v1.CompilationResult.CompilationError compilation_errors = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addCompilationErrors(
        com.google.cloud.dataform.v1.CompilationResult.CompilationError value) {
      if (compilationErrorsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureCompilationErrorsIsMutable();
        compilationErrors_.add(value);
        onChanged();
      } else {
        compilationErrorsBuilder_.addMessage(value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Errors encountered during project compilation.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataform.v1.CompilationResult.CompilationError compilation_errors = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addCompilationErrors(
        int index, com.google.cloud.dataform.v1.CompilationResult.CompilationError value) {
      if (compilationErrorsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureCompilationErrorsIsMutable();
        compilationErrors_.add(index, value);
        onChanged();
      } else {
        compilationErrorsBuilder_.addMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Errors encountered during project compilation.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataform.v1.CompilationResult.CompilationError compilation_errors = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addCompilationErrors(
        com.google.cloud.dataform.v1.CompilationResult.CompilationError.Builder builderForValue) {
      if (compilationErrorsBuilder_ == null) {
        ensureCompilationErrorsIsMutable();
        compilationErrors_.add(builderForValue.build());
        onChanged();
      } else {
        compilationErrorsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Errors encountered during project compilation.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataform.v1.CompilationResult.CompilationError compilation_errors = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addCompilationErrors(
        int index,
        com.google.cloud.dataform.v1.CompilationResult.CompilationError.Builder builderForValue) {
      if (compilationErrorsBuilder_ == null) {
        ensureCompilationErrorsIsMutable();
        compilationErrors_.add(index, builderForValue.build());
        onChanged();
      } else {
        compilationErrorsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Errors encountered during project compilation.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataform.v1.CompilationResult.CompilationError compilation_errors = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addAllCompilationErrors(
        java.lang.Iterable<
                ? extends com.google.cloud.dataform.v1.CompilationResult.CompilationError>
            values) {
      if (compilationErrorsBuilder_ == null) {
        ensureCompilationErrorsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, compilationErrors_);
        onChanged();
      } else {
        compilationErrorsBuilder_.addAllMessages(values);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Errors encountered during project compilation.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataform.v1.CompilationResult.CompilationError compilation_errors = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearCompilationErrors() {
      if (compilationErrorsBuilder_ == null) {
        compilationErrors_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000080);
        onChanged();
      } else {
        compilationErrorsBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Errors encountered during project compilation.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataform.v1.CompilationResult.CompilationError compilation_errors = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder removeCompilationErrors(int index) {
      if (compilationErrorsBuilder_ == null) {
        ensureCompilationErrorsIsMutable();
        compilationErrors_.remove(index);
        onChanged();
      } else {
        compilationErrorsBuilder_.remove(index);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Errors encountered during project compilation.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataform.v1.CompilationResult.CompilationError compilation_errors = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.dataform.v1.CompilationResult.CompilationError.Builder
        getCompilationErrorsBuilder(int index) {
      return getCompilationErrorsFieldBuilder().getBuilder(index);
    }

    /**
     *
     *
     * <pre>
     * Output only. Errors encountered during project compilation.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataform.v1.CompilationResult.CompilationError compilation_errors = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.dataform.v1.CompilationResult.CompilationErrorOrBuilder
        getCompilationErrorsOrBuilder(int index) {
      if (compilationErrorsBuilder_ == null) {
        return compilationErrors_.get(index);
      } else {
        return compilationErrorsBuilder_.getMessageOrBuilder(index);
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Errors encountered during project compilation.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataform.v1.CompilationResult.CompilationError compilation_errors = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<
            ? extends com.google.cloud.dataform.v1.CompilationResult.CompilationErrorOrBuilder>
        getCompilationErrorsOrBuilderList() {
      if (compilationErrorsBuilder_ != null) {
        return compilationErrorsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(compilationErrors_);
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Errors encountered during project compilation.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataform.v1.CompilationResult.CompilationError compilation_errors = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.dataform.v1.CompilationResult.CompilationError.Builder
        addCompilationErrorsBuilder() {
      return getCompilationErrorsFieldBuilder()
          .addBuilder(
              com.google.cloud.dataform.v1.CompilationResult.CompilationError.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * Output only. Errors encountered during project compilation.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataform.v1.CompilationResult.CompilationError compilation_errors = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.dataform.v1.CompilationResult.CompilationError.Builder
        addCompilationErrorsBuilder(int index) {
      return getCompilationErrorsFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.dataform.v1.CompilationResult.CompilationError.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * Output only. Errors encountered during project compilation.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataform.v1.CompilationResult.CompilationError compilation_errors = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<com.google.cloud.dataform.v1.CompilationResult.CompilationError.Builder>
        getCompilationErrorsBuilderList() {
      return getCompilationErrorsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.dataform.v1.CompilationResult.CompilationError,
            com.google.cloud.dataform.v1.CompilationResult.CompilationError.Builder,
            com.google.cloud.dataform.v1.CompilationResult.CompilationErrorOrBuilder>
        getCompilationErrorsFieldBuilder() {
      if (compilationErrorsBuilder_ == null) {
        compilationErrorsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.dataform.v1.CompilationResult.CompilationError,
                com.google.cloud.dataform.v1.CompilationResult.CompilationError.Builder,
                com.google.cloud.dataform.v1.CompilationResult.CompilationErrorOrBuilder>(
                compilationErrors_,
                ((bitField0_ & 0x00000080) != 0),
                getParentForChildren(),
                isClean());
        compilationErrors_ = null;
      }
      return compilationErrorsBuilder_;
    }

    private com.google.cloud.dataform.v1.DataEncryptionState dataEncryptionState_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dataform.v1.DataEncryptionState,
            com.google.cloud.dataform.v1.DataEncryptionState.Builder,
            com.google.cloud.dataform.v1.DataEncryptionStateOrBuilder>
        dataEncryptionStateBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. Only set if the repository has a KMS Key.
     * </pre>
     *
     * <code>
     * .google.cloud.dataform.v1.DataEncryptionState data_encryption_state = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the dataEncryptionState field is set.
     */
    public boolean hasDataEncryptionState() {
      return ((bitField0_ & 0x00000100) != 0);
    }

    /**
     *
     *
     * <pre>
     * Output only. Only set if the repository has a KMS Key.
     * </pre>
     *
     * <code>
     * .google.cloud.dataform.v1.DataEncryptionState data_encryption_state = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The dataEncryptionState.
     */
    public com.google.cloud.dataform.v1.DataEncryptionState getDataEncryptionState() {
      if (dataEncryptionStateBuilder_ == null) {
        return dataEncryptionState_ == null
            ? com.google.cloud.dataform.v1.DataEncryptionState.getDefaultInstance()
            : dataEncryptionState_;
      } else {
        return dataEncryptionStateBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Only set if the repository has a KMS Key.
     * </pre>
     *
     * <code>
     * .google.cloud.dataform.v1.DataEncryptionState data_encryption_state = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setDataEncryptionState(com.google.cloud.dataform.v1.DataEncryptionState value) {
      if (dataEncryptionStateBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        dataEncryptionState_ = value;
      } else {
        dataEncryptionStateBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Only set if the repository has a KMS Key.
     * </pre>
     *
     * <code>
     * .google.cloud.dataform.v1.DataEncryptionState data_encryption_state = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setDataEncryptionState(
        com.google.cloud.dataform.v1.DataEncryptionState.Builder builderForValue) {
      if (dataEncryptionStateBuilder_ == null) {
        dataEncryptionState_ = builderForValue.build();
      } else {
        dataEncryptionStateBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Only set if the repository has a KMS Key.
     * </pre>
     *
     * <code>
     * .google.cloud.dataform.v1.DataEncryptionState data_encryption_state = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeDataEncryptionState(
        com.google.cloud.dataform.v1.DataEncryptionState value) {
      if (dataEncryptionStateBuilder_ == null) {
        if (((bitField0_ & 0x00000100) != 0)
            && dataEncryptionState_ != null
            && dataEncryptionState_
                != com.google.cloud.dataform.v1.DataEncryptionState.getDefaultInstance()) {
          getDataEncryptionStateBuilder().mergeFrom(value);
        } else {
          dataEncryptionState_ = value;
        }
      } else {
        dataEncryptionStateBuilder_.mergeFrom(value);
      }
      if (dataEncryptionState_ != null) {
        bitField0_ |= 0x00000100;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Only set if the repository has a KMS Key.
     * </pre>
     *
     * <code>
     * .google.cloud.dataform.v1.DataEncryptionState data_encryption_state = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearDataEncryptionState() {
      bitField0_ = (bitField0_ & ~0x00000100);
      dataEncryptionState_ = null;
      if (dataEncryptionStateBuilder_ != null) {
        dataEncryptionStateBuilder_.dispose();
        dataEncryptionStateBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Only set if the repository has a KMS Key.
     * </pre>
     *
     * <code>
     * .google.cloud.dataform.v1.DataEncryptionState data_encryption_state = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.dataform.v1.DataEncryptionState.Builder
        getDataEncryptionStateBuilder() {
      bitField0_ |= 0x00000100;
      onChanged();
      return getDataEncryptionStateFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Output only. Only set if the repository has a KMS Key.
     * </pre>
     *
     * <code>
     * .google.cloud.dataform.v1.DataEncryptionState data_encryption_state = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.dataform.v1.DataEncryptionStateOrBuilder
        getDataEncryptionStateOrBuilder() {
      if (dataEncryptionStateBuilder_ != null) {
        return dataEncryptionStateBuilder_.getMessageOrBuilder();
      } else {
        return dataEncryptionState_ == null
            ? com.google.cloud.dataform.v1.DataEncryptionState.getDefaultInstance()
            : dataEncryptionState_;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Only set if the repository has a KMS Key.
     * </pre>
     *
     * <code>
     * .google.cloud.dataform.v1.DataEncryptionState data_encryption_state = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dataform.v1.DataEncryptionState,
            com.google.cloud.dataform.v1.DataEncryptionState.Builder,
            com.google.cloud.dataform.v1.DataEncryptionStateOrBuilder>
        getDataEncryptionStateFieldBuilder() {
      if (dataEncryptionStateBuilder_ == null) {
        dataEncryptionStateBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dataform.v1.DataEncryptionState,
                com.google.cloud.dataform.v1.DataEncryptionState.Builder,
                com.google.cloud.dataform.v1.DataEncryptionStateOrBuilder>(
                getDataEncryptionState(), getParentForChildren(), isClean());
        dataEncryptionState_ = null;
      }
      return dataEncryptionStateBuilder_;
    }

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. The timestamp of when the compilation result was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return ((bitField0_ & 0x00000200) != 0);
    }

    /**
     *
     *
     * <pre>
     * Output only. The timestamp of when the compilation result was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. The timestamp of when the compilation result was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
      } else {
        createTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The timestamp of when the compilation result was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The timestamp of when the compilation result was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000200) != 0)
            && createTime_ != null
            && createTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getCreateTimeBuilder().mergeFrom(value);
        } else {
          createTime_ = value;
        }
      } else {
        createTimeBuilder_.mergeFrom(value);
      }
      if (createTime_ != null) {
        bitField0_ |= 0x00000200;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The timestamp of when the compilation result was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearCreateTime() {
      bitField0_ = (bitField0_ & ~0x00000200);
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The timestamp of when the compilation result was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {
      bitField0_ |= 0x00000200;
      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Output only. The timestamp of when the compilation result was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. The timestamp of when the compilation result was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private java.lang.Object internalMetadata_ = "";

    /**
     *
     *
     * <pre>
     * Output only. All the metadata information that is used internally to serve
     * the resource. For example: timestamps, flags, status fields, etc. The
     * format of this field is a JSON string.
     * </pre>
     *
     * <code>optional string internal_metadata = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the internalMetadata field is set.
     */
    public boolean hasInternalMetadata() {
      return ((bitField0_ & 0x00000400) != 0);
    }

    /**
     *
     *
     * <pre>
     * Output only. All the metadata information that is used internally to serve
     * the resource. For example: timestamps, flags, status fields, etc. The
     * format of this field is a JSON string.
     * </pre>
     *
     * <code>optional string internal_metadata = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The internalMetadata.
     */
    public java.lang.String getInternalMetadata() {
      java.lang.Object ref = internalMetadata_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        internalMetadata_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. All the metadata information that is used internally to serve
     * the resource. For example: timestamps, flags, status fields, etc. The
     * format of this field is a JSON string.
     * </pre>
     *
     * <code>optional string internal_metadata = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The bytes for internalMetadata.
     */
    public com.google.protobuf.ByteString getInternalMetadataBytes() {
      java.lang.Object ref = internalMetadata_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        internalMetadata_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. All the metadata information that is used internally to serve
     * the resource. For example: timestamps, flags, status fields, etc. The
     * format of this field is a JSON string.
     * </pre>
     *
     * <code>optional string internal_metadata = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The internalMetadata to set.
     * @return This builder for chaining.
     */
    public Builder setInternalMetadata(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      internalMetadata_ = value;
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. All the metadata information that is used internally to serve
     * the resource. For example: timestamps, flags, status fields, etc. The
     * format of this field is a JSON string.
     * </pre>
     *
     * <code>optional string internal_metadata = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearInternalMetadata() {
      internalMetadata_ = getDefaultInstance().getInternalMetadata();
      bitField0_ = (bitField0_ & ~0x00000400);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. All the metadata information that is used internally to serve
     * the resource. For example: timestamps, flags, status fields, etc. The
     * format of this field is a JSON string.
     * </pre>
     *
     * <code>optional string internal_metadata = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The bytes for internalMetadata to set.
     * @return This builder for chaining.
     */
    public Builder setInternalMetadataBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      internalMetadata_ = value;
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.dataform.v1.CompilationResult)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.dataform.v1.CompilationResult)
  private static final com.google.cloud.dataform.v1.CompilationResult DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.dataform.v1.CompilationResult();
  }

  public static com.google.cloud.dataform.v1.CompilationResult getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<CompilationResult> PARSER =
      new com.google.protobuf.AbstractParser<CompilationResult>() {
        @java.lang.Override
        public CompilationResult parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<CompilationResult> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<CompilationResult> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.dataform.v1.CompilationResult getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
