/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/bigquery/storage/v1/storage.proto

// Protobuf Java Version: 3.25.8
package com.google.cloud.bigquery.storage.v1;

/**
 *
 *
 * <pre>
 * Request message for `AppendRows`.
 *
 * Because AppendRows is a bidirectional streaming RPC, certain parts of the
 * AppendRowsRequest need only be specified for the first request before
 * switching table destinations. You can also switch table destinations within
 * the same connection for the default stream.
 *
 * The size of a single AppendRowsRequest must be less than 10 MB in size.
 * Requests larger than this return an error, typically `INVALID_ARGUMENT`.
 * </pre>
 *
 * Protobuf type {@code google.cloud.bigquery.storage.v1.AppendRowsRequest}
 */
public final class AppendRowsRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.bigquery.storage.v1.AppendRowsRequest)
    AppendRowsRequestOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use AppendRowsRequest.newBuilder() to construct.
  private AppendRowsRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private AppendRowsRequest() {
    writeStream_ = "";
    traceId_ = "";
    defaultMissingValueInterpretation_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new AppendRowsRequest();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.bigquery.storage.v1.StorageProto
        .internal_static_google_cloud_bigquery_storage_v1_AppendRowsRequest_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
      int number) {
    switch (number) {
      case 7:
        return internalGetMissingValueInterpretations();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.bigquery.storage.v1.StorageProto
        .internal_static_google_cloud_bigquery_storage_v1_AppendRowsRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.bigquery.storage.v1.AppendRowsRequest.class,
            com.google.cloud.bigquery.storage.v1.AppendRowsRequest.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * An enum to indicate how to interpret missing values of fields that are
   * present in user schema but missing in rows. A missing value can represent a
   * NULL or a column default value defined in BigQuery table schema.
   * </pre>
   *
   * Protobuf enum {@code
   * google.cloud.bigquery.storage.v1.AppendRowsRequest.MissingValueInterpretation}
   */
  public enum MissingValueInterpretation implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Invalid missing value interpretation. Requests with this value will be
     * rejected.
     * </pre>
     *
     * <code>MISSING_VALUE_INTERPRETATION_UNSPECIFIED = 0;</code>
     */
    MISSING_VALUE_INTERPRETATION_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Missing value is interpreted as NULL.
     * </pre>
     *
     * <code>NULL_VALUE = 1;</code>
     */
    NULL_VALUE(1),
    /**
     *
     *
     * <pre>
     * Missing value is interpreted as column default value if declared in the
     * table schema, NULL otherwise.
     * </pre>
     *
     * <code>DEFAULT_VALUE = 2;</code>
     */
    DEFAULT_VALUE(2),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Invalid missing value interpretation. Requests with this value will be
     * rejected.
     * </pre>
     *
     * <code>MISSING_VALUE_INTERPRETATION_UNSPECIFIED = 0;</code>
     */
    public static final int MISSING_VALUE_INTERPRETATION_UNSPECIFIED_VALUE = 0;

    /**
     *
     *
     * <pre>
     * Missing value is interpreted as NULL.
     * </pre>
     *
     * <code>NULL_VALUE = 1;</code>
     */
    public static final int NULL_VALUE_VALUE = 1;

    /**
     *
     *
     * <pre>
     * Missing value is interpreted as column default value if declared in the
     * table schema, NULL otherwise.
     * </pre>
     *
     * <code>DEFAULT_VALUE = 2;</code>
     */
    public static final int DEFAULT_VALUE_VALUE = 2;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static MissingValueInterpretation valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static MissingValueInterpretation forNumber(int value) {
      switch (value) {
        case 0:
          return MISSING_VALUE_INTERPRETATION_UNSPECIFIED;
        case 1:
          return NULL_VALUE;
        case 2:
          return DEFAULT_VALUE;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<MissingValueInterpretation>
        internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<MissingValueInterpretation>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<MissingValueInterpretation>() {
              public MissingValueInterpretation findValueByNumber(int number) {
                return MissingValueInterpretation.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.bigquery.storage.v1.AppendRowsRequest.getDescriptor()
          .getEnumTypes()
          .get(0);
    }

    private static final MissingValueInterpretation[] VALUES = values();

    public static MissingValueInterpretation valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private MissingValueInterpretation(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.bigquery.storage.v1.AppendRowsRequest.MissingValueInterpretation)
  }

  public interface ArrowDataOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.bigquery.storage.v1.AppendRowsRequest.ArrowData)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Optional. Arrow Schema used to serialize the data.
     * </pre>
     *
     * <code>.google.cloud.bigquery.storage.v1.ArrowSchema writer_schema = 1;</code>
     *
     * @return Whether the writerSchema field is set.
     */
    boolean hasWriterSchema();

    /**
     *
     *
     * <pre>
     * Optional. Arrow Schema used to serialize the data.
     * </pre>
     *
     * <code>.google.cloud.bigquery.storage.v1.ArrowSchema writer_schema = 1;</code>
     *
     * @return The writerSchema.
     */
    com.google.cloud.bigquery.storage.v1.ArrowSchema getWriterSchema();

    /**
     *
     *
     * <pre>
     * Optional. Arrow Schema used to serialize the data.
     * </pre>
     *
     * <code>.google.cloud.bigquery.storage.v1.ArrowSchema writer_schema = 1;</code>
     */
    com.google.cloud.bigquery.storage.v1.ArrowSchemaOrBuilder getWriterSchemaOrBuilder();

    /**
     *
     *
     * <pre>
     * Required. Serialized row data in Arrow format.
     * </pre>
     *
     * <code>.google.cloud.bigquery.storage.v1.ArrowRecordBatch rows = 2;</code>
     *
     * @return Whether the rows field is set.
     */
    boolean hasRows();

    /**
     *
     *
     * <pre>
     * Required. Serialized row data in Arrow format.
     * </pre>
     *
     * <code>.google.cloud.bigquery.storage.v1.ArrowRecordBatch rows = 2;</code>
     *
     * @return The rows.
     */
    com.google.cloud.bigquery.storage.v1.ArrowRecordBatch getRows();

    /**
     *
     *
     * <pre>
     * Required. Serialized row data in Arrow format.
     * </pre>
     *
     * <code>.google.cloud.bigquery.storage.v1.ArrowRecordBatch rows = 2;</code>
     */
    com.google.cloud.bigquery.storage.v1.ArrowRecordBatchOrBuilder getRowsOrBuilder();
  }

  /**
   *
   *
   * <pre>
   * Arrow schema and data.
   * </pre>
   *
   * Protobuf type {@code google.cloud.bigquery.storage.v1.AppendRowsRequest.ArrowData}
   */
  public static final class ArrowData extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.bigquery.storage.v1.AppendRowsRequest.ArrowData)
      ArrowDataOrBuilder {
    private static final long serialVersionUID = 0L;

    // Use ArrowData.newBuilder() to construct.
    private ArrowData(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private ArrowData() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new ArrowData();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.bigquery.storage.v1.StorageProto
          .internal_static_google_cloud_bigquery_storage_v1_AppendRowsRequest_ArrowData_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.bigquery.storage.v1.StorageProto
          .internal_static_google_cloud_bigquery_storage_v1_AppendRowsRequest_ArrowData_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.bigquery.storage.v1.AppendRowsRequest.ArrowData.class,
              com.google.cloud.bigquery.storage.v1.AppendRowsRequest.ArrowData.Builder.class);
    }

    private int bitField0_;
    public static final int WRITER_SCHEMA_FIELD_NUMBER = 1;
    private com.google.cloud.bigquery.storage.v1.ArrowSchema writerSchema_;

    /**
     *
     *
     * <pre>
     * Optional. Arrow Schema used to serialize the data.
     * </pre>
     *
     * <code>.google.cloud.bigquery.storage.v1.ArrowSchema writer_schema = 1;</code>
     *
     * @return Whether the writerSchema field is set.
     */
    @java.lang.Override
    public boolean hasWriterSchema() {
      return ((bitField0_ & 0x00000001) != 0);
    }

    /**
     *
     *
     * <pre>
     * Optional. Arrow Schema used to serialize the data.
     * </pre>
     *
     * <code>.google.cloud.bigquery.storage.v1.ArrowSchema writer_schema = 1;</code>
     *
     * @return The writerSchema.
     */
    @java.lang.Override
    public com.google.cloud.bigquery.storage.v1.ArrowSchema getWriterSchema() {
      return writerSchema_ == null
          ? com.google.cloud.bigquery.storage.v1.ArrowSchema.getDefaultInstance()
          : writerSchema_;
    }

    /**
     *
     *
     * <pre>
     * Optional. Arrow Schema used to serialize the data.
     * </pre>
     *
     * <code>.google.cloud.bigquery.storage.v1.ArrowSchema writer_schema = 1;</code>
     */
    @java.lang.Override
    public com.google.cloud.bigquery.storage.v1.ArrowSchemaOrBuilder getWriterSchemaOrBuilder() {
      return writerSchema_ == null
          ? com.google.cloud.bigquery.storage.v1.ArrowSchema.getDefaultInstance()
          : writerSchema_;
    }

    public static final int ROWS_FIELD_NUMBER = 2;
    private com.google.cloud.bigquery.storage.v1.ArrowRecordBatch rows_;

    /**
     *
     *
     * <pre>
     * Required. Serialized row data in Arrow format.
     * </pre>
     *
     * <code>.google.cloud.bigquery.storage.v1.ArrowRecordBatch rows = 2;</code>
     *
     * @return Whether the rows field is set.
     */
    @java.lang.Override
    public boolean hasRows() {
      return ((bitField0_ & 0x00000002) != 0);
    }

    /**
     *
     *
     * <pre>
     * Required. Serialized row data in Arrow format.
     * </pre>
     *
     * <code>.google.cloud.bigquery.storage.v1.ArrowRecordBatch rows = 2;</code>
     *
     * @return The rows.
     */
    @java.lang.Override
    public com.google.cloud.bigquery.storage.v1.ArrowRecordBatch getRows() {
      return rows_ == null
          ? com.google.cloud.bigquery.storage.v1.ArrowRecordBatch.getDefaultInstance()
          : rows_;
    }

    /**
     *
     *
     * <pre>
     * Required. Serialized row data in Arrow format.
     * </pre>
     *
     * <code>.google.cloud.bigquery.storage.v1.ArrowRecordBatch rows = 2;</code>
     */
    @java.lang.Override
    public com.google.cloud.bigquery.storage.v1.ArrowRecordBatchOrBuilder getRowsOrBuilder() {
      return rows_ == null
          ? com.google.cloud.bigquery.storage.v1.ArrowRecordBatch.getDefaultInstance()
          : rows_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(1, getWriterSchema());
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        output.writeMessage(2, getRows());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getWriterSchema());
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getRows());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.bigquery.storage.v1.AppendRowsRequest.ArrowData)) {
        return super.equals(obj);
      }
      com.google.cloud.bigquery.storage.v1.AppendRowsRequest.ArrowData other =
          (com.google.cloud.bigquery.storage.v1.AppendRowsRequest.ArrowData) obj;

      if (hasWriterSchema() != other.hasWriterSchema()) return false;
      if (hasWriterSchema()) {
        if (!getWriterSchema().equals(other.getWriterSchema())) return false;
      }
      if (hasRows() != other.hasRows()) return false;
      if (hasRows()) {
        if (!getRows().equals(other.getRows())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasWriterSchema()) {
        hash = (37 * hash) + WRITER_SCHEMA_FIELD_NUMBER;
        hash = (53 * hash) + getWriterSchema().hashCode();
      }
      if (hasRows()) {
        hash = (37 * hash) + ROWS_FIELD_NUMBER;
        hash = (53 * hash) + getRows().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.bigquery.storage.v1.AppendRowsRequest.ArrowData parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.bigquery.storage.v1.AppendRowsRequest.ArrowData parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.bigquery.storage.v1.AppendRowsRequest.ArrowData parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.bigquery.storage.v1.AppendRowsRequest.ArrowData parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.bigquery.storage.v1.AppendRowsRequest.ArrowData parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.bigquery.storage.v1.AppendRowsRequest.ArrowData parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.bigquery.storage.v1.AppendRowsRequest.ArrowData parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.bigquery.storage.v1.AppendRowsRequest.ArrowData parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.bigquery.storage.v1.AppendRowsRequest.ArrowData
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.bigquery.storage.v1.AppendRowsRequest.ArrowData
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.bigquery.storage.v1.AppendRowsRequest.ArrowData parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.bigquery.storage.v1.AppendRowsRequest.ArrowData parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.bigquery.storage.v1.AppendRowsRequest.ArrowData prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * Arrow schema and data.
     * </pre>
     *
     * Protobuf type {@code google.cloud.bigquery.storage.v1.AppendRowsRequest.ArrowData}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.bigquery.storage.v1.AppendRowsRequest.ArrowData)
        com.google.cloud.bigquery.storage.v1.AppendRowsRequest.ArrowDataOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.bigquery.storage.v1.StorageProto
            .internal_static_google_cloud_bigquery_storage_v1_AppendRowsRequest_ArrowData_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.bigquery.storage.v1.StorageProto
            .internal_static_google_cloud_bigquery_storage_v1_AppendRowsRequest_ArrowData_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.bigquery.storage.v1.AppendRowsRequest.ArrowData.class,
                com.google.cloud.bigquery.storage.v1.AppendRowsRequest.ArrowData.Builder.class);
      }

      // Construct using
      // com.google.cloud.bigquery.storage.v1.AppendRowsRequest.ArrowData.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getWriterSchemaFieldBuilder();
          getRowsFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        writerSchema_ = null;
        if (writerSchemaBuilder_ != null) {
          writerSchemaBuilder_.dispose();
          writerSchemaBuilder_ = null;
        }
        rows_ = null;
        if (rowsBuilder_ != null) {
          rowsBuilder_.dispose();
          rowsBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.bigquery.storage.v1.StorageProto
            .internal_static_google_cloud_bigquery_storage_v1_AppendRowsRequest_ArrowData_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.bigquery.storage.v1.AppendRowsRequest.ArrowData
          getDefaultInstanceForType() {
        return com.google.cloud.bigquery.storage.v1.AppendRowsRequest.ArrowData
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.bigquery.storage.v1.AppendRowsRequest.ArrowData build() {
        com.google.cloud.bigquery.storage.v1.AppendRowsRequest.ArrowData result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.bigquery.storage.v1.AppendRowsRequest.ArrowData buildPartial() {
        com.google.cloud.bigquery.storage.v1.AppendRowsRequest.ArrowData result =
            new com.google.cloud.bigquery.storage.v1.AppendRowsRequest.ArrowData(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.bigquery.storage.v1.AppendRowsRequest.ArrowData result) {
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.writerSchema_ =
              writerSchemaBuilder_ == null ? writerSchema_ : writerSchemaBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.rows_ = rowsBuilder_ == null ? rows_ : rowsBuilder_.build();
          to_bitField0_ |= 0x00000002;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.bigquery.storage.v1.AppendRowsRequest.ArrowData) {
          return mergeFrom(
              (com.google.cloud.bigquery.storage.v1.AppendRowsRequest.ArrowData) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.bigquery.storage.v1.AppendRowsRequest.ArrowData other) {
        if (other
            == com.google.cloud.bigquery.storage.v1.AppendRowsRequest.ArrowData
                .getDefaultInstance()) return this;
        if (other.hasWriterSchema()) {
          mergeWriterSchema(other.getWriterSchema());
        }
        if (other.hasRows()) {
          mergeRows(other.getRows());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  input.readMessage(getWriterSchemaFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  input.readMessage(getRowsFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private com.google.cloud.bigquery.storage.v1.ArrowSchema writerSchema_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.bigquery.storage.v1.ArrowSchema,
              com.google.cloud.bigquery.storage.v1.ArrowSchema.Builder,
              com.google.cloud.bigquery.storage.v1.ArrowSchemaOrBuilder>
          writerSchemaBuilder_;

      /**
       *
       *
       * <pre>
       * Optional. Arrow Schema used to serialize the data.
       * </pre>
       *
       * <code>.google.cloud.bigquery.storage.v1.ArrowSchema writer_schema = 1;</code>
       *
       * @return Whether the writerSchema field is set.
       */
      public boolean hasWriterSchema() {
        return ((bitField0_ & 0x00000001) != 0);
      }

      /**
       *
       *
       * <pre>
       * Optional. Arrow Schema used to serialize the data.
       * </pre>
       *
       * <code>.google.cloud.bigquery.storage.v1.ArrowSchema writer_schema = 1;</code>
       *
       * @return The writerSchema.
       */
      public com.google.cloud.bigquery.storage.v1.ArrowSchema getWriterSchema() {
        if (writerSchemaBuilder_ == null) {
          return writerSchema_ == null
              ? com.google.cloud.bigquery.storage.v1.ArrowSchema.getDefaultInstance()
              : writerSchema_;
        } else {
          return writerSchemaBuilder_.getMessage();
        }
      }

      /**
       *
       *
       * <pre>
       * Optional. Arrow Schema used to serialize the data.
       * </pre>
       *
       * <code>.google.cloud.bigquery.storage.v1.ArrowSchema writer_schema = 1;</code>
       */
      public Builder setWriterSchema(com.google.cloud.bigquery.storage.v1.ArrowSchema value) {
        if (writerSchemaBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          writerSchema_ = value;
        } else {
          writerSchemaBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. Arrow Schema used to serialize the data.
       * </pre>
       *
       * <code>.google.cloud.bigquery.storage.v1.ArrowSchema writer_schema = 1;</code>
       */
      public Builder setWriterSchema(
          com.google.cloud.bigquery.storage.v1.ArrowSchema.Builder builderForValue) {
        if (writerSchemaBuilder_ == null) {
          writerSchema_ = builderForValue.build();
        } else {
          writerSchemaBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. Arrow Schema used to serialize the data.
       * </pre>
       *
       * <code>.google.cloud.bigquery.storage.v1.ArrowSchema writer_schema = 1;</code>
       */
      public Builder mergeWriterSchema(com.google.cloud.bigquery.storage.v1.ArrowSchema value) {
        if (writerSchemaBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)
              && writerSchema_ != null
              && writerSchema_
                  != com.google.cloud.bigquery.storage.v1.ArrowSchema.getDefaultInstance()) {
            getWriterSchemaBuilder().mergeFrom(value);
          } else {
            writerSchema_ = value;
          }
        } else {
          writerSchemaBuilder_.mergeFrom(value);
        }
        if (writerSchema_ != null) {
          bitField0_ |= 0x00000001;
          onChanged();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. Arrow Schema used to serialize the data.
       * </pre>
       *
       * <code>.google.cloud.bigquery.storage.v1.ArrowSchema writer_schema = 1;</code>
       */
      public Builder clearWriterSchema() {
        bitField0_ = (bitField0_ & ~0x00000001);
        writerSchema_ = null;
        if (writerSchemaBuilder_ != null) {
          writerSchemaBuilder_.dispose();
          writerSchemaBuilder_ = null;
        }
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. Arrow Schema used to serialize the data.
       * </pre>
       *
       * <code>.google.cloud.bigquery.storage.v1.ArrowSchema writer_schema = 1;</code>
       */
      public com.google.cloud.bigquery.storage.v1.ArrowSchema.Builder getWriterSchemaBuilder() {
        bitField0_ |= 0x00000001;
        onChanged();
        return getWriterSchemaFieldBuilder().getBuilder();
      }

      /**
       *
       *
       * <pre>
       * Optional. Arrow Schema used to serialize the data.
       * </pre>
       *
       * <code>.google.cloud.bigquery.storage.v1.ArrowSchema writer_schema = 1;</code>
       */
      public com.google.cloud.bigquery.storage.v1.ArrowSchemaOrBuilder getWriterSchemaOrBuilder() {
        if (writerSchemaBuilder_ != null) {
          return writerSchemaBuilder_.getMessageOrBuilder();
        } else {
          return writerSchema_ == null
              ? com.google.cloud.bigquery.storage.v1.ArrowSchema.getDefaultInstance()
              : writerSchema_;
        }
      }

      /**
       *
       *
       * <pre>
       * Optional. Arrow Schema used to serialize the data.
       * </pre>
       *
       * <code>.google.cloud.bigquery.storage.v1.ArrowSchema writer_schema = 1;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.bigquery.storage.v1.ArrowSchema,
              com.google.cloud.bigquery.storage.v1.ArrowSchema.Builder,
              com.google.cloud.bigquery.storage.v1.ArrowSchemaOrBuilder>
          getWriterSchemaFieldBuilder() {
        if (writerSchemaBuilder_ == null) {
          writerSchemaBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.bigquery.storage.v1.ArrowSchema,
                  com.google.cloud.bigquery.storage.v1.ArrowSchema.Builder,
                  com.google.cloud.bigquery.storage.v1.ArrowSchemaOrBuilder>(
                  getWriterSchema(), getParentForChildren(), isClean());
          writerSchema_ = null;
        }
        return writerSchemaBuilder_;
      }

      private com.google.cloud.bigquery.storage.v1.ArrowRecordBatch rows_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.bigquery.storage.v1.ArrowRecordBatch,
              com.google.cloud.bigquery.storage.v1.ArrowRecordBatch.Builder,
              com.google.cloud.bigquery.storage.v1.ArrowRecordBatchOrBuilder>
          rowsBuilder_;

      /**
       *
       *
       * <pre>
       * Required. Serialized row data in Arrow format.
       * </pre>
       *
       * <code>.google.cloud.bigquery.storage.v1.ArrowRecordBatch rows = 2;</code>
       *
       * @return Whether the rows field is set.
       */
      public boolean hasRows() {
        return ((bitField0_ & 0x00000002) != 0);
      }

      /**
       *
       *
       * <pre>
       * Required. Serialized row data in Arrow format.
       * </pre>
       *
       * <code>.google.cloud.bigquery.storage.v1.ArrowRecordBatch rows = 2;</code>
       *
       * @return The rows.
       */
      public com.google.cloud.bigquery.storage.v1.ArrowRecordBatch getRows() {
        if (rowsBuilder_ == null) {
          return rows_ == null
              ? com.google.cloud.bigquery.storage.v1.ArrowRecordBatch.getDefaultInstance()
              : rows_;
        } else {
          return rowsBuilder_.getMessage();
        }
      }

      /**
       *
       *
       * <pre>
       * Required. Serialized row data in Arrow format.
       * </pre>
       *
       * <code>.google.cloud.bigquery.storage.v1.ArrowRecordBatch rows = 2;</code>
       */
      public Builder setRows(com.google.cloud.bigquery.storage.v1.ArrowRecordBatch value) {
        if (rowsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          rows_ = value;
        } else {
          rowsBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Required. Serialized row data in Arrow format.
       * </pre>
       *
       * <code>.google.cloud.bigquery.storage.v1.ArrowRecordBatch rows = 2;</code>
       */
      public Builder setRows(
          com.google.cloud.bigquery.storage.v1.ArrowRecordBatch.Builder builderForValue) {
        if (rowsBuilder_ == null) {
          rows_ = builderForValue.build();
        } else {
          rowsBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Required. Serialized row data in Arrow format.
       * </pre>
       *
       * <code>.google.cloud.bigquery.storage.v1.ArrowRecordBatch rows = 2;</code>
       */
      public Builder mergeRows(com.google.cloud.bigquery.storage.v1.ArrowRecordBatch value) {
        if (rowsBuilder_ == null) {
          if (((bitField0_ & 0x00000002) != 0)
              && rows_ != null
              && rows_
                  != com.google.cloud.bigquery.storage.v1.ArrowRecordBatch.getDefaultInstance()) {
            getRowsBuilder().mergeFrom(value);
          } else {
            rows_ = value;
          }
        } else {
          rowsBuilder_.mergeFrom(value);
        }
        if (rows_ != null) {
          bitField0_ |= 0x00000002;
          onChanged();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Required. Serialized row data in Arrow format.
       * </pre>
       *
       * <code>.google.cloud.bigquery.storage.v1.ArrowRecordBatch rows = 2;</code>
       */
      public Builder clearRows() {
        bitField0_ = (bitField0_ & ~0x00000002);
        rows_ = null;
        if (rowsBuilder_ != null) {
          rowsBuilder_.dispose();
          rowsBuilder_ = null;
        }
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Required. Serialized row data in Arrow format.
       * </pre>
       *
       * <code>.google.cloud.bigquery.storage.v1.ArrowRecordBatch rows = 2;</code>
       */
      public com.google.cloud.bigquery.storage.v1.ArrowRecordBatch.Builder getRowsBuilder() {
        bitField0_ |= 0x00000002;
        onChanged();
        return getRowsFieldBuilder().getBuilder();
      }

      /**
       *
       *
       * <pre>
       * Required. Serialized row data in Arrow format.
       * </pre>
       *
       * <code>.google.cloud.bigquery.storage.v1.ArrowRecordBatch rows = 2;</code>
       */
      public com.google.cloud.bigquery.storage.v1.ArrowRecordBatchOrBuilder getRowsOrBuilder() {
        if (rowsBuilder_ != null) {
          return rowsBuilder_.getMessageOrBuilder();
        } else {
          return rows_ == null
              ? com.google.cloud.bigquery.storage.v1.ArrowRecordBatch.getDefaultInstance()
              : rows_;
        }
      }

      /**
       *
       *
       * <pre>
       * Required. Serialized row data in Arrow format.
       * </pre>
       *
       * <code>.google.cloud.bigquery.storage.v1.ArrowRecordBatch rows = 2;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.bigquery.storage.v1.ArrowRecordBatch,
              com.google.cloud.bigquery.storage.v1.ArrowRecordBatch.Builder,
              com.google.cloud.bigquery.storage.v1.ArrowRecordBatchOrBuilder>
          getRowsFieldBuilder() {
        if (rowsBuilder_ == null) {
          rowsBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.bigquery.storage.v1.ArrowRecordBatch,
                  com.google.cloud.bigquery.storage.v1.ArrowRecordBatch.Builder,
                  com.google.cloud.bigquery.storage.v1.ArrowRecordBatchOrBuilder>(
                  getRows(), getParentForChildren(), isClean());
          rows_ = null;
        }
        return rowsBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.bigquery.storage.v1.AppendRowsRequest.ArrowData)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.bigquery.storage.v1.AppendRowsRequest.ArrowData)
    private static final com.google.cloud.bigquery.storage.v1.AppendRowsRequest.ArrowData
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.bigquery.storage.v1.AppendRowsRequest.ArrowData();
    }

    public static com.google.cloud.bigquery.storage.v1.AppendRowsRequest.ArrowData
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<ArrowData> PARSER =
        new com.google.protobuf.AbstractParser<ArrowData>() {
          @java.lang.Override
          public ArrowData parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<ArrowData> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<ArrowData> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.bigquery.storage.v1.AppendRowsRequest.ArrowData
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface ProtoDataOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.bigquery.storage.v1.AppendRowsRequest.ProtoData)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Optional. The protocol buffer schema used to serialize the data. Provide
     * this value whenever:
     *
     * * You send the first request of an RPC connection.
     *
     * * You change the input schema.
     *
     * * You specify a new destination table.
     * </pre>
     *
     * <code>.google.cloud.bigquery.storage.v1.ProtoSchema writer_schema = 1;</code>
     *
     * @return Whether the writerSchema field is set.
     */
    boolean hasWriterSchema();

    /**
     *
     *
     * <pre>
     * Optional. The protocol buffer schema used to serialize the data. Provide
     * this value whenever:
     *
     * * You send the first request of an RPC connection.
     *
     * * You change the input schema.
     *
     * * You specify a new destination table.
     * </pre>
     *
     * <code>.google.cloud.bigquery.storage.v1.ProtoSchema writer_schema = 1;</code>
     *
     * @return The writerSchema.
     */
    com.google.cloud.bigquery.storage.v1.ProtoSchema getWriterSchema();

    /**
     *
     *
     * <pre>
     * Optional. The protocol buffer schema used to serialize the data. Provide
     * this value whenever:
     *
     * * You send the first request of an RPC connection.
     *
     * * You change the input schema.
     *
     * * You specify a new destination table.
     * </pre>
     *
     * <code>.google.cloud.bigquery.storage.v1.ProtoSchema writer_schema = 1;</code>
     */
    com.google.cloud.bigquery.storage.v1.ProtoSchemaOrBuilder getWriterSchemaOrBuilder();

    /**
     *
     *
     * <pre>
     * Required. Serialized row data in protobuf message format.
     * Currently, the backend expects the serialized rows to adhere to
     * proto2 semantics when appending rows, particularly with respect to
     * how default values are encoded.
     * </pre>
     *
     * <code>.google.cloud.bigquery.storage.v1.ProtoRows rows = 2;</code>
     *
     * @return Whether the rows field is set.
     */
    boolean hasRows();

    /**
     *
     *
     * <pre>
     * Required. Serialized row data in protobuf message format.
     * Currently, the backend expects the serialized rows to adhere to
     * proto2 semantics when appending rows, particularly with respect to
     * how default values are encoded.
     * </pre>
     *
     * <code>.google.cloud.bigquery.storage.v1.ProtoRows rows = 2;</code>
     *
     * @return The rows.
     */
    com.google.cloud.bigquery.storage.v1.ProtoRows getRows();

    /**
     *
     *
     * <pre>
     * Required. Serialized row data in protobuf message format.
     * Currently, the backend expects the serialized rows to adhere to
     * proto2 semantics when appending rows, particularly with respect to
     * how default values are encoded.
     * </pre>
     *
     * <code>.google.cloud.bigquery.storage.v1.ProtoRows rows = 2;</code>
     */
    com.google.cloud.bigquery.storage.v1.ProtoRowsOrBuilder getRowsOrBuilder();
  }

  /**
   *
   *
   * <pre>
   * ProtoData contains the data rows and schema when constructing append
   * requests.
   * </pre>
   *
   * Protobuf type {@code google.cloud.bigquery.storage.v1.AppendRowsRequest.ProtoData}
   */
  public static final class ProtoData extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.bigquery.storage.v1.AppendRowsRequest.ProtoData)
      ProtoDataOrBuilder {
    private static final long serialVersionUID = 0L;

    // Use ProtoData.newBuilder() to construct.
    private ProtoData(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private ProtoData() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new ProtoData();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.bigquery.storage.v1.StorageProto
          .internal_static_google_cloud_bigquery_storage_v1_AppendRowsRequest_ProtoData_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.bigquery.storage.v1.StorageProto
          .internal_static_google_cloud_bigquery_storage_v1_AppendRowsRequest_ProtoData_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.bigquery.storage.v1.AppendRowsRequest.ProtoData.class,
              com.google.cloud.bigquery.storage.v1.AppendRowsRequest.ProtoData.Builder.class);
    }

    private int bitField0_;
    public static final int WRITER_SCHEMA_FIELD_NUMBER = 1;
    private com.google.cloud.bigquery.storage.v1.ProtoSchema writerSchema_;

    /**
     *
     *
     * <pre>
     * Optional. The protocol buffer schema used to serialize the data. Provide
     * this value whenever:
     *
     * * You send the first request of an RPC connection.
     *
     * * You change the input schema.
     *
     * * You specify a new destination table.
     * </pre>
     *
     * <code>.google.cloud.bigquery.storage.v1.ProtoSchema writer_schema = 1;</code>
     *
     * @return Whether the writerSchema field is set.
     */
    @java.lang.Override
    public boolean hasWriterSchema() {
      return ((bitField0_ & 0x00000001) != 0);
    }

    /**
     *
     *
     * <pre>
     * Optional. The protocol buffer schema used to serialize the data. Provide
     * this value whenever:
     *
     * * You send the first request of an RPC connection.
     *
     * * You change the input schema.
     *
     * * You specify a new destination table.
     * </pre>
     *
     * <code>.google.cloud.bigquery.storage.v1.ProtoSchema writer_schema = 1;</code>
     *
     * @return The writerSchema.
     */
    @java.lang.Override
    public com.google.cloud.bigquery.storage.v1.ProtoSchema getWriterSchema() {
      return writerSchema_ == null
          ? com.google.cloud.bigquery.storage.v1.ProtoSchema.getDefaultInstance()
          : writerSchema_;
    }

    /**
     *
     *
     * <pre>
     * Optional. The protocol buffer schema used to serialize the data. Provide
     * this value whenever:
     *
     * * You send the first request of an RPC connection.
     *
     * * You change the input schema.
     *
     * * You specify a new destination table.
     * </pre>
     *
     * <code>.google.cloud.bigquery.storage.v1.ProtoSchema writer_schema = 1;</code>
     */
    @java.lang.Override
    public com.google.cloud.bigquery.storage.v1.ProtoSchemaOrBuilder getWriterSchemaOrBuilder() {
      return writerSchema_ == null
          ? com.google.cloud.bigquery.storage.v1.ProtoSchema.getDefaultInstance()
          : writerSchema_;
    }

    public static final int ROWS_FIELD_NUMBER = 2;
    private com.google.cloud.bigquery.storage.v1.ProtoRows rows_;

    /**
     *
     *
     * <pre>
     * Required. Serialized row data in protobuf message format.
     * Currently, the backend expects the serialized rows to adhere to
     * proto2 semantics when appending rows, particularly with respect to
     * how default values are encoded.
     * </pre>
     *
     * <code>.google.cloud.bigquery.storage.v1.ProtoRows rows = 2;</code>
     *
     * @return Whether the rows field is set.
     */
    @java.lang.Override
    public boolean hasRows() {
      return ((bitField0_ & 0x00000002) != 0);
    }

    /**
     *
     *
     * <pre>
     * Required. Serialized row data in protobuf message format.
     * Currently, the backend expects the serialized rows to adhere to
     * proto2 semantics when appending rows, particularly with respect to
     * how default values are encoded.
     * </pre>
     *
     * <code>.google.cloud.bigquery.storage.v1.ProtoRows rows = 2;</code>
     *
     * @return The rows.
     */
    @java.lang.Override
    public com.google.cloud.bigquery.storage.v1.ProtoRows getRows() {
      return rows_ == null
          ? com.google.cloud.bigquery.storage.v1.ProtoRows.getDefaultInstance()
          : rows_;
    }

    /**
     *
     *
     * <pre>
     * Required. Serialized row data in protobuf message format.
     * Currently, the backend expects the serialized rows to adhere to
     * proto2 semantics when appending rows, particularly with respect to
     * how default values are encoded.
     * </pre>
     *
     * <code>.google.cloud.bigquery.storage.v1.ProtoRows rows = 2;</code>
     */
    @java.lang.Override
    public com.google.cloud.bigquery.storage.v1.ProtoRowsOrBuilder getRowsOrBuilder() {
      return rows_ == null
          ? com.google.cloud.bigquery.storage.v1.ProtoRows.getDefaultInstance()
          : rows_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      if (hasWriterSchema()) {
        if (!getWriterSchema().isInitialized()) {
          memoizedIsInitialized = 0;
          return false;
        }
      }
      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(1, getWriterSchema());
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        output.writeMessage(2, getRows());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getWriterSchema());
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getRows());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.bigquery.storage.v1.AppendRowsRequest.ProtoData)) {
        return super.equals(obj);
      }
      com.google.cloud.bigquery.storage.v1.AppendRowsRequest.ProtoData other =
          (com.google.cloud.bigquery.storage.v1.AppendRowsRequest.ProtoData) obj;

      if (hasWriterSchema() != other.hasWriterSchema()) return false;
      if (hasWriterSchema()) {
        if (!getWriterSchema().equals(other.getWriterSchema())) return false;
      }
      if (hasRows() != other.hasRows()) return false;
      if (hasRows()) {
        if (!getRows().equals(other.getRows())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasWriterSchema()) {
        hash = (37 * hash) + WRITER_SCHEMA_FIELD_NUMBER;
        hash = (53 * hash) + getWriterSchema().hashCode();
      }
      if (hasRows()) {
        hash = (37 * hash) + ROWS_FIELD_NUMBER;
        hash = (53 * hash) + getRows().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.bigquery.storage.v1.AppendRowsRequest.ProtoData parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.bigquery.storage.v1.AppendRowsRequest.ProtoData parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.bigquery.storage.v1.AppendRowsRequest.ProtoData parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.bigquery.storage.v1.AppendRowsRequest.ProtoData parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.bigquery.storage.v1.AppendRowsRequest.ProtoData parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.bigquery.storage.v1.AppendRowsRequest.ProtoData parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.bigquery.storage.v1.AppendRowsRequest.ProtoData parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.bigquery.storage.v1.AppendRowsRequest.ProtoData parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.bigquery.storage.v1.AppendRowsRequest.ProtoData
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.bigquery.storage.v1.AppendRowsRequest.ProtoData
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.bigquery.storage.v1.AppendRowsRequest.ProtoData parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.bigquery.storage.v1.AppendRowsRequest.ProtoData parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.bigquery.storage.v1.AppendRowsRequest.ProtoData prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * ProtoData contains the data rows and schema when constructing append
     * requests.
     * </pre>
     *
     * Protobuf type {@code google.cloud.bigquery.storage.v1.AppendRowsRequest.ProtoData}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.bigquery.storage.v1.AppendRowsRequest.ProtoData)
        com.google.cloud.bigquery.storage.v1.AppendRowsRequest.ProtoDataOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.bigquery.storage.v1.StorageProto
            .internal_static_google_cloud_bigquery_storage_v1_AppendRowsRequest_ProtoData_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.bigquery.storage.v1.StorageProto
            .internal_static_google_cloud_bigquery_storage_v1_AppendRowsRequest_ProtoData_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.bigquery.storage.v1.AppendRowsRequest.ProtoData.class,
                com.google.cloud.bigquery.storage.v1.AppendRowsRequest.ProtoData.Builder.class);
      }

      // Construct using
      // com.google.cloud.bigquery.storage.v1.AppendRowsRequest.ProtoData.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getWriterSchemaFieldBuilder();
          getRowsFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        writerSchema_ = null;
        if (writerSchemaBuilder_ != null) {
          writerSchemaBuilder_.dispose();
          writerSchemaBuilder_ = null;
        }
        rows_ = null;
        if (rowsBuilder_ != null) {
          rowsBuilder_.dispose();
          rowsBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.bigquery.storage.v1.StorageProto
            .internal_static_google_cloud_bigquery_storage_v1_AppendRowsRequest_ProtoData_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.bigquery.storage.v1.AppendRowsRequest.ProtoData
          getDefaultInstanceForType() {
        return com.google.cloud.bigquery.storage.v1.AppendRowsRequest.ProtoData
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.bigquery.storage.v1.AppendRowsRequest.ProtoData build() {
        com.google.cloud.bigquery.storage.v1.AppendRowsRequest.ProtoData result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.bigquery.storage.v1.AppendRowsRequest.ProtoData buildPartial() {
        com.google.cloud.bigquery.storage.v1.AppendRowsRequest.ProtoData result =
            new com.google.cloud.bigquery.storage.v1.AppendRowsRequest.ProtoData(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.bigquery.storage.v1.AppendRowsRequest.ProtoData result) {
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.writerSchema_ =
              writerSchemaBuilder_ == null ? writerSchema_ : writerSchemaBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.rows_ = rowsBuilder_ == null ? rows_ : rowsBuilder_.build();
          to_bitField0_ |= 0x00000002;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.bigquery.storage.v1.AppendRowsRequest.ProtoData) {
          return mergeFrom(
              (com.google.cloud.bigquery.storage.v1.AppendRowsRequest.ProtoData) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.bigquery.storage.v1.AppendRowsRequest.ProtoData other) {
        if (other
            == com.google.cloud.bigquery.storage.v1.AppendRowsRequest.ProtoData
                .getDefaultInstance()) return this;
        if (other.hasWriterSchema()) {
          mergeWriterSchema(other.getWriterSchema());
        }
        if (other.hasRows()) {
          mergeRows(other.getRows());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        if (hasWriterSchema()) {
          if (!getWriterSchema().isInitialized()) {
            return false;
          }
        }
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  input.readMessage(getWriterSchemaFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  input.readMessage(getRowsFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private com.google.cloud.bigquery.storage.v1.ProtoSchema writerSchema_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.bigquery.storage.v1.ProtoSchema,
              com.google.cloud.bigquery.storage.v1.ProtoSchema.Builder,
              com.google.cloud.bigquery.storage.v1.ProtoSchemaOrBuilder>
          writerSchemaBuilder_;

      /**
       *
       *
       * <pre>
       * Optional. The protocol buffer schema used to serialize the data. Provide
       * this value whenever:
       *
       * * You send the first request of an RPC connection.
       *
       * * You change the input schema.
       *
       * * You specify a new destination table.
       * </pre>
       *
       * <code>.google.cloud.bigquery.storage.v1.ProtoSchema writer_schema = 1;</code>
       *
       * @return Whether the writerSchema field is set.
       */
      public boolean hasWriterSchema() {
        return ((bitField0_ & 0x00000001) != 0);
      }

      /**
       *
       *
       * <pre>
       * Optional. The protocol buffer schema used to serialize the data. Provide
       * this value whenever:
       *
       * * You send the first request of an RPC connection.
       *
       * * You change the input schema.
       *
       * * You specify a new destination table.
       * </pre>
       *
       * <code>.google.cloud.bigquery.storage.v1.ProtoSchema writer_schema = 1;</code>
       *
       * @return The writerSchema.
       */
      public com.google.cloud.bigquery.storage.v1.ProtoSchema getWriterSchema() {
        if (writerSchemaBuilder_ == null) {
          return writerSchema_ == null
              ? com.google.cloud.bigquery.storage.v1.ProtoSchema.getDefaultInstance()
              : writerSchema_;
        } else {
          return writerSchemaBuilder_.getMessage();
        }
      }

      /**
       *
       *
       * <pre>
       * Optional. The protocol buffer schema used to serialize the data. Provide
       * this value whenever:
       *
       * * You send the first request of an RPC connection.
       *
       * * You change the input schema.
       *
       * * You specify a new destination table.
       * </pre>
       *
       * <code>.google.cloud.bigquery.storage.v1.ProtoSchema writer_schema = 1;</code>
       */
      public Builder setWriterSchema(com.google.cloud.bigquery.storage.v1.ProtoSchema value) {
        if (writerSchemaBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          writerSchema_ = value;
        } else {
          writerSchemaBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. The protocol buffer schema used to serialize the data. Provide
       * this value whenever:
       *
       * * You send the first request of an RPC connection.
       *
       * * You change the input schema.
       *
       * * You specify a new destination table.
       * </pre>
       *
       * <code>.google.cloud.bigquery.storage.v1.ProtoSchema writer_schema = 1;</code>
       */
      public Builder setWriterSchema(
          com.google.cloud.bigquery.storage.v1.ProtoSchema.Builder builderForValue) {
        if (writerSchemaBuilder_ == null) {
          writerSchema_ = builderForValue.build();
        } else {
          writerSchemaBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. The protocol buffer schema used to serialize the data. Provide
       * this value whenever:
       *
       * * You send the first request of an RPC connection.
       *
       * * You change the input schema.
       *
       * * You specify a new destination table.
       * </pre>
       *
       * <code>.google.cloud.bigquery.storage.v1.ProtoSchema writer_schema = 1;</code>
       */
      public Builder mergeWriterSchema(com.google.cloud.bigquery.storage.v1.ProtoSchema value) {
        if (writerSchemaBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)
              && writerSchema_ != null
              && writerSchema_
                  != com.google.cloud.bigquery.storage.v1.ProtoSchema.getDefaultInstance()) {
            getWriterSchemaBuilder().mergeFrom(value);
          } else {
            writerSchema_ = value;
          }
        } else {
          writerSchemaBuilder_.mergeFrom(value);
        }
        if (writerSchema_ != null) {
          bitField0_ |= 0x00000001;
          onChanged();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. The protocol buffer schema used to serialize the data. Provide
       * this value whenever:
       *
       * * You send the first request of an RPC connection.
       *
       * * You change the input schema.
       *
       * * You specify a new destination table.
       * </pre>
       *
       * <code>.google.cloud.bigquery.storage.v1.ProtoSchema writer_schema = 1;</code>
       */
      public Builder clearWriterSchema() {
        bitField0_ = (bitField0_ & ~0x00000001);
        writerSchema_ = null;
        if (writerSchemaBuilder_ != null) {
          writerSchemaBuilder_.dispose();
          writerSchemaBuilder_ = null;
        }
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. The protocol buffer schema used to serialize the data. Provide
       * this value whenever:
       *
       * * You send the first request of an RPC connection.
       *
       * * You change the input schema.
       *
       * * You specify a new destination table.
       * </pre>
       *
       * <code>.google.cloud.bigquery.storage.v1.ProtoSchema writer_schema = 1;</code>
       */
      public com.google.cloud.bigquery.storage.v1.ProtoSchema.Builder getWriterSchemaBuilder() {
        bitField0_ |= 0x00000001;
        onChanged();
        return getWriterSchemaFieldBuilder().getBuilder();
      }

      /**
       *
       *
       * <pre>
       * Optional. The protocol buffer schema used to serialize the data. Provide
       * this value whenever:
       *
       * * You send the first request of an RPC connection.
       *
       * * You change the input schema.
       *
       * * You specify a new destination table.
       * </pre>
       *
       * <code>.google.cloud.bigquery.storage.v1.ProtoSchema writer_schema = 1;</code>
       */
      public com.google.cloud.bigquery.storage.v1.ProtoSchemaOrBuilder getWriterSchemaOrBuilder() {
        if (writerSchemaBuilder_ != null) {
          return writerSchemaBuilder_.getMessageOrBuilder();
        } else {
          return writerSchema_ == null
              ? com.google.cloud.bigquery.storage.v1.ProtoSchema.getDefaultInstance()
              : writerSchema_;
        }
      }

      /**
       *
       *
       * <pre>
       * Optional. The protocol buffer schema used to serialize the data. Provide
       * this value whenever:
       *
       * * You send the first request of an RPC connection.
       *
       * * You change the input schema.
       *
       * * You specify a new destination table.
       * </pre>
       *
       * <code>.google.cloud.bigquery.storage.v1.ProtoSchema writer_schema = 1;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.bigquery.storage.v1.ProtoSchema,
              com.google.cloud.bigquery.storage.v1.ProtoSchema.Builder,
              com.google.cloud.bigquery.storage.v1.ProtoSchemaOrBuilder>
          getWriterSchemaFieldBuilder() {
        if (writerSchemaBuilder_ == null) {
          writerSchemaBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.bigquery.storage.v1.ProtoSchema,
                  com.google.cloud.bigquery.storage.v1.ProtoSchema.Builder,
                  com.google.cloud.bigquery.storage.v1.ProtoSchemaOrBuilder>(
                  getWriterSchema(), getParentForChildren(), isClean());
          writerSchema_ = null;
        }
        return writerSchemaBuilder_;
      }

      private com.google.cloud.bigquery.storage.v1.ProtoRows rows_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.bigquery.storage.v1.ProtoRows,
              com.google.cloud.bigquery.storage.v1.ProtoRows.Builder,
              com.google.cloud.bigquery.storage.v1.ProtoRowsOrBuilder>
          rowsBuilder_;

      /**
       *
       *
       * <pre>
       * Required. Serialized row data in protobuf message format.
       * Currently, the backend expects the serialized rows to adhere to
       * proto2 semantics when appending rows, particularly with respect to
       * how default values are encoded.
       * </pre>
       *
       * <code>.google.cloud.bigquery.storage.v1.ProtoRows rows = 2;</code>
       *
       * @return Whether the rows field is set.
       */
      public boolean hasRows() {
        return ((bitField0_ & 0x00000002) != 0);
      }

      /**
       *
       *
       * <pre>
       * Required. Serialized row data in protobuf message format.
       * Currently, the backend expects the serialized rows to adhere to
       * proto2 semantics when appending rows, particularly with respect to
       * how default values are encoded.
       * </pre>
       *
       * <code>.google.cloud.bigquery.storage.v1.ProtoRows rows = 2;</code>
       *
       * @return The rows.
       */
      public com.google.cloud.bigquery.storage.v1.ProtoRows getRows() {
        if (rowsBuilder_ == null) {
          return rows_ == null
              ? com.google.cloud.bigquery.storage.v1.ProtoRows.getDefaultInstance()
              : rows_;
        } else {
          return rowsBuilder_.getMessage();
        }
      }

      /**
       *
       *
       * <pre>
       * Required. Serialized row data in protobuf message format.
       * Currently, the backend expects the serialized rows to adhere to
       * proto2 semantics when appending rows, particularly with respect to
       * how default values are encoded.
       * </pre>
       *
       * <code>.google.cloud.bigquery.storage.v1.ProtoRows rows = 2;</code>
       */
      public Builder setRows(com.google.cloud.bigquery.storage.v1.ProtoRows value) {
        if (rowsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          rows_ = value;
        } else {
          rowsBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Required. Serialized row data in protobuf message format.
       * Currently, the backend expects the serialized rows to adhere to
       * proto2 semantics when appending rows, particularly with respect to
       * how default values are encoded.
       * </pre>
       *
       * <code>.google.cloud.bigquery.storage.v1.ProtoRows rows = 2;</code>
       */
      public Builder setRows(
          com.google.cloud.bigquery.storage.v1.ProtoRows.Builder builderForValue) {
        if (rowsBuilder_ == null) {
          rows_ = builderForValue.build();
        } else {
          rowsBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Required. Serialized row data in protobuf message format.
       * Currently, the backend expects the serialized rows to adhere to
       * proto2 semantics when appending rows, particularly with respect to
       * how default values are encoded.
       * </pre>
       *
       * <code>.google.cloud.bigquery.storage.v1.ProtoRows rows = 2;</code>
       */
      public Builder mergeRows(com.google.cloud.bigquery.storage.v1.ProtoRows value) {
        if (rowsBuilder_ == null) {
          if (((bitField0_ & 0x00000002) != 0)
              && rows_ != null
              && rows_ != com.google.cloud.bigquery.storage.v1.ProtoRows.getDefaultInstance()) {
            getRowsBuilder().mergeFrom(value);
          } else {
            rows_ = value;
          }
        } else {
          rowsBuilder_.mergeFrom(value);
        }
        if (rows_ != null) {
          bitField0_ |= 0x00000002;
          onChanged();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Required. Serialized row data in protobuf message format.
       * Currently, the backend expects the serialized rows to adhere to
       * proto2 semantics when appending rows, particularly with respect to
       * how default values are encoded.
       * </pre>
       *
       * <code>.google.cloud.bigquery.storage.v1.ProtoRows rows = 2;</code>
       */
      public Builder clearRows() {
        bitField0_ = (bitField0_ & ~0x00000002);
        rows_ = null;
        if (rowsBuilder_ != null) {
          rowsBuilder_.dispose();
          rowsBuilder_ = null;
        }
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Required. Serialized row data in protobuf message format.
       * Currently, the backend expects the serialized rows to adhere to
       * proto2 semantics when appending rows, particularly with respect to
       * how default values are encoded.
       * </pre>
       *
       * <code>.google.cloud.bigquery.storage.v1.ProtoRows rows = 2;</code>
       */
      public com.google.cloud.bigquery.storage.v1.ProtoRows.Builder getRowsBuilder() {
        bitField0_ |= 0x00000002;
        onChanged();
        return getRowsFieldBuilder().getBuilder();
      }

      /**
       *
       *
       * <pre>
       * Required. Serialized row data in protobuf message format.
       * Currently, the backend expects the serialized rows to adhere to
       * proto2 semantics when appending rows, particularly with respect to
       * how default values are encoded.
       * </pre>
       *
       * <code>.google.cloud.bigquery.storage.v1.ProtoRows rows = 2;</code>
       */
      public com.google.cloud.bigquery.storage.v1.ProtoRowsOrBuilder getRowsOrBuilder() {
        if (rowsBuilder_ != null) {
          return rowsBuilder_.getMessageOrBuilder();
        } else {
          return rows_ == null
              ? com.google.cloud.bigquery.storage.v1.ProtoRows.getDefaultInstance()
              : rows_;
        }
      }

      /**
       *
       *
       * <pre>
       * Required. Serialized row data in protobuf message format.
       * Currently, the backend expects the serialized rows to adhere to
       * proto2 semantics when appending rows, particularly with respect to
       * how default values are encoded.
       * </pre>
       *
       * <code>.google.cloud.bigquery.storage.v1.ProtoRows rows = 2;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.bigquery.storage.v1.ProtoRows,
              com.google.cloud.bigquery.storage.v1.ProtoRows.Builder,
              com.google.cloud.bigquery.storage.v1.ProtoRowsOrBuilder>
          getRowsFieldBuilder() {
        if (rowsBuilder_ == null) {
          rowsBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.bigquery.storage.v1.ProtoRows,
                  com.google.cloud.bigquery.storage.v1.ProtoRows.Builder,
                  com.google.cloud.bigquery.storage.v1.ProtoRowsOrBuilder>(
                  getRows(), getParentForChildren(), isClean());
          rows_ = null;
        }
        return rowsBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.bigquery.storage.v1.AppendRowsRequest.ProtoData)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.bigquery.storage.v1.AppendRowsRequest.ProtoData)
    private static final com.google.cloud.bigquery.storage.v1.AppendRowsRequest.ProtoData
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.bigquery.storage.v1.AppendRowsRequest.ProtoData();
    }

    public static com.google.cloud.bigquery.storage.v1.AppendRowsRequest.ProtoData
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<ProtoData> PARSER =
        new com.google.protobuf.AbstractParser<ProtoData>() {
          @java.lang.Override
          public ProtoData parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<ProtoData> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<ProtoData> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.bigquery.storage.v1.AppendRowsRequest.ProtoData
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int bitField0_;
  private int rowsCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object rows_;

  public enum RowsCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    PROTO_ROWS(4),
    ARROW_ROWS(5),
    ROWS_NOT_SET(0);
    private final int value;

    private RowsCase(int value) {
      this.value = value;
    }

    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static RowsCase valueOf(int value) {
      return forNumber(value);
    }

    public static RowsCase forNumber(int value) {
      switch (value) {
        case 4:
          return PROTO_ROWS;
        case 5:
          return ARROW_ROWS;
        case 0:
          return ROWS_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public RowsCase getRowsCase() {
    return RowsCase.forNumber(rowsCase_);
  }

  public static final int WRITE_STREAM_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object writeStream_ = "";

  /**
   *
   *
   * <pre>
   * Required. The write_stream identifies the append operation. It must be
   * provided in the following scenarios:
   *
   * * In the first request to an AppendRows connection.
   *
   * * In all subsequent requests to an AppendRows connection, if you use the
   * same connection to write to multiple tables or change the input schema for
   * default streams.
   *
   * For explicitly created write streams, the format is:
   *
   * * `projects/{project}/datasets/{dataset}/tables/{table}/streams/{id}`
   *
   * For the special default stream, the format is:
   *
   * * `projects/{project}/datasets/{dataset}/tables/{table}/streams/_default`.
   *
   * An example of a possible sequence of requests with write_stream fields
   * within a single connection:
   *
   * * r1: {write_stream: stream_name_1}
   *
   * * r2: {write_stream: /&#42;omit*&#47;}
   *
   * * r3: {write_stream: /&#42;omit*&#47;}
   *
   * * r4: {write_stream: stream_name_2}
   *
   * * r5: {write_stream: stream_name_2}
   *
   * The destination changed in request_4, so the write_stream field must be
   * populated in all subsequent requests in this stream.
   * </pre>
   *
   * <code>
   * string write_stream = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The writeStream.
   */
  @java.lang.Override
  public java.lang.String getWriteStream() {
    java.lang.Object ref = writeStream_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      writeStream_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Required. The write_stream identifies the append operation. It must be
   * provided in the following scenarios:
   *
   * * In the first request to an AppendRows connection.
   *
   * * In all subsequent requests to an AppendRows connection, if you use the
   * same connection to write to multiple tables or change the input schema for
   * default streams.
   *
   * For explicitly created write streams, the format is:
   *
   * * `projects/{project}/datasets/{dataset}/tables/{table}/streams/{id}`
   *
   * For the special default stream, the format is:
   *
   * * `projects/{project}/datasets/{dataset}/tables/{table}/streams/_default`.
   *
   * An example of a possible sequence of requests with write_stream fields
   * within a single connection:
   *
   * * r1: {write_stream: stream_name_1}
   *
   * * r2: {write_stream: /&#42;omit*&#47;}
   *
   * * r3: {write_stream: /&#42;omit*&#47;}
   *
   * * r4: {write_stream: stream_name_2}
   *
   * * r5: {write_stream: stream_name_2}
   *
   * The destination changed in request_4, so the write_stream field must be
   * populated in all subsequent requests in this stream.
   * </pre>
   *
   * <code>
   * string write_stream = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for writeStream.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getWriteStreamBytes() {
    java.lang.Object ref = writeStream_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      writeStream_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int OFFSET_FIELD_NUMBER = 2;
  private com.google.protobuf.Int64Value offset_;

  /**
   *
   *
   * <pre>
   * If present, the write is only performed if the next append offset is same
   * as the provided value. If not present, the write is performed at the
   * current end of stream. Specifying a value for this field is not allowed
   * when calling AppendRows for the '_default' stream.
   * </pre>
   *
   * <code>.google.protobuf.Int64Value offset = 2;</code>
   *
   * @return Whether the offset field is set.
   */
  @java.lang.Override
  public boolean hasOffset() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * If present, the write is only performed if the next append offset is same
   * as the provided value. If not present, the write is performed at the
   * current end of stream. Specifying a value for this field is not allowed
   * when calling AppendRows for the '_default' stream.
   * </pre>
   *
   * <code>.google.protobuf.Int64Value offset = 2;</code>
   *
   * @return The offset.
   */
  @java.lang.Override
  public com.google.protobuf.Int64Value getOffset() {
    return offset_ == null ? com.google.protobuf.Int64Value.getDefaultInstance() : offset_;
  }

  /**
   *
   *
   * <pre>
   * If present, the write is only performed if the next append offset is same
   * as the provided value. If not present, the write is performed at the
   * current end of stream. Specifying a value for this field is not allowed
   * when calling AppendRows for the '_default' stream.
   * </pre>
   *
   * <code>.google.protobuf.Int64Value offset = 2;</code>
   */
  @java.lang.Override
  public com.google.protobuf.Int64ValueOrBuilder getOffsetOrBuilder() {
    return offset_ == null ? com.google.protobuf.Int64Value.getDefaultInstance() : offset_;
  }

  public static final int PROTO_ROWS_FIELD_NUMBER = 4;

  /**
   *
   *
   * <pre>
   * Rows in proto format.
   * </pre>
   *
   * <code>.google.cloud.bigquery.storage.v1.AppendRowsRequest.ProtoData proto_rows = 4;</code>
   *
   * @return Whether the protoRows field is set.
   */
  @java.lang.Override
  public boolean hasProtoRows() {
    return rowsCase_ == 4;
  }

  /**
   *
   *
   * <pre>
   * Rows in proto format.
   * </pre>
   *
   * <code>.google.cloud.bigquery.storage.v1.AppendRowsRequest.ProtoData proto_rows = 4;</code>
   *
   * @return The protoRows.
   */
  @java.lang.Override
  public com.google.cloud.bigquery.storage.v1.AppendRowsRequest.ProtoData getProtoRows() {
    if (rowsCase_ == 4) {
      return (com.google.cloud.bigquery.storage.v1.AppendRowsRequest.ProtoData) rows_;
    }
    return com.google.cloud.bigquery.storage.v1.AppendRowsRequest.ProtoData.getDefaultInstance();
  }

  /**
   *
   *
   * <pre>
   * Rows in proto format.
   * </pre>
   *
   * <code>.google.cloud.bigquery.storage.v1.AppendRowsRequest.ProtoData proto_rows = 4;</code>
   */
  @java.lang.Override
  public com.google.cloud.bigquery.storage.v1.AppendRowsRequest.ProtoDataOrBuilder
      getProtoRowsOrBuilder() {
    if (rowsCase_ == 4) {
      return (com.google.cloud.bigquery.storage.v1.AppendRowsRequest.ProtoData) rows_;
    }
    return com.google.cloud.bigquery.storage.v1.AppendRowsRequest.ProtoData.getDefaultInstance();
  }

  public static final int ARROW_ROWS_FIELD_NUMBER = 5;

  /**
   *
   *
   * <pre>
   * Rows in arrow format.
   * </pre>
   *
   * <code>.google.cloud.bigquery.storage.v1.AppendRowsRequest.ArrowData arrow_rows = 5;</code>
   *
   * @return Whether the arrowRows field is set.
   */
  @java.lang.Override
  public boolean hasArrowRows() {
    return rowsCase_ == 5;
  }

  /**
   *
   *
   * <pre>
   * Rows in arrow format.
   * </pre>
   *
   * <code>.google.cloud.bigquery.storage.v1.AppendRowsRequest.ArrowData arrow_rows = 5;</code>
   *
   * @return The arrowRows.
   */
  @java.lang.Override
  public com.google.cloud.bigquery.storage.v1.AppendRowsRequest.ArrowData getArrowRows() {
    if (rowsCase_ == 5) {
      return (com.google.cloud.bigquery.storage.v1.AppendRowsRequest.ArrowData) rows_;
    }
    return com.google.cloud.bigquery.storage.v1.AppendRowsRequest.ArrowData.getDefaultInstance();
  }

  /**
   *
   *
   * <pre>
   * Rows in arrow format.
   * </pre>
   *
   * <code>.google.cloud.bigquery.storage.v1.AppendRowsRequest.ArrowData arrow_rows = 5;</code>
   */
  @java.lang.Override
  public com.google.cloud.bigquery.storage.v1.AppendRowsRequest.ArrowDataOrBuilder
      getArrowRowsOrBuilder() {
    if (rowsCase_ == 5) {
      return (com.google.cloud.bigquery.storage.v1.AppendRowsRequest.ArrowData) rows_;
    }
    return com.google.cloud.bigquery.storage.v1.AppendRowsRequest.ArrowData.getDefaultInstance();
  }

  public static final int TRACE_ID_FIELD_NUMBER = 6;

  @SuppressWarnings("serial")
  private volatile java.lang.Object traceId_ = "";

  /**
   *
   *
   * <pre>
   * Id set by client to annotate its identity. Only initial request setting is
   * respected.
   * </pre>
   *
   * <code>string trace_id = 6;</code>
   *
   * @return The traceId.
   */
  @java.lang.Override
  public java.lang.String getTraceId() {
    java.lang.Object ref = traceId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      traceId_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Id set by client to annotate its identity. Only initial request setting is
   * respected.
   * </pre>
   *
   * <code>string trace_id = 6;</code>
   *
   * @return The bytes for traceId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getTraceIdBytes() {
    java.lang.Object ref = traceId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      traceId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int MISSING_VALUE_INTERPRETATIONS_FIELD_NUMBER = 7;

  private static final class MissingValueInterpretationsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.Integer> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.Integer>newDefaultInstance(
            com.google.cloud.bigquery.storage.v1.StorageProto
                .internal_static_google_cloud_bigquery_storage_v1_AppendRowsRequest_MissingValueInterpretationsEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.ENUM,
            com.google.cloud.bigquery.storage.v1.AppendRowsRequest.MissingValueInterpretation
                .MISSING_VALUE_INTERPRETATION_UNSPECIFIED
                .getNumber());
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, java.lang.Integer>
      missingValueInterpretations_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.Integer>
      internalGetMissingValueInterpretations() {
    if (missingValueInterpretations_ == null) {
      return com.google.protobuf.MapField.emptyMapField(
          MissingValueInterpretationsDefaultEntryHolder.defaultEntry);
    }
    return missingValueInterpretations_;
  }

  private static final com.google.protobuf.Internal.MapAdapter.Converter<
          java.lang.Integer,
          com.google.cloud.bigquery.storage.v1.AppendRowsRequest.MissingValueInterpretation>
      missingValueInterpretationsValueConverter =
          com.google.protobuf.Internal.MapAdapter.newEnumConverter(
              com.google.cloud.bigquery.storage.v1.AppendRowsRequest.MissingValueInterpretation
                  .internalGetValueMap(),
              com.google.cloud.bigquery.storage.v1.AppendRowsRequest.MissingValueInterpretation
                  .UNRECOGNIZED);

  private static final java.util.Map<
          java.lang.String,
          com.google.cloud.bigquery.storage.v1.AppendRowsRequest.MissingValueInterpretation>
      internalGetAdaptedMissingValueInterpretationsMap(
          java.util.Map<java.lang.String, java.lang.Integer> map) {
    return new com.google.protobuf.Internal.MapAdapter<
        java.lang.String,
        com.google.cloud.bigquery.storage.v1.AppendRowsRequest.MissingValueInterpretation,
        java.lang.Integer>(map, missingValueInterpretationsValueConverter);
  }

  public int getMissingValueInterpretationsCount() {
    return internalGetMissingValueInterpretations().getMap().size();
  }

  /**
   *
   *
   * <pre>
   * A map to indicate how to interpret missing value for some fields. Missing
   * values are fields present in user schema but missing in rows. The key is
   * the field name. The value is the interpretation of missing values for the
   * field.
   *
   * For example, a map {'foo': NULL_VALUE, 'bar': DEFAULT_VALUE} means all
   * missing values in field foo are interpreted as NULL, all missing values in
   * field bar are interpreted as the default value of field bar in table
   * schema.
   *
   * If a field is not in this map and has missing values, the missing values
   * in this field are interpreted as NULL.
   *
   * This field only applies to the current request, it won't affect other
   * requests on the connection.
   *
   * Currently, field name can only be top-level column name, can't be a struct
   * field path like 'foo.bar'.
   * </pre>
   *
   * <code>
   * map&lt;string, .google.cloud.bigquery.storage.v1.AppendRowsRequest.MissingValueInterpretation&gt; missing_value_interpretations = 7;
   * </code>
   */
  @java.lang.Override
  public boolean containsMissingValueInterpretations(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetMissingValueInterpretations().getMap().containsKey(key);
  }

  /** Use {@link #getMissingValueInterpretationsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<
          java.lang.String,
          com.google.cloud.bigquery.storage.v1.AppendRowsRequest.MissingValueInterpretation>
      getMissingValueInterpretations() {
    return getMissingValueInterpretationsMap();
  }

  /**
   *
   *
   * <pre>
   * A map to indicate how to interpret missing value for some fields. Missing
   * values are fields present in user schema but missing in rows. The key is
   * the field name. The value is the interpretation of missing values for the
   * field.
   *
   * For example, a map {'foo': NULL_VALUE, 'bar': DEFAULT_VALUE} means all
   * missing values in field foo are interpreted as NULL, all missing values in
   * field bar are interpreted as the default value of field bar in table
   * schema.
   *
   * If a field is not in this map and has missing values, the missing values
   * in this field are interpreted as NULL.
   *
   * This field only applies to the current request, it won't affect other
   * requests on the connection.
   *
   * Currently, field name can only be top-level column name, can't be a struct
   * field path like 'foo.bar'.
   * </pre>
   *
   * <code>
   * map&lt;string, .google.cloud.bigquery.storage.v1.AppendRowsRequest.MissingValueInterpretation&gt; missing_value_interpretations = 7;
   * </code>
   */
  @java.lang.Override
  public java.util.Map<
          java.lang.String,
          com.google.cloud.bigquery.storage.v1.AppendRowsRequest.MissingValueInterpretation>
      getMissingValueInterpretationsMap() {
    return internalGetAdaptedMissingValueInterpretationsMap(
        internalGetMissingValueInterpretations().getMap());
  }

  /**
   *
   *
   * <pre>
   * A map to indicate how to interpret missing value for some fields. Missing
   * values are fields present in user schema but missing in rows. The key is
   * the field name. The value is the interpretation of missing values for the
   * field.
   *
   * For example, a map {'foo': NULL_VALUE, 'bar': DEFAULT_VALUE} means all
   * missing values in field foo are interpreted as NULL, all missing values in
   * field bar are interpreted as the default value of field bar in table
   * schema.
   *
   * If a field is not in this map and has missing values, the missing values
   * in this field are interpreted as NULL.
   *
   * This field only applies to the current request, it won't affect other
   * requests on the connection.
   *
   * Currently, field name can only be top-level column name, can't be a struct
   * field path like 'foo.bar'.
   * </pre>
   *
   * <code>
   * map&lt;string, .google.cloud.bigquery.storage.v1.AppendRowsRequest.MissingValueInterpretation&gt; missing_value_interpretations = 7;
   * </code>
   */
  @java.lang.Override
  public /* nullable */ com.google.cloud.bigquery.storage.v1.AppendRowsRequest
          .MissingValueInterpretation
      getMissingValueInterpretationsOrDefault(
          java.lang.String key,
          /* nullable */
          com.google.cloud.bigquery.storage.v1.AppendRowsRequest.MissingValueInterpretation
              defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.Integer> map =
        internalGetMissingValueInterpretations().getMap();
    return map.containsKey(key)
        ? missingValueInterpretationsValueConverter.doForward(map.get(key))
        : defaultValue;
  }

  /**
   *
   *
   * <pre>
   * A map to indicate how to interpret missing value for some fields. Missing
   * values are fields present in user schema but missing in rows. The key is
   * the field name. The value is the interpretation of missing values for the
   * field.
   *
   * For example, a map {'foo': NULL_VALUE, 'bar': DEFAULT_VALUE} means all
   * missing values in field foo are interpreted as NULL, all missing values in
   * field bar are interpreted as the default value of field bar in table
   * schema.
   *
   * If a field is not in this map and has missing values, the missing values
   * in this field are interpreted as NULL.
   *
   * This field only applies to the current request, it won't affect other
   * requests on the connection.
   *
   * Currently, field name can only be top-level column name, can't be a struct
   * field path like 'foo.bar'.
   * </pre>
   *
   * <code>
   * map&lt;string, .google.cloud.bigquery.storage.v1.AppendRowsRequest.MissingValueInterpretation&gt; missing_value_interpretations = 7;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.bigquery.storage.v1.AppendRowsRequest.MissingValueInterpretation
      getMissingValueInterpretationsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.Integer> map =
        internalGetMissingValueInterpretations().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return missingValueInterpretationsValueConverter.doForward(map.get(key));
  }

  /** Use {@link #getMissingValueInterpretationsValueMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.Integer> getMissingValueInterpretationsValue() {
    return getMissingValueInterpretationsValueMap();
  }

  /**
   *
   *
   * <pre>
   * A map to indicate how to interpret missing value for some fields. Missing
   * values are fields present in user schema but missing in rows. The key is
   * the field name. The value is the interpretation of missing values for the
   * field.
   *
   * For example, a map {'foo': NULL_VALUE, 'bar': DEFAULT_VALUE} means all
   * missing values in field foo are interpreted as NULL, all missing values in
   * field bar are interpreted as the default value of field bar in table
   * schema.
   *
   * If a field is not in this map and has missing values, the missing values
   * in this field are interpreted as NULL.
   *
   * This field only applies to the current request, it won't affect other
   * requests on the connection.
   *
   * Currently, field name can only be top-level column name, can't be a struct
   * field path like 'foo.bar'.
   * </pre>
   *
   * <code>
   * map&lt;string, .google.cloud.bigquery.storage.v1.AppendRowsRequest.MissingValueInterpretation&gt; missing_value_interpretations = 7;
   * </code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.Integer>
      getMissingValueInterpretationsValueMap() {
    return internalGetMissingValueInterpretations().getMap();
  }

  /**
   *
   *
   * <pre>
   * A map to indicate how to interpret missing value for some fields. Missing
   * values are fields present in user schema but missing in rows. The key is
   * the field name. The value is the interpretation of missing values for the
   * field.
   *
   * For example, a map {'foo': NULL_VALUE, 'bar': DEFAULT_VALUE} means all
   * missing values in field foo are interpreted as NULL, all missing values in
   * field bar are interpreted as the default value of field bar in table
   * schema.
   *
   * If a field is not in this map and has missing values, the missing values
   * in this field are interpreted as NULL.
   *
   * This field only applies to the current request, it won't affect other
   * requests on the connection.
   *
   * Currently, field name can only be top-level column name, can't be a struct
   * field path like 'foo.bar'.
   * </pre>
   *
   * <code>
   * map&lt;string, .google.cloud.bigquery.storage.v1.AppendRowsRequest.MissingValueInterpretation&gt; missing_value_interpretations = 7;
   * </code>
   */
  @java.lang.Override
  public int getMissingValueInterpretationsValueOrDefault(java.lang.String key, int defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.Integer> map =
        internalGetMissingValueInterpretations().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }

  /**
   *
   *
   * <pre>
   * A map to indicate how to interpret missing value for some fields. Missing
   * values are fields present in user schema but missing in rows. The key is
   * the field name. The value is the interpretation of missing values for the
   * field.
   *
   * For example, a map {'foo': NULL_VALUE, 'bar': DEFAULT_VALUE} means all
   * missing values in field foo are interpreted as NULL, all missing values in
   * field bar are interpreted as the default value of field bar in table
   * schema.
   *
   * If a field is not in this map and has missing values, the missing values
   * in this field are interpreted as NULL.
   *
   * This field only applies to the current request, it won't affect other
   * requests on the connection.
   *
   * Currently, field name can only be top-level column name, can't be a struct
   * field path like 'foo.bar'.
   * </pre>
   *
   * <code>
   * map&lt;string, .google.cloud.bigquery.storage.v1.AppendRowsRequest.MissingValueInterpretation&gt; missing_value_interpretations = 7;
   * </code>
   */
  @java.lang.Override
  public int getMissingValueInterpretationsValueOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.Integer> map =
        internalGetMissingValueInterpretations().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int DEFAULT_MISSING_VALUE_INTERPRETATION_FIELD_NUMBER = 8;
  private int defaultMissingValueInterpretation_ = 0;

  /**
   *
   *
   * <pre>
   * Optional. Default missing value interpretation for all columns in the
   * table. When a value is specified on an `AppendRowsRequest`, it is applied
   * to all requests from that point forward, until a subsequent
   * `AppendRowsRequest` sets it to a different value.
   * `missing_value_interpretation` can override
   * `default_missing_value_interpretation`. For example, if you want to write
   * `NULL` instead of using default values for some columns, you can set
   * `default_missing_value_interpretation` to `DEFAULT_VALUE` and at the same
   * time, set `missing_value_interpretations` to `NULL_VALUE` on those columns.
   * </pre>
   *
   * <code>
   * .google.cloud.bigquery.storage.v1.AppendRowsRequest.MissingValueInterpretation default_missing_value_interpretation = 8 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The enum numeric value on the wire for defaultMissingValueInterpretation.
   */
  @java.lang.Override
  public int getDefaultMissingValueInterpretationValue() {
    return defaultMissingValueInterpretation_;
  }

  /**
   *
   *
   * <pre>
   * Optional. Default missing value interpretation for all columns in the
   * table. When a value is specified on an `AppendRowsRequest`, it is applied
   * to all requests from that point forward, until a subsequent
   * `AppendRowsRequest` sets it to a different value.
   * `missing_value_interpretation` can override
   * `default_missing_value_interpretation`. For example, if you want to write
   * `NULL` instead of using default values for some columns, you can set
   * `default_missing_value_interpretation` to `DEFAULT_VALUE` and at the same
   * time, set `missing_value_interpretations` to `NULL_VALUE` on those columns.
   * </pre>
   *
   * <code>
   * .google.cloud.bigquery.storage.v1.AppendRowsRequest.MissingValueInterpretation default_missing_value_interpretation = 8 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The defaultMissingValueInterpretation.
   */
  @java.lang.Override
  public com.google.cloud.bigquery.storage.v1.AppendRowsRequest.MissingValueInterpretation
      getDefaultMissingValueInterpretation() {
    com.google.cloud.bigquery.storage.v1.AppendRowsRequest.MissingValueInterpretation result =
        com.google.cloud.bigquery.storage.v1.AppendRowsRequest.MissingValueInterpretation.forNumber(
            defaultMissingValueInterpretation_);
    return result == null
        ? com.google.cloud.bigquery.storage.v1.AppendRowsRequest.MissingValueInterpretation
            .UNRECOGNIZED
        : result;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    if (hasProtoRows()) {
      if (!getProtoRows().isInitialized()) {
        memoizedIsInitialized = 0;
        return false;
      }
    }
    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(writeStream_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, writeStream_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(2, getOffset());
    }
    if (rowsCase_ == 4) {
      output.writeMessage(
          4, (com.google.cloud.bigquery.storage.v1.AppendRowsRequest.ProtoData) rows_);
    }
    if (rowsCase_ == 5) {
      output.writeMessage(
          5, (com.google.cloud.bigquery.storage.v1.AppendRowsRequest.ArrowData) rows_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(traceId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, traceId_);
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output,
        internalGetMissingValueInterpretations(),
        MissingValueInterpretationsDefaultEntryHolder.defaultEntry,
        7);
    if (defaultMissingValueInterpretation_
        != com.google.cloud.bigquery.storage.v1.AppendRowsRequest.MissingValueInterpretation
            .MISSING_VALUE_INTERPRETATION_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(8, defaultMissingValueInterpretation_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(writeStream_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, writeStream_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getOffset());
    }
    if (rowsCase_ == 4) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              4, (com.google.cloud.bigquery.storage.v1.AppendRowsRequest.ProtoData) rows_);
    }
    if (rowsCase_ == 5) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              5, (com.google.cloud.bigquery.storage.v1.AppendRowsRequest.ArrowData) rows_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(traceId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, traceId_);
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.Integer> entry :
        internalGetMissingValueInterpretations().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.Integer>
          missingValueInterpretations__ =
              MissingValueInterpretationsDefaultEntryHolder.defaultEntry
                  .newBuilderForType()
                  .setKey(entry.getKey())
                  .setValue(entry.getValue())
                  .build();
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              7, missingValueInterpretations__);
    }
    if (defaultMissingValueInterpretation_
        != com.google.cloud.bigquery.storage.v1.AppendRowsRequest.MissingValueInterpretation
            .MISSING_VALUE_INTERPRETATION_UNSPECIFIED
            .getNumber()) {
      size +=
          com.google.protobuf.CodedOutputStream.computeEnumSize(
              8, defaultMissingValueInterpretation_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.bigquery.storage.v1.AppendRowsRequest)) {
      return super.equals(obj);
    }
    com.google.cloud.bigquery.storage.v1.AppendRowsRequest other =
        (com.google.cloud.bigquery.storage.v1.AppendRowsRequest) obj;

    if (!getWriteStream().equals(other.getWriteStream())) return false;
    if (hasOffset() != other.hasOffset()) return false;
    if (hasOffset()) {
      if (!getOffset().equals(other.getOffset())) return false;
    }
    if (!getTraceId().equals(other.getTraceId())) return false;
    if (!internalGetMissingValueInterpretations()
        .equals(other.internalGetMissingValueInterpretations())) return false;
    if (defaultMissingValueInterpretation_ != other.defaultMissingValueInterpretation_)
      return false;
    if (!getRowsCase().equals(other.getRowsCase())) return false;
    switch (rowsCase_) {
      case 4:
        if (!getProtoRows().equals(other.getProtoRows())) return false;
        break;
      case 5:
        if (!getArrowRows().equals(other.getArrowRows())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + WRITE_STREAM_FIELD_NUMBER;
    hash = (53 * hash) + getWriteStream().hashCode();
    if (hasOffset()) {
      hash = (37 * hash) + OFFSET_FIELD_NUMBER;
      hash = (53 * hash) + getOffset().hashCode();
    }
    hash = (37 * hash) + TRACE_ID_FIELD_NUMBER;
    hash = (53 * hash) + getTraceId().hashCode();
    if (!internalGetMissingValueInterpretations().getMap().isEmpty()) {
      hash = (37 * hash) + MISSING_VALUE_INTERPRETATIONS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetMissingValueInterpretations().hashCode();
    }
    hash = (37 * hash) + DEFAULT_MISSING_VALUE_INTERPRETATION_FIELD_NUMBER;
    hash = (53 * hash) + defaultMissingValueInterpretation_;
    switch (rowsCase_) {
      case 4:
        hash = (37 * hash) + PROTO_ROWS_FIELD_NUMBER;
        hash = (53 * hash) + getProtoRows().hashCode();
        break;
      case 5:
        hash = (37 * hash) + ARROW_ROWS_FIELD_NUMBER;
        hash = (53 * hash) + getArrowRows().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.bigquery.storage.v1.AppendRowsRequest parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.bigquery.storage.v1.AppendRowsRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.bigquery.storage.v1.AppendRowsRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.bigquery.storage.v1.AppendRowsRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.bigquery.storage.v1.AppendRowsRequest parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.bigquery.storage.v1.AppendRowsRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.bigquery.storage.v1.AppendRowsRequest parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.bigquery.storage.v1.AppendRowsRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.bigquery.storage.v1.AppendRowsRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.bigquery.storage.v1.AppendRowsRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.bigquery.storage.v1.AppendRowsRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.bigquery.storage.v1.AppendRowsRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.bigquery.storage.v1.AppendRowsRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * Request message for `AppendRows`.
   *
   * Because AppendRows is a bidirectional streaming RPC, certain parts of the
   * AppendRowsRequest need only be specified for the first request before
   * switching table destinations. You can also switch table destinations within
   * the same connection for the default stream.
   *
   * The size of a single AppendRowsRequest must be less than 10 MB in size.
   * Requests larger than this return an error, typically `INVALID_ARGUMENT`.
   * </pre>
   *
   * Protobuf type {@code google.cloud.bigquery.storage.v1.AppendRowsRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.bigquery.storage.v1.AppendRowsRequest)
      com.google.cloud.bigquery.storage.v1.AppendRowsRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.bigquery.storage.v1.StorageProto
          .internal_static_google_cloud_bigquery_storage_v1_AppendRowsRequest_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
        int number) {
      switch (number) {
        case 7:
          return internalGetMissingValueInterpretations();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMutableMapFieldReflection(
        int number) {
      switch (number) {
        case 7:
          return internalGetMutableMissingValueInterpretations();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.bigquery.storage.v1.StorageProto
          .internal_static_google_cloud_bigquery_storage_v1_AppendRowsRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.bigquery.storage.v1.AppendRowsRequest.class,
              com.google.cloud.bigquery.storage.v1.AppendRowsRequest.Builder.class);
    }

    // Construct using com.google.cloud.bigquery.storage.v1.AppendRowsRequest.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getOffsetFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      writeStream_ = "";
      offset_ = null;
      if (offsetBuilder_ != null) {
        offsetBuilder_.dispose();
        offsetBuilder_ = null;
      }
      if (protoRowsBuilder_ != null) {
        protoRowsBuilder_.clear();
      }
      if (arrowRowsBuilder_ != null) {
        arrowRowsBuilder_.clear();
      }
      traceId_ = "";
      internalGetMutableMissingValueInterpretations().clear();
      defaultMissingValueInterpretation_ = 0;
      rowsCase_ = 0;
      rows_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.bigquery.storage.v1.StorageProto
          .internal_static_google_cloud_bigquery_storage_v1_AppendRowsRequest_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.bigquery.storage.v1.AppendRowsRequest getDefaultInstanceForType() {
      return com.google.cloud.bigquery.storage.v1.AppendRowsRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.bigquery.storage.v1.AppendRowsRequest build() {
      com.google.cloud.bigquery.storage.v1.AppendRowsRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.bigquery.storage.v1.AppendRowsRequest buildPartial() {
      com.google.cloud.bigquery.storage.v1.AppendRowsRequest result =
          new com.google.cloud.bigquery.storage.v1.AppendRowsRequest(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.bigquery.storage.v1.AppendRowsRequest result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.writeStream_ = writeStream_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.offset_ = offsetBuilder_ == null ? offset_ : offsetBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.traceId_ = traceId_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.missingValueInterpretations_ = internalGetMissingValueInterpretations();
        result.missingValueInterpretations_.makeImmutable();
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.defaultMissingValueInterpretation_ = defaultMissingValueInterpretation_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    private void buildPartialOneofs(com.google.cloud.bigquery.storage.v1.AppendRowsRequest result) {
      result.rowsCase_ = rowsCase_;
      result.rows_ = this.rows_;
      if (rowsCase_ == 4 && protoRowsBuilder_ != null) {
        result.rows_ = protoRowsBuilder_.build();
      }
      if (rowsCase_ == 5 && arrowRowsBuilder_ != null) {
        result.rows_ = arrowRowsBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.bigquery.storage.v1.AppendRowsRequest) {
        return mergeFrom((com.google.cloud.bigquery.storage.v1.AppendRowsRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.bigquery.storage.v1.AppendRowsRequest other) {
      if (other == com.google.cloud.bigquery.storage.v1.AppendRowsRequest.getDefaultInstance())
        return this;
      if (!other.getWriteStream().isEmpty()) {
        writeStream_ = other.writeStream_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.hasOffset()) {
        mergeOffset(other.getOffset());
      }
      if (!other.getTraceId().isEmpty()) {
        traceId_ = other.traceId_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      internalGetMutableMissingValueInterpretations()
          .mergeFrom(other.internalGetMissingValueInterpretations());
      bitField0_ |= 0x00000020;
      if (other.defaultMissingValueInterpretation_ != 0) {
        setDefaultMissingValueInterpretationValue(
            other.getDefaultMissingValueInterpretationValue());
      }
      switch (other.getRowsCase()) {
        case PROTO_ROWS:
          {
            mergeProtoRows(other.getProtoRows());
            break;
          }
        case ARROW_ROWS:
          {
            mergeArrowRows(other.getArrowRows());
            break;
          }
        case ROWS_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      if (hasProtoRows()) {
        if (!getProtoRows().isInitialized()) {
          return false;
        }
      }
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                writeStream_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getOffsetFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 34:
              {
                input.readMessage(getProtoRowsFieldBuilder().getBuilder(), extensionRegistry);
                rowsCase_ = 4;
                break;
              } // case 34
            case 42:
              {
                input.readMessage(getArrowRowsFieldBuilder().getBuilder(), extensionRegistry);
                rowsCase_ = 5;
                break;
              } // case 42
            case 50:
              {
                traceId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case 50
            case 58:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.Integer>
                    missingValueInterpretations__ =
                        input.readMessage(
                            MissingValueInterpretationsDefaultEntryHolder.defaultEntry
                                .getParserForType(),
                            extensionRegistry);
                internalGetMutableMissingValueInterpretations()
                    .getMutableMap()
                    .put(
                        missingValueInterpretations__.getKey(),
                        missingValueInterpretations__.getValue());
                bitField0_ |= 0x00000020;
                break;
              } // case 58
            case 64:
              {
                defaultMissingValueInterpretation_ = input.readEnum();
                bitField0_ |= 0x00000040;
                break;
              } // case 64
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int rowsCase_ = 0;
    private java.lang.Object rows_;

    public RowsCase getRowsCase() {
      return RowsCase.forNumber(rowsCase_);
    }

    public Builder clearRows() {
      rowsCase_ = 0;
      rows_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private java.lang.Object writeStream_ = "";

    /**
     *
     *
     * <pre>
     * Required. The write_stream identifies the append operation. It must be
     * provided in the following scenarios:
     *
     * * In the first request to an AppendRows connection.
     *
     * * In all subsequent requests to an AppendRows connection, if you use the
     * same connection to write to multiple tables or change the input schema for
     * default streams.
     *
     * For explicitly created write streams, the format is:
     *
     * * `projects/{project}/datasets/{dataset}/tables/{table}/streams/{id}`
     *
     * For the special default stream, the format is:
     *
     * * `projects/{project}/datasets/{dataset}/tables/{table}/streams/_default`.
     *
     * An example of a possible sequence of requests with write_stream fields
     * within a single connection:
     *
     * * r1: {write_stream: stream_name_1}
     *
     * * r2: {write_stream: /&#42;omit*&#47;}
     *
     * * r3: {write_stream: /&#42;omit*&#47;}
     *
     * * r4: {write_stream: stream_name_2}
     *
     * * r5: {write_stream: stream_name_2}
     *
     * The destination changed in request_4, so the write_stream field must be
     * populated in all subsequent requests in this stream.
     * </pre>
     *
     * <code>
     * string write_stream = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The writeStream.
     */
    public java.lang.String getWriteStream() {
      java.lang.Object ref = writeStream_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        writeStream_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The write_stream identifies the append operation. It must be
     * provided in the following scenarios:
     *
     * * In the first request to an AppendRows connection.
     *
     * * In all subsequent requests to an AppendRows connection, if you use the
     * same connection to write to multiple tables or change the input schema for
     * default streams.
     *
     * For explicitly created write streams, the format is:
     *
     * * `projects/{project}/datasets/{dataset}/tables/{table}/streams/{id}`
     *
     * For the special default stream, the format is:
     *
     * * `projects/{project}/datasets/{dataset}/tables/{table}/streams/_default`.
     *
     * An example of a possible sequence of requests with write_stream fields
     * within a single connection:
     *
     * * r1: {write_stream: stream_name_1}
     *
     * * r2: {write_stream: /&#42;omit*&#47;}
     *
     * * r3: {write_stream: /&#42;omit*&#47;}
     *
     * * r4: {write_stream: stream_name_2}
     *
     * * r5: {write_stream: stream_name_2}
     *
     * The destination changed in request_4, so the write_stream field must be
     * populated in all subsequent requests in this stream.
     * </pre>
     *
     * <code>
     * string write_stream = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for writeStream.
     */
    public com.google.protobuf.ByteString getWriteStreamBytes() {
      java.lang.Object ref = writeStream_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        writeStream_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The write_stream identifies the append operation. It must be
     * provided in the following scenarios:
     *
     * * In the first request to an AppendRows connection.
     *
     * * In all subsequent requests to an AppendRows connection, if you use the
     * same connection to write to multiple tables or change the input schema for
     * default streams.
     *
     * For explicitly created write streams, the format is:
     *
     * * `projects/{project}/datasets/{dataset}/tables/{table}/streams/{id}`
     *
     * For the special default stream, the format is:
     *
     * * `projects/{project}/datasets/{dataset}/tables/{table}/streams/_default`.
     *
     * An example of a possible sequence of requests with write_stream fields
     * within a single connection:
     *
     * * r1: {write_stream: stream_name_1}
     *
     * * r2: {write_stream: /&#42;omit*&#47;}
     *
     * * r3: {write_stream: /&#42;omit*&#47;}
     *
     * * r4: {write_stream: stream_name_2}
     *
     * * r5: {write_stream: stream_name_2}
     *
     * The destination changed in request_4, so the write_stream field must be
     * populated in all subsequent requests in this stream.
     * </pre>
     *
     * <code>
     * string write_stream = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The writeStream to set.
     * @return This builder for chaining.
     */
    public Builder setWriteStream(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      writeStream_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The write_stream identifies the append operation. It must be
     * provided in the following scenarios:
     *
     * * In the first request to an AppendRows connection.
     *
     * * In all subsequent requests to an AppendRows connection, if you use the
     * same connection to write to multiple tables or change the input schema for
     * default streams.
     *
     * For explicitly created write streams, the format is:
     *
     * * `projects/{project}/datasets/{dataset}/tables/{table}/streams/{id}`
     *
     * For the special default stream, the format is:
     *
     * * `projects/{project}/datasets/{dataset}/tables/{table}/streams/_default`.
     *
     * An example of a possible sequence of requests with write_stream fields
     * within a single connection:
     *
     * * r1: {write_stream: stream_name_1}
     *
     * * r2: {write_stream: /&#42;omit*&#47;}
     *
     * * r3: {write_stream: /&#42;omit*&#47;}
     *
     * * r4: {write_stream: stream_name_2}
     *
     * * r5: {write_stream: stream_name_2}
     *
     * The destination changed in request_4, so the write_stream field must be
     * populated in all subsequent requests in this stream.
     * </pre>
     *
     * <code>
     * string write_stream = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearWriteStream() {
      writeStream_ = getDefaultInstance().getWriteStream();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The write_stream identifies the append operation. It must be
     * provided in the following scenarios:
     *
     * * In the first request to an AppendRows connection.
     *
     * * In all subsequent requests to an AppendRows connection, if you use the
     * same connection to write to multiple tables or change the input schema for
     * default streams.
     *
     * For explicitly created write streams, the format is:
     *
     * * `projects/{project}/datasets/{dataset}/tables/{table}/streams/{id}`
     *
     * For the special default stream, the format is:
     *
     * * `projects/{project}/datasets/{dataset}/tables/{table}/streams/_default`.
     *
     * An example of a possible sequence of requests with write_stream fields
     * within a single connection:
     *
     * * r1: {write_stream: stream_name_1}
     *
     * * r2: {write_stream: /&#42;omit*&#47;}
     *
     * * r3: {write_stream: /&#42;omit*&#47;}
     *
     * * r4: {write_stream: stream_name_2}
     *
     * * r5: {write_stream: stream_name_2}
     *
     * The destination changed in request_4, so the write_stream field must be
     * populated in all subsequent requests in this stream.
     * </pre>
     *
     * <code>
     * string write_stream = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for writeStream to set.
     * @return This builder for chaining.
     */
    public Builder setWriteStreamBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      writeStream_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.protobuf.Int64Value offset_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Int64Value,
            com.google.protobuf.Int64Value.Builder,
            com.google.protobuf.Int64ValueOrBuilder>
        offsetBuilder_;

    /**
     *
     *
     * <pre>
     * If present, the write is only performed if the next append offset is same
     * as the provided value. If not present, the write is performed at the
     * current end of stream. Specifying a value for this field is not allowed
     * when calling AppendRows for the '_default' stream.
     * </pre>
     *
     * <code>.google.protobuf.Int64Value offset = 2;</code>
     *
     * @return Whether the offset field is set.
     */
    public boolean hasOffset() {
      return ((bitField0_ & 0x00000002) != 0);
    }

    /**
     *
     *
     * <pre>
     * If present, the write is only performed if the next append offset is same
     * as the provided value. If not present, the write is performed at the
     * current end of stream. Specifying a value for this field is not allowed
     * when calling AppendRows for the '_default' stream.
     * </pre>
     *
     * <code>.google.protobuf.Int64Value offset = 2;</code>
     *
     * @return The offset.
     */
    public com.google.protobuf.Int64Value getOffset() {
      if (offsetBuilder_ == null) {
        return offset_ == null ? com.google.protobuf.Int64Value.getDefaultInstance() : offset_;
      } else {
        return offsetBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * If present, the write is only performed if the next append offset is same
     * as the provided value. If not present, the write is performed at the
     * current end of stream. Specifying a value for this field is not allowed
     * when calling AppendRows for the '_default' stream.
     * </pre>
     *
     * <code>.google.protobuf.Int64Value offset = 2;</code>
     */
    public Builder setOffset(com.google.protobuf.Int64Value value) {
      if (offsetBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        offset_ = value;
      } else {
        offsetBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * If present, the write is only performed if the next append offset is same
     * as the provided value. If not present, the write is performed at the
     * current end of stream. Specifying a value for this field is not allowed
     * when calling AppendRows for the '_default' stream.
     * </pre>
     *
     * <code>.google.protobuf.Int64Value offset = 2;</code>
     */
    public Builder setOffset(com.google.protobuf.Int64Value.Builder builderForValue) {
      if (offsetBuilder_ == null) {
        offset_ = builderForValue.build();
      } else {
        offsetBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * If present, the write is only performed if the next append offset is same
     * as the provided value. If not present, the write is performed at the
     * current end of stream. Specifying a value for this field is not allowed
     * when calling AppendRows for the '_default' stream.
     * </pre>
     *
     * <code>.google.protobuf.Int64Value offset = 2;</code>
     */
    public Builder mergeOffset(com.google.protobuf.Int64Value value) {
      if (offsetBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && offset_ != null
            && offset_ != com.google.protobuf.Int64Value.getDefaultInstance()) {
          getOffsetBuilder().mergeFrom(value);
        } else {
          offset_ = value;
        }
      } else {
        offsetBuilder_.mergeFrom(value);
      }
      if (offset_ != null) {
        bitField0_ |= 0x00000002;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * If present, the write is only performed if the next append offset is same
     * as the provided value. If not present, the write is performed at the
     * current end of stream. Specifying a value for this field is not allowed
     * when calling AppendRows for the '_default' stream.
     * </pre>
     *
     * <code>.google.protobuf.Int64Value offset = 2;</code>
     */
    public Builder clearOffset() {
      bitField0_ = (bitField0_ & ~0x00000002);
      offset_ = null;
      if (offsetBuilder_ != null) {
        offsetBuilder_.dispose();
        offsetBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * If present, the write is only performed if the next append offset is same
     * as the provided value. If not present, the write is performed at the
     * current end of stream. Specifying a value for this field is not allowed
     * when calling AppendRows for the '_default' stream.
     * </pre>
     *
     * <code>.google.protobuf.Int64Value offset = 2;</code>
     */
    public com.google.protobuf.Int64Value.Builder getOffsetBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getOffsetFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * If present, the write is only performed if the next append offset is same
     * as the provided value. If not present, the write is performed at the
     * current end of stream. Specifying a value for this field is not allowed
     * when calling AppendRows for the '_default' stream.
     * </pre>
     *
     * <code>.google.protobuf.Int64Value offset = 2;</code>
     */
    public com.google.protobuf.Int64ValueOrBuilder getOffsetOrBuilder() {
      if (offsetBuilder_ != null) {
        return offsetBuilder_.getMessageOrBuilder();
      } else {
        return offset_ == null ? com.google.protobuf.Int64Value.getDefaultInstance() : offset_;
      }
    }

    /**
     *
     *
     * <pre>
     * If present, the write is only performed if the next append offset is same
     * as the provided value. If not present, the write is performed at the
     * current end of stream. Specifying a value for this field is not allowed
     * when calling AppendRows for the '_default' stream.
     * </pre>
     *
     * <code>.google.protobuf.Int64Value offset = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Int64Value,
            com.google.protobuf.Int64Value.Builder,
            com.google.protobuf.Int64ValueOrBuilder>
        getOffsetFieldBuilder() {
      if (offsetBuilder_ == null) {
        offsetBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Int64Value,
                com.google.protobuf.Int64Value.Builder,
                com.google.protobuf.Int64ValueOrBuilder>(
                getOffset(), getParentForChildren(), isClean());
        offset_ = null;
      }
      return offsetBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.bigquery.storage.v1.AppendRowsRequest.ProtoData,
            com.google.cloud.bigquery.storage.v1.AppendRowsRequest.ProtoData.Builder,
            com.google.cloud.bigquery.storage.v1.AppendRowsRequest.ProtoDataOrBuilder>
        protoRowsBuilder_;

    /**
     *
     *
     * <pre>
     * Rows in proto format.
     * </pre>
     *
     * <code>.google.cloud.bigquery.storage.v1.AppendRowsRequest.ProtoData proto_rows = 4;</code>
     *
     * @return Whether the protoRows field is set.
     */
    @java.lang.Override
    public boolean hasProtoRows() {
      return rowsCase_ == 4;
    }

    /**
     *
     *
     * <pre>
     * Rows in proto format.
     * </pre>
     *
     * <code>.google.cloud.bigquery.storage.v1.AppendRowsRequest.ProtoData proto_rows = 4;</code>
     *
     * @return The protoRows.
     */
    @java.lang.Override
    public com.google.cloud.bigquery.storage.v1.AppendRowsRequest.ProtoData getProtoRows() {
      if (protoRowsBuilder_ == null) {
        if (rowsCase_ == 4) {
          return (com.google.cloud.bigquery.storage.v1.AppendRowsRequest.ProtoData) rows_;
        }
        return com.google.cloud.bigquery.storage.v1.AppendRowsRequest.ProtoData
            .getDefaultInstance();
      } else {
        if (rowsCase_ == 4) {
          return protoRowsBuilder_.getMessage();
        }
        return com.google.cloud.bigquery.storage.v1.AppendRowsRequest.ProtoData
            .getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Rows in proto format.
     * </pre>
     *
     * <code>.google.cloud.bigquery.storage.v1.AppendRowsRequest.ProtoData proto_rows = 4;</code>
     */
    public Builder setProtoRows(
        com.google.cloud.bigquery.storage.v1.AppendRowsRequest.ProtoData value) {
      if (protoRowsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        rows_ = value;
        onChanged();
      } else {
        protoRowsBuilder_.setMessage(value);
      }
      rowsCase_ = 4;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Rows in proto format.
     * </pre>
     *
     * <code>.google.cloud.bigquery.storage.v1.AppendRowsRequest.ProtoData proto_rows = 4;</code>
     */
    public Builder setProtoRows(
        com.google.cloud.bigquery.storage.v1.AppendRowsRequest.ProtoData.Builder builderForValue) {
      if (protoRowsBuilder_ == null) {
        rows_ = builderForValue.build();
        onChanged();
      } else {
        protoRowsBuilder_.setMessage(builderForValue.build());
      }
      rowsCase_ = 4;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Rows in proto format.
     * </pre>
     *
     * <code>.google.cloud.bigquery.storage.v1.AppendRowsRequest.ProtoData proto_rows = 4;</code>
     */
    public Builder mergeProtoRows(
        com.google.cloud.bigquery.storage.v1.AppendRowsRequest.ProtoData value) {
      if (protoRowsBuilder_ == null) {
        if (rowsCase_ == 4
            && rows_
                != com.google.cloud.bigquery.storage.v1.AppendRowsRequest.ProtoData
                    .getDefaultInstance()) {
          rows_ =
              com.google.cloud.bigquery.storage.v1.AppendRowsRequest.ProtoData.newBuilder(
                      (com.google.cloud.bigquery.storage.v1.AppendRowsRequest.ProtoData) rows_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          rows_ = value;
        }
        onChanged();
      } else {
        if (rowsCase_ == 4) {
          protoRowsBuilder_.mergeFrom(value);
        } else {
          protoRowsBuilder_.setMessage(value);
        }
      }
      rowsCase_ = 4;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Rows in proto format.
     * </pre>
     *
     * <code>.google.cloud.bigquery.storage.v1.AppendRowsRequest.ProtoData proto_rows = 4;</code>
     */
    public Builder clearProtoRows() {
      if (protoRowsBuilder_ == null) {
        if (rowsCase_ == 4) {
          rowsCase_ = 0;
          rows_ = null;
          onChanged();
        }
      } else {
        if (rowsCase_ == 4) {
          rowsCase_ = 0;
          rows_ = null;
        }
        protoRowsBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Rows in proto format.
     * </pre>
     *
     * <code>.google.cloud.bigquery.storage.v1.AppendRowsRequest.ProtoData proto_rows = 4;</code>
     */
    public com.google.cloud.bigquery.storage.v1.AppendRowsRequest.ProtoData.Builder
        getProtoRowsBuilder() {
      return getProtoRowsFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Rows in proto format.
     * </pre>
     *
     * <code>.google.cloud.bigquery.storage.v1.AppendRowsRequest.ProtoData proto_rows = 4;</code>
     */
    @java.lang.Override
    public com.google.cloud.bigquery.storage.v1.AppendRowsRequest.ProtoDataOrBuilder
        getProtoRowsOrBuilder() {
      if ((rowsCase_ == 4) && (protoRowsBuilder_ != null)) {
        return protoRowsBuilder_.getMessageOrBuilder();
      } else {
        if (rowsCase_ == 4) {
          return (com.google.cloud.bigquery.storage.v1.AppendRowsRequest.ProtoData) rows_;
        }
        return com.google.cloud.bigquery.storage.v1.AppendRowsRequest.ProtoData
            .getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Rows in proto format.
     * </pre>
     *
     * <code>.google.cloud.bigquery.storage.v1.AppendRowsRequest.ProtoData proto_rows = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.bigquery.storage.v1.AppendRowsRequest.ProtoData,
            com.google.cloud.bigquery.storage.v1.AppendRowsRequest.ProtoData.Builder,
            com.google.cloud.bigquery.storage.v1.AppendRowsRequest.ProtoDataOrBuilder>
        getProtoRowsFieldBuilder() {
      if (protoRowsBuilder_ == null) {
        if (!(rowsCase_ == 4)) {
          rows_ =
              com.google.cloud.bigquery.storage.v1.AppendRowsRequest.ProtoData.getDefaultInstance();
        }
        protoRowsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.bigquery.storage.v1.AppendRowsRequest.ProtoData,
                com.google.cloud.bigquery.storage.v1.AppendRowsRequest.ProtoData.Builder,
                com.google.cloud.bigquery.storage.v1.AppendRowsRequest.ProtoDataOrBuilder>(
                (com.google.cloud.bigquery.storage.v1.AppendRowsRequest.ProtoData) rows_,
                getParentForChildren(),
                isClean());
        rows_ = null;
      }
      rowsCase_ = 4;
      onChanged();
      return protoRowsBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.bigquery.storage.v1.AppendRowsRequest.ArrowData,
            com.google.cloud.bigquery.storage.v1.AppendRowsRequest.ArrowData.Builder,
            com.google.cloud.bigquery.storage.v1.AppendRowsRequest.ArrowDataOrBuilder>
        arrowRowsBuilder_;

    /**
     *
     *
     * <pre>
     * Rows in arrow format.
     * </pre>
     *
     * <code>.google.cloud.bigquery.storage.v1.AppendRowsRequest.ArrowData arrow_rows = 5;</code>
     *
     * @return Whether the arrowRows field is set.
     */
    @java.lang.Override
    public boolean hasArrowRows() {
      return rowsCase_ == 5;
    }

    /**
     *
     *
     * <pre>
     * Rows in arrow format.
     * </pre>
     *
     * <code>.google.cloud.bigquery.storage.v1.AppendRowsRequest.ArrowData arrow_rows = 5;</code>
     *
     * @return The arrowRows.
     */
    @java.lang.Override
    public com.google.cloud.bigquery.storage.v1.AppendRowsRequest.ArrowData getArrowRows() {
      if (arrowRowsBuilder_ == null) {
        if (rowsCase_ == 5) {
          return (com.google.cloud.bigquery.storage.v1.AppendRowsRequest.ArrowData) rows_;
        }
        return com.google.cloud.bigquery.storage.v1.AppendRowsRequest.ArrowData
            .getDefaultInstance();
      } else {
        if (rowsCase_ == 5) {
          return arrowRowsBuilder_.getMessage();
        }
        return com.google.cloud.bigquery.storage.v1.AppendRowsRequest.ArrowData
            .getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Rows in arrow format.
     * </pre>
     *
     * <code>.google.cloud.bigquery.storage.v1.AppendRowsRequest.ArrowData arrow_rows = 5;</code>
     */
    public Builder setArrowRows(
        com.google.cloud.bigquery.storage.v1.AppendRowsRequest.ArrowData value) {
      if (arrowRowsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        rows_ = value;
        onChanged();
      } else {
        arrowRowsBuilder_.setMessage(value);
      }
      rowsCase_ = 5;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Rows in arrow format.
     * </pre>
     *
     * <code>.google.cloud.bigquery.storage.v1.AppendRowsRequest.ArrowData arrow_rows = 5;</code>
     */
    public Builder setArrowRows(
        com.google.cloud.bigquery.storage.v1.AppendRowsRequest.ArrowData.Builder builderForValue) {
      if (arrowRowsBuilder_ == null) {
        rows_ = builderForValue.build();
        onChanged();
      } else {
        arrowRowsBuilder_.setMessage(builderForValue.build());
      }
      rowsCase_ = 5;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Rows in arrow format.
     * </pre>
     *
     * <code>.google.cloud.bigquery.storage.v1.AppendRowsRequest.ArrowData arrow_rows = 5;</code>
     */
    public Builder mergeArrowRows(
        com.google.cloud.bigquery.storage.v1.AppendRowsRequest.ArrowData value) {
      if (arrowRowsBuilder_ == null) {
        if (rowsCase_ == 5
            && rows_
                != com.google.cloud.bigquery.storage.v1.AppendRowsRequest.ArrowData
                    .getDefaultInstance()) {
          rows_ =
              com.google.cloud.bigquery.storage.v1.AppendRowsRequest.ArrowData.newBuilder(
                      (com.google.cloud.bigquery.storage.v1.AppendRowsRequest.ArrowData) rows_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          rows_ = value;
        }
        onChanged();
      } else {
        if (rowsCase_ == 5) {
          arrowRowsBuilder_.mergeFrom(value);
        } else {
          arrowRowsBuilder_.setMessage(value);
        }
      }
      rowsCase_ = 5;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Rows in arrow format.
     * </pre>
     *
     * <code>.google.cloud.bigquery.storage.v1.AppendRowsRequest.ArrowData arrow_rows = 5;</code>
     */
    public Builder clearArrowRows() {
      if (arrowRowsBuilder_ == null) {
        if (rowsCase_ == 5) {
          rowsCase_ = 0;
          rows_ = null;
          onChanged();
        }
      } else {
        if (rowsCase_ == 5) {
          rowsCase_ = 0;
          rows_ = null;
        }
        arrowRowsBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Rows in arrow format.
     * </pre>
     *
     * <code>.google.cloud.bigquery.storage.v1.AppendRowsRequest.ArrowData arrow_rows = 5;</code>
     */
    public com.google.cloud.bigquery.storage.v1.AppendRowsRequest.ArrowData.Builder
        getArrowRowsBuilder() {
      return getArrowRowsFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Rows in arrow format.
     * </pre>
     *
     * <code>.google.cloud.bigquery.storage.v1.AppendRowsRequest.ArrowData arrow_rows = 5;</code>
     */
    @java.lang.Override
    public com.google.cloud.bigquery.storage.v1.AppendRowsRequest.ArrowDataOrBuilder
        getArrowRowsOrBuilder() {
      if ((rowsCase_ == 5) && (arrowRowsBuilder_ != null)) {
        return arrowRowsBuilder_.getMessageOrBuilder();
      } else {
        if (rowsCase_ == 5) {
          return (com.google.cloud.bigquery.storage.v1.AppendRowsRequest.ArrowData) rows_;
        }
        return com.google.cloud.bigquery.storage.v1.AppendRowsRequest.ArrowData
            .getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Rows in arrow format.
     * </pre>
     *
     * <code>.google.cloud.bigquery.storage.v1.AppendRowsRequest.ArrowData arrow_rows = 5;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.bigquery.storage.v1.AppendRowsRequest.ArrowData,
            com.google.cloud.bigquery.storage.v1.AppendRowsRequest.ArrowData.Builder,
            com.google.cloud.bigquery.storage.v1.AppendRowsRequest.ArrowDataOrBuilder>
        getArrowRowsFieldBuilder() {
      if (arrowRowsBuilder_ == null) {
        if (!(rowsCase_ == 5)) {
          rows_ =
              com.google.cloud.bigquery.storage.v1.AppendRowsRequest.ArrowData.getDefaultInstance();
        }
        arrowRowsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.bigquery.storage.v1.AppendRowsRequest.ArrowData,
                com.google.cloud.bigquery.storage.v1.AppendRowsRequest.ArrowData.Builder,
                com.google.cloud.bigquery.storage.v1.AppendRowsRequest.ArrowDataOrBuilder>(
                (com.google.cloud.bigquery.storage.v1.AppendRowsRequest.ArrowData) rows_,
                getParentForChildren(),
                isClean());
        rows_ = null;
      }
      rowsCase_ = 5;
      onChanged();
      return arrowRowsBuilder_;
    }

    private java.lang.Object traceId_ = "";

    /**
     *
     *
     * <pre>
     * Id set by client to annotate its identity. Only initial request setting is
     * respected.
     * </pre>
     *
     * <code>string trace_id = 6;</code>
     *
     * @return The traceId.
     */
    public java.lang.String getTraceId() {
      java.lang.Object ref = traceId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        traceId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Id set by client to annotate its identity. Only initial request setting is
     * respected.
     * </pre>
     *
     * <code>string trace_id = 6;</code>
     *
     * @return The bytes for traceId.
     */
    public com.google.protobuf.ByteString getTraceIdBytes() {
      java.lang.Object ref = traceId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        traceId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Id set by client to annotate its identity. Only initial request setting is
     * respected.
     * </pre>
     *
     * <code>string trace_id = 6;</code>
     *
     * @param value The traceId to set.
     * @return This builder for chaining.
     */
    public Builder setTraceId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      traceId_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Id set by client to annotate its identity. Only initial request setting is
     * respected.
     * </pre>
     *
     * <code>string trace_id = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTraceId() {
      traceId_ = getDefaultInstance().getTraceId();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Id set by client to annotate its identity. Only initial request setting is
     * respected.
     * </pre>
     *
     * <code>string trace_id = 6;</code>
     *
     * @param value The bytes for traceId to set.
     * @return This builder for chaining.
     */
    public Builder setTraceIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      traceId_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.Integer>
        missingValueInterpretations_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.Integer>
        internalGetMissingValueInterpretations() {
      if (missingValueInterpretations_ == null) {
        return com.google.protobuf.MapField.emptyMapField(
            MissingValueInterpretationsDefaultEntryHolder.defaultEntry);
      }
      return missingValueInterpretations_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.Integer>
        internalGetMutableMissingValueInterpretations() {
      if (missingValueInterpretations_ == null) {
        missingValueInterpretations_ =
            com.google.protobuf.MapField.newMapField(
                MissingValueInterpretationsDefaultEntryHolder.defaultEntry);
      }
      if (!missingValueInterpretations_.isMutable()) {
        missingValueInterpretations_ = missingValueInterpretations_.copy();
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return missingValueInterpretations_;
    }

    public int getMissingValueInterpretationsCount() {
      return internalGetMissingValueInterpretations().getMap().size();
    }

    /**
     *
     *
     * <pre>
     * A map to indicate how to interpret missing value for some fields. Missing
     * values are fields present in user schema but missing in rows. The key is
     * the field name. The value is the interpretation of missing values for the
     * field.
     *
     * For example, a map {'foo': NULL_VALUE, 'bar': DEFAULT_VALUE} means all
     * missing values in field foo are interpreted as NULL, all missing values in
     * field bar are interpreted as the default value of field bar in table
     * schema.
     *
     * If a field is not in this map and has missing values, the missing values
     * in this field are interpreted as NULL.
     *
     * This field only applies to the current request, it won't affect other
     * requests on the connection.
     *
     * Currently, field name can only be top-level column name, can't be a struct
     * field path like 'foo.bar'.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.bigquery.storage.v1.AppendRowsRequest.MissingValueInterpretation&gt; missing_value_interpretations = 7;
     * </code>
     */
    @java.lang.Override
    public boolean containsMissingValueInterpretations(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetMissingValueInterpretations().getMap().containsKey(key);
    }

    /** Use {@link #getMissingValueInterpretationsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<
            java.lang.String,
            com.google.cloud.bigquery.storage.v1.AppendRowsRequest.MissingValueInterpretation>
        getMissingValueInterpretations() {
      return getMissingValueInterpretationsMap();
    }

    /**
     *
     *
     * <pre>
     * A map to indicate how to interpret missing value for some fields. Missing
     * values are fields present in user schema but missing in rows. The key is
     * the field name. The value is the interpretation of missing values for the
     * field.
     *
     * For example, a map {'foo': NULL_VALUE, 'bar': DEFAULT_VALUE} means all
     * missing values in field foo are interpreted as NULL, all missing values in
     * field bar are interpreted as the default value of field bar in table
     * schema.
     *
     * If a field is not in this map and has missing values, the missing values
     * in this field are interpreted as NULL.
     *
     * This field only applies to the current request, it won't affect other
     * requests on the connection.
     *
     * Currently, field name can only be top-level column name, can't be a struct
     * field path like 'foo.bar'.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.bigquery.storage.v1.AppendRowsRequest.MissingValueInterpretation&gt; missing_value_interpretations = 7;
     * </code>
     */
    @java.lang.Override
    public java.util.Map<
            java.lang.String,
            com.google.cloud.bigquery.storage.v1.AppendRowsRequest.MissingValueInterpretation>
        getMissingValueInterpretationsMap() {
      return internalGetAdaptedMissingValueInterpretationsMap(
          internalGetMissingValueInterpretations().getMap());
    }

    /**
     *
     *
     * <pre>
     * A map to indicate how to interpret missing value for some fields. Missing
     * values are fields present in user schema but missing in rows. The key is
     * the field name. The value is the interpretation of missing values for the
     * field.
     *
     * For example, a map {'foo': NULL_VALUE, 'bar': DEFAULT_VALUE} means all
     * missing values in field foo are interpreted as NULL, all missing values in
     * field bar are interpreted as the default value of field bar in table
     * schema.
     *
     * If a field is not in this map and has missing values, the missing values
     * in this field are interpreted as NULL.
     *
     * This field only applies to the current request, it won't affect other
     * requests on the connection.
     *
     * Currently, field name can only be top-level column name, can't be a struct
     * field path like 'foo.bar'.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.bigquery.storage.v1.AppendRowsRequest.MissingValueInterpretation&gt; missing_value_interpretations = 7;
     * </code>
     */
    @java.lang.Override
    public /* nullable */ com.google.cloud.bigquery.storage.v1.AppendRowsRequest
            .MissingValueInterpretation
        getMissingValueInterpretationsOrDefault(
            java.lang.String key,
            /* nullable */
            com.google.cloud.bigquery.storage.v1.AppendRowsRequest.MissingValueInterpretation
                defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.Integer> map =
          internalGetMissingValueInterpretations().getMap();
      return map.containsKey(key)
          ? missingValueInterpretationsValueConverter.doForward(map.get(key))
          : defaultValue;
    }

    /**
     *
     *
     * <pre>
     * A map to indicate how to interpret missing value for some fields. Missing
     * values are fields present in user schema but missing in rows. The key is
     * the field name. The value is the interpretation of missing values for the
     * field.
     *
     * For example, a map {'foo': NULL_VALUE, 'bar': DEFAULT_VALUE} means all
     * missing values in field foo are interpreted as NULL, all missing values in
     * field bar are interpreted as the default value of field bar in table
     * schema.
     *
     * If a field is not in this map and has missing values, the missing values
     * in this field are interpreted as NULL.
     *
     * This field only applies to the current request, it won't affect other
     * requests on the connection.
     *
     * Currently, field name can only be top-level column name, can't be a struct
     * field path like 'foo.bar'.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.bigquery.storage.v1.AppendRowsRequest.MissingValueInterpretation&gt; missing_value_interpretations = 7;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.bigquery.storage.v1.AppendRowsRequest.MissingValueInterpretation
        getMissingValueInterpretationsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.Integer> map =
          internalGetMissingValueInterpretations().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return missingValueInterpretationsValueConverter.doForward(map.get(key));
    }

    /** Use {@link #getMissingValueInterpretationsValueMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.Integer>
        getMissingValueInterpretationsValue() {
      return getMissingValueInterpretationsValueMap();
    }

    /**
     *
     *
     * <pre>
     * A map to indicate how to interpret missing value for some fields. Missing
     * values are fields present in user schema but missing in rows. The key is
     * the field name. The value is the interpretation of missing values for the
     * field.
     *
     * For example, a map {'foo': NULL_VALUE, 'bar': DEFAULT_VALUE} means all
     * missing values in field foo are interpreted as NULL, all missing values in
     * field bar are interpreted as the default value of field bar in table
     * schema.
     *
     * If a field is not in this map and has missing values, the missing values
     * in this field are interpreted as NULL.
     *
     * This field only applies to the current request, it won't affect other
     * requests on the connection.
     *
     * Currently, field name can only be top-level column name, can't be a struct
     * field path like 'foo.bar'.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.bigquery.storage.v1.AppendRowsRequest.MissingValueInterpretation&gt; missing_value_interpretations = 7;
     * </code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.Integer>
        getMissingValueInterpretationsValueMap() {
      return internalGetMissingValueInterpretations().getMap();
    }

    /**
     *
     *
     * <pre>
     * A map to indicate how to interpret missing value for some fields. Missing
     * values are fields present in user schema but missing in rows. The key is
     * the field name. The value is the interpretation of missing values for the
     * field.
     *
     * For example, a map {'foo': NULL_VALUE, 'bar': DEFAULT_VALUE} means all
     * missing values in field foo are interpreted as NULL, all missing values in
     * field bar are interpreted as the default value of field bar in table
     * schema.
     *
     * If a field is not in this map and has missing values, the missing values
     * in this field are interpreted as NULL.
     *
     * This field only applies to the current request, it won't affect other
     * requests on the connection.
     *
     * Currently, field name can only be top-level column name, can't be a struct
     * field path like 'foo.bar'.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.bigquery.storage.v1.AppendRowsRequest.MissingValueInterpretation&gt; missing_value_interpretations = 7;
     * </code>
     */
    @java.lang.Override
    public int getMissingValueInterpretationsValueOrDefault(
        java.lang.String key, int defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.Integer> map =
          internalGetMissingValueInterpretations().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }

    /**
     *
     *
     * <pre>
     * A map to indicate how to interpret missing value for some fields. Missing
     * values are fields present in user schema but missing in rows. The key is
     * the field name. The value is the interpretation of missing values for the
     * field.
     *
     * For example, a map {'foo': NULL_VALUE, 'bar': DEFAULT_VALUE} means all
     * missing values in field foo are interpreted as NULL, all missing values in
     * field bar are interpreted as the default value of field bar in table
     * schema.
     *
     * If a field is not in this map and has missing values, the missing values
     * in this field are interpreted as NULL.
     *
     * This field only applies to the current request, it won't affect other
     * requests on the connection.
     *
     * Currently, field name can only be top-level column name, can't be a struct
     * field path like 'foo.bar'.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.bigquery.storage.v1.AppendRowsRequest.MissingValueInterpretation&gt; missing_value_interpretations = 7;
     * </code>
     */
    @java.lang.Override
    public int getMissingValueInterpretationsValueOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.Integer> map =
          internalGetMissingValueInterpretations().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearMissingValueInterpretations() {
      bitField0_ = (bitField0_ & ~0x00000020);
      internalGetMutableMissingValueInterpretations().getMutableMap().clear();
      return this;
    }

    /**
     *
     *
     * <pre>
     * A map to indicate how to interpret missing value for some fields. Missing
     * values are fields present in user schema but missing in rows. The key is
     * the field name. The value is the interpretation of missing values for the
     * field.
     *
     * For example, a map {'foo': NULL_VALUE, 'bar': DEFAULT_VALUE} means all
     * missing values in field foo are interpreted as NULL, all missing values in
     * field bar are interpreted as the default value of field bar in table
     * schema.
     *
     * If a field is not in this map and has missing values, the missing values
     * in this field are interpreted as NULL.
     *
     * This field only applies to the current request, it won't affect other
     * requests on the connection.
     *
     * Currently, field name can only be top-level column name, can't be a struct
     * field path like 'foo.bar'.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.bigquery.storage.v1.AppendRowsRequest.MissingValueInterpretation&gt; missing_value_interpretations = 7;
     * </code>
     */
    public Builder removeMissingValueInterpretations(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableMissingValueInterpretations().getMutableMap().remove(key);
      return this;
    }

    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<
            java.lang.String,
            com.google.cloud.bigquery.storage.v1.AppendRowsRequest.MissingValueInterpretation>
        getMutableMissingValueInterpretations() {
      bitField0_ |= 0x00000020;
      return internalGetAdaptedMissingValueInterpretationsMap(
          internalGetMutableMissingValueInterpretations().getMutableMap());
    }

    /**
     *
     *
     * <pre>
     * A map to indicate how to interpret missing value for some fields. Missing
     * values are fields present in user schema but missing in rows. The key is
     * the field name. The value is the interpretation of missing values for the
     * field.
     *
     * For example, a map {'foo': NULL_VALUE, 'bar': DEFAULT_VALUE} means all
     * missing values in field foo are interpreted as NULL, all missing values in
     * field bar are interpreted as the default value of field bar in table
     * schema.
     *
     * If a field is not in this map and has missing values, the missing values
     * in this field are interpreted as NULL.
     *
     * This field only applies to the current request, it won't affect other
     * requests on the connection.
     *
     * Currently, field name can only be top-level column name, can't be a struct
     * field path like 'foo.bar'.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.bigquery.storage.v1.AppendRowsRequest.MissingValueInterpretation&gt; missing_value_interpretations = 7;
     * </code>
     */
    public Builder putMissingValueInterpretations(
        java.lang.String key,
        com.google.cloud.bigquery.storage.v1.AppendRowsRequest.MissingValueInterpretation value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }

      internalGetMutableMissingValueInterpretations()
          .getMutableMap()
          .put(key, missingValueInterpretationsValueConverter.doBackward(value));
      bitField0_ |= 0x00000020;
      return this;
    }

    /**
     *
     *
     * <pre>
     * A map to indicate how to interpret missing value for some fields. Missing
     * values are fields present in user schema but missing in rows. The key is
     * the field name. The value is the interpretation of missing values for the
     * field.
     *
     * For example, a map {'foo': NULL_VALUE, 'bar': DEFAULT_VALUE} means all
     * missing values in field foo are interpreted as NULL, all missing values in
     * field bar are interpreted as the default value of field bar in table
     * schema.
     *
     * If a field is not in this map and has missing values, the missing values
     * in this field are interpreted as NULL.
     *
     * This field only applies to the current request, it won't affect other
     * requests on the connection.
     *
     * Currently, field name can only be top-level column name, can't be a struct
     * field path like 'foo.bar'.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.bigquery.storage.v1.AppendRowsRequest.MissingValueInterpretation&gt; missing_value_interpretations = 7;
     * </code>
     */
    public Builder putAllMissingValueInterpretations(
        java.util.Map<
                java.lang.String,
                com.google.cloud.bigquery.storage.v1.AppendRowsRequest.MissingValueInterpretation>
            values) {
      internalGetAdaptedMissingValueInterpretationsMap(
              internalGetMutableMissingValueInterpretations().getMutableMap())
          .putAll(values);
      bitField0_ |= 0x00000020;
      return this;
    }

    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.Integer>
        getMutableMissingValueInterpretationsValue() {
      bitField0_ |= 0x00000020;
      return internalGetMutableMissingValueInterpretations().getMutableMap();
    }

    /**
     *
     *
     * <pre>
     * A map to indicate how to interpret missing value for some fields. Missing
     * values are fields present in user schema but missing in rows. The key is
     * the field name. The value is the interpretation of missing values for the
     * field.
     *
     * For example, a map {'foo': NULL_VALUE, 'bar': DEFAULT_VALUE} means all
     * missing values in field foo are interpreted as NULL, all missing values in
     * field bar are interpreted as the default value of field bar in table
     * schema.
     *
     * If a field is not in this map and has missing values, the missing values
     * in this field are interpreted as NULL.
     *
     * This field only applies to the current request, it won't affect other
     * requests on the connection.
     *
     * Currently, field name can only be top-level column name, can't be a struct
     * field path like 'foo.bar'.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.bigquery.storage.v1.AppendRowsRequest.MissingValueInterpretation&gt; missing_value_interpretations = 7;
     * </code>
     */
    public Builder putMissingValueInterpretationsValue(java.lang.String key, int value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }

      internalGetMutableMissingValueInterpretations().getMutableMap().put(key, value);
      bitField0_ |= 0x00000020;
      return this;
    }

    /**
     *
     *
     * <pre>
     * A map to indicate how to interpret missing value for some fields. Missing
     * values are fields present in user schema but missing in rows. The key is
     * the field name. The value is the interpretation of missing values for the
     * field.
     *
     * For example, a map {'foo': NULL_VALUE, 'bar': DEFAULT_VALUE} means all
     * missing values in field foo are interpreted as NULL, all missing values in
     * field bar are interpreted as the default value of field bar in table
     * schema.
     *
     * If a field is not in this map and has missing values, the missing values
     * in this field are interpreted as NULL.
     *
     * This field only applies to the current request, it won't affect other
     * requests on the connection.
     *
     * Currently, field name can only be top-level column name, can't be a struct
     * field path like 'foo.bar'.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.bigquery.storage.v1.AppendRowsRequest.MissingValueInterpretation&gt; missing_value_interpretations = 7;
     * </code>
     */
    public Builder putAllMissingValueInterpretationsValue(
        java.util.Map<java.lang.String, java.lang.Integer> values) {
      internalGetMutableMissingValueInterpretations().getMutableMap().putAll(values);
      bitField0_ |= 0x00000020;
      return this;
    }

    private int defaultMissingValueInterpretation_ = 0;

    /**
     *
     *
     * <pre>
     * Optional. Default missing value interpretation for all columns in the
     * table. When a value is specified on an `AppendRowsRequest`, it is applied
     * to all requests from that point forward, until a subsequent
     * `AppendRowsRequest` sets it to a different value.
     * `missing_value_interpretation` can override
     * `default_missing_value_interpretation`. For example, if you want to write
     * `NULL` instead of using default values for some columns, you can set
     * `default_missing_value_interpretation` to `DEFAULT_VALUE` and at the same
     * time, set `missing_value_interpretations` to `NULL_VALUE` on those columns.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.storage.v1.AppendRowsRequest.MissingValueInterpretation default_missing_value_interpretation = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The enum numeric value on the wire for defaultMissingValueInterpretation.
     */
    @java.lang.Override
    public int getDefaultMissingValueInterpretationValue() {
      return defaultMissingValueInterpretation_;
    }

    /**
     *
     *
     * <pre>
     * Optional. Default missing value interpretation for all columns in the
     * table. When a value is specified on an `AppendRowsRequest`, it is applied
     * to all requests from that point forward, until a subsequent
     * `AppendRowsRequest` sets it to a different value.
     * `missing_value_interpretation` can override
     * `default_missing_value_interpretation`. For example, if you want to write
     * `NULL` instead of using default values for some columns, you can set
     * `default_missing_value_interpretation` to `DEFAULT_VALUE` and at the same
     * time, set `missing_value_interpretations` to `NULL_VALUE` on those columns.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.storage.v1.AppendRowsRequest.MissingValueInterpretation default_missing_value_interpretation = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The enum numeric value on the wire for defaultMissingValueInterpretation to set.
     * @return This builder for chaining.
     */
    public Builder setDefaultMissingValueInterpretationValue(int value) {
      defaultMissingValueInterpretation_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Default missing value interpretation for all columns in the
     * table. When a value is specified on an `AppendRowsRequest`, it is applied
     * to all requests from that point forward, until a subsequent
     * `AppendRowsRequest` sets it to a different value.
     * `missing_value_interpretation` can override
     * `default_missing_value_interpretation`. For example, if you want to write
     * `NULL` instead of using default values for some columns, you can set
     * `default_missing_value_interpretation` to `DEFAULT_VALUE` and at the same
     * time, set `missing_value_interpretations` to `NULL_VALUE` on those columns.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.storage.v1.AppendRowsRequest.MissingValueInterpretation default_missing_value_interpretation = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The defaultMissingValueInterpretation.
     */
    @java.lang.Override
    public com.google.cloud.bigquery.storage.v1.AppendRowsRequest.MissingValueInterpretation
        getDefaultMissingValueInterpretation() {
      com.google.cloud.bigquery.storage.v1.AppendRowsRequest.MissingValueInterpretation result =
          com.google.cloud.bigquery.storage.v1.AppendRowsRequest.MissingValueInterpretation
              .forNumber(defaultMissingValueInterpretation_);
      return result == null
          ? com.google.cloud.bigquery.storage.v1.AppendRowsRequest.MissingValueInterpretation
              .UNRECOGNIZED
          : result;
    }

    /**
     *
     *
     * <pre>
     * Optional. Default missing value interpretation for all columns in the
     * table. When a value is specified on an `AppendRowsRequest`, it is applied
     * to all requests from that point forward, until a subsequent
     * `AppendRowsRequest` sets it to a different value.
     * `missing_value_interpretation` can override
     * `default_missing_value_interpretation`. For example, if you want to write
     * `NULL` instead of using default values for some columns, you can set
     * `default_missing_value_interpretation` to `DEFAULT_VALUE` and at the same
     * time, set `missing_value_interpretations` to `NULL_VALUE` on those columns.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.storage.v1.AppendRowsRequest.MissingValueInterpretation default_missing_value_interpretation = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The defaultMissingValueInterpretation to set.
     * @return This builder for chaining.
     */
    public Builder setDefaultMissingValueInterpretation(
        com.google.cloud.bigquery.storage.v1.AppendRowsRequest.MissingValueInterpretation value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000040;
      defaultMissingValueInterpretation_ = value.getNumber();
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Default missing value interpretation for all columns in the
     * table. When a value is specified on an `AppendRowsRequest`, it is applied
     * to all requests from that point forward, until a subsequent
     * `AppendRowsRequest` sets it to a different value.
     * `missing_value_interpretation` can override
     * `default_missing_value_interpretation`. For example, if you want to write
     * `NULL` instead of using default values for some columns, you can set
     * `default_missing_value_interpretation` to `DEFAULT_VALUE` and at the same
     * time, set `missing_value_interpretations` to `NULL_VALUE` on those columns.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.storage.v1.AppendRowsRequest.MissingValueInterpretation default_missing_value_interpretation = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDefaultMissingValueInterpretation() {
      bitField0_ = (bitField0_ & ~0x00000040);
      defaultMissingValueInterpretation_ = 0;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.bigquery.storage.v1.AppendRowsRequest)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.bigquery.storage.v1.AppendRowsRequest)
  private static final com.google.cloud.bigquery.storage.v1.AppendRowsRequest DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.bigquery.storage.v1.AppendRowsRequest();
  }

  public static com.google.cloud.bigquery.storage.v1.AppendRowsRequest getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<AppendRowsRequest> PARSER =
      new com.google.protobuf.AbstractParser<AppendRowsRequest>() {
        @java.lang.Override
        public AppendRowsRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<AppendRowsRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<AppendRowsRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.bigquery.storage.v1.AppendRowsRequest getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
