/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.analyticshub.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class QueryTemplateName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_DATA_EXCHANGE_QUERY_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/dataExchanges/{data_exchange}/queryTemplates/{query_template}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String dataExchange;
    private final String queryTemplate;

    @Deprecated
    protected QueryTemplateName() {
        this.project = null;
        this.location = null;
        this.dataExchange = null;
        this.queryTemplate = null;
    }

    private QueryTemplateName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.dataExchange = (String)Preconditions.checkNotNull((Object)builder.getDataExchange());
        this.queryTemplate = (String)Preconditions.checkNotNull((Object)builder.getQueryTemplate());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getDataExchange() {
        return this.dataExchange;
    }

    public String getQueryTemplate() {
        return this.queryTemplate;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static QueryTemplateName of(String project, String location, String dataExchange, String queryTemplate) {
        return QueryTemplateName.newBuilder().setProject(project).setLocation(location).setDataExchange(dataExchange).setQueryTemplate(queryTemplate).build();
    }

    public static String format(String project, String location, String dataExchange, String queryTemplate) {
        return QueryTemplateName.newBuilder().setProject(project).setLocation(location).setDataExchange(dataExchange).setQueryTemplate(queryTemplate).build().toString();
    }

    public static QueryTemplateName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_DATA_EXCHANGE_QUERY_TEMPLATE.validatedMatch(formattedString, "QueryTemplateName.parse: formattedString not in valid format");
        return QueryTemplateName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("data_exchange"), (String)matchMap.get("query_template"));
    }

    public static List<QueryTemplateName> parseList(List<String> formattedStrings) {
        ArrayList<QueryTemplateName> list = new ArrayList<QueryTemplateName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(QueryTemplateName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<QueryTemplateName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (QueryTemplateName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_DATA_EXCHANGE_QUERY_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            QueryTemplateName queryTemplateName = this;
            synchronized (queryTemplateName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.dataExchange != null) {
                        fieldMapBuilder.put((Object)"data_exchange", (Object)this.dataExchange);
                    }
                    if (this.queryTemplate != null) {
                        fieldMapBuilder.put((Object)"query_template", (Object)this.queryTemplate);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_DATA_EXCHANGE_QUERY_TEMPLATE.instantiate(new String[]{"project", this.project, "location", this.location, "data_exchange", this.dataExchange, "query_template", this.queryTemplate});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            QueryTemplateName that = (QueryTemplateName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.dataExchange, that.dataExchange) && Objects.equals(this.queryTemplate, that.queryTemplate);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.dataExchange);
        h *= 1000003;
        return h ^= Objects.hashCode(this.queryTemplate);
    }

    public static class Builder {
        private String project;
        private String location;
        private String dataExchange;
        private String queryTemplate;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getDataExchange() {
            return this.dataExchange;
        }

        public String getQueryTemplate() {
            return this.queryTemplate;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setDataExchange(String dataExchange) {
            this.dataExchange = dataExchange;
            return this;
        }

        public Builder setQueryTemplate(String queryTemplate) {
            this.queryTemplate = queryTemplate;
            return this;
        }

        private Builder(QueryTemplateName queryTemplateName) {
            this.project = queryTemplateName.project;
            this.location = queryTemplateName.location;
            this.dataExchange = queryTemplateName.dataExchange;
            this.queryTemplate = queryTemplateName.queryTemplate;
        }

        public QueryTemplateName build() {
            return new QueryTemplateName(this);
        }
    }
}

