/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/bigquery/analyticshub/v1/pubsub.proto

// Protobuf Java Version: 3.25.8
package com.google.cloud.bigquery.analyticshub.v1;

/**
 *
 *
 * <pre>
 * Defines the destination Pub/Sub subscription.
 * If none of `push_config`, `bigquery_config`, `cloud_storage_config`,
 * `pubsub_export_config`, or `pubsublite_export_config`
 * is set, then the subscriber will pull and ack messages using API methods. At
 * most one of these fields may be set.
 * </pre>
 *
 * Protobuf type {@code google.cloud.bigquery.analyticshub.v1.PubSubSubscription}
 */
public final class PubSubSubscription extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.bigquery.analyticshub.v1.PubSubSubscription)
    PubSubSubscriptionOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use PubSubSubscription.newBuilder() to construct.
  private PubSubSubscription(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private PubSubSubscription() {
    name_ = "";
    filter_ = "";
    messageTransforms_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new PubSubSubscription();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.bigquery.analyticshub.v1.PubsubProto
        .internal_static_google_cloud_bigquery_analyticshub_v1_PubSubSubscription_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
      int number) {
    switch (number) {
      case 9:
        return internalGetLabels();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.bigquery.analyticshub.v1.PubsubProto
        .internal_static_google_cloud_bigquery_analyticshub_v1_PubSubSubscription_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.bigquery.analyticshub.v1.PubSubSubscription.class,
            com.google.cloud.bigquery.analyticshub.v1.PubSubSubscription.Builder.class);
  }

  private int bitField0_;
  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";

  /**
   *
   *
   * <pre>
   * Required. Name of the subscription.
   * Format is `projects/{project}/subscriptions/{sub}`.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Required. Name of the subscription.
   * Format is `projects/{project}/subscriptions/{sub}`.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PUSH_CONFIG_FIELD_NUMBER = 4;
  private com.google.cloud.bigquery.analyticshub.v1.PushConfig pushConfig_;

  /**
   *
   *
   * <pre>
   * Optional. If push delivery is used with this subscription, this field is
   * used to configure it.
   * </pre>
   *
   * <code>
   * .google.cloud.bigquery.analyticshub.v1.PushConfig push_config = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the pushConfig field is set.
   */
  @java.lang.Override
  public boolean hasPushConfig() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * Optional. If push delivery is used with this subscription, this field is
   * used to configure it.
   * </pre>
   *
   * <code>
   * .google.cloud.bigquery.analyticshub.v1.PushConfig push_config = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The pushConfig.
   */
  @java.lang.Override
  public com.google.cloud.bigquery.analyticshub.v1.PushConfig getPushConfig() {
    return pushConfig_ == null
        ? com.google.cloud.bigquery.analyticshub.v1.PushConfig.getDefaultInstance()
        : pushConfig_;
  }

  /**
   *
   *
   * <pre>
   * Optional. If push delivery is used with this subscription, this field is
   * used to configure it.
   * </pre>
   *
   * <code>
   * .google.cloud.bigquery.analyticshub.v1.PushConfig push_config = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.bigquery.analyticshub.v1.PushConfigOrBuilder getPushConfigOrBuilder() {
    return pushConfig_ == null
        ? com.google.cloud.bigquery.analyticshub.v1.PushConfig.getDefaultInstance()
        : pushConfig_;
  }

  public static final int BIGQUERY_CONFIG_FIELD_NUMBER = 18;
  private com.google.cloud.bigquery.analyticshub.v1.BigQueryConfig bigqueryConfig_;

  /**
   *
   *
   * <pre>
   * Optional. If delivery to BigQuery is used with this subscription, this
   * field is used to configure it.
   * </pre>
   *
   * <code>
   * .google.cloud.bigquery.analyticshub.v1.BigQueryConfig bigquery_config = 18 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the bigqueryConfig field is set.
   */
  @java.lang.Override
  public boolean hasBigqueryConfig() {
    return ((bitField0_ & 0x00000002) != 0);
  }

  /**
   *
   *
   * <pre>
   * Optional. If delivery to BigQuery is used with this subscription, this
   * field is used to configure it.
   * </pre>
   *
   * <code>
   * .google.cloud.bigquery.analyticshub.v1.BigQueryConfig bigquery_config = 18 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The bigqueryConfig.
   */
  @java.lang.Override
  public com.google.cloud.bigquery.analyticshub.v1.BigQueryConfig getBigqueryConfig() {
    return bigqueryConfig_ == null
        ? com.google.cloud.bigquery.analyticshub.v1.BigQueryConfig.getDefaultInstance()
        : bigqueryConfig_;
  }

  /**
   *
   *
   * <pre>
   * Optional. If delivery to BigQuery is used with this subscription, this
   * field is used to configure it.
   * </pre>
   *
   * <code>
   * .google.cloud.bigquery.analyticshub.v1.BigQueryConfig bigquery_config = 18 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.bigquery.analyticshub.v1.BigQueryConfigOrBuilder
      getBigqueryConfigOrBuilder() {
    return bigqueryConfig_ == null
        ? com.google.cloud.bigquery.analyticshub.v1.BigQueryConfig.getDefaultInstance()
        : bigqueryConfig_;
  }

  public static final int CLOUD_STORAGE_CONFIG_FIELD_NUMBER = 22;
  private com.google.cloud.bigquery.analyticshub.v1.CloudStorageConfig cloudStorageConfig_;

  /**
   *
   *
   * <pre>
   * Optional. If delivery to Google Cloud Storage is used with this
   * subscription, this field is used to configure it.
   * </pre>
   *
   * <code>
   * .google.cloud.bigquery.analyticshub.v1.CloudStorageConfig cloud_storage_config = 22 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the cloudStorageConfig field is set.
   */
  @java.lang.Override
  public boolean hasCloudStorageConfig() {
    return ((bitField0_ & 0x00000004) != 0);
  }

  /**
   *
   *
   * <pre>
   * Optional. If delivery to Google Cloud Storage is used with this
   * subscription, this field is used to configure it.
   * </pre>
   *
   * <code>
   * .google.cloud.bigquery.analyticshub.v1.CloudStorageConfig cloud_storage_config = 22 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The cloudStorageConfig.
   */
  @java.lang.Override
  public com.google.cloud.bigquery.analyticshub.v1.CloudStorageConfig getCloudStorageConfig() {
    return cloudStorageConfig_ == null
        ? com.google.cloud.bigquery.analyticshub.v1.CloudStorageConfig.getDefaultInstance()
        : cloudStorageConfig_;
  }

  /**
   *
   *
   * <pre>
   * Optional. If delivery to Google Cloud Storage is used with this
   * subscription, this field is used to configure it.
   * </pre>
   *
   * <code>
   * .google.cloud.bigquery.analyticshub.v1.CloudStorageConfig cloud_storage_config = 22 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.bigquery.analyticshub.v1.CloudStorageConfigOrBuilder
      getCloudStorageConfigOrBuilder() {
    return cloudStorageConfig_ == null
        ? com.google.cloud.bigquery.analyticshub.v1.CloudStorageConfig.getDefaultInstance()
        : cloudStorageConfig_;
  }

  public static final int ACK_DEADLINE_SECONDS_FIELD_NUMBER = 5;
  private int ackDeadlineSeconds_ = 0;

  /**
   *
   *
   * <pre>
   * Optional. The approximate amount of time (on a best-effort basis) Pub/Sub
   * waits for the subscriber to acknowledge receipt before resending the
   * message. In the interval after the message is delivered and before it is
   * acknowledged, it is considered to be _outstanding_. During that time
   * period, the message will not be redelivered (on a best-effort basis).
   *
   * For pull subscriptions, this value is used as the initial value for the ack
   * deadline. To override this value for a given message, call
   * `ModifyAckDeadline` with the corresponding `ack_id` if using
   * non-streaming pull or send the `ack_id` in a
   * `StreamingModifyAckDeadlineRequest` if using streaming pull.
   * The minimum custom deadline you can specify is 10 seconds.
   * The maximum custom deadline you can specify is 600 seconds (10 minutes).
   * If this parameter is 0, a default value of 10 seconds is used.
   *
   * For push delivery, this value is also used to set the request timeout for
   * the call to the push endpoint.
   *
   * If the subscriber never acknowledges the message, the Pub/Sub
   * system will eventually redeliver the message.
   * </pre>
   *
   * <code>int32 ack_deadline_seconds = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The ackDeadlineSeconds.
   */
  @java.lang.Override
  public int getAckDeadlineSeconds() {
    return ackDeadlineSeconds_;
  }

  public static final int RETAIN_ACKED_MESSAGES_FIELD_NUMBER = 7;
  private boolean retainAckedMessages_ = false;

  /**
   *
   *
   * <pre>
   * Optional. Indicates whether to retain acknowledged messages. If true, then
   * messages are not expunged from the subscription's backlog, even if they are
   * acknowledged, until they fall out of the `message_retention_duration`
   * window. This must be true if you would like to [`Seek` to a timestamp]
   * (https://cloud.google.com/pubsub/docs/replay-overview#seek_to_a_time) in
   * the past to replay previously-acknowledged messages.
   * </pre>
   *
   * <code>bool retain_acked_messages = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The retainAckedMessages.
   */
  @java.lang.Override
  public boolean getRetainAckedMessages() {
    return retainAckedMessages_;
  }

  public static final int MESSAGE_RETENTION_DURATION_FIELD_NUMBER = 8;
  private com.google.protobuf.Duration messageRetentionDuration_;

  /**
   *
   *
   * <pre>
   * Optional. How long to retain unacknowledged messages in the subscription's
   * backlog, from the moment a message is published. If `retain_acked_messages`
   * is true, then this also configures the retention of acknowledged messages,
   * and thus configures how far back in time a `Seek` can be done. Defaults to
   * 7 days. Cannot be more than 31 days or less than 10 minutes.
   * </pre>
   *
   * <code>
   * .google.protobuf.Duration message_retention_duration = 8 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the messageRetentionDuration field is set.
   */
  @java.lang.Override
  public boolean hasMessageRetentionDuration() {
    return ((bitField0_ & 0x00000008) != 0);
  }

  /**
   *
   *
   * <pre>
   * Optional. How long to retain unacknowledged messages in the subscription's
   * backlog, from the moment a message is published. If `retain_acked_messages`
   * is true, then this also configures the retention of acknowledged messages,
   * and thus configures how far back in time a `Seek` can be done. Defaults to
   * 7 days. Cannot be more than 31 days or less than 10 minutes.
   * </pre>
   *
   * <code>
   * .google.protobuf.Duration message_retention_duration = 8 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The messageRetentionDuration.
   */
  @java.lang.Override
  public com.google.protobuf.Duration getMessageRetentionDuration() {
    return messageRetentionDuration_ == null
        ? com.google.protobuf.Duration.getDefaultInstance()
        : messageRetentionDuration_;
  }

  /**
   *
   *
   * <pre>
   * Optional. How long to retain unacknowledged messages in the subscription's
   * backlog, from the moment a message is published. If `retain_acked_messages`
   * is true, then this also configures the retention of acknowledged messages,
   * and thus configures how far back in time a `Seek` can be done. Defaults to
   * 7 days. Cannot be more than 31 days or less than 10 minutes.
   * </pre>
   *
   * <code>
   * .google.protobuf.Duration message_retention_duration = 8 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.DurationOrBuilder getMessageRetentionDurationOrBuilder() {
    return messageRetentionDuration_ == null
        ? com.google.protobuf.Duration.getDefaultInstance()
        : messageRetentionDuration_;
  }

  public static final int LABELS_FIELD_NUMBER = 9;

  private static final class LabelsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.cloud.bigquery.analyticshub.v1.PubsubProto
                .internal_static_google_cloud_bigquery_analyticshub_v1_PubSubSubscription_LabelsEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
    if (labels_ == null) {
      return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
    }
    return labels_;
  }

  public int getLabelsCount() {
    return internalGetLabels().getMap().size();
  }

  /**
   *
   *
   * <pre>
   * Optional. See [Creating and managing
   * labels](https://cloud.google.com/pubsub/docs/labels).
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  @java.lang.Override
  public boolean containsLabels(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetLabels().getMap().containsKey(key);
  }

  /** Use {@link #getLabelsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getLabels() {
    return getLabelsMap();
  }

  /**
   *
   *
   * <pre>
   * Optional. See [Creating and managing
   * labels](https://cloud.google.com/pubsub/docs/labels).
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
    return internalGetLabels().getMap();
  }

  /**
   *
   *
   * <pre>
   * Optional. See [Creating and managing
   * labels](https://cloud.google.com/pubsub/docs/labels).
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  @java.lang.Override
  public /* nullable */ java.lang.String getLabelsOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }

  /**
   *
   *
   * <pre>
   * Optional. See [Creating and managing
   * labels](https://cloud.google.com/pubsub/docs/labels).
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  @java.lang.Override
  public java.lang.String getLabelsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int ENABLE_MESSAGE_ORDERING_FIELD_NUMBER = 10;
  private boolean enableMessageOrdering_ = false;

  /**
   *
   *
   * <pre>
   * Optional. If true, messages published with the same `ordering_key` in
   * `PubsubMessage` will be delivered to the subscribers in the order in which
   * they are received by the Pub/Sub system. Otherwise, they may be delivered
   * in any order.
   * </pre>
   *
   * <code>bool enable_message_ordering = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The enableMessageOrdering.
   */
  @java.lang.Override
  public boolean getEnableMessageOrdering() {
    return enableMessageOrdering_;
  }

  public static final int EXPIRATION_POLICY_FIELD_NUMBER = 11;
  private com.google.cloud.bigquery.analyticshub.v1.ExpirationPolicy expirationPolicy_;

  /**
   *
   *
   * <pre>
   * Optional. A policy that specifies the conditions for this subscription's
   * expiration. A subscription is considered active as long as any connected
   * subscriber is successfully consuming messages from the subscription or is
   * issuing operations on the subscription. If `expiration_policy` is not set,
   * a *default policy* with `ttl` of 31 days will be used. The minimum allowed
   * value for `expiration_policy.ttl` is 1 day. If `expiration_policy` is set,
   * but `expiration_policy.ttl` is not set, the subscription never expires.
   * </pre>
   *
   * <code>
   * .google.cloud.bigquery.analyticshub.v1.ExpirationPolicy expiration_policy = 11 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the expirationPolicy field is set.
   */
  @java.lang.Override
  public boolean hasExpirationPolicy() {
    return ((bitField0_ & 0x00000010) != 0);
  }

  /**
   *
   *
   * <pre>
   * Optional. A policy that specifies the conditions for this subscription's
   * expiration. A subscription is considered active as long as any connected
   * subscriber is successfully consuming messages from the subscription or is
   * issuing operations on the subscription. If `expiration_policy` is not set,
   * a *default policy* with `ttl` of 31 days will be used. The minimum allowed
   * value for `expiration_policy.ttl` is 1 day. If `expiration_policy` is set,
   * but `expiration_policy.ttl` is not set, the subscription never expires.
   * </pre>
   *
   * <code>
   * .google.cloud.bigquery.analyticshub.v1.ExpirationPolicy expiration_policy = 11 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The expirationPolicy.
   */
  @java.lang.Override
  public com.google.cloud.bigquery.analyticshub.v1.ExpirationPolicy getExpirationPolicy() {
    return expirationPolicy_ == null
        ? com.google.cloud.bigquery.analyticshub.v1.ExpirationPolicy.getDefaultInstance()
        : expirationPolicy_;
  }

  /**
   *
   *
   * <pre>
   * Optional. A policy that specifies the conditions for this subscription's
   * expiration. A subscription is considered active as long as any connected
   * subscriber is successfully consuming messages from the subscription or is
   * issuing operations on the subscription. If `expiration_policy` is not set,
   * a *default policy* with `ttl` of 31 days will be used. The minimum allowed
   * value for `expiration_policy.ttl` is 1 day. If `expiration_policy` is set,
   * but `expiration_policy.ttl` is not set, the subscription never expires.
   * </pre>
   *
   * <code>
   * .google.cloud.bigquery.analyticshub.v1.ExpirationPolicy expiration_policy = 11 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.bigquery.analyticshub.v1.ExpirationPolicyOrBuilder
      getExpirationPolicyOrBuilder() {
    return expirationPolicy_ == null
        ? com.google.cloud.bigquery.analyticshub.v1.ExpirationPolicy.getDefaultInstance()
        : expirationPolicy_;
  }

  public static final int FILTER_FIELD_NUMBER = 12;

  @SuppressWarnings("serial")
  private volatile java.lang.Object filter_ = "";

  /**
   *
   *
   * <pre>
   * Optional. An expression written in the Pub/Sub [filter
   * language](https://cloud.google.com/pubsub/docs/filtering). If non-empty,
   * then only `PubsubMessage`s whose `attributes` field matches the filter are
   * delivered on this subscription. If empty, then no messages are filtered
   * out.
   * </pre>
   *
   * <code>string filter = 12 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The filter.
   */
  @java.lang.Override
  public java.lang.String getFilter() {
    java.lang.Object ref = filter_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      filter_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Optional. An expression written in the Pub/Sub [filter
   * language](https://cloud.google.com/pubsub/docs/filtering). If non-empty,
   * then only `PubsubMessage`s whose `attributes` field matches the filter are
   * delivered on this subscription. If empty, then no messages are filtered
   * out.
   * </pre>
   *
   * <code>string filter = 12 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for filter.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getFilterBytes() {
    java.lang.Object ref = filter_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      filter_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DEAD_LETTER_POLICY_FIELD_NUMBER = 13;
  private com.google.cloud.bigquery.analyticshub.v1.DeadLetterPolicy deadLetterPolicy_;

  /**
   *
   *
   * <pre>
   * Optional. A policy that specifies the conditions for dead lettering
   * messages in this subscription. If dead_letter_policy is not set, dead
   * lettering is disabled.
   *
   * The Pub/Sub service account associated with this subscriptions's
   * parent project (i.e.,
   * service-{project_number}&#64;gcp-sa-pubsub.iam.gserviceaccount.com) must have
   * permission to Acknowledge() messages on this subscription.
   * </pre>
   *
   * <code>
   * .google.cloud.bigquery.analyticshub.v1.DeadLetterPolicy dead_letter_policy = 13 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the deadLetterPolicy field is set.
   */
  @java.lang.Override
  public boolean hasDeadLetterPolicy() {
    return ((bitField0_ & 0x00000020) != 0);
  }

  /**
   *
   *
   * <pre>
   * Optional. A policy that specifies the conditions for dead lettering
   * messages in this subscription. If dead_letter_policy is not set, dead
   * lettering is disabled.
   *
   * The Pub/Sub service account associated with this subscriptions's
   * parent project (i.e.,
   * service-{project_number}&#64;gcp-sa-pubsub.iam.gserviceaccount.com) must have
   * permission to Acknowledge() messages on this subscription.
   * </pre>
   *
   * <code>
   * .google.cloud.bigquery.analyticshub.v1.DeadLetterPolicy dead_letter_policy = 13 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The deadLetterPolicy.
   */
  @java.lang.Override
  public com.google.cloud.bigquery.analyticshub.v1.DeadLetterPolicy getDeadLetterPolicy() {
    return deadLetterPolicy_ == null
        ? com.google.cloud.bigquery.analyticshub.v1.DeadLetterPolicy.getDefaultInstance()
        : deadLetterPolicy_;
  }

  /**
   *
   *
   * <pre>
   * Optional. A policy that specifies the conditions for dead lettering
   * messages in this subscription. If dead_letter_policy is not set, dead
   * lettering is disabled.
   *
   * The Pub/Sub service account associated with this subscriptions's
   * parent project (i.e.,
   * service-{project_number}&#64;gcp-sa-pubsub.iam.gserviceaccount.com) must have
   * permission to Acknowledge() messages on this subscription.
   * </pre>
   *
   * <code>
   * .google.cloud.bigquery.analyticshub.v1.DeadLetterPolicy dead_letter_policy = 13 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.bigquery.analyticshub.v1.DeadLetterPolicyOrBuilder
      getDeadLetterPolicyOrBuilder() {
    return deadLetterPolicy_ == null
        ? com.google.cloud.bigquery.analyticshub.v1.DeadLetterPolicy.getDefaultInstance()
        : deadLetterPolicy_;
  }

  public static final int RETRY_POLICY_FIELD_NUMBER = 14;
  private com.google.cloud.bigquery.analyticshub.v1.RetryPolicy retryPolicy_;

  /**
   *
   *
   * <pre>
   * Optional. A policy that specifies how Pub/Sub retries message delivery for
   * this subscription.
   *
   * If not set, the default retry policy is applied. This generally implies
   * that messages will be retried as soon as possible for healthy subscribers.
   * RetryPolicy will be triggered on NACKs or acknowledgement deadline
   * exceeded events for a given message.
   * </pre>
   *
   * <code>
   * .google.cloud.bigquery.analyticshub.v1.RetryPolicy retry_policy = 14 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the retryPolicy field is set.
   */
  @java.lang.Override
  public boolean hasRetryPolicy() {
    return ((bitField0_ & 0x00000040) != 0);
  }

  /**
   *
   *
   * <pre>
   * Optional. A policy that specifies how Pub/Sub retries message delivery for
   * this subscription.
   *
   * If not set, the default retry policy is applied. This generally implies
   * that messages will be retried as soon as possible for healthy subscribers.
   * RetryPolicy will be triggered on NACKs or acknowledgement deadline
   * exceeded events for a given message.
   * </pre>
   *
   * <code>
   * .google.cloud.bigquery.analyticshub.v1.RetryPolicy retry_policy = 14 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The retryPolicy.
   */
  @java.lang.Override
  public com.google.cloud.bigquery.analyticshub.v1.RetryPolicy getRetryPolicy() {
    return retryPolicy_ == null
        ? com.google.cloud.bigquery.analyticshub.v1.RetryPolicy.getDefaultInstance()
        : retryPolicy_;
  }

  /**
   *
   *
   * <pre>
   * Optional. A policy that specifies how Pub/Sub retries message delivery for
   * this subscription.
   *
   * If not set, the default retry policy is applied. This generally implies
   * that messages will be retried as soon as possible for healthy subscribers.
   * RetryPolicy will be triggered on NACKs or acknowledgement deadline
   * exceeded events for a given message.
   * </pre>
   *
   * <code>
   * .google.cloud.bigquery.analyticshub.v1.RetryPolicy retry_policy = 14 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.bigquery.analyticshub.v1.RetryPolicyOrBuilder getRetryPolicyOrBuilder() {
    return retryPolicy_ == null
        ? com.google.cloud.bigquery.analyticshub.v1.RetryPolicy.getDefaultInstance()
        : retryPolicy_;
  }

  public static final int DETACHED_FIELD_NUMBER = 15;
  private boolean detached_ = false;

  /**
   *
   *
   * <pre>
   * Optional. Indicates whether the subscription is detached from its topic.
   * Detached subscriptions don't receive messages from their topic and don't
   * retain any backlog. `Pull` and `StreamingPull` requests will return
   * FAILED_PRECONDITION. If the subscription is a push subscription, pushes to
   * the endpoint will not be made.
   * </pre>
   *
   * <code>bool detached = 15 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The detached.
   */
  @java.lang.Override
  public boolean getDetached() {
    return detached_;
  }

  public static final int ENABLE_EXACTLY_ONCE_DELIVERY_FIELD_NUMBER = 16;
  private boolean enableExactlyOnceDelivery_ = false;

  /**
   *
   *
   * <pre>
   * Optional. If true, Pub/Sub provides the following guarantees for the
   * delivery of a message with a given value of `message_id` on this
   * subscription:
   *
   * * The message sent to a subscriber is guaranteed not to be resent
   * before the message's acknowledgement deadline expires.
   * * An acknowledged message will not be resent to a subscriber.
   *
   * Note that subscribers may still receive multiple copies of a message
   * when `enable_exactly_once_delivery` is true if the message was published
   * multiple times by a publisher client. These copies are  considered distinct
   * by Pub/Sub and have distinct `message_id` values.
   * </pre>
   *
   * <code>bool enable_exactly_once_delivery = 16 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The enableExactlyOnceDelivery.
   */
  @java.lang.Override
  public boolean getEnableExactlyOnceDelivery() {
    return enableExactlyOnceDelivery_;
  }

  public static final int MESSAGE_TRANSFORMS_FIELD_NUMBER = 25;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.bigquery.analyticshub.v1.MessageTransform>
      messageTransforms_;

  /**
   *
   *
   * <pre>
   * Optional. Transforms to be applied to messages before they are delivered to
   * subscribers. Transforms are applied in the order specified.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.bigquery.analyticshub.v1.MessageTransform message_transforms = 25 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.bigquery.analyticshub.v1.MessageTransform>
      getMessageTransformsList() {
    return messageTransforms_;
  }

  /**
   *
   *
   * <pre>
   * Optional. Transforms to be applied to messages before they are delivered to
   * subscribers. Transforms are applied in the order specified.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.bigquery.analyticshub.v1.MessageTransform message_transforms = 25 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends com.google.cloud.bigquery.analyticshub.v1.MessageTransformOrBuilder>
      getMessageTransformsOrBuilderList() {
    return messageTransforms_;
  }

  /**
   *
   *
   * <pre>
   * Optional. Transforms to be applied to messages before they are delivered to
   * subscribers. Transforms are applied in the order specified.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.bigquery.analyticshub.v1.MessageTransform message_transforms = 25 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public int getMessageTransformsCount() {
    return messageTransforms_.size();
  }

  /**
   *
   *
   * <pre>
   * Optional. Transforms to be applied to messages before they are delivered to
   * subscribers. Transforms are applied in the order specified.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.bigquery.analyticshub.v1.MessageTransform message_transforms = 25 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.bigquery.analyticshub.v1.MessageTransform getMessageTransforms(
      int index) {
    return messageTransforms_.get(index);
  }

  /**
   *
   *
   * <pre>
   * Optional. Transforms to be applied to messages before they are delivered to
   * subscribers. Transforms are applied in the order specified.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.bigquery.analyticshub.v1.MessageTransform message_transforms = 25 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.bigquery.analyticshub.v1.MessageTransformOrBuilder
      getMessageTransformsOrBuilder(int index) {
    return messageTransforms_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(4, getPushConfig());
    }
    if (ackDeadlineSeconds_ != 0) {
      output.writeInt32(5, ackDeadlineSeconds_);
    }
    if (retainAckedMessages_ != false) {
      output.writeBool(7, retainAckedMessages_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      output.writeMessage(8, getMessageRetentionDuration());
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetLabels(), LabelsDefaultEntryHolder.defaultEntry, 9);
    if (enableMessageOrdering_ != false) {
      output.writeBool(10, enableMessageOrdering_);
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      output.writeMessage(11, getExpirationPolicy());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(filter_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 12, filter_);
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      output.writeMessage(13, getDeadLetterPolicy());
    }
    if (((bitField0_ & 0x00000040) != 0)) {
      output.writeMessage(14, getRetryPolicy());
    }
    if (detached_ != false) {
      output.writeBool(15, detached_);
    }
    if (enableExactlyOnceDelivery_ != false) {
      output.writeBool(16, enableExactlyOnceDelivery_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(18, getBigqueryConfig());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(22, getCloudStorageConfig());
    }
    for (int i = 0; i < messageTransforms_.size(); i++) {
      output.writeMessage(25, messageTransforms_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getPushConfig());
    }
    if (ackDeadlineSeconds_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(5, ackDeadlineSeconds_);
    }
    if (retainAckedMessages_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(7, retainAckedMessages_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              8, getMessageRetentionDuration());
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetLabels().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
          LabelsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(9, labels__);
    }
    if (enableMessageOrdering_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(10, enableMessageOrdering_);
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(11, getExpirationPolicy());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(filter_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(12, filter_);
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(13, getDeadLetterPolicy());
    }
    if (((bitField0_ & 0x00000040) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(14, getRetryPolicy());
    }
    if (detached_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(15, detached_);
    }
    if (enableExactlyOnceDelivery_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(16, enableExactlyOnceDelivery_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(18, getBigqueryConfig());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(22, getCloudStorageConfig());
    }
    for (int i = 0; i < messageTransforms_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(25, messageTransforms_.get(i));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.bigquery.analyticshub.v1.PubSubSubscription)) {
      return super.equals(obj);
    }
    com.google.cloud.bigquery.analyticshub.v1.PubSubSubscription other =
        (com.google.cloud.bigquery.analyticshub.v1.PubSubSubscription) obj;

    if (!getName().equals(other.getName())) return false;
    if (hasPushConfig() != other.hasPushConfig()) return false;
    if (hasPushConfig()) {
      if (!getPushConfig().equals(other.getPushConfig())) return false;
    }
    if (hasBigqueryConfig() != other.hasBigqueryConfig()) return false;
    if (hasBigqueryConfig()) {
      if (!getBigqueryConfig().equals(other.getBigqueryConfig())) return false;
    }
    if (hasCloudStorageConfig() != other.hasCloudStorageConfig()) return false;
    if (hasCloudStorageConfig()) {
      if (!getCloudStorageConfig().equals(other.getCloudStorageConfig())) return false;
    }
    if (getAckDeadlineSeconds() != other.getAckDeadlineSeconds()) return false;
    if (getRetainAckedMessages() != other.getRetainAckedMessages()) return false;
    if (hasMessageRetentionDuration() != other.hasMessageRetentionDuration()) return false;
    if (hasMessageRetentionDuration()) {
      if (!getMessageRetentionDuration().equals(other.getMessageRetentionDuration())) return false;
    }
    if (!internalGetLabels().equals(other.internalGetLabels())) return false;
    if (getEnableMessageOrdering() != other.getEnableMessageOrdering()) return false;
    if (hasExpirationPolicy() != other.hasExpirationPolicy()) return false;
    if (hasExpirationPolicy()) {
      if (!getExpirationPolicy().equals(other.getExpirationPolicy())) return false;
    }
    if (!getFilter().equals(other.getFilter())) return false;
    if (hasDeadLetterPolicy() != other.hasDeadLetterPolicy()) return false;
    if (hasDeadLetterPolicy()) {
      if (!getDeadLetterPolicy().equals(other.getDeadLetterPolicy())) return false;
    }
    if (hasRetryPolicy() != other.hasRetryPolicy()) return false;
    if (hasRetryPolicy()) {
      if (!getRetryPolicy().equals(other.getRetryPolicy())) return false;
    }
    if (getDetached() != other.getDetached()) return false;
    if (getEnableExactlyOnceDelivery() != other.getEnableExactlyOnceDelivery()) return false;
    if (!getMessageTransformsList().equals(other.getMessageTransformsList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    if (hasPushConfig()) {
      hash = (37 * hash) + PUSH_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getPushConfig().hashCode();
    }
    if (hasBigqueryConfig()) {
      hash = (37 * hash) + BIGQUERY_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getBigqueryConfig().hashCode();
    }
    if (hasCloudStorageConfig()) {
      hash = (37 * hash) + CLOUD_STORAGE_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getCloudStorageConfig().hashCode();
    }
    hash = (37 * hash) + ACK_DEADLINE_SECONDS_FIELD_NUMBER;
    hash = (53 * hash) + getAckDeadlineSeconds();
    hash = (37 * hash) + RETAIN_ACKED_MESSAGES_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getRetainAckedMessages());
    if (hasMessageRetentionDuration()) {
      hash = (37 * hash) + MESSAGE_RETENTION_DURATION_FIELD_NUMBER;
      hash = (53 * hash) + getMessageRetentionDuration().hashCode();
    }
    if (!internalGetLabels().getMap().isEmpty()) {
      hash = (37 * hash) + LABELS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetLabels().hashCode();
    }
    hash = (37 * hash) + ENABLE_MESSAGE_ORDERING_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getEnableMessageOrdering());
    if (hasExpirationPolicy()) {
      hash = (37 * hash) + EXPIRATION_POLICY_FIELD_NUMBER;
      hash = (53 * hash) + getExpirationPolicy().hashCode();
    }
    hash = (37 * hash) + FILTER_FIELD_NUMBER;
    hash = (53 * hash) + getFilter().hashCode();
    if (hasDeadLetterPolicy()) {
      hash = (37 * hash) + DEAD_LETTER_POLICY_FIELD_NUMBER;
      hash = (53 * hash) + getDeadLetterPolicy().hashCode();
    }
    if (hasRetryPolicy()) {
      hash = (37 * hash) + RETRY_POLICY_FIELD_NUMBER;
      hash = (53 * hash) + getRetryPolicy().hashCode();
    }
    hash = (37 * hash) + DETACHED_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getDetached());
    hash = (37 * hash) + ENABLE_EXACTLY_ONCE_DELIVERY_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getEnableExactlyOnceDelivery());
    if (getMessageTransformsCount() > 0) {
      hash = (37 * hash) + MESSAGE_TRANSFORMS_FIELD_NUMBER;
      hash = (53 * hash) + getMessageTransformsList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.bigquery.analyticshub.v1.PubSubSubscription parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.bigquery.analyticshub.v1.PubSubSubscription parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.bigquery.analyticshub.v1.PubSubSubscription parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.bigquery.analyticshub.v1.PubSubSubscription parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.bigquery.analyticshub.v1.PubSubSubscription parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.bigquery.analyticshub.v1.PubSubSubscription parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.bigquery.analyticshub.v1.PubSubSubscription parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.bigquery.analyticshub.v1.PubSubSubscription parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.bigquery.analyticshub.v1.PubSubSubscription parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.bigquery.analyticshub.v1.PubSubSubscription parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.bigquery.analyticshub.v1.PubSubSubscription parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.bigquery.analyticshub.v1.PubSubSubscription parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.bigquery.analyticshub.v1.PubSubSubscription prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * Defines the destination Pub/Sub subscription.
   * If none of `push_config`, `bigquery_config`, `cloud_storage_config`,
   * `pubsub_export_config`, or `pubsublite_export_config`
   * is set, then the subscriber will pull and ack messages using API methods. At
   * most one of these fields may be set.
   * </pre>
   *
   * Protobuf type {@code google.cloud.bigquery.analyticshub.v1.PubSubSubscription}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.bigquery.analyticshub.v1.PubSubSubscription)
      com.google.cloud.bigquery.analyticshub.v1.PubSubSubscriptionOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.bigquery.analyticshub.v1.PubsubProto
          .internal_static_google_cloud_bigquery_analyticshub_v1_PubSubSubscription_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
        int number) {
      switch (number) {
        case 9:
          return internalGetLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMutableMapFieldReflection(
        int number) {
      switch (number) {
        case 9:
          return internalGetMutableLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.bigquery.analyticshub.v1.PubsubProto
          .internal_static_google_cloud_bigquery_analyticshub_v1_PubSubSubscription_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.bigquery.analyticshub.v1.PubSubSubscription.class,
              com.google.cloud.bigquery.analyticshub.v1.PubSubSubscription.Builder.class);
    }

    // Construct using com.google.cloud.bigquery.analyticshub.v1.PubSubSubscription.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getPushConfigFieldBuilder();
        getBigqueryConfigFieldBuilder();
        getCloudStorageConfigFieldBuilder();
        getMessageRetentionDurationFieldBuilder();
        getExpirationPolicyFieldBuilder();
        getDeadLetterPolicyFieldBuilder();
        getRetryPolicyFieldBuilder();
        getMessageTransformsFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      pushConfig_ = null;
      if (pushConfigBuilder_ != null) {
        pushConfigBuilder_.dispose();
        pushConfigBuilder_ = null;
      }
      bigqueryConfig_ = null;
      if (bigqueryConfigBuilder_ != null) {
        bigqueryConfigBuilder_.dispose();
        bigqueryConfigBuilder_ = null;
      }
      cloudStorageConfig_ = null;
      if (cloudStorageConfigBuilder_ != null) {
        cloudStorageConfigBuilder_.dispose();
        cloudStorageConfigBuilder_ = null;
      }
      ackDeadlineSeconds_ = 0;
      retainAckedMessages_ = false;
      messageRetentionDuration_ = null;
      if (messageRetentionDurationBuilder_ != null) {
        messageRetentionDurationBuilder_.dispose();
        messageRetentionDurationBuilder_ = null;
      }
      internalGetMutableLabels().clear();
      enableMessageOrdering_ = false;
      expirationPolicy_ = null;
      if (expirationPolicyBuilder_ != null) {
        expirationPolicyBuilder_.dispose();
        expirationPolicyBuilder_ = null;
      }
      filter_ = "";
      deadLetterPolicy_ = null;
      if (deadLetterPolicyBuilder_ != null) {
        deadLetterPolicyBuilder_.dispose();
        deadLetterPolicyBuilder_ = null;
      }
      retryPolicy_ = null;
      if (retryPolicyBuilder_ != null) {
        retryPolicyBuilder_.dispose();
        retryPolicyBuilder_ = null;
      }
      detached_ = false;
      enableExactlyOnceDelivery_ = false;
      if (messageTransformsBuilder_ == null) {
        messageTransforms_ = java.util.Collections.emptyList();
      } else {
        messageTransforms_ = null;
        messageTransformsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00008000);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.bigquery.analyticshub.v1.PubsubProto
          .internal_static_google_cloud_bigquery_analyticshub_v1_PubSubSubscription_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.bigquery.analyticshub.v1.PubSubSubscription
        getDefaultInstanceForType() {
      return com.google.cloud.bigquery.analyticshub.v1.PubSubSubscription.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.bigquery.analyticshub.v1.PubSubSubscription build() {
      com.google.cloud.bigquery.analyticshub.v1.PubSubSubscription result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.bigquery.analyticshub.v1.PubSubSubscription buildPartial() {
      com.google.cloud.bigquery.analyticshub.v1.PubSubSubscription result =
          new com.google.cloud.bigquery.analyticshub.v1.PubSubSubscription(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.bigquery.analyticshub.v1.PubSubSubscription result) {
      if (messageTransformsBuilder_ == null) {
        if (((bitField0_ & 0x00008000) != 0)) {
          messageTransforms_ = java.util.Collections.unmodifiableList(messageTransforms_);
          bitField0_ = (bitField0_ & ~0x00008000);
        }
        result.messageTransforms_ = messageTransforms_;
      } else {
        result.messageTransforms_ = messageTransformsBuilder_.build();
      }
    }

    private void buildPartial0(
        com.google.cloud.bigquery.analyticshub.v1.PubSubSubscription result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.pushConfig_ = pushConfigBuilder_ == null ? pushConfig_ : pushConfigBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.bigqueryConfig_ =
            bigqueryConfigBuilder_ == null ? bigqueryConfig_ : bigqueryConfigBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.cloudStorageConfig_ =
            cloudStorageConfigBuilder_ == null
                ? cloudStorageConfig_
                : cloudStorageConfigBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.ackDeadlineSeconds_ = ackDeadlineSeconds_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.retainAckedMessages_ = retainAckedMessages_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.messageRetentionDuration_ =
            messageRetentionDurationBuilder_ == null
                ? messageRetentionDuration_
                : messageRetentionDurationBuilder_.build();
        to_bitField0_ |= 0x00000008;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.labels_ = internalGetLabels();
        result.labels_.makeImmutable();
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.enableMessageOrdering_ = enableMessageOrdering_;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.expirationPolicy_ =
            expirationPolicyBuilder_ == null ? expirationPolicy_ : expirationPolicyBuilder_.build();
        to_bitField0_ |= 0x00000010;
      }
      if (((from_bitField0_ & 0x00000400) != 0)) {
        result.filter_ = filter_;
      }
      if (((from_bitField0_ & 0x00000800) != 0)) {
        result.deadLetterPolicy_ =
            deadLetterPolicyBuilder_ == null ? deadLetterPolicy_ : deadLetterPolicyBuilder_.build();
        to_bitField0_ |= 0x00000020;
      }
      if (((from_bitField0_ & 0x00001000) != 0)) {
        result.retryPolicy_ =
            retryPolicyBuilder_ == null ? retryPolicy_ : retryPolicyBuilder_.build();
        to_bitField0_ |= 0x00000040;
      }
      if (((from_bitField0_ & 0x00002000) != 0)) {
        result.detached_ = detached_;
      }
      if (((from_bitField0_ & 0x00004000) != 0)) {
        result.enableExactlyOnceDelivery_ = enableExactlyOnceDelivery_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.bigquery.analyticshub.v1.PubSubSubscription) {
        return mergeFrom((com.google.cloud.bigquery.analyticshub.v1.PubSubSubscription) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.bigquery.analyticshub.v1.PubSubSubscription other) {
      if (other
          == com.google.cloud.bigquery.analyticshub.v1.PubSubSubscription.getDefaultInstance())
        return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.hasPushConfig()) {
        mergePushConfig(other.getPushConfig());
      }
      if (other.hasBigqueryConfig()) {
        mergeBigqueryConfig(other.getBigqueryConfig());
      }
      if (other.hasCloudStorageConfig()) {
        mergeCloudStorageConfig(other.getCloudStorageConfig());
      }
      if (other.getAckDeadlineSeconds() != 0) {
        setAckDeadlineSeconds(other.getAckDeadlineSeconds());
      }
      if (other.getRetainAckedMessages() != false) {
        setRetainAckedMessages(other.getRetainAckedMessages());
      }
      if (other.hasMessageRetentionDuration()) {
        mergeMessageRetentionDuration(other.getMessageRetentionDuration());
      }
      internalGetMutableLabels().mergeFrom(other.internalGetLabels());
      bitField0_ |= 0x00000080;
      if (other.getEnableMessageOrdering() != false) {
        setEnableMessageOrdering(other.getEnableMessageOrdering());
      }
      if (other.hasExpirationPolicy()) {
        mergeExpirationPolicy(other.getExpirationPolicy());
      }
      if (!other.getFilter().isEmpty()) {
        filter_ = other.filter_;
        bitField0_ |= 0x00000400;
        onChanged();
      }
      if (other.hasDeadLetterPolicy()) {
        mergeDeadLetterPolicy(other.getDeadLetterPolicy());
      }
      if (other.hasRetryPolicy()) {
        mergeRetryPolicy(other.getRetryPolicy());
      }
      if (other.getDetached() != false) {
        setDetached(other.getDetached());
      }
      if (other.getEnableExactlyOnceDelivery() != false) {
        setEnableExactlyOnceDelivery(other.getEnableExactlyOnceDelivery());
      }
      if (messageTransformsBuilder_ == null) {
        if (!other.messageTransforms_.isEmpty()) {
          if (messageTransforms_.isEmpty()) {
            messageTransforms_ = other.messageTransforms_;
            bitField0_ = (bitField0_ & ~0x00008000);
          } else {
            ensureMessageTransformsIsMutable();
            messageTransforms_.addAll(other.messageTransforms_);
          }
          onChanged();
        }
      } else {
        if (!other.messageTransforms_.isEmpty()) {
          if (messageTransformsBuilder_.isEmpty()) {
            messageTransformsBuilder_.dispose();
            messageTransformsBuilder_ = null;
            messageTransforms_ = other.messageTransforms_;
            bitField0_ = (bitField0_ & ~0x00008000);
            messageTransformsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getMessageTransformsFieldBuilder()
                    : null;
          } else {
            messageTransformsBuilder_.addAllMessages(other.messageTransforms_);
          }
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 34:
              {
                input.readMessage(getPushConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 34
            case 40:
              {
                ackDeadlineSeconds_ = input.readInt32();
                bitField0_ |= 0x00000010;
                break;
              } // case 40
            case 56:
              {
                retainAckedMessages_ = input.readBool();
                bitField0_ |= 0x00000020;
                break;
              } // case 56
            case 66:
              {
                input.readMessage(
                    getMessageRetentionDurationFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000040;
                break;
              } // case 66
            case 74:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
                    input.readMessage(
                        LabelsDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                internalGetMutableLabels()
                    .getMutableMap()
                    .put(labels__.getKey(), labels__.getValue());
                bitField0_ |= 0x00000080;
                break;
              } // case 74
            case 80:
              {
                enableMessageOrdering_ = input.readBool();
                bitField0_ |= 0x00000100;
                break;
              } // case 80
            case 90:
              {
                input.readMessage(
                    getExpirationPolicyFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000200;
                break;
              } // case 90
            case 98:
              {
                filter_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000400;
                break;
              } // case 98
            case 106:
              {
                input.readMessage(
                    getDeadLetterPolicyFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000800;
                break;
              } // case 106
            case 114:
              {
                input.readMessage(getRetryPolicyFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00001000;
                break;
              } // case 114
            case 120:
              {
                detached_ = input.readBool();
                bitField0_ |= 0x00002000;
                break;
              } // case 120
            case 128:
              {
                enableExactlyOnceDelivery_ = input.readBool();
                bitField0_ |= 0x00004000;
                break;
              } // case 128
            case 146:
              {
                input.readMessage(getBigqueryConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 146
            case 178:
              {
                input.readMessage(
                    getCloudStorageConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 178
            case 202:
              {
                com.google.cloud.bigquery.analyticshub.v1.MessageTransform m =
                    input.readMessage(
                        com.google.cloud.bigquery.analyticshub.v1.MessageTransform.parser(),
                        extensionRegistry);
                if (messageTransformsBuilder_ == null) {
                  ensureMessageTransformsIsMutable();
                  messageTransforms_.add(m);
                } else {
                  messageTransformsBuilder_.addMessage(m);
                }
                break;
              } // case 202
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";

    /**
     *
     *
     * <pre>
     * Required. Name of the subscription.
     * Format is `projects/{project}/subscriptions/{sub}`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. Name of the subscription.
     * Format is `projects/{project}/subscriptions/{sub}`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. Name of the subscription.
     * Format is `projects/{project}/subscriptions/{sub}`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. Name of the subscription.
     * Format is `projects/{project}/subscriptions/{sub}`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. Name of the subscription.
     * Format is `projects/{project}/subscriptions/{sub}`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.cloud.bigquery.analyticshub.v1.PushConfig pushConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.bigquery.analyticshub.v1.PushConfig,
            com.google.cloud.bigquery.analyticshub.v1.PushConfig.Builder,
            com.google.cloud.bigquery.analyticshub.v1.PushConfigOrBuilder>
        pushConfigBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. If push delivery is used with this subscription, this field is
     * used to configure it.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.analyticshub.v1.PushConfig push_config = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the pushConfig field is set.
     */
    public boolean hasPushConfig() {
      return ((bitField0_ & 0x00000002) != 0);
    }

    /**
     *
     *
     * <pre>
     * Optional. If push delivery is used with this subscription, this field is
     * used to configure it.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.analyticshub.v1.PushConfig push_config = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The pushConfig.
     */
    public com.google.cloud.bigquery.analyticshub.v1.PushConfig getPushConfig() {
      if (pushConfigBuilder_ == null) {
        return pushConfig_ == null
            ? com.google.cloud.bigquery.analyticshub.v1.PushConfig.getDefaultInstance()
            : pushConfig_;
      } else {
        return pushConfigBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. If push delivery is used with this subscription, this field is
     * used to configure it.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.analyticshub.v1.PushConfig push_config = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setPushConfig(com.google.cloud.bigquery.analyticshub.v1.PushConfig value) {
      if (pushConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        pushConfig_ = value;
      } else {
        pushConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. If push delivery is used with this subscription, this field is
     * used to configure it.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.analyticshub.v1.PushConfig push_config = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setPushConfig(
        com.google.cloud.bigquery.analyticshub.v1.PushConfig.Builder builderForValue) {
      if (pushConfigBuilder_ == null) {
        pushConfig_ = builderForValue.build();
      } else {
        pushConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. If push delivery is used with this subscription, this field is
     * used to configure it.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.analyticshub.v1.PushConfig push_config = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergePushConfig(com.google.cloud.bigquery.analyticshub.v1.PushConfig value) {
      if (pushConfigBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && pushConfig_ != null
            && pushConfig_
                != com.google.cloud.bigquery.analyticshub.v1.PushConfig.getDefaultInstance()) {
          getPushConfigBuilder().mergeFrom(value);
        } else {
          pushConfig_ = value;
        }
      } else {
        pushConfigBuilder_.mergeFrom(value);
      }
      if (pushConfig_ != null) {
        bitField0_ |= 0x00000002;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. If push delivery is used with this subscription, this field is
     * used to configure it.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.analyticshub.v1.PushConfig push_config = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearPushConfig() {
      bitField0_ = (bitField0_ & ~0x00000002);
      pushConfig_ = null;
      if (pushConfigBuilder_ != null) {
        pushConfigBuilder_.dispose();
        pushConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. If push delivery is used with this subscription, this field is
     * used to configure it.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.analyticshub.v1.PushConfig push_config = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.bigquery.analyticshub.v1.PushConfig.Builder getPushConfigBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getPushConfigFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Optional. If push delivery is used with this subscription, this field is
     * used to configure it.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.analyticshub.v1.PushConfig push_config = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.bigquery.analyticshub.v1.PushConfigOrBuilder getPushConfigOrBuilder() {
      if (pushConfigBuilder_ != null) {
        return pushConfigBuilder_.getMessageOrBuilder();
      } else {
        return pushConfig_ == null
            ? com.google.cloud.bigquery.analyticshub.v1.PushConfig.getDefaultInstance()
            : pushConfig_;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. If push delivery is used with this subscription, this field is
     * used to configure it.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.analyticshub.v1.PushConfig push_config = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.bigquery.analyticshub.v1.PushConfig,
            com.google.cloud.bigquery.analyticshub.v1.PushConfig.Builder,
            com.google.cloud.bigquery.analyticshub.v1.PushConfigOrBuilder>
        getPushConfigFieldBuilder() {
      if (pushConfigBuilder_ == null) {
        pushConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.bigquery.analyticshub.v1.PushConfig,
                com.google.cloud.bigquery.analyticshub.v1.PushConfig.Builder,
                com.google.cloud.bigquery.analyticshub.v1.PushConfigOrBuilder>(
                getPushConfig(), getParentForChildren(), isClean());
        pushConfig_ = null;
      }
      return pushConfigBuilder_;
    }

    private com.google.cloud.bigquery.analyticshub.v1.BigQueryConfig bigqueryConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.bigquery.analyticshub.v1.BigQueryConfig,
            com.google.cloud.bigquery.analyticshub.v1.BigQueryConfig.Builder,
            com.google.cloud.bigquery.analyticshub.v1.BigQueryConfigOrBuilder>
        bigqueryConfigBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. If delivery to BigQuery is used with this subscription, this
     * field is used to configure it.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.analyticshub.v1.BigQueryConfig bigquery_config = 18 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the bigqueryConfig field is set.
     */
    public boolean hasBigqueryConfig() {
      return ((bitField0_ & 0x00000004) != 0);
    }

    /**
     *
     *
     * <pre>
     * Optional. If delivery to BigQuery is used with this subscription, this
     * field is used to configure it.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.analyticshub.v1.BigQueryConfig bigquery_config = 18 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The bigqueryConfig.
     */
    public com.google.cloud.bigquery.analyticshub.v1.BigQueryConfig getBigqueryConfig() {
      if (bigqueryConfigBuilder_ == null) {
        return bigqueryConfig_ == null
            ? com.google.cloud.bigquery.analyticshub.v1.BigQueryConfig.getDefaultInstance()
            : bigqueryConfig_;
      } else {
        return bigqueryConfigBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. If delivery to BigQuery is used with this subscription, this
     * field is used to configure it.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.analyticshub.v1.BigQueryConfig bigquery_config = 18 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setBigqueryConfig(
        com.google.cloud.bigquery.analyticshub.v1.BigQueryConfig value) {
      if (bigqueryConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        bigqueryConfig_ = value;
      } else {
        bigqueryConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. If delivery to BigQuery is used with this subscription, this
     * field is used to configure it.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.analyticshub.v1.BigQueryConfig bigquery_config = 18 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setBigqueryConfig(
        com.google.cloud.bigquery.analyticshub.v1.BigQueryConfig.Builder builderForValue) {
      if (bigqueryConfigBuilder_ == null) {
        bigqueryConfig_ = builderForValue.build();
      } else {
        bigqueryConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. If delivery to BigQuery is used with this subscription, this
     * field is used to configure it.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.analyticshub.v1.BigQueryConfig bigquery_config = 18 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeBigqueryConfig(
        com.google.cloud.bigquery.analyticshub.v1.BigQueryConfig value) {
      if (bigqueryConfigBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && bigqueryConfig_ != null
            && bigqueryConfig_
                != com.google.cloud.bigquery.analyticshub.v1.BigQueryConfig.getDefaultInstance()) {
          getBigqueryConfigBuilder().mergeFrom(value);
        } else {
          bigqueryConfig_ = value;
        }
      } else {
        bigqueryConfigBuilder_.mergeFrom(value);
      }
      if (bigqueryConfig_ != null) {
        bitField0_ |= 0x00000004;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. If delivery to BigQuery is used with this subscription, this
     * field is used to configure it.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.analyticshub.v1.BigQueryConfig bigquery_config = 18 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearBigqueryConfig() {
      bitField0_ = (bitField0_ & ~0x00000004);
      bigqueryConfig_ = null;
      if (bigqueryConfigBuilder_ != null) {
        bigqueryConfigBuilder_.dispose();
        bigqueryConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. If delivery to BigQuery is used with this subscription, this
     * field is used to configure it.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.analyticshub.v1.BigQueryConfig bigquery_config = 18 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.bigquery.analyticshub.v1.BigQueryConfig.Builder
        getBigqueryConfigBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getBigqueryConfigFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Optional. If delivery to BigQuery is used with this subscription, this
     * field is used to configure it.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.analyticshub.v1.BigQueryConfig bigquery_config = 18 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.bigquery.analyticshub.v1.BigQueryConfigOrBuilder
        getBigqueryConfigOrBuilder() {
      if (bigqueryConfigBuilder_ != null) {
        return bigqueryConfigBuilder_.getMessageOrBuilder();
      } else {
        return bigqueryConfig_ == null
            ? com.google.cloud.bigquery.analyticshub.v1.BigQueryConfig.getDefaultInstance()
            : bigqueryConfig_;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. If delivery to BigQuery is used with this subscription, this
     * field is used to configure it.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.analyticshub.v1.BigQueryConfig bigquery_config = 18 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.bigquery.analyticshub.v1.BigQueryConfig,
            com.google.cloud.bigquery.analyticshub.v1.BigQueryConfig.Builder,
            com.google.cloud.bigquery.analyticshub.v1.BigQueryConfigOrBuilder>
        getBigqueryConfigFieldBuilder() {
      if (bigqueryConfigBuilder_ == null) {
        bigqueryConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.bigquery.analyticshub.v1.BigQueryConfig,
                com.google.cloud.bigquery.analyticshub.v1.BigQueryConfig.Builder,
                com.google.cloud.bigquery.analyticshub.v1.BigQueryConfigOrBuilder>(
                getBigqueryConfig(), getParentForChildren(), isClean());
        bigqueryConfig_ = null;
      }
      return bigqueryConfigBuilder_;
    }

    private com.google.cloud.bigquery.analyticshub.v1.CloudStorageConfig cloudStorageConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.bigquery.analyticshub.v1.CloudStorageConfig,
            com.google.cloud.bigquery.analyticshub.v1.CloudStorageConfig.Builder,
            com.google.cloud.bigquery.analyticshub.v1.CloudStorageConfigOrBuilder>
        cloudStorageConfigBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. If delivery to Google Cloud Storage is used with this
     * subscription, this field is used to configure it.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.analyticshub.v1.CloudStorageConfig cloud_storage_config = 22 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the cloudStorageConfig field is set.
     */
    public boolean hasCloudStorageConfig() {
      return ((bitField0_ & 0x00000008) != 0);
    }

    /**
     *
     *
     * <pre>
     * Optional. If delivery to Google Cloud Storage is used with this
     * subscription, this field is used to configure it.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.analyticshub.v1.CloudStorageConfig cloud_storage_config = 22 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The cloudStorageConfig.
     */
    public com.google.cloud.bigquery.analyticshub.v1.CloudStorageConfig getCloudStorageConfig() {
      if (cloudStorageConfigBuilder_ == null) {
        return cloudStorageConfig_ == null
            ? com.google.cloud.bigquery.analyticshub.v1.CloudStorageConfig.getDefaultInstance()
            : cloudStorageConfig_;
      } else {
        return cloudStorageConfigBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. If delivery to Google Cloud Storage is used with this
     * subscription, this field is used to configure it.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.analyticshub.v1.CloudStorageConfig cloud_storage_config = 22 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setCloudStorageConfig(
        com.google.cloud.bigquery.analyticshub.v1.CloudStorageConfig value) {
      if (cloudStorageConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        cloudStorageConfig_ = value;
      } else {
        cloudStorageConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. If delivery to Google Cloud Storage is used with this
     * subscription, this field is used to configure it.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.analyticshub.v1.CloudStorageConfig cloud_storage_config = 22 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setCloudStorageConfig(
        com.google.cloud.bigquery.analyticshub.v1.CloudStorageConfig.Builder builderForValue) {
      if (cloudStorageConfigBuilder_ == null) {
        cloudStorageConfig_ = builderForValue.build();
      } else {
        cloudStorageConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. If delivery to Google Cloud Storage is used with this
     * subscription, this field is used to configure it.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.analyticshub.v1.CloudStorageConfig cloud_storage_config = 22 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeCloudStorageConfig(
        com.google.cloud.bigquery.analyticshub.v1.CloudStorageConfig value) {
      if (cloudStorageConfigBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && cloudStorageConfig_ != null
            && cloudStorageConfig_
                != com.google.cloud.bigquery.analyticshub.v1.CloudStorageConfig
                    .getDefaultInstance()) {
          getCloudStorageConfigBuilder().mergeFrom(value);
        } else {
          cloudStorageConfig_ = value;
        }
      } else {
        cloudStorageConfigBuilder_.mergeFrom(value);
      }
      if (cloudStorageConfig_ != null) {
        bitField0_ |= 0x00000008;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. If delivery to Google Cloud Storage is used with this
     * subscription, this field is used to configure it.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.analyticshub.v1.CloudStorageConfig cloud_storage_config = 22 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearCloudStorageConfig() {
      bitField0_ = (bitField0_ & ~0x00000008);
      cloudStorageConfig_ = null;
      if (cloudStorageConfigBuilder_ != null) {
        cloudStorageConfigBuilder_.dispose();
        cloudStorageConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. If delivery to Google Cloud Storage is used with this
     * subscription, this field is used to configure it.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.analyticshub.v1.CloudStorageConfig cloud_storage_config = 22 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.bigquery.analyticshub.v1.CloudStorageConfig.Builder
        getCloudStorageConfigBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getCloudStorageConfigFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Optional. If delivery to Google Cloud Storage is used with this
     * subscription, this field is used to configure it.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.analyticshub.v1.CloudStorageConfig cloud_storage_config = 22 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.bigquery.analyticshub.v1.CloudStorageConfigOrBuilder
        getCloudStorageConfigOrBuilder() {
      if (cloudStorageConfigBuilder_ != null) {
        return cloudStorageConfigBuilder_.getMessageOrBuilder();
      } else {
        return cloudStorageConfig_ == null
            ? com.google.cloud.bigquery.analyticshub.v1.CloudStorageConfig.getDefaultInstance()
            : cloudStorageConfig_;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. If delivery to Google Cloud Storage is used with this
     * subscription, this field is used to configure it.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.analyticshub.v1.CloudStorageConfig cloud_storage_config = 22 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.bigquery.analyticshub.v1.CloudStorageConfig,
            com.google.cloud.bigquery.analyticshub.v1.CloudStorageConfig.Builder,
            com.google.cloud.bigquery.analyticshub.v1.CloudStorageConfigOrBuilder>
        getCloudStorageConfigFieldBuilder() {
      if (cloudStorageConfigBuilder_ == null) {
        cloudStorageConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.bigquery.analyticshub.v1.CloudStorageConfig,
                com.google.cloud.bigquery.analyticshub.v1.CloudStorageConfig.Builder,
                com.google.cloud.bigquery.analyticshub.v1.CloudStorageConfigOrBuilder>(
                getCloudStorageConfig(), getParentForChildren(), isClean());
        cloudStorageConfig_ = null;
      }
      return cloudStorageConfigBuilder_;
    }

    private int ackDeadlineSeconds_;

    /**
     *
     *
     * <pre>
     * Optional. The approximate amount of time (on a best-effort basis) Pub/Sub
     * waits for the subscriber to acknowledge receipt before resending the
     * message. In the interval after the message is delivered and before it is
     * acknowledged, it is considered to be _outstanding_. During that time
     * period, the message will not be redelivered (on a best-effort basis).
     *
     * For pull subscriptions, this value is used as the initial value for the ack
     * deadline. To override this value for a given message, call
     * `ModifyAckDeadline` with the corresponding `ack_id` if using
     * non-streaming pull or send the `ack_id` in a
     * `StreamingModifyAckDeadlineRequest` if using streaming pull.
     * The minimum custom deadline you can specify is 10 seconds.
     * The maximum custom deadline you can specify is 600 seconds (10 minutes).
     * If this parameter is 0, a default value of 10 seconds is used.
     *
     * For push delivery, this value is also used to set the request timeout for
     * the call to the push endpoint.
     *
     * If the subscriber never acknowledges the message, the Pub/Sub
     * system will eventually redeliver the message.
     * </pre>
     *
     * <code>int32 ack_deadline_seconds = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The ackDeadlineSeconds.
     */
    @java.lang.Override
    public int getAckDeadlineSeconds() {
      return ackDeadlineSeconds_;
    }

    /**
     *
     *
     * <pre>
     * Optional. The approximate amount of time (on a best-effort basis) Pub/Sub
     * waits for the subscriber to acknowledge receipt before resending the
     * message. In the interval after the message is delivered and before it is
     * acknowledged, it is considered to be _outstanding_. During that time
     * period, the message will not be redelivered (on a best-effort basis).
     *
     * For pull subscriptions, this value is used as the initial value for the ack
     * deadline. To override this value for a given message, call
     * `ModifyAckDeadline` with the corresponding `ack_id` if using
     * non-streaming pull or send the `ack_id` in a
     * `StreamingModifyAckDeadlineRequest` if using streaming pull.
     * The minimum custom deadline you can specify is 10 seconds.
     * The maximum custom deadline you can specify is 600 seconds (10 minutes).
     * If this parameter is 0, a default value of 10 seconds is used.
     *
     * For push delivery, this value is also used to set the request timeout for
     * the call to the push endpoint.
     *
     * If the subscriber never acknowledges the message, the Pub/Sub
     * system will eventually redeliver the message.
     * </pre>
     *
     * <code>int32 ack_deadline_seconds = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The ackDeadlineSeconds to set.
     * @return This builder for chaining.
     */
    public Builder setAckDeadlineSeconds(int value) {

      ackDeadlineSeconds_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The approximate amount of time (on a best-effort basis) Pub/Sub
     * waits for the subscriber to acknowledge receipt before resending the
     * message. In the interval after the message is delivered and before it is
     * acknowledged, it is considered to be _outstanding_. During that time
     * period, the message will not be redelivered (on a best-effort basis).
     *
     * For pull subscriptions, this value is used as the initial value for the ack
     * deadline. To override this value for a given message, call
     * `ModifyAckDeadline` with the corresponding `ack_id` if using
     * non-streaming pull or send the `ack_id` in a
     * `StreamingModifyAckDeadlineRequest` if using streaming pull.
     * The minimum custom deadline you can specify is 10 seconds.
     * The maximum custom deadline you can specify is 600 seconds (10 minutes).
     * If this parameter is 0, a default value of 10 seconds is used.
     *
     * For push delivery, this value is also used to set the request timeout for
     * the call to the push endpoint.
     *
     * If the subscriber never acknowledges the message, the Pub/Sub
     * system will eventually redeliver the message.
     * </pre>
     *
     * <code>int32 ack_deadline_seconds = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAckDeadlineSeconds() {
      bitField0_ = (bitField0_ & ~0x00000010);
      ackDeadlineSeconds_ = 0;
      onChanged();
      return this;
    }

    private boolean retainAckedMessages_;

    /**
     *
     *
     * <pre>
     * Optional. Indicates whether to retain acknowledged messages. If true, then
     * messages are not expunged from the subscription's backlog, even if they are
     * acknowledged, until they fall out of the `message_retention_duration`
     * window. This must be true if you would like to [`Seek` to a timestamp]
     * (https://cloud.google.com/pubsub/docs/replay-overview#seek_to_a_time) in
     * the past to replay previously-acknowledged messages.
     * </pre>
     *
     * <code>bool retain_acked_messages = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The retainAckedMessages.
     */
    @java.lang.Override
    public boolean getRetainAckedMessages() {
      return retainAckedMessages_;
    }

    /**
     *
     *
     * <pre>
     * Optional. Indicates whether to retain acknowledged messages. If true, then
     * messages are not expunged from the subscription's backlog, even if they are
     * acknowledged, until they fall out of the `message_retention_duration`
     * window. This must be true if you would like to [`Seek` to a timestamp]
     * (https://cloud.google.com/pubsub/docs/replay-overview#seek_to_a_time) in
     * the past to replay previously-acknowledged messages.
     * </pre>
     *
     * <code>bool retain_acked_messages = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The retainAckedMessages to set.
     * @return This builder for chaining.
     */
    public Builder setRetainAckedMessages(boolean value) {

      retainAckedMessages_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Indicates whether to retain acknowledged messages. If true, then
     * messages are not expunged from the subscription's backlog, even if they are
     * acknowledged, until they fall out of the `message_retention_duration`
     * window. This must be true if you would like to [`Seek` to a timestamp]
     * (https://cloud.google.com/pubsub/docs/replay-overview#seek_to_a_time) in
     * the past to replay previously-acknowledged messages.
     * </pre>
     *
     * <code>bool retain_acked_messages = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRetainAckedMessages() {
      bitField0_ = (bitField0_ & ~0x00000020);
      retainAckedMessages_ = false;
      onChanged();
      return this;
    }

    private com.google.protobuf.Duration messageRetentionDuration_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        messageRetentionDurationBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. How long to retain unacknowledged messages in the subscription's
     * backlog, from the moment a message is published. If `retain_acked_messages`
     * is true, then this also configures the retention of acknowledged messages,
     * and thus configures how far back in time a `Seek` can be done. Defaults to
     * 7 days. Cannot be more than 31 days or less than 10 minutes.
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration message_retention_duration = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the messageRetentionDuration field is set.
     */
    public boolean hasMessageRetentionDuration() {
      return ((bitField0_ & 0x00000040) != 0);
    }

    /**
     *
     *
     * <pre>
     * Optional. How long to retain unacknowledged messages in the subscription's
     * backlog, from the moment a message is published. If `retain_acked_messages`
     * is true, then this also configures the retention of acknowledged messages,
     * and thus configures how far back in time a `Seek` can be done. Defaults to
     * 7 days. Cannot be more than 31 days or less than 10 minutes.
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration message_retention_duration = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The messageRetentionDuration.
     */
    public com.google.protobuf.Duration getMessageRetentionDuration() {
      if (messageRetentionDurationBuilder_ == null) {
        return messageRetentionDuration_ == null
            ? com.google.protobuf.Duration.getDefaultInstance()
            : messageRetentionDuration_;
      } else {
        return messageRetentionDurationBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. How long to retain unacknowledged messages in the subscription's
     * backlog, from the moment a message is published. If `retain_acked_messages`
     * is true, then this also configures the retention of acknowledged messages,
     * and thus configures how far back in time a `Seek` can be done. Defaults to
     * 7 days. Cannot be more than 31 days or less than 10 minutes.
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration message_retention_duration = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setMessageRetentionDuration(com.google.protobuf.Duration value) {
      if (messageRetentionDurationBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        messageRetentionDuration_ = value;
      } else {
        messageRetentionDurationBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. How long to retain unacknowledged messages in the subscription's
     * backlog, from the moment a message is published. If `retain_acked_messages`
     * is true, then this also configures the retention of acknowledged messages,
     * and thus configures how far back in time a `Seek` can be done. Defaults to
     * 7 days. Cannot be more than 31 days or less than 10 minutes.
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration message_retention_duration = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setMessageRetentionDuration(
        com.google.protobuf.Duration.Builder builderForValue) {
      if (messageRetentionDurationBuilder_ == null) {
        messageRetentionDuration_ = builderForValue.build();
      } else {
        messageRetentionDurationBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. How long to retain unacknowledged messages in the subscription's
     * backlog, from the moment a message is published. If `retain_acked_messages`
     * is true, then this also configures the retention of acknowledged messages,
     * and thus configures how far back in time a `Seek` can be done. Defaults to
     * 7 days. Cannot be more than 31 days or less than 10 minutes.
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration message_retention_duration = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeMessageRetentionDuration(com.google.protobuf.Duration value) {
      if (messageRetentionDurationBuilder_ == null) {
        if (((bitField0_ & 0x00000040) != 0)
            && messageRetentionDuration_ != null
            && messageRetentionDuration_ != com.google.protobuf.Duration.getDefaultInstance()) {
          getMessageRetentionDurationBuilder().mergeFrom(value);
        } else {
          messageRetentionDuration_ = value;
        }
      } else {
        messageRetentionDurationBuilder_.mergeFrom(value);
      }
      if (messageRetentionDuration_ != null) {
        bitField0_ |= 0x00000040;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. How long to retain unacknowledged messages in the subscription's
     * backlog, from the moment a message is published. If `retain_acked_messages`
     * is true, then this also configures the retention of acknowledged messages,
     * and thus configures how far back in time a `Seek` can be done. Defaults to
     * 7 days. Cannot be more than 31 days or less than 10 minutes.
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration message_retention_duration = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearMessageRetentionDuration() {
      bitField0_ = (bitField0_ & ~0x00000040);
      messageRetentionDuration_ = null;
      if (messageRetentionDurationBuilder_ != null) {
        messageRetentionDurationBuilder_.dispose();
        messageRetentionDurationBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. How long to retain unacknowledged messages in the subscription's
     * backlog, from the moment a message is published. If `retain_acked_messages`
     * is true, then this also configures the retention of acknowledged messages,
     * and thus configures how far back in time a `Seek` can be done. Defaults to
     * 7 days. Cannot be more than 31 days or less than 10 minutes.
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration message_retention_duration = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.protobuf.Duration.Builder getMessageRetentionDurationBuilder() {
      bitField0_ |= 0x00000040;
      onChanged();
      return getMessageRetentionDurationFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Optional. How long to retain unacknowledged messages in the subscription's
     * backlog, from the moment a message is published. If `retain_acked_messages`
     * is true, then this also configures the retention of acknowledged messages,
     * and thus configures how far back in time a `Seek` can be done. Defaults to
     * 7 days. Cannot be more than 31 days or less than 10 minutes.
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration message_retention_duration = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.protobuf.DurationOrBuilder getMessageRetentionDurationOrBuilder() {
      if (messageRetentionDurationBuilder_ != null) {
        return messageRetentionDurationBuilder_.getMessageOrBuilder();
      } else {
        return messageRetentionDuration_ == null
            ? com.google.protobuf.Duration.getDefaultInstance()
            : messageRetentionDuration_;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. How long to retain unacknowledged messages in the subscription's
     * backlog, from the moment a message is published. If `retain_acked_messages`
     * is true, then this also configures the retention of acknowledged messages,
     * and thus configures how far back in time a `Seek` can be done. Defaults to
     * 7 days. Cannot be more than 31 days or less than 10 minutes.
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration message_retention_duration = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        getMessageRetentionDurationFieldBuilder() {
      if (messageRetentionDurationBuilder_ == null) {
        messageRetentionDurationBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Duration,
                com.google.protobuf.Duration.Builder,
                com.google.protobuf.DurationOrBuilder>(
                getMessageRetentionDuration(), getParentForChildren(), isClean());
        messageRetentionDuration_ = null;
      }
      return messageRetentionDurationBuilder_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
      if (labels_ == null) {
        return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      return labels_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableLabels() {
      if (labels_ == null) {
        labels_ = com.google.protobuf.MapField.newMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      if (!labels_.isMutable()) {
        labels_ = labels_.copy();
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return labels_;
    }

    public int getLabelsCount() {
      return internalGetLabels().getMap().size();
    }

    /**
     *
     *
     * <pre>
     * Optional. See [Creating and managing
     * labels](https://cloud.google.com/pubsub/docs/labels).
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    @java.lang.Override
    public boolean containsLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetLabels().getMap().containsKey(key);
    }

    /** Use {@link #getLabelsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getLabels() {
      return getLabelsMap();
    }

    /**
     *
     *
     * <pre>
     * Optional. See [Creating and managing
     * labels](https://cloud.google.com/pubsub/docs/labels).
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
      return internalGetLabels().getMap();
    }

    /**
     *
     *
     * <pre>
     * Optional. See [Creating and managing
     * labels](https://cloud.google.com/pubsub/docs/labels).
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    @java.lang.Override
    public /* nullable */ java.lang.String getLabelsOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }

    /**
     *
     *
     * <pre>
     * Optional. See [Creating and managing
     * labels](https://cloud.google.com/pubsub/docs/labels).
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    @java.lang.Override
    public java.lang.String getLabelsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearLabels() {
      bitField0_ = (bitField0_ & ~0x00000080);
      internalGetMutableLabels().getMutableMap().clear();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. See [Creating and managing
     * labels](https://cloud.google.com/pubsub/docs/labels).
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    public Builder removeLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableLabels().getMutableMap().remove(key);
      return this;
    }

    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableLabels() {
      bitField0_ |= 0x00000080;
      return internalGetMutableLabels().getMutableMap();
    }

    /**
     *
     *
     * <pre>
     * Optional. See [Creating and managing
     * labels](https://cloud.google.com/pubsub/docs/labels).
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    public Builder putLabels(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableLabels().getMutableMap().put(key, value);
      bitField0_ |= 0x00000080;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. See [Creating and managing
     * labels](https://cloud.google.com/pubsub/docs/labels).
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    public Builder putAllLabels(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableLabels().getMutableMap().putAll(values);
      bitField0_ |= 0x00000080;
      return this;
    }

    private boolean enableMessageOrdering_;

    /**
     *
     *
     * <pre>
     * Optional. If true, messages published with the same `ordering_key` in
     * `PubsubMessage` will be delivered to the subscribers in the order in which
     * they are received by the Pub/Sub system. Otherwise, they may be delivered
     * in any order.
     * </pre>
     *
     * <code>bool enable_message_ordering = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The enableMessageOrdering.
     */
    @java.lang.Override
    public boolean getEnableMessageOrdering() {
      return enableMessageOrdering_;
    }

    /**
     *
     *
     * <pre>
     * Optional. If true, messages published with the same `ordering_key` in
     * `PubsubMessage` will be delivered to the subscribers in the order in which
     * they are received by the Pub/Sub system. Otherwise, they may be delivered
     * in any order.
     * </pre>
     *
     * <code>bool enable_message_ordering = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The enableMessageOrdering to set.
     * @return This builder for chaining.
     */
    public Builder setEnableMessageOrdering(boolean value) {

      enableMessageOrdering_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. If true, messages published with the same `ordering_key` in
     * `PubsubMessage` will be delivered to the subscribers in the order in which
     * they are received by the Pub/Sub system. Otherwise, they may be delivered
     * in any order.
     * </pre>
     *
     * <code>bool enable_message_ordering = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEnableMessageOrdering() {
      bitField0_ = (bitField0_ & ~0x00000100);
      enableMessageOrdering_ = false;
      onChanged();
      return this;
    }

    private com.google.cloud.bigquery.analyticshub.v1.ExpirationPolicy expirationPolicy_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.bigquery.analyticshub.v1.ExpirationPolicy,
            com.google.cloud.bigquery.analyticshub.v1.ExpirationPolicy.Builder,
            com.google.cloud.bigquery.analyticshub.v1.ExpirationPolicyOrBuilder>
        expirationPolicyBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. A policy that specifies the conditions for this subscription's
     * expiration. A subscription is considered active as long as any connected
     * subscriber is successfully consuming messages from the subscription or is
     * issuing operations on the subscription. If `expiration_policy` is not set,
     * a *default policy* with `ttl` of 31 days will be used. The minimum allowed
     * value for `expiration_policy.ttl` is 1 day. If `expiration_policy` is set,
     * but `expiration_policy.ttl` is not set, the subscription never expires.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.analyticshub.v1.ExpirationPolicy expiration_policy = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the expirationPolicy field is set.
     */
    public boolean hasExpirationPolicy() {
      return ((bitField0_ & 0x00000200) != 0);
    }

    /**
     *
     *
     * <pre>
     * Optional. A policy that specifies the conditions for this subscription's
     * expiration. A subscription is considered active as long as any connected
     * subscriber is successfully consuming messages from the subscription or is
     * issuing operations on the subscription. If `expiration_policy` is not set,
     * a *default policy* with `ttl` of 31 days will be used. The minimum allowed
     * value for `expiration_policy.ttl` is 1 day. If `expiration_policy` is set,
     * but `expiration_policy.ttl` is not set, the subscription never expires.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.analyticshub.v1.ExpirationPolicy expiration_policy = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The expirationPolicy.
     */
    public com.google.cloud.bigquery.analyticshub.v1.ExpirationPolicy getExpirationPolicy() {
      if (expirationPolicyBuilder_ == null) {
        return expirationPolicy_ == null
            ? com.google.cloud.bigquery.analyticshub.v1.ExpirationPolicy.getDefaultInstance()
            : expirationPolicy_;
      } else {
        return expirationPolicyBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. A policy that specifies the conditions for this subscription's
     * expiration. A subscription is considered active as long as any connected
     * subscriber is successfully consuming messages from the subscription or is
     * issuing operations on the subscription. If `expiration_policy` is not set,
     * a *default policy* with `ttl` of 31 days will be used. The minimum allowed
     * value for `expiration_policy.ttl` is 1 day. If `expiration_policy` is set,
     * but `expiration_policy.ttl` is not set, the subscription never expires.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.analyticshub.v1.ExpirationPolicy expiration_policy = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setExpirationPolicy(
        com.google.cloud.bigquery.analyticshub.v1.ExpirationPolicy value) {
      if (expirationPolicyBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        expirationPolicy_ = value;
      } else {
        expirationPolicyBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. A policy that specifies the conditions for this subscription's
     * expiration. A subscription is considered active as long as any connected
     * subscriber is successfully consuming messages from the subscription or is
     * issuing operations on the subscription. If `expiration_policy` is not set,
     * a *default policy* with `ttl` of 31 days will be used. The minimum allowed
     * value for `expiration_policy.ttl` is 1 day. If `expiration_policy` is set,
     * but `expiration_policy.ttl` is not set, the subscription never expires.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.analyticshub.v1.ExpirationPolicy expiration_policy = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setExpirationPolicy(
        com.google.cloud.bigquery.analyticshub.v1.ExpirationPolicy.Builder builderForValue) {
      if (expirationPolicyBuilder_ == null) {
        expirationPolicy_ = builderForValue.build();
      } else {
        expirationPolicyBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. A policy that specifies the conditions for this subscription's
     * expiration. A subscription is considered active as long as any connected
     * subscriber is successfully consuming messages from the subscription or is
     * issuing operations on the subscription. If `expiration_policy` is not set,
     * a *default policy* with `ttl` of 31 days will be used. The minimum allowed
     * value for `expiration_policy.ttl` is 1 day. If `expiration_policy` is set,
     * but `expiration_policy.ttl` is not set, the subscription never expires.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.analyticshub.v1.ExpirationPolicy expiration_policy = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeExpirationPolicy(
        com.google.cloud.bigquery.analyticshub.v1.ExpirationPolicy value) {
      if (expirationPolicyBuilder_ == null) {
        if (((bitField0_ & 0x00000200) != 0)
            && expirationPolicy_ != null
            && expirationPolicy_
                != com.google.cloud.bigquery.analyticshub.v1.ExpirationPolicy
                    .getDefaultInstance()) {
          getExpirationPolicyBuilder().mergeFrom(value);
        } else {
          expirationPolicy_ = value;
        }
      } else {
        expirationPolicyBuilder_.mergeFrom(value);
      }
      if (expirationPolicy_ != null) {
        bitField0_ |= 0x00000200;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. A policy that specifies the conditions for this subscription's
     * expiration. A subscription is considered active as long as any connected
     * subscriber is successfully consuming messages from the subscription or is
     * issuing operations on the subscription. If `expiration_policy` is not set,
     * a *default policy* with `ttl` of 31 days will be used. The minimum allowed
     * value for `expiration_policy.ttl` is 1 day. If `expiration_policy` is set,
     * but `expiration_policy.ttl` is not set, the subscription never expires.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.analyticshub.v1.ExpirationPolicy expiration_policy = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearExpirationPolicy() {
      bitField0_ = (bitField0_ & ~0x00000200);
      expirationPolicy_ = null;
      if (expirationPolicyBuilder_ != null) {
        expirationPolicyBuilder_.dispose();
        expirationPolicyBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. A policy that specifies the conditions for this subscription's
     * expiration. A subscription is considered active as long as any connected
     * subscriber is successfully consuming messages from the subscription or is
     * issuing operations on the subscription. If `expiration_policy` is not set,
     * a *default policy* with `ttl` of 31 days will be used. The minimum allowed
     * value for `expiration_policy.ttl` is 1 day. If `expiration_policy` is set,
     * but `expiration_policy.ttl` is not set, the subscription never expires.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.analyticshub.v1.ExpirationPolicy expiration_policy = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.bigquery.analyticshub.v1.ExpirationPolicy.Builder
        getExpirationPolicyBuilder() {
      bitField0_ |= 0x00000200;
      onChanged();
      return getExpirationPolicyFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Optional. A policy that specifies the conditions for this subscription's
     * expiration. A subscription is considered active as long as any connected
     * subscriber is successfully consuming messages from the subscription or is
     * issuing operations on the subscription. If `expiration_policy` is not set,
     * a *default policy* with `ttl` of 31 days will be used. The minimum allowed
     * value for `expiration_policy.ttl` is 1 day. If `expiration_policy` is set,
     * but `expiration_policy.ttl` is not set, the subscription never expires.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.analyticshub.v1.ExpirationPolicy expiration_policy = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.bigquery.analyticshub.v1.ExpirationPolicyOrBuilder
        getExpirationPolicyOrBuilder() {
      if (expirationPolicyBuilder_ != null) {
        return expirationPolicyBuilder_.getMessageOrBuilder();
      } else {
        return expirationPolicy_ == null
            ? com.google.cloud.bigquery.analyticshub.v1.ExpirationPolicy.getDefaultInstance()
            : expirationPolicy_;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. A policy that specifies the conditions for this subscription's
     * expiration. A subscription is considered active as long as any connected
     * subscriber is successfully consuming messages from the subscription or is
     * issuing operations on the subscription. If `expiration_policy` is not set,
     * a *default policy* with `ttl` of 31 days will be used. The minimum allowed
     * value for `expiration_policy.ttl` is 1 day. If `expiration_policy` is set,
     * but `expiration_policy.ttl` is not set, the subscription never expires.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.analyticshub.v1.ExpirationPolicy expiration_policy = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.bigquery.analyticshub.v1.ExpirationPolicy,
            com.google.cloud.bigquery.analyticshub.v1.ExpirationPolicy.Builder,
            com.google.cloud.bigquery.analyticshub.v1.ExpirationPolicyOrBuilder>
        getExpirationPolicyFieldBuilder() {
      if (expirationPolicyBuilder_ == null) {
        expirationPolicyBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.bigquery.analyticshub.v1.ExpirationPolicy,
                com.google.cloud.bigquery.analyticshub.v1.ExpirationPolicy.Builder,
                com.google.cloud.bigquery.analyticshub.v1.ExpirationPolicyOrBuilder>(
                getExpirationPolicy(), getParentForChildren(), isClean());
        expirationPolicy_ = null;
      }
      return expirationPolicyBuilder_;
    }

    private java.lang.Object filter_ = "";

    /**
     *
     *
     * <pre>
     * Optional. An expression written in the Pub/Sub [filter
     * language](https://cloud.google.com/pubsub/docs/filtering). If non-empty,
     * then only `PubsubMessage`s whose `attributes` field matches the filter are
     * delivered on this subscription. If empty, then no messages are filtered
     * out.
     * </pre>
     *
     * <code>string filter = 12 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The filter.
     */
    public java.lang.String getFilter() {
      java.lang.Object ref = filter_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        filter_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. An expression written in the Pub/Sub [filter
     * language](https://cloud.google.com/pubsub/docs/filtering). If non-empty,
     * then only `PubsubMessage`s whose `attributes` field matches the filter are
     * delivered on this subscription. If empty, then no messages are filtered
     * out.
     * </pre>
     *
     * <code>string filter = 12 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for filter.
     */
    public com.google.protobuf.ByteString getFilterBytes() {
      java.lang.Object ref = filter_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        filter_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. An expression written in the Pub/Sub [filter
     * language](https://cloud.google.com/pubsub/docs/filtering). If non-empty,
     * then only `PubsubMessage`s whose `attributes` field matches the filter are
     * delivered on this subscription. If empty, then no messages are filtered
     * out.
     * </pre>
     *
     * <code>string filter = 12 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The filter to set.
     * @return This builder for chaining.
     */
    public Builder setFilter(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      filter_ = value;
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. An expression written in the Pub/Sub [filter
     * language](https://cloud.google.com/pubsub/docs/filtering). If non-empty,
     * then only `PubsubMessage`s whose `attributes` field matches the filter are
     * delivered on this subscription. If empty, then no messages are filtered
     * out.
     * </pre>
     *
     * <code>string filter = 12 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearFilter() {
      filter_ = getDefaultInstance().getFilter();
      bitField0_ = (bitField0_ & ~0x00000400);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. An expression written in the Pub/Sub [filter
     * language](https://cloud.google.com/pubsub/docs/filtering). If non-empty,
     * then only `PubsubMessage`s whose `attributes` field matches the filter are
     * delivered on this subscription. If empty, then no messages are filtered
     * out.
     * </pre>
     *
     * <code>string filter = 12 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for filter to set.
     * @return This builder for chaining.
     */
    public Builder setFilterBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      filter_ = value;
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }

    private com.google.cloud.bigquery.analyticshub.v1.DeadLetterPolicy deadLetterPolicy_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.bigquery.analyticshub.v1.DeadLetterPolicy,
            com.google.cloud.bigquery.analyticshub.v1.DeadLetterPolicy.Builder,
            com.google.cloud.bigquery.analyticshub.v1.DeadLetterPolicyOrBuilder>
        deadLetterPolicyBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. A policy that specifies the conditions for dead lettering
     * messages in this subscription. If dead_letter_policy is not set, dead
     * lettering is disabled.
     *
     * The Pub/Sub service account associated with this subscriptions's
     * parent project (i.e.,
     * service-{project_number}&#64;gcp-sa-pubsub.iam.gserviceaccount.com) must have
     * permission to Acknowledge() messages on this subscription.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.analyticshub.v1.DeadLetterPolicy dead_letter_policy = 13 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the deadLetterPolicy field is set.
     */
    public boolean hasDeadLetterPolicy() {
      return ((bitField0_ & 0x00000800) != 0);
    }

    /**
     *
     *
     * <pre>
     * Optional. A policy that specifies the conditions for dead lettering
     * messages in this subscription. If dead_letter_policy is not set, dead
     * lettering is disabled.
     *
     * The Pub/Sub service account associated with this subscriptions's
     * parent project (i.e.,
     * service-{project_number}&#64;gcp-sa-pubsub.iam.gserviceaccount.com) must have
     * permission to Acknowledge() messages on this subscription.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.analyticshub.v1.DeadLetterPolicy dead_letter_policy = 13 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The deadLetterPolicy.
     */
    public com.google.cloud.bigquery.analyticshub.v1.DeadLetterPolicy getDeadLetterPolicy() {
      if (deadLetterPolicyBuilder_ == null) {
        return deadLetterPolicy_ == null
            ? com.google.cloud.bigquery.analyticshub.v1.DeadLetterPolicy.getDefaultInstance()
            : deadLetterPolicy_;
      } else {
        return deadLetterPolicyBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. A policy that specifies the conditions for dead lettering
     * messages in this subscription. If dead_letter_policy is not set, dead
     * lettering is disabled.
     *
     * The Pub/Sub service account associated with this subscriptions's
     * parent project (i.e.,
     * service-{project_number}&#64;gcp-sa-pubsub.iam.gserviceaccount.com) must have
     * permission to Acknowledge() messages on this subscription.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.analyticshub.v1.DeadLetterPolicy dead_letter_policy = 13 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setDeadLetterPolicy(
        com.google.cloud.bigquery.analyticshub.v1.DeadLetterPolicy value) {
      if (deadLetterPolicyBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        deadLetterPolicy_ = value;
      } else {
        deadLetterPolicyBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. A policy that specifies the conditions for dead lettering
     * messages in this subscription. If dead_letter_policy is not set, dead
     * lettering is disabled.
     *
     * The Pub/Sub service account associated with this subscriptions's
     * parent project (i.e.,
     * service-{project_number}&#64;gcp-sa-pubsub.iam.gserviceaccount.com) must have
     * permission to Acknowledge() messages on this subscription.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.analyticshub.v1.DeadLetterPolicy dead_letter_policy = 13 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setDeadLetterPolicy(
        com.google.cloud.bigquery.analyticshub.v1.DeadLetterPolicy.Builder builderForValue) {
      if (deadLetterPolicyBuilder_ == null) {
        deadLetterPolicy_ = builderForValue.build();
      } else {
        deadLetterPolicyBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. A policy that specifies the conditions for dead lettering
     * messages in this subscription. If dead_letter_policy is not set, dead
     * lettering is disabled.
     *
     * The Pub/Sub service account associated with this subscriptions's
     * parent project (i.e.,
     * service-{project_number}&#64;gcp-sa-pubsub.iam.gserviceaccount.com) must have
     * permission to Acknowledge() messages on this subscription.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.analyticshub.v1.DeadLetterPolicy dead_letter_policy = 13 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeDeadLetterPolicy(
        com.google.cloud.bigquery.analyticshub.v1.DeadLetterPolicy value) {
      if (deadLetterPolicyBuilder_ == null) {
        if (((bitField0_ & 0x00000800) != 0)
            && deadLetterPolicy_ != null
            && deadLetterPolicy_
                != com.google.cloud.bigquery.analyticshub.v1.DeadLetterPolicy
                    .getDefaultInstance()) {
          getDeadLetterPolicyBuilder().mergeFrom(value);
        } else {
          deadLetterPolicy_ = value;
        }
      } else {
        deadLetterPolicyBuilder_.mergeFrom(value);
      }
      if (deadLetterPolicy_ != null) {
        bitField0_ |= 0x00000800;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. A policy that specifies the conditions for dead lettering
     * messages in this subscription. If dead_letter_policy is not set, dead
     * lettering is disabled.
     *
     * The Pub/Sub service account associated with this subscriptions's
     * parent project (i.e.,
     * service-{project_number}&#64;gcp-sa-pubsub.iam.gserviceaccount.com) must have
     * permission to Acknowledge() messages on this subscription.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.analyticshub.v1.DeadLetterPolicy dead_letter_policy = 13 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearDeadLetterPolicy() {
      bitField0_ = (bitField0_ & ~0x00000800);
      deadLetterPolicy_ = null;
      if (deadLetterPolicyBuilder_ != null) {
        deadLetterPolicyBuilder_.dispose();
        deadLetterPolicyBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. A policy that specifies the conditions for dead lettering
     * messages in this subscription. If dead_letter_policy is not set, dead
     * lettering is disabled.
     *
     * The Pub/Sub service account associated with this subscriptions's
     * parent project (i.e.,
     * service-{project_number}&#64;gcp-sa-pubsub.iam.gserviceaccount.com) must have
     * permission to Acknowledge() messages on this subscription.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.analyticshub.v1.DeadLetterPolicy dead_letter_policy = 13 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.bigquery.analyticshub.v1.DeadLetterPolicy.Builder
        getDeadLetterPolicyBuilder() {
      bitField0_ |= 0x00000800;
      onChanged();
      return getDeadLetterPolicyFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Optional. A policy that specifies the conditions for dead lettering
     * messages in this subscription. If dead_letter_policy is not set, dead
     * lettering is disabled.
     *
     * The Pub/Sub service account associated with this subscriptions's
     * parent project (i.e.,
     * service-{project_number}&#64;gcp-sa-pubsub.iam.gserviceaccount.com) must have
     * permission to Acknowledge() messages on this subscription.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.analyticshub.v1.DeadLetterPolicy dead_letter_policy = 13 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.bigquery.analyticshub.v1.DeadLetterPolicyOrBuilder
        getDeadLetterPolicyOrBuilder() {
      if (deadLetterPolicyBuilder_ != null) {
        return deadLetterPolicyBuilder_.getMessageOrBuilder();
      } else {
        return deadLetterPolicy_ == null
            ? com.google.cloud.bigquery.analyticshub.v1.DeadLetterPolicy.getDefaultInstance()
            : deadLetterPolicy_;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. A policy that specifies the conditions for dead lettering
     * messages in this subscription. If dead_letter_policy is not set, dead
     * lettering is disabled.
     *
     * The Pub/Sub service account associated with this subscriptions's
     * parent project (i.e.,
     * service-{project_number}&#64;gcp-sa-pubsub.iam.gserviceaccount.com) must have
     * permission to Acknowledge() messages on this subscription.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.analyticshub.v1.DeadLetterPolicy dead_letter_policy = 13 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.bigquery.analyticshub.v1.DeadLetterPolicy,
            com.google.cloud.bigquery.analyticshub.v1.DeadLetterPolicy.Builder,
            com.google.cloud.bigquery.analyticshub.v1.DeadLetterPolicyOrBuilder>
        getDeadLetterPolicyFieldBuilder() {
      if (deadLetterPolicyBuilder_ == null) {
        deadLetterPolicyBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.bigquery.analyticshub.v1.DeadLetterPolicy,
                com.google.cloud.bigquery.analyticshub.v1.DeadLetterPolicy.Builder,
                com.google.cloud.bigquery.analyticshub.v1.DeadLetterPolicyOrBuilder>(
                getDeadLetterPolicy(), getParentForChildren(), isClean());
        deadLetterPolicy_ = null;
      }
      return deadLetterPolicyBuilder_;
    }

    private com.google.cloud.bigquery.analyticshub.v1.RetryPolicy retryPolicy_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.bigquery.analyticshub.v1.RetryPolicy,
            com.google.cloud.bigquery.analyticshub.v1.RetryPolicy.Builder,
            com.google.cloud.bigquery.analyticshub.v1.RetryPolicyOrBuilder>
        retryPolicyBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. A policy that specifies how Pub/Sub retries message delivery for
     * this subscription.
     *
     * If not set, the default retry policy is applied. This generally implies
     * that messages will be retried as soon as possible for healthy subscribers.
     * RetryPolicy will be triggered on NACKs or acknowledgement deadline
     * exceeded events for a given message.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.analyticshub.v1.RetryPolicy retry_policy = 14 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the retryPolicy field is set.
     */
    public boolean hasRetryPolicy() {
      return ((bitField0_ & 0x00001000) != 0);
    }

    /**
     *
     *
     * <pre>
     * Optional. A policy that specifies how Pub/Sub retries message delivery for
     * this subscription.
     *
     * If not set, the default retry policy is applied. This generally implies
     * that messages will be retried as soon as possible for healthy subscribers.
     * RetryPolicy will be triggered on NACKs or acknowledgement deadline
     * exceeded events for a given message.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.analyticshub.v1.RetryPolicy retry_policy = 14 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The retryPolicy.
     */
    public com.google.cloud.bigquery.analyticshub.v1.RetryPolicy getRetryPolicy() {
      if (retryPolicyBuilder_ == null) {
        return retryPolicy_ == null
            ? com.google.cloud.bigquery.analyticshub.v1.RetryPolicy.getDefaultInstance()
            : retryPolicy_;
      } else {
        return retryPolicyBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. A policy that specifies how Pub/Sub retries message delivery for
     * this subscription.
     *
     * If not set, the default retry policy is applied. This generally implies
     * that messages will be retried as soon as possible for healthy subscribers.
     * RetryPolicy will be triggered on NACKs or acknowledgement deadline
     * exceeded events for a given message.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.analyticshub.v1.RetryPolicy retry_policy = 14 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setRetryPolicy(com.google.cloud.bigquery.analyticshub.v1.RetryPolicy value) {
      if (retryPolicyBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        retryPolicy_ = value;
      } else {
        retryPolicyBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. A policy that specifies how Pub/Sub retries message delivery for
     * this subscription.
     *
     * If not set, the default retry policy is applied. This generally implies
     * that messages will be retried as soon as possible for healthy subscribers.
     * RetryPolicy will be triggered on NACKs or acknowledgement deadline
     * exceeded events for a given message.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.analyticshub.v1.RetryPolicy retry_policy = 14 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setRetryPolicy(
        com.google.cloud.bigquery.analyticshub.v1.RetryPolicy.Builder builderForValue) {
      if (retryPolicyBuilder_ == null) {
        retryPolicy_ = builderForValue.build();
      } else {
        retryPolicyBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. A policy that specifies how Pub/Sub retries message delivery for
     * this subscription.
     *
     * If not set, the default retry policy is applied. This generally implies
     * that messages will be retried as soon as possible for healthy subscribers.
     * RetryPolicy will be triggered on NACKs or acknowledgement deadline
     * exceeded events for a given message.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.analyticshub.v1.RetryPolicy retry_policy = 14 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeRetryPolicy(com.google.cloud.bigquery.analyticshub.v1.RetryPolicy value) {
      if (retryPolicyBuilder_ == null) {
        if (((bitField0_ & 0x00001000) != 0)
            && retryPolicy_ != null
            && retryPolicy_
                != com.google.cloud.bigquery.analyticshub.v1.RetryPolicy.getDefaultInstance()) {
          getRetryPolicyBuilder().mergeFrom(value);
        } else {
          retryPolicy_ = value;
        }
      } else {
        retryPolicyBuilder_.mergeFrom(value);
      }
      if (retryPolicy_ != null) {
        bitField0_ |= 0x00001000;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. A policy that specifies how Pub/Sub retries message delivery for
     * this subscription.
     *
     * If not set, the default retry policy is applied. This generally implies
     * that messages will be retried as soon as possible for healthy subscribers.
     * RetryPolicy will be triggered on NACKs or acknowledgement deadline
     * exceeded events for a given message.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.analyticshub.v1.RetryPolicy retry_policy = 14 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearRetryPolicy() {
      bitField0_ = (bitField0_ & ~0x00001000);
      retryPolicy_ = null;
      if (retryPolicyBuilder_ != null) {
        retryPolicyBuilder_.dispose();
        retryPolicyBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. A policy that specifies how Pub/Sub retries message delivery for
     * this subscription.
     *
     * If not set, the default retry policy is applied. This generally implies
     * that messages will be retried as soon as possible for healthy subscribers.
     * RetryPolicy will be triggered on NACKs or acknowledgement deadline
     * exceeded events for a given message.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.analyticshub.v1.RetryPolicy retry_policy = 14 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.bigquery.analyticshub.v1.RetryPolicy.Builder getRetryPolicyBuilder() {
      bitField0_ |= 0x00001000;
      onChanged();
      return getRetryPolicyFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Optional. A policy that specifies how Pub/Sub retries message delivery for
     * this subscription.
     *
     * If not set, the default retry policy is applied. This generally implies
     * that messages will be retried as soon as possible for healthy subscribers.
     * RetryPolicy will be triggered on NACKs or acknowledgement deadline
     * exceeded events for a given message.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.analyticshub.v1.RetryPolicy retry_policy = 14 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.bigquery.analyticshub.v1.RetryPolicyOrBuilder
        getRetryPolicyOrBuilder() {
      if (retryPolicyBuilder_ != null) {
        return retryPolicyBuilder_.getMessageOrBuilder();
      } else {
        return retryPolicy_ == null
            ? com.google.cloud.bigquery.analyticshub.v1.RetryPolicy.getDefaultInstance()
            : retryPolicy_;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. A policy that specifies how Pub/Sub retries message delivery for
     * this subscription.
     *
     * If not set, the default retry policy is applied. This generally implies
     * that messages will be retried as soon as possible for healthy subscribers.
     * RetryPolicy will be triggered on NACKs or acknowledgement deadline
     * exceeded events for a given message.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.analyticshub.v1.RetryPolicy retry_policy = 14 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.bigquery.analyticshub.v1.RetryPolicy,
            com.google.cloud.bigquery.analyticshub.v1.RetryPolicy.Builder,
            com.google.cloud.bigquery.analyticshub.v1.RetryPolicyOrBuilder>
        getRetryPolicyFieldBuilder() {
      if (retryPolicyBuilder_ == null) {
        retryPolicyBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.bigquery.analyticshub.v1.RetryPolicy,
                com.google.cloud.bigquery.analyticshub.v1.RetryPolicy.Builder,
                com.google.cloud.bigquery.analyticshub.v1.RetryPolicyOrBuilder>(
                getRetryPolicy(), getParentForChildren(), isClean());
        retryPolicy_ = null;
      }
      return retryPolicyBuilder_;
    }

    private boolean detached_;

    /**
     *
     *
     * <pre>
     * Optional. Indicates whether the subscription is detached from its topic.
     * Detached subscriptions don't receive messages from their topic and don't
     * retain any backlog. `Pull` and `StreamingPull` requests will return
     * FAILED_PRECONDITION. If the subscription is a push subscription, pushes to
     * the endpoint will not be made.
     * </pre>
     *
     * <code>bool detached = 15 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The detached.
     */
    @java.lang.Override
    public boolean getDetached() {
      return detached_;
    }

    /**
     *
     *
     * <pre>
     * Optional. Indicates whether the subscription is detached from its topic.
     * Detached subscriptions don't receive messages from their topic and don't
     * retain any backlog. `Pull` and `StreamingPull` requests will return
     * FAILED_PRECONDITION. If the subscription is a push subscription, pushes to
     * the endpoint will not be made.
     * </pre>
     *
     * <code>bool detached = 15 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The detached to set.
     * @return This builder for chaining.
     */
    public Builder setDetached(boolean value) {

      detached_ = value;
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Indicates whether the subscription is detached from its topic.
     * Detached subscriptions don't receive messages from their topic and don't
     * retain any backlog. `Pull` and `StreamingPull` requests will return
     * FAILED_PRECONDITION. If the subscription is a push subscription, pushes to
     * the endpoint will not be made.
     * </pre>
     *
     * <code>bool detached = 15 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDetached() {
      bitField0_ = (bitField0_ & ~0x00002000);
      detached_ = false;
      onChanged();
      return this;
    }

    private boolean enableExactlyOnceDelivery_;

    /**
     *
     *
     * <pre>
     * Optional. If true, Pub/Sub provides the following guarantees for the
     * delivery of a message with a given value of `message_id` on this
     * subscription:
     *
     * * The message sent to a subscriber is guaranteed not to be resent
     * before the message's acknowledgement deadline expires.
     * * An acknowledged message will not be resent to a subscriber.
     *
     * Note that subscribers may still receive multiple copies of a message
     * when `enable_exactly_once_delivery` is true if the message was published
     * multiple times by a publisher client. These copies are  considered distinct
     * by Pub/Sub and have distinct `message_id` values.
     * </pre>
     *
     * <code>bool enable_exactly_once_delivery = 16 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The enableExactlyOnceDelivery.
     */
    @java.lang.Override
    public boolean getEnableExactlyOnceDelivery() {
      return enableExactlyOnceDelivery_;
    }

    /**
     *
     *
     * <pre>
     * Optional. If true, Pub/Sub provides the following guarantees for the
     * delivery of a message with a given value of `message_id` on this
     * subscription:
     *
     * * The message sent to a subscriber is guaranteed not to be resent
     * before the message's acknowledgement deadline expires.
     * * An acknowledged message will not be resent to a subscriber.
     *
     * Note that subscribers may still receive multiple copies of a message
     * when `enable_exactly_once_delivery` is true if the message was published
     * multiple times by a publisher client. These copies are  considered distinct
     * by Pub/Sub and have distinct `message_id` values.
     * </pre>
     *
     * <code>bool enable_exactly_once_delivery = 16 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The enableExactlyOnceDelivery to set.
     * @return This builder for chaining.
     */
    public Builder setEnableExactlyOnceDelivery(boolean value) {

      enableExactlyOnceDelivery_ = value;
      bitField0_ |= 0x00004000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. If true, Pub/Sub provides the following guarantees for the
     * delivery of a message with a given value of `message_id` on this
     * subscription:
     *
     * * The message sent to a subscriber is guaranteed not to be resent
     * before the message's acknowledgement deadline expires.
     * * An acknowledged message will not be resent to a subscriber.
     *
     * Note that subscribers may still receive multiple copies of a message
     * when `enable_exactly_once_delivery` is true if the message was published
     * multiple times by a publisher client. These copies are  considered distinct
     * by Pub/Sub and have distinct `message_id` values.
     * </pre>
     *
     * <code>bool enable_exactly_once_delivery = 16 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEnableExactlyOnceDelivery() {
      bitField0_ = (bitField0_ & ~0x00004000);
      enableExactlyOnceDelivery_ = false;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.bigquery.analyticshub.v1.MessageTransform>
        messageTransforms_ = java.util.Collections.emptyList();

    private void ensureMessageTransformsIsMutable() {
      if (!((bitField0_ & 0x00008000) != 0)) {
        messageTransforms_ =
            new java.util.ArrayList<com.google.cloud.bigquery.analyticshub.v1.MessageTransform>(
                messageTransforms_);
        bitField0_ |= 0x00008000;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.bigquery.analyticshub.v1.MessageTransform,
            com.google.cloud.bigquery.analyticshub.v1.MessageTransform.Builder,
            com.google.cloud.bigquery.analyticshub.v1.MessageTransformOrBuilder>
        messageTransformsBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. Transforms to be applied to messages before they are delivered to
     * subscribers. Transforms are applied in the order specified.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.analyticshub.v1.MessageTransform message_transforms = 25 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<com.google.cloud.bigquery.analyticshub.v1.MessageTransform>
        getMessageTransformsList() {
      if (messageTransformsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(messageTransforms_);
      } else {
        return messageTransformsBuilder_.getMessageList();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Transforms to be applied to messages before they are delivered to
     * subscribers. Transforms are applied in the order specified.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.analyticshub.v1.MessageTransform message_transforms = 25 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public int getMessageTransformsCount() {
      if (messageTransformsBuilder_ == null) {
        return messageTransforms_.size();
      } else {
        return messageTransformsBuilder_.getCount();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Transforms to be applied to messages before they are delivered to
     * subscribers. Transforms are applied in the order specified.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.analyticshub.v1.MessageTransform message_transforms = 25 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.bigquery.analyticshub.v1.MessageTransform getMessageTransforms(
        int index) {
      if (messageTransformsBuilder_ == null) {
        return messageTransforms_.get(index);
      } else {
        return messageTransformsBuilder_.getMessage(index);
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Transforms to be applied to messages before they are delivered to
     * subscribers. Transforms are applied in the order specified.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.analyticshub.v1.MessageTransform message_transforms = 25 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setMessageTransforms(
        int index, com.google.cloud.bigquery.analyticshub.v1.MessageTransform value) {
      if (messageTransformsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureMessageTransformsIsMutable();
        messageTransforms_.set(index, value);
        onChanged();
      } else {
        messageTransformsBuilder_.setMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Transforms to be applied to messages before they are delivered to
     * subscribers. Transforms are applied in the order specified.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.analyticshub.v1.MessageTransform message_transforms = 25 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setMessageTransforms(
        int index,
        com.google.cloud.bigquery.analyticshub.v1.MessageTransform.Builder builderForValue) {
      if (messageTransformsBuilder_ == null) {
        ensureMessageTransformsIsMutable();
        messageTransforms_.set(index, builderForValue.build());
        onChanged();
      } else {
        messageTransformsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Transforms to be applied to messages before they are delivered to
     * subscribers. Transforms are applied in the order specified.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.analyticshub.v1.MessageTransform message_transforms = 25 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addMessageTransforms(
        com.google.cloud.bigquery.analyticshub.v1.MessageTransform value) {
      if (messageTransformsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureMessageTransformsIsMutable();
        messageTransforms_.add(value);
        onChanged();
      } else {
        messageTransformsBuilder_.addMessage(value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Transforms to be applied to messages before they are delivered to
     * subscribers. Transforms are applied in the order specified.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.analyticshub.v1.MessageTransform message_transforms = 25 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addMessageTransforms(
        int index, com.google.cloud.bigquery.analyticshub.v1.MessageTransform value) {
      if (messageTransformsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureMessageTransformsIsMutable();
        messageTransforms_.add(index, value);
        onChanged();
      } else {
        messageTransformsBuilder_.addMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Transforms to be applied to messages before they are delivered to
     * subscribers. Transforms are applied in the order specified.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.analyticshub.v1.MessageTransform message_transforms = 25 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addMessageTransforms(
        com.google.cloud.bigquery.analyticshub.v1.MessageTransform.Builder builderForValue) {
      if (messageTransformsBuilder_ == null) {
        ensureMessageTransformsIsMutable();
        messageTransforms_.add(builderForValue.build());
        onChanged();
      } else {
        messageTransformsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Transforms to be applied to messages before they are delivered to
     * subscribers. Transforms are applied in the order specified.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.analyticshub.v1.MessageTransform message_transforms = 25 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addMessageTransforms(
        int index,
        com.google.cloud.bigquery.analyticshub.v1.MessageTransform.Builder builderForValue) {
      if (messageTransformsBuilder_ == null) {
        ensureMessageTransformsIsMutable();
        messageTransforms_.add(index, builderForValue.build());
        onChanged();
      } else {
        messageTransformsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Transforms to be applied to messages before they are delivered to
     * subscribers. Transforms are applied in the order specified.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.analyticshub.v1.MessageTransform message_transforms = 25 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addAllMessageTransforms(
        java.lang.Iterable<? extends com.google.cloud.bigquery.analyticshub.v1.MessageTransform>
            values) {
      if (messageTransformsBuilder_ == null) {
        ensureMessageTransformsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, messageTransforms_);
        onChanged();
      } else {
        messageTransformsBuilder_.addAllMessages(values);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Transforms to be applied to messages before they are delivered to
     * subscribers. Transforms are applied in the order specified.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.analyticshub.v1.MessageTransform message_transforms = 25 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearMessageTransforms() {
      if (messageTransformsBuilder_ == null) {
        messageTransforms_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00008000);
        onChanged();
      } else {
        messageTransformsBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Transforms to be applied to messages before they are delivered to
     * subscribers. Transforms are applied in the order specified.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.analyticshub.v1.MessageTransform message_transforms = 25 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder removeMessageTransforms(int index) {
      if (messageTransformsBuilder_ == null) {
        ensureMessageTransformsIsMutable();
        messageTransforms_.remove(index);
        onChanged();
      } else {
        messageTransformsBuilder_.remove(index);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Transforms to be applied to messages before they are delivered to
     * subscribers. Transforms are applied in the order specified.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.analyticshub.v1.MessageTransform message_transforms = 25 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.bigquery.analyticshub.v1.MessageTransform.Builder
        getMessageTransformsBuilder(int index) {
      return getMessageTransformsFieldBuilder().getBuilder(index);
    }

    /**
     *
     *
     * <pre>
     * Optional. Transforms to be applied to messages before they are delivered to
     * subscribers. Transforms are applied in the order specified.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.analyticshub.v1.MessageTransform message_transforms = 25 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.bigquery.analyticshub.v1.MessageTransformOrBuilder
        getMessageTransformsOrBuilder(int index) {
      if (messageTransformsBuilder_ == null) {
        return messageTransforms_.get(index);
      } else {
        return messageTransformsBuilder_.getMessageOrBuilder(index);
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Transforms to be applied to messages before they are delivered to
     * subscribers. Transforms are applied in the order specified.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.analyticshub.v1.MessageTransform message_transforms = 25 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<
            ? extends com.google.cloud.bigquery.analyticshub.v1.MessageTransformOrBuilder>
        getMessageTransformsOrBuilderList() {
      if (messageTransformsBuilder_ != null) {
        return messageTransformsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(messageTransforms_);
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Transforms to be applied to messages before they are delivered to
     * subscribers. Transforms are applied in the order specified.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.analyticshub.v1.MessageTransform message_transforms = 25 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.bigquery.analyticshub.v1.MessageTransform.Builder
        addMessageTransformsBuilder() {
      return getMessageTransformsFieldBuilder()
          .addBuilder(
              com.google.cloud.bigquery.analyticshub.v1.MessageTransform.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * Optional. Transforms to be applied to messages before they are delivered to
     * subscribers. Transforms are applied in the order specified.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.analyticshub.v1.MessageTransform message_transforms = 25 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.bigquery.analyticshub.v1.MessageTransform.Builder
        addMessageTransformsBuilder(int index) {
      return getMessageTransformsFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.bigquery.analyticshub.v1.MessageTransform.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * Optional. Transforms to be applied to messages before they are delivered to
     * subscribers. Transforms are applied in the order specified.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.analyticshub.v1.MessageTransform message_transforms = 25 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<com.google.cloud.bigquery.analyticshub.v1.MessageTransform.Builder>
        getMessageTransformsBuilderList() {
      return getMessageTransformsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.bigquery.analyticshub.v1.MessageTransform,
            com.google.cloud.bigquery.analyticshub.v1.MessageTransform.Builder,
            com.google.cloud.bigquery.analyticshub.v1.MessageTransformOrBuilder>
        getMessageTransformsFieldBuilder() {
      if (messageTransformsBuilder_ == null) {
        messageTransformsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.bigquery.analyticshub.v1.MessageTransform,
                com.google.cloud.bigquery.analyticshub.v1.MessageTransform.Builder,
                com.google.cloud.bigquery.analyticshub.v1.MessageTransformOrBuilder>(
                messageTransforms_,
                ((bitField0_ & 0x00008000) != 0),
                getParentForChildren(),
                isClean());
        messageTransforms_ = null;
      }
      return messageTransformsBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.bigquery.analyticshub.v1.PubSubSubscription)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.bigquery.analyticshub.v1.PubSubSubscription)
  private static final com.google.cloud.bigquery.analyticshub.v1.PubSubSubscription
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.bigquery.analyticshub.v1.PubSubSubscription();
  }

  public static com.google.cloud.bigquery.analyticshub.v1.PubSubSubscription getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<PubSubSubscription> PARSER =
      new com.google.protobuf.AbstractParser<PubSubSubscription>() {
        @java.lang.Override
        public PubSubSubscription parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<PubSubSubscription> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<PubSubSubscription> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.bigquery.analyticshub.v1.PubSubSubscription getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
