/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/bigquery/analyticshub/v1/analyticshub.proto

// Protobuf Java Version: 3.25.8
package com.google.cloud.bigquery.analyticshub.v1;

public interface ListingOrBuilder
    extends
    // @@protoc_insertion_point(interface_extends:google.cloud.bigquery.analyticshub.v1.Listing)
    com.google.protobuf.MessageOrBuilder {

  /**
   *
   *
   * <pre>
   * Shared dataset i.e. BigQuery dataset source.
   * </pre>
   *
   * <code>
   * .google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource bigquery_dataset = 6;
   * </code>
   *
   * @return Whether the bigqueryDataset field is set.
   */
  boolean hasBigqueryDataset();

  /**
   *
   *
   * <pre>
   * Shared dataset i.e. BigQuery dataset source.
   * </pre>
   *
   * <code>
   * .google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource bigquery_dataset = 6;
   * </code>
   *
   * @return The bigqueryDataset.
   */
  com.google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource getBigqueryDataset();

  /**
   *
   *
   * <pre>
   * Shared dataset i.e. BigQuery dataset source.
   * </pre>
   *
   * <code>
   * .google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource bigquery_dataset = 6;
   * </code>
   */
  com.google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSourceOrBuilder
      getBigqueryDatasetOrBuilder();

  /**
   *
   *
   * <pre>
   * Pub/Sub topic source.
   * </pre>
   *
   * <code>.google.cloud.bigquery.analyticshub.v1.Listing.PubSubTopicSource pubsub_topic = 16;
   * </code>
   *
   * @return Whether the pubsubTopic field is set.
   */
  boolean hasPubsubTopic();

  /**
   *
   *
   * <pre>
   * Pub/Sub topic source.
   * </pre>
   *
   * <code>.google.cloud.bigquery.analyticshub.v1.Listing.PubSubTopicSource pubsub_topic = 16;
   * </code>
   *
   * @return The pubsubTopic.
   */
  com.google.cloud.bigquery.analyticshub.v1.Listing.PubSubTopicSource getPubsubTopic();

  /**
   *
   *
   * <pre>
   * Pub/Sub topic source.
   * </pre>
   *
   * <code>.google.cloud.bigquery.analyticshub.v1.Listing.PubSubTopicSource pubsub_topic = 16;
   * </code>
   */
  com.google.cloud.bigquery.analyticshub.v1.Listing.PubSubTopicSourceOrBuilder
      getPubsubTopicOrBuilder();

  /**
   *
   *
   * <pre>
   * Output only. The resource name of the listing.
   * e.g. `projects/myproject/locations/us/dataExchanges/123/listings/456`
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The name.
   */
  java.lang.String getName();

  /**
   *
   *
   * <pre>
   * Output only. The resource name of the listing.
   * e.g. `projects/myproject/locations/us/dataExchanges/123/listings/456`
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for name.
   */
  com.google.protobuf.ByteString getNameBytes();

  /**
   *
   *
   * <pre>
   * Required. Human-readable display name of the listing. The display name must
   * contain only Unicode letters, numbers (0-9), underscores (_), dashes (-),
   * spaces ( ), ampersands (&amp;) and can't start or end with spaces. Default
   * value is an empty string. Max length: 63 bytes.
   * </pre>
   *
   * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The displayName.
   */
  java.lang.String getDisplayName();

  /**
   *
   *
   * <pre>
   * Required. Human-readable display name of the listing. The display name must
   * contain only Unicode letters, numbers (0-9), underscores (_), dashes (-),
   * spaces ( ), ampersands (&amp;) and can't start or end with spaces. Default
   * value is an empty string. Max length: 63 bytes.
   * </pre>
   *
   * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for displayName.
   */
  com.google.protobuf.ByteString getDisplayNameBytes();

  /**
   *
   *
   * <pre>
   * Optional. Short description of the listing. The description must not
   * contain Unicode non-characters and C0 and C1 control codes except tabs
   * (HT), new lines (LF), carriage returns (CR), and page breaks (FF). Default
   * value is an empty string. Max length: 2000 bytes.
   * </pre>
   *
   * <code>string description = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The description.
   */
  java.lang.String getDescription();

  /**
   *
   *
   * <pre>
   * Optional. Short description of the listing. The description must not
   * contain Unicode non-characters and C0 and C1 control codes except tabs
   * (HT), new lines (LF), carriage returns (CR), and page breaks (FF). Default
   * value is an empty string. Max length: 2000 bytes.
   * </pre>
   *
   * <code>string description = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for description.
   */
  com.google.protobuf.ByteString getDescriptionBytes();

  /**
   *
   *
   * <pre>
   * Optional. Email or URL of the primary point of contact of the listing.
   * Max Length: 1000 bytes.
   * </pre>
   *
   * <code>string primary_contact = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The primaryContact.
   */
  java.lang.String getPrimaryContact();

  /**
   *
   *
   * <pre>
   * Optional. Email or URL of the primary point of contact of the listing.
   * Max Length: 1000 bytes.
   * </pre>
   *
   * <code>string primary_contact = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for primaryContact.
   */
  com.google.protobuf.ByteString getPrimaryContactBytes();

  /**
   *
   *
   * <pre>
   * Optional. Documentation describing the listing.
   * </pre>
   *
   * <code>string documentation = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The documentation.
   */
  java.lang.String getDocumentation();

  /**
   *
   *
   * <pre>
   * Optional. Documentation describing the listing.
   * </pre>
   *
   * <code>string documentation = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for documentation.
   */
  com.google.protobuf.ByteString getDocumentationBytes();

  /**
   *
   *
   * <pre>
   * Output only. Current state of the listing.
   * </pre>
   *
   * <code>
   * .google.cloud.bigquery.analyticshub.v1.Listing.State state = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The enum numeric value on the wire for state.
   */
  int getStateValue();

  /**
   *
   *
   * <pre>
   * Output only. Current state of the listing.
   * </pre>
   *
   * <code>
   * .google.cloud.bigquery.analyticshub.v1.Listing.State state = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The state.
   */
  com.google.cloud.bigquery.analyticshub.v1.Listing.State getState();

  /**
   *
   *
   * <pre>
   * Optional. Base64 encoded image representing the listing. Max Size: 3.0MiB
   * Expected image dimensions are 512x512 pixels, however the API only
   * performs validation on size of the encoded data.
   * Note: For byte fields, the contents of the field are base64-encoded (which
   * increases the size of the data by 33-36%) when using JSON on the wire.
   * </pre>
   *
   * <code>bytes icon = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The icon.
   */
  com.google.protobuf.ByteString getIcon();

  /**
   *
   *
   * <pre>
   * Optional. Details of the data provider who owns the source data.
   * </pre>
   *
   * <code>
   * .google.cloud.bigquery.analyticshub.v1.DataProvider data_provider = 9 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the dataProvider field is set.
   */
  boolean hasDataProvider();

  /**
   *
   *
   * <pre>
   * Optional. Details of the data provider who owns the source data.
   * </pre>
   *
   * <code>
   * .google.cloud.bigquery.analyticshub.v1.DataProvider data_provider = 9 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The dataProvider.
   */
  com.google.cloud.bigquery.analyticshub.v1.DataProvider getDataProvider();

  /**
   *
   *
   * <pre>
   * Optional. Details of the data provider who owns the source data.
   * </pre>
   *
   * <code>
   * .google.cloud.bigquery.analyticshub.v1.DataProvider data_provider = 9 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  com.google.cloud.bigquery.analyticshub.v1.DataProviderOrBuilder getDataProviderOrBuilder();

  /**
   *
   *
   * <pre>
   * Optional. Categories of the listing. Up to two categories are allowed.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.bigquery.analyticshub.v1.Listing.Category categories = 10 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return A list containing the categories.
   */
  java.util.List<com.google.cloud.bigquery.analyticshub.v1.Listing.Category> getCategoriesList();

  /**
   *
   *
   * <pre>
   * Optional. Categories of the listing. Up to two categories are allowed.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.bigquery.analyticshub.v1.Listing.Category categories = 10 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The count of categories.
   */
  int getCategoriesCount();

  /**
   *
   *
   * <pre>
   * Optional. Categories of the listing. Up to two categories are allowed.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.bigquery.analyticshub.v1.Listing.Category categories = 10 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @param index The index of the element to return.
   * @return The categories at the given index.
   */
  com.google.cloud.bigquery.analyticshub.v1.Listing.Category getCategories(int index);

  /**
   *
   *
   * <pre>
   * Optional. Categories of the listing. Up to two categories are allowed.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.bigquery.analyticshub.v1.Listing.Category categories = 10 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return A list containing the enum numeric values on the wire for categories.
   */
  java.util.List<java.lang.Integer> getCategoriesValueList();

  /**
   *
   *
   * <pre>
   * Optional. Categories of the listing. Up to two categories are allowed.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.bigquery.analyticshub.v1.Listing.Category categories = 10 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @param index The index of the value to return.
   * @return The enum numeric value on the wire of categories at the given index.
   */
  int getCategoriesValue(int index);

  /**
   *
   *
   * <pre>
   * Optional. Details of the publisher who owns the listing and who can share
   * the source data.
   * </pre>
   *
   * <code>
   * .google.cloud.bigquery.analyticshub.v1.Publisher publisher = 11 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the publisher field is set.
   */
  boolean hasPublisher();

  /**
   *
   *
   * <pre>
   * Optional. Details of the publisher who owns the listing and who can share
   * the source data.
   * </pre>
   *
   * <code>
   * .google.cloud.bigquery.analyticshub.v1.Publisher publisher = 11 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The publisher.
   */
  com.google.cloud.bigquery.analyticshub.v1.Publisher getPublisher();

  /**
   *
   *
   * <pre>
   * Optional. Details of the publisher who owns the listing and who can share
   * the source data.
   * </pre>
   *
   * <code>
   * .google.cloud.bigquery.analyticshub.v1.Publisher publisher = 11 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  com.google.cloud.bigquery.analyticshub.v1.PublisherOrBuilder getPublisherOrBuilder();

  /**
   *
   *
   * <pre>
   * Optional. Email or URL of the request access of the listing.
   * Subscribers can use this reference to request access.
   * Max Length: 1000 bytes.
   * </pre>
   *
   * <code>string request_access = 12 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The requestAccess.
   */
  java.lang.String getRequestAccess();

  /**
   *
   *
   * <pre>
   * Optional. Email or URL of the request access of the listing.
   * Subscribers can use this reference to request access.
   * Max Length: 1000 bytes.
   * </pre>
   *
   * <code>string request_access = 12 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for requestAccess.
   */
  com.google.protobuf.ByteString getRequestAccessBytes();

  /**
   *
   *
   * <pre>
   * Optional. If set, restricted export configuration will be propagated and
   * enforced on the linked dataset.
   * </pre>
   *
   * <code>
   * .google.cloud.bigquery.analyticshub.v1.Listing.RestrictedExportConfig restricted_export_config = 13 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the restrictedExportConfig field is set.
   */
  boolean hasRestrictedExportConfig();

  /**
   *
   *
   * <pre>
   * Optional. If set, restricted export configuration will be propagated and
   * enforced on the linked dataset.
   * </pre>
   *
   * <code>
   * .google.cloud.bigquery.analyticshub.v1.Listing.RestrictedExportConfig restricted_export_config = 13 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The restrictedExportConfig.
   */
  com.google.cloud.bigquery.analyticshub.v1.Listing.RestrictedExportConfig
      getRestrictedExportConfig();

  /**
   *
   *
   * <pre>
   * Optional. If set, restricted export configuration will be propagated and
   * enforced on the linked dataset.
   * </pre>
   *
   * <code>
   * .google.cloud.bigquery.analyticshub.v1.Listing.RestrictedExportConfig restricted_export_config = 13 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  com.google.cloud.bigquery.analyticshub.v1.Listing.RestrictedExportConfigOrBuilder
      getRestrictedExportConfigOrBuilder();

  /**
   *
   *
   * <pre>
   * Optional. Type of discovery of the listing on the discovery page.
   * </pre>
   *
   * <code>
   * optional .google.cloud.bigquery.analyticshub.v1.DiscoveryType discovery_type = 14 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the discoveryType field is set.
   */
  boolean hasDiscoveryType();

  /**
   *
   *
   * <pre>
   * Optional. Type of discovery of the listing on the discovery page.
   * </pre>
   *
   * <code>
   * optional .google.cloud.bigquery.analyticshub.v1.DiscoveryType discovery_type = 14 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The enum numeric value on the wire for discoveryType.
   */
  int getDiscoveryTypeValue();

  /**
   *
   *
   * <pre>
   * Optional. Type of discovery of the listing on the discovery page.
   * </pre>
   *
   * <code>
   * optional .google.cloud.bigquery.analyticshub.v1.DiscoveryType discovery_type = 14 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The discoveryType.
   */
  com.google.cloud.bigquery.analyticshub.v1.DiscoveryType getDiscoveryType();

  /**
   *
   *
   * <pre>
   * Output only. Listing shared asset type.
   * </pre>
   *
   * <code>
   * .google.cloud.bigquery.analyticshub.v1.SharedResourceType resource_type = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The enum numeric value on the wire for resourceType.
   */
  int getResourceTypeValue();

  /**
   *
   *
   * <pre>
   * Output only. Listing shared asset type.
   * </pre>
   *
   * <code>
   * .google.cloud.bigquery.analyticshub.v1.SharedResourceType resource_type = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The resourceType.
   */
  com.google.cloud.bigquery.analyticshub.v1.SharedResourceType getResourceType();

  /**
   *
   *
   * <pre>
   * Output only. Commercial info contains the information about the commercial
   * data products associated with the listing.
   * </pre>
   *
   * <code>
   * optional .google.cloud.bigquery.analyticshub.v1.Listing.CommercialInfo commercial_info = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the commercialInfo field is set.
   */
  boolean hasCommercialInfo();

  /**
   *
   *
   * <pre>
   * Output only. Commercial info contains the information about the commercial
   * data products associated with the listing.
   * </pre>
   *
   * <code>
   * optional .google.cloud.bigquery.analyticshub.v1.Listing.CommercialInfo commercial_info = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The commercialInfo.
   */
  com.google.cloud.bigquery.analyticshub.v1.Listing.CommercialInfo getCommercialInfo();

  /**
   *
   *
   * <pre>
   * Output only. Commercial info contains the information about the commercial
   * data products associated with the listing.
   * </pre>
   *
   * <code>
   * optional .google.cloud.bigquery.analyticshub.v1.Listing.CommercialInfo commercial_info = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  com.google.cloud.bigquery.analyticshub.v1.Listing.CommercialInfoOrBuilder
      getCommercialInfoOrBuilder();

  /**
   *
   *
   * <pre>
   * Optional. By default, false.
   * If true, the Listing has an email sharing mandate enabled.
   * </pre>
   *
   * <code>
   * optional bool log_linked_dataset_query_user_email = 18 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the logLinkedDatasetQueryUserEmail field is set.
   */
  boolean hasLogLinkedDatasetQueryUserEmail();

  /**
   *
   *
   * <pre>
   * Optional. By default, false.
   * If true, the Listing has an email sharing mandate enabled.
   * </pre>
   *
   * <code>
   * optional bool log_linked_dataset_query_user_email = 18 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The logLinkedDatasetQueryUserEmail.
   */
  boolean getLogLinkedDatasetQueryUserEmail();

  /**
   *
   *
   * <pre>
   * Optional. If true, the listing is only available to get the resource
   * metadata. Listing is non subscribable.
   * </pre>
   *
   * <code>optional bool allow_only_metadata_sharing = 19 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the allowOnlyMetadataSharing field is set.
   */
  boolean hasAllowOnlyMetadataSharing();

  /**
   *
   *
   * <pre>
   * Optional. If true, the listing is only available to get the resource
   * metadata. Listing is non subscribable.
   * </pre>
   *
   * <code>optional bool allow_only_metadata_sharing = 19 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The allowOnlyMetadataSharing.
   */
  boolean getAllowOnlyMetadataSharing();

  com.google.cloud.bigquery.analyticshub.v1.Listing.SourceCase getSourceCase();
}
