/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/bigquery/analyticshub/v1/analyticshub.proto

// Protobuf Java Version: 3.25.8
package com.google.cloud.bigquery.analyticshub.v1;

/**
 *
 *
 * <pre>
 * A listing is what gets published into a data exchange that a subscriber can
 * subscribe to. It contains a reference to the data source along with
 * descriptive information that will help subscribers find and subscribe the
 * data.
 * </pre>
 *
 * Protobuf type {@code google.cloud.bigquery.analyticshub.v1.Listing}
 */
public final class Listing extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.bigquery.analyticshub.v1.Listing)
    ListingOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use Listing.newBuilder() to construct.
  private Listing(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Listing() {
    name_ = "";
    displayName_ = "";
    description_ = "";
    primaryContact_ = "";
    documentation_ = "";
    state_ = 0;
    icon_ = com.google.protobuf.ByteString.EMPTY;
    categories_ = java.util.Collections.emptyList();
    requestAccess_ = "";
    discoveryType_ = 0;
    resourceType_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Listing();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.bigquery.analyticshub.v1.AnalyticsHubProto
        .internal_static_google_cloud_bigquery_analyticshub_v1_Listing_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.bigquery.analyticshub.v1.AnalyticsHubProto
        .internal_static_google_cloud_bigquery_analyticshub_v1_Listing_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.bigquery.analyticshub.v1.Listing.class,
            com.google.cloud.bigquery.analyticshub.v1.Listing.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * State of the listing.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.bigquery.analyticshub.v1.Listing.State}
   */
  public enum State implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Default value. This value is unused.
     * </pre>
     *
     * <code>STATE_UNSPECIFIED = 0;</code>
     */
    STATE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Subscribable state. Users with dataexchange.listings.subscribe permission
     * can subscribe to this listing.
     * </pre>
     *
     * <code>ACTIVE = 1;</code>
     */
    ACTIVE(1),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Default value. This value is unused.
     * </pre>
     *
     * <code>STATE_UNSPECIFIED = 0;</code>
     */
    public static final int STATE_UNSPECIFIED_VALUE = 0;

    /**
     *
     *
     * <pre>
     * Subscribable state. Users with dataexchange.listings.subscribe permission
     * can subscribe to this listing.
     * </pre>
     *
     * <code>ACTIVE = 1;</code>
     */
    public static final int ACTIVE_VALUE = 1;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static State valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static State forNumber(int value) {
      switch (value) {
        case 0:
          return STATE_UNSPECIFIED;
        case 1:
          return ACTIVE;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<State> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<State> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<State>() {
          public State findValueByNumber(int number) {
            return State.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.bigquery.analyticshub.v1.Listing.getDescriptor()
          .getEnumTypes()
          .get(0);
    }

    private static final State[] VALUES = values();

    public static State valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private State(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.bigquery.analyticshub.v1.Listing.State)
  }

  /**
   *
   *
   * <pre>
   * Listing categories.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.bigquery.analyticshub.v1.Listing.Category}
   */
  public enum Category implements com.google.protobuf.ProtocolMessageEnum {
    /** <code>CATEGORY_UNSPECIFIED = 0;</code> */
    CATEGORY_UNSPECIFIED(0),
    /** <code>CATEGORY_OTHERS = 1;</code> */
    CATEGORY_OTHERS(1),
    /** <code>CATEGORY_ADVERTISING_AND_MARKETING = 2;</code> */
    CATEGORY_ADVERTISING_AND_MARKETING(2),
    /** <code>CATEGORY_COMMERCE = 3;</code> */
    CATEGORY_COMMERCE(3),
    /** <code>CATEGORY_CLIMATE_AND_ENVIRONMENT = 4;</code> */
    CATEGORY_CLIMATE_AND_ENVIRONMENT(4),
    /** <code>CATEGORY_DEMOGRAPHICS = 5;</code> */
    CATEGORY_DEMOGRAPHICS(5),
    /** <code>CATEGORY_ECONOMICS = 6;</code> */
    CATEGORY_ECONOMICS(6),
    /** <code>CATEGORY_EDUCATION = 7;</code> */
    CATEGORY_EDUCATION(7),
    /** <code>CATEGORY_ENERGY = 8;</code> */
    CATEGORY_ENERGY(8),
    /** <code>CATEGORY_FINANCIAL = 9;</code> */
    CATEGORY_FINANCIAL(9),
    /** <code>CATEGORY_GAMING = 10;</code> */
    CATEGORY_GAMING(10),
    /** <code>CATEGORY_GEOSPATIAL = 11;</code> */
    CATEGORY_GEOSPATIAL(11),
    /** <code>CATEGORY_HEALTHCARE_AND_LIFE_SCIENCE = 12;</code> */
    CATEGORY_HEALTHCARE_AND_LIFE_SCIENCE(12),
    /** <code>CATEGORY_MEDIA = 13;</code> */
    CATEGORY_MEDIA(13),
    /** <code>CATEGORY_PUBLIC_SECTOR = 14;</code> */
    CATEGORY_PUBLIC_SECTOR(14),
    /** <code>CATEGORY_RETAIL = 15;</code> */
    CATEGORY_RETAIL(15),
    /** <code>CATEGORY_SPORTS = 16;</code> */
    CATEGORY_SPORTS(16),
    /** <code>CATEGORY_SCIENCE_AND_RESEARCH = 17;</code> */
    CATEGORY_SCIENCE_AND_RESEARCH(17),
    /** <code>CATEGORY_TRANSPORTATION_AND_LOGISTICS = 18;</code> */
    CATEGORY_TRANSPORTATION_AND_LOGISTICS(18),
    /** <code>CATEGORY_TRAVEL_AND_TOURISM = 19;</code> */
    CATEGORY_TRAVEL_AND_TOURISM(19),
    UNRECOGNIZED(-1),
    ;

    /** <code>CATEGORY_UNSPECIFIED = 0;</code> */
    public static final int CATEGORY_UNSPECIFIED_VALUE = 0;

    /** <code>CATEGORY_OTHERS = 1;</code> */
    public static final int CATEGORY_OTHERS_VALUE = 1;

    /** <code>CATEGORY_ADVERTISING_AND_MARKETING = 2;</code> */
    public static final int CATEGORY_ADVERTISING_AND_MARKETING_VALUE = 2;

    /** <code>CATEGORY_COMMERCE = 3;</code> */
    public static final int CATEGORY_COMMERCE_VALUE = 3;

    /** <code>CATEGORY_CLIMATE_AND_ENVIRONMENT = 4;</code> */
    public static final int CATEGORY_CLIMATE_AND_ENVIRONMENT_VALUE = 4;

    /** <code>CATEGORY_DEMOGRAPHICS = 5;</code> */
    public static final int CATEGORY_DEMOGRAPHICS_VALUE = 5;

    /** <code>CATEGORY_ECONOMICS = 6;</code> */
    public static final int CATEGORY_ECONOMICS_VALUE = 6;

    /** <code>CATEGORY_EDUCATION = 7;</code> */
    public static final int CATEGORY_EDUCATION_VALUE = 7;

    /** <code>CATEGORY_ENERGY = 8;</code> */
    public static final int CATEGORY_ENERGY_VALUE = 8;

    /** <code>CATEGORY_FINANCIAL = 9;</code> */
    public static final int CATEGORY_FINANCIAL_VALUE = 9;

    /** <code>CATEGORY_GAMING = 10;</code> */
    public static final int CATEGORY_GAMING_VALUE = 10;

    /** <code>CATEGORY_GEOSPATIAL = 11;</code> */
    public static final int CATEGORY_GEOSPATIAL_VALUE = 11;

    /** <code>CATEGORY_HEALTHCARE_AND_LIFE_SCIENCE = 12;</code> */
    public static final int CATEGORY_HEALTHCARE_AND_LIFE_SCIENCE_VALUE = 12;

    /** <code>CATEGORY_MEDIA = 13;</code> */
    public static final int CATEGORY_MEDIA_VALUE = 13;

    /** <code>CATEGORY_PUBLIC_SECTOR = 14;</code> */
    public static final int CATEGORY_PUBLIC_SECTOR_VALUE = 14;

    /** <code>CATEGORY_RETAIL = 15;</code> */
    public static final int CATEGORY_RETAIL_VALUE = 15;

    /** <code>CATEGORY_SPORTS = 16;</code> */
    public static final int CATEGORY_SPORTS_VALUE = 16;

    /** <code>CATEGORY_SCIENCE_AND_RESEARCH = 17;</code> */
    public static final int CATEGORY_SCIENCE_AND_RESEARCH_VALUE = 17;

    /** <code>CATEGORY_TRANSPORTATION_AND_LOGISTICS = 18;</code> */
    public static final int CATEGORY_TRANSPORTATION_AND_LOGISTICS_VALUE = 18;

    /** <code>CATEGORY_TRAVEL_AND_TOURISM = 19;</code> */
    public static final int CATEGORY_TRAVEL_AND_TOURISM_VALUE = 19;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static Category valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static Category forNumber(int value) {
      switch (value) {
        case 0:
          return CATEGORY_UNSPECIFIED;
        case 1:
          return CATEGORY_OTHERS;
        case 2:
          return CATEGORY_ADVERTISING_AND_MARKETING;
        case 3:
          return CATEGORY_COMMERCE;
        case 4:
          return CATEGORY_CLIMATE_AND_ENVIRONMENT;
        case 5:
          return CATEGORY_DEMOGRAPHICS;
        case 6:
          return CATEGORY_ECONOMICS;
        case 7:
          return CATEGORY_EDUCATION;
        case 8:
          return CATEGORY_ENERGY;
        case 9:
          return CATEGORY_FINANCIAL;
        case 10:
          return CATEGORY_GAMING;
        case 11:
          return CATEGORY_GEOSPATIAL;
        case 12:
          return CATEGORY_HEALTHCARE_AND_LIFE_SCIENCE;
        case 13:
          return CATEGORY_MEDIA;
        case 14:
          return CATEGORY_PUBLIC_SECTOR;
        case 15:
          return CATEGORY_RETAIL;
        case 16:
          return CATEGORY_SPORTS;
        case 17:
          return CATEGORY_SCIENCE_AND_RESEARCH;
        case 18:
          return CATEGORY_TRANSPORTATION_AND_LOGISTICS;
        case 19:
          return CATEGORY_TRAVEL_AND_TOURISM;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<Category> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<Category> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<Category>() {
          public Category findValueByNumber(int number) {
            return Category.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.bigquery.analyticshub.v1.Listing.getDescriptor()
          .getEnumTypes()
          .get(1);
    }

    private static final Category[] VALUES = values();

    public static Category valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private Category(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.bigquery.analyticshub.v1.Listing.Category)
  }

  public interface BigQueryDatasetSourceOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Optional. Resource name of the dataset source for this listing.
     * e.g. `projects/myproject/datasets/123`
     * </pre>
     *
     * <code>
     * string dataset = 1 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The dataset.
     */
    java.lang.String getDataset();

    /**
     *
     *
     * <pre>
     * Optional. Resource name of the dataset source for this listing.
     * e.g. `projects/myproject/datasets/123`
     * </pre>
     *
     * <code>
     * string dataset = 1 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for dataset.
     */
    com.google.protobuf.ByteString getDatasetBytes();

    /**
     *
     *
     * <pre>
     * Optional. Resource in this dataset that is selectively shared.
     * This field is required for data clean room exchanges.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource.SelectedResource selected_resources = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    java.util.List<
            com.google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource
                .SelectedResource>
        getSelectedResourcesList();

    /**
     *
     *
     * <pre>
     * Optional. Resource in this dataset that is selectively shared.
     * This field is required for data clean room exchanges.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource.SelectedResource selected_resources = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    com.google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource.SelectedResource
        getSelectedResources(int index);

    /**
     *
     *
     * <pre>
     * Optional. Resource in this dataset that is selectively shared.
     * This field is required for data clean room exchanges.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource.SelectedResource selected_resources = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    int getSelectedResourcesCount();

    /**
     *
     *
     * <pre>
     * Optional. Resource in this dataset that is selectively shared.
     * This field is required for data clean room exchanges.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource.SelectedResource selected_resources = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    java.util.List<
            ? extends
                com.google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource
                    .SelectedResourceOrBuilder>
        getSelectedResourcesOrBuilderList();

    /**
     *
     *
     * <pre>
     * Optional. Resource in this dataset that is selectively shared.
     * This field is required for data clean room exchanges.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource.SelectedResource selected_resources = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    com.google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource
            .SelectedResourceOrBuilder
        getSelectedResourcesOrBuilder(int index);

    /**
     *
     *
     * <pre>
     * Optional. If set, restricted export policy will be propagated and
     * enforced on the linked dataset.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource.RestrictedExportPolicy restricted_export_policy = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the restrictedExportPolicy field is set.
     */
    boolean hasRestrictedExportPolicy();

    /**
     *
     *
     * <pre>
     * Optional. If set, restricted export policy will be propagated and
     * enforced on the linked dataset.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource.RestrictedExportPolicy restricted_export_policy = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The restrictedExportPolicy.
     */
    com.google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource.RestrictedExportPolicy
        getRestrictedExportPolicy();

    /**
     *
     *
     * <pre>
     * Optional. If set, restricted export policy will be propagated and
     * enforced on the linked dataset.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource.RestrictedExportPolicy restricted_export_policy = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    com.google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource
            .RestrictedExportPolicyOrBuilder
        getRestrictedExportPolicyOrBuilder();
  }

  /**
   *
   *
   * <pre>
   * A reference to a shared dataset. It is an existing BigQuery dataset with a
   * collection of objects such as tables and views that you want to share
   * with subscribers.
   * When subscriber's subscribe to a listing, Analytics Hub creates a linked
   * dataset in
   * the subscriber's project. A Linked dataset is an opaque, read-only BigQuery
   * dataset that serves as a _symbolic link_ to a shared dataset.
   * </pre>
   *
   * Protobuf type {@code google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource}
   */
  public static final class BigQueryDatasetSource extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource)
      BigQueryDatasetSourceOrBuilder {
    private static final long serialVersionUID = 0L;

    // Use BigQueryDatasetSource.newBuilder() to construct.
    private BigQueryDatasetSource(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private BigQueryDatasetSource() {
      dataset_ = "";
      selectedResources_ = java.util.Collections.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new BigQueryDatasetSource();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.bigquery.analyticshub.v1.AnalyticsHubProto
          .internal_static_google_cloud_bigquery_analyticshub_v1_Listing_BigQueryDatasetSource_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.bigquery.analyticshub.v1.AnalyticsHubProto
          .internal_static_google_cloud_bigquery_analyticshub_v1_Listing_BigQueryDatasetSource_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource.class,
              com.google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource.Builder
                  .class);
    }

    public interface SelectedResourceOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource.SelectedResource)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * Optional. Format:
       * For table:
       * `projects/{projectId}/datasets/{datasetId}/tables/{tableId}`
       * Example:"projects/test_project/datasets/test_dataset/tables/test_table"
       * </pre>
       *
       * <code>
       * string table = 1 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return Whether the table field is set.
       */
      boolean hasTable();

      /**
       *
       *
       * <pre>
       * Optional. Format:
       * For table:
       * `projects/{projectId}/datasets/{datasetId}/tables/{tableId}`
       * Example:"projects/test_project/datasets/test_dataset/tables/test_table"
       * </pre>
       *
       * <code>
       * string table = 1 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return The table.
       */
      java.lang.String getTable();

      /**
       *
       *
       * <pre>
       * Optional. Format:
       * For table:
       * `projects/{projectId}/datasets/{datasetId}/tables/{tableId}`
       * Example:"projects/test_project/datasets/test_dataset/tables/test_table"
       * </pre>
       *
       * <code>
       * string table = 1 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return The bytes for table.
       */
      com.google.protobuf.ByteString getTableBytes();

      /**
       *
       *
       * <pre>
       * Optional. Format:
       * For routine:
       * `projects/{projectId}/datasets/{datasetId}/routines/{routineId}`
       * Example:"projects/test_project/datasets/test_dataset/routines/test_routine"
       * </pre>
       *
       * <code>
       * string routine = 2 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return Whether the routine field is set.
       */
      boolean hasRoutine();

      /**
       *
       *
       * <pre>
       * Optional. Format:
       * For routine:
       * `projects/{projectId}/datasets/{datasetId}/routines/{routineId}`
       * Example:"projects/test_project/datasets/test_dataset/routines/test_routine"
       * </pre>
       *
       * <code>
       * string routine = 2 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return The routine.
       */
      java.lang.String getRoutine();

      /**
       *
       *
       * <pre>
       * Optional. Format:
       * For routine:
       * `projects/{projectId}/datasets/{datasetId}/routines/{routineId}`
       * Example:"projects/test_project/datasets/test_dataset/routines/test_routine"
       * </pre>
       *
       * <code>
       * string routine = 2 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return The bytes for routine.
       */
      com.google.protobuf.ByteString getRoutineBytes();

      com.google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource.SelectedResource
              .ResourceCase
          getResourceCase();
    }

    /**
     *
     *
     * <pre>
     * Resource in this dataset that is selectively shared.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource.SelectedResource}
     */
    public static final class SelectedResource extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource.SelectedResource)
        SelectedResourceOrBuilder {
      private static final long serialVersionUID = 0L;

      // Use SelectedResource.newBuilder() to construct.
      private SelectedResource(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private SelectedResource() {}

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new SelectedResource();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.bigquery.analyticshub.v1.AnalyticsHubProto
            .internal_static_google_cloud_bigquery_analyticshub_v1_Listing_BigQueryDatasetSource_SelectedResource_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.bigquery.analyticshub.v1.AnalyticsHubProto
            .internal_static_google_cloud_bigquery_analyticshub_v1_Listing_BigQueryDatasetSource_SelectedResource_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource
                    .SelectedResource.class,
                com.google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource
                    .SelectedResource.Builder.class);
      }

      private int resourceCase_ = 0;

      @SuppressWarnings("serial")
      private java.lang.Object resource_;

      public enum ResourceCase
          implements
              com.google.protobuf.Internal.EnumLite,
              com.google.protobuf.AbstractMessage.InternalOneOfEnum {
        TABLE(1),
        ROUTINE(2),
        RESOURCE_NOT_SET(0);
        private final int value;

        private ResourceCase(int value) {
          this.value = value;
        }

        /**
         * @param value The number of the enum to look for.
         * @return The enum associated with the given number.
         * @deprecated Use {@link #forNumber(int)} instead.
         */
        @java.lang.Deprecated
        public static ResourceCase valueOf(int value) {
          return forNumber(value);
        }

        public static ResourceCase forNumber(int value) {
          switch (value) {
            case 1:
              return TABLE;
            case 2:
              return ROUTINE;
            case 0:
              return RESOURCE_NOT_SET;
            default:
              return null;
          }
        }

        public int getNumber() {
          return this.value;
        }
      };

      public ResourceCase getResourceCase() {
        return ResourceCase.forNumber(resourceCase_);
      }

      public static final int TABLE_FIELD_NUMBER = 1;

      /**
       *
       *
       * <pre>
       * Optional. Format:
       * For table:
       * `projects/{projectId}/datasets/{datasetId}/tables/{tableId}`
       * Example:"projects/test_project/datasets/test_dataset/tables/test_table"
       * </pre>
       *
       * <code>
       * string table = 1 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return Whether the table field is set.
       */
      public boolean hasTable() {
        return resourceCase_ == 1;
      }

      /**
       *
       *
       * <pre>
       * Optional. Format:
       * For table:
       * `projects/{projectId}/datasets/{datasetId}/tables/{tableId}`
       * Example:"projects/test_project/datasets/test_dataset/tables/test_table"
       * </pre>
       *
       * <code>
       * string table = 1 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return The table.
       */
      public java.lang.String getTable() {
        java.lang.Object ref = "";
        if (resourceCase_ == 1) {
          ref = resource_;
        }
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (resourceCase_ == 1) {
            resource_ = s;
          }
          return s;
        }
      }

      /**
       *
       *
       * <pre>
       * Optional. Format:
       * For table:
       * `projects/{projectId}/datasets/{datasetId}/tables/{tableId}`
       * Example:"projects/test_project/datasets/test_dataset/tables/test_table"
       * </pre>
       *
       * <code>
       * string table = 1 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return The bytes for table.
       */
      public com.google.protobuf.ByteString getTableBytes() {
        java.lang.Object ref = "";
        if (resourceCase_ == 1) {
          ref = resource_;
        }
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          if (resourceCase_ == 1) {
            resource_ = b;
          }
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      public static final int ROUTINE_FIELD_NUMBER = 2;

      /**
       *
       *
       * <pre>
       * Optional. Format:
       * For routine:
       * `projects/{projectId}/datasets/{datasetId}/routines/{routineId}`
       * Example:"projects/test_project/datasets/test_dataset/routines/test_routine"
       * </pre>
       *
       * <code>
       * string routine = 2 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return Whether the routine field is set.
       */
      public boolean hasRoutine() {
        return resourceCase_ == 2;
      }

      /**
       *
       *
       * <pre>
       * Optional. Format:
       * For routine:
       * `projects/{projectId}/datasets/{datasetId}/routines/{routineId}`
       * Example:"projects/test_project/datasets/test_dataset/routines/test_routine"
       * </pre>
       *
       * <code>
       * string routine = 2 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return The routine.
       */
      public java.lang.String getRoutine() {
        java.lang.Object ref = "";
        if (resourceCase_ == 2) {
          ref = resource_;
        }
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (resourceCase_ == 2) {
            resource_ = s;
          }
          return s;
        }
      }

      /**
       *
       *
       * <pre>
       * Optional. Format:
       * For routine:
       * `projects/{projectId}/datasets/{datasetId}/routines/{routineId}`
       * Example:"projects/test_project/datasets/test_dataset/routines/test_routine"
       * </pre>
       *
       * <code>
       * string routine = 2 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return The bytes for routine.
       */
      public com.google.protobuf.ByteString getRoutineBytes() {
        java.lang.Object ref = "";
        if (resourceCase_ == 2) {
          ref = resource_;
        }
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          if (resourceCase_ == 2) {
            resource_ = b;
          }
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (resourceCase_ == 1) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 1, resource_);
        }
        if (resourceCase_ == 2) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 2, resource_);
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (resourceCase_ == 1) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, resource_);
        }
        if (resourceCase_ == 2) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, resource_);
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj
            instanceof
            com.google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource
                .SelectedResource)) {
          return super.equals(obj);
        }
        com.google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource.SelectedResource
            other =
                (com.google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource
                        .SelectedResource)
                    obj;

        if (!getResourceCase().equals(other.getResourceCase())) return false;
        switch (resourceCase_) {
          case 1:
            if (!getTable().equals(other.getTable())) return false;
            break;
          case 2:
            if (!getRoutine().equals(other.getRoutine())) return false;
            break;
          case 0:
          default:
        }
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        switch (resourceCase_) {
          case 1:
            hash = (37 * hash) + TABLE_FIELD_NUMBER;
            hash = (53 * hash) + getTable().hashCode();
            break;
          case 2:
            hash = (37 * hash) + ROUTINE_FIELD_NUMBER;
            hash = (53 * hash) + getRoutine().hashCode();
            break;
          case 0:
          default:
        }
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource
              .SelectedResource
          parseFrom(java.nio.ByteBuffer data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource
              .SelectedResource
          parseFrom(
              java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource
              .SelectedResource
          parseFrom(com.google.protobuf.ByteString data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource
              .SelectedResource
          parseFrom(
              com.google.protobuf.ByteString data,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource
              .SelectedResource
          parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource
              .SelectedResource
          parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource
              .SelectedResource
          parseFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource
              .SelectedResource
          parseFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource
              .SelectedResource
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource
              .SelectedResource
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource
              .SelectedResource
          parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource
              .SelectedResource
          parseFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource.SelectedResource
              prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }

      /**
       *
       *
       * <pre>
       * Resource in this dataset that is selectively shared.
       * </pre>
       *
       * Protobuf type {@code
       * google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource.SelectedResource}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource.SelectedResource)
          com.google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource
              .SelectedResourceOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.bigquery.analyticshub.v1.AnalyticsHubProto
              .internal_static_google_cloud_bigquery_analyticshub_v1_Listing_BigQueryDatasetSource_SelectedResource_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.bigquery.analyticshub.v1.AnalyticsHubProto
              .internal_static_google_cloud_bigquery_analyticshub_v1_Listing_BigQueryDatasetSource_SelectedResource_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource
                      .SelectedResource.class,
                  com.google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource
                      .SelectedResource.Builder.class);
        }

        // Construct using
        // com.google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource.SelectedResource.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          resourceCase_ = 0;
          resource_ = null;
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.bigquery.analyticshub.v1.AnalyticsHubProto
              .internal_static_google_cloud_bigquery_analyticshub_v1_Listing_BigQueryDatasetSource_SelectedResource_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource
                .SelectedResource
            getDefaultInstanceForType() {
          return com.google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource
              .SelectedResource.getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource
                .SelectedResource
            build() {
          com.google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource.SelectedResource
              result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource
                .SelectedResource
            buildPartial() {
          com.google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource.SelectedResource
              result =
                  new com.google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource
                      .SelectedResource(this);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          buildPartialOneofs(result);
          onBuilt();
          return result;
        }

        private void buildPartial0(
            com.google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource.SelectedResource
                result) {
          int from_bitField0_ = bitField0_;
        }

        private void buildPartialOneofs(
            com.google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource.SelectedResource
                result) {
          result.resourceCase_ = resourceCase_;
          result.resource_ = this.resource_;
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other
              instanceof
              com.google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource
                  .SelectedResource) {
            return mergeFrom(
                (com.google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource
                        .SelectedResource)
                    other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource.SelectedResource
                other) {
          if (other
              == com.google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource
                  .SelectedResource.getDefaultInstance()) return this;
          switch (other.getResourceCase()) {
            case TABLE:
              {
                resourceCase_ = 1;
                resource_ = other.resource_;
                onChanged();
                break;
              }
            case ROUTINE:
              {
                resourceCase_ = 2;
                resource_ = other.resource_;
                onChanged();
                break;
              }
            case RESOURCE_NOT_SET:
              {
                break;
              }
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 10:
                  {
                    java.lang.String s = input.readStringRequireUtf8();
                    resourceCase_ = 1;
                    resource_ = s;
                    break;
                  } // case 10
                case 18:
                  {
                    java.lang.String s = input.readStringRequireUtf8();
                    resourceCase_ = 2;
                    resource_ = s;
                    break;
                  } // case 18
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int resourceCase_ = 0;
        private java.lang.Object resource_;

        public ResourceCase getResourceCase() {
          return ResourceCase.forNumber(resourceCase_);
        }

        public Builder clearResource() {
          resourceCase_ = 0;
          resource_ = null;
          onChanged();
          return this;
        }

        private int bitField0_;

        /**
         *
         *
         * <pre>
         * Optional. Format:
         * For table:
         * `projects/{projectId}/datasets/{datasetId}/tables/{tableId}`
         * Example:"projects/test_project/datasets/test_dataset/tables/test_table"
         * </pre>
         *
         * <code>
         * string table = 1 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
         * </code>
         *
         * @return Whether the table field is set.
         */
        @java.lang.Override
        public boolean hasTable() {
          return resourceCase_ == 1;
        }

        /**
         *
         *
         * <pre>
         * Optional. Format:
         * For table:
         * `projects/{projectId}/datasets/{datasetId}/tables/{tableId}`
         * Example:"projects/test_project/datasets/test_dataset/tables/test_table"
         * </pre>
         *
         * <code>
         * string table = 1 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
         * </code>
         *
         * @return The table.
         */
        @java.lang.Override
        public java.lang.String getTable() {
          java.lang.Object ref = "";
          if (resourceCase_ == 1) {
            ref = resource_;
          }
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            if (resourceCase_ == 1) {
              resource_ = s;
            }
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }

        /**
         *
         *
         * <pre>
         * Optional. Format:
         * For table:
         * `projects/{projectId}/datasets/{datasetId}/tables/{tableId}`
         * Example:"projects/test_project/datasets/test_dataset/tables/test_table"
         * </pre>
         *
         * <code>
         * string table = 1 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
         * </code>
         *
         * @return The bytes for table.
         */
        @java.lang.Override
        public com.google.protobuf.ByteString getTableBytes() {
          java.lang.Object ref = "";
          if (resourceCase_ == 1) {
            ref = resource_;
          }
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            if (resourceCase_ == 1) {
              resource_ = b;
            }
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }

        /**
         *
         *
         * <pre>
         * Optional. Format:
         * For table:
         * `projects/{projectId}/datasets/{datasetId}/tables/{tableId}`
         * Example:"projects/test_project/datasets/test_dataset/tables/test_table"
         * </pre>
         *
         * <code>
         * string table = 1 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
         * </code>
         *
         * @param value The table to set.
         * @return This builder for chaining.
         */
        public Builder setTable(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          resourceCase_ = 1;
          resource_ = value;
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * Optional. Format:
         * For table:
         * `projects/{projectId}/datasets/{datasetId}/tables/{tableId}`
         * Example:"projects/test_project/datasets/test_dataset/tables/test_table"
         * </pre>
         *
         * <code>
         * string table = 1 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
         * </code>
         *
         * @return This builder for chaining.
         */
        public Builder clearTable() {
          if (resourceCase_ == 1) {
            resourceCase_ = 0;
            resource_ = null;
            onChanged();
          }
          return this;
        }

        /**
         *
         *
         * <pre>
         * Optional. Format:
         * For table:
         * `projects/{projectId}/datasets/{datasetId}/tables/{tableId}`
         * Example:"projects/test_project/datasets/test_dataset/tables/test_table"
         * </pre>
         *
         * <code>
         * string table = 1 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
         * </code>
         *
         * @param value The bytes for table to set.
         * @return This builder for chaining.
         */
        public Builder setTableBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          resourceCase_ = 1;
          resource_ = value;
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * Optional. Format:
         * For routine:
         * `projects/{projectId}/datasets/{datasetId}/routines/{routineId}`
         * Example:"projects/test_project/datasets/test_dataset/routines/test_routine"
         * </pre>
         *
         * <code>
         * string routine = 2 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
         * </code>
         *
         * @return Whether the routine field is set.
         */
        @java.lang.Override
        public boolean hasRoutine() {
          return resourceCase_ == 2;
        }

        /**
         *
         *
         * <pre>
         * Optional. Format:
         * For routine:
         * `projects/{projectId}/datasets/{datasetId}/routines/{routineId}`
         * Example:"projects/test_project/datasets/test_dataset/routines/test_routine"
         * </pre>
         *
         * <code>
         * string routine = 2 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
         * </code>
         *
         * @return The routine.
         */
        @java.lang.Override
        public java.lang.String getRoutine() {
          java.lang.Object ref = "";
          if (resourceCase_ == 2) {
            ref = resource_;
          }
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            if (resourceCase_ == 2) {
              resource_ = s;
            }
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }

        /**
         *
         *
         * <pre>
         * Optional. Format:
         * For routine:
         * `projects/{projectId}/datasets/{datasetId}/routines/{routineId}`
         * Example:"projects/test_project/datasets/test_dataset/routines/test_routine"
         * </pre>
         *
         * <code>
         * string routine = 2 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
         * </code>
         *
         * @return The bytes for routine.
         */
        @java.lang.Override
        public com.google.protobuf.ByteString getRoutineBytes() {
          java.lang.Object ref = "";
          if (resourceCase_ == 2) {
            ref = resource_;
          }
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            if (resourceCase_ == 2) {
              resource_ = b;
            }
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }

        /**
         *
         *
         * <pre>
         * Optional. Format:
         * For routine:
         * `projects/{projectId}/datasets/{datasetId}/routines/{routineId}`
         * Example:"projects/test_project/datasets/test_dataset/routines/test_routine"
         * </pre>
         *
         * <code>
         * string routine = 2 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
         * </code>
         *
         * @param value The routine to set.
         * @return This builder for chaining.
         */
        public Builder setRoutine(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          resourceCase_ = 2;
          resource_ = value;
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * Optional. Format:
         * For routine:
         * `projects/{projectId}/datasets/{datasetId}/routines/{routineId}`
         * Example:"projects/test_project/datasets/test_dataset/routines/test_routine"
         * </pre>
         *
         * <code>
         * string routine = 2 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
         * </code>
         *
         * @return This builder for chaining.
         */
        public Builder clearRoutine() {
          if (resourceCase_ == 2) {
            resourceCase_ = 0;
            resource_ = null;
            onChanged();
          }
          return this;
        }

        /**
         *
         *
         * <pre>
         * Optional. Format:
         * For routine:
         * `projects/{projectId}/datasets/{datasetId}/routines/{routineId}`
         * Example:"projects/test_project/datasets/test_dataset/routines/test_routine"
         * </pre>
         *
         * <code>
         * string routine = 2 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
         * </code>
         *
         * @param value The bytes for routine to set.
         * @return This builder for chaining.
         */
        public Builder setRoutineBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          resourceCase_ = 2;
          resource_ = value;
          onChanged();
          return this;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource.SelectedResource)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource.SelectedResource)
      private static final com.google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource
              .SelectedResource
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE =
            new com.google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource
                .SelectedResource();
      }

      public static com.google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource
              .SelectedResource
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<SelectedResource> PARSER =
          new com.google.protobuf.AbstractParser<SelectedResource>() {
            @java.lang.Override
            public SelectedResource parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<SelectedResource> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<SelectedResource> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource
              .SelectedResource
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    public interface RestrictedExportPolicyOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource.RestrictedExportPolicy)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * Optional. If true, enable restricted export.
       * </pre>
       *
       * <code>.google.protobuf.BoolValue enabled = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return Whether the enabled field is set.
       */
      boolean hasEnabled();

      /**
       *
       *
       * <pre>
       * Optional. If true, enable restricted export.
       * </pre>
       *
       * <code>.google.protobuf.BoolValue enabled = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The enabled.
       */
      com.google.protobuf.BoolValue getEnabled();

      /**
       *
       *
       * <pre>
       * Optional. If true, enable restricted export.
       * </pre>
       *
       * <code>.google.protobuf.BoolValue enabled = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      com.google.protobuf.BoolValueOrBuilder getEnabledOrBuilder();

      /**
       *
       *
       * <pre>
       * Optional. If true, restrict direct table access (read
       * api/tabledata.list) on linked table.
       * </pre>
       *
       * <code>
       * .google.protobuf.BoolValue restrict_direct_table_access = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return Whether the restrictDirectTableAccess field is set.
       */
      boolean hasRestrictDirectTableAccess();

      /**
       *
       *
       * <pre>
       * Optional. If true, restrict direct table access (read
       * api/tabledata.list) on linked table.
       * </pre>
       *
       * <code>
       * .google.protobuf.BoolValue restrict_direct_table_access = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The restrictDirectTableAccess.
       */
      com.google.protobuf.BoolValue getRestrictDirectTableAccess();

      /**
       *
       *
       * <pre>
       * Optional. If true, restrict direct table access (read
       * api/tabledata.list) on linked table.
       * </pre>
       *
       * <code>
       * .google.protobuf.BoolValue restrict_direct_table_access = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      com.google.protobuf.BoolValueOrBuilder getRestrictDirectTableAccessOrBuilder();

      /**
       *
       *
       * <pre>
       * Optional. If true, restrict export of query result derived from
       * restricted linked dataset table.
       * </pre>
       *
       * <code>
       * .google.protobuf.BoolValue restrict_query_result = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return Whether the restrictQueryResult field is set.
       */
      boolean hasRestrictQueryResult();

      /**
       *
       *
       * <pre>
       * Optional. If true, restrict export of query result derived from
       * restricted linked dataset table.
       * </pre>
       *
       * <code>
       * .google.protobuf.BoolValue restrict_query_result = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The restrictQueryResult.
       */
      com.google.protobuf.BoolValue getRestrictQueryResult();

      /**
       *
       *
       * <pre>
       * Optional. If true, restrict export of query result derived from
       * restricted linked dataset table.
       * </pre>
       *
       * <code>
       * .google.protobuf.BoolValue restrict_query_result = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      com.google.protobuf.BoolValueOrBuilder getRestrictQueryResultOrBuilder();
    }

    /**
     *
     *
     * <pre>
     * Restricted export policy used to configure restricted export on linked
     * dataset.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource.RestrictedExportPolicy}
     */
    public static final class RestrictedExportPolicy extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource.RestrictedExportPolicy)
        RestrictedExportPolicyOrBuilder {
      private static final long serialVersionUID = 0L;

      // Use RestrictedExportPolicy.newBuilder() to construct.
      private RestrictedExportPolicy(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private RestrictedExportPolicy() {}

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new RestrictedExportPolicy();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.bigquery.analyticshub.v1.AnalyticsHubProto
            .internal_static_google_cloud_bigquery_analyticshub_v1_Listing_BigQueryDatasetSource_RestrictedExportPolicy_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.bigquery.analyticshub.v1.AnalyticsHubProto
            .internal_static_google_cloud_bigquery_analyticshub_v1_Listing_BigQueryDatasetSource_RestrictedExportPolicy_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource
                    .RestrictedExportPolicy.class,
                com.google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource
                    .RestrictedExportPolicy.Builder.class);
      }

      private int bitField0_;
      public static final int ENABLED_FIELD_NUMBER = 1;
      private com.google.protobuf.BoolValue enabled_;

      /**
       *
       *
       * <pre>
       * Optional. If true, enable restricted export.
       * </pre>
       *
       * <code>.google.protobuf.BoolValue enabled = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return Whether the enabled field is set.
       */
      @java.lang.Override
      public boolean hasEnabled() {
        return ((bitField0_ & 0x00000001) != 0);
      }

      /**
       *
       *
       * <pre>
       * Optional. If true, enable restricted export.
       * </pre>
       *
       * <code>.google.protobuf.BoolValue enabled = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The enabled.
       */
      @java.lang.Override
      public com.google.protobuf.BoolValue getEnabled() {
        return enabled_ == null ? com.google.protobuf.BoolValue.getDefaultInstance() : enabled_;
      }

      /**
       *
       *
       * <pre>
       * Optional. If true, enable restricted export.
       * </pre>
       *
       * <code>.google.protobuf.BoolValue enabled = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      @java.lang.Override
      public com.google.protobuf.BoolValueOrBuilder getEnabledOrBuilder() {
        return enabled_ == null ? com.google.protobuf.BoolValue.getDefaultInstance() : enabled_;
      }

      public static final int RESTRICT_DIRECT_TABLE_ACCESS_FIELD_NUMBER = 2;
      private com.google.protobuf.BoolValue restrictDirectTableAccess_;

      /**
       *
       *
       * <pre>
       * Optional. If true, restrict direct table access (read
       * api/tabledata.list) on linked table.
       * </pre>
       *
       * <code>
       * .google.protobuf.BoolValue restrict_direct_table_access = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return Whether the restrictDirectTableAccess field is set.
       */
      @java.lang.Override
      public boolean hasRestrictDirectTableAccess() {
        return ((bitField0_ & 0x00000002) != 0);
      }

      /**
       *
       *
       * <pre>
       * Optional. If true, restrict direct table access (read
       * api/tabledata.list) on linked table.
       * </pre>
       *
       * <code>
       * .google.protobuf.BoolValue restrict_direct_table_access = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The restrictDirectTableAccess.
       */
      @java.lang.Override
      public com.google.protobuf.BoolValue getRestrictDirectTableAccess() {
        return restrictDirectTableAccess_ == null
            ? com.google.protobuf.BoolValue.getDefaultInstance()
            : restrictDirectTableAccess_;
      }

      /**
       *
       *
       * <pre>
       * Optional. If true, restrict direct table access (read
       * api/tabledata.list) on linked table.
       * </pre>
       *
       * <code>
       * .google.protobuf.BoolValue restrict_direct_table_access = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      @java.lang.Override
      public com.google.protobuf.BoolValueOrBuilder getRestrictDirectTableAccessOrBuilder() {
        return restrictDirectTableAccess_ == null
            ? com.google.protobuf.BoolValue.getDefaultInstance()
            : restrictDirectTableAccess_;
      }

      public static final int RESTRICT_QUERY_RESULT_FIELD_NUMBER = 3;
      private com.google.protobuf.BoolValue restrictQueryResult_;

      /**
       *
       *
       * <pre>
       * Optional. If true, restrict export of query result derived from
       * restricted linked dataset table.
       * </pre>
       *
       * <code>
       * .google.protobuf.BoolValue restrict_query_result = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return Whether the restrictQueryResult field is set.
       */
      @java.lang.Override
      public boolean hasRestrictQueryResult() {
        return ((bitField0_ & 0x00000004) != 0);
      }

      /**
       *
       *
       * <pre>
       * Optional. If true, restrict export of query result derived from
       * restricted linked dataset table.
       * </pre>
       *
       * <code>
       * .google.protobuf.BoolValue restrict_query_result = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The restrictQueryResult.
       */
      @java.lang.Override
      public com.google.protobuf.BoolValue getRestrictQueryResult() {
        return restrictQueryResult_ == null
            ? com.google.protobuf.BoolValue.getDefaultInstance()
            : restrictQueryResult_;
      }

      /**
       *
       *
       * <pre>
       * Optional. If true, restrict export of query result derived from
       * restricted linked dataset table.
       * </pre>
       *
       * <code>
       * .google.protobuf.BoolValue restrict_query_result = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      @java.lang.Override
      public com.google.protobuf.BoolValueOrBuilder getRestrictQueryResultOrBuilder() {
        return restrictQueryResult_ == null
            ? com.google.protobuf.BoolValue.getDefaultInstance()
            : restrictQueryResult_;
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (((bitField0_ & 0x00000001) != 0)) {
          output.writeMessage(1, getEnabled());
        }
        if (((bitField0_ & 0x00000002) != 0)) {
          output.writeMessage(2, getRestrictDirectTableAccess());
        }
        if (((bitField0_ & 0x00000004) != 0)) {
          output.writeMessage(3, getRestrictQueryResult());
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (((bitField0_ & 0x00000001) != 0)) {
          size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getEnabled());
        }
        if (((bitField0_ & 0x00000002) != 0)) {
          size +=
              com.google.protobuf.CodedOutputStream.computeMessageSize(
                  2, getRestrictDirectTableAccess());
        }
        if (((bitField0_ & 0x00000004) != 0)) {
          size +=
              com.google.protobuf.CodedOutputStream.computeMessageSize(3, getRestrictQueryResult());
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj
            instanceof
            com.google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource
                .RestrictedExportPolicy)) {
          return super.equals(obj);
        }
        com.google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource
                .RestrictedExportPolicy
            other =
                (com.google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource
                        .RestrictedExportPolicy)
                    obj;

        if (hasEnabled() != other.hasEnabled()) return false;
        if (hasEnabled()) {
          if (!getEnabled().equals(other.getEnabled())) return false;
        }
        if (hasRestrictDirectTableAccess() != other.hasRestrictDirectTableAccess()) return false;
        if (hasRestrictDirectTableAccess()) {
          if (!getRestrictDirectTableAccess().equals(other.getRestrictDirectTableAccess()))
            return false;
        }
        if (hasRestrictQueryResult() != other.hasRestrictQueryResult()) return false;
        if (hasRestrictQueryResult()) {
          if (!getRestrictQueryResult().equals(other.getRestrictQueryResult())) return false;
        }
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        if (hasEnabled()) {
          hash = (37 * hash) + ENABLED_FIELD_NUMBER;
          hash = (53 * hash) + getEnabled().hashCode();
        }
        if (hasRestrictDirectTableAccess()) {
          hash = (37 * hash) + RESTRICT_DIRECT_TABLE_ACCESS_FIELD_NUMBER;
          hash = (53 * hash) + getRestrictDirectTableAccess().hashCode();
        }
        if (hasRestrictQueryResult()) {
          hash = (37 * hash) + RESTRICT_QUERY_RESULT_FIELD_NUMBER;
          hash = (53 * hash) + getRestrictQueryResult().hashCode();
        }
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource
              .RestrictedExportPolicy
          parseFrom(java.nio.ByteBuffer data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource
              .RestrictedExportPolicy
          parseFrom(
              java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource
              .RestrictedExportPolicy
          parseFrom(com.google.protobuf.ByteString data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource
              .RestrictedExportPolicy
          parseFrom(
              com.google.protobuf.ByteString data,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource
              .RestrictedExportPolicy
          parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource
              .RestrictedExportPolicy
          parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource
              .RestrictedExportPolicy
          parseFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource
              .RestrictedExportPolicy
          parseFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource
              .RestrictedExportPolicy
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource
              .RestrictedExportPolicy
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource
              .RestrictedExportPolicy
          parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource
              .RestrictedExportPolicy
          parseFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource
                  .RestrictedExportPolicy
              prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }

      /**
       *
       *
       * <pre>
       * Restricted export policy used to configure restricted export on linked
       * dataset.
       * </pre>
       *
       * Protobuf type {@code
       * google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource.RestrictedExportPolicy}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource.RestrictedExportPolicy)
          com.google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource
              .RestrictedExportPolicyOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.bigquery.analyticshub.v1.AnalyticsHubProto
              .internal_static_google_cloud_bigquery_analyticshub_v1_Listing_BigQueryDatasetSource_RestrictedExportPolicy_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.bigquery.analyticshub.v1.AnalyticsHubProto
              .internal_static_google_cloud_bigquery_analyticshub_v1_Listing_BigQueryDatasetSource_RestrictedExportPolicy_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource
                      .RestrictedExportPolicy.class,
                  com.google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource
                      .RestrictedExportPolicy.Builder.class);
        }

        // Construct using
        // com.google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource.RestrictedExportPolicy.newBuilder()
        private Builder() {
          maybeForceBuilderInitialization();
        }

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
          maybeForceBuilderInitialization();
        }

        private void maybeForceBuilderInitialization() {
          if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
            getEnabledFieldBuilder();
            getRestrictDirectTableAccessFieldBuilder();
            getRestrictQueryResultFieldBuilder();
          }
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          enabled_ = null;
          if (enabledBuilder_ != null) {
            enabledBuilder_.dispose();
            enabledBuilder_ = null;
          }
          restrictDirectTableAccess_ = null;
          if (restrictDirectTableAccessBuilder_ != null) {
            restrictDirectTableAccessBuilder_.dispose();
            restrictDirectTableAccessBuilder_ = null;
          }
          restrictQueryResult_ = null;
          if (restrictQueryResultBuilder_ != null) {
            restrictQueryResultBuilder_.dispose();
            restrictQueryResultBuilder_ = null;
          }
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.bigquery.analyticshub.v1.AnalyticsHubProto
              .internal_static_google_cloud_bigquery_analyticshub_v1_Listing_BigQueryDatasetSource_RestrictedExportPolicy_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource
                .RestrictedExportPolicy
            getDefaultInstanceForType() {
          return com.google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource
              .RestrictedExportPolicy.getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource
                .RestrictedExportPolicy
            build() {
          com.google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource
                  .RestrictedExportPolicy
              result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource
                .RestrictedExportPolicy
            buildPartial() {
          com.google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource
                  .RestrictedExportPolicy
              result =
                  new com.google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource
                      .RestrictedExportPolicy(this);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          onBuilt();
          return result;
        }

        private void buildPartial0(
            com.google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource
                    .RestrictedExportPolicy
                result) {
          int from_bitField0_ = bitField0_;
          int to_bitField0_ = 0;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            result.enabled_ = enabledBuilder_ == null ? enabled_ : enabledBuilder_.build();
            to_bitField0_ |= 0x00000001;
          }
          if (((from_bitField0_ & 0x00000002) != 0)) {
            result.restrictDirectTableAccess_ =
                restrictDirectTableAccessBuilder_ == null
                    ? restrictDirectTableAccess_
                    : restrictDirectTableAccessBuilder_.build();
            to_bitField0_ |= 0x00000002;
          }
          if (((from_bitField0_ & 0x00000004) != 0)) {
            result.restrictQueryResult_ =
                restrictQueryResultBuilder_ == null
                    ? restrictQueryResult_
                    : restrictQueryResultBuilder_.build();
            to_bitField0_ |= 0x00000004;
          }
          result.bitField0_ |= to_bitField0_;
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other
              instanceof
              com.google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource
                  .RestrictedExportPolicy) {
            return mergeFrom(
                (com.google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource
                        .RestrictedExportPolicy)
                    other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource
                    .RestrictedExportPolicy
                other) {
          if (other
              == com.google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource
                  .RestrictedExportPolicy.getDefaultInstance()) return this;
          if (other.hasEnabled()) {
            mergeEnabled(other.getEnabled());
          }
          if (other.hasRestrictDirectTableAccess()) {
            mergeRestrictDirectTableAccess(other.getRestrictDirectTableAccess());
          }
          if (other.hasRestrictQueryResult()) {
            mergeRestrictQueryResult(other.getRestrictQueryResult());
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 10:
                  {
                    input.readMessage(getEnabledFieldBuilder().getBuilder(), extensionRegistry);
                    bitField0_ |= 0x00000001;
                    break;
                  } // case 10
                case 18:
                  {
                    input.readMessage(
                        getRestrictDirectTableAccessFieldBuilder().getBuilder(), extensionRegistry);
                    bitField0_ |= 0x00000002;
                    break;
                  } // case 18
                case 26:
                  {
                    input.readMessage(
                        getRestrictQueryResultFieldBuilder().getBuilder(), extensionRegistry);
                    bitField0_ |= 0x00000004;
                    break;
                  } // case 26
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int bitField0_;

        private com.google.protobuf.BoolValue enabled_;
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.BoolValue,
                com.google.protobuf.BoolValue.Builder,
                com.google.protobuf.BoolValueOrBuilder>
            enabledBuilder_;

        /**
         *
         *
         * <pre>
         * Optional. If true, enable restricted export.
         * </pre>
         *
         * <code>.google.protobuf.BoolValue enabled = 1 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         *
         * @return Whether the enabled field is set.
         */
        public boolean hasEnabled() {
          return ((bitField0_ & 0x00000001) != 0);
        }

        /**
         *
         *
         * <pre>
         * Optional. If true, enable restricted export.
         * </pre>
         *
         * <code>.google.protobuf.BoolValue enabled = 1 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         *
         * @return The enabled.
         */
        public com.google.protobuf.BoolValue getEnabled() {
          if (enabledBuilder_ == null) {
            return enabled_ == null ? com.google.protobuf.BoolValue.getDefaultInstance() : enabled_;
          } else {
            return enabledBuilder_.getMessage();
          }
        }

        /**
         *
         *
         * <pre>
         * Optional. If true, enable restricted export.
         * </pre>
         *
         * <code>.google.protobuf.BoolValue enabled = 1 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public Builder setEnabled(com.google.protobuf.BoolValue value) {
          if (enabledBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            enabled_ = value;
          } else {
            enabledBuilder_.setMessage(value);
          }
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * Optional. If true, enable restricted export.
         * </pre>
         *
         * <code>.google.protobuf.BoolValue enabled = 1 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public Builder setEnabled(com.google.protobuf.BoolValue.Builder builderForValue) {
          if (enabledBuilder_ == null) {
            enabled_ = builderForValue.build();
          } else {
            enabledBuilder_.setMessage(builderForValue.build());
          }
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * Optional. If true, enable restricted export.
         * </pre>
         *
         * <code>.google.protobuf.BoolValue enabled = 1 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public Builder mergeEnabled(com.google.protobuf.BoolValue value) {
          if (enabledBuilder_ == null) {
            if (((bitField0_ & 0x00000001) != 0)
                && enabled_ != null
                && enabled_ != com.google.protobuf.BoolValue.getDefaultInstance()) {
              getEnabledBuilder().mergeFrom(value);
            } else {
              enabled_ = value;
            }
          } else {
            enabledBuilder_.mergeFrom(value);
          }
          if (enabled_ != null) {
            bitField0_ |= 0x00000001;
            onChanged();
          }
          return this;
        }

        /**
         *
         *
         * <pre>
         * Optional. If true, enable restricted export.
         * </pre>
         *
         * <code>.google.protobuf.BoolValue enabled = 1 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public Builder clearEnabled() {
          bitField0_ = (bitField0_ & ~0x00000001);
          enabled_ = null;
          if (enabledBuilder_ != null) {
            enabledBuilder_.dispose();
            enabledBuilder_ = null;
          }
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * Optional. If true, enable restricted export.
         * </pre>
         *
         * <code>.google.protobuf.BoolValue enabled = 1 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public com.google.protobuf.BoolValue.Builder getEnabledBuilder() {
          bitField0_ |= 0x00000001;
          onChanged();
          return getEnabledFieldBuilder().getBuilder();
        }

        /**
         *
         *
         * <pre>
         * Optional. If true, enable restricted export.
         * </pre>
         *
         * <code>.google.protobuf.BoolValue enabled = 1 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public com.google.protobuf.BoolValueOrBuilder getEnabledOrBuilder() {
          if (enabledBuilder_ != null) {
            return enabledBuilder_.getMessageOrBuilder();
          } else {
            return enabled_ == null ? com.google.protobuf.BoolValue.getDefaultInstance() : enabled_;
          }
        }

        /**
         *
         *
         * <pre>
         * Optional. If true, enable restricted export.
         * </pre>
         *
         * <code>.google.protobuf.BoolValue enabled = 1 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.BoolValue,
                com.google.protobuf.BoolValue.Builder,
                com.google.protobuf.BoolValueOrBuilder>
            getEnabledFieldBuilder() {
          if (enabledBuilder_ == null) {
            enabledBuilder_ =
                new com.google.protobuf.SingleFieldBuilderV3<
                    com.google.protobuf.BoolValue,
                    com.google.protobuf.BoolValue.Builder,
                    com.google.protobuf.BoolValueOrBuilder>(
                    getEnabled(), getParentForChildren(), isClean());
            enabled_ = null;
          }
          return enabledBuilder_;
        }

        private com.google.protobuf.BoolValue restrictDirectTableAccess_;
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.BoolValue,
                com.google.protobuf.BoolValue.Builder,
                com.google.protobuf.BoolValueOrBuilder>
            restrictDirectTableAccessBuilder_;

        /**
         *
         *
         * <pre>
         * Optional. If true, restrict direct table access (read
         * api/tabledata.list) on linked table.
         * </pre>
         *
         * <code>
         * .google.protobuf.BoolValue restrict_direct_table_access = 2 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         *
         * @return Whether the restrictDirectTableAccess field is set.
         */
        public boolean hasRestrictDirectTableAccess() {
          return ((bitField0_ & 0x00000002) != 0);
        }

        /**
         *
         *
         * <pre>
         * Optional. If true, restrict direct table access (read
         * api/tabledata.list) on linked table.
         * </pre>
         *
         * <code>
         * .google.protobuf.BoolValue restrict_direct_table_access = 2 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         *
         * @return The restrictDirectTableAccess.
         */
        public com.google.protobuf.BoolValue getRestrictDirectTableAccess() {
          if (restrictDirectTableAccessBuilder_ == null) {
            return restrictDirectTableAccess_ == null
                ? com.google.protobuf.BoolValue.getDefaultInstance()
                : restrictDirectTableAccess_;
          } else {
            return restrictDirectTableAccessBuilder_.getMessage();
          }
        }

        /**
         *
         *
         * <pre>
         * Optional. If true, restrict direct table access (read
         * api/tabledata.list) on linked table.
         * </pre>
         *
         * <code>
         * .google.protobuf.BoolValue restrict_direct_table_access = 2 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public Builder setRestrictDirectTableAccess(com.google.protobuf.BoolValue value) {
          if (restrictDirectTableAccessBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            restrictDirectTableAccess_ = value;
          } else {
            restrictDirectTableAccessBuilder_.setMessage(value);
          }
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * Optional. If true, restrict direct table access (read
         * api/tabledata.list) on linked table.
         * </pre>
         *
         * <code>
         * .google.protobuf.BoolValue restrict_direct_table_access = 2 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public Builder setRestrictDirectTableAccess(
            com.google.protobuf.BoolValue.Builder builderForValue) {
          if (restrictDirectTableAccessBuilder_ == null) {
            restrictDirectTableAccess_ = builderForValue.build();
          } else {
            restrictDirectTableAccessBuilder_.setMessage(builderForValue.build());
          }
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * Optional. If true, restrict direct table access (read
         * api/tabledata.list) on linked table.
         * </pre>
         *
         * <code>
         * .google.protobuf.BoolValue restrict_direct_table_access = 2 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public Builder mergeRestrictDirectTableAccess(com.google.protobuf.BoolValue value) {
          if (restrictDirectTableAccessBuilder_ == null) {
            if (((bitField0_ & 0x00000002) != 0)
                && restrictDirectTableAccess_ != null
                && restrictDirectTableAccess_
                    != com.google.protobuf.BoolValue.getDefaultInstance()) {
              getRestrictDirectTableAccessBuilder().mergeFrom(value);
            } else {
              restrictDirectTableAccess_ = value;
            }
          } else {
            restrictDirectTableAccessBuilder_.mergeFrom(value);
          }
          if (restrictDirectTableAccess_ != null) {
            bitField0_ |= 0x00000002;
            onChanged();
          }
          return this;
        }

        /**
         *
         *
         * <pre>
         * Optional. If true, restrict direct table access (read
         * api/tabledata.list) on linked table.
         * </pre>
         *
         * <code>
         * .google.protobuf.BoolValue restrict_direct_table_access = 2 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public Builder clearRestrictDirectTableAccess() {
          bitField0_ = (bitField0_ & ~0x00000002);
          restrictDirectTableAccess_ = null;
          if (restrictDirectTableAccessBuilder_ != null) {
            restrictDirectTableAccessBuilder_.dispose();
            restrictDirectTableAccessBuilder_ = null;
          }
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * Optional. If true, restrict direct table access (read
         * api/tabledata.list) on linked table.
         * </pre>
         *
         * <code>
         * .google.protobuf.BoolValue restrict_direct_table_access = 2 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public com.google.protobuf.BoolValue.Builder getRestrictDirectTableAccessBuilder() {
          bitField0_ |= 0x00000002;
          onChanged();
          return getRestrictDirectTableAccessFieldBuilder().getBuilder();
        }

        /**
         *
         *
         * <pre>
         * Optional. If true, restrict direct table access (read
         * api/tabledata.list) on linked table.
         * </pre>
         *
         * <code>
         * .google.protobuf.BoolValue restrict_direct_table_access = 2 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public com.google.protobuf.BoolValueOrBuilder getRestrictDirectTableAccessOrBuilder() {
          if (restrictDirectTableAccessBuilder_ != null) {
            return restrictDirectTableAccessBuilder_.getMessageOrBuilder();
          } else {
            return restrictDirectTableAccess_ == null
                ? com.google.protobuf.BoolValue.getDefaultInstance()
                : restrictDirectTableAccess_;
          }
        }

        /**
         *
         *
         * <pre>
         * Optional. If true, restrict direct table access (read
         * api/tabledata.list) on linked table.
         * </pre>
         *
         * <code>
         * .google.protobuf.BoolValue restrict_direct_table_access = 2 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.BoolValue,
                com.google.protobuf.BoolValue.Builder,
                com.google.protobuf.BoolValueOrBuilder>
            getRestrictDirectTableAccessFieldBuilder() {
          if (restrictDirectTableAccessBuilder_ == null) {
            restrictDirectTableAccessBuilder_ =
                new com.google.protobuf.SingleFieldBuilderV3<
                    com.google.protobuf.BoolValue,
                    com.google.protobuf.BoolValue.Builder,
                    com.google.protobuf.BoolValueOrBuilder>(
                    getRestrictDirectTableAccess(), getParentForChildren(), isClean());
            restrictDirectTableAccess_ = null;
          }
          return restrictDirectTableAccessBuilder_;
        }

        private com.google.protobuf.BoolValue restrictQueryResult_;
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.BoolValue,
                com.google.protobuf.BoolValue.Builder,
                com.google.protobuf.BoolValueOrBuilder>
            restrictQueryResultBuilder_;

        /**
         *
         *
         * <pre>
         * Optional. If true, restrict export of query result derived from
         * restricted linked dataset table.
         * </pre>
         *
         * <code>
         * .google.protobuf.BoolValue restrict_query_result = 3 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         *
         * @return Whether the restrictQueryResult field is set.
         */
        public boolean hasRestrictQueryResult() {
          return ((bitField0_ & 0x00000004) != 0);
        }

        /**
         *
         *
         * <pre>
         * Optional. If true, restrict export of query result derived from
         * restricted linked dataset table.
         * </pre>
         *
         * <code>
         * .google.protobuf.BoolValue restrict_query_result = 3 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         *
         * @return The restrictQueryResult.
         */
        public com.google.protobuf.BoolValue getRestrictQueryResult() {
          if (restrictQueryResultBuilder_ == null) {
            return restrictQueryResult_ == null
                ? com.google.protobuf.BoolValue.getDefaultInstance()
                : restrictQueryResult_;
          } else {
            return restrictQueryResultBuilder_.getMessage();
          }
        }

        /**
         *
         *
         * <pre>
         * Optional. If true, restrict export of query result derived from
         * restricted linked dataset table.
         * </pre>
         *
         * <code>
         * .google.protobuf.BoolValue restrict_query_result = 3 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public Builder setRestrictQueryResult(com.google.protobuf.BoolValue value) {
          if (restrictQueryResultBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            restrictQueryResult_ = value;
          } else {
            restrictQueryResultBuilder_.setMessage(value);
          }
          bitField0_ |= 0x00000004;
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * Optional. If true, restrict export of query result derived from
         * restricted linked dataset table.
         * </pre>
         *
         * <code>
         * .google.protobuf.BoolValue restrict_query_result = 3 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public Builder setRestrictQueryResult(
            com.google.protobuf.BoolValue.Builder builderForValue) {
          if (restrictQueryResultBuilder_ == null) {
            restrictQueryResult_ = builderForValue.build();
          } else {
            restrictQueryResultBuilder_.setMessage(builderForValue.build());
          }
          bitField0_ |= 0x00000004;
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * Optional. If true, restrict export of query result derived from
         * restricted linked dataset table.
         * </pre>
         *
         * <code>
         * .google.protobuf.BoolValue restrict_query_result = 3 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public Builder mergeRestrictQueryResult(com.google.protobuf.BoolValue value) {
          if (restrictQueryResultBuilder_ == null) {
            if (((bitField0_ & 0x00000004) != 0)
                && restrictQueryResult_ != null
                && restrictQueryResult_ != com.google.protobuf.BoolValue.getDefaultInstance()) {
              getRestrictQueryResultBuilder().mergeFrom(value);
            } else {
              restrictQueryResult_ = value;
            }
          } else {
            restrictQueryResultBuilder_.mergeFrom(value);
          }
          if (restrictQueryResult_ != null) {
            bitField0_ |= 0x00000004;
            onChanged();
          }
          return this;
        }

        /**
         *
         *
         * <pre>
         * Optional. If true, restrict export of query result derived from
         * restricted linked dataset table.
         * </pre>
         *
         * <code>
         * .google.protobuf.BoolValue restrict_query_result = 3 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public Builder clearRestrictQueryResult() {
          bitField0_ = (bitField0_ & ~0x00000004);
          restrictQueryResult_ = null;
          if (restrictQueryResultBuilder_ != null) {
            restrictQueryResultBuilder_.dispose();
            restrictQueryResultBuilder_ = null;
          }
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * Optional. If true, restrict export of query result derived from
         * restricted linked dataset table.
         * </pre>
         *
         * <code>
         * .google.protobuf.BoolValue restrict_query_result = 3 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public com.google.protobuf.BoolValue.Builder getRestrictQueryResultBuilder() {
          bitField0_ |= 0x00000004;
          onChanged();
          return getRestrictQueryResultFieldBuilder().getBuilder();
        }

        /**
         *
         *
         * <pre>
         * Optional. If true, restrict export of query result derived from
         * restricted linked dataset table.
         * </pre>
         *
         * <code>
         * .google.protobuf.BoolValue restrict_query_result = 3 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public com.google.protobuf.BoolValueOrBuilder getRestrictQueryResultOrBuilder() {
          if (restrictQueryResultBuilder_ != null) {
            return restrictQueryResultBuilder_.getMessageOrBuilder();
          } else {
            return restrictQueryResult_ == null
                ? com.google.protobuf.BoolValue.getDefaultInstance()
                : restrictQueryResult_;
          }
        }

        /**
         *
         *
         * <pre>
         * Optional. If true, restrict export of query result derived from
         * restricted linked dataset table.
         * </pre>
         *
         * <code>
         * .google.protobuf.BoolValue restrict_query_result = 3 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.BoolValue,
                com.google.protobuf.BoolValue.Builder,
                com.google.protobuf.BoolValueOrBuilder>
            getRestrictQueryResultFieldBuilder() {
          if (restrictQueryResultBuilder_ == null) {
            restrictQueryResultBuilder_ =
                new com.google.protobuf.SingleFieldBuilderV3<
                    com.google.protobuf.BoolValue,
                    com.google.protobuf.BoolValue.Builder,
                    com.google.protobuf.BoolValueOrBuilder>(
                    getRestrictQueryResult(), getParentForChildren(), isClean());
            restrictQueryResult_ = null;
          }
          return restrictQueryResultBuilder_;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource.RestrictedExportPolicy)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource.RestrictedExportPolicy)
      private static final com.google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource
              .RestrictedExportPolicy
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE =
            new com.google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource
                .RestrictedExportPolicy();
      }

      public static com.google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource
              .RestrictedExportPolicy
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<RestrictedExportPolicy> PARSER =
          new com.google.protobuf.AbstractParser<RestrictedExportPolicy>() {
            @java.lang.Override
            public RestrictedExportPolicy parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<RestrictedExportPolicy> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<RestrictedExportPolicy> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource
              .RestrictedExportPolicy
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    private int bitField0_;
    public static final int DATASET_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object dataset_ = "";

    /**
     *
     *
     * <pre>
     * Optional. Resource name of the dataset source for this listing.
     * e.g. `projects/myproject/datasets/123`
     * </pre>
     *
     * <code>
     * string dataset = 1 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The dataset.
     */
    @java.lang.Override
    public java.lang.String getDataset() {
      java.lang.Object ref = dataset_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        dataset_ = s;
        return s;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Resource name of the dataset source for this listing.
     * e.g. `projects/myproject/datasets/123`
     * </pre>
     *
     * <code>
     * string dataset = 1 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for dataset.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getDatasetBytes() {
      java.lang.Object ref = dataset_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        dataset_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int SELECTED_RESOURCES_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private java.util.List<
            com.google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource
                .SelectedResource>
        selectedResources_;

    /**
     *
     *
     * <pre>
     * Optional. Resource in this dataset that is selectively shared.
     * This field is required for data clean room exchanges.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource.SelectedResource selected_resources = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public java.util.List<
            com.google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource
                .SelectedResource>
        getSelectedResourcesList() {
      return selectedResources_;
    }

    /**
     *
     *
     * <pre>
     * Optional. Resource in this dataset that is selectively shared.
     * This field is required for data clean room exchanges.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource.SelectedResource selected_resources = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public java.util.List<
            ? extends
                com.google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource
                    .SelectedResourceOrBuilder>
        getSelectedResourcesOrBuilderList() {
      return selectedResources_;
    }

    /**
     *
     *
     * <pre>
     * Optional. Resource in this dataset that is selectively shared.
     * This field is required for data clean room exchanges.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource.SelectedResource selected_resources = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public int getSelectedResourcesCount() {
      return selectedResources_.size();
    }

    /**
     *
     *
     * <pre>
     * Optional. Resource in this dataset that is selectively shared.
     * This field is required for data clean room exchanges.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource.SelectedResource selected_resources = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource.SelectedResource
        getSelectedResources(int index) {
      return selectedResources_.get(index);
    }

    /**
     *
     *
     * <pre>
     * Optional. Resource in this dataset that is selectively shared.
     * This field is required for data clean room exchanges.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource.SelectedResource selected_resources = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource
            .SelectedResourceOrBuilder
        getSelectedResourcesOrBuilder(int index) {
      return selectedResources_.get(index);
    }

    public static final int RESTRICTED_EXPORT_POLICY_FIELD_NUMBER = 3;
    private com.google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource
            .RestrictedExportPolicy
        restrictedExportPolicy_;

    /**
     *
     *
     * <pre>
     * Optional. If set, restricted export policy will be propagated and
     * enforced on the linked dataset.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource.RestrictedExportPolicy restricted_export_policy = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the restrictedExportPolicy field is set.
     */
    @java.lang.Override
    public boolean hasRestrictedExportPolicy() {
      return ((bitField0_ & 0x00000001) != 0);
    }

    /**
     *
     *
     * <pre>
     * Optional. If set, restricted export policy will be propagated and
     * enforced on the linked dataset.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource.RestrictedExportPolicy restricted_export_policy = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The restrictedExportPolicy.
     */
    @java.lang.Override
    public com.google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource
            .RestrictedExportPolicy
        getRestrictedExportPolicy() {
      return restrictedExportPolicy_ == null
          ? com.google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource
              .RestrictedExportPolicy.getDefaultInstance()
          : restrictedExportPolicy_;
    }

    /**
     *
     *
     * <pre>
     * Optional. If set, restricted export policy will be propagated and
     * enforced on the linked dataset.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource.RestrictedExportPolicy restricted_export_policy = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource
            .RestrictedExportPolicyOrBuilder
        getRestrictedExportPolicyOrBuilder() {
      return restrictedExportPolicy_ == null
          ? com.google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource
              .RestrictedExportPolicy.getDefaultInstance()
          : restrictedExportPolicy_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(dataset_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, dataset_);
      }
      for (int i = 0; i < selectedResources_.size(); i++) {
        output.writeMessage(2, selectedResources_.get(i));
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(3, getRestrictedExportPolicy());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(dataset_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, dataset_);
      }
      for (int i = 0; i < selectedResources_.size(); i++) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(2, selectedResources_.get(i));
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                3, getRestrictedExportPolicy());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof com.google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource)) {
        return super.equals(obj);
      }
      com.google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource other =
          (com.google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource) obj;

      if (!getDataset().equals(other.getDataset())) return false;
      if (!getSelectedResourcesList().equals(other.getSelectedResourcesList())) return false;
      if (hasRestrictedExportPolicy() != other.hasRestrictedExportPolicy()) return false;
      if (hasRestrictedExportPolicy()) {
        if (!getRestrictedExportPolicy().equals(other.getRestrictedExportPolicy())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + DATASET_FIELD_NUMBER;
      hash = (53 * hash) + getDataset().hashCode();
      if (getSelectedResourcesCount() > 0) {
        hash = (37 * hash) + SELECTED_RESOURCES_FIELD_NUMBER;
        hash = (53 * hash) + getSelectedResourcesList().hashCode();
      }
      if (hasRestrictedExportPolicy()) {
        hash = (37 * hash) + RESTRICTED_EXPORT_POLICY_FIELD_NUMBER;
        hash = (53 * hash) + getRestrictedExportPolicy().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * A reference to a shared dataset. It is an existing BigQuery dataset with a
     * collection of objects such as tables and views that you want to share
     * with subscribers.
     * When subscriber's subscribe to a listing, Analytics Hub creates a linked
     * dataset in
     * the subscriber's project. A Linked dataset is an opaque, read-only BigQuery
     * dataset that serves as a _symbolic link_ to a shared dataset.
     * </pre>
     *
     * Protobuf type {@code google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource)
        com.google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSourceOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.bigquery.analyticshub.v1.AnalyticsHubProto
            .internal_static_google_cloud_bigquery_analyticshub_v1_Listing_BigQueryDatasetSource_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.bigquery.analyticshub.v1.AnalyticsHubProto
            .internal_static_google_cloud_bigquery_analyticshub_v1_Listing_BigQueryDatasetSource_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource.class,
                com.google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource.Builder
                    .class);
      }

      // Construct using
      // com.google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getSelectedResourcesFieldBuilder();
          getRestrictedExportPolicyFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        dataset_ = "";
        if (selectedResourcesBuilder_ == null) {
          selectedResources_ = java.util.Collections.emptyList();
        } else {
          selectedResources_ = null;
          selectedResourcesBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000002);
        restrictedExportPolicy_ = null;
        if (restrictedExportPolicyBuilder_ != null) {
          restrictedExportPolicyBuilder_.dispose();
          restrictedExportPolicyBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.bigquery.analyticshub.v1.AnalyticsHubProto
            .internal_static_google_cloud_bigquery_analyticshub_v1_Listing_BigQueryDatasetSource_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource
          getDefaultInstanceForType() {
        return com.google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource build() {
        com.google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource
          buildPartial() {
        com.google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource result =
            new com.google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource(this);
        buildPartialRepeatedFields(result);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartialRepeatedFields(
          com.google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource result) {
        if (selectedResourcesBuilder_ == null) {
          if (((bitField0_ & 0x00000002) != 0)) {
            selectedResources_ = java.util.Collections.unmodifiableList(selectedResources_);
            bitField0_ = (bitField0_ & ~0x00000002);
          }
          result.selectedResources_ = selectedResources_;
        } else {
          result.selectedResources_ = selectedResourcesBuilder_.build();
        }
      }

      private void buildPartial0(
          com.google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.dataset_ = dataset_;
        }
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.restrictedExportPolicy_ =
              restrictedExportPolicyBuilder_ == null
                  ? restrictedExportPolicy_
                  : restrictedExportPolicyBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof com.google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource) {
          return mergeFrom(
              (com.google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource other) {
        if (other
            == com.google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource
                .getDefaultInstance()) return this;
        if (!other.getDataset().isEmpty()) {
          dataset_ = other.dataset_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (selectedResourcesBuilder_ == null) {
          if (!other.selectedResources_.isEmpty()) {
            if (selectedResources_.isEmpty()) {
              selectedResources_ = other.selectedResources_;
              bitField0_ = (bitField0_ & ~0x00000002);
            } else {
              ensureSelectedResourcesIsMutable();
              selectedResources_.addAll(other.selectedResources_);
            }
            onChanged();
          }
        } else {
          if (!other.selectedResources_.isEmpty()) {
            if (selectedResourcesBuilder_.isEmpty()) {
              selectedResourcesBuilder_.dispose();
              selectedResourcesBuilder_ = null;
              selectedResources_ = other.selectedResources_;
              bitField0_ = (bitField0_ & ~0x00000002);
              selectedResourcesBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getSelectedResourcesFieldBuilder()
                      : null;
            } else {
              selectedResourcesBuilder_.addAllMessages(other.selectedResources_);
            }
          }
        }
        if (other.hasRestrictedExportPolicy()) {
          mergeRestrictedExportPolicy(other.getRestrictedExportPolicy());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  dataset_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  com.google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource
                          .SelectedResource
                      m =
                          input.readMessage(
                              com.google.cloud.bigquery.analyticshub.v1.Listing
                                  .BigQueryDatasetSource.SelectedResource.parser(),
                              extensionRegistry);
                  if (selectedResourcesBuilder_ == null) {
                    ensureSelectedResourcesIsMutable();
                    selectedResources_.add(m);
                  } else {
                    selectedResourcesBuilder_.addMessage(m);
                  }
                  break;
                } // case 18
              case 26:
                {
                  input.readMessage(
                      getRestrictedExportPolicyFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000004;
                  break;
                } // case 26
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object dataset_ = "";

      /**
       *
       *
       * <pre>
       * Optional. Resource name of the dataset source for this listing.
       * e.g. `projects/myproject/datasets/123`
       * </pre>
       *
       * <code>
       * string dataset = 1 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return The dataset.
       */
      public java.lang.String getDataset() {
        java.lang.Object ref = dataset_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          dataset_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Optional. Resource name of the dataset source for this listing.
       * e.g. `projects/myproject/datasets/123`
       * </pre>
       *
       * <code>
       * string dataset = 1 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return The bytes for dataset.
       */
      public com.google.protobuf.ByteString getDatasetBytes() {
        java.lang.Object ref = dataset_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          dataset_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Optional. Resource name of the dataset source for this listing.
       * e.g. `projects/myproject/datasets/123`
       * </pre>
       *
       * <code>
       * string dataset = 1 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @param value The dataset to set.
       * @return This builder for chaining.
       */
      public Builder setDataset(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        dataset_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. Resource name of the dataset source for this listing.
       * e.g. `projects/myproject/datasets/123`
       * </pre>
       *
       * <code>
       * string dataset = 1 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearDataset() {
        dataset_ = getDefaultInstance().getDataset();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. Resource name of the dataset source for this listing.
       * e.g. `projects/myproject/datasets/123`
       * </pre>
       *
       * <code>
       * string dataset = 1 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @param value The bytes for dataset to set.
       * @return This builder for chaining.
       */
      public Builder setDatasetBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        dataset_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private java.util.List<
              com.google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource
                  .SelectedResource>
          selectedResources_ = java.util.Collections.emptyList();

      private void ensureSelectedResourcesIsMutable() {
        if (!((bitField0_ & 0x00000002) != 0)) {
          selectedResources_ =
              new java.util.ArrayList<
                  com.google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource
                      .SelectedResource>(selectedResources_);
          bitField0_ |= 0x00000002;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource
                  .SelectedResource,
              com.google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource
                  .SelectedResource.Builder,
              com.google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource
                  .SelectedResourceOrBuilder>
          selectedResourcesBuilder_;

      /**
       *
       *
       * <pre>
       * Optional. Resource in this dataset that is selectively shared.
       * This field is required for data clean room exchanges.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource.SelectedResource selected_resources = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public java.util.List<
              com.google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource
                  .SelectedResource>
          getSelectedResourcesList() {
        if (selectedResourcesBuilder_ == null) {
          return java.util.Collections.unmodifiableList(selectedResources_);
        } else {
          return selectedResourcesBuilder_.getMessageList();
        }
      }

      /**
       *
       *
       * <pre>
       * Optional. Resource in this dataset that is selectively shared.
       * This field is required for data clean room exchanges.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource.SelectedResource selected_resources = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public int getSelectedResourcesCount() {
        if (selectedResourcesBuilder_ == null) {
          return selectedResources_.size();
        } else {
          return selectedResourcesBuilder_.getCount();
        }
      }

      /**
       *
       *
       * <pre>
       * Optional. Resource in this dataset that is selectively shared.
       * This field is required for data clean room exchanges.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource.SelectedResource selected_resources = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource
              .SelectedResource
          getSelectedResources(int index) {
        if (selectedResourcesBuilder_ == null) {
          return selectedResources_.get(index);
        } else {
          return selectedResourcesBuilder_.getMessage(index);
        }
      }

      /**
       *
       *
       * <pre>
       * Optional. Resource in this dataset that is selectively shared.
       * This field is required for data clean room exchanges.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource.SelectedResource selected_resources = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder setSelectedResources(
          int index,
          com.google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource.SelectedResource
              value) {
        if (selectedResourcesBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureSelectedResourcesIsMutable();
          selectedResources_.set(index, value);
          onChanged();
        } else {
          selectedResourcesBuilder_.setMessage(index, value);
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. Resource in this dataset that is selectively shared.
       * This field is required for data clean room exchanges.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource.SelectedResource selected_resources = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder setSelectedResources(
          int index,
          com.google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource.SelectedResource
                  .Builder
              builderForValue) {
        if (selectedResourcesBuilder_ == null) {
          ensureSelectedResourcesIsMutable();
          selectedResources_.set(index, builderForValue.build());
          onChanged();
        } else {
          selectedResourcesBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. Resource in this dataset that is selectively shared.
       * This field is required for data clean room exchanges.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource.SelectedResource selected_resources = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder addSelectedResources(
          com.google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource.SelectedResource
              value) {
        if (selectedResourcesBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureSelectedResourcesIsMutable();
          selectedResources_.add(value);
          onChanged();
        } else {
          selectedResourcesBuilder_.addMessage(value);
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. Resource in this dataset that is selectively shared.
       * This field is required for data clean room exchanges.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource.SelectedResource selected_resources = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder addSelectedResources(
          int index,
          com.google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource.SelectedResource
              value) {
        if (selectedResourcesBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureSelectedResourcesIsMutable();
          selectedResources_.add(index, value);
          onChanged();
        } else {
          selectedResourcesBuilder_.addMessage(index, value);
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. Resource in this dataset that is selectively shared.
       * This field is required for data clean room exchanges.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource.SelectedResource selected_resources = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder addSelectedResources(
          com.google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource.SelectedResource
                  .Builder
              builderForValue) {
        if (selectedResourcesBuilder_ == null) {
          ensureSelectedResourcesIsMutable();
          selectedResources_.add(builderForValue.build());
          onChanged();
        } else {
          selectedResourcesBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. Resource in this dataset that is selectively shared.
       * This field is required for data clean room exchanges.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource.SelectedResource selected_resources = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder addSelectedResources(
          int index,
          com.google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource.SelectedResource
                  .Builder
              builderForValue) {
        if (selectedResourcesBuilder_ == null) {
          ensureSelectedResourcesIsMutable();
          selectedResources_.add(index, builderForValue.build());
          onChanged();
        } else {
          selectedResourcesBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. Resource in this dataset that is selectively shared.
       * This field is required for data clean room exchanges.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource.SelectedResource selected_resources = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder addAllSelectedResources(
          java.lang.Iterable<
                  ? extends
                      com.google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource
                          .SelectedResource>
              values) {
        if (selectedResourcesBuilder_ == null) {
          ensureSelectedResourcesIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, selectedResources_);
          onChanged();
        } else {
          selectedResourcesBuilder_.addAllMessages(values);
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. Resource in this dataset that is selectively shared.
       * This field is required for data clean room exchanges.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource.SelectedResource selected_resources = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder clearSelectedResources() {
        if (selectedResourcesBuilder_ == null) {
          selectedResources_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000002);
          onChanged();
        } else {
          selectedResourcesBuilder_.clear();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. Resource in this dataset that is selectively shared.
       * This field is required for data clean room exchanges.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource.SelectedResource selected_resources = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder removeSelectedResources(int index) {
        if (selectedResourcesBuilder_ == null) {
          ensureSelectedResourcesIsMutable();
          selectedResources_.remove(index);
          onChanged();
        } else {
          selectedResourcesBuilder_.remove(index);
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. Resource in this dataset that is selectively shared.
       * This field is required for data clean room exchanges.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource.SelectedResource selected_resources = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource
              .SelectedResource.Builder
          getSelectedResourcesBuilder(int index) {
        return getSelectedResourcesFieldBuilder().getBuilder(index);
      }

      /**
       *
       *
       * <pre>
       * Optional. Resource in this dataset that is selectively shared.
       * This field is required for data clean room exchanges.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource.SelectedResource selected_resources = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource
              .SelectedResourceOrBuilder
          getSelectedResourcesOrBuilder(int index) {
        if (selectedResourcesBuilder_ == null) {
          return selectedResources_.get(index);
        } else {
          return selectedResourcesBuilder_.getMessageOrBuilder(index);
        }
      }

      /**
       *
       *
       * <pre>
       * Optional. Resource in this dataset that is selectively shared.
       * This field is required for data clean room exchanges.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource.SelectedResource selected_resources = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public java.util.List<
              ? extends
                  com.google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource
                      .SelectedResourceOrBuilder>
          getSelectedResourcesOrBuilderList() {
        if (selectedResourcesBuilder_ != null) {
          return selectedResourcesBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(selectedResources_);
        }
      }

      /**
       *
       *
       * <pre>
       * Optional. Resource in this dataset that is selectively shared.
       * This field is required for data clean room exchanges.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource.SelectedResource selected_resources = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource
              .SelectedResource.Builder
          addSelectedResourcesBuilder() {
        return getSelectedResourcesFieldBuilder()
            .addBuilder(
                com.google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource
                    .SelectedResource.getDefaultInstance());
      }

      /**
       *
       *
       * <pre>
       * Optional. Resource in this dataset that is selectively shared.
       * This field is required for data clean room exchanges.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource.SelectedResource selected_resources = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource
              .SelectedResource.Builder
          addSelectedResourcesBuilder(int index) {
        return getSelectedResourcesFieldBuilder()
            .addBuilder(
                index,
                com.google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource
                    .SelectedResource.getDefaultInstance());
      }

      /**
       *
       *
       * <pre>
       * Optional. Resource in this dataset that is selectively shared.
       * This field is required for data clean room exchanges.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource.SelectedResource selected_resources = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public java.util.List<
              com.google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource
                  .SelectedResource.Builder>
          getSelectedResourcesBuilderList() {
        return getSelectedResourcesFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource
                  .SelectedResource,
              com.google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource
                  .SelectedResource.Builder,
              com.google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource
                  .SelectedResourceOrBuilder>
          getSelectedResourcesFieldBuilder() {
        if (selectedResourcesBuilder_ == null) {
          selectedResourcesBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilderV3<
                  com.google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource
                      .SelectedResource,
                  com.google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource
                      .SelectedResource.Builder,
                  com.google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource
                      .SelectedResourceOrBuilder>(
                  selectedResources_,
                  ((bitField0_ & 0x00000002) != 0),
                  getParentForChildren(),
                  isClean());
          selectedResources_ = null;
        }
        return selectedResourcesBuilder_;
      }

      private com.google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource
              .RestrictedExportPolicy
          restrictedExportPolicy_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource
                  .RestrictedExportPolicy,
              com.google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource
                  .RestrictedExportPolicy.Builder,
              com.google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource
                  .RestrictedExportPolicyOrBuilder>
          restrictedExportPolicyBuilder_;

      /**
       *
       *
       * <pre>
       * Optional. If set, restricted export policy will be propagated and
       * enforced on the linked dataset.
       * </pre>
       *
       * <code>
       * .google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource.RestrictedExportPolicy restricted_export_policy = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return Whether the restrictedExportPolicy field is set.
       */
      public boolean hasRestrictedExportPolicy() {
        return ((bitField0_ & 0x00000004) != 0);
      }

      /**
       *
       *
       * <pre>
       * Optional. If set, restricted export policy will be propagated and
       * enforced on the linked dataset.
       * </pre>
       *
       * <code>
       * .google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource.RestrictedExportPolicy restricted_export_policy = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The restrictedExportPolicy.
       */
      public com.google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource
              .RestrictedExportPolicy
          getRestrictedExportPolicy() {
        if (restrictedExportPolicyBuilder_ == null) {
          return restrictedExportPolicy_ == null
              ? com.google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource
                  .RestrictedExportPolicy.getDefaultInstance()
              : restrictedExportPolicy_;
        } else {
          return restrictedExportPolicyBuilder_.getMessage();
        }
      }

      /**
       *
       *
       * <pre>
       * Optional. If set, restricted export policy will be propagated and
       * enforced on the linked dataset.
       * </pre>
       *
       * <code>
       * .google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource.RestrictedExportPolicy restricted_export_policy = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder setRestrictedExportPolicy(
          com.google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource
                  .RestrictedExportPolicy
              value) {
        if (restrictedExportPolicyBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          restrictedExportPolicy_ = value;
        } else {
          restrictedExportPolicyBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. If set, restricted export policy will be propagated and
       * enforced on the linked dataset.
       * </pre>
       *
       * <code>
       * .google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource.RestrictedExportPolicy restricted_export_policy = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder setRestrictedExportPolicy(
          com.google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource
                  .RestrictedExportPolicy.Builder
              builderForValue) {
        if (restrictedExportPolicyBuilder_ == null) {
          restrictedExportPolicy_ = builderForValue.build();
        } else {
          restrictedExportPolicyBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. If set, restricted export policy will be propagated and
       * enforced on the linked dataset.
       * </pre>
       *
       * <code>
       * .google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource.RestrictedExportPolicy restricted_export_policy = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder mergeRestrictedExportPolicy(
          com.google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource
                  .RestrictedExportPolicy
              value) {
        if (restrictedExportPolicyBuilder_ == null) {
          if (((bitField0_ & 0x00000004) != 0)
              && restrictedExportPolicy_ != null
              && restrictedExportPolicy_
                  != com.google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource
                      .RestrictedExportPolicy.getDefaultInstance()) {
            getRestrictedExportPolicyBuilder().mergeFrom(value);
          } else {
            restrictedExportPolicy_ = value;
          }
        } else {
          restrictedExportPolicyBuilder_.mergeFrom(value);
        }
        if (restrictedExportPolicy_ != null) {
          bitField0_ |= 0x00000004;
          onChanged();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. If set, restricted export policy will be propagated and
       * enforced on the linked dataset.
       * </pre>
       *
       * <code>
       * .google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource.RestrictedExportPolicy restricted_export_policy = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder clearRestrictedExportPolicy() {
        bitField0_ = (bitField0_ & ~0x00000004);
        restrictedExportPolicy_ = null;
        if (restrictedExportPolicyBuilder_ != null) {
          restrictedExportPolicyBuilder_.dispose();
          restrictedExportPolicyBuilder_ = null;
        }
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. If set, restricted export policy will be propagated and
       * enforced on the linked dataset.
       * </pre>
       *
       * <code>
       * .google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource.RestrictedExportPolicy restricted_export_policy = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource
              .RestrictedExportPolicy.Builder
          getRestrictedExportPolicyBuilder() {
        bitField0_ |= 0x00000004;
        onChanged();
        return getRestrictedExportPolicyFieldBuilder().getBuilder();
      }

      /**
       *
       *
       * <pre>
       * Optional. If set, restricted export policy will be propagated and
       * enforced on the linked dataset.
       * </pre>
       *
       * <code>
       * .google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource.RestrictedExportPolicy restricted_export_policy = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource
              .RestrictedExportPolicyOrBuilder
          getRestrictedExportPolicyOrBuilder() {
        if (restrictedExportPolicyBuilder_ != null) {
          return restrictedExportPolicyBuilder_.getMessageOrBuilder();
        } else {
          return restrictedExportPolicy_ == null
              ? com.google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource
                  .RestrictedExportPolicy.getDefaultInstance()
              : restrictedExportPolicy_;
        }
      }

      /**
       *
       *
       * <pre>
       * Optional. If set, restricted export policy will be propagated and
       * enforced on the linked dataset.
       * </pre>
       *
       * <code>
       * .google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource.RestrictedExportPolicy restricted_export_policy = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource
                  .RestrictedExportPolicy,
              com.google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource
                  .RestrictedExportPolicy.Builder,
              com.google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource
                  .RestrictedExportPolicyOrBuilder>
          getRestrictedExportPolicyFieldBuilder() {
        if (restrictedExportPolicyBuilder_ == null) {
          restrictedExportPolicyBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource
                      .RestrictedExportPolicy,
                  com.google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource
                      .RestrictedExportPolicy.Builder,
                  com.google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource
                      .RestrictedExportPolicyOrBuilder>(
                  getRestrictedExportPolicy(), getParentForChildren(), isClean());
          restrictedExportPolicy_ = null;
        }
        return restrictedExportPolicyBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource)
    private static final com.google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource();
    }

    public static com.google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<BigQueryDatasetSource> PARSER =
        new com.google.protobuf.AbstractParser<BigQueryDatasetSource>() {
          @java.lang.Override
          public BigQueryDatasetSource parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<BigQueryDatasetSource> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<BigQueryDatasetSource> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface PubSubTopicSourceOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.bigquery.analyticshub.v1.Listing.PubSubTopicSource)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Required. Resource name of the Pub/Sub topic source for this listing.
     * e.g. projects/myproject/topics/topicId
     * </pre>
     *
     * <code>
     * string topic = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The topic.
     */
    java.lang.String getTopic();

    /**
     *
     *
     * <pre>
     * Required. Resource name of the Pub/Sub topic source for this listing.
     * e.g. projects/myproject/topics/topicId
     * </pre>
     *
     * <code>
     * string topic = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for topic.
     */
    com.google.protobuf.ByteString getTopicBytes();

    /**
     *
     *
     * <pre>
     * Optional. Region hint on where the data might be published. Data affinity
     * regions are modifiable. See https://cloud.google.com/about/locations for
     * full listing of possible Cloud regions.
     * </pre>
     *
     * <code>repeated string data_affinity_regions = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return A list containing the dataAffinityRegions.
     */
    java.util.List<java.lang.String> getDataAffinityRegionsList();

    /**
     *
     *
     * <pre>
     * Optional. Region hint on where the data might be published. Data affinity
     * regions are modifiable. See https://cloud.google.com/about/locations for
     * full listing of possible Cloud regions.
     * </pre>
     *
     * <code>repeated string data_affinity_regions = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The count of dataAffinityRegions.
     */
    int getDataAffinityRegionsCount();

    /**
     *
     *
     * <pre>
     * Optional. Region hint on where the data might be published. Data affinity
     * regions are modifiable. See https://cloud.google.com/about/locations for
     * full listing of possible Cloud regions.
     * </pre>
     *
     * <code>repeated string data_affinity_regions = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param index The index of the element to return.
     * @return The dataAffinityRegions at the given index.
     */
    java.lang.String getDataAffinityRegions(int index);

    /**
     *
     *
     * <pre>
     * Optional. Region hint on where the data might be published. Data affinity
     * regions are modifiable. See https://cloud.google.com/about/locations for
     * full listing of possible Cloud regions.
     * </pre>
     *
     * <code>repeated string data_affinity_regions = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the dataAffinityRegions at the given index.
     */
    com.google.protobuf.ByteString getDataAffinityRegionsBytes(int index);
  }

  /**
   *
   *
   * <pre>
   * Pub/Sub topic source.
   * </pre>
   *
   * Protobuf type {@code google.cloud.bigquery.analyticshub.v1.Listing.PubSubTopicSource}
   */
  public static final class PubSubTopicSource extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.bigquery.analyticshub.v1.Listing.PubSubTopicSource)
      PubSubTopicSourceOrBuilder {
    private static final long serialVersionUID = 0L;

    // Use PubSubTopicSource.newBuilder() to construct.
    private PubSubTopicSource(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private PubSubTopicSource() {
      topic_ = "";
      dataAffinityRegions_ = com.google.protobuf.LazyStringArrayList.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new PubSubTopicSource();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.bigquery.analyticshub.v1.AnalyticsHubProto
          .internal_static_google_cloud_bigquery_analyticshub_v1_Listing_PubSubTopicSource_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.bigquery.analyticshub.v1.AnalyticsHubProto
          .internal_static_google_cloud_bigquery_analyticshub_v1_Listing_PubSubTopicSource_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.bigquery.analyticshub.v1.Listing.PubSubTopicSource.class,
              com.google.cloud.bigquery.analyticshub.v1.Listing.PubSubTopicSource.Builder.class);
    }

    public static final int TOPIC_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object topic_ = "";

    /**
     *
     *
     * <pre>
     * Required. Resource name of the Pub/Sub topic source for this listing.
     * e.g. projects/myproject/topics/topicId
     * </pre>
     *
     * <code>
     * string topic = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The topic.
     */
    @java.lang.Override
    public java.lang.String getTopic() {
      java.lang.Object ref = topic_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        topic_ = s;
        return s;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. Resource name of the Pub/Sub topic source for this listing.
     * e.g. projects/myproject/topics/topicId
     * </pre>
     *
     * <code>
     * string topic = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for topic.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getTopicBytes() {
      java.lang.Object ref = topic_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        topic_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int DATA_AFFINITY_REGIONS_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private com.google.protobuf.LazyStringArrayList dataAffinityRegions_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    /**
     *
     *
     * <pre>
     * Optional. Region hint on where the data might be published. Data affinity
     * regions are modifiable. See https://cloud.google.com/about/locations for
     * full listing of possible Cloud regions.
     * </pre>
     *
     * <code>repeated string data_affinity_regions = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return A list containing the dataAffinityRegions.
     */
    public com.google.protobuf.ProtocolStringList getDataAffinityRegionsList() {
      return dataAffinityRegions_;
    }

    /**
     *
     *
     * <pre>
     * Optional. Region hint on where the data might be published. Data affinity
     * regions are modifiable. See https://cloud.google.com/about/locations for
     * full listing of possible Cloud regions.
     * </pre>
     *
     * <code>repeated string data_affinity_regions = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The count of dataAffinityRegions.
     */
    public int getDataAffinityRegionsCount() {
      return dataAffinityRegions_.size();
    }

    /**
     *
     *
     * <pre>
     * Optional. Region hint on where the data might be published. Data affinity
     * regions are modifiable. See https://cloud.google.com/about/locations for
     * full listing of possible Cloud regions.
     * </pre>
     *
     * <code>repeated string data_affinity_regions = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param index The index of the element to return.
     * @return The dataAffinityRegions at the given index.
     */
    public java.lang.String getDataAffinityRegions(int index) {
      return dataAffinityRegions_.get(index);
    }

    /**
     *
     *
     * <pre>
     * Optional. Region hint on where the data might be published. Data affinity
     * regions are modifiable. See https://cloud.google.com/about/locations for
     * full listing of possible Cloud regions.
     * </pre>
     *
     * <code>repeated string data_affinity_regions = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the dataAffinityRegions at the given index.
     */
    public com.google.protobuf.ByteString getDataAffinityRegionsBytes(int index) {
      return dataAffinityRegions_.getByteString(index);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(topic_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, topic_);
      }
      for (int i = 0; i < dataAffinityRegions_.size(); i++) {
        com.google.protobuf.GeneratedMessageV3.writeString(
            output, 2, dataAffinityRegions_.getRaw(i));
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(topic_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, topic_);
      }
      {
        int dataSize = 0;
        for (int i = 0; i < dataAffinityRegions_.size(); i++) {
          dataSize += computeStringSizeNoTag(dataAffinityRegions_.getRaw(i));
        }
        size += dataSize;
        size += 1 * getDataAffinityRegionsList().size();
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.bigquery.analyticshub.v1.Listing.PubSubTopicSource)) {
        return super.equals(obj);
      }
      com.google.cloud.bigquery.analyticshub.v1.Listing.PubSubTopicSource other =
          (com.google.cloud.bigquery.analyticshub.v1.Listing.PubSubTopicSource) obj;

      if (!getTopic().equals(other.getTopic())) return false;
      if (!getDataAffinityRegionsList().equals(other.getDataAffinityRegionsList())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + TOPIC_FIELD_NUMBER;
      hash = (53 * hash) + getTopic().hashCode();
      if (getDataAffinityRegionsCount() > 0) {
        hash = (37 * hash) + DATA_AFFINITY_REGIONS_FIELD_NUMBER;
        hash = (53 * hash) + getDataAffinityRegionsList().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.bigquery.analyticshub.v1.Listing.PubSubTopicSource parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.bigquery.analyticshub.v1.Listing.PubSubTopicSource parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.bigquery.analyticshub.v1.Listing.PubSubTopicSource parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.bigquery.analyticshub.v1.Listing.PubSubTopicSource parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.bigquery.analyticshub.v1.Listing.PubSubTopicSource parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.bigquery.analyticshub.v1.Listing.PubSubTopicSource parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.bigquery.analyticshub.v1.Listing.PubSubTopicSource parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.bigquery.analyticshub.v1.Listing.PubSubTopicSource parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.bigquery.analyticshub.v1.Listing.PubSubTopicSource
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.bigquery.analyticshub.v1.Listing.PubSubTopicSource
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.bigquery.analyticshub.v1.Listing.PubSubTopicSource parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.bigquery.analyticshub.v1.Listing.PubSubTopicSource parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.bigquery.analyticshub.v1.Listing.PubSubTopicSource prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * Pub/Sub topic source.
     * </pre>
     *
     * Protobuf type {@code google.cloud.bigquery.analyticshub.v1.Listing.PubSubTopicSource}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.bigquery.analyticshub.v1.Listing.PubSubTopicSource)
        com.google.cloud.bigquery.analyticshub.v1.Listing.PubSubTopicSourceOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.bigquery.analyticshub.v1.AnalyticsHubProto
            .internal_static_google_cloud_bigquery_analyticshub_v1_Listing_PubSubTopicSource_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.bigquery.analyticshub.v1.AnalyticsHubProto
            .internal_static_google_cloud_bigquery_analyticshub_v1_Listing_PubSubTopicSource_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.bigquery.analyticshub.v1.Listing.PubSubTopicSource.class,
                com.google.cloud.bigquery.analyticshub.v1.Listing.PubSubTopicSource.Builder.class);
      }

      // Construct using
      // com.google.cloud.bigquery.analyticshub.v1.Listing.PubSubTopicSource.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        topic_ = "";
        dataAffinityRegions_ = com.google.protobuf.LazyStringArrayList.emptyList();
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.bigquery.analyticshub.v1.AnalyticsHubProto
            .internal_static_google_cloud_bigquery_analyticshub_v1_Listing_PubSubTopicSource_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.bigquery.analyticshub.v1.Listing.PubSubTopicSource
          getDefaultInstanceForType() {
        return com.google.cloud.bigquery.analyticshub.v1.Listing.PubSubTopicSource
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.bigquery.analyticshub.v1.Listing.PubSubTopicSource build() {
        com.google.cloud.bigquery.analyticshub.v1.Listing.PubSubTopicSource result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.bigquery.analyticshub.v1.Listing.PubSubTopicSource buildPartial() {
        com.google.cloud.bigquery.analyticshub.v1.Listing.PubSubTopicSource result =
            new com.google.cloud.bigquery.analyticshub.v1.Listing.PubSubTopicSource(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.bigquery.analyticshub.v1.Listing.PubSubTopicSource result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.topic_ = topic_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          dataAffinityRegions_.makeImmutable();
          result.dataAffinityRegions_ = dataAffinityRegions_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.bigquery.analyticshub.v1.Listing.PubSubTopicSource) {
          return mergeFrom(
              (com.google.cloud.bigquery.analyticshub.v1.Listing.PubSubTopicSource) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.bigquery.analyticshub.v1.Listing.PubSubTopicSource other) {
        if (other
            == com.google.cloud.bigquery.analyticshub.v1.Listing.PubSubTopicSource
                .getDefaultInstance()) return this;
        if (!other.getTopic().isEmpty()) {
          topic_ = other.topic_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (!other.dataAffinityRegions_.isEmpty()) {
          if (dataAffinityRegions_.isEmpty()) {
            dataAffinityRegions_ = other.dataAffinityRegions_;
            bitField0_ |= 0x00000002;
          } else {
            ensureDataAffinityRegionsIsMutable();
            dataAffinityRegions_.addAll(other.dataAffinityRegions_);
          }
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  topic_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  java.lang.String s = input.readStringRequireUtf8();
                  ensureDataAffinityRegionsIsMutable();
                  dataAffinityRegions_.add(s);
                  break;
                } // case 18
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object topic_ = "";

      /**
       *
       *
       * <pre>
       * Required. Resource name of the Pub/Sub topic source for this listing.
       * e.g. projects/myproject/topics/topicId
       * </pre>
       *
       * <code>
       * string topic = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return The topic.
       */
      public java.lang.String getTopic() {
        java.lang.Object ref = topic_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          topic_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Required. Resource name of the Pub/Sub topic source for this listing.
       * e.g. projects/myproject/topics/topicId
       * </pre>
       *
       * <code>
       * string topic = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return The bytes for topic.
       */
      public com.google.protobuf.ByteString getTopicBytes() {
        java.lang.Object ref = topic_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          topic_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Required. Resource name of the Pub/Sub topic source for this listing.
       * e.g. projects/myproject/topics/topicId
       * </pre>
       *
       * <code>
       * string topic = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @param value The topic to set.
       * @return This builder for chaining.
       */
      public Builder setTopic(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        topic_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Required. Resource name of the Pub/Sub topic source for this listing.
       * e.g. projects/myproject/topics/topicId
       * </pre>
       *
       * <code>
       * string topic = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearTopic() {
        topic_ = getDefaultInstance().getTopic();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Required. Resource name of the Pub/Sub topic source for this listing.
       * e.g. projects/myproject/topics/topicId
       * </pre>
       *
       * <code>
       * string topic = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @param value The bytes for topic to set.
       * @return This builder for chaining.
       */
      public Builder setTopicBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        topic_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private com.google.protobuf.LazyStringArrayList dataAffinityRegions_ =
          com.google.protobuf.LazyStringArrayList.emptyList();

      private void ensureDataAffinityRegionsIsMutable() {
        if (!dataAffinityRegions_.isModifiable()) {
          dataAffinityRegions_ = new com.google.protobuf.LazyStringArrayList(dataAffinityRegions_);
        }
        bitField0_ |= 0x00000002;
      }

      /**
       *
       *
       * <pre>
       * Optional. Region hint on where the data might be published. Data affinity
       * regions are modifiable. See https://cloud.google.com/about/locations for
       * full listing of possible Cloud regions.
       * </pre>
       *
       * <code>repeated string data_affinity_regions = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return A list containing the dataAffinityRegions.
       */
      public com.google.protobuf.ProtocolStringList getDataAffinityRegionsList() {
        dataAffinityRegions_.makeImmutable();
        return dataAffinityRegions_;
      }

      /**
       *
       *
       * <pre>
       * Optional. Region hint on where the data might be published. Data affinity
       * regions are modifiable. See https://cloud.google.com/about/locations for
       * full listing of possible Cloud regions.
       * </pre>
       *
       * <code>repeated string data_affinity_regions = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The count of dataAffinityRegions.
       */
      public int getDataAffinityRegionsCount() {
        return dataAffinityRegions_.size();
      }

      /**
       *
       *
       * <pre>
       * Optional. Region hint on where the data might be published. Data affinity
       * regions are modifiable. See https://cloud.google.com/about/locations for
       * full listing of possible Cloud regions.
       * </pre>
       *
       * <code>repeated string data_affinity_regions = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @param index The index of the element to return.
       * @return The dataAffinityRegions at the given index.
       */
      public java.lang.String getDataAffinityRegions(int index) {
        return dataAffinityRegions_.get(index);
      }

      /**
       *
       *
       * <pre>
       * Optional. Region hint on where the data might be published. Data affinity
       * regions are modifiable. See https://cloud.google.com/about/locations for
       * full listing of possible Cloud regions.
       * </pre>
       *
       * <code>repeated string data_affinity_regions = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the dataAffinityRegions at the given index.
       */
      public com.google.protobuf.ByteString getDataAffinityRegionsBytes(int index) {
        return dataAffinityRegions_.getByteString(index);
      }

      /**
       *
       *
       * <pre>
       * Optional. Region hint on where the data might be published. Data affinity
       * regions are modifiable. See https://cloud.google.com/about/locations for
       * full listing of possible Cloud regions.
       * </pre>
       *
       * <code>repeated string data_affinity_regions = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @param index The index to set the value at.
       * @param value The dataAffinityRegions to set.
       * @return This builder for chaining.
       */
      public Builder setDataAffinityRegions(int index, java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureDataAffinityRegionsIsMutable();
        dataAffinityRegions_.set(index, value);
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. Region hint on where the data might be published. Data affinity
       * regions are modifiable. See https://cloud.google.com/about/locations for
       * full listing of possible Cloud regions.
       * </pre>
       *
       * <code>repeated string data_affinity_regions = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @param value The dataAffinityRegions to add.
       * @return This builder for chaining.
       */
      public Builder addDataAffinityRegions(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureDataAffinityRegionsIsMutable();
        dataAffinityRegions_.add(value);
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. Region hint on where the data might be published. Data affinity
       * regions are modifiable. See https://cloud.google.com/about/locations for
       * full listing of possible Cloud regions.
       * </pre>
       *
       * <code>repeated string data_affinity_regions = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @param values The dataAffinityRegions to add.
       * @return This builder for chaining.
       */
      public Builder addAllDataAffinityRegions(java.lang.Iterable<java.lang.String> values) {
        ensureDataAffinityRegionsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, dataAffinityRegions_);
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. Region hint on where the data might be published. Data affinity
       * regions are modifiable. See https://cloud.google.com/about/locations for
       * full listing of possible Cloud regions.
       * </pre>
       *
       * <code>repeated string data_affinity_regions = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearDataAffinityRegions() {
        dataAffinityRegions_ = com.google.protobuf.LazyStringArrayList.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        ;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. Region hint on where the data might be published. Data affinity
       * regions are modifiable. See https://cloud.google.com/about/locations for
       * full listing of possible Cloud regions.
       * </pre>
       *
       * <code>repeated string data_affinity_regions = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @param value The bytes of the dataAffinityRegions to add.
       * @return This builder for chaining.
       */
      public Builder addDataAffinityRegionsBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        ensureDataAffinityRegionsIsMutable();
        dataAffinityRegions_.add(value);
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.bigquery.analyticshub.v1.Listing.PubSubTopicSource)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.bigquery.analyticshub.v1.Listing.PubSubTopicSource)
    private static final com.google.cloud.bigquery.analyticshub.v1.Listing.PubSubTopicSource
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.bigquery.analyticshub.v1.Listing.PubSubTopicSource();
    }

    public static com.google.cloud.bigquery.analyticshub.v1.Listing.PubSubTopicSource
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<PubSubTopicSource> PARSER =
        new com.google.protobuf.AbstractParser<PubSubTopicSource>() {
          @java.lang.Override
          public PubSubTopicSource parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<PubSubTopicSource> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<PubSubTopicSource> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.bigquery.analyticshub.v1.Listing.PubSubTopicSource
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface RestrictedExportConfigOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.bigquery.analyticshub.v1.Listing.RestrictedExportConfig)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Optional. If true, enable restricted export.
     * </pre>
     *
     * <code>bool enabled = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The enabled.
     */
    boolean getEnabled();

    /**
     *
     *
     * <pre>
     * Output only. If true, restrict direct table access(read
     * api/tabledata.list) on linked table.
     * </pre>
     *
     * <code>bool restrict_direct_table_access = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The restrictDirectTableAccess.
     */
    boolean getRestrictDirectTableAccess();

    /**
     *
     *
     * <pre>
     * Optional. If true, restrict export of query result derived from
     * restricted linked dataset table.
     * </pre>
     *
     * <code>bool restrict_query_result = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The restrictQueryResult.
     */
    boolean getRestrictQueryResult();
  }

  /**
   *
   *
   * <pre>
   * Restricted export config, used to configure restricted export on linked
   * dataset.
   * </pre>
   *
   * Protobuf type {@code google.cloud.bigquery.analyticshub.v1.Listing.RestrictedExportConfig}
   */
  public static final class RestrictedExportConfig extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.bigquery.analyticshub.v1.Listing.RestrictedExportConfig)
      RestrictedExportConfigOrBuilder {
    private static final long serialVersionUID = 0L;

    // Use RestrictedExportConfig.newBuilder() to construct.
    private RestrictedExportConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private RestrictedExportConfig() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new RestrictedExportConfig();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.bigquery.analyticshub.v1.AnalyticsHubProto
          .internal_static_google_cloud_bigquery_analyticshub_v1_Listing_RestrictedExportConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.bigquery.analyticshub.v1.AnalyticsHubProto
          .internal_static_google_cloud_bigquery_analyticshub_v1_Listing_RestrictedExportConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.bigquery.analyticshub.v1.Listing.RestrictedExportConfig.class,
              com.google.cloud.bigquery.analyticshub.v1.Listing.RestrictedExportConfig.Builder
                  .class);
    }

    public static final int ENABLED_FIELD_NUMBER = 3;
    private boolean enabled_ = false;

    /**
     *
     *
     * <pre>
     * Optional. If true, enable restricted export.
     * </pre>
     *
     * <code>bool enabled = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The enabled.
     */
    @java.lang.Override
    public boolean getEnabled() {
      return enabled_;
    }

    public static final int RESTRICT_DIRECT_TABLE_ACCESS_FIELD_NUMBER = 1;
    private boolean restrictDirectTableAccess_ = false;

    /**
     *
     *
     * <pre>
     * Output only. If true, restrict direct table access(read
     * api/tabledata.list) on linked table.
     * </pre>
     *
     * <code>bool restrict_direct_table_access = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The restrictDirectTableAccess.
     */
    @java.lang.Override
    public boolean getRestrictDirectTableAccess() {
      return restrictDirectTableAccess_;
    }

    public static final int RESTRICT_QUERY_RESULT_FIELD_NUMBER = 2;
    private boolean restrictQueryResult_ = false;

    /**
     *
     *
     * <pre>
     * Optional. If true, restrict export of query result derived from
     * restricted linked dataset table.
     * </pre>
     *
     * <code>bool restrict_query_result = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The restrictQueryResult.
     */
    @java.lang.Override
    public boolean getRestrictQueryResult() {
      return restrictQueryResult_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (restrictDirectTableAccess_ != false) {
        output.writeBool(1, restrictDirectTableAccess_);
      }
      if (restrictQueryResult_ != false) {
        output.writeBool(2, restrictQueryResult_);
      }
      if (enabled_ != false) {
        output.writeBool(3, enabled_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (restrictDirectTableAccess_ != false) {
        size +=
            com.google.protobuf.CodedOutputStream.computeBoolSize(1, restrictDirectTableAccess_);
      }
      if (restrictQueryResult_ != false) {
        size += com.google.protobuf.CodedOutputStream.computeBoolSize(2, restrictQueryResult_);
      }
      if (enabled_ != false) {
        size += com.google.protobuf.CodedOutputStream.computeBoolSize(3, enabled_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof com.google.cloud.bigquery.analyticshub.v1.Listing.RestrictedExportConfig)) {
        return super.equals(obj);
      }
      com.google.cloud.bigquery.analyticshub.v1.Listing.RestrictedExportConfig other =
          (com.google.cloud.bigquery.analyticshub.v1.Listing.RestrictedExportConfig) obj;

      if (getEnabled() != other.getEnabled()) return false;
      if (getRestrictDirectTableAccess() != other.getRestrictDirectTableAccess()) return false;
      if (getRestrictQueryResult() != other.getRestrictQueryResult()) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + ENABLED_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getEnabled());
      hash = (37 * hash) + RESTRICT_DIRECT_TABLE_ACCESS_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getRestrictDirectTableAccess());
      hash = (37 * hash) + RESTRICT_QUERY_RESULT_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getRestrictQueryResult());
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.bigquery.analyticshub.v1.Listing.RestrictedExportConfig
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.bigquery.analyticshub.v1.Listing.RestrictedExportConfig
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.bigquery.analyticshub.v1.Listing.RestrictedExportConfig
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.bigquery.analyticshub.v1.Listing.RestrictedExportConfig
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.bigquery.analyticshub.v1.Listing.RestrictedExportConfig
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.bigquery.analyticshub.v1.Listing.RestrictedExportConfig
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.bigquery.analyticshub.v1.Listing.RestrictedExportConfig
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.bigquery.analyticshub.v1.Listing.RestrictedExportConfig
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.bigquery.analyticshub.v1.Listing.RestrictedExportConfig
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.bigquery.analyticshub.v1.Listing.RestrictedExportConfig
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.bigquery.analyticshub.v1.Listing.RestrictedExportConfig
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.bigquery.analyticshub.v1.Listing.RestrictedExportConfig
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.bigquery.analyticshub.v1.Listing.RestrictedExportConfig prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * Restricted export config, used to configure restricted export on linked
     * dataset.
     * </pre>
     *
     * Protobuf type {@code google.cloud.bigquery.analyticshub.v1.Listing.RestrictedExportConfig}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.bigquery.analyticshub.v1.Listing.RestrictedExportConfig)
        com.google.cloud.bigquery.analyticshub.v1.Listing.RestrictedExportConfigOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.bigquery.analyticshub.v1.AnalyticsHubProto
            .internal_static_google_cloud_bigquery_analyticshub_v1_Listing_RestrictedExportConfig_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.bigquery.analyticshub.v1.AnalyticsHubProto
            .internal_static_google_cloud_bigquery_analyticshub_v1_Listing_RestrictedExportConfig_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.bigquery.analyticshub.v1.Listing.RestrictedExportConfig.class,
                com.google.cloud.bigquery.analyticshub.v1.Listing.RestrictedExportConfig.Builder
                    .class);
      }

      // Construct using
      // com.google.cloud.bigquery.analyticshub.v1.Listing.RestrictedExportConfig.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        enabled_ = false;
        restrictDirectTableAccess_ = false;
        restrictQueryResult_ = false;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.bigquery.analyticshub.v1.AnalyticsHubProto
            .internal_static_google_cloud_bigquery_analyticshub_v1_Listing_RestrictedExportConfig_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.bigquery.analyticshub.v1.Listing.RestrictedExportConfig
          getDefaultInstanceForType() {
        return com.google.cloud.bigquery.analyticshub.v1.Listing.RestrictedExportConfig
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.bigquery.analyticshub.v1.Listing.RestrictedExportConfig build() {
        com.google.cloud.bigquery.analyticshub.v1.Listing.RestrictedExportConfig result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.bigquery.analyticshub.v1.Listing.RestrictedExportConfig
          buildPartial() {
        com.google.cloud.bigquery.analyticshub.v1.Listing.RestrictedExportConfig result =
            new com.google.cloud.bigquery.analyticshub.v1.Listing.RestrictedExportConfig(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.bigquery.analyticshub.v1.Listing.RestrictedExportConfig result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.enabled_ = enabled_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.restrictDirectTableAccess_ = restrictDirectTableAccess_;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.restrictQueryResult_ = restrictQueryResult_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof com.google.cloud.bigquery.analyticshub.v1.Listing.RestrictedExportConfig) {
          return mergeFrom(
              (com.google.cloud.bigquery.analyticshub.v1.Listing.RestrictedExportConfig) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.bigquery.analyticshub.v1.Listing.RestrictedExportConfig other) {
        if (other
            == com.google.cloud.bigquery.analyticshub.v1.Listing.RestrictedExportConfig
                .getDefaultInstance()) return this;
        if (other.getEnabled() != false) {
          setEnabled(other.getEnabled());
        }
        if (other.getRestrictDirectTableAccess() != false) {
          setRestrictDirectTableAccess(other.getRestrictDirectTableAccess());
        }
        if (other.getRestrictQueryResult() != false) {
          setRestrictQueryResult(other.getRestrictQueryResult());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8:
                {
                  restrictDirectTableAccess_ = input.readBool();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 8
              case 16:
                {
                  restrictQueryResult_ = input.readBool();
                  bitField0_ |= 0x00000004;
                  break;
                } // case 16
              case 24:
                {
                  enabled_ = input.readBool();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 24
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private boolean enabled_;

      /**
       *
       *
       * <pre>
       * Optional. If true, enable restricted export.
       * </pre>
       *
       * <code>bool enabled = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The enabled.
       */
      @java.lang.Override
      public boolean getEnabled() {
        return enabled_;
      }

      /**
       *
       *
       * <pre>
       * Optional. If true, enable restricted export.
       * </pre>
       *
       * <code>bool enabled = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The enabled to set.
       * @return This builder for chaining.
       */
      public Builder setEnabled(boolean value) {

        enabled_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. If true, enable restricted export.
       * </pre>
       *
       * <code>bool enabled = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearEnabled() {
        bitField0_ = (bitField0_ & ~0x00000001);
        enabled_ = false;
        onChanged();
        return this;
      }

      private boolean restrictDirectTableAccess_;

      /**
       *
       *
       * <pre>
       * Output only. If true, restrict direct table access(read
       * api/tabledata.list) on linked table.
       * </pre>
       *
       * <code>bool restrict_direct_table_access = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return The restrictDirectTableAccess.
       */
      @java.lang.Override
      public boolean getRestrictDirectTableAccess() {
        return restrictDirectTableAccess_;
      }

      /**
       *
       *
       * <pre>
       * Output only. If true, restrict direct table access(read
       * api/tabledata.list) on linked table.
       * </pre>
       *
       * <code>bool restrict_direct_table_access = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @param value The restrictDirectTableAccess to set.
       * @return This builder for chaining.
       */
      public Builder setRestrictDirectTableAccess(boolean value) {

        restrictDirectTableAccess_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Output only. If true, restrict direct table access(read
       * api/tabledata.list) on linked table.
       * </pre>
       *
       * <code>bool restrict_direct_table_access = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearRestrictDirectTableAccess() {
        bitField0_ = (bitField0_ & ~0x00000002);
        restrictDirectTableAccess_ = false;
        onChanged();
        return this;
      }

      private boolean restrictQueryResult_;

      /**
       *
       *
       * <pre>
       * Optional. If true, restrict export of query result derived from
       * restricted linked dataset table.
       * </pre>
       *
       * <code>bool restrict_query_result = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The restrictQueryResult.
       */
      @java.lang.Override
      public boolean getRestrictQueryResult() {
        return restrictQueryResult_;
      }

      /**
       *
       *
       * <pre>
       * Optional. If true, restrict export of query result derived from
       * restricted linked dataset table.
       * </pre>
       *
       * <code>bool restrict_query_result = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The restrictQueryResult to set.
       * @return This builder for chaining.
       */
      public Builder setRestrictQueryResult(boolean value) {

        restrictQueryResult_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. If true, restrict export of query result derived from
       * restricted linked dataset table.
       * </pre>
       *
       * <code>bool restrict_query_result = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearRestrictQueryResult() {
        bitField0_ = (bitField0_ & ~0x00000004);
        restrictQueryResult_ = false;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.bigquery.analyticshub.v1.Listing.RestrictedExportConfig)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.bigquery.analyticshub.v1.Listing.RestrictedExportConfig)
    private static final com.google.cloud.bigquery.analyticshub.v1.Listing.RestrictedExportConfig
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.bigquery.analyticshub.v1.Listing.RestrictedExportConfig();
    }

    public static com.google.cloud.bigquery.analyticshub.v1.Listing.RestrictedExportConfig
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<RestrictedExportConfig> PARSER =
        new com.google.protobuf.AbstractParser<RestrictedExportConfig>() {
          @java.lang.Override
          public RestrictedExportConfig parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<RestrictedExportConfig> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<RestrictedExportConfig> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.bigquery.analyticshub.v1.Listing.RestrictedExportConfig
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface CommercialInfoOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.bigquery.analyticshub.v1.Listing.CommercialInfo)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Output only. Details of the Marketplace Data Product associated with the
     * Listing.
     * </pre>
     *
     * <code>
     * optional .google.cloud.bigquery.analyticshub.v1.Listing.CommercialInfo.GoogleCloudMarketplaceInfo cloud_marketplace = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the cloudMarketplace field is set.
     */
    boolean hasCloudMarketplace();

    /**
     *
     *
     * <pre>
     * Output only. Details of the Marketplace Data Product associated with the
     * Listing.
     * </pre>
     *
     * <code>
     * optional .google.cloud.bigquery.analyticshub.v1.Listing.CommercialInfo.GoogleCloudMarketplaceInfo cloud_marketplace = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The cloudMarketplace.
     */
    com.google.cloud.bigquery.analyticshub.v1.Listing.CommercialInfo.GoogleCloudMarketplaceInfo
        getCloudMarketplace();

    /**
     *
     *
     * <pre>
     * Output only. Details of the Marketplace Data Product associated with the
     * Listing.
     * </pre>
     *
     * <code>
     * optional .google.cloud.bigquery.analyticshub.v1.Listing.CommercialInfo.GoogleCloudMarketplaceInfo cloud_marketplace = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    com.google.cloud.bigquery.analyticshub.v1.Listing.CommercialInfo
            .GoogleCloudMarketplaceInfoOrBuilder
        getCloudMarketplaceOrBuilder();
  }

  /**
   *
   *
   * <pre>
   * Commercial info contains the information about the commercial data products
   * associated with the listing.
   * </pre>
   *
   * Protobuf type {@code google.cloud.bigquery.analyticshub.v1.Listing.CommercialInfo}
   */
  public static final class CommercialInfo extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.bigquery.analyticshub.v1.Listing.CommercialInfo)
      CommercialInfoOrBuilder {
    private static final long serialVersionUID = 0L;

    // Use CommercialInfo.newBuilder() to construct.
    private CommercialInfo(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private CommercialInfo() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new CommercialInfo();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.bigquery.analyticshub.v1.AnalyticsHubProto
          .internal_static_google_cloud_bigquery_analyticshub_v1_Listing_CommercialInfo_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.bigquery.analyticshub.v1.AnalyticsHubProto
          .internal_static_google_cloud_bigquery_analyticshub_v1_Listing_CommercialInfo_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.bigquery.analyticshub.v1.Listing.CommercialInfo.class,
              com.google.cloud.bigquery.analyticshub.v1.Listing.CommercialInfo.Builder.class);
    }

    public interface GoogleCloudMarketplaceInfoOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.bigquery.analyticshub.v1.Listing.CommercialInfo.GoogleCloudMarketplaceInfo)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * Output only. Resource name of the commercial service associated with
       * the Marketplace Data Product. e.g. example.com
       * </pre>
       *
       * <code>
       * optional string service = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return Whether the service field is set.
       */
      boolean hasService();

      /**
       *
       *
       * <pre>
       * Output only. Resource name of the commercial service associated with
       * the Marketplace Data Product. e.g. example.com
       * </pre>
       *
       * <code>
       * optional string service = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return The service.
       */
      java.lang.String getService();

      /**
       *
       *
       * <pre>
       * Output only. Resource name of the commercial service associated with
       * the Marketplace Data Product. e.g. example.com
       * </pre>
       *
       * <code>
       * optional string service = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return The bytes for service.
       */
      com.google.protobuf.ByteString getServiceBytes();

      /**
       *
       *
       * <pre>
       * Output only. Commercial state of the Marketplace Data Product.
       * </pre>
       *
       * <code>
       * optional .google.cloud.bigquery.analyticshub.v1.Listing.CommercialInfo.GoogleCloudMarketplaceInfo.CommercialState commercial_state = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return Whether the commercialState field is set.
       */
      boolean hasCommercialState();

      /**
       *
       *
       * <pre>
       * Output only. Commercial state of the Marketplace Data Product.
       * </pre>
       *
       * <code>
       * optional .google.cloud.bigquery.analyticshub.v1.Listing.CommercialInfo.GoogleCloudMarketplaceInfo.CommercialState commercial_state = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return The enum numeric value on the wire for commercialState.
       */
      int getCommercialStateValue();

      /**
       *
       *
       * <pre>
       * Output only. Commercial state of the Marketplace Data Product.
       * </pre>
       *
       * <code>
       * optional .google.cloud.bigquery.analyticshub.v1.Listing.CommercialInfo.GoogleCloudMarketplaceInfo.CommercialState commercial_state = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return The commercialState.
       */
      com.google.cloud.bigquery.analyticshub.v1.Listing.CommercialInfo.GoogleCloudMarketplaceInfo
              .CommercialState
          getCommercialState();
    }

    /**
     *
     *
     * <pre>
     * Specifies the details of the Marketplace Data Product associated with the
     * Listing.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.bigquery.analyticshub.v1.Listing.CommercialInfo.GoogleCloudMarketplaceInfo}
     */
    public static final class GoogleCloudMarketplaceInfo
        extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.bigquery.analyticshub.v1.Listing.CommercialInfo.GoogleCloudMarketplaceInfo)
        GoogleCloudMarketplaceInfoOrBuilder {
      private static final long serialVersionUID = 0L;

      // Use GoogleCloudMarketplaceInfo.newBuilder() to construct.
      private GoogleCloudMarketplaceInfo(
          com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private GoogleCloudMarketplaceInfo() {
        service_ = "";
        commercialState_ = 0;
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new GoogleCloudMarketplaceInfo();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.bigquery.analyticshub.v1.AnalyticsHubProto
            .internal_static_google_cloud_bigquery_analyticshub_v1_Listing_CommercialInfo_GoogleCloudMarketplaceInfo_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.bigquery.analyticshub.v1.AnalyticsHubProto
            .internal_static_google_cloud_bigquery_analyticshub_v1_Listing_CommercialInfo_GoogleCloudMarketplaceInfo_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.bigquery.analyticshub.v1.Listing.CommercialInfo
                    .GoogleCloudMarketplaceInfo.class,
                com.google.cloud.bigquery.analyticshub.v1.Listing.CommercialInfo
                    .GoogleCloudMarketplaceInfo.Builder.class);
      }

      /**
       *
       *
       * <pre>
       * Indicates whether this commercial access is currently active.
       * </pre>
       *
       * Protobuf enum {@code
       * google.cloud.bigquery.analyticshub.v1.Listing.CommercialInfo.GoogleCloudMarketplaceInfo.CommercialState}
       */
      public enum CommercialState implements com.google.protobuf.ProtocolMessageEnum {
        /**
         *
         *
         * <pre>
         * Commercialization is incomplete and cannot be used.
         * </pre>
         *
         * <code>COMMERCIAL_STATE_UNSPECIFIED = 0;</code>
         */
        COMMERCIAL_STATE_UNSPECIFIED(0),
        /**
         *
         *
         * <pre>
         * Commercialization has been initialized.
         * </pre>
         *
         * <code>ONBOARDING = 1;</code>
         */
        ONBOARDING(1),
        /**
         *
         *
         * <pre>
         * Commercialization is complete and available for use.
         * </pre>
         *
         * <code>ACTIVE = 2;</code>
         */
        ACTIVE(2),
        UNRECOGNIZED(-1),
        ;

        /**
         *
         *
         * <pre>
         * Commercialization is incomplete and cannot be used.
         * </pre>
         *
         * <code>COMMERCIAL_STATE_UNSPECIFIED = 0;</code>
         */
        public static final int COMMERCIAL_STATE_UNSPECIFIED_VALUE = 0;

        /**
         *
         *
         * <pre>
         * Commercialization has been initialized.
         * </pre>
         *
         * <code>ONBOARDING = 1;</code>
         */
        public static final int ONBOARDING_VALUE = 1;

        /**
         *
         *
         * <pre>
         * Commercialization is complete and available for use.
         * </pre>
         *
         * <code>ACTIVE = 2;</code>
         */
        public static final int ACTIVE_VALUE = 2;

        public final int getNumber() {
          if (this == UNRECOGNIZED) {
            throw new java.lang.IllegalArgumentException(
                "Can't get the number of an unknown enum value.");
          }
          return value;
        }

        /**
         * @param value The numeric wire value of the corresponding enum entry.
         * @return The enum associated with the given numeric wire value.
         * @deprecated Use {@link #forNumber(int)} instead.
         */
        @java.lang.Deprecated
        public static CommercialState valueOf(int value) {
          return forNumber(value);
        }

        /**
         * @param value The numeric wire value of the corresponding enum entry.
         * @return The enum associated with the given numeric wire value.
         */
        public static CommercialState forNumber(int value) {
          switch (value) {
            case 0:
              return COMMERCIAL_STATE_UNSPECIFIED;
            case 1:
              return ONBOARDING;
            case 2:
              return ACTIVE;
            default:
              return null;
          }
        }

        public static com.google.protobuf.Internal.EnumLiteMap<CommercialState>
            internalGetValueMap() {
          return internalValueMap;
        }

        private static final com.google.protobuf.Internal.EnumLiteMap<CommercialState>
            internalValueMap =
                new com.google.protobuf.Internal.EnumLiteMap<CommercialState>() {
                  public CommercialState findValueByNumber(int number) {
                    return CommercialState.forNumber(number);
                  }
                };

        public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
          if (this == UNRECOGNIZED) {
            throw new java.lang.IllegalStateException(
                "Can't get the descriptor of an unrecognized enum value.");
          }
          return getDescriptor().getValues().get(ordinal());
        }

        public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
          return getDescriptor();
        }

        public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
          return com.google.cloud.bigquery.analyticshub.v1.Listing.CommercialInfo
              .GoogleCloudMarketplaceInfo.getDescriptor()
              .getEnumTypes()
              .get(0);
        }

        private static final CommercialState[] VALUES = values();

        public static CommercialState valueOf(
            com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
          if (desc.getType() != getDescriptor()) {
            throw new java.lang.IllegalArgumentException(
                "EnumValueDescriptor is not for this type.");
          }
          if (desc.getIndex() == -1) {
            return UNRECOGNIZED;
          }
          return VALUES[desc.getIndex()];
        }

        private final int value;

        private CommercialState(int value) {
          this.value = value;
        }

        // @@protoc_insertion_point(enum_scope:google.cloud.bigquery.analyticshub.v1.Listing.CommercialInfo.GoogleCloudMarketplaceInfo.CommercialState)
      }

      private int bitField0_;
      public static final int SERVICE_FIELD_NUMBER = 1;

      @SuppressWarnings("serial")
      private volatile java.lang.Object service_ = "";

      /**
       *
       *
       * <pre>
       * Output only. Resource name of the commercial service associated with
       * the Marketplace Data Product. e.g. example.com
       * </pre>
       *
       * <code>
       * optional string service = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return Whether the service field is set.
       */
      @java.lang.Override
      public boolean hasService() {
        return ((bitField0_ & 0x00000001) != 0);
      }

      /**
       *
       *
       * <pre>
       * Output only. Resource name of the commercial service associated with
       * the Marketplace Data Product. e.g. example.com
       * </pre>
       *
       * <code>
       * optional string service = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return The service.
       */
      @java.lang.Override
      public java.lang.String getService() {
        java.lang.Object ref = service_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          service_ = s;
          return s;
        }
      }

      /**
       *
       *
       * <pre>
       * Output only. Resource name of the commercial service associated with
       * the Marketplace Data Product. e.g. example.com
       * </pre>
       *
       * <code>
       * optional string service = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return The bytes for service.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getServiceBytes() {
        java.lang.Object ref = service_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          service_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      public static final int COMMERCIAL_STATE_FIELD_NUMBER = 3;
      private int commercialState_ = 0;

      /**
       *
       *
       * <pre>
       * Output only. Commercial state of the Marketplace Data Product.
       * </pre>
       *
       * <code>
       * optional .google.cloud.bigquery.analyticshub.v1.Listing.CommercialInfo.GoogleCloudMarketplaceInfo.CommercialState commercial_state = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return Whether the commercialState field is set.
       */
      @java.lang.Override
      public boolean hasCommercialState() {
        return ((bitField0_ & 0x00000002) != 0);
      }

      /**
       *
       *
       * <pre>
       * Output only. Commercial state of the Marketplace Data Product.
       * </pre>
       *
       * <code>
       * optional .google.cloud.bigquery.analyticshub.v1.Listing.CommercialInfo.GoogleCloudMarketplaceInfo.CommercialState commercial_state = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return The enum numeric value on the wire for commercialState.
       */
      @java.lang.Override
      public int getCommercialStateValue() {
        return commercialState_;
      }

      /**
       *
       *
       * <pre>
       * Output only. Commercial state of the Marketplace Data Product.
       * </pre>
       *
       * <code>
       * optional .google.cloud.bigquery.analyticshub.v1.Listing.CommercialInfo.GoogleCloudMarketplaceInfo.CommercialState commercial_state = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return The commercialState.
       */
      @java.lang.Override
      public com.google.cloud.bigquery.analyticshub.v1.Listing.CommercialInfo
              .GoogleCloudMarketplaceInfo.CommercialState
          getCommercialState() {
        com.google.cloud.bigquery.analyticshub.v1.Listing.CommercialInfo.GoogleCloudMarketplaceInfo
                .CommercialState
            result =
                com.google.cloud.bigquery.analyticshub.v1.Listing.CommercialInfo
                    .GoogleCloudMarketplaceInfo.CommercialState.forNumber(commercialState_);
        return result == null
            ? com.google.cloud.bigquery.analyticshub.v1.Listing.CommercialInfo
                .GoogleCloudMarketplaceInfo.CommercialState.UNRECOGNIZED
            : result;
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (((bitField0_ & 0x00000001) != 0)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 1, service_);
        }
        if (((bitField0_ & 0x00000002) != 0)) {
          output.writeEnum(3, commercialState_);
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (((bitField0_ & 0x00000001) != 0)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, service_);
        }
        if (((bitField0_ & 0x00000002) != 0)) {
          size += com.google.protobuf.CodedOutputStream.computeEnumSize(3, commercialState_);
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj
            instanceof
            com.google.cloud.bigquery.analyticshub.v1.Listing.CommercialInfo
                .GoogleCloudMarketplaceInfo)) {
          return super.equals(obj);
        }
        com.google.cloud.bigquery.analyticshub.v1.Listing.CommercialInfo.GoogleCloudMarketplaceInfo
            other =
                (com.google.cloud.bigquery.analyticshub.v1.Listing.CommercialInfo
                        .GoogleCloudMarketplaceInfo)
                    obj;

        if (hasService() != other.hasService()) return false;
        if (hasService()) {
          if (!getService().equals(other.getService())) return false;
        }
        if (hasCommercialState() != other.hasCommercialState()) return false;
        if (hasCommercialState()) {
          if (commercialState_ != other.commercialState_) return false;
        }
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        if (hasService()) {
          hash = (37 * hash) + SERVICE_FIELD_NUMBER;
          hash = (53 * hash) + getService().hashCode();
        }
        if (hasCommercialState()) {
          hash = (37 * hash) + COMMERCIAL_STATE_FIELD_NUMBER;
          hash = (53 * hash) + commercialState_;
        }
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.bigquery.analyticshub.v1.Listing.CommercialInfo
              .GoogleCloudMarketplaceInfo
          parseFrom(java.nio.ByteBuffer data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.bigquery.analyticshub.v1.Listing.CommercialInfo
              .GoogleCloudMarketplaceInfo
          parseFrom(
              java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.bigquery.analyticshub.v1.Listing.CommercialInfo
              .GoogleCloudMarketplaceInfo
          parseFrom(com.google.protobuf.ByteString data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.bigquery.analyticshub.v1.Listing.CommercialInfo
              .GoogleCloudMarketplaceInfo
          parseFrom(
              com.google.protobuf.ByteString data,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.bigquery.analyticshub.v1.Listing.CommercialInfo
              .GoogleCloudMarketplaceInfo
          parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.bigquery.analyticshub.v1.Listing.CommercialInfo
              .GoogleCloudMarketplaceInfo
          parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.bigquery.analyticshub.v1.Listing.CommercialInfo
              .GoogleCloudMarketplaceInfo
          parseFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.bigquery.analyticshub.v1.Listing.CommercialInfo
              .GoogleCloudMarketplaceInfo
          parseFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.bigquery.analyticshub.v1.Listing.CommercialInfo
              .GoogleCloudMarketplaceInfo
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.bigquery.analyticshub.v1.Listing.CommercialInfo
              .GoogleCloudMarketplaceInfo
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.bigquery.analyticshub.v1.Listing.CommercialInfo
              .GoogleCloudMarketplaceInfo
          parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.bigquery.analyticshub.v1.Listing.CommercialInfo
              .GoogleCloudMarketplaceInfo
          parseFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.bigquery.analyticshub.v1.Listing.CommercialInfo
                  .GoogleCloudMarketplaceInfo
              prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }

      /**
       *
       *
       * <pre>
       * Specifies the details of the Marketplace Data Product associated with the
       * Listing.
       * </pre>
       *
       * Protobuf type {@code
       * google.cloud.bigquery.analyticshub.v1.Listing.CommercialInfo.GoogleCloudMarketplaceInfo}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.bigquery.analyticshub.v1.Listing.CommercialInfo.GoogleCloudMarketplaceInfo)
          com.google.cloud.bigquery.analyticshub.v1.Listing.CommercialInfo
              .GoogleCloudMarketplaceInfoOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.bigquery.analyticshub.v1.AnalyticsHubProto
              .internal_static_google_cloud_bigquery_analyticshub_v1_Listing_CommercialInfo_GoogleCloudMarketplaceInfo_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.bigquery.analyticshub.v1.AnalyticsHubProto
              .internal_static_google_cloud_bigquery_analyticshub_v1_Listing_CommercialInfo_GoogleCloudMarketplaceInfo_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.bigquery.analyticshub.v1.Listing.CommercialInfo
                      .GoogleCloudMarketplaceInfo.class,
                  com.google.cloud.bigquery.analyticshub.v1.Listing.CommercialInfo
                      .GoogleCloudMarketplaceInfo.Builder.class);
        }

        // Construct using
        // com.google.cloud.bigquery.analyticshub.v1.Listing.CommercialInfo.GoogleCloudMarketplaceInfo.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          service_ = "";
          commercialState_ = 0;
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.bigquery.analyticshub.v1.AnalyticsHubProto
              .internal_static_google_cloud_bigquery_analyticshub_v1_Listing_CommercialInfo_GoogleCloudMarketplaceInfo_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.bigquery.analyticshub.v1.Listing.CommercialInfo
                .GoogleCloudMarketplaceInfo
            getDefaultInstanceForType() {
          return com.google.cloud.bigquery.analyticshub.v1.Listing.CommercialInfo
              .GoogleCloudMarketplaceInfo.getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.bigquery.analyticshub.v1.Listing.CommercialInfo
                .GoogleCloudMarketplaceInfo
            build() {
          com.google.cloud.bigquery.analyticshub.v1.Listing.CommercialInfo
                  .GoogleCloudMarketplaceInfo
              result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.bigquery.analyticshub.v1.Listing.CommercialInfo
                .GoogleCloudMarketplaceInfo
            buildPartial() {
          com.google.cloud.bigquery.analyticshub.v1.Listing.CommercialInfo
                  .GoogleCloudMarketplaceInfo
              result =
                  new com.google.cloud.bigquery.analyticshub.v1.Listing.CommercialInfo
                      .GoogleCloudMarketplaceInfo(this);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          onBuilt();
          return result;
        }

        private void buildPartial0(
            com.google.cloud.bigquery.analyticshub.v1.Listing.CommercialInfo
                    .GoogleCloudMarketplaceInfo
                result) {
          int from_bitField0_ = bitField0_;
          int to_bitField0_ = 0;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            result.service_ = service_;
            to_bitField0_ |= 0x00000001;
          }
          if (((from_bitField0_ & 0x00000002) != 0)) {
            result.commercialState_ = commercialState_;
            to_bitField0_ |= 0x00000002;
          }
          result.bitField0_ |= to_bitField0_;
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other
              instanceof
              com.google.cloud.bigquery.analyticshub.v1.Listing.CommercialInfo
                  .GoogleCloudMarketplaceInfo) {
            return mergeFrom(
                (com.google.cloud.bigquery.analyticshub.v1.Listing.CommercialInfo
                        .GoogleCloudMarketplaceInfo)
                    other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.cloud.bigquery.analyticshub.v1.Listing.CommercialInfo
                    .GoogleCloudMarketplaceInfo
                other) {
          if (other
              == com.google.cloud.bigquery.analyticshub.v1.Listing.CommercialInfo
                  .GoogleCloudMarketplaceInfo.getDefaultInstance()) return this;
          if (other.hasService()) {
            service_ = other.service_;
            bitField0_ |= 0x00000001;
            onChanged();
          }
          if (other.hasCommercialState()) {
            setCommercialState(other.getCommercialState());
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 10:
                  {
                    service_ = input.readStringRequireUtf8();
                    bitField0_ |= 0x00000001;
                    break;
                  } // case 10
                case 24:
                  {
                    commercialState_ = input.readEnum();
                    bitField0_ |= 0x00000002;
                    break;
                  } // case 24
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int bitField0_;

        private java.lang.Object service_ = "";

        /**
         *
         *
         * <pre>
         * Output only. Resource name of the commercial service associated with
         * the Marketplace Data Product. e.g. example.com
         * </pre>
         *
         * <code>
         * optional string service = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
         * </code>
         *
         * @return Whether the service field is set.
         */
        public boolean hasService() {
          return ((bitField0_ & 0x00000001) != 0);
        }

        /**
         *
         *
         * <pre>
         * Output only. Resource name of the commercial service associated with
         * the Marketplace Data Product. e.g. example.com
         * </pre>
         *
         * <code>
         * optional string service = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
         * </code>
         *
         * @return The service.
         */
        public java.lang.String getService() {
          java.lang.Object ref = service_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            service_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }

        /**
         *
         *
         * <pre>
         * Output only. Resource name of the commercial service associated with
         * the Marketplace Data Product. e.g. example.com
         * </pre>
         *
         * <code>
         * optional string service = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
         * </code>
         *
         * @return The bytes for service.
         */
        public com.google.protobuf.ByteString getServiceBytes() {
          java.lang.Object ref = service_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            service_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }

        /**
         *
         *
         * <pre>
         * Output only. Resource name of the commercial service associated with
         * the Marketplace Data Product. e.g. example.com
         * </pre>
         *
         * <code>
         * optional string service = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
         * </code>
         *
         * @param value The service to set.
         * @return This builder for chaining.
         */
        public Builder setService(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          service_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * Output only. Resource name of the commercial service associated with
         * the Marketplace Data Product. e.g. example.com
         * </pre>
         *
         * <code>
         * optional string service = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
         * </code>
         *
         * @return This builder for chaining.
         */
        public Builder clearService() {
          service_ = getDefaultInstance().getService();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * Output only. Resource name of the commercial service associated with
         * the Marketplace Data Product. e.g. example.com
         * </pre>
         *
         * <code>
         * optional string service = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
         * </code>
         *
         * @param value The bytes for service to set.
         * @return This builder for chaining.
         */
        public Builder setServiceBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          service_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }

        private int commercialState_ = 0;

        /**
         *
         *
         * <pre>
         * Output only. Commercial state of the Marketplace Data Product.
         * </pre>
         *
         * <code>
         * optional .google.cloud.bigquery.analyticshub.v1.Listing.CommercialInfo.GoogleCloudMarketplaceInfo.CommercialState commercial_state = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
         * </code>
         *
         * @return Whether the commercialState field is set.
         */
        @java.lang.Override
        public boolean hasCommercialState() {
          return ((bitField0_ & 0x00000002) != 0);
        }

        /**
         *
         *
         * <pre>
         * Output only. Commercial state of the Marketplace Data Product.
         * </pre>
         *
         * <code>
         * optional .google.cloud.bigquery.analyticshub.v1.Listing.CommercialInfo.GoogleCloudMarketplaceInfo.CommercialState commercial_state = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
         * </code>
         *
         * @return The enum numeric value on the wire for commercialState.
         */
        @java.lang.Override
        public int getCommercialStateValue() {
          return commercialState_;
        }

        /**
         *
         *
         * <pre>
         * Output only. Commercial state of the Marketplace Data Product.
         * </pre>
         *
         * <code>
         * optional .google.cloud.bigquery.analyticshub.v1.Listing.CommercialInfo.GoogleCloudMarketplaceInfo.CommercialState commercial_state = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
         * </code>
         *
         * @param value The enum numeric value on the wire for commercialState to set.
         * @return This builder for chaining.
         */
        public Builder setCommercialStateValue(int value) {
          commercialState_ = value;
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * Output only. Commercial state of the Marketplace Data Product.
         * </pre>
         *
         * <code>
         * optional .google.cloud.bigquery.analyticshub.v1.Listing.CommercialInfo.GoogleCloudMarketplaceInfo.CommercialState commercial_state = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
         * </code>
         *
         * @return The commercialState.
         */
        @java.lang.Override
        public com.google.cloud.bigquery.analyticshub.v1.Listing.CommercialInfo
                .GoogleCloudMarketplaceInfo.CommercialState
            getCommercialState() {
          com.google.cloud.bigquery.analyticshub.v1.Listing.CommercialInfo
                  .GoogleCloudMarketplaceInfo.CommercialState
              result =
                  com.google.cloud.bigquery.analyticshub.v1.Listing.CommercialInfo
                      .GoogleCloudMarketplaceInfo.CommercialState.forNumber(commercialState_);
          return result == null
              ? com.google.cloud.bigquery.analyticshub.v1.Listing.CommercialInfo
                  .GoogleCloudMarketplaceInfo.CommercialState.UNRECOGNIZED
              : result;
        }

        /**
         *
         *
         * <pre>
         * Output only. Commercial state of the Marketplace Data Product.
         * </pre>
         *
         * <code>
         * optional .google.cloud.bigquery.analyticshub.v1.Listing.CommercialInfo.GoogleCloudMarketplaceInfo.CommercialState commercial_state = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
         * </code>
         *
         * @param value The commercialState to set.
         * @return This builder for chaining.
         */
        public Builder setCommercialState(
            com.google.cloud.bigquery.analyticshub.v1.Listing.CommercialInfo
                    .GoogleCloudMarketplaceInfo.CommercialState
                value) {
          if (value == null) {
            throw new NullPointerException();
          }
          bitField0_ |= 0x00000002;
          commercialState_ = value.getNumber();
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * Output only. Commercial state of the Marketplace Data Product.
         * </pre>
         *
         * <code>
         * optional .google.cloud.bigquery.analyticshub.v1.Listing.CommercialInfo.GoogleCloudMarketplaceInfo.CommercialState commercial_state = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
         * </code>
         *
         * @return This builder for chaining.
         */
        public Builder clearCommercialState() {
          bitField0_ = (bitField0_ & ~0x00000002);
          commercialState_ = 0;
          onChanged();
          return this;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.bigquery.analyticshub.v1.Listing.CommercialInfo.GoogleCloudMarketplaceInfo)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.bigquery.analyticshub.v1.Listing.CommercialInfo.GoogleCloudMarketplaceInfo)
      private static final com.google.cloud.bigquery.analyticshub.v1.Listing.CommercialInfo
              .GoogleCloudMarketplaceInfo
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE =
            new com.google.cloud.bigquery.analyticshub.v1.Listing.CommercialInfo
                .GoogleCloudMarketplaceInfo();
      }

      public static com.google.cloud.bigquery.analyticshub.v1.Listing.CommercialInfo
              .GoogleCloudMarketplaceInfo
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<GoogleCloudMarketplaceInfo> PARSER =
          new com.google.protobuf.AbstractParser<GoogleCloudMarketplaceInfo>() {
            @java.lang.Override
            public GoogleCloudMarketplaceInfo parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<GoogleCloudMarketplaceInfo> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<GoogleCloudMarketplaceInfo> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.bigquery.analyticshub.v1.Listing.CommercialInfo
              .GoogleCloudMarketplaceInfo
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    private int bitField0_;
    public static final int CLOUD_MARKETPLACE_FIELD_NUMBER = 1;
    private com.google.cloud.bigquery.analyticshub.v1.Listing.CommercialInfo
            .GoogleCloudMarketplaceInfo
        cloudMarketplace_;

    /**
     *
     *
     * <pre>
     * Output only. Details of the Marketplace Data Product associated with the
     * Listing.
     * </pre>
     *
     * <code>
     * optional .google.cloud.bigquery.analyticshub.v1.Listing.CommercialInfo.GoogleCloudMarketplaceInfo cloud_marketplace = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the cloudMarketplace field is set.
     */
    @java.lang.Override
    public boolean hasCloudMarketplace() {
      return ((bitField0_ & 0x00000001) != 0);
    }

    /**
     *
     *
     * <pre>
     * Output only. Details of the Marketplace Data Product associated with the
     * Listing.
     * </pre>
     *
     * <code>
     * optional .google.cloud.bigquery.analyticshub.v1.Listing.CommercialInfo.GoogleCloudMarketplaceInfo cloud_marketplace = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The cloudMarketplace.
     */
    @java.lang.Override
    public com.google.cloud.bigquery.analyticshub.v1.Listing.CommercialInfo
            .GoogleCloudMarketplaceInfo
        getCloudMarketplace() {
      return cloudMarketplace_ == null
          ? com.google.cloud.bigquery.analyticshub.v1.Listing.CommercialInfo
              .GoogleCloudMarketplaceInfo.getDefaultInstance()
          : cloudMarketplace_;
    }

    /**
     *
     *
     * <pre>
     * Output only. Details of the Marketplace Data Product associated with the
     * Listing.
     * </pre>
     *
     * <code>
     * optional .google.cloud.bigquery.analyticshub.v1.Listing.CommercialInfo.GoogleCloudMarketplaceInfo cloud_marketplace = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.bigquery.analyticshub.v1.Listing.CommercialInfo
            .GoogleCloudMarketplaceInfoOrBuilder
        getCloudMarketplaceOrBuilder() {
      return cloudMarketplace_ == null
          ? com.google.cloud.bigquery.analyticshub.v1.Listing.CommercialInfo
              .GoogleCloudMarketplaceInfo.getDefaultInstance()
          : cloudMarketplace_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(1, getCloudMarketplace());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getCloudMarketplace());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.bigquery.analyticshub.v1.Listing.CommercialInfo)) {
        return super.equals(obj);
      }
      com.google.cloud.bigquery.analyticshub.v1.Listing.CommercialInfo other =
          (com.google.cloud.bigquery.analyticshub.v1.Listing.CommercialInfo) obj;

      if (hasCloudMarketplace() != other.hasCloudMarketplace()) return false;
      if (hasCloudMarketplace()) {
        if (!getCloudMarketplace().equals(other.getCloudMarketplace())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasCloudMarketplace()) {
        hash = (37 * hash) + CLOUD_MARKETPLACE_FIELD_NUMBER;
        hash = (53 * hash) + getCloudMarketplace().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.bigquery.analyticshub.v1.Listing.CommercialInfo parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.bigquery.analyticshub.v1.Listing.CommercialInfo parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.bigquery.analyticshub.v1.Listing.CommercialInfo parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.bigquery.analyticshub.v1.Listing.CommercialInfo parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.bigquery.analyticshub.v1.Listing.CommercialInfo parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.bigquery.analyticshub.v1.Listing.CommercialInfo parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.bigquery.analyticshub.v1.Listing.CommercialInfo parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.bigquery.analyticshub.v1.Listing.CommercialInfo parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.bigquery.analyticshub.v1.Listing.CommercialInfo
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.bigquery.analyticshub.v1.Listing.CommercialInfo
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.bigquery.analyticshub.v1.Listing.CommercialInfo parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.bigquery.analyticshub.v1.Listing.CommercialInfo parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.bigquery.analyticshub.v1.Listing.CommercialInfo prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * Commercial info contains the information about the commercial data products
     * associated with the listing.
     * </pre>
     *
     * Protobuf type {@code google.cloud.bigquery.analyticshub.v1.Listing.CommercialInfo}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.bigquery.analyticshub.v1.Listing.CommercialInfo)
        com.google.cloud.bigquery.analyticshub.v1.Listing.CommercialInfoOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.bigquery.analyticshub.v1.AnalyticsHubProto
            .internal_static_google_cloud_bigquery_analyticshub_v1_Listing_CommercialInfo_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.bigquery.analyticshub.v1.AnalyticsHubProto
            .internal_static_google_cloud_bigquery_analyticshub_v1_Listing_CommercialInfo_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.bigquery.analyticshub.v1.Listing.CommercialInfo.class,
                com.google.cloud.bigquery.analyticshub.v1.Listing.CommercialInfo.Builder.class);
      }

      // Construct using
      // com.google.cloud.bigquery.analyticshub.v1.Listing.CommercialInfo.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getCloudMarketplaceFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        cloudMarketplace_ = null;
        if (cloudMarketplaceBuilder_ != null) {
          cloudMarketplaceBuilder_.dispose();
          cloudMarketplaceBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.bigquery.analyticshub.v1.AnalyticsHubProto
            .internal_static_google_cloud_bigquery_analyticshub_v1_Listing_CommercialInfo_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.bigquery.analyticshub.v1.Listing.CommercialInfo
          getDefaultInstanceForType() {
        return com.google.cloud.bigquery.analyticshub.v1.Listing.CommercialInfo
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.bigquery.analyticshub.v1.Listing.CommercialInfo build() {
        com.google.cloud.bigquery.analyticshub.v1.Listing.CommercialInfo result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.bigquery.analyticshub.v1.Listing.CommercialInfo buildPartial() {
        com.google.cloud.bigquery.analyticshub.v1.Listing.CommercialInfo result =
            new com.google.cloud.bigquery.analyticshub.v1.Listing.CommercialInfo(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.bigquery.analyticshub.v1.Listing.CommercialInfo result) {
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.cloudMarketplace_ =
              cloudMarketplaceBuilder_ == null
                  ? cloudMarketplace_
                  : cloudMarketplaceBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.bigquery.analyticshub.v1.Listing.CommercialInfo) {
          return mergeFrom(
              (com.google.cloud.bigquery.analyticshub.v1.Listing.CommercialInfo) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.bigquery.analyticshub.v1.Listing.CommercialInfo other) {
        if (other
            == com.google.cloud.bigquery.analyticshub.v1.Listing.CommercialInfo
                .getDefaultInstance()) return this;
        if (other.hasCloudMarketplace()) {
          mergeCloudMarketplace(other.getCloudMarketplace());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  input.readMessage(
                      getCloudMarketplaceFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private com.google.cloud.bigquery.analyticshub.v1.Listing.CommercialInfo
              .GoogleCloudMarketplaceInfo
          cloudMarketplace_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.bigquery.analyticshub.v1.Listing.CommercialInfo
                  .GoogleCloudMarketplaceInfo,
              com.google.cloud.bigquery.analyticshub.v1.Listing.CommercialInfo
                  .GoogleCloudMarketplaceInfo.Builder,
              com.google.cloud.bigquery.analyticshub.v1.Listing.CommercialInfo
                  .GoogleCloudMarketplaceInfoOrBuilder>
          cloudMarketplaceBuilder_;

      /**
       *
       *
       * <pre>
       * Output only. Details of the Marketplace Data Product associated with the
       * Listing.
       * </pre>
       *
       * <code>
       * optional .google.cloud.bigquery.analyticshub.v1.Listing.CommercialInfo.GoogleCloudMarketplaceInfo cloud_marketplace = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return Whether the cloudMarketplace field is set.
       */
      public boolean hasCloudMarketplace() {
        return ((bitField0_ & 0x00000001) != 0);
      }

      /**
       *
       *
       * <pre>
       * Output only. Details of the Marketplace Data Product associated with the
       * Listing.
       * </pre>
       *
       * <code>
       * optional .google.cloud.bigquery.analyticshub.v1.Listing.CommercialInfo.GoogleCloudMarketplaceInfo cloud_marketplace = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return The cloudMarketplace.
       */
      public com.google.cloud.bigquery.analyticshub.v1.Listing.CommercialInfo
              .GoogleCloudMarketplaceInfo
          getCloudMarketplace() {
        if (cloudMarketplaceBuilder_ == null) {
          return cloudMarketplace_ == null
              ? com.google.cloud.bigquery.analyticshub.v1.Listing.CommercialInfo
                  .GoogleCloudMarketplaceInfo.getDefaultInstance()
              : cloudMarketplace_;
        } else {
          return cloudMarketplaceBuilder_.getMessage();
        }
      }

      /**
       *
       *
       * <pre>
       * Output only. Details of the Marketplace Data Product associated with the
       * Listing.
       * </pre>
       *
       * <code>
       * optional .google.cloud.bigquery.analyticshub.v1.Listing.CommercialInfo.GoogleCloudMarketplaceInfo cloud_marketplace = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder setCloudMarketplace(
          com.google.cloud.bigquery.analyticshub.v1.Listing.CommercialInfo
                  .GoogleCloudMarketplaceInfo
              value) {
        if (cloudMarketplaceBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          cloudMarketplace_ = value;
        } else {
          cloudMarketplaceBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Output only. Details of the Marketplace Data Product associated with the
       * Listing.
       * </pre>
       *
       * <code>
       * optional .google.cloud.bigquery.analyticshub.v1.Listing.CommercialInfo.GoogleCloudMarketplaceInfo cloud_marketplace = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder setCloudMarketplace(
          com.google.cloud.bigquery.analyticshub.v1.Listing.CommercialInfo
                  .GoogleCloudMarketplaceInfo.Builder
              builderForValue) {
        if (cloudMarketplaceBuilder_ == null) {
          cloudMarketplace_ = builderForValue.build();
        } else {
          cloudMarketplaceBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Output only. Details of the Marketplace Data Product associated with the
       * Listing.
       * </pre>
       *
       * <code>
       * optional .google.cloud.bigquery.analyticshub.v1.Listing.CommercialInfo.GoogleCloudMarketplaceInfo cloud_marketplace = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder mergeCloudMarketplace(
          com.google.cloud.bigquery.analyticshub.v1.Listing.CommercialInfo
                  .GoogleCloudMarketplaceInfo
              value) {
        if (cloudMarketplaceBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)
              && cloudMarketplace_ != null
              && cloudMarketplace_
                  != com.google.cloud.bigquery.analyticshub.v1.Listing.CommercialInfo
                      .GoogleCloudMarketplaceInfo.getDefaultInstance()) {
            getCloudMarketplaceBuilder().mergeFrom(value);
          } else {
            cloudMarketplace_ = value;
          }
        } else {
          cloudMarketplaceBuilder_.mergeFrom(value);
        }
        if (cloudMarketplace_ != null) {
          bitField0_ |= 0x00000001;
          onChanged();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Output only. Details of the Marketplace Data Product associated with the
       * Listing.
       * </pre>
       *
       * <code>
       * optional .google.cloud.bigquery.analyticshub.v1.Listing.CommercialInfo.GoogleCloudMarketplaceInfo cloud_marketplace = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder clearCloudMarketplace() {
        bitField0_ = (bitField0_ & ~0x00000001);
        cloudMarketplace_ = null;
        if (cloudMarketplaceBuilder_ != null) {
          cloudMarketplaceBuilder_.dispose();
          cloudMarketplaceBuilder_ = null;
        }
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Output only. Details of the Marketplace Data Product associated with the
       * Listing.
       * </pre>
       *
       * <code>
       * optional .google.cloud.bigquery.analyticshub.v1.Listing.CommercialInfo.GoogleCloudMarketplaceInfo cloud_marketplace = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public com.google.cloud.bigquery.analyticshub.v1.Listing.CommercialInfo
              .GoogleCloudMarketplaceInfo.Builder
          getCloudMarketplaceBuilder() {
        bitField0_ |= 0x00000001;
        onChanged();
        return getCloudMarketplaceFieldBuilder().getBuilder();
      }

      /**
       *
       *
       * <pre>
       * Output only. Details of the Marketplace Data Product associated with the
       * Listing.
       * </pre>
       *
       * <code>
       * optional .google.cloud.bigquery.analyticshub.v1.Listing.CommercialInfo.GoogleCloudMarketplaceInfo cloud_marketplace = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public com.google.cloud.bigquery.analyticshub.v1.Listing.CommercialInfo
              .GoogleCloudMarketplaceInfoOrBuilder
          getCloudMarketplaceOrBuilder() {
        if (cloudMarketplaceBuilder_ != null) {
          return cloudMarketplaceBuilder_.getMessageOrBuilder();
        } else {
          return cloudMarketplace_ == null
              ? com.google.cloud.bigquery.analyticshub.v1.Listing.CommercialInfo
                  .GoogleCloudMarketplaceInfo.getDefaultInstance()
              : cloudMarketplace_;
        }
      }

      /**
       *
       *
       * <pre>
       * Output only. Details of the Marketplace Data Product associated with the
       * Listing.
       * </pre>
       *
       * <code>
       * optional .google.cloud.bigquery.analyticshub.v1.Listing.CommercialInfo.GoogleCloudMarketplaceInfo cloud_marketplace = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.bigquery.analyticshub.v1.Listing.CommercialInfo
                  .GoogleCloudMarketplaceInfo,
              com.google.cloud.bigquery.analyticshub.v1.Listing.CommercialInfo
                  .GoogleCloudMarketplaceInfo.Builder,
              com.google.cloud.bigquery.analyticshub.v1.Listing.CommercialInfo
                  .GoogleCloudMarketplaceInfoOrBuilder>
          getCloudMarketplaceFieldBuilder() {
        if (cloudMarketplaceBuilder_ == null) {
          cloudMarketplaceBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.bigquery.analyticshub.v1.Listing.CommercialInfo
                      .GoogleCloudMarketplaceInfo,
                  com.google.cloud.bigquery.analyticshub.v1.Listing.CommercialInfo
                      .GoogleCloudMarketplaceInfo.Builder,
                  com.google.cloud.bigquery.analyticshub.v1.Listing.CommercialInfo
                      .GoogleCloudMarketplaceInfoOrBuilder>(
                  getCloudMarketplace(), getParentForChildren(), isClean());
          cloudMarketplace_ = null;
        }
        return cloudMarketplaceBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.bigquery.analyticshub.v1.Listing.CommercialInfo)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.bigquery.analyticshub.v1.Listing.CommercialInfo)
    private static final com.google.cloud.bigquery.analyticshub.v1.Listing.CommercialInfo
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.bigquery.analyticshub.v1.Listing.CommercialInfo();
    }

    public static com.google.cloud.bigquery.analyticshub.v1.Listing.CommercialInfo
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<CommercialInfo> PARSER =
        new com.google.protobuf.AbstractParser<CommercialInfo>() {
          @java.lang.Override
          public CommercialInfo parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<CommercialInfo> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<CommercialInfo> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.bigquery.analyticshub.v1.Listing.CommercialInfo
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int bitField0_;
  private int sourceCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object source_;

  public enum SourceCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    BIGQUERY_DATASET(6),
    PUBSUB_TOPIC(16),
    SOURCE_NOT_SET(0);
    private final int value;

    private SourceCase(int value) {
      this.value = value;
    }

    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static SourceCase valueOf(int value) {
      return forNumber(value);
    }

    public static SourceCase forNumber(int value) {
      switch (value) {
        case 6:
          return BIGQUERY_DATASET;
        case 16:
          return PUBSUB_TOPIC;
        case 0:
          return SOURCE_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public SourceCase getSourceCase() {
    return SourceCase.forNumber(sourceCase_);
  }

  public static final int BIGQUERY_DATASET_FIELD_NUMBER = 6;

  /**
   *
   *
   * <pre>
   * Shared dataset i.e. BigQuery dataset source.
   * </pre>
   *
   * <code>
   * .google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource bigquery_dataset = 6;
   * </code>
   *
   * @return Whether the bigqueryDataset field is set.
   */
  @java.lang.Override
  public boolean hasBigqueryDataset() {
    return sourceCase_ == 6;
  }

  /**
   *
   *
   * <pre>
   * Shared dataset i.e. BigQuery dataset source.
   * </pre>
   *
   * <code>
   * .google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource bigquery_dataset = 6;
   * </code>
   *
   * @return The bigqueryDataset.
   */
  @java.lang.Override
  public com.google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource
      getBigqueryDataset() {
    if (sourceCase_ == 6) {
      return (com.google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource) source_;
    }
    return com.google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource
        .getDefaultInstance();
  }

  /**
   *
   *
   * <pre>
   * Shared dataset i.e. BigQuery dataset source.
   * </pre>
   *
   * <code>
   * .google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource bigquery_dataset = 6;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSourceOrBuilder
      getBigqueryDatasetOrBuilder() {
    if (sourceCase_ == 6) {
      return (com.google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource) source_;
    }
    return com.google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource
        .getDefaultInstance();
  }

  public static final int PUBSUB_TOPIC_FIELD_NUMBER = 16;

  /**
   *
   *
   * <pre>
   * Pub/Sub topic source.
   * </pre>
   *
   * <code>.google.cloud.bigquery.analyticshub.v1.Listing.PubSubTopicSource pubsub_topic = 16;
   * </code>
   *
   * @return Whether the pubsubTopic field is set.
   */
  @java.lang.Override
  public boolean hasPubsubTopic() {
    return sourceCase_ == 16;
  }

  /**
   *
   *
   * <pre>
   * Pub/Sub topic source.
   * </pre>
   *
   * <code>.google.cloud.bigquery.analyticshub.v1.Listing.PubSubTopicSource pubsub_topic = 16;
   * </code>
   *
   * @return The pubsubTopic.
   */
  @java.lang.Override
  public com.google.cloud.bigquery.analyticshub.v1.Listing.PubSubTopicSource getPubsubTopic() {
    if (sourceCase_ == 16) {
      return (com.google.cloud.bigquery.analyticshub.v1.Listing.PubSubTopicSource) source_;
    }
    return com.google.cloud.bigquery.analyticshub.v1.Listing.PubSubTopicSource.getDefaultInstance();
  }

  /**
   *
   *
   * <pre>
   * Pub/Sub topic source.
   * </pre>
   *
   * <code>.google.cloud.bigquery.analyticshub.v1.Listing.PubSubTopicSource pubsub_topic = 16;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.bigquery.analyticshub.v1.Listing.PubSubTopicSourceOrBuilder
      getPubsubTopicOrBuilder() {
    if (sourceCase_ == 16) {
      return (com.google.cloud.bigquery.analyticshub.v1.Listing.PubSubTopicSource) source_;
    }
    return com.google.cloud.bigquery.analyticshub.v1.Listing.PubSubTopicSource.getDefaultInstance();
  }

  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";

  /**
   *
   *
   * <pre>
   * Output only. The resource name of the listing.
   * e.g. `projects/myproject/locations/us/dataExchanges/123/listings/456`
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Output only. The resource name of the listing.
   * e.g. `projects/myproject/locations/us/dataExchanges/123/listings/456`
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DISPLAY_NAME_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object displayName_ = "";

  /**
   *
   *
   * <pre>
   * Required. Human-readable display name of the listing. The display name must
   * contain only Unicode letters, numbers (0-9), underscores (_), dashes (-),
   * spaces ( ), ampersands (&amp;) and can't start or end with spaces. Default
   * value is an empty string. Max length: 63 bytes.
   * </pre>
   *
   * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The displayName.
   */
  @java.lang.Override
  public java.lang.String getDisplayName() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      displayName_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Required. Human-readable display name of the listing. The display name must
   * contain only Unicode letters, numbers (0-9), underscores (_), dashes (-),
   * spaces ( ), ampersands (&amp;) and can't start or end with spaces. Default
   * value is an empty string. Max length: 63 bytes.
   * </pre>
   *
   * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for displayName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDisplayNameBytes() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      displayName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DESCRIPTION_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object description_ = "";

  /**
   *
   *
   * <pre>
   * Optional. Short description of the listing. The description must not
   * contain Unicode non-characters and C0 and C1 control codes except tabs
   * (HT), new lines (LF), carriage returns (CR), and page breaks (FF). Default
   * value is an empty string. Max length: 2000 bytes.
   * </pre>
   *
   * <code>string description = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The description.
   */
  @java.lang.Override
  public java.lang.String getDescription() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      description_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Optional. Short description of the listing. The description must not
   * contain Unicode non-characters and C0 and C1 control codes except tabs
   * (HT), new lines (LF), carriage returns (CR), and page breaks (FF). Default
   * value is an empty string. Max length: 2000 bytes.
   * </pre>
   *
   * <code>string description = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for description.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDescriptionBytes() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      description_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PRIMARY_CONTACT_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private volatile java.lang.Object primaryContact_ = "";

  /**
   *
   *
   * <pre>
   * Optional. Email or URL of the primary point of contact of the listing.
   * Max Length: 1000 bytes.
   * </pre>
   *
   * <code>string primary_contact = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The primaryContact.
   */
  @java.lang.Override
  public java.lang.String getPrimaryContact() {
    java.lang.Object ref = primaryContact_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      primaryContact_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Optional. Email or URL of the primary point of contact of the listing.
   * Max Length: 1000 bytes.
   * </pre>
   *
   * <code>string primary_contact = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for primaryContact.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getPrimaryContactBytes() {
    java.lang.Object ref = primaryContact_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      primaryContact_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DOCUMENTATION_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private volatile java.lang.Object documentation_ = "";

  /**
   *
   *
   * <pre>
   * Optional. Documentation describing the listing.
   * </pre>
   *
   * <code>string documentation = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The documentation.
   */
  @java.lang.Override
  public java.lang.String getDocumentation() {
    java.lang.Object ref = documentation_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      documentation_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Optional. Documentation describing the listing.
   * </pre>
   *
   * <code>string documentation = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for documentation.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDocumentationBytes() {
    java.lang.Object ref = documentation_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      documentation_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int STATE_FIELD_NUMBER = 7;
  private int state_ = 0;

  /**
   *
   *
   * <pre>
   * Output only. Current state of the listing.
   * </pre>
   *
   * <code>
   * .google.cloud.bigquery.analyticshub.v1.Listing.State state = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The enum numeric value on the wire for state.
   */
  @java.lang.Override
  public int getStateValue() {
    return state_;
  }

  /**
   *
   *
   * <pre>
   * Output only. Current state of the listing.
   * </pre>
   *
   * <code>
   * .google.cloud.bigquery.analyticshub.v1.Listing.State state = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The state.
   */
  @java.lang.Override
  public com.google.cloud.bigquery.analyticshub.v1.Listing.State getState() {
    com.google.cloud.bigquery.analyticshub.v1.Listing.State result =
        com.google.cloud.bigquery.analyticshub.v1.Listing.State.forNumber(state_);
    return result == null
        ? com.google.cloud.bigquery.analyticshub.v1.Listing.State.UNRECOGNIZED
        : result;
  }

  public static final int ICON_FIELD_NUMBER = 8;
  private com.google.protobuf.ByteString icon_ = com.google.protobuf.ByteString.EMPTY;

  /**
   *
   *
   * <pre>
   * Optional. Base64 encoded image representing the listing. Max Size: 3.0MiB
   * Expected image dimensions are 512x512 pixels, however the API only
   * performs validation on size of the encoded data.
   * Note: For byte fields, the contents of the field are base64-encoded (which
   * increases the size of the data by 33-36%) when using JSON on the wire.
   * </pre>
   *
   * <code>bytes icon = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The icon.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getIcon() {
    return icon_;
  }

  public static final int DATA_PROVIDER_FIELD_NUMBER = 9;
  private com.google.cloud.bigquery.analyticshub.v1.DataProvider dataProvider_;

  /**
   *
   *
   * <pre>
   * Optional. Details of the data provider who owns the source data.
   * </pre>
   *
   * <code>
   * .google.cloud.bigquery.analyticshub.v1.DataProvider data_provider = 9 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the dataProvider field is set.
   */
  @java.lang.Override
  public boolean hasDataProvider() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * Optional. Details of the data provider who owns the source data.
   * </pre>
   *
   * <code>
   * .google.cloud.bigquery.analyticshub.v1.DataProvider data_provider = 9 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The dataProvider.
   */
  @java.lang.Override
  public com.google.cloud.bigquery.analyticshub.v1.DataProvider getDataProvider() {
    return dataProvider_ == null
        ? com.google.cloud.bigquery.analyticshub.v1.DataProvider.getDefaultInstance()
        : dataProvider_;
  }

  /**
   *
   *
   * <pre>
   * Optional. Details of the data provider who owns the source data.
   * </pre>
   *
   * <code>
   * .google.cloud.bigquery.analyticshub.v1.DataProvider data_provider = 9 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.bigquery.analyticshub.v1.DataProviderOrBuilder
      getDataProviderOrBuilder() {
    return dataProvider_ == null
        ? com.google.cloud.bigquery.analyticshub.v1.DataProvider.getDefaultInstance()
        : dataProvider_;
  }

  public static final int CATEGORIES_FIELD_NUMBER = 10;

  @SuppressWarnings("serial")
  private java.util.List<java.lang.Integer> categories_;

  private static final com.google.protobuf.Internal.ListAdapter.Converter<
          java.lang.Integer, com.google.cloud.bigquery.analyticshub.v1.Listing.Category>
      categories_converter_ =
          new com.google.protobuf.Internal.ListAdapter.Converter<
              java.lang.Integer, com.google.cloud.bigquery.analyticshub.v1.Listing.Category>() {
            public com.google.cloud.bigquery.analyticshub.v1.Listing.Category convert(
                java.lang.Integer from) {
              com.google.cloud.bigquery.analyticshub.v1.Listing.Category result =
                  com.google.cloud.bigquery.analyticshub.v1.Listing.Category.forNumber(from);
              return result == null
                  ? com.google.cloud.bigquery.analyticshub.v1.Listing.Category.UNRECOGNIZED
                  : result;
            }
          };

  /**
   *
   *
   * <pre>
   * Optional. Categories of the listing. Up to two categories are allowed.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.bigquery.analyticshub.v1.Listing.Category categories = 10 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return A list containing the categories.
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.bigquery.analyticshub.v1.Listing.Category>
      getCategoriesList() {
    return new com.google.protobuf.Internal.ListAdapter<
        java.lang.Integer, com.google.cloud.bigquery.analyticshub.v1.Listing.Category>(
        categories_, categories_converter_);
  }

  /**
   *
   *
   * <pre>
   * Optional. Categories of the listing. Up to two categories are allowed.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.bigquery.analyticshub.v1.Listing.Category categories = 10 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The count of categories.
   */
  @java.lang.Override
  public int getCategoriesCount() {
    return categories_.size();
  }

  /**
   *
   *
   * <pre>
   * Optional. Categories of the listing. Up to two categories are allowed.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.bigquery.analyticshub.v1.Listing.Category categories = 10 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @param index The index of the element to return.
   * @return The categories at the given index.
   */
  @java.lang.Override
  public com.google.cloud.bigquery.analyticshub.v1.Listing.Category getCategories(int index) {
    return categories_converter_.convert(categories_.get(index));
  }

  /**
   *
   *
   * <pre>
   * Optional. Categories of the listing. Up to two categories are allowed.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.bigquery.analyticshub.v1.Listing.Category categories = 10 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return A list containing the enum numeric values on the wire for categories.
   */
  @java.lang.Override
  public java.util.List<java.lang.Integer> getCategoriesValueList() {
    return categories_;
  }

  /**
   *
   *
   * <pre>
   * Optional. Categories of the listing. Up to two categories are allowed.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.bigquery.analyticshub.v1.Listing.Category categories = 10 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @param index The index of the value to return.
   * @return The enum numeric value on the wire of categories at the given index.
   */
  @java.lang.Override
  public int getCategoriesValue(int index) {
    return categories_.get(index);
  }

  private int categoriesMemoizedSerializedSize;

  public static final int PUBLISHER_FIELD_NUMBER = 11;
  private com.google.cloud.bigquery.analyticshub.v1.Publisher publisher_;

  /**
   *
   *
   * <pre>
   * Optional. Details of the publisher who owns the listing and who can share
   * the source data.
   * </pre>
   *
   * <code>
   * .google.cloud.bigquery.analyticshub.v1.Publisher publisher = 11 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the publisher field is set.
   */
  @java.lang.Override
  public boolean hasPublisher() {
    return ((bitField0_ & 0x00000002) != 0);
  }

  /**
   *
   *
   * <pre>
   * Optional. Details of the publisher who owns the listing and who can share
   * the source data.
   * </pre>
   *
   * <code>
   * .google.cloud.bigquery.analyticshub.v1.Publisher publisher = 11 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The publisher.
   */
  @java.lang.Override
  public com.google.cloud.bigquery.analyticshub.v1.Publisher getPublisher() {
    return publisher_ == null
        ? com.google.cloud.bigquery.analyticshub.v1.Publisher.getDefaultInstance()
        : publisher_;
  }

  /**
   *
   *
   * <pre>
   * Optional. Details of the publisher who owns the listing and who can share
   * the source data.
   * </pre>
   *
   * <code>
   * .google.cloud.bigquery.analyticshub.v1.Publisher publisher = 11 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.bigquery.analyticshub.v1.PublisherOrBuilder getPublisherOrBuilder() {
    return publisher_ == null
        ? com.google.cloud.bigquery.analyticshub.v1.Publisher.getDefaultInstance()
        : publisher_;
  }

  public static final int REQUEST_ACCESS_FIELD_NUMBER = 12;

  @SuppressWarnings("serial")
  private volatile java.lang.Object requestAccess_ = "";

  /**
   *
   *
   * <pre>
   * Optional. Email or URL of the request access of the listing.
   * Subscribers can use this reference to request access.
   * Max Length: 1000 bytes.
   * </pre>
   *
   * <code>string request_access = 12 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The requestAccess.
   */
  @java.lang.Override
  public java.lang.String getRequestAccess() {
    java.lang.Object ref = requestAccess_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      requestAccess_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Optional. Email or URL of the request access of the listing.
   * Subscribers can use this reference to request access.
   * Max Length: 1000 bytes.
   * </pre>
   *
   * <code>string request_access = 12 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for requestAccess.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getRequestAccessBytes() {
    java.lang.Object ref = requestAccess_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      requestAccess_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int RESTRICTED_EXPORT_CONFIG_FIELD_NUMBER = 13;
  private com.google.cloud.bigquery.analyticshub.v1.Listing.RestrictedExportConfig
      restrictedExportConfig_;

  /**
   *
   *
   * <pre>
   * Optional. If set, restricted export configuration will be propagated and
   * enforced on the linked dataset.
   * </pre>
   *
   * <code>
   * .google.cloud.bigquery.analyticshub.v1.Listing.RestrictedExportConfig restricted_export_config = 13 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the restrictedExportConfig field is set.
   */
  @java.lang.Override
  public boolean hasRestrictedExportConfig() {
    return ((bitField0_ & 0x00000004) != 0);
  }

  /**
   *
   *
   * <pre>
   * Optional. If set, restricted export configuration will be propagated and
   * enforced on the linked dataset.
   * </pre>
   *
   * <code>
   * .google.cloud.bigquery.analyticshub.v1.Listing.RestrictedExportConfig restricted_export_config = 13 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The restrictedExportConfig.
   */
  @java.lang.Override
  public com.google.cloud.bigquery.analyticshub.v1.Listing.RestrictedExportConfig
      getRestrictedExportConfig() {
    return restrictedExportConfig_ == null
        ? com.google.cloud.bigquery.analyticshub.v1.Listing.RestrictedExportConfig
            .getDefaultInstance()
        : restrictedExportConfig_;
  }

  /**
   *
   *
   * <pre>
   * Optional. If set, restricted export configuration will be propagated and
   * enforced on the linked dataset.
   * </pre>
   *
   * <code>
   * .google.cloud.bigquery.analyticshub.v1.Listing.RestrictedExportConfig restricted_export_config = 13 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.bigquery.analyticshub.v1.Listing.RestrictedExportConfigOrBuilder
      getRestrictedExportConfigOrBuilder() {
    return restrictedExportConfig_ == null
        ? com.google.cloud.bigquery.analyticshub.v1.Listing.RestrictedExportConfig
            .getDefaultInstance()
        : restrictedExportConfig_;
  }

  public static final int DISCOVERY_TYPE_FIELD_NUMBER = 14;
  private int discoveryType_ = 0;

  /**
   *
   *
   * <pre>
   * Optional. Type of discovery of the listing on the discovery page.
   * </pre>
   *
   * <code>
   * optional .google.cloud.bigquery.analyticshub.v1.DiscoveryType discovery_type = 14 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the discoveryType field is set.
   */
  @java.lang.Override
  public boolean hasDiscoveryType() {
    return ((bitField0_ & 0x00000008) != 0);
  }

  /**
   *
   *
   * <pre>
   * Optional. Type of discovery of the listing on the discovery page.
   * </pre>
   *
   * <code>
   * optional .google.cloud.bigquery.analyticshub.v1.DiscoveryType discovery_type = 14 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The enum numeric value on the wire for discoveryType.
   */
  @java.lang.Override
  public int getDiscoveryTypeValue() {
    return discoveryType_;
  }

  /**
   *
   *
   * <pre>
   * Optional. Type of discovery of the listing on the discovery page.
   * </pre>
   *
   * <code>
   * optional .google.cloud.bigquery.analyticshub.v1.DiscoveryType discovery_type = 14 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The discoveryType.
   */
  @java.lang.Override
  public com.google.cloud.bigquery.analyticshub.v1.DiscoveryType getDiscoveryType() {
    com.google.cloud.bigquery.analyticshub.v1.DiscoveryType result =
        com.google.cloud.bigquery.analyticshub.v1.DiscoveryType.forNumber(discoveryType_);
    return result == null
        ? com.google.cloud.bigquery.analyticshub.v1.DiscoveryType.UNRECOGNIZED
        : result;
  }

  public static final int RESOURCE_TYPE_FIELD_NUMBER = 15;
  private int resourceType_ = 0;

  /**
   *
   *
   * <pre>
   * Output only. Listing shared asset type.
   * </pre>
   *
   * <code>
   * .google.cloud.bigquery.analyticshub.v1.SharedResourceType resource_type = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The enum numeric value on the wire for resourceType.
   */
  @java.lang.Override
  public int getResourceTypeValue() {
    return resourceType_;
  }

  /**
   *
   *
   * <pre>
   * Output only. Listing shared asset type.
   * </pre>
   *
   * <code>
   * .google.cloud.bigquery.analyticshub.v1.SharedResourceType resource_type = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The resourceType.
   */
  @java.lang.Override
  public com.google.cloud.bigquery.analyticshub.v1.SharedResourceType getResourceType() {
    com.google.cloud.bigquery.analyticshub.v1.SharedResourceType result =
        com.google.cloud.bigquery.analyticshub.v1.SharedResourceType.forNumber(resourceType_);
    return result == null
        ? com.google.cloud.bigquery.analyticshub.v1.SharedResourceType.UNRECOGNIZED
        : result;
  }

  public static final int COMMERCIAL_INFO_FIELD_NUMBER = 17;
  private com.google.cloud.bigquery.analyticshub.v1.Listing.CommercialInfo commercialInfo_;

  /**
   *
   *
   * <pre>
   * Output only. Commercial info contains the information about the commercial
   * data products associated with the listing.
   * </pre>
   *
   * <code>
   * optional .google.cloud.bigquery.analyticshub.v1.Listing.CommercialInfo commercial_info = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the commercialInfo field is set.
   */
  @java.lang.Override
  public boolean hasCommercialInfo() {
    return ((bitField0_ & 0x00000010) != 0);
  }

  /**
   *
   *
   * <pre>
   * Output only. Commercial info contains the information about the commercial
   * data products associated with the listing.
   * </pre>
   *
   * <code>
   * optional .google.cloud.bigquery.analyticshub.v1.Listing.CommercialInfo commercial_info = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The commercialInfo.
   */
  @java.lang.Override
  public com.google.cloud.bigquery.analyticshub.v1.Listing.CommercialInfo getCommercialInfo() {
    return commercialInfo_ == null
        ? com.google.cloud.bigquery.analyticshub.v1.Listing.CommercialInfo.getDefaultInstance()
        : commercialInfo_;
  }

  /**
   *
   *
   * <pre>
   * Output only. Commercial info contains the information about the commercial
   * data products associated with the listing.
   * </pre>
   *
   * <code>
   * optional .google.cloud.bigquery.analyticshub.v1.Listing.CommercialInfo commercial_info = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.bigquery.analyticshub.v1.Listing.CommercialInfoOrBuilder
      getCommercialInfoOrBuilder() {
    return commercialInfo_ == null
        ? com.google.cloud.bigquery.analyticshub.v1.Listing.CommercialInfo.getDefaultInstance()
        : commercialInfo_;
  }

  public static final int LOG_LINKED_DATASET_QUERY_USER_EMAIL_FIELD_NUMBER = 18;
  private boolean logLinkedDatasetQueryUserEmail_ = false;

  /**
   *
   *
   * <pre>
   * Optional. By default, false.
   * If true, the Listing has an email sharing mandate enabled.
   * </pre>
   *
   * <code>
   * optional bool log_linked_dataset_query_user_email = 18 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the logLinkedDatasetQueryUserEmail field is set.
   */
  @java.lang.Override
  public boolean hasLogLinkedDatasetQueryUserEmail() {
    return ((bitField0_ & 0x00000020) != 0);
  }

  /**
   *
   *
   * <pre>
   * Optional. By default, false.
   * If true, the Listing has an email sharing mandate enabled.
   * </pre>
   *
   * <code>
   * optional bool log_linked_dataset_query_user_email = 18 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The logLinkedDatasetQueryUserEmail.
   */
  @java.lang.Override
  public boolean getLogLinkedDatasetQueryUserEmail() {
    return logLinkedDatasetQueryUserEmail_;
  }

  public static final int ALLOW_ONLY_METADATA_SHARING_FIELD_NUMBER = 19;
  private boolean allowOnlyMetadataSharing_ = false;

  /**
   *
   *
   * <pre>
   * Optional. If true, the listing is only available to get the resource
   * metadata. Listing is non subscribable.
   * </pre>
   *
   * <code>optional bool allow_only_metadata_sharing = 19 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the allowOnlyMetadataSharing field is set.
   */
  @java.lang.Override
  public boolean hasAllowOnlyMetadataSharing() {
    return ((bitField0_ & 0x00000040) != 0);
  }

  /**
   *
   *
   * <pre>
   * Optional. If true, the listing is only available to get the resource
   * metadata. Listing is non subscribable.
   * </pre>
   *
   * <code>optional bool allow_only_metadata_sharing = 19 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The allowOnlyMetadataSharing.
   */
  @java.lang.Override
  public boolean getAllowOnlyMetadataSharing() {
    return allowOnlyMetadataSharing_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    getSerializedSize();
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, displayName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, description_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(primaryContact_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, primaryContact_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(documentation_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, documentation_);
    }
    if (sourceCase_ == 6) {
      output.writeMessage(
          6, (com.google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource) source_);
    }
    if (state_
        != com.google.cloud.bigquery.analyticshub.v1.Listing.State.STATE_UNSPECIFIED.getNumber()) {
      output.writeEnum(7, state_);
    }
    if (!icon_.isEmpty()) {
      output.writeBytes(8, icon_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(9, getDataProvider());
    }
    if (getCategoriesList().size() > 0) {
      output.writeUInt32NoTag(82);
      output.writeUInt32NoTag(categoriesMemoizedSerializedSize);
    }
    for (int i = 0; i < categories_.size(); i++) {
      output.writeEnumNoTag(categories_.get(i));
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(11, getPublisher());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(requestAccess_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 12, requestAccess_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(13, getRestrictedExportConfig());
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      output.writeEnum(14, discoveryType_);
    }
    if (resourceType_
        != com.google.cloud.bigquery.analyticshub.v1.SharedResourceType
            .SHARED_RESOURCE_TYPE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(15, resourceType_);
    }
    if (sourceCase_ == 16) {
      output.writeMessage(
          16, (com.google.cloud.bigquery.analyticshub.v1.Listing.PubSubTopicSource) source_);
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      output.writeMessage(17, getCommercialInfo());
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      output.writeBool(18, logLinkedDatasetQueryUserEmail_);
    }
    if (((bitField0_ & 0x00000040) != 0)) {
      output.writeBool(19, allowOnlyMetadataSharing_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, displayName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, description_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(primaryContact_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, primaryContact_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(documentation_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, documentation_);
    }
    if (sourceCase_ == 6) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              6, (com.google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource) source_);
    }
    if (state_
        != com.google.cloud.bigquery.analyticshub.v1.Listing.State.STATE_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(7, state_);
    }
    if (!icon_.isEmpty()) {
      size += com.google.protobuf.CodedOutputStream.computeBytesSize(8, icon_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(9, getDataProvider());
    }
    {
      int dataSize = 0;
      for (int i = 0; i < categories_.size(); i++) {
        dataSize += com.google.protobuf.CodedOutputStream.computeEnumSizeNoTag(categories_.get(i));
      }
      size += dataSize;
      if (!getCategoriesList().isEmpty()) {
        size += 1;
        size += com.google.protobuf.CodedOutputStream.computeUInt32SizeNoTag(dataSize);
      }
      categoriesMemoizedSerializedSize = dataSize;
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(11, getPublisher());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(requestAccess_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(12, requestAccess_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(13, getRestrictedExportConfig());
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(14, discoveryType_);
    }
    if (resourceType_
        != com.google.cloud.bigquery.analyticshub.v1.SharedResourceType
            .SHARED_RESOURCE_TYPE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(15, resourceType_);
    }
    if (sourceCase_ == 16) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              16, (com.google.cloud.bigquery.analyticshub.v1.Listing.PubSubTopicSource) source_);
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(17, getCommercialInfo());
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeBoolSize(
              18, logLinkedDatasetQueryUserEmail_);
    }
    if (((bitField0_ & 0x00000040) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(19, allowOnlyMetadataSharing_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.bigquery.analyticshub.v1.Listing)) {
      return super.equals(obj);
    }
    com.google.cloud.bigquery.analyticshub.v1.Listing other =
        (com.google.cloud.bigquery.analyticshub.v1.Listing) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getDisplayName().equals(other.getDisplayName())) return false;
    if (!getDescription().equals(other.getDescription())) return false;
    if (!getPrimaryContact().equals(other.getPrimaryContact())) return false;
    if (!getDocumentation().equals(other.getDocumentation())) return false;
    if (state_ != other.state_) return false;
    if (!getIcon().equals(other.getIcon())) return false;
    if (hasDataProvider() != other.hasDataProvider()) return false;
    if (hasDataProvider()) {
      if (!getDataProvider().equals(other.getDataProvider())) return false;
    }
    if (!categories_.equals(other.categories_)) return false;
    if (hasPublisher() != other.hasPublisher()) return false;
    if (hasPublisher()) {
      if (!getPublisher().equals(other.getPublisher())) return false;
    }
    if (!getRequestAccess().equals(other.getRequestAccess())) return false;
    if (hasRestrictedExportConfig() != other.hasRestrictedExportConfig()) return false;
    if (hasRestrictedExportConfig()) {
      if (!getRestrictedExportConfig().equals(other.getRestrictedExportConfig())) return false;
    }
    if (hasDiscoveryType() != other.hasDiscoveryType()) return false;
    if (hasDiscoveryType()) {
      if (discoveryType_ != other.discoveryType_) return false;
    }
    if (resourceType_ != other.resourceType_) return false;
    if (hasCommercialInfo() != other.hasCommercialInfo()) return false;
    if (hasCommercialInfo()) {
      if (!getCommercialInfo().equals(other.getCommercialInfo())) return false;
    }
    if (hasLogLinkedDatasetQueryUserEmail() != other.hasLogLinkedDatasetQueryUserEmail())
      return false;
    if (hasLogLinkedDatasetQueryUserEmail()) {
      if (getLogLinkedDatasetQueryUserEmail() != other.getLogLinkedDatasetQueryUserEmail())
        return false;
    }
    if (hasAllowOnlyMetadataSharing() != other.hasAllowOnlyMetadataSharing()) return false;
    if (hasAllowOnlyMetadataSharing()) {
      if (getAllowOnlyMetadataSharing() != other.getAllowOnlyMetadataSharing()) return false;
    }
    if (!getSourceCase().equals(other.getSourceCase())) return false;
    switch (sourceCase_) {
      case 6:
        if (!getBigqueryDataset().equals(other.getBigqueryDataset())) return false;
        break;
      case 16:
        if (!getPubsubTopic().equals(other.getPubsubTopic())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + DISPLAY_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getDisplayName().hashCode();
    hash = (37 * hash) + DESCRIPTION_FIELD_NUMBER;
    hash = (53 * hash) + getDescription().hashCode();
    hash = (37 * hash) + PRIMARY_CONTACT_FIELD_NUMBER;
    hash = (53 * hash) + getPrimaryContact().hashCode();
    hash = (37 * hash) + DOCUMENTATION_FIELD_NUMBER;
    hash = (53 * hash) + getDocumentation().hashCode();
    hash = (37 * hash) + STATE_FIELD_NUMBER;
    hash = (53 * hash) + state_;
    hash = (37 * hash) + ICON_FIELD_NUMBER;
    hash = (53 * hash) + getIcon().hashCode();
    if (hasDataProvider()) {
      hash = (37 * hash) + DATA_PROVIDER_FIELD_NUMBER;
      hash = (53 * hash) + getDataProvider().hashCode();
    }
    if (getCategoriesCount() > 0) {
      hash = (37 * hash) + CATEGORIES_FIELD_NUMBER;
      hash = (53 * hash) + categories_.hashCode();
    }
    if (hasPublisher()) {
      hash = (37 * hash) + PUBLISHER_FIELD_NUMBER;
      hash = (53 * hash) + getPublisher().hashCode();
    }
    hash = (37 * hash) + REQUEST_ACCESS_FIELD_NUMBER;
    hash = (53 * hash) + getRequestAccess().hashCode();
    if (hasRestrictedExportConfig()) {
      hash = (37 * hash) + RESTRICTED_EXPORT_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getRestrictedExportConfig().hashCode();
    }
    if (hasDiscoveryType()) {
      hash = (37 * hash) + DISCOVERY_TYPE_FIELD_NUMBER;
      hash = (53 * hash) + discoveryType_;
    }
    hash = (37 * hash) + RESOURCE_TYPE_FIELD_NUMBER;
    hash = (53 * hash) + resourceType_;
    if (hasCommercialInfo()) {
      hash = (37 * hash) + COMMERCIAL_INFO_FIELD_NUMBER;
      hash = (53 * hash) + getCommercialInfo().hashCode();
    }
    if (hasLogLinkedDatasetQueryUserEmail()) {
      hash = (37 * hash) + LOG_LINKED_DATASET_QUERY_USER_EMAIL_FIELD_NUMBER;
      hash =
          (53 * hash)
              + com.google.protobuf.Internal.hashBoolean(getLogLinkedDatasetQueryUserEmail());
    }
    if (hasAllowOnlyMetadataSharing()) {
      hash = (37 * hash) + ALLOW_ONLY_METADATA_SHARING_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getAllowOnlyMetadataSharing());
    }
    switch (sourceCase_) {
      case 6:
        hash = (37 * hash) + BIGQUERY_DATASET_FIELD_NUMBER;
        hash = (53 * hash) + getBigqueryDataset().hashCode();
        break;
      case 16:
        hash = (37 * hash) + PUBSUB_TOPIC_FIELD_NUMBER;
        hash = (53 * hash) + getPubsubTopic().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.bigquery.analyticshub.v1.Listing parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.bigquery.analyticshub.v1.Listing parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.bigquery.analyticshub.v1.Listing parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.bigquery.analyticshub.v1.Listing parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.bigquery.analyticshub.v1.Listing parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.bigquery.analyticshub.v1.Listing parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.bigquery.analyticshub.v1.Listing parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.bigquery.analyticshub.v1.Listing parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.bigquery.analyticshub.v1.Listing parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.bigquery.analyticshub.v1.Listing parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.bigquery.analyticshub.v1.Listing parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.bigquery.analyticshub.v1.Listing parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.bigquery.analyticshub.v1.Listing prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * A listing is what gets published into a data exchange that a subscriber can
   * subscribe to. It contains a reference to the data source along with
   * descriptive information that will help subscribers find and subscribe the
   * data.
   * </pre>
   *
   * Protobuf type {@code google.cloud.bigquery.analyticshub.v1.Listing}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.bigquery.analyticshub.v1.Listing)
      com.google.cloud.bigquery.analyticshub.v1.ListingOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.bigquery.analyticshub.v1.AnalyticsHubProto
          .internal_static_google_cloud_bigquery_analyticshub_v1_Listing_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.bigquery.analyticshub.v1.AnalyticsHubProto
          .internal_static_google_cloud_bigquery_analyticshub_v1_Listing_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.bigquery.analyticshub.v1.Listing.class,
              com.google.cloud.bigquery.analyticshub.v1.Listing.Builder.class);
    }

    // Construct using com.google.cloud.bigquery.analyticshub.v1.Listing.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getDataProviderFieldBuilder();
        getPublisherFieldBuilder();
        getRestrictedExportConfigFieldBuilder();
        getCommercialInfoFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (bigqueryDatasetBuilder_ != null) {
        bigqueryDatasetBuilder_.clear();
      }
      if (pubsubTopicBuilder_ != null) {
        pubsubTopicBuilder_.clear();
      }
      name_ = "";
      displayName_ = "";
      description_ = "";
      primaryContact_ = "";
      documentation_ = "";
      state_ = 0;
      icon_ = com.google.protobuf.ByteString.EMPTY;
      dataProvider_ = null;
      if (dataProviderBuilder_ != null) {
        dataProviderBuilder_.dispose();
        dataProviderBuilder_ = null;
      }
      categories_ = java.util.Collections.emptyList();
      bitField0_ = (bitField0_ & ~0x00000400);
      publisher_ = null;
      if (publisherBuilder_ != null) {
        publisherBuilder_.dispose();
        publisherBuilder_ = null;
      }
      requestAccess_ = "";
      restrictedExportConfig_ = null;
      if (restrictedExportConfigBuilder_ != null) {
        restrictedExportConfigBuilder_.dispose();
        restrictedExportConfigBuilder_ = null;
      }
      discoveryType_ = 0;
      resourceType_ = 0;
      commercialInfo_ = null;
      if (commercialInfoBuilder_ != null) {
        commercialInfoBuilder_.dispose();
        commercialInfoBuilder_ = null;
      }
      logLinkedDatasetQueryUserEmail_ = false;
      allowOnlyMetadataSharing_ = false;
      sourceCase_ = 0;
      source_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.bigquery.analyticshub.v1.AnalyticsHubProto
          .internal_static_google_cloud_bigquery_analyticshub_v1_Listing_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.bigquery.analyticshub.v1.Listing getDefaultInstanceForType() {
      return com.google.cloud.bigquery.analyticshub.v1.Listing.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.bigquery.analyticshub.v1.Listing build() {
      com.google.cloud.bigquery.analyticshub.v1.Listing result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.bigquery.analyticshub.v1.Listing buildPartial() {
      com.google.cloud.bigquery.analyticshub.v1.Listing result =
          new com.google.cloud.bigquery.analyticshub.v1.Listing(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.bigquery.analyticshub.v1.Listing result) {
      if (((bitField0_ & 0x00000400) != 0)) {
        categories_ = java.util.Collections.unmodifiableList(categories_);
        bitField0_ = (bitField0_ & ~0x00000400);
      }
      result.categories_ = categories_;
    }

    private void buildPartial0(com.google.cloud.bigquery.analyticshub.v1.Listing result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.displayName_ = displayName_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.description_ = description_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.primaryContact_ = primaryContact_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.documentation_ = documentation_;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.state_ = state_;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.icon_ = icon_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.dataProvider_ =
            dataProviderBuilder_ == null ? dataProvider_ : dataProviderBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000800) != 0)) {
        result.publisher_ = publisherBuilder_ == null ? publisher_ : publisherBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00001000) != 0)) {
        result.requestAccess_ = requestAccess_;
      }
      if (((from_bitField0_ & 0x00002000) != 0)) {
        result.restrictedExportConfig_ =
            restrictedExportConfigBuilder_ == null
                ? restrictedExportConfig_
                : restrictedExportConfigBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00004000) != 0)) {
        result.discoveryType_ = discoveryType_;
        to_bitField0_ |= 0x00000008;
      }
      if (((from_bitField0_ & 0x00008000) != 0)) {
        result.resourceType_ = resourceType_;
      }
      if (((from_bitField0_ & 0x00010000) != 0)) {
        result.commercialInfo_ =
            commercialInfoBuilder_ == null ? commercialInfo_ : commercialInfoBuilder_.build();
        to_bitField0_ |= 0x00000010;
      }
      if (((from_bitField0_ & 0x00020000) != 0)) {
        result.logLinkedDatasetQueryUserEmail_ = logLinkedDatasetQueryUserEmail_;
        to_bitField0_ |= 0x00000020;
      }
      if (((from_bitField0_ & 0x00040000) != 0)) {
        result.allowOnlyMetadataSharing_ = allowOnlyMetadataSharing_;
        to_bitField0_ |= 0x00000040;
      }
      result.bitField0_ |= to_bitField0_;
    }

    private void buildPartialOneofs(com.google.cloud.bigquery.analyticshub.v1.Listing result) {
      result.sourceCase_ = sourceCase_;
      result.source_ = this.source_;
      if (sourceCase_ == 6 && bigqueryDatasetBuilder_ != null) {
        result.source_ = bigqueryDatasetBuilder_.build();
      }
      if (sourceCase_ == 16 && pubsubTopicBuilder_ != null) {
        result.source_ = pubsubTopicBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.bigquery.analyticshub.v1.Listing) {
        return mergeFrom((com.google.cloud.bigquery.analyticshub.v1.Listing) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.bigquery.analyticshub.v1.Listing other) {
      if (other == com.google.cloud.bigquery.analyticshub.v1.Listing.getDefaultInstance())
        return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (!other.getDisplayName().isEmpty()) {
        displayName_ = other.displayName_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (!other.getDescription().isEmpty()) {
        description_ = other.description_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      if (!other.getPrimaryContact().isEmpty()) {
        primaryContact_ = other.primaryContact_;
        bitField0_ |= 0x00000020;
        onChanged();
      }
      if (!other.getDocumentation().isEmpty()) {
        documentation_ = other.documentation_;
        bitField0_ |= 0x00000040;
        onChanged();
      }
      if (other.state_ != 0) {
        setStateValue(other.getStateValue());
      }
      if (other.getIcon() != com.google.protobuf.ByteString.EMPTY) {
        setIcon(other.getIcon());
      }
      if (other.hasDataProvider()) {
        mergeDataProvider(other.getDataProvider());
      }
      if (!other.categories_.isEmpty()) {
        if (categories_.isEmpty()) {
          categories_ = other.categories_;
          bitField0_ = (bitField0_ & ~0x00000400);
        } else {
          ensureCategoriesIsMutable();
          categories_.addAll(other.categories_);
        }
        onChanged();
      }
      if (other.hasPublisher()) {
        mergePublisher(other.getPublisher());
      }
      if (!other.getRequestAccess().isEmpty()) {
        requestAccess_ = other.requestAccess_;
        bitField0_ |= 0x00001000;
        onChanged();
      }
      if (other.hasRestrictedExportConfig()) {
        mergeRestrictedExportConfig(other.getRestrictedExportConfig());
      }
      if (other.hasDiscoveryType()) {
        setDiscoveryType(other.getDiscoveryType());
      }
      if (other.resourceType_ != 0) {
        setResourceTypeValue(other.getResourceTypeValue());
      }
      if (other.hasCommercialInfo()) {
        mergeCommercialInfo(other.getCommercialInfo());
      }
      if (other.hasLogLinkedDatasetQueryUserEmail()) {
        setLogLinkedDatasetQueryUserEmail(other.getLogLinkedDatasetQueryUserEmail());
      }
      if (other.hasAllowOnlyMetadataSharing()) {
        setAllowOnlyMetadataSharing(other.getAllowOnlyMetadataSharing());
      }
      switch (other.getSourceCase()) {
        case BIGQUERY_DATASET:
          {
            mergeBigqueryDataset(other.getBigqueryDataset());
            break;
          }
        case PUBSUB_TOPIC:
          {
            mergePubsubTopic(other.getPubsubTopic());
            break;
          }
        case SOURCE_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 10
            case 18:
              {
                displayName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 18
            case 26:
              {
                description_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case 26
            case 34:
              {
                primaryContact_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000020;
                break;
              } // case 34
            case 42:
              {
                documentation_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000040;
                break;
              } // case 42
            case 50:
              {
                input.readMessage(getBigqueryDatasetFieldBuilder().getBuilder(), extensionRegistry);
                sourceCase_ = 6;
                break;
              } // case 50
            case 56:
              {
                state_ = input.readEnum();
                bitField0_ |= 0x00000080;
                break;
              } // case 56
            case 66:
              {
                icon_ = input.readBytes();
                bitField0_ |= 0x00000100;
                break;
              } // case 66
            case 74:
              {
                input.readMessage(getDataProviderFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000200;
                break;
              } // case 74
            case 80:
              {
                int tmpRaw = input.readEnum();
                ensureCategoriesIsMutable();
                categories_.add(tmpRaw);
                break;
              } // case 80
            case 82:
              {
                int length = input.readRawVarint32();
                int oldLimit = input.pushLimit(length);
                while (input.getBytesUntilLimit() > 0) {
                  int tmpRaw = input.readEnum();
                  ensureCategoriesIsMutable();
                  categories_.add(tmpRaw);
                }
                input.popLimit(oldLimit);
                break;
              } // case 82
            case 90:
              {
                input.readMessage(getPublisherFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000800;
                break;
              } // case 90
            case 98:
              {
                requestAccess_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00001000;
                break;
              } // case 98
            case 106:
              {
                input.readMessage(
                    getRestrictedExportConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00002000;
                break;
              } // case 106
            case 112:
              {
                discoveryType_ = input.readEnum();
                bitField0_ |= 0x00004000;
                break;
              } // case 112
            case 120:
              {
                resourceType_ = input.readEnum();
                bitField0_ |= 0x00008000;
                break;
              } // case 120
            case 130:
              {
                input.readMessage(getPubsubTopicFieldBuilder().getBuilder(), extensionRegistry);
                sourceCase_ = 16;
                break;
              } // case 130
            case 138:
              {
                input.readMessage(getCommercialInfoFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00010000;
                break;
              } // case 138
            case 144:
              {
                logLinkedDatasetQueryUserEmail_ = input.readBool();
                bitField0_ |= 0x00020000;
                break;
              } // case 144
            case 152:
              {
                allowOnlyMetadataSharing_ = input.readBool();
                bitField0_ |= 0x00040000;
                break;
              } // case 152
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int sourceCase_ = 0;
    private java.lang.Object source_;

    public SourceCase getSourceCase() {
      return SourceCase.forNumber(sourceCase_);
    }

    public Builder clearSource() {
      sourceCase_ = 0;
      source_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource,
            com.google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource.Builder,
            com.google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSourceOrBuilder>
        bigqueryDatasetBuilder_;

    /**
     *
     *
     * <pre>
     * Shared dataset i.e. BigQuery dataset source.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource bigquery_dataset = 6;
     * </code>
     *
     * @return Whether the bigqueryDataset field is set.
     */
    @java.lang.Override
    public boolean hasBigqueryDataset() {
      return sourceCase_ == 6;
    }

    /**
     *
     *
     * <pre>
     * Shared dataset i.e. BigQuery dataset source.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource bigquery_dataset = 6;
     * </code>
     *
     * @return The bigqueryDataset.
     */
    @java.lang.Override
    public com.google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource
        getBigqueryDataset() {
      if (bigqueryDatasetBuilder_ == null) {
        if (sourceCase_ == 6) {
          return (com.google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource) source_;
        }
        return com.google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource
            .getDefaultInstance();
      } else {
        if (sourceCase_ == 6) {
          return bigqueryDatasetBuilder_.getMessage();
        }
        return com.google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource
            .getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Shared dataset i.e. BigQuery dataset source.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource bigquery_dataset = 6;
     * </code>
     */
    public Builder setBigqueryDataset(
        com.google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource value) {
      if (bigqueryDatasetBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        source_ = value;
        onChanged();
      } else {
        bigqueryDatasetBuilder_.setMessage(value);
      }
      sourceCase_ = 6;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Shared dataset i.e. BigQuery dataset source.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource bigquery_dataset = 6;
     * </code>
     */
    public Builder setBigqueryDataset(
        com.google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource.Builder
            builderForValue) {
      if (bigqueryDatasetBuilder_ == null) {
        source_ = builderForValue.build();
        onChanged();
      } else {
        bigqueryDatasetBuilder_.setMessage(builderForValue.build());
      }
      sourceCase_ = 6;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Shared dataset i.e. BigQuery dataset source.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource bigquery_dataset = 6;
     * </code>
     */
    public Builder mergeBigqueryDataset(
        com.google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource value) {
      if (bigqueryDatasetBuilder_ == null) {
        if (sourceCase_ == 6
            && source_
                != com.google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource
                    .getDefaultInstance()) {
          source_ =
              com.google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource.newBuilder(
                      (com.google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource)
                          source_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          source_ = value;
        }
        onChanged();
      } else {
        if (sourceCase_ == 6) {
          bigqueryDatasetBuilder_.mergeFrom(value);
        } else {
          bigqueryDatasetBuilder_.setMessage(value);
        }
      }
      sourceCase_ = 6;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Shared dataset i.e. BigQuery dataset source.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource bigquery_dataset = 6;
     * </code>
     */
    public Builder clearBigqueryDataset() {
      if (bigqueryDatasetBuilder_ == null) {
        if (sourceCase_ == 6) {
          sourceCase_ = 0;
          source_ = null;
          onChanged();
        }
      } else {
        if (sourceCase_ == 6) {
          sourceCase_ = 0;
          source_ = null;
        }
        bigqueryDatasetBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Shared dataset i.e. BigQuery dataset source.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource bigquery_dataset = 6;
     * </code>
     */
    public com.google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource.Builder
        getBigqueryDatasetBuilder() {
      return getBigqueryDatasetFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Shared dataset i.e. BigQuery dataset source.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource bigquery_dataset = 6;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSourceOrBuilder
        getBigqueryDatasetOrBuilder() {
      if ((sourceCase_ == 6) && (bigqueryDatasetBuilder_ != null)) {
        return bigqueryDatasetBuilder_.getMessageOrBuilder();
      } else {
        if (sourceCase_ == 6) {
          return (com.google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource) source_;
        }
        return com.google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource
            .getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Shared dataset i.e. BigQuery dataset source.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource bigquery_dataset = 6;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource,
            com.google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource.Builder,
            com.google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSourceOrBuilder>
        getBigqueryDatasetFieldBuilder() {
      if (bigqueryDatasetBuilder_ == null) {
        if (!(sourceCase_ == 6)) {
          source_ =
              com.google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource
                  .getDefaultInstance();
        }
        bigqueryDatasetBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource,
                com.google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource.Builder,
                com.google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSourceOrBuilder>(
                (com.google.cloud.bigquery.analyticshub.v1.Listing.BigQueryDatasetSource) source_,
                getParentForChildren(),
                isClean());
        source_ = null;
      }
      sourceCase_ = 6;
      onChanged();
      return bigqueryDatasetBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.bigquery.analyticshub.v1.Listing.PubSubTopicSource,
            com.google.cloud.bigquery.analyticshub.v1.Listing.PubSubTopicSource.Builder,
            com.google.cloud.bigquery.analyticshub.v1.Listing.PubSubTopicSourceOrBuilder>
        pubsubTopicBuilder_;

    /**
     *
     *
     * <pre>
     * Pub/Sub topic source.
     * </pre>
     *
     * <code>.google.cloud.bigquery.analyticshub.v1.Listing.PubSubTopicSource pubsub_topic = 16;
     * </code>
     *
     * @return Whether the pubsubTopic field is set.
     */
    @java.lang.Override
    public boolean hasPubsubTopic() {
      return sourceCase_ == 16;
    }

    /**
     *
     *
     * <pre>
     * Pub/Sub topic source.
     * </pre>
     *
     * <code>.google.cloud.bigquery.analyticshub.v1.Listing.PubSubTopicSource pubsub_topic = 16;
     * </code>
     *
     * @return The pubsubTopic.
     */
    @java.lang.Override
    public com.google.cloud.bigquery.analyticshub.v1.Listing.PubSubTopicSource getPubsubTopic() {
      if (pubsubTopicBuilder_ == null) {
        if (sourceCase_ == 16) {
          return (com.google.cloud.bigquery.analyticshub.v1.Listing.PubSubTopicSource) source_;
        }
        return com.google.cloud.bigquery.analyticshub.v1.Listing.PubSubTopicSource
            .getDefaultInstance();
      } else {
        if (sourceCase_ == 16) {
          return pubsubTopicBuilder_.getMessage();
        }
        return com.google.cloud.bigquery.analyticshub.v1.Listing.PubSubTopicSource
            .getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Pub/Sub topic source.
     * </pre>
     *
     * <code>.google.cloud.bigquery.analyticshub.v1.Listing.PubSubTopicSource pubsub_topic = 16;
     * </code>
     */
    public Builder setPubsubTopic(
        com.google.cloud.bigquery.analyticshub.v1.Listing.PubSubTopicSource value) {
      if (pubsubTopicBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        source_ = value;
        onChanged();
      } else {
        pubsubTopicBuilder_.setMessage(value);
      }
      sourceCase_ = 16;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Pub/Sub topic source.
     * </pre>
     *
     * <code>.google.cloud.bigquery.analyticshub.v1.Listing.PubSubTopicSource pubsub_topic = 16;
     * </code>
     */
    public Builder setPubsubTopic(
        com.google.cloud.bigquery.analyticshub.v1.Listing.PubSubTopicSource.Builder
            builderForValue) {
      if (pubsubTopicBuilder_ == null) {
        source_ = builderForValue.build();
        onChanged();
      } else {
        pubsubTopicBuilder_.setMessage(builderForValue.build());
      }
      sourceCase_ = 16;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Pub/Sub topic source.
     * </pre>
     *
     * <code>.google.cloud.bigquery.analyticshub.v1.Listing.PubSubTopicSource pubsub_topic = 16;
     * </code>
     */
    public Builder mergePubsubTopic(
        com.google.cloud.bigquery.analyticshub.v1.Listing.PubSubTopicSource value) {
      if (pubsubTopicBuilder_ == null) {
        if (sourceCase_ == 16
            && source_
                != com.google.cloud.bigquery.analyticshub.v1.Listing.PubSubTopicSource
                    .getDefaultInstance()) {
          source_ =
              com.google.cloud.bigquery.analyticshub.v1.Listing.PubSubTopicSource.newBuilder(
                      (com.google.cloud.bigquery.analyticshub.v1.Listing.PubSubTopicSource) source_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          source_ = value;
        }
        onChanged();
      } else {
        if (sourceCase_ == 16) {
          pubsubTopicBuilder_.mergeFrom(value);
        } else {
          pubsubTopicBuilder_.setMessage(value);
        }
      }
      sourceCase_ = 16;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Pub/Sub topic source.
     * </pre>
     *
     * <code>.google.cloud.bigquery.analyticshub.v1.Listing.PubSubTopicSource pubsub_topic = 16;
     * </code>
     */
    public Builder clearPubsubTopic() {
      if (pubsubTopicBuilder_ == null) {
        if (sourceCase_ == 16) {
          sourceCase_ = 0;
          source_ = null;
          onChanged();
        }
      } else {
        if (sourceCase_ == 16) {
          sourceCase_ = 0;
          source_ = null;
        }
        pubsubTopicBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Pub/Sub topic source.
     * </pre>
     *
     * <code>.google.cloud.bigquery.analyticshub.v1.Listing.PubSubTopicSource pubsub_topic = 16;
     * </code>
     */
    public com.google.cloud.bigquery.analyticshub.v1.Listing.PubSubTopicSource.Builder
        getPubsubTopicBuilder() {
      return getPubsubTopicFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Pub/Sub topic source.
     * </pre>
     *
     * <code>.google.cloud.bigquery.analyticshub.v1.Listing.PubSubTopicSource pubsub_topic = 16;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.bigquery.analyticshub.v1.Listing.PubSubTopicSourceOrBuilder
        getPubsubTopicOrBuilder() {
      if ((sourceCase_ == 16) && (pubsubTopicBuilder_ != null)) {
        return pubsubTopicBuilder_.getMessageOrBuilder();
      } else {
        if (sourceCase_ == 16) {
          return (com.google.cloud.bigquery.analyticshub.v1.Listing.PubSubTopicSource) source_;
        }
        return com.google.cloud.bigquery.analyticshub.v1.Listing.PubSubTopicSource
            .getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Pub/Sub topic source.
     * </pre>
     *
     * <code>.google.cloud.bigquery.analyticshub.v1.Listing.PubSubTopicSource pubsub_topic = 16;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.bigquery.analyticshub.v1.Listing.PubSubTopicSource,
            com.google.cloud.bigquery.analyticshub.v1.Listing.PubSubTopicSource.Builder,
            com.google.cloud.bigquery.analyticshub.v1.Listing.PubSubTopicSourceOrBuilder>
        getPubsubTopicFieldBuilder() {
      if (pubsubTopicBuilder_ == null) {
        if (!(sourceCase_ == 16)) {
          source_ =
              com.google.cloud.bigquery.analyticshub.v1.Listing.PubSubTopicSource
                  .getDefaultInstance();
        }
        pubsubTopicBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.bigquery.analyticshub.v1.Listing.PubSubTopicSource,
                com.google.cloud.bigquery.analyticshub.v1.Listing.PubSubTopicSource.Builder,
                com.google.cloud.bigquery.analyticshub.v1.Listing.PubSubTopicSourceOrBuilder>(
                (com.google.cloud.bigquery.analyticshub.v1.Listing.PubSubTopicSource) source_,
                getParentForChildren(),
                isClean());
        source_ = null;
      }
      sourceCase_ = 16;
      onChanged();
      return pubsubTopicBuilder_;
    }

    private java.lang.Object name_ = "";

    /**
     *
     *
     * <pre>
     * Output only. The resource name of the listing.
     * e.g. `projects/myproject/locations/us/dataExchanges/123/listings/456`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. The resource name of the listing.
     * e.g. `projects/myproject/locations/us/dataExchanges/123/listings/456`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. The resource name of the listing.
     * e.g. `projects/myproject/locations/us/dataExchanges/123/listings/456`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The resource name of the listing.
     * e.g. `projects/myproject/locations/us/dataExchanges/123/listings/456`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The resource name of the listing.
     * e.g. `projects/myproject/locations/us/dataExchanges/123/listings/456`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private java.lang.Object displayName_ = "";

    /**
     *
     *
     * <pre>
     * Required. Human-readable display name of the listing. The display name must
     * contain only Unicode letters, numbers (0-9), underscores (_), dashes (-),
     * spaces ( ), ampersands (&amp;) and can't start or end with spaces. Default
     * value is an empty string. Max length: 63 bytes.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The displayName.
     */
    public java.lang.String getDisplayName() {
      java.lang.Object ref = displayName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        displayName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. Human-readable display name of the listing. The display name must
     * contain only Unicode letters, numbers (0-9), underscores (_), dashes (-),
     * spaces ( ), ampersands (&amp;) and can't start or end with spaces. Default
     * value is an empty string. Max length: 63 bytes.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for displayName.
     */
    public com.google.protobuf.ByteString getDisplayNameBytes() {
      java.lang.Object ref = displayName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        displayName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. Human-readable display name of the listing. The display name must
     * contain only Unicode letters, numbers (0-9), underscores (_), dashes (-),
     * spaces ( ), ampersands (&amp;) and can't start or end with spaces. Default
     * value is an empty string. Max length: 63 bytes.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      displayName_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. Human-readable display name of the listing. The display name must
     * contain only Unicode letters, numbers (0-9), underscores (_), dashes (-),
     * spaces ( ), ampersands (&amp;) and can't start or end with spaces. Default
     * value is an empty string. Max length: 63 bytes.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDisplayName() {
      displayName_ = getDefaultInstance().getDisplayName();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. Human-readable display name of the listing. The display name must
     * contain only Unicode letters, numbers (0-9), underscores (_), dashes (-),
     * spaces ( ), ampersands (&amp;) and can't start or end with spaces. Default
     * value is an empty string. Max length: 63 bytes.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      displayName_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private java.lang.Object description_ = "";

    /**
     *
     *
     * <pre>
     * Optional. Short description of the listing. The description must not
     * contain Unicode non-characters and C0 and C1 control codes except tabs
     * (HT), new lines (LF), carriage returns (CR), and page breaks (FF). Default
     * value is an empty string. Max length: 2000 bytes.
     * </pre>
     *
     * <code>string description = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The description.
     */
    public java.lang.String getDescription() {
      java.lang.Object ref = description_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        description_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Short description of the listing. The description must not
     * contain Unicode non-characters and C0 and C1 control codes except tabs
     * (HT), new lines (LF), carriage returns (CR), and page breaks (FF). Default
     * value is an empty string. Max length: 2000 bytes.
     * </pre>
     *
     * <code>string description = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for description.
     */
    public com.google.protobuf.ByteString getDescriptionBytes() {
      java.lang.Object ref = description_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        description_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Short description of the listing. The description must not
     * contain Unicode non-characters and C0 and C1 control codes except tabs
     * (HT), new lines (LF), carriage returns (CR), and page breaks (FF). Default
     * value is an empty string. Max length: 2000 bytes.
     * </pre>
     *
     * <code>string description = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The description to set.
     * @return This builder for chaining.
     */
    public Builder setDescription(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      description_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Short description of the listing. The description must not
     * contain Unicode non-characters and C0 and C1 control codes except tabs
     * (HT), new lines (LF), carriage returns (CR), and page breaks (FF). Default
     * value is an empty string. Max length: 2000 bytes.
     * </pre>
     *
     * <code>string description = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDescription() {
      description_ = getDefaultInstance().getDescription();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Short description of the listing. The description must not
     * contain Unicode non-characters and C0 and C1 control codes except tabs
     * (HT), new lines (LF), carriage returns (CR), and page breaks (FF). Default
     * value is an empty string. Max length: 2000 bytes.
     * </pre>
     *
     * <code>string description = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for description to set.
     * @return This builder for chaining.
     */
    public Builder setDescriptionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      description_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private java.lang.Object primaryContact_ = "";

    /**
     *
     *
     * <pre>
     * Optional. Email or URL of the primary point of contact of the listing.
     * Max Length: 1000 bytes.
     * </pre>
     *
     * <code>string primary_contact = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The primaryContact.
     */
    public java.lang.String getPrimaryContact() {
      java.lang.Object ref = primaryContact_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        primaryContact_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Email or URL of the primary point of contact of the listing.
     * Max Length: 1000 bytes.
     * </pre>
     *
     * <code>string primary_contact = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for primaryContact.
     */
    public com.google.protobuf.ByteString getPrimaryContactBytes() {
      java.lang.Object ref = primaryContact_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        primaryContact_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Email or URL of the primary point of contact of the listing.
     * Max Length: 1000 bytes.
     * </pre>
     *
     * <code>string primary_contact = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The primaryContact to set.
     * @return This builder for chaining.
     */
    public Builder setPrimaryContact(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      primaryContact_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Email or URL of the primary point of contact of the listing.
     * Max Length: 1000 bytes.
     * </pre>
     *
     * <code>string primary_contact = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPrimaryContact() {
      primaryContact_ = getDefaultInstance().getPrimaryContact();
      bitField0_ = (bitField0_ & ~0x00000020);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Email or URL of the primary point of contact of the listing.
     * Max Length: 1000 bytes.
     * </pre>
     *
     * <code>string primary_contact = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for primaryContact to set.
     * @return This builder for chaining.
     */
    public Builder setPrimaryContactBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      primaryContact_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    private java.lang.Object documentation_ = "";

    /**
     *
     *
     * <pre>
     * Optional. Documentation describing the listing.
     * </pre>
     *
     * <code>string documentation = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The documentation.
     */
    public java.lang.String getDocumentation() {
      java.lang.Object ref = documentation_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        documentation_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Documentation describing the listing.
     * </pre>
     *
     * <code>string documentation = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for documentation.
     */
    public com.google.protobuf.ByteString getDocumentationBytes() {
      java.lang.Object ref = documentation_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        documentation_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Documentation describing the listing.
     * </pre>
     *
     * <code>string documentation = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The documentation to set.
     * @return This builder for chaining.
     */
    public Builder setDocumentation(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      documentation_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Documentation describing the listing.
     * </pre>
     *
     * <code>string documentation = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDocumentation() {
      documentation_ = getDefaultInstance().getDocumentation();
      bitField0_ = (bitField0_ & ~0x00000040);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Documentation describing the listing.
     * </pre>
     *
     * <code>string documentation = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for documentation to set.
     * @return This builder for chaining.
     */
    public Builder setDocumentationBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      documentation_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    private int state_ = 0;

    /**
     *
     *
     * <pre>
     * Output only. Current state of the listing.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.analyticshub.v1.Listing.State state = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for state.
     */
    @java.lang.Override
    public int getStateValue() {
      return state_;
    }

    /**
     *
     *
     * <pre>
     * Output only. Current state of the listing.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.analyticshub.v1.Listing.State state = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The enum numeric value on the wire for state to set.
     * @return This builder for chaining.
     */
    public Builder setStateValue(int value) {
      state_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Current state of the listing.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.analyticshub.v1.Listing.State state = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The state.
     */
    @java.lang.Override
    public com.google.cloud.bigquery.analyticshub.v1.Listing.State getState() {
      com.google.cloud.bigquery.analyticshub.v1.Listing.State result =
          com.google.cloud.bigquery.analyticshub.v1.Listing.State.forNumber(state_);
      return result == null
          ? com.google.cloud.bigquery.analyticshub.v1.Listing.State.UNRECOGNIZED
          : result;
    }

    /**
     *
     *
     * <pre>
     * Output only. Current state of the listing.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.analyticshub.v1.Listing.State state = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The state to set.
     * @return This builder for chaining.
     */
    public Builder setState(com.google.cloud.bigquery.analyticshub.v1.Listing.State value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000080;
      state_ = value.getNumber();
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Current state of the listing.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.analyticshub.v1.Listing.State state = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearState() {
      bitField0_ = (bitField0_ & ~0x00000080);
      state_ = 0;
      onChanged();
      return this;
    }

    private com.google.protobuf.ByteString icon_ = com.google.protobuf.ByteString.EMPTY;

    /**
     *
     *
     * <pre>
     * Optional. Base64 encoded image representing the listing. Max Size: 3.0MiB
     * Expected image dimensions are 512x512 pixels, however the API only
     * performs validation on size of the encoded data.
     * Note: For byte fields, the contents of the field are base64-encoded (which
     * increases the size of the data by 33-36%) when using JSON on the wire.
     * </pre>
     *
     * <code>bytes icon = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The icon.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getIcon() {
      return icon_;
    }

    /**
     *
     *
     * <pre>
     * Optional. Base64 encoded image representing the listing. Max Size: 3.0MiB
     * Expected image dimensions are 512x512 pixels, however the API only
     * performs validation on size of the encoded data.
     * Note: For byte fields, the contents of the field are base64-encoded (which
     * increases the size of the data by 33-36%) when using JSON on the wire.
     * </pre>
     *
     * <code>bytes icon = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The icon to set.
     * @return This builder for chaining.
     */
    public Builder setIcon(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      icon_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Base64 encoded image representing the listing. Max Size: 3.0MiB
     * Expected image dimensions are 512x512 pixels, however the API only
     * performs validation on size of the encoded data.
     * Note: For byte fields, the contents of the field are base64-encoded (which
     * increases the size of the data by 33-36%) when using JSON on the wire.
     * </pre>
     *
     * <code>bytes icon = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearIcon() {
      bitField0_ = (bitField0_ & ~0x00000100);
      icon_ = getDefaultInstance().getIcon();
      onChanged();
      return this;
    }

    private com.google.cloud.bigquery.analyticshub.v1.DataProvider dataProvider_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.bigquery.analyticshub.v1.DataProvider,
            com.google.cloud.bigquery.analyticshub.v1.DataProvider.Builder,
            com.google.cloud.bigquery.analyticshub.v1.DataProviderOrBuilder>
        dataProviderBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. Details of the data provider who owns the source data.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.analyticshub.v1.DataProvider data_provider = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the dataProvider field is set.
     */
    public boolean hasDataProvider() {
      return ((bitField0_ & 0x00000200) != 0);
    }

    /**
     *
     *
     * <pre>
     * Optional. Details of the data provider who owns the source data.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.analyticshub.v1.DataProvider data_provider = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The dataProvider.
     */
    public com.google.cloud.bigquery.analyticshub.v1.DataProvider getDataProvider() {
      if (dataProviderBuilder_ == null) {
        return dataProvider_ == null
            ? com.google.cloud.bigquery.analyticshub.v1.DataProvider.getDefaultInstance()
            : dataProvider_;
      } else {
        return dataProviderBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Details of the data provider who owns the source data.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.analyticshub.v1.DataProvider data_provider = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setDataProvider(com.google.cloud.bigquery.analyticshub.v1.DataProvider value) {
      if (dataProviderBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        dataProvider_ = value;
      } else {
        dataProviderBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Details of the data provider who owns the source data.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.analyticshub.v1.DataProvider data_provider = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setDataProvider(
        com.google.cloud.bigquery.analyticshub.v1.DataProvider.Builder builderForValue) {
      if (dataProviderBuilder_ == null) {
        dataProvider_ = builderForValue.build();
      } else {
        dataProviderBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Details of the data provider who owns the source data.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.analyticshub.v1.DataProvider data_provider = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeDataProvider(com.google.cloud.bigquery.analyticshub.v1.DataProvider value) {
      if (dataProviderBuilder_ == null) {
        if (((bitField0_ & 0x00000200) != 0)
            && dataProvider_ != null
            && dataProvider_
                != com.google.cloud.bigquery.analyticshub.v1.DataProvider.getDefaultInstance()) {
          getDataProviderBuilder().mergeFrom(value);
        } else {
          dataProvider_ = value;
        }
      } else {
        dataProviderBuilder_.mergeFrom(value);
      }
      if (dataProvider_ != null) {
        bitField0_ |= 0x00000200;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Details of the data provider who owns the source data.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.analyticshub.v1.DataProvider data_provider = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearDataProvider() {
      bitField0_ = (bitField0_ & ~0x00000200);
      dataProvider_ = null;
      if (dataProviderBuilder_ != null) {
        dataProviderBuilder_.dispose();
        dataProviderBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Details of the data provider who owns the source data.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.analyticshub.v1.DataProvider data_provider = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.bigquery.analyticshub.v1.DataProvider.Builder getDataProviderBuilder() {
      bitField0_ |= 0x00000200;
      onChanged();
      return getDataProviderFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Optional. Details of the data provider who owns the source data.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.analyticshub.v1.DataProvider data_provider = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.bigquery.analyticshub.v1.DataProviderOrBuilder
        getDataProviderOrBuilder() {
      if (dataProviderBuilder_ != null) {
        return dataProviderBuilder_.getMessageOrBuilder();
      } else {
        return dataProvider_ == null
            ? com.google.cloud.bigquery.analyticshub.v1.DataProvider.getDefaultInstance()
            : dataProvider_;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Details of the data provider who owns the source data.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.analyticshub.v1.DataProvider data_provider = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.bigquery.analyticshub.v1.DataProvider,
            com.google.cloud.bigquery.analyticshub.v1.DataProvider.Builder,
            com.google.cloud.bigquery.analyticshub.v1.DataProviderOrBuilder>
        getDataProviderFieldBuilder() {
      if (dataProviderBuilder_ == null) {
        dataProviderBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.bigquery.analyticshub.v1.DataProvider,
                com.google.cloud.bigquery.analyticshub.v1.DataProvider.Builder,
                com.google.cloud.bigquery.analyticshub.v1.DataProviderOrBuilder>(
                getDataProvider(), getParentForChildren(), isClean());
        dataProvider_ = null;
      }
      return dataProviderBuilder_;
    }

    private java.util.List<java.lang.Integer> categories_ = java.util.Collections.emptyList();

    private void ensureCategoriesIsMutable() {
      if (!((bitField0_ & 0x00000400) != 0)) {
        categories_ = new java.util.ArrayList<java.lang.Integer>(categories_);
        bitField0_ |= 0x00000400;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Categories of the listing. Up to two categories are allowed.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.analyticshub.v1.Listing.Category categories = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return A list containing the categories.
     */
    public java.util.List<com.google.cloud.bigquery.analyticshub.v1.Listing.Category>
        getCategoriesList() {
      return new com.google.protobuf.Internal.ListAdapter<
          java.lang.Integer, com.google.cloud.bigquery.analyticshub.v1.Listing.Category>(
          categories_, categories_converter_);
    }

    /**
     *
     *
     * <pre>
     * Optional. Categories of the listing. Up to two categories are allowed.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.analyticshub.v1.Listing.Category categories = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The count of categories.
     */
    public int getCategoriesCount() {
      return categories_.size();
    }

    /**
     *
     *
     * <pre>
     * Optional. Categories of the listing. Up to two categories are allowed.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.analyticshub.v1.Listing.Category categories = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param index The index of the element to return.
     * @return The categories at the given index.
     */
    public com.google.cloud.bigquery.analyticshub.v1.Listing.Category getCategories(int index) {
      return categories_converter_.convert(categories_.get(index));
    }

    /**
     *
     *
     * <pre>
     * Optional. Categories of the listing. Up to two categories are allowed.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.analyticshub.v1.Listing.Category categories = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param index The index to set the value at.
     * @param value The categories to set.
     * @return This builder for chaining.
     */
    public Builder setCategories(
        int index, com.google.cloud.bigquery.analyticshub.v1.Listing.Category value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureCategoriesIsMutable();
      categories_.set(index, value.getNumber());
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Categories of the listing. Up to two categories are allowed.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.analyticshub.v1.Listing.Category categories = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The categories to add.
     * @return This builder for chaining.
     */
    public Builder addCategories(com.google.cloud.bigquery.analyticshub.v1.Listing.Category value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureCategoriesIsMutable();
      categories_.add(value.getNumber());
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Categories of the listing. Up to two categories are allowed.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.analyticshub.v1.Listing.Category categories = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param values The categories to add.
     * @return This builder for chaining.
     */
    public Builder addAllCategories(
        java.lang.Iterable<? extends com.google.cloud.bigquery.analyticshub.v1.Listing.Category>
            values) {
      ensureCategoriesIsMutable();
      for (com.google.cloud.bigquery.analyticshub.v1.Listing.Category value : values) {
        categories_.add(value.getNumber());
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Categories of the listing. Up to two categories are allowed.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.analyticshub.v1.Listing.Category categories = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCategories() {
      categories_ = java.util.Collections.emptyList();
      bitField0_ = (bitField0_ & ~0x00000400);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Categories of the listing. Up to two categories are allowed.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.analyticshub.v1.Listing.Category categories = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return A list containing the enum numeric values on the wire for categories.
     */
    public java.util.List<java.lang.Integer> getCategoriesValueList() {
      return java.util.Collections.unmodifiableList(categories_);
    }

    /**
     *
     *
     * <pre>
     * Optional. Categories of the listing. Up to two categories are allowed.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.analyticshub.v1.Listing.Category categories = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param index The index of the value to return.
     * @return The enum numeric value on the wire of categories at the given index.
     */
    public int getCategoriesValue(int index) {
      return categories_.get(index);
    }

    /**
     *
     *
     * <pre>
     * Optional. Categories of the listing. Up to two categories are allowed.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.analyticshub.v1.Listing.Category categories = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param index The index to set the value at.
     * @param value The enum numeric value on the wire for categories to set.
     * @return This builder for chaining.
     */
    public Builder setCategoriesValue(int index, int value) {
      ensureCategoriesIsMutable();
      categories_.set(index, value);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Categories of the listing. Up to two categories are allowed.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.analyticshub.v1.Listing.Category categories = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The enum numeric value on the wire for categories to add.
     * @return This builder for chaining.
     */
    public Builder addCategoriesValue(int value) {
      ensureCategoriesIsMutable();
      categories_.add(value);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Categories of the listing. Up to two categories are allowed.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.analyticshub.v1.Listing.Category categories = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param values The enum numeric values on the wire for categories to add.
     * @return This builder for chaining.
     */
    public Builder addAllCategoriesValue(java.lang.Iterable<java.lang.Integer> values) {
      ensureCategoriesIsMutable();
      for (int value : values) {
        categories_.add(value);
      }
      onChanged();
      return this;
    }

    private com.google.cloud.bigquery.analyticshub.v1.Publisher publisher_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.bigquery.analyticshub.v1.Publisher,
            com.google.cloud.bigquery.analyticshub.v1.Publisher.Builder,
            com.google.cloud.bigquery.analyticshub.v1.PublisherOrBuilder>
        publisherBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. Details of the publisher who owns the listing and who can share
     * the source data.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.analyticshub.v1.Publisher publisher = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the publisher field is set.
     */
    public boolean hasPublisher() {
      return ((bitField0_ & 0x00000800) != 0);
    }

    /**
     *
     *
     * <pre>
     * Optional. Details of the publisher who owns the listing and who can share
     * the source data.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.analyticshub.v1.Publisher publisher = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The publisher.
     */
    public com.google.cloud.bigquery.analyticshub.v1.Publisher getPublisher() {
      if (publisherBuilder_ == null) {
        return publisher_ == null
            ? com.google.cloud.bigquery.analyticshub.v1.Publisher.getDefaultInstance()
            : publisher_;
      } else {
        return publisherBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Details of the publisher who owns the listing and who can share
     * the source data.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.analyticshub.v1.Publisher publisher = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setPublisher(com.google.cloud.bigquery.analyticshub.v1.Publisher value) {
      if (publisherBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        publisher_ = value;
      } else {
        publisherBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Details of the publisher who owns the listing and who can share
     * the source data.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.analyticshub.v1.Publisher publisher = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setPublisher(
        com.google.cloud.bigquery.analyticshub.v1.Publisher.Builder builderForValue) {
      if (publisherBuilder_ == null) {
        publisher_ = builderForValue.build();
      } else {
        publisherBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Details of the publisher who owns the listing and who can share
     * the source data.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.analyticshub.v1.Publisher publisher = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergePublisher(com.google.cloud.bigquery.analyticshub.v1.Publisher value) {
      if (publisherBuilder_ == null) {
        if (((bitField0_ & 0x00000800) != 0)
            && publisher_ != null
            && publisher_
                != com.google.cloud.bigquery.analyticshub.v1.Publisher.getDefaultInstance()) {
          getPublisherBuilder().mergeFrom(value);
        } else {
          publisher_ = value;
        }
      } else {
        publisherBuilder_.mergeFrom(value);
      }
      if (publisher_ != null) {
        bitField0_ |= 0x00000800;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Details of the publisher who owns the listing and who can share
     * the source data.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.analyticshub.v1.Publisher publisher = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearPublisher() {
      bitField0_ = (bitField0_ & ~0x00000800);
      publisher_ = null;
      if (publisherBuilder_ != null) {
        publisherBuilder_.dispose();
        publisherBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Details of the publisher who owns the listing and who can share
     * the source data.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.analyticshub.v1.Publisher publisher = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.bigquery.analyticshub.v1.Publisher.Builder getPublisherBuilder() {
      bitField0_ |= 0x00000800;
      onChanged();
      return getPublisherFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Optional. Details of the publisher who owns the listing and who can share
     * the source data.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.analyticshub.v1.Publisher publisher = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.bigquery.analyticshub.v1.PublisherOrBuilder getPublisherOrBuilder() {
      if (publisherBuilder_ != null) {
        return publisherBuilder_.getMessageOrBuilder();
      } else {
        return publisher_ == null
            ? com.google.cloud.bigquery.analyticshub.v1.Publisher.getDefaultInstance()
            : publisher_;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Details of the publisher who owns the listing and who can share
     * the source data.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.analyticshub.v1.Publisher publisher = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.bigquery.analyticshub.v1.Publisher,
            com.google.cloud.bigquery.analyticshub.v1.Publisher.Builder,
            com.google.cloud.bigquery.analyticshub.v1.PublisherOrBuilder>
        getPublisherFieldBuilder() {
      if (publisherBuilder_ == null) {
        publisherBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.bigquery.analyticshub.v1.Publisher,
                com.google.cloud.bigquery.analyticshub.v1.Publisher.Builder,
                com.google.cloud.bigquery.analyticshub.v1.PublisherOrBuilder>(
                getPublisher(), getParentForChildren(), isClean());
        publisher_ = null;
      }
      return publisherBuilder_;
    }

    private java.lang.Object requestAccess_ = "";

    /**
     *
     *
     * <pre>
     * Optional. Email or URL of the request access of the listing.
     * Subscribers can use this reference to request access.
     * Max Length: 1000 bytes.
     * </pre>
     *
     * <code>string request_access = 12 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The requestAccess.
     */
    public java.lang.String getRequestAccess() {
      java.lang.Object ref = requestAccess_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        requestAccess_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Email or URL of the request access of the listing.
     * Subscribers can use this reference to request access.
     * Max Length: 1000 bytes.
     * </pre>
     *
     * <code>string request_access = 12 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for requestAccess.
     */
    public com.google.protobuf.ByteString getRequestAccessBytes() {
      java.lang.Object ref = requestAccess_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        requestAccess_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Email or URL of the request access of the listing.
     * Subscribers can use this reference to request access.
     * Max Length: 1000 bytes.
     * </pre>
     *
     * <code>string request_access = 12 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The requestAccess to set.
     * @return This builder for chaining.
     */
    public Builder setRequestAccess(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      requestAccess_ = value;
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Email or URL of the request access of the listing.
     * Subscribers can use this reference to request access.
     * Max Length: 1000 bytes.
     * </pre>
     *
     * <code>string request_access = 12 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRequestAccess() {
      requestAccess_ = getDefaultInstance().getRequestAccess();
      bitField0_ = (bitField0_ & ~0x00001000);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Email or URL of the request access of the listing.
     * Subscribers can use this reference to request access.
     * Max Length: 1000 bytes.
     * </pre>
     *
     * <code>string request_access = 12 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for requestAccess to set.
     * @return This builder for chaining.
     */
    public Builder setRequestAccessBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      requestAccess_ = value;
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }

    private com.google.cloud.bigquery.analyticshub.v1.Listing.RestrictedExportConfig
        restrictedExportConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.bigquery.analyticshub.v1.Listing.RestrictedExportConfig,
            com.google.cloud.bigquery.analyticshub.v1.Listing.RestrictedExportConfig.Builder,
            com.google.cloud.bigquery.analyticshub.v1.Listing.RestrictedExportConfigOrBuilder>
        restrictedExportConfigBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. If set, restricted export configuration will be propagated and
     * enforced on the linked dataset.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.analyticshub.v1.Listing.RestrictedExportConfig restricted_export_config = 13 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the restrictedExportConfig field is set.
     */
    public boolean hasRestrictedExportConfig() {
      return ((bitField0_ & 0x00002000) != 0);
    }

    /**
     *
     *
     * <pre>
     * Optional. If set, restricted export configuration will be propagated and
     * enforced on the linked dataset.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.analyticshub.v1.Listing.RestrictedExportConfig restricted_export_config = 13 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The restrictedExportConfig.
     */
    public com.google.cloud.bigquery.analyticshub.v1.Listing.RestrictedExportConfig
        getRestrictedExportConfig() {
      if (restrictedExportConfigBuilder_ == null) {
        return restrictedExportConfig_ == null
            ? com.google.cloud.bigquery.analyticshub.v1.Listing.RestrictedExportConfig
                .getDefaultInstance()
            : restrictedExportConfig_;
      } else {
        return restrictedExportConfigBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. If set, restricted export configuration will be propagated and
     * enforced on the linked dataset.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.analyticshub.v1.Listing.RestrictedExportConfig restricted_export_config = 13 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setRestrictedExportConfig(
        com.google.cloud.bigquery.analyticshub.v1.Listing.RestrictedExportConfig value) {
      if (restrictedExportConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        restrictedExportConfig_ = value;
      } else {
        restrictedExportConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. If set, restricted export configuration will be propagated and
     * enforced on the linked dataset.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.analyticshub.v1.Listing.RestrictedExportConfig restricted_export_config = 13 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setRestrictedExportConfig(
        com.google.cloud.bigquery.analyticshub.v1.Listing.RestrictedExportConfig.Builder
            builderForValue) {
      if (restrictedExportConfigBuilder_ == null) {
        restrictedExportConfig_ = builderForValue.build();
      } else {
        restrictedExportConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. If set, restricted export configuration will be propagated and
     * enforced on the linked dataset.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.analyticshub.v1.Listing.RestrictedExportConfig restricted_export_config = 13 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeRestrictedExportConfig(
        com.google.cloud.bigquery.analyticshub.v1.Listing.RestrictedExportConfig value) {
      if (restrictedExportConfigBuilder_ == null) {
        if (((bitField0_ & 0x00002000) != 0)
            && restrictedExportConfig_ != null
            && restrictedExportConfig_
                != com.google.cloud.bigquery.analyticshub.v1.Listing.RestrictedExportConfig
                    .getDefaultInstance()) {
          getRestrictedExportConfigBuilder().mergeFrom(value);
        } else {
          restrictedExportConfig_ = value;
        }
      } else {
        restrictedExportConfigBuilder_.mergeFrom(value);
      }
      if (restrictedExportConfig_ != null) {
        bitField0_ |= 0x00002000;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. If set, restricted export configuration will be propagated and
     * enforced on the linked dataset.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.analyticshub.v1.Listing.RestrictedExportConfig restricted_export_config = 13 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearRestrictedExportConfig() {
      bitField0_ = (bitField0_ & ~0x00002000);
      restrictedExportConfig_ = null;
      if (restrictedExportConfigBuilder_ != null) {
        restrictedExportConfigBuilder_.dispose();
        restrictedExportConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. If set, restricted export configuration will be propagated and
     * enforced on the linked dataset.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.analyticshub.v1.Listing.RestrictedExportConfig restricted_export_config = 13 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.bigquery.analyticshub.v1.Listing.RestrictedExportConfig.Builder
        getRestrictedExportConfigBuilder() {
      bitField0_ |= 0x00002000;
      onChanged();
      return getRestrictedExportConfigFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Optional. If set, restricted export configuration will be propagated and
     * enforced on the linked dataset.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.analyticshub.v1.Listing.RestrictedExportConfig restricted_export_config = 13 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.bigquery.analyticshub.v1.Listing.RestrictedExportConfigOrBuilder
        getRestrictedExportConfigOrBuilder() {
      if (restrictedExportConfigBuilder_ != null) {
        return restrictedExportConfigBuilder_.getMessageOrBuilder();
      } else {
        return restrictedExportConfig_ == null
            ? com.google.cloud.bigquery.analyticshub.v1.Listing.RestrictedExportConfig
                .getDefaultInstance()
            : restrictedExportConfig_;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. If set, restricted export configuration will be propagated and
     * enforced on the linked dataset.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.analyticshub.v1.Listing.RestrictedExportConfig restricted_export_config = 13 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.bigquery.analyticshub.v1.Listing.RestrictedExportConfig,
            com.google.cloud.bigquery.analyticshub.v1.Listing.RestrictedExportConfig.Builder,
            com.google.cloud.bigquery.analyticshub.v1.Listing.RestrictedExportConfigOrBuilder>
        getRestrictedExportConfigFieldBuilder() {
      if (restrictedExportConfigBuilder_ == null) {
        restrictedExportConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.bigquery.analyticshub.v1.Listing.RestrictedExportConfig,
                com.google.cloud.bigquery.analyticshub.v1.Listing.RestrictedExportConfig.Builder,
                com.google.cloud.bigquery.analyticshub.v1.Listing.RestrictedExportConfigOrBuilder>(
                getRestrictedExportConfig(), getParentForChildren(), isClean());
        restrictedExportConfig_ = null;
      }
      return restrictedExportConfigBuilder_;
    }

    private int discoveryType_ = 0;

    /**
     *
     *
     * <pre>
     * Optional. Type of discovery of the listing on the discovery page.
     * </pre>
     *
     * <code>
     * optional .google.cloud.bigquery.analyticshub.v1.DiscoveryType discovery_type = 14 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the discoveryType field is set.
     */
    @java.lang.Override
    public boolean hasDiscoveryType() {
      return ((bitField0_ & 0x00004000) != 0);
    }

    /**
     *
     *
     * <pre>
     * Optional. Type of discovery of the listing on the discovery page.
     * </pre>
     *
     * <code>
     * optional .google.cloud.bigquery.analyticshub.v1.DiscoveryType discovery_type = 14 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The enum numeric value on the wire for discoveryType.
     */
    @java.lang.Override
    public int getDiscoveryTypeValue() {
      return discoveryType_;
    }

    /**
     *
     *
     * <pre>
     * Optional. Type of discovery of the listing on the discovery page.
     * </pre>
     *
     * <code>
     * optional .google.cloud.bigquery.analyticshub.v1.DiscoveryType discovery_type = 14 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The enum numeric value on the wire for discoveryType to set.
     * @return This builder for chaining.
     */
    public Builder setDiscoveryTypeValue(int value) {
      discoveryType_ = value;
      bitField0_ |= 0x00004000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Type of discovery of the listing on the discovery page.
     * </pre>
     *
     * <code>
     * optional .google.cloud.bigquery.analyticshub.v1.DiscoveryType discovery_type = 14 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The discoveryType.
     */
    @java.lang.Override
    public com.google.cloud.bigquery.analyticshub.v1.DiscoveryType getDiscoveryType() {
      com.google.cloud.bigquery.analyticshub.v1.DiscoveryType result =
          com.google.cloud.bigquery.analyticshub.v1.DiscoveryType.forNumber(discoveryType_);
      return result == null
          ? com.google.cloud.bigquery.analyticshub.v1.DiscoveryType.UNRECOGNIZED
          : result;
    }

    /**
     *
     *
     * <pre>
     * Optional. Type of discovery of the listing on the discovery page.
     * </pre>
     *
     * <code>
     * optional .google.cloud.bigquery.analyticshub.v1.DiscoveryType discovery_type = 14 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The discoveryType to set.
     * @return This builder for chaining.
     */
    public Builder setDiscoveryType(com.google.cloud.bigquery.analyticshub.v1.DiscoveryType value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00004000;
      discoveryType_ = value.getNumber();
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Type of discovery of the listing on the discovery page.
     * </pre>
     *
     * <code>
     * optional .google.cloud.bigquery.analyticshub.v1.DiscoveryType discovery_type = 14 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDiscoveryType() {
      bitField0_ = (bitField0_ & ~0x00004000);
      discoveryType_ = 0;
      onChanged();
      return this;
    }

    private int resourceType_ = 0;

    /**
     *
     *
     * <pre>
     * Output only. Listing shared asset type.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.analyticshub.v1.SharedResourceType resource_type = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for resourceType.
     */
    @java.lang.Override
    public int getResourceTypeValue() {
      return resourceType_;
    }

    /**
     *
     *
     * <pre>
     * Output only. Listing shared asset type.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.analyticshub.v1.SharedResourceType resource_type = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The enum numeric value on the wire for resourceType to set.
     * @return This builder for chaining.
     */
    public Builder setResourceTypeValue(int value) {
      resourceType_ = value;
      bitField0_ |= 0x00008000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Listing shared asset type.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.analyticshub.v1.SharedResourceType resource_type = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The resourceType.
     */
    @java.lang.Override
    public com.google.cloud.bigquery.analyticshub.v1.SharedResourceType getResourceType() {
      com.google.cloud.bigquery.analyticshub.v1.SharedResourceType result =
          com.google.cloud.bigquery.analyticshub.v1.SharedResourceType.forNumber(resourceType_);
      return result == null
          ? com.google.cloud.bigquery.analyticshub.v1.SharedResourceType.UNRECOGNIZED
          : result;
    }

    /**
     *
     *
     * <pre>
     * Output only. Listing shared asset type.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.analyticshub.v1.SharedResourceType resource_type = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The resourceType to set.
     * @return This builder for chaining.
     */
    public Builder setResourceType(
        com.google.cloud.bigquery.analyticshub.v1.SharedResourceType value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00008000;
      resourceType_ = value.getNumber();
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Listing shared asset type.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.analyticshub.v1.SharedResourceType resource_type = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearResourceType() {
      bitField0_ = (bitField0_ & ~0x00008000);
      resourceType_ = 0;
      onChanged();
      return this;
    }

    private com.google.cloud.bigquery.analyticshub.v1.Listing.CommercialInfo commercialInfo_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.bigquery.analyticshub.v1.Listing.CommercialInfo,
            com.google.cloud.bigquery.analyticshub.v1.Listing.CommercialInfo.Builder,
            com.google.cloud.bigquery.analyticshub.v1.Listing.CommercialInfoOrBuilder>
        commercialInfoBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. Commercial info contains the information about the commercial
     * data products associated with the listing.
     * </pre>
     *
     * <code>
     * optional .google.cloud.bigquery.analyticshub.v1.Listing.CommercialInfo commercial_info = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the commercialInfo field is set.
     */
    public boolean hasCommercialInfo() {
      return ((bitField0_ & 0x00010000) != 0);
    }

    /**
     *
     *
     * <pre>
     * Output only. Commercial info contains the information about the commercial
     * data products associated with the listing.
     * </pre>
     *
     * <code>
     * optional .google.cloud.bigquery.analyticshub.v1.Listing.CommercialInfo commercial_info = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The commercialInfo.
     */
    public com.google.cloud.bigquery.analyticshub.v1.Listing.CommercialInfo getCommercialInfo() {
      if (commercialInfoBuilder_ == null) {
        return commercialInfo_ == null
            ? com.google.cloud.bigquery.analyticshub.v1.Listing.CommercialInfo.getDefaultInstance()
            : commercialInfo_;
      } else {
        return commercialInfoBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Commercial info contains the information about the commercial
     * data products associated with the listing.
     * </pre>
     *
     * <code>
     * optional .google.cloud.bigquery.analyticshub.v1.Listing.CommercialInfo commercial_info = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCommercialInfo(
        com.google.cloud.bigquery.analyticshub.v1.Listing.CommercialInfo value) {
      if (commercialInfoBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        commercialInfo_ = value;
      } else {
        commercialInfoBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00010000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Commercial info contains the information about the commercial
     * data products associated with the listing.
     * </pre>
     *
     * <code>
     * optional .google.cloud.bigquery.analyticshub.v1.Listing.CommercialInfo commercial_info = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCommercialInfo(
        com.google.cloud.bigquery.analyticshub.v1.Listing.CommercialInfo.Builder builderForValue) {
      if (commercialInfoBuilder_ == null) {
        commercialInfo_ = builderForValue.build();
      } else {
        commercialInfoBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00010000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Commercial info contains the information about the commercial
     * data products associated with the listing.
     * </pre>
     *
     * <code>
     * optional .google.cloud.bigquery.analyticshub.v1.Listing.CommercialInfo commercial_info = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeCommercialInfo(
        com.google.cloud.bigquery.analyticshub.v1.Listing.CommercialInfo value) {
      if (commercialInfoBuilder_ == null) {
        if (((bitField0_ & 0x00010000) != 0)
            && commercialInfo_ != null
            && commercialInfo_
                != com.google.cloud.bigquery.analyticshub.v1.Listing.CommercialInfo
                    .getDefaultInstance()) {
          getCommercialInfoBuilder().mergeFrom(value);
        } else {
          commercialInfo_ = value;
        }
      } else {
        commercialInfoBuilder_.mergeFrom(value);
      }
      if (commercialInfo_ != null) {
        bitField0_ |= 0x00010000;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Commercial info contains the information about the commercial
     * data products associated with the listing.
     * </pre>
     *
     * <code>
     * optional .google.cloud.bigquery.analyticshub.v1.Listing.CommercialInfo commercial_info = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearCommercialInfo() {
      bitField0_ = (bitField0_ & ~0x00010000);
      commercialInfo_ = null;
      if (commercialInfoBuilder_ != null) {
        commercialInfoBuilder_.dispose();
        commercialInfoBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Commercial info contains the information about the commercial
     * data products associated with the listing.
     * </pre>
     *
     * <code>
     * optional .google.cloud.bigquery.analyticshub.v1.Listing.CommercialInfo commercial_info = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.bigquery.analyticshub.v1.Listing.CommercialInfo.Builder
        getCommercialInfoBuilder() {
      bitField0_ |= 0x00010000;
      onChanged();
      return getCommercialInfoFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Output only. Commercial info contains the information about the commercial
     * data products associated with the listing.
     * </pre>
     *
     * <code>
     * optional .google.cloud.bigquery.analyticshub.v1.Listing.CommercialInfo commercial_info = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.bigquery.analyticshub.v1.Listing.CommercialInfoOrBuilder
        getCommercialInfoOrBuilder() {
      if (commercialInfoBuilder_ != null) {
        return commercialInfoBuilder_.getMessageOrBuilder();
      } else {
        return commercialInfo_ == null
            ? com.google.cloud.bigquery.analyticshub.v1.Listing.CommercialInfo.getDefaultInstance()
            : commercialInfo_;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Commercial info contains the information about the commercial
     * data products associated with the listing.
     * </pre>
     *
     * <code>
     * optional .google.cloud.bigquery.analyticshub.v1.Listing.CommercialInfo commercial_info = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.bigquery.analyticshub.v1.Listing.CommercialInfo,
            com.google.cloud.bigquery.analyticshub.v1.Listing.CommercialInfo.Builder,
            com.google.cloud.bigquery.analyticshub.v1.Listing.CommercialInfoOrBuilder>
        getCommercialInfoFieldBuilder() {
      if (commercialInfoBuilder_ == null) {
        commercialInfoBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.bigquery.analyticshub.v1.Listing.CommercialInfo,
                com.google.cloud.bigquery.analyticshub.v1.Listing.CommercialInfo.Builder,
                com.google.cloud.bigquery.analyticshub.v1.Listing.CommercialInfoOrBuilder>(
                getCommercialInfo(), getParentForChildren(), isClean());
        commercialInfo_ = null;
      }
      return commercialInfoBuilder_;
    }

    private boolean logLinkedDatasetQueryUserEmail_;

    /**
     *
     *
     * <pre>
     * Optional. By default, false.
     * If true, the Listing has an email sharing mandate enabled.
     * </pre>
     *
     * <code>
     * optional bool log_linked_dataset_query_user_email = 18 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the logLinkedDatasetQueryUserEmail field is set.
     */
    @java.lang.Override
    public boolean hasLogLinkedDatasetQueryUserEmail() {
      return ((bitField0_ & 0x00020000) != 0);
    }

    /**
     *
     *
     * <pre>
     * Optional. By default, false.
     * If true, the Listing has an email sharing mandate enabled.
     * </pre>
     *
     * <code>
     * optional bool log_linked_dataset_query_user_email = 18 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The logLinkedDatasetQueryUserEmail.
     */
    @java.lang.Override
    public boolean getLogLinkedDatasetQueryUserEmail() {
      return logLinkedDatasetQueryUserEmail_;
    }

    /**
     *
     *
     * <pre>
     * Optional. By default, false.
     * If true, the Listing has an email sharing mandate enabled.
     * </pre>
     *
     * <code>
     * optional bool log_linked_dataset_query_user_email = 18 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The logLinkedDatasetQueryUserEmail to set.
     * @return This builder for chaining.
     */
    public Builder setLogLinkedDatasetQueryUserEmail(boolean value) {

      logLinkedDatasetQueryUserEmail_ = value;
      bitField0_ |= 0x00020000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. By default, false.
     * If true, the Listing has an email sharing mandate enabled.
     * </pre>
     *
     * <code>
     * optional bool log_linked_dataset_query_user_email = 18 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearLogLinkedDatasetQueryUserEmail() {
      bitField0_ = (bitField0_ & ~0x00020000);
      logLinkedDatasetQueryUserEmail_ = false;
      onChanged();
      return this;
    }

    private boolean allowOnlyMetadataSharing_;

    /**
     *
     *
     * <pre>
     * Optional. If true, the listing is only available to get the resource
     * metadata. Listing is non subscribable.
     * </pre>
     *
     * <code>
     * optional bool allow_only_metadata_sharing = 19 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the allowOnlyMetadataSharing field is set.
     */
    @java.lang.Override
    public boolean hasAllowOnlyMetadataSharing() {
      return ((bitField0_ & 0x00040000) != 0);
    }

    /**
     *
     *
     * <pre>
     * Optional. If true, the listing is only available to get the resource
     * metadata. Listing is non subscribable.
     * </pre>
     *
     * <code>
     * optional bool allow_only_metadata_sharing = 19 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The allowOnlyMetadataSharing.
     */
    @java.lang.Override
    public boolean getAllowOnlyMetadataSharing() {
      return allowOnlyMetadataSharing_;
    }

    /**
     *
     *
     * <pre>
     * Optional. If true, the listing is only available to get the resource
     * metadata. Listing is non subscribable.
     * </pre>
     *
     * <code>
     * optional bool allow_only_metadata_sharing = 19 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The allowOnlyMetadataSharing to set.
     * @return This builder for chaining.
     */
    public Builder setAllowOnlyMetadataSharing(boolean value) {

      allowOnlyMetadataSharing_ = value;
      bitField0_ |= 0x00040000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. If true, the listing is only available to get the resource
     * metadata. Listing is non subscribable.
     * </pre>
     *
     * <code>
     * optional bool allow_only_metadata_sharing = 19 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAllowOnlyMetadataSharing() {
      bitField0_ = (bitField0_ & ~0x00040000);
      allowOnlyMetadataSharing_ = false;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.bigquery.analyticshub.v1.Listing)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.bigquery.analyticshub.v1.Listing)
  private static final com.google.cloud.bigquery.analyticshub.v1.Listing DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.bigquery.analyticshub.v1.Listing();
  }

  public static com.google.cloud.bigquery.analyticshub.v1.Listing getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Listing> PARSER =
      new com.google.protobuf.AbstractParser<Listing>() {
        @java.lang.Override
        public Listing parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Listing> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Listing> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.bigquery.analyticshub.v1.Listing getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
