/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/bigquery/analyticshub/v1/analyticshub.proto

// Protobuf Java Version: 3.25.8
package com.google.cloud.bigquery.analyticshub.v1;

/**
 *
 *
 * <pre>
 * Defines the destination bigquery dataset.
 * </pre>
 *
 * Protobuf type {@code google.cloud.bigquery.analyticshub.v1.DestinationDataset}
 */
public final class DestinationDataset extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.bigquery.analyticshub.v1.DestinationDataset)
    DestinationDatasetOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use DestinationDataset.newBuilder() to construct.
  private DestinationDataset(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private DestinationDataset() {
    location_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new DestinationDataset();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.bigquery.analyticshub.v1.AnalyticsHubProto
        .internal_static_google_cloud_bigquery_analyticshub_v1_DestinationDataset_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
      int number) {
    switch (number) {
      case 4:
        return internalGetLabels();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.bigquery.analyticshub.v1.AnalyticsHubProto
        .internal_static_google_cloud_bigquery_analyticshub_v1_DestinationDataset_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.bigquery.analyticshub.v1.DestinationDataset.class,
            com.google.cloud.bigquery.analyticshub.v1.DestinationDataset.Builder.class);
  }

  private int bitField0_;
  public static final int DATASET_REFERENCE_FIELD_NUMBER = 1;
  private com.google.cloud.bigquery.analyticshub.v1.DestinationDatasetReference datasetReference_;

  /**
   *
   *
   * <pre>
   * Required. A reference that identifies the destination dataset.
   * </pre>
   *
   * <code>
   * .google.cloud.bigquery.analyticshub.v1.DestinationDatasetReference dataset_reference = 1 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return Whether the datasetReference field is set.
   */
  @java.lang.Override
  public boolean hasDatasetReference() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * Required. A reference that identifies the destination dataset.
   * </pre>
   *
   * <code>
   * .google.cloud.bigquery.analyticshub.v1.DestinationDatasetReference dataset_reference = 1 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The datasetReference.
   */
  @java.lang.Override
  public com.google.cloud.bigquery.analyticshub.v1.DestinationDatasetReference
      getDatasetReference() {
    return datasetReference_ == null
        ? com.google.cloud.bigquery.analyticshub.v1.DestinationDatasetReference.getDefaultInstance()
        : datasetReference_;
  }

  /**
   *
   *
   * <pre>
   * Required. A reference that identifies the destination dataset.
   * </pre>
   *
   * <code>
   * .google.cloud.bigquery.analyticshub.v1.DestinationDatasetReference dataset_reference = 1 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.bigquery.analyticshub.v1.DestinationDatasetReferenceOrBuilder
      getDatasetReferenceOrBuilder() {
    return datasetReference_ == null
        ? com.google.cloud.bigquery.analyticshub.v1.DestinationDatasetReference.getDefaultInstance()
        : datasetReference_;
  }

  public static final int FRIENDLY_NAME_FIELD_NUMBER = 2;
  private com.google.protobuf.StringValue friendlyName_;

  /**
   *
   *
   * <pre>
   * Optional. A descriptive name for the dataset.
   * </pre>
   *
   * <code>.google.protobuf.StringValue friendly_name = 2 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the friendlyName field is set.
   */
  @java.lang.Override
  public boolean hasFriendlyName() {
    return ((bitField0_ & 0x00000002) != 0);
  }

  /**
   *
   *
   * <pre>
   * Optional. A descriptive name for the dataset.
   * </pre>
   *
   * <code>.google.protobuf.StringValue friendly_name = 2 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The friendlyName.
   */
  @java.lang.Override
  public com.google.protobuf.StringValue getFriendlyName() {
    return friendlyName_ == null
        ? com.google.protobuf.StringValue.getDefaultInstance()
        : friendlyName_;
  }

  /**
   *
   *
   * <pre>
   * Optional. A descriptive name for the dataset.
   * </pre>
   *
   * <code>.google.protobuf.StringValue friendly_name = 2 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.StringValueOrBuilder getFriendlyNameOrBuilder() {
    return friendlyName_ == null
        ? com.google.protobuf.StringValue.getDefaultInstance()
        : friendlyName_;
  }

  public static final int DESCRIPTION_FIELD_NUMBER = 3;
  private com.google.protobuf.StringValue description_;

  /**
   *
   *
   * <pre>
   * Optional. A user-friendly description of the dataset.
   * </pre>
   *
   * <code>.google.protobuf.StringValue description = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the description field is set.
   */
  @java.lang.Override
  public boolean hasDescription() {
    return ((bitField0_ & 0x00000004) != 0);
  }

  /**
   *
   *
   * <pre>
   * Optional. A user-friendly description of the dataset.
   * </pre>
   *
   * <code>.google.protobuf.StringValue description = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The description.
   */
  @java.lang.Override
  public com.google.protobuf.StringValue getDescription() {
    return description_ == null
        ? com.google.protobuf.StringValue.getDefaultInstance()
        : description_;
  }

  /**
   *
   *
   * <pre>
   * Optional. A user-friendly description of the dataset.
   * </pre>
   *
   * <code>.google.protobuf.StringValue description = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.StringValueOrBuilder getDescriptionOrBuilder() {
    return description_ == null
        ? com.google.protobuf.StringValue.getDefaultInstance()
        : description_;
  }

  public static final int LABELS_FIELD_NUMBER = 4;

  private static final class LabelsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.cloud.bigquery.analyticshub.v1.AnalyticsHubProto
                .internal_static_google_cloud_bigquery_analyticshub_v1_DestinationDataset_LabelsEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
    if (labels_ == null) {
      return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
    }
    return labels_;
  }

  public int getLabelsCount() {
    return internalGetLabels().getMap().size();
  }

  /**
   *
   *
   * <pre>
   * Optional. The labels associated with this dataset. You can use these
   * to organize and group your datasets.
   * You can set this property when inserting or updating a dataset.
   * See https://cloud.google.com/resource-manager/docs/creating-managing-labels
   * for more information.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  @java.lang.Override
  public boolean containsLabels(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetLabels().getMap().containsKey(key);
  }

  /** Use {@link #getLabelsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getLabels() {
    return getLabelsMap();
  }

  /**
   *
   *
   * <pre>
   * Optional. The labels associated with this dataset. You can use these
   * to organize and group your datasets.
   * You can set this property when inserting or updating a dataset.
   * See https://cloud.google.com/resource-manager/docs/creating-managing-labels
   * for more information.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
    return internalGetLabels().getMap();
  }

  /**
   *
   *
   * <pre>
   * Optional. The labels associated with this dataset. You can use these
   * to organize and group your datasets.
   * You can set this property when inserting or updating a dataset.
   * See https://cloud.google.com/resource-manager/docs/creating-managing-labels
   * for more information.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  @java.lang.Override
  public /* nullable */ java.lang.String getLabelsOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }

  /**
   *
   *
   * <pre>
   * Optional. The labels associated with this dataset. You can use these
   * to organize and group your datasets.
   * You can set this property when inserting or updating a dataset.
   * See https://cloud.google.com/resource-manager/docs/creating-managing-labels
   * for more information.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  @java.lang.Override
  public java.lang.String getLabelsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int LOCATION_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private volatile java.lang.Object location_ = "";

  /**
   *
   *
   * <pre>
   * Required. The geographic location where the dataset should reside. See
   * https://cloud.google.com/bigquery/docs/locations for supported
   * locations.
   * </pre>
   *
   * <code>string location = 5 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The location.
   */
  @java.lang.Override
  public java.lang.String getLocation() {
    java.lang.Object ref = location_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      location_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Required. The geographic location where the dataset should reside. See
   * https://cloud.google.com/bigquery/docs/locations for supported
   * locations.
   * </pre>
   *
   * <code>string location = 5 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for location.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getLocationBytes() {
    java.lang.Object ref = location_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      location_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(1, getDatasetReference());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(2, getFriendlyName());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(3, getDescription());
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetLabels(), LabelsDefaultEntryHolder.defaultEntry, 4);
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(location_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, location_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getDatasetReference());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getFriendlyName());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getDescription());
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetLabels().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
          LabelsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, labels__);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(location_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, location_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.bigquery.analyticshub.v1.DestinationDataset)) {
      return super.equals(obj);
    }
    com.google.cloud.bigquery.analyticshub.v1.DestinationDataset other =
        (com.google.cloud.bigquery.analyticshub.v1.DestinationDataset) obj;

    if (hasDatasetReference() != other.hasDatasetReference()) return false;
    if (hasDatasetReference()) {
      if (!getDatasetReference().equals(other.getDatasetReference())) return false;
    }
    if (hasFriendlyName() != other.hasFriendlyName()) return false;
    if (hasFriendlyName()) {
      if (!getFriendlyName().equals(other.getFriendlyName())) return false;
    }
    if (hasDescription() != other.hasDescription()) return false;
    if (hasDescription()) {
      if (!getDescription().equals(other.getDescription())) return false;
    }
    if (!internalGetLabels().equals(other.internalGetLabels())) return false;
    if (!getLocation().equals(other.getLocation())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasDatasetReference()) {
      hash = (37 * hash) + DATASET_REFERENCE_FIELD_NUMBER;
      hash = (53 * hash) + getDatasetReference().hashCode();
    }
    if (hasFriendlyName()) {
      hash = (37 * hash) + FRIENDLY_NAME_FIELD_NUMBER;
      hash = (53 * hash) + getFriendlyName().hashCode();
    }
    if (hasDescription()) {
      hash = (37 * hash) + DESCRIPTION_FIELD_NUMBER;
      hash = (53 * hash) + getDescription().hashCode();
    }
    if (!internalGetLabels().getMap().isEmpty()) {
      hash = (37 * hash) + LABELS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetLabels().hashCode();
    }
    hash = (37 * hash) + LOCATION_FIELD_NUMBER;
    hash = (53 * hash) + getLocation().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.bigquery.analyticshub.v1.DestinationDataset parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.bigquery.analyticshub.v1.DestinationDataset parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.bigquery.analyticshub.v1.DestinationDataset parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.bigquery.analyticshub.v1.DestinationDataset parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.bigquery.analyticshub.v1.DestinationDataset parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.bigquery.analyticshub.v1.DestinationDataset parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.bigquery.analyticshub.v1.DestinationDataset parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.bigquery.analyticshub.v1.DestinationDataset parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.bigquery.analyticshub.v1.DestinationDataset parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.bigquery.analyticshub.v1.DestinationDataset parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.bigquery.analyticshub.v1.DestinationDataset parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.bigquery.analyticshub.v1.DestinationDataset parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.bigquery.analyticshub.v1.DestinationDataset prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * Defines the destination bigquery dataset.
   * </pre>
   *
   * Protobuf type {@code google.cloud.bigquery.analyticshub.v1.DestinationDataset}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.bigquery.analyticshub.v1.DestinationDataset)
      com.google.cloud.bigquery.analyticshub.v1.DestinationDatasetOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.bigquery.analyticshub.v1.AnalyticsHubProto
          .internal_static_google_cloud_bigquery_analyticshub_v1_DestinationDataset_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
        int number) {
      switch (number) {
        case 4:
          return internalGetLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMutableMapFieldReflection(
        int number) {
      switch (number) {
        case 4:
          return internalGetMutableLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.bigquery.analyticshub.v1.AnalyticsHubProto
          .internal_static_google_cloud_bigquery_analyticshub_v1_DestinationDataset_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.bigquery.analyticshub.v1.DestinationDataset.class,
              com.google.cloud.bigquery.analyticshub.v1.DestinationDataset.Builder.class);
    }

    // Construct using com.google.cloud.bigquery.analyticshub.v1.DestinationDataset.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getDatasetReferenceFieldBuilder();
        getFriendlyNameFieldBuilder();
        getDescriptionFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      datasetReference_ = null;
      if (datasetReferenceBuilder_ != null) {
        datasetReferenceBuilder_.dispose();
        datasetReferenceBuilder_ = null;
      }
      friendlyName_ = null;
      if (friendlyNameBuilder_ != null) {
        friendlyNameBuilder_.dispose();
        friendlyNameBuilder_ = null;
      }
      description_ = null;
      if (descriptionBuilder_ != null) {
        descriptionBuilder_.dispose();
        descriptionBuilder_ = null;
      }
      internalGetMutableLabels().clear();
      location_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.bigquery.analyticshub.v1.AnalyticsHubProto
          .internal_static_google_cloud_bigquery_analyticshub_v1_DestinationDataset_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.bigquery.analyticshub.v1.DestinationDataset
        getDefaultInstanceForType() {
      return com.google.cloud.bigquery.analyticshub.v1.DestinationDataset.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.bigquery.analyticshub.v1.DestinationDataset build() {
      com.google.cloud.bigquery.analyticshub.v1.DestinationDataset result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.bigquery.analyticshub.v1.DestinationDataset buildPartial() {
      com.google.cloud.bigquery.analyticshub.v1.DestinationDataset result =
          new com.google.cloud.bigquery.analyticshub.v1.DestinationDataset(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(
        com.google.cloud.bigquery.analyticshub.v1.DestinationDataset result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.datasetReference_ =
            datasetReferenceBuilder_ == null ? datasetReference_ : datasetReferenceBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.friendlyName_ =
            friendlyNameBuilder_ == null ? friendlyName_ : friendlyNameBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.description_ =
            descriptionBuilder_ == null ? description_ : descriptionBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.labels_ = internalGetLabels();
        result.labels_.makeImmutable();
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.location_ = location_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.bigquery.analyticshub.v1.DestinationDataset) {
        return mergeFrom((com.google.cloud.bigquery.analyticshub.v1.DestinationDataset) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.bigquery.analyticshub.v1.DestinationDataset other) {
      if (other
          == com.google.cloud.bigquery.analyticshub.v1.DestinationDataset.getDefaultInstance())
        return this;
      if (other.hasDatasetReference()) {
        mergeDatasetReference(other.getDatasetReference());
      }
      if (other.hasFriendlyName()) {
        mergeFriendlyName(other.getFriendlyName());
      }
      if (other.hasDescription()) {
        mergeDescription(other.getDescription());
      }
      internalGetMutableLabels().mergeFrom(other.internalGetLabels());
      bitField0_ |= 0x00000008;
      if (!other.getLocation().isEmpty()) {
        location_ = other.location_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(
                    getDatasetReferenceFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getFriendlyNameFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getDescriptionFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
                    input.readMessage(
                        LabelsDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                internalGetMutableLabels()
                    .getMutableMap()
                    .put(labels__.getKey(), labels__.getValue());
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 42:
              {
                location_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private com.google.cloud.bigquery.analyticshub.v1.DestinationDatasetReference datasetReference_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.bigquery.analyticshub.v1.DestinationDatasetReference,
            com.google.cloud.bigquery.analyticshub.v1.DestinationDatasetReference.Builder,
            com.google.cloud.bigquery.analyticshub.v1.DestinationDatasetReferenceOrBuilder>
        datasetReferenceBuilder_;

    /**
     *
     *
     * <pre>
     * Required. A reference that identifies the destination dataset.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.analyticshub.v1.DestinationDatasetReference dataset_reference = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the datasetReference field is set.
     */
    public boolean hasDatasetReference() {
      return ((bitField0_ & 0x00000001) != 0);
    }

    /**
     *
     *
     * <pre>
     * Required. A reference that identifies the destination dataset.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.analyticshub.v1.DestinationDatasetReference dataset_reference = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The datasetReference.
     */
    public com.google.cloud.bigquery.analyticshub.v1.DestinationDatasetReference
        getDatasetReference() {
      if (datasetReferenceBuilder_ == null) {
        return datasetReference_ == null
            ? com.google.cloud.bigquery.analyticshub.v1.DestinationDatasetReference
                .getDefaultInstance()
            : datasetReference_;
      } else {
        return datasetReferenceBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Required. A reference that identifies the destination dataset.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.analyticshub.v1.DestinationDatasetReference dataset_reference = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setDatasetReference(
        com.google.cloud.bigquery.analyticshub.v1.DestinationDatasetReference value) {
      if (datasetReferenceBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        datasetReference_ = value;
      } else {
        datasetReferenceBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. A reference that identifies the destination dataset.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.analyticshub.v1.DestinationDatasetReference dataset_reference = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setDatasetReference(
        com.google.cloud.bigquery.analyticshub.v1.DestinationDatasetReference.Builder
            builderForValue) {
      if (datasetReferenceBuilder_ == null) {
        datasetReference_ = builderForValue.build();
      } else {
        datasetReferenceBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. A reference that identifies the destination dataset.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.analyticshub.v1.DestinationDatasetReference dataset_reference = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder mergeDatasetReference(
        com.google.cloud.bigquery.analyticshub.v1.DestinationDatasetReference value) {
      if (datasetReferenceBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)
            && datasetReference_ != null
            && datasetReference_
                != com.google.cloud.bigquery.analyticshub.v1.DestinationDatasetReference
                    .getDefaultInstance()) {
          getDatasetReferenceBuilder().mergeFrom(value);
        } else {
          datasetReference_ = value;
        }
      } else {
        datasetReferenceBuilder_.mergeFrom(value);
      }
      if (datasetReference_ != null) {
        bitField0_ |= 0x00000001;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. A reference that identifies the destination dataset.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.analyticshub.v1.DestinationDatasetReference dataset_reference = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearDatasetReference() {
      bitField0_ = (bitField0_ & ~0x00000001);
      datasetReference_ = null;
      if (datasetReferenceBuilder_ != null) {
        datasetReferenceBuilder_.dispose();
        datasetReferenceBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. A reference that identifies the destination dataset.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.analyticshub.v1.DestinationDatasetReference dataset_reference = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.bigquery.analyticshub.v1.DestinationDatasetReference.Builder
        getDatasetReferenceBuilder() {
      bitField0_ |= 0x00000001;
      onChanged();
      return getDatasetReferenceFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Required. A reference that identifies the destination dataset.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.analyticshub.v1.DestinationDatasetReference dataset_reference = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.bigquery.analyticshub.v1.DestinationDatasetReferenceOrBuilder
        getDatasetReferenceOrBuilder() {
      if (datasetReferenceBuilder_ != null) {
        return datasetReferenceBuilder_.getMessageOrBuilder();
      } else {
        return datasetReference_ == null
            ? com.google.cloud.bigquery.analyticshub.v1.DestinationDatasetReference
                .getDefaultInstance()
            : datasetReference_;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. A reference that identifies the destination dataset.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.analyticshub.v1.DestinationDatasetReference dataset_reference = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.bigquery.analyticshub.v1.DestinationDatasetReference,
            com.google.cloud.bigquery.analyticshub.v1.DestinationDatasetReference.Builder,
            com.google.cloud.bigquery.analyticshub.v1.DestinationDatasetReferenceOrBuilder>
        getDatasetReferenceFieldBuilder() {
      if (datasetReferenceBuilder_ == null) {
        datasetReferenceBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.bigquery.analyticshub.v1.DestinationDatasetReference,
                com.google.cloud.bigquery.analyticshub.v1.DestinationDatasetReference.Builder,
                com.google.cloud.bigquery.analyticshub.v1.DestinationDatasetReferenceOrBuilder>(
                getDatasetReference(), getParentForChildren(), isClean());
        datasetReference_ = null;
      }
      return datasetReferenceBuilder_;
    }

    private com.google.protobuf.StringValue friendlyName_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.StringValue,
            com.google.protobuf.StringValue.Builder,
            com.google.protobuf.StringValueOrBuilder>
        friendlyNameBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. A descriptive name for the dataset.
     * </pre>
     *
     * <code>
     * .google.protobuf.StringValue friendly_name = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the friendlyName field is set.
     */
    public boolean hasFriendlyName() {
      return ((bitField0_ & 0x00000002) != 0);
    }

    /**
     *
     *
     * <pre>
     * Optional. A descriptive name for the dataset.
     * </pre>
     *
     * <code>
     * .google.protobuf.StringValue friendly_name = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The friendlyName.
     */
    public com.google.protobuf.StringValue getFriendlyName() {
      if (friendlyNameBuilder_ == null) {
        return friendlyName_ == null
            ? com.google.protobuf.StringValue.getDefaultInstance()
            : friendlyName_;
      } else {
        return friendlyNameBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. A descriptive name for the dataset.
     * </pre>
     *
     * <code>
     * .google.protobuf.StringValue friendly_name = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setFriendlyName(com.google.protobuf.StringValue value) {
      if (friendlyNameBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        friendlyName_ = value;
      } else {
        friendlyNameBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. A descriptive name for the dataset.
     * </pre>
     *
     * <code>
     * .google.protobuf.StringValue friendly_name = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setFriendlyName(com.google.protobuf.StringValue.Builder builderForValue) {
      if (friendlyNameBuilder_ == null) {
        friendlyName_ = builderForValue.build();
      } else {
        friendlyNameBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. A descriptive name for the dataset.
     * </pre>
     *
     * <code>
     * .google.protobuf.StringValue friendly_name = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeFriendlyName(com.google.protobuf.StringValue value) {
      if (friendlyNameBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && friendlyName_ != null
            && friendlyName_ != com.google.protobuf.StringValue.getDefaultInstance()) {
          getFriendlyNameBuilder().mergeFrom(value);
        } else {
          friendlyName_ = value;
        }
      } else {
        friendlyNameBuilder_.mergeFrom(value);
      }
      if (friendlyName_ != null) {
        bitField0_ |= 0x00000002;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. A descriptive name for the dataset.
     * </pre>
     *
     * <code>
     * .google.protobuf.StringValue friendly_name = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearFriendlyName() {
      bitField0_ = (bitField0_ & ~0x00000002);
      friendlyName_ = null;
      if (friendlyNameBuilder_ != null) {
        friendlyNameBuilder_.dispose();
        friendlyNameBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. A descriptive name for the dataset.
     * </pre>
     *
     * <code>
     * .google.protobuf.StringValue friendly_name = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.protobuf.StringValue.Builder getFriendlyNameBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getFriendlyNameFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Optional. A descriptive name for the dataset.
     * </pre>
     *
     * <code>
     * .google.protobuf.StringValue friendly_name = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.protobuf.StringValueOrBuilder getFriendlyNameOrBuilder() {
      if (friendlyNameBuilder_ != null) {
        return friendlyNameBuilder_.getMessageOrBuilder();
      } else {
        return friendlyName_ == null
            ? com.google.protobuf.StringValue.getDefaultInstance()
            : friendlyName_;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. A descriptive name for the dataset.
     * </pre>
     *
     * <code>
     * .google.protobuf.StringValue friendly_name = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.StringValue,
            com.google.protobuf.StringValue.Builder,
            com.google.protobuf.StringValueOrBuilder>
        getFriendlyNameFieldBuilder() {
      if (friendlyNameBuilder_ == null) {
        friendlyNameBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.StringValue,
                com.google.protobuf.StringValue.Builder,
                com.google.protobuf.StringValueOrBuilder>(
                getFriendlyName(), getParentForChildren(), isClean());
        friendlyName_ = null;
      }
      return friendlyNameBuilder_;
    }

    private com.google.protobuf.StringValue description_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.StringValue,
            com.google.protobuf.StringValue.Builder,
            com.google.protobuf.StringValueOrBuilder>
        descriptionBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. A user-friendly description of the dataset.
     * </pre>
     *
     * <code>.google.protobuf.StringValue description = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the description field is set.
     */
    public boolean hasDescription() {
      return ((bitField0_ & 0x00000004) != 0);
    }

    /**
     *
     *
     * <pre>
     * Optional. A user-friendly description of the dataset.
     * </pre>
     *
     * <code>.google.protobuf.StringValue description = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The description.
     */
    public com.google.protobuf.StringValue getDescription() {
      if (descriptionBuilder_ == null) {
        return description_ == null
            ? com.google.protobuf.StringValue.getDefaultInstance()
            : description_;
      } else {
        return descriptionBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. A user-friendly description of the dataset.
     * </pre>
     *
     * <code>.google.protobuf.StringValue description = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setDescription(com.google.protobuf.StringValue value) {
      if (descriptionBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        description_ = value;
      } else {
        descriptionBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. A user-friendly description of the dataset.
     * </pre>
     *
     * <code>.google.protobuf.StringValue description = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setDescription(com.google.protobuf.StringValue.Builder builderForValue) {
      if (descriptionBuilder_ == null) {
        description_ = builderForValue.build();
      } else {
        descriptionBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. A user-friendly description of the dataset.
     * </pre>
     *
     * <code>.google.protobuf.StringValue description = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeDescription(com.google.protobuf.StringValue value) {
      if (descriptionBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && description_ != null
            && description_ != com.google.protobuf.StringValue.getDefaultInstance()) {
          getDescriptionBuilder().mergeFrom(value);
        } else {
          description_ = value;
        }
      } else {
        descriptionBuilder_.mergeFrom(value);
      }
      if (description_ != null) {
        bitField0_ |= 0x00000004;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. A user-friendly description of the dataset.
     * </pre>
     *
     * <code>.google.protobuf.StringValue description = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearDescription() {
      bitField0_ = (bitField0_ & ~0x00000004);
      description_ = null;
      if (descriptionBuilder_ != null) {
        descriptionBuilder_.dispose();
        descriptionBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. A user-friendly description of the dataset.
     * </pre>
     *
     * <code>.google.protobuf.StringValue description = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.protobuf.StringValue.Builder getDescriptionBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getDescriptionFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Optional. A user-friendly description of the dataset.
     * </pre>
     *
     * <code>.google.protobuf.StringValue description = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.protobuf.StringValueOrBuilder getDescriptionOrBuilder() {
      if (descriptionBuilder_ != null) {
        return descriptionBuilder_.getMessageOrBuilder();
      } else {
        return description_ == null
            ? com.google.protobuf.StringValue.getDefaultInstance()
            : description_;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. A user-friendly description of the dataset.
     * </pre>
     *
     * <code>.google.protobuf.StringValue description = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.StringValue,
            com.google.protobuf.StringValue.Builder,
            com.google.protobuf.StringValueOrBuilder>
        getDescriptionFieldBuilder() {
      if (descriptionBuilder_ == null) {
        descriptionBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.StringValue,
                com.google.protobuf.StringValue.Builder,
                com.google.protobuf.StringValueOrBuilder>(
                getDescription(), getParentForChildren(), isClean());
        description_ = null;
      }
      return descriptionBuilder_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
      if (labels_ == null) {
        return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      return labels_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableLabels() {
      if (labels_ == null) {
        labels_ = com.google.protobuf.MapField.newMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      if (!labels_.isMutable()) {
        labels_ = labels_.copy();
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return labels_;
    }

    public int getLabelsCount() {
      return internalGetLabels().getMap().size();
    }

    /**
     *
     *
     * <pre>
     * Optional. The labels associated with this dataset. You can use these
     * to organize and group your datasets.
     * You can set this property when inserting or updating a dataset.
     * See https://cloud.google.com/resource-manager/docs/creating-managing-labels
     * for more information.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    @java.lang.Override
    public boolean containsLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetLabels().getMap().containsKey(key);
    }

    /** Use {@link #getLabelsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getLabels() {
      return getLabelsMap();
    }

    /**
     *
     *
     * <pre>
     * Optional. The labels associated with this dataset. You can use these
     * to organize and group your datasets.
     * You can set this property when inserting or updating a dataset.
     * See https://cloud.google.com/resource-manager/docs/creating-managing-labels
     * for more information.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
      return internalGetLabels().getMap();
    }

    /**
     *
     *
     * <pre>
     * Optional. The labels associated with this dataset. You can use these
     * to organize and group your datasets.
     * You can set this property when inserting or updating a dataset.
     * See https://cloud.google.com/resource-manager/docs/creating-managing-labels
     * for more information.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    @java.lang.Override
    public /* nullable */ java.lang.String getLabelsOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }

    /**
     *
     *
     * <pre>
     * Optional. The labels associated with this dataset. You can use these
     * to organize and group your datasets.
     * You can set this property when inserting or updating a dataset.
     * See https://cloud.google.com/resource-manager/docs/creating-managing-labels
     * for more information.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    @java.lang.Override
    public java.lang.String getLabelsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearLabels() {
      bitField0_ = (bitField0_ & ~0x00000008);
      internalGetMutableLabels().getMutableMap().clear();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The labels associated with this dataset. You can use these
     * to organize and group your datasets.
     * You can set this property when inserting or updating a dataset.
     * See https://cloud.google.com/resource-manager/docs/creating-managing-labels
     * for more information.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    public Builder removeLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableLabels().getMutableMap().remove(key);
      return this;
    }

    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableLabels() {
      bitField0_ |= 0x00000008;
      return internalGetMutableLabels().getMutableMap();
    }

    /**
     *
     *
     * <pre>
     * Optional. The labels associated with this dataset. You can use these
     * to organize and group your datasets.
     * You can set this property when inserting or updating a dataset.
     * See https://cloud.google.com/resource-manager/docs/creating-managing-labels
     * for more information.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    public Builder putLabels(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableLabels().getMutableMap().put(key, value);
      bitField0_ |= 0x00000008;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The labels associated with this dataset. You can use these
     * to organize and group your datasets.
     * You can set this property when inserting or updating a dataset.
     * See https://cloud.google.com/resource-manager/docs/creating-managing-labels
     * for more information.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    public Builder putAllLabels(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableLabels().getMutableMap().putAll(values);
      bitField0_ |= 0x00000008;
      return this;
    }

    private java.lang.Object location_ = "";

    /**
     *
     *
     * <pre>
     * Required. The geographic location where the dataset should reside. See
     * https://cloud.google.com/bigquery/docs/locations for supported
     * locations.
     * </pre>
     *
     * <code>string location = 5 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The location.
     */
    public java.lang.String getLocation() {
      java.lang.Object ref = location_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        location_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The geographic location where the dataset should reside. See
     * https://cloud.google.com/bigquery/docs/locations for supported
     * locations.
     * </pre>
     *
     * <code>string location = 5 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for location.
     */
    public com.google.protobuf.ByteString getLocationBytes() {
      java.lang.Object ref = location_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        location_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The geographic location where the dataset should reside. See
     * https://cloud.google.com/bigquery/docs/locations for supported
     * locations.
     * </pre>
     *
     * <code>string location = 5 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The location to set.
     * @return This builder for chaining.
     */
    public Builder setLocation(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      location_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The geographic location where the dataset should reside. See
     * https://cloud.google.com/bigquery/docs/locations for supported
     * locations.
     * </pre>
     *
     * <code>string location = 5 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearLocation() {
      location_ = getDefaultInstance().getLocation();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The geographic location where the dataset should reside. See
     * https://cloud.google.com/bigquery/docs/locations for supported
     * locations.
     * </pre>
     *
     * <code>string location = 5 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for location to set.
     * @return This builder for chaining.
     */
    public Builder setLocationBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      location_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.bigquery.analyticshub.v1.DestinationDataset)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.bigquery.analyticshub.v1.DestinationDataset)
  private static final com.google.cloud.bigquery.analyticshub.v1.DestinationDataset
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.bigquery.analyticshub.v1.DestinationDataset();
  }

  public static com.google.cloud.bigquery.analyticshub.v1.DestinationDataset getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<DestinationDataset> PARSER =
      new com.google.protobuf.AbstractParser<DestinationDataset>() {
        @java.lang.Override
        public DestinationDataset parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<DestinationDataset> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<DestinationDataset> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.bigquery.analyticshub.v1.DestinationDataset getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
