/*
 * Decompiled with CFR 0.152.
 */
package com.github.spotbugs.snom.internal;

import com.github.spotbugs.snom.SpotBugsTask;
import com.github.spotbugs.snom.internal.OutputScanner;
import com.github.spotbugs.snom.internal.SpotBugsRunner;
import com.github.spotbugs.snom.internal.SpotBugsRunnerForHybrid;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.RegularFile;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.jvm.toolchain.JavaLauncher;
import org.gradle.process.ExecOperations;
import org.gradle.process.JavaExecSpec;
import org.gradle.workers.WorkAction;
import org.gradle.workers.WorkParameters;
import org.gradle.workers.WorkerExecutor;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 \u000f2\u00020\u0001:\u0003\r\u000e\u000fB\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/github/spotbugs/snom/internal/SpotBugsRunnerForHybrid;", "Lcom/github/spotbugs/snom/internal/SpotBugsRunner;", "workerExecutor", "Lorg/gradle/workers/WorkerExecutor;", "javaLauncher", "Lorg/gradle/api/provider/Property;", "Lorg/gradle/jvm/toolchain/JavaLauncher;", "<init>", "(Lorg/gradle/workers/WorkerExecutor;Lorg/gradle/api/provider/Property;)V", "run", "", "task", "Lcom/github/spotbugs/snom/SpotBugsTask;", "SpotBugsWorkParameters", "SpotBugsExecutor", "Companion", "spotbugs-gradle-plugin"})
@SourceDebugExtension(value={"SMAP\nSpotBugsRunnerForHybrid.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpotBugsRunnerForHybrid.kt\ncom/github/spotbugs/snom/internal/SpotBugsRunnerForHybrid\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,169:1\n1317#2,2:170\n*S KotlinDebug\n*F\n+ 1 SpotBugsRunnerForHybrid.kt\ncom/github/spotbugs/snom/internal/SpotBugsRunnerForHybrid\n*L\n65#1:170,2\n*E\n"})
public final class SpotBugsRunnerForHybrid
extends SpotBugsRunner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final WorkerExecutor workerExecutor;
    @NotNull
    private final Property<JavaLauncher> javaLauncher;
    private static final int MISSING_CLASS_FLAG = 2;

    public SpotBugsRunnerForHybrid(@NotNull WorkerExecutor workerExecutor, @NotNull Property<JavaLauncher> javaLauncher) {
        Intrinsics.checkNotNullParameter((Object)workerExecutor, (String)"workerExecutor");
        Intrinsics.checkNotNullParameter(javaLauncher, (String)"javaLauncher");
        this.workerExecutor = workerExecutor;
        this.javaLauncher = javaLauncher;
    }

    @Override
    public void run(@NotNull SpotBugsTask task) {
        Intrinsics.checkNotNullParameter((Object)((Object)task), (String)"task");
        this.workerExecutor.noIsolation().submit(SpotBugsExecutor.class, arg_0 -> SpotBugsRunnerForHybrid.run$lambda$1(arg_0 -> SpotBugsRunnerForHybrid.run$lambda$0(this, task, arg_0), arg_0));
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit run$lambda$0(SpotBugsRunnerForHybrid this$0, SpotBugsTask $task, SpotBugsWorkParameters it) {
        void $this$forEach$iv;
        List args = new ArrayList();
        args.add("-exitcode");
        args.addAll((Collection)this$0.buildArguments($task));
        it.getClasspath().setFrom((Iterable)$task.getSpotbugsClasspath());
        it.getJvmArgs().set((Iterable)this$0.buildJvmArguments($task));
        it.getArgs().set((Iterable)args);
        String maxHeapSize = (String)$task.getMaxHeapSize().getOrNull();
        if (maxHeapSize != null) {
            it.getMaxHeapSize().set((Object)maxHeapSize);
        }
        it.getIgnoreFailures().set((Object)$task.getIgnoreFailures());
        it.getShowStackTraces().set((Provider)$task.getShowStackTraces());
        Sequence sequence = SequencesKt.map($task.getRequiredReports$spotbugs_gradle_plugin(), (Function1)run.1.1.INSTANCE);
        ListProperty<RegularFile> listProperty = it.getReports();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Provider p0 = (Provider)element$iv;
            boolean bl = false;
            listProperty.add(p0);
        }
        if (this$0.javaLauncher.isPresent()) {
            it.getJavaToolchainExecutablePath().set((Object)((JavaLauncher)this$0.javaLauncher.get()).getExecutablePath().getAsFile().getAbsolutePath());
        }
        return Unit.INSTANCE;
    }

    private static final void run$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0006\u0010\u0003\u00a8\u0006\u0007"}, d2={"Lcom/github/spotbugs/snom/internal/SpotBugsRunnerForHybrid$Companion;", "", "<init>", "()V", "MISSING_CLASS_FLAG", "", "getMISSING_CLASS_FLAG$annotations", "spotbugs-gradle-plugin"})
    public static final class Companion {
        private Companion() {
        }

        private static /* synthetic */ void getMISSING_CLASS_FLAG$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0011\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0002J\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0014\u001a\u00020\u0002H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/github/spotbugs/snom/internal/SpotBugsRunnerForHybrid$SpotBugsExecutor;", "Lorg/gradle/workers/WorkAction;", "Lcom/github/spotbugs/snom/internal/SpotBugsRunnerForHybrid$SpotBugsWorkParameters;", "execOperations", "Lorg/gradle/process/ExecOperations;", "<init>", "(Lorg/gradle/process/ExecOperations;)V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "stderrOutputScanner", "Lcom/github/spotbugs/snom/internal/OutputScanner;", "execute", "", "ignoreMissingClassFlag", "", "exitValue", "configureJavaExec", "Lorg/gradle/api/Action;", "Lorg/gradle/process/JavaExecSpec;", "params", "spotbugs-gradle-plugin"})
    public static abstract class SpotBugsExecutor
    implements WorkAction<SpotBugsWorkParameters> {
        @NotNull
        private final ExecOperations execOperations;
        private final Logger log;
        private OutputScanner stderrOutputScanner;

        @Inject
        public SpotBugsExecutor(@NotNull ExecOperations execOperations) {
            Intrinsics.checkNotNullParameter((Object)execOperations, (String)"execOperations");
            this.execOperations = execOperations;
            this.log = LoggerFactory.getLogger(this.getClass());
        }

        public void execute() {
            StringBuilder stringBuilder;
            WorkParameters workParameters = this.getParameters();
            Intrinsics.checkNotNullExpressionValue((Object)workParameters, (String)"getParameters(...)");
            int exitValue = this.execOperations.javaexec(this.configureJavaExec((SpotBugsWorkParameters)workParameters)).rethrowFailure().getExitValue();
            Boolean ignoreFailures = (Boolean)((SpotBugsWorkParameters)this.getParameters()).getIgnoreFailures().getOrElse((Object)false);
            if (this.ignoreMissingClassFlag(exitValue) == 0) {
                OutputScanner outputScanner = this.stderrOutputScanner;
                if (outputScanner == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"stderrOutputScanner");
                    outputScanner = null;
                }
                if (outputScanner.isFailedToReport() && !ignoreFailures.booleanValue()) {
                    throw new GradleException("SpotBugs analysis succeeded but report generation failed");
                }
                return;
            }
            if (ignoreFailures.booleanValue()) {
                this.log.warn("SpotBugs ended with exit code " + exitValue);
                return;
            }
            StringBuilder $this$execute_u24lambda_u240 = stringBuilder = new StringBuilder();
            boolean bl = false;
            $this$execute_u24lambda_u240.append("Verification failed: SpotBugs ended with exit code " + exitValue + ".");
            Object object = ((SpotBugsWorkParameters)this.getParameters()).getReports().get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
            List reportPaths2 = SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.map((Sequence)SequencesKt.map((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)((Iterable)object)), (Function1)execute.errorMessage.1.reportPaths.1.INSTANCE), (Function1)execute.errorMessage.1.reportPaths.2.INSTANCE), (Function1)execute.errorMessage.1.reportPaths.3.INSTANCE), (Function1)execute.errorMessage.1.reportPaths.4.INSTANCE));
            if (!((Collection)reportPaths2).isEmpty()) {
                $this$execute_u24lambda_u240.append(" See the report at: ");
                $this$execute_u24lambda_u240.append(CollectionsKt.joinToString$default((Iterable)reportPaths2, null, null, null, (int)0, null, null, (int)63, null));
            }
            String string = stringBuilder.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            String errorMessage2 = string;
            throw new GradleException(errorMessage2);
        }

        private final int ignoreMissingClassFlag(int exitValue) {
            if ((exitValue & 2) == 0) {
                return exitValue;
            }
            this.log.debug("MISSING_CLASS_FLAG (2) was set to the exit code, but ignore it to keep the task result stable.");
            return exitValue ^ 2;
        }

        private final Action<JavaExecSpec> configureJavaExec(SpotBugsWorkParameters params) {
            return arg_0 -> SpotBugsExecutor.configureJavaExec$lambda$0(params, this, arg_0);
        }

        private static final void configureJavaExec$lambda$0(SpotBugsWorkParameters $params, SpotBugsExecutor this$0, JavaExecSpec it) {
            it.setJvmArgs((List)$params.getJvmArgs().get());
            Object[] objectArray = new Object[]{$params.getClasspath()};
            it.classpath(objectArray);
            it.setArgs((List)$params.getArgs().get());
            it.getMainClass().set((Object)"edu.umd.cs.findbugs.FindBugs2");
            String maxHeapSize = (String)$params.getMaxHeapSize().getOrNull();
            if (maxHeapSize != null) {
                it.setMaxHeapSize(maxHeapSize);
            }
            if ($params.getJavaToolchainExecutablePath().isPresent()) {
                this$0.log.info("Spotbugs will be executed using Java Toolchain configuration: {}", $params.getJavaToolchainExecutablePath().get());
                it.setExecutable((String)$params.getJavaToolchainExecutablePath().get());
            }
            it.setIgnoreExitValue(true);
            PrintStream printStream = System.err;
            Intrinsics.checkNotNullExpressionValue((Object)printStream, (String)"err");
            this$0.stderrOutputScanner = new OutputScanner(printStream);
            OutputScanner outputScanner = this$0.stderrOutputScanner;
            if (outputScanner == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"stderrOutputScanner");
                outputScanner = null;
            }
            it.setErrorOutput((OutputStream)outputScanner);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H&J\u000e\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H&J\u000e\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\bH&J\u000e\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\bH&J\u000e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0005H&J\u000e\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0005H&J\u000e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H&J\u000e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\bH&\u00a8\u0006\u0010\u00c0\u0006\u0003"}, d2={"Lcom/github/spotbugs/snom/internal/SpotBugsRunnerForHybrid$SpotBugsWorkParameters;", "Lorg/gradle/workers/WorkParameters;", "getClasspath", "Lorg/gradle/api/file/ConfigurableFileCollection;", "getMaxHeapSize", "Lorg/gradle/api/provider/Property;", "", "getArgs", "Lorg/gradle/api/provider/ListProperty;", "getJvmArgs", "getIgnoreFailures", "", "getShowStackTraces", "getJavaToolchainExecutablePath", "getReports", "Lorg/gradle/api/file/RegularFile;", "spotbugs-gradle-plugin"})
    public static interface SpotBugsWorkParameters
    extends WorkParameters {
        @NotNull
        public ConfigurableFileCollection getClasspath();

        @NotNull
        public Property<String> getMaxHeapSize();

        @NotNull
        public ListProperty<String> getArgs();

        @NotNull
        public ListProperty<String> getJvmArgs();

        @NotNull
        public Property<Boolean> getIgnoreFailures();

        @NotNull
        public Property<Boolean> getShowStackTraces();

        @NotNull
        public Property<String> getJavaToolchainExecutablePath();

        @NotNull
        public ListProperty<RegularFile> getReports();
    }
}

