/*
 * Decompiled with CFR 0.152.
 */
package com.github.spotbugs.snom.internal;

import com.github.spotbugs.snom.SpotBugsReport;
import com.github.spotbugs.snom.SpotBugsTask;
import com.github.spotbugs.snom.internal.OutputScanner;
import com.github.spotbugs.snom.internal.SpotBugsRunner;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.File;
import java.io.OutputStream;
import java.net.URI;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.file.FileSystemLocationProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.jvm.toolchain.JavaLauncher;
import org.gradle.process.JavaExecSpec;
import org.gradle.process.internal.ExecException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpotBugsRunnerForJavaExec
extends SpotBugsRunner {
    private final Logger log = LoggerFactory.getLogger(SpotBugsRunnerForJavaExec.class);
    private final Property<JavaLauncher> javaLauncher;
    private OutputScanner stderrOutputScanner;

    public SpotBugsRunnerForJavaExec(Property<JavaLauncher> javaLauncher) {
        this.javaLauncher = javaLauncher;
    }

    @Override
    public void run(@NonNull SpotBugsTask task) {
        try {
            task.getProject().javaexec(this.configureJavaExec(task)).rethrowFailure().assertNormalExitValue();
            if (this.stderrOutputScanner.isFailedToReport() && !task.getIgnoreFailures()) {
                throw new GradleException("SpotBugs analysis succeeded but report generation failed");
            }
        }
        catch (ExecException e) {
            if (task.getIgnoreFailures()) {
                this.log.warn("SpotBugs reported failures", (Throwable)(task.getShowStackTraces() ? e : null));
            }
            String errorMessage = "Verification failed: SpotBugs execution thrown exception.";
            List reportPaths = task.getEnabledReports().stream().map(SpotBugsReport::getOutputLocation).map(FileSystemLocationProperty::getAsFile).map(Provider::get).map(File::toPath).map(Path::toUri).map(URI::toString).collect(Collectors.toList());
            if (!reportPaths.isEmpty()) {
                errorMessage = errorMessage + "See the report at: " + String.join((CharSequence)",", reportPaths);
            }
            throw new GradleException(errorMessage, (Throwable)e);
        }
    }

    private Action<? super JavaExecSpec> configureJavaExec(SpotBugsTask task) {
        return spec -> {
            ArrayList<String> args = new ArrayList<String>();
            args.add("-exitcode");
            args.addAll(this.buildArguments(task));
            spec.classpath(new Object[]{task.getSpotbugsClasspath()});
            spec.setJvmArgs(this.buildJvmArguments(task));
            spec.getMainClass().set((Object)"edu.umd.cs.findbugs.FindBugs2");
            spec.setArgs(args);
            String maxHeapSize = (String)task.getMaxHeapSize().getOrNull();
            if (maxHeapSize != null) {
                spec.setMaxHeapSize(maxHeapSize);
            }
            this.stderrOutputScanner = new OutputScanner(System.err);
            spec.setErrorOutput((OutputStream)this.stderrOutputScanner);
            if (this.javaLauncher.isPresent()) {
                this.log.info("Spotbugs will be executed using Java Toolchain configuration: Vendor: {} | Version: {}", (Object)((JavaLauncher)this.javaLauncher.get()).getMetadata().getVendor(), (Object)((JavaLauncher)this.javaLauncher.get()).getMetadata().getLanguageVersion().asInt());
                spec.setExecutable(((JavaLauncher)this.javaLauncher.get()).getExecutablePath().getAsFile().getAbsolutePath());
            }
        };
    }
}

