/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.core.ast;

import com.github.sommeri.less4j.core.ast.ASTCssNode;
import com.github.sommeri.less4j.core.ast.ASTCssNodeType;
import com.github.sommeri.less4j.core.ast.BodyOwner;
import com.github.sommeri.less4j.core.ast.FunctionExpression;
import com.github.sommeri.less4j.core.ast.GeneralBody;
import com.github.sommeri.less4j.core.ast.annotations.NotAstProperty;
import com.github.sommeri.less4j.core.parser.HiddenTokenAwareTree;
import com.github.sommeri.less4j.utils.ArraysUtils;
import java.util.ArrayList;
import java.util.List;

public class Document
extends ASTCssNode
implements BodyOwner<GeneralBody> {
    private String dialect;
    private List<FunctionExpression> urlMatchFunction = new ArrayList<FunctionExpression>();
    private GeneralBody body;

    public Document(HiddenTokenAwareTree token, String dialect) {
        super(token);
        this.dialect = dialect;
    }

    @Override
    public GeneralBody getBody() {
        return this.body;
    }

    @Override
    public void setBody(GeneralBody body) {
        this.body = body;
    }

    public String getDialect() {
        return this.dialect;
    }

    public void setDialect(String dialect) {
        this.dialect = dialect;
    }

    public List<FunctionExpression> getUrlMatchFunctions() {
        return this.urlMatchFunction;
    }

    @NotAstProperty
    public List<ASTCssNode> getChilds() {
        ArrayList<ASTCssNode> childs = new ArrayList<ASTCssNode>(this.urlMatchFunction);
        childs.add((FunctionExpression)((Object)this.body));
        return childs;
    }

    @Override
    public ASTCssNodeType getType() {
        return ASTCssNodeType.DOCUMENT;
    }

    @Override
    public Document clone() {
        Document result = (Document)super.clone();
        result.urlMatchFunction = ArraysUtils.deeplyClonedList(this.urlMatchFunction);
        result.body = this.body == null ? null : this.body.clone();
        result.configureParentToAllChilds();
        return result;
    }

    public void addUrlMatchFunctions(List<FunctionExpression> urlMatchFunctions) {
        this.urlMatchFunction.addAll(urlMatchFunctions);
    }
}

