/*
 * Decompiled with CFR 0.152.
 */
package com.smarteist.autoimageslider;

import android.content.Context;
import android.content.res.TypedArray;
import android.database.DataSetObserver;
import android.graphics.Color;
import android.os.Handler;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewPager;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.smarteist.autoimageslider.CircularSliderHandle;
import com.smarteist.autoimageslider.IndicatorAnimations;
import com.smarteist.autoimageslider.IndicatorView.PageIndicatorView;
import com.smarteist.autoimageslider.IndicatorView.animation.type.AnimationType;
import com.smarteist.autoimageslider.IndicatorView.draw.controller.AttributeController;
import com.smarteist.autoimageslider.IndicatorView.draw.controller.DrawController;
import com.smarteist.autoimageslider.IndicatorView.draw.data.Orientation;
import com.smarteist.autoimageslider.IndicatorView.draw.data.RtlMode;
import com.smarteist.autoimageslider.IndicatorView.utils.DensityUtils;
import com.smarteist.autoimageslider.R;
import com.smarteist.autoimageslider.SliderAnimations;
import com.smarteist.autoimageslider.SliderPager;
import com.smarteist.autoimageslider.Transformations.AntiClockSpinTransformation;
import com.smarteist.autoimageslider.Transformations.Clock_SpinTransformation;
import com.smarteist.autoimageslider.Transformations.CubeInDepthTransformation;
import com.smarteist.autoimageslider.Transformations.CubeInRotationTransformation;
import com.smarteist.autoimageslider.Transformations.CubeInScalingTransformation;
import com.smarteist.autoimageslider.Transformations.CubeOutDepthTransformation;
import com.smarteist.autoimageslider.Transformations.CubeOutRotationTransformation;
import com.smarteist.autoimageslider.Transformations.CubeOutScalingTransformation;
import com.smarteist.autoimageslider.Transformations.DepthTransformation;
import com.smarteist.autoimageslider.Transformations.FadeTransformation;
import com.smarteist.autoimageslider.Transformations.FanTransformation;
import com.smarteist.autoimageslider.Transformations.FidgetSpinTransformation;
import com.smarteist.autoimageslider.Transformations.GateTransformation;
import com.smarteist.autoimageslider.Transformations.HingeTransformation;
import com.smarteist.autoimageslider.Transformations.HorizontalFlipTransformation;
import com.smarteist.autoimageslider.Transformations.PopTransformation;
import com.smarteist.autoimageslider.Transformations.SimpleTransformation;
import com.smarteist.autoimageslider.Transformations.SpinnerTransformation;
import com.smarteist.autoimageslider.Transformations.TossTransformation;
import com.smarteist.autoimageslider.Transformations.VerticalFlipTransformation;
import com.smarteist.autoimageslider.Transformations.VerticalShutTransformation;
import com.smarteist.autoimageslider.Transformations.ZoomOutTransformation;

public class SliderView
extends FrameLayout {
    public static final int AUTO_CYCLE_DIRECTION_RIGHT = 0;
    public static final int AUTO_CYCLE_DIRECTION_LEFT = 1;
    public static final int AUTO_CYCLE_DIRECTION_BACK_AND_FORTH = 2;
    private final Handler mHandler = new Handler();
    private boolean mFlagBackAndForth;
    private boolean mIsAutoCycle;
    private int mAutoCycleDirection;
    private int mScrollTimeInSec;
    private CircularSliderHandle mCircularSliderHandle;
    private PageIndicatorView mPagerIndicator;
    private DataSetObserver mDataSetObserver;
    private PagerAdapter mPagerAdapter;
    private Runnable mSliderRunnable;
    private SliderPager mSliderPager;

    public SliderView(Context context) {
        super(context);
        this.setupSlideView(context);
    }

    public SliderView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.setupSlideView(context);
        this.setUpAttributes(context, attrs);
    }

    public SliderView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.setupSlideView(context);
        this.setUpAttributes(context, attrs);
    }

    private void setUpAttributes(Context context, AttributeSet attrs) {
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.SliderView, 0, 0);
        int indicatorOrientation = typedArray.getInt(R.styleable.SliderView_sliderIndicatorOrientation, Orientation.HORIZONTAL.ordinal());
        Orientation orientation = indicatorOrientation == 0 ? Orientation.HORIZONTAL : Orientation.VERTICAL;
        int indicatorRadius = (int)typedArray.getDimension(R.styleable.SliderView_sliderIndicatorRadius, (float)DensityUtils.dpToPx(2));
        int indicatorPadding = (int)typedArray.getDimension(R.styleable.SliderView_sliderIndicatorPadding, (float)DensityUtils.dpToPx(3));
        int indicatorMargin = (int)typedArray.getDimension(R.styleable.SliderView_sliderIndicatorMargin, (float)DensityUtils.dpToPx(12));
        int indicatorGravity = typedArray.getInt(R.styleable.SliderView_sliderIndicatorGravity, 81);
        int indicatorUnselectedColor = typedArray.getColor(R.styleable.SliderView_sliderIndicatorUnselectedColor, Color.parseColor((String)"#33ffffff"));
        int indicatorSelectedColor = typedArray.getColor(R.styleable.SliderView_sliderIndicatorSelectedColor, Color.parseColor((String)"#ffffff"));
        int indicatorAnimationDuration = typedArray.getInt(R.styleable.SliderView_sliderIndicatorAnimationDuration, 350);
        int indicatorRtlMode = typedArray.getInt(R.styleable.SliderView_sliderIndicatorRtlMode, RtlMode.Off.ordinal());
        RtlMode rtlMode = AttributeController.getRtlMode(indicatorRtlMode);
        int sliderAnimationDuration = typedArray.getInt(R.styleable.SliderView_sliderAnimationDuration, 250);
        int sliderScrollTimeInSec = typedArray.getInt(R.styleable.SliderView_sliderScrollTimeInSec, 2);
        boolean sliderCircularHandlerEnabled = typedArray.getBoolean(R.styleable.SliderView_sliderCircularHandlerEnabled, true);
        boolean sliderAutoCycleEnabled = typedArray.getBoolean(R.styleable.SliderView_sliderAutoCycleEnabled, true);
        boolean sliderStartAutoCycle = typedArray.getBoolean(R.styleable.SliderView_sliderStartAutoCycle, false);
        int sliderAutoCycleDirection = typedArray.getInt(R.styleable.SliderView_sliderAutoCycleDirection, 0);
        this.setIndicatorOrientation(orientation);
        this.setIndicatorRadius(indicatorRadius);
        this.setIndicatorPadding(indicatorPadding);
        this.setIndicatorMargin(indicatorMargin);
        this.setIndicatorGravity(indicatorGravity);
        this.setIndicatorUnselectedColor(indicatorUnselectedColor);
        this.setIndicatorSelectedColor(indicatorSelectedColor);
        this.setIndicatorAnimationDuration(indicatorAnimationDuration);
        this.setIndicatorRtlMode(rtlMode);
        this.setSliderAnimationDuration(sliderAnimationDuration);
        this.setScrollTimeInSec(sliderScrollTimeInSec);
        this.setCircularHandlerEnabled(sliderCircularHandlerEnabled);
        this.setAutoCycle(sliderAutoCycleEnabled);
        this.setAutoCycleDirection(sliderAutoCycleDirection);
        if (sliderStartAutoCycle) {
            this.startAutoCycle();
        }
        typedArray.recycle();
    }

    private void setupSlideView(Context context) {
        View wrapperView = LayoutInflater.from((Context)context).inflate(R.layout.slider_view, (ViewGroup)this, true);
        this.mSliderPager = (SliderPager)wrapperView.findViewById(R.id.vp_slider_layout);
        this.mCircularSliderHandle = new CircularSliderHandle(this.mSliderPager);
        this.mSliderPager.addOnPageChangeListener(this.mCircularSliderHandle);
        this.mSliderPager.setOffscreenPageLimit(4);
        this.mPagerIndicator = (PageIndicatorView)wrapperView.findViewById(R.id.pager_indicator);
        this.mPagerIndicator.setViewPager(this.mSliderPager);
    }

    public void setOnIndicatorClickListener(DrawController.ClickListener listener) {
        this.mPagerIndicator.setClickListener(listener);
    }

    public void setCurrentPageListener(CircularSliderHandle.CurrentPageListener listener) {
        this.mCircularSliderHandle.setCurrentPageListener(listener);
    }

    public void setSliderAdapter(PagerAdapter pagerAdapter) {
        this.mPagerAdapter = pagerAdapter;
        this.mSliderPager.setAdapter(pagerAdapter);
        this.mPagerIndicator.setCount(this.getAdapterItemsCount());
        this.mPagerIndicator.setDynamicCount(true);
    }

    public PagerAdapter getSliderAdapter() {
        return this.mPagerAdapter;
    }

    private void registerAdapterDataObserver() {
        if (this.mDataSetObserver != null) {
            this.mPagerAdapter.unregisterDataSetObserver(this.mDataSetObserver);
        }
        this.mDataSetObserver = new DataSetObserver(){

            public void onChanged() {
                super.onChanged();
                SliderView.this.mSliderPager.setOffscreenPageLimit(SliderView.this.getAdapterItemsCount() - 1);
            }
        };
        this.mPagerAdapter.registerDataSetObserver(this.mDataSetObserver);
    }

    public boolean isAutoCycle() {
        return this.mIsAutoCycle;
    }

    public void setAutoCycle(boolean autoCycle) {
        this.mIsAutoCycle = autoCycle;
        if (!this.mIsAutoCycle && this.mSliderRunnable != null) {
            this.mHandler.removeCallbacks(this.mSliderRunnable);
            this.mSliderRunnable = null;
        }
    }

    public void setOffscreenPageLimit(int limit) {
        this.mSliderPager.setOffscreenPageLimit(limit);
    }

    public void setCircularHandlerEnabled(boolean enable) {
        this.mSliderPager.clearOnPageChangeListeners();
        if (enable) {
            this.mSliderPager.addOnPageChangeListener(this.mCircularSliderHandle);
        }
    }

    public int getScrollTimeInSec() {
        return this.mScrollTimeInSec;
    }

    public void setScrollTimeInSec(int time) {
        this.mScrollTimeInSec = time;
    }

    public void setSliderTransformAnimation(SliderAnimations animation) {
        switch (animation) {
            case ANTICLOCKSPINTRANSFORMATION: {
                this.mSliderPager.setPageTransformer(false, new AntiClockSpinTransformation());
                break;
            }
            case CLOCK_SPINTRANSFORMATION: {
                this.mSliderPager.setPageTransformer(false, new Clock_SpinTransformation());
                break;
            }
            case CUBEINDEPTHTRANSFORMATION: {
                this.mSliderPager.setPageTransformer(false, new CubeInDepthTransformation());
                break;
            }
            case CUBEINROTATIONTRANSFORMATION: {
                this.mSliderPager.setPageTransformer(false, new CubeInRotationTransformation());
                break;
            }
            case CUBEINSCALINGTRANSFORMATION: {
                this.mSliderPager.setPageTransformer(false, new CubeInScalingTransformation());
                break;
            }
            case CUBEOUTDEPTHTRANSFORMATION: {
                this.mSliderPager.setPageTransformer(false, new CubeOutDepthTransformation());
                break;
            }
            case CUBEOUTROTATIONTRANSFORMATION: {
                this.mSliderPager.setPageTransformer(false, new CubeOutRotationTransformation());
                break;
            }
            case CUBEOUTSCALINGTRANSFORMATION: {
                this.mSliderPager.setPageTransformer(false, new CubeOutScalingTransformation());
                break;
            }
            case DEPTHTRANSFORMATION: {
                this.mSliderPager.setPageTransformer(false, new DepthTransformation());
                break;
            }
            case FADETRANSFORMATION: {
                this.mSliderPager.setPageTransformer(false, new FadeTransformation());
                break;
            }
            case FANTRANSFORMATION: {
                this.mSliderPager.setPageTransformer(false, new FanTransformation());
                break;
            }
            case FIDGETSPINTRANSFORMATION: {
                this.mSliderPager.setPageTransformer(false, new FidgetSpinTransformation());
                break;
            }
            case GATETRANSFORMATION: {
                this.mSliderPager.setPageTransformer(false, new GateTransformation());
                break;
            }
            case HINGETRANSFORMATION: {
                this.mSliderPager.setPageTransformer(false, new HingeTransformation());
                break;
            }
            case HORIZONTALFLIPTRANSFORMATION: {
                this.mSliderPager.setPageTransformer(false, new HorizontalFlipTransformation());
                break;
            }
            case POPTRANSFORMATION: {
                this.mSliderPager.setPageTransformer(false, new PopTransformation());
                break;
            }
            case SIMPLETRANSFORMATION: {
                this.mSliderPager.setPageTransformer(false, new SimpleTransformation());
                break;
            }
            case SPINNERTRANSFORMATION: {
                this.mSliderPager.setPageTransformer(false, new SpinnerTransformation());
                break;
            }
            case TOSSTRANSFORMATION: {
                this.mSliderPager.setPageTransformer(false, new TossTransformation());
                break;
            }
            case VERTICALFLIPTRANSFORMATION: {
                this.mSliderPager.setPageTransformer(false, new VerticalFlipTransformation());
                break;
            }
            case VERTICALSHUTTRANSFORMATION: {
                this.mSliderPager.setPageTransformer(false, new VerticalShutTransformation());
                break;
            }
            case ZOOMOUTTRANSFORMATION: {
                this.mSliderPager.setPageTransformer(false, new ZoomOutTransformation());
                break;
            }
            default: {
                this.mSliderPager.setPageTransformer(false, new SimpleTransformation());
            }
        }
    }

    public void setCustomSliderTransformAnimation(ViewPager.PageTransformer animation) {
        this.mSliderPager.setPageTransformer(false, animation);
    }

    public void setSliderAnimationDuration(int duration) {
        this.mSliderPager.setScrollDuration(duration);
    }

    public void setCurrentPagePosition(int position) {
        if (this.getSliderAdapter() == null) {
            throw new NullPointerException("Adapter not set");
        }
        this.mSliderPager.setCurrentItem(position, true);
    }

    public int getCurrentPagePosition() {
        if (this.getSliderAdapter() != null) {
            return this.mSliderPager.getCurrentItem();
        }
        throw new NullPointerException("Adapter not set");
    }

    public void setIndicatorAnimationDuration(long duration) {
        this.mPagerIndicator.setAnimationDuration(duration);
    }

    public void setIndicatorGravity(int gravity) {
        FrameLayout.LayoutParams layoutParams = (FrameLayout.LayoutParams)this.mPagerIndicator.getLayoutParams();
        layoutParams.gravity = gravity;
        this.mPagerIndicator.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
    }

    public void setIndicatorPadding(int padding) {
        this.mPagerIndicator.setPadding(padding);
    }

    public void setIndicatorOrientation(Orientation orientation) {
        this.mPagerIndicator.setOrientation(orientation);
    }

    public void setIndicatorAnimation(IndicatorAnimations animations) {
        switch (animations) {
            case DROP: {
                this.mPagerIndicator.setAnimationType(AnimationType.DROP);
                break;
            }
            case FILL: {
                this.mPagerIndicator.setAnimationType(AnimationType.FILL);
                break;
            }
            case NONE: {
                this.mPagerIndicator.setAnimationType(AnimationType.NONE);
                break;
            }
            case SWAP: {
                this.mPagerIndicator.setAnimationType(AnimationType.SWAP);
                break;
            }
            case WORM: {
                this.mPagerIndicator.setAnimationType(AnimationType.WORM);
                break;
            }
            case COLOR: {
                this.mPagerIndicator.setAnimationType(AnimationType.COLOR);
                break;
            }
            case SCALE: {
                this.mPagerIndicator.setAnimationType(AnimationType.SCALE);
                break;
            }
            case SLIDE: {
                this.mPagerIndicator.setAnimationType(AnimationType.SLIDE);
                break;
            }
            case SCALE_DOWN: {
                this.mPagerIndicator.setAnimationType(AnimationType.SCALE_DOWN);
                break;
            }
            case THIN_WORM: {
                this.mPagerIndicator.setAnimationType(AnimationType.THIN_WORM);
            }
        }
    }

    public void setIndicatorVisibility(boolean visibility) {
        if (visibility) {
            this.mPagerIndicator.setVisibility(0);
        } else {
            this.mPagerIndicator.setVisibility(8);
        }
    }

    private int getAdapterItemsCount() {
        try {
            return this.getSliderAdapter().getCount();
        }
        catch (NullPointerException e) {
            return 0;
        }
    }

    public void startAutoCycle() {
        if (this.mSliderRunnable != null) {
            this.mHandler.removeCallbacks(this.mSliderRunnable);
            this.mSliderRunnable = null;
        }
        this.mSliderRunnable = new Runnable(){

            @Override
            public void run() {
                try {
                    if (!SliderView.this.mIsAutoCycle) {
                        return;
                    }
                    int currentPosition = SliderView.this.mSliderPager.getCurrentItem();
                    if (SliderView.this.mAutoCycleDirection == 2) {
                        if (currentPosition == 0) {
                            SliderView.this.mFlagBackAndForth = true;
                        }
                        if (currentPosition == SliderView.this.getAdapterItemsCount() - 1) {
                            SliderView.this.mFlagBackAndForth = false;
                        }
                        if (SliderView.this.mFlagBackAndForth) {
                            SliderView.this.mSliderPager.setCurrentItem(++currentPosition, true);
                        } else {
                            SliderView.this.mSliderPager.setCurrentItem(--currentPosition, true);
                        }
                    } else if (SliderView.this.mAutoCycleDirection == 1) {
                        if (currentPosition == 0) {
                            SliderView.this.mSliderPager.setCurrentItem(SliderView.this.getAdapterItemsCount() - 1, true);
                        } else {
                            SliderView.this.mSliderPager.setCurrentItem(--currentPosition, true);
                        }
                    } else if (currentPosition == SliderView.this.getAdapterItemsCount() - 1) {
                        SliderView.this.mSliderPager.setCurrentItem(0, true);
                    } else {
                        SliderView.this.mSliderPager.setCurrentItem(++currentPosition, true);
                    }
                }
                finally {
                    SliderView.this.mHandler.postDelayed((Runnable)this, (long)(SliderView.this.mScrollTimeInSec * 1000));
                }
            }
        };
        this.mHandler.postDelayed(this.mSliderRunnable, (long)(this.mScrollTimeInSec * 1000));
    }

    public void setAutoCycleDirection(int direction) {
        this.mAutoCycleDirection = direction;
    }

    public int getAutoCycleDirection() {
        return this.mAutoCycleDirection;
    }

    public int getIndicatorRadius() {
        return this.mPagerIndicator.getRadius();
    }

    public void setIndicatorRtlMode(RtlMode rtlMode) {
        this.mPagerIndicator.setRtlMode(rtlMode);
    }

    public void setIndicatorRadius(int pagerIndicatorRadius) {
        this.mPagerIndicator.setRadius(pagerIndicatorRadius);
    }

    public void setIndicatorMargin(int margin) {
        FrameLayout.LayoutParams layoutParams = (FrameLayout.LayoutParams)this.mPagerIndicator.getLayoutParams();
        layoutParams.setMargins(margin, margin, margin, margin);
        this.mPagerIndicator.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
    }

    public void setIndicatorSelectedColor(int color) {
        this.mPagerIndicator.setSelectedColor(color);
    }

    public int getIndicatorSelectedColor() {
        return this.mPagerIndicator.getSelectedColor();
    }

    public void setIndicatorUnselectedColor(int color) {
        this.mPagerIndicator.setUnselectedColor(color);
    }

    public int getIndicatorUnselectedColor() {
        return this.mPagerIndicator.getUnselectedColor();
    }
}

