/*
 * Decompiled with CFR 0.152.
 */
package inet.ipaddr.format;

import inet.ipaddr.AddressTypeException;
import inet.ipaddr.IPAddress;
import inet.ipaddr.format.AddressDivision;
import inet.ipaddr.format.util.AddressSegmentParams;

public abstract class IPAddressDivision
extends AddressDivision {
    private static final long serialVersionUID = 3L;
    public static final boolean ADJUST_RANGES_BY_PREFIX = true;
    private final Integer divisionNetworkPrefix;
    protected transient String cachedWildcardString;
    private transient Boolean isRangeEquivalentToPrefix;

    protected IPAddressDivision() {
        this(null);
    }

    protected IPAddressDivision(Integer networkPrefixLength) {
        if (networkPrefixLength != null && networkPrefixLength < 0) {
            throw new IllegalArgumentException();
        }
        this.divisionNetworkPrefix = networkPrefixLength;
    }

    public boolean isPrefixed() {
        return this.divisionNetworkPrefix != null;
    }

    public Integer getDivisionPrefixLength() {
        return this.divisionNetworkPrefix;
    }

    public boolean matchesWithPrefix(long value, Integer divisionPrefixLen) {
        if (divisionPrefixLen == null) {
            return this.matches(value);
        }
        long mask = this.getDivisionNetworkMask(divisionPrefixLen);
        long matchingValue = value & mask;
        return matchingValue == (this.getLowerValue() & mask) && matchingValue == (this.getUpperValue() & mask);
    }

    protected abstract long getDivisionNetworkMask(int var1);

    protected abstract long getDivisionHostMask(int var1);

    public Integer getMaskPrefixLength(boolean network) {
        long invertedVal;
        long val;
        if (network) {
            val = this.getLowerValue();
            invertedVal = (val ^ 0xFFFFFFFFFFFFFFFFL) & this.getMaxValue();
        } else {
            invertedVal = this.getLowerValue();
            val = (invertedVal ^ 0xFFFFFFFFFFFFFFFFL) & this.getMaxValue();
        }
        int bitCount = this.getBitCount();
        int hostLength = Math.min(Long.numberOfTrailingZeros(val), bitCount);
        long shifted = invertedVal >>> hostLength;
        return shifted == 0L ? Integer.valueOf(bitCount - hostLength) : null;
    }

    public boolean isSamePrefixedRange(long lowerValue) {
        return this.isPrefixed() ? this.isSamePrefixedRange(lowerValue, this.getDivisionPrefixLength()) : lowerValue == this.getLowerValue() && !this.isMultiple();
    }

    private boolean isSamePrefixedRange(long lowerValue, int divisionPrefixLen) {
        long mask = this.getDivisionNetworkMask(divisionPrefixLen);
        long expectedValue = lowerValue & mask;
        return this.getLowerValue() == expectedValue && this.getUpperValue() == (lowerValue | this.getDivisionHostMask(divisionPrefixLen));
    }

    private static boolean testRange(long lowerValue, long upperValue, long finalUpperValue, long networkMask, long hostMask) {
        return lowerValue == (lowerValue & networkMask) && finalUpperValue == (upperValue | hostMask);
    }

    private boolean isRangeUnchanged(long segmentValue, long upperValue, int divisionPrefixLen) {
        return IPAddressDivision.testRange(segmentValue, upperValue, upperValue, this.getDivisionNetworkMask(divisionPrefixLen), this.getDivisionHostMask(divisionPrefixLen));
    }

    protected boolean isRangeEquivalent(long segmentValue, long upperValue, int divisionPrefixLen) {
        return IPAddressDivision.testRange(segmentValue, segmentValue, upperValue, this.getDivisionNetworkMask(divisionPrefixLen), this.getDivisionHostMask(divisionPrefixLen));
    }

    public boolean isRangeEquivalent(Integer divisionPrefixLen) {
        if (divisionPrefixLen == null) {
            return !this.isMultiple();
        }
        return divisionPrefixLen == 0 || this.isRangeEquivalent(this.getLowerValue(), this.getUpperValue(), divisionPrefixLen);
    }

    public boolean isRangeUnchanged(Integer divisionPrefixLen) {
        if (divisionPrefixLen == null) {
            return true;
        }
        if (divisionPrefixLen == 0) {
            return this.isFullRange();
        }
        return this.isRangeUnchanged(this.getLowerValue(), this.getUpperValue(), divisionPrefixLen);
    }

    @Override
    public boolean isRangeEquivalentToPrefix() {
        if (this.isRangeEquivalentToPrefix == null) {
            this.isRangeEquivalentToPrefix = this.isRangeEquivalent(this.getDivisionPrefixLength());
        }
        return this.isRangeEquivalentToPrefix;
    }

    @Override
    protected boolean isRangeAdjustedToPrefix() {
        return !this.isPrefixed() || this.divisionNetworkPrefix.intValue() == this.getBitCount();
    }

    public boolean isBitwiseOrCompatibleWithRange(long maskValue, Integer divisionPrefixLen) {
        boolean differingIsLowestBit;
        long upperValue;
        int divPrefLen;
        boolean hasBits;
        boolean bl = hasBits = divisionPrefixLen != null;
        if (hasBits) {
            divPrefLen = divisionPrefixLen;
            if (divPrefLen < 0 || divPrefLen > this.getBitCount()) {
                throw new AddressTypeException(this, (int)divisionPrefixLen, "ipaddress.error.prefixSize");
            }
        } else {
            divPrefLen = this.getBitCount();
        }
        if (!this.isMultiple() || maskValue == this.getMaxValue() || maskValue == 0L) {
            return true;
        }
        long networkMask = this.getDivisionNetworkMask(divPrefLen);
        if (hasBits && (networkMask & maskValue) == networkMask) {
            return true;
        }
        long value = this.getLowerValue();
        long differing = (value ^ (upperValue = this.getUpperValue())) & networkMask;
        boolean foundDiffering = differing != 0L;
        boolean bl2 = differingIsLowestBit = differing == 1L;
        if (foundDiffering && !differingIsLowestBit) {
            int highestDifferingBitInRange = Long.numberOfLeadingZeros(differing);
            long maskMask = -1L >>> highestDifferingBitInRange;
            long differingMasked = maskValue & maskMask;
            foundDiffering = differingMasked != maskMask;
            boolean bl3 = differingIsLowestBit = (differingMasked | 1L) == maskMask;
            if (foundDiffering && !differingIsLowestBit) {
                int highestDifferingBitMasked = Long.numberOfLeadingZeros((differingMasked ^ 0xFFFFFFFFFFFFFFFFL) & maskMask);
                long hostMask = -1L >>> highestDifferingBitMasked + 1;
                if (((maskValue &= this.getDivisionNetworkMask(divPrefLen)) & hostMask) != 0L) {
                    return false;
                }
            }
        }
        return true;
    }

    public boolean isMaskCompatibleWithRange(long maskValue, Integer divisionPrefixLen) {
        boolean differingIsLowestBit;
        long upperValue;
        int divPrefLen;
        boolean hasBits;
        boolean bl = hasBits = divisionPrefixLen != null;
        if (hasBits) {
            divPrefLen = divisionPrefixLen;
            if (divPrefLen < 0 || divPrefLen > this.getBitCount()) {
                throw new AddressTypeException(this, (int)divisionPrefixLen, "ipaddress.error.prefixSize");
            }
        } else {
            divPrefLen = this.getBitCount();
        }
        if (!this.isMultiple() || maskValue == this.getMaxValue() || maskValue == 0L) {
            return true;
        }
        long networkMask = this.getDivisionNetworkMask(divPrefLen);
        if (hasBits && (networkMask & maskValue) == 0L) {
            return true;
        }
        long value = this.getLowerValue();
        long differing = (value ^ (upperValue = this.getUpperValue())) & networkMask;
        boolean foundDiffering = differing != 0L;
        boolean bl2 = differingIsLowestBit = differing == 1L;
        if (foundDiffering && !differingIsLowestBit) {
            int highestDifferingBitInRange = Long.numberOfLeadingZeros(differing);
            long maskMask = -1L >>> highestDifferingBitInRange;
            long differingMasked = maskValue & maskMask;
            foundDiffering = differingMasked != 0L;
            boolean bl3 = differingIsLowestBit = differingMasked == 1L;
            if (foundDiffering && !differingIsLowestBit) {
                int highestDifferingBitMasked = Long.numberOfLeadingZeros(differingMasked);
                long hostMask = -1L >>> highestDifferingBitMasked + 1;
                if (((maskValue |= this.getDivisionHostMask(divPrefLen)) & hostMask) != hostMask) {
                    return false;
                }
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getString() {
        String result = this.cachedString;
        if (result == null) {
            IPAddressDivision iPAddressDivision = this;
            synchronized (iPAddressDivision) {
                result = this.cachedString;
                if (result == null) {
                    if (this.isRangeEquivalentToPrefix()) {
                        result = this.getDefaultString();
                    } else if (this.isFullRange()) {
                        result = IPAddress.SEGMENT_WILDCARD_STR;
                    } else {
                        boolean maskUpper;
                        long upperValue = this.getUpperValue();
                        boolean bl = maskUpper = this.isPrefixed();
                        if (maskUpper) {
                            upperValue &= this.getDivisionNetworkMask(this.getDivisionPrefixLength());
                        }
                        result = this.getDefaultRangeString(this.getLowerValue(), upperValue, this.getDefaultTextualRadix(), maskUpper);
                    }
                    this.cachedString = result;
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getWildcardString() {
        String result = this.cachedWildcardString;
        if (result == null) {
            IPAddressDivision iPAddressDivision = this;
            synchronized (iPAddressDivision) {
                result = this.cachedWildcardString;
                if (result == null) {
                    result = !this.isPrefixed() || !this.isMultiple() ? this.getString() : (this.isFullRange() ? IPAddress.SEGMENT_WILDCARD_STR : this.getDefaultRangeString());
                    this.cachedWildcardString = result;
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void setFullRangeWildcardString() {
        if (this.cachedWildcardString == null) {
            IPAddressDivision iPAddressDivision = this;
            synchronized (iPAddressDivision) {
                this.cachedWildcardString = IPAddress.SEGMENT_WILDCARD_STR;
            }
        }
    }

    @Override
    protected void getUpperStringMasked(int radix, boolean uppercase, StringBuilder appendable) {
        long upperValue = this.getUpperValue();
        long mask = this.getDivisionNetworkMask(this.getDivisionPrefixLength());
        IPAddressDivision.toUnsignedString(upperValue &= mask, radix, 0, uppercase, uppercase ? UPPED_DIGITS : DIGITS, appendable);
    }

    @Override
    public int getConfiguredString(int segmentIndex, AddressSegmentParams params, StringBuilder appendable) {
        if (params.preferWildcards() || params.isSplitDigits()) {
            return this.getStandardString(segmentIndex, params, appendable);
        }
        return this.getPrefixAdjustedString(segmentIndex, params, appendable);
    }
}

