/*
 * Decompiled with CFR 0.152.
 */
package inet.ipaddr.format;

import inet.ipaddr.format.AddressDivision;
import inet.ipaddr.format.IPAddressDivision;

public class IPAddressBitsDivision
extends IPAddressDivision {
    private static final long serialVersionUID = 3L;
    private final int bitCount;
    private final int defaultRadix;
    private final int maxDigitCount;
    private final long value;
    private final long upperValue;
    private final long bitsMask;

    public IPAddressBitsDivision(long value, long upperValue, int bitCount, int defaultRadix) {
        this(value, upperValue, bitCount, defaultRadix, null);
    }

    public IPAddressBitsDivision(long value, long upperValue, int bitCount, int defaultRadix, Integer networkPrefixLength) {
        super(networkPrefixLength);
        this.bitCount = bitCount;
        this.value = value;
        this.upperValue = upperValue;
        this.defaultRadix = defaultRadix;
        this.bitsMask = -1L << bitCount ^ 0xFFFFFFFFFFFFFFFFL;
        this.maxDigitCount = IPAddressBitsDivision.getMaxDigitCount(defaultRadix, bitCount, this.bitsMask);
    }

    @Override
    public int getBitCount() {
        return this.bitCount;
    }

    @Override
    protected long getDivisionNetworkMask(int bits) {
        int bitShift = this.bitCount - bits;
        return this.bitsMask & -1L << bitShift;
    }

    @Override
    protected long getDivisionHostMask(int bits) {
        int bitShift = this.bitCount - bits;
        return -1L << bitShift ^ 0xFFFFFFFFFFFFFFFFL;
    }

    @Override
    public long getLowerValue() {
        return this.value;
    }

    @Override
    public long getUpperValue() {
        return this.upperValue;
    }

    @Override
    protected boolean isSameValues(AddressDivision other) {
        if (other instanceof IPAddressBitsDivision) {
            return this.isSameValues((IPAddressBitsDivision)other);
        }
        return false;
    }

    protected boolean isSameValues(IPAddressBitsDivision otherSegment) {
        return this.value == otherSegment.value && this.upperValue == otherSegment.upperValue && this.bitCount == otherSegment.bitCount;
    }

    @Override
    public int getDefaultTextualRadix() {
        return this.defaultRadix;
    }

    @Override
    public int getMaxDigitCount() {
        return this.maxDigitCount;
    }
}

