/*
 * Decompiled with CFR 0.152.
 */
package inet.ipaddr.format;

import inet.ipaddr.Address;
import inet.ipaddr.AddressTypeException;
import inet.ipaddr.format.AddressDivision;
import inet.ipaddr.format.AddressDivisionBase;
import inet.ipaddr.format.util.AddressSegmentParams;
import java.math.BigInteger;
import java.util.Arrays;

public class AddressLargeDivision
extends AddressDivisionBase {
    private static BigInteger LONG_MAX = BigInteger.valueOf(Long.MAX_VALUE);
    public static final char EXTENDED_DIGITS_RANGE_SEPARATOR = '\u203a';
    public static final String EXTENDED_DIGITS_RANGE_SEPARATOR_STR = String.valueOf('\u203a');
    public static final char[] EXTENDED_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '!', '#', '$', '%', '&', '(', ')', '*', '+', '-', ';', '<', '=', '>', '?', '@', '^', '_', '`', '{', '|', '}', '~'};
    private static final long serialVersionUID = 3L;
    private final BigInteger value;
    private final BigInteger upperValue;
    private final BigInteger maxValue;
    private final BigInteger upperValueMasked;
    private final BigInteger defaultRadix;
    private final int bitCount;
    private final Integer networkPrefixLength;
    private final boolean isRangeEquivalentToPrefix;

    public AddressLargeDivision(byte[] bytes, byte[] upperBytes, int bitCount, int defaultRadix, Integer networkPrefixLength) {
        boolean isRangeEquivalentToPrefix;
        byte[] maskedBytes;
        boolean isUpperMasked;
        block10: {
            block9: {
                int i;
                this.bitCount = bitCount;
                this.defaultRadix = BigInteger.valueOf(defaultRadix);
                isUpperMasked = networkPrefixLength == null;
                maskedBytes = null;
                if (isUpperMasked) break block9;
                int shift = bitCount - networkPrefixLength;
                int byteIndex = (shift + 7) / 8;
                int mask = -1 << shift % 8;
                int n = byteIndex;
                bytes[n] = (byte)(bytes[n] & mask);
                isRangeEquivalentToPrefix = isUpperMasked = bytes == upperBytes;
                if (isUpperMasked) break block10;
                byte upper = upperBytes[byteIndex];
                byte newUpper = (byte)(upper & mask);
                isUpperMasked = newUpper == upper;
                boolean bl = isRangeEquivalentToPrefix = newUpper == (bytes[byteIndex] & mask);
                if (isRangeEquivalentToPrefix) {
                    i = byteIndex - 1;
                    while (i >= 0) {
                        if (bytes[i] != upperBytes[i]) {
                            isRangeEquivalentToPrefix = false;
                            break;
                        }
                        --i;
                    }
                }
                if (isUpperMasked) {
                    i = byteIndex;
                    while (i < upperBytes.length) {
                        if (bytes[i] != 0) {
                            isUpperMasked = false;
                            break;
                        }
                        ++i;
                    }
                }
                if (isUpperMasked) break block10;
                maskedBytes = Arrays.copyOf(upperBytes, upperBytes.length);
                maskedBytes[byteIndex] = newUpper;
                Arrays.fill(maskedBytes, byteIndex + 1, maskedBytes.length, (byte)0);
                break block10;
            }
            isRangeEquivalentToPrefix = true;
            if (bytes != upperBytes) {
                int i = bytes.length - 1;
                while (i >= 0) {
                    if (bytes[i] != upperBytes[i]) {
                        isRangeEquivalentToPrefix = false;
                        break;
                    }
                    --i;
                }
            }
        }
        this.isRangeEquivalentToPrefix = isRangeEquivalentToPrefix;
        this.upperValue = new BigInteger(1, upperBytes);
        this.upperValueMasked = isUpperMasked ? this.upperValue : new BigInteger(1, maskedBytes);
        this.value = bytes == upperBytes ? this.upperValue : new BigInteger(1, bytes);
        this.maxValue = AddressLargeDivision.getMaxValue(bitCount);
        this.networkPrefixLength = networkPrefixLength;
    }

    public AddressLargeDivision(byte[] bytes, int bitCount, int defaultRadix, Integer prefix) {
        this(bytes, bytes, bitCount, defaultRadix, prefix);
    }

    @Override
    public boolean isBoundedBy(int val) {
        BigInteger bigVal = BigInteger.valueOf(val);
        return this.upperValue.compareTo(bigVal) < 0;
    }

    @Override
    public int getDigitCount(int radix) {
        if (!this.isMultiple() && radix == this.getDefaultTextualRadix()) {
            return this.getString().length();
        }
        return AddressLargeDivision.getDigitCountStatic(this.upperValue, radix);
    }

    @Override
    public BigInteger getCount() {
        return this.upperValue.subtract(this.value).add(BigInteger.ONE);
    }

    @Override
    public int getBitCount() {
        return this.bitCount;
    }

    @Override
    public boolean isMultiple() {
        return !this.value.equals(this.upperValue);
    }

    @Override
    public boolean isZero() {
        return this.value.equals(BigInteger.ZERO) && !this.isMultiple();
    }

    @Override
    public boolean isFullRange() {
        return this.value.equals(BigInteger.ZERO) && this.upperValue.equals(this.maxValue);
    }

    @Override
    protected byte[] getBytesImpl(boolean low) {
        return low ? this.value.toByteArray() : this.upperValue.toByteArray();
    }

    @Override
    public int getDefaultTextualRadix() {
        return this.defaultRadix.intValue();
    }

    @Override
    public int getMaxDigitCount() {
        return AddressLargeDivision.getMaxDigitCount(this.defaultRadix.intValue(), this.bitCount, this.maxValue);
    }

    @Override
    public int getMaxDigitCount(int radix) {
        return AddressLargeDivision.getMaxDigitCount(radix, this.bitCount, this.maxValue);
    }

    @Override
    protected int adjustLowerLeadingZeroCount(int leadingZeroCount, int radix) {
        return this.adjustLeadingZeroCount(leadingZeroCount, this.value, radix);
    }

    @Override
    protected int adjustUpperLeadingZeroCount(int leadingZeroCount, int radix) {
        return this.adjustLeadingZeroCount(leadingZeroCount, this.upperValue, radix);
    }

    private int adjustLeadingZeroCount(int leadingZeroCount, BigInteger value, int radix) {
        if (leadingZeroCount < 0) {
            int width = this.getDigitCount(value, radix);
            return Math.max(0, this.getMaxDigitCount(radix) - width);
        }
        return leadingZeroCount;
    }

    private int getDigitCount(BigInteger val, int radix) {
        BigInteger bigRadix = this.defaultRadix.intValue() == radix ? this.defaultRadix : BigInteger.valueOf(radix);
        return AddressLargeDivision.getDigitCount(val, bigRadix);
    }

    private static int getDigitCountStatic(BigInteger val, int radix) {
        return AddressLargeDivision.getDigitCount(val, BigInteger.valueOf(radix));
    }

    private String toDefaultString(BigInteger val, int radix, boolean uppercase, int choppedDigits) {
        BigInteger bigRadix = this.defaultRadix.intValue() == radix ? this.defaultRadix : BigInteger.valueOf(radix);
        return AddressLargeDivision.toDefaultString(val, bigRadix, uppercase, choppedDigits, AddressLargeDivision.getMaxDigitCount(radix, this.bitCount, null));
    }

    private static void toDefaultStringRecursive(BigInteger val, BigInteger radix, boolean uppercase, int choppedDigits, int digitCount, char[] dig, boolean highest, StringBuilder builder) {
        if (val.compareTo(LONG_MAX) <= 0) {
            long longVal = val.longValue();
            int intRadix = radix.intValue();
            if (!highest) {
                AddressLargeDivision.getLeadingZeros(digitCount - AddressDivision.toUnsignedStringLength(longVal, intRadix), builder);
            }
            AddressDivision.toUnsignedString(longVal, intRadix, choppedDigits, uppercase, dig, builder);
        } else {
            int halfCount = digitCount >>> 1;
            if (halfCount > choppedDigits) {
                BigInteger radixPower = AddressLargeDivision.getRadixPower(radix, halfCount);
                BigInteger[] highLow = val.divideAndRemainder(radixPower);
                BigInteger high = highLow[0];
                BigInteger low = highLow[1];
                if (highest && high.equals(BigInteger.ZERO)) {
                    AddressLargeDivision.toDefaultStringRecursive(low, radix, uppercase, choppedDigits, halfCount, dig, true, builder);
                } else {
                    if (digitCount > choppedDigits) {
                        AddressLargeDivision.toDefaultStringRecursive(high, radix, uppercase, Math.max(0, choppedDigits - halfCount), digitCount - halfCount, dig, highest, builder);
                    }
                    AddressLargeDivision.toDefaultStringRecursive(low, radix, uppercase, choppedDigits, halfCount, dig, false, builder);
                }
            }
        }
    }

    private boolean isExtendedDigits() {
        return AddressLargeDivision.isExtendedDigits(this.defaultRadix.intValue());
    }

    private static boolean isExtendedDigits(int radix) {
        return radix > 36;
    }

    private static char[] getDigits(int radix, boolean uppercase) {
        if (AddressLargeDivision.isExtendedDigits(radix)) {
            return EXTENDED_DIGITS;
        }
        return uppercase ? UPPED_DIGITS : DIGITS;
    }

    private static String toDefaultString(BigInteger val, BigInteger radix, boolean uppercase, int choppedDigits, int maxDigits) {
        if (val.equals(BigInteger.ZERO)) {
            return "0";
        }
        if (val.equals(BigInteger.ONE)) {
            return "1";
        }
        char[] dig = AddressLargeDivision.getDigits(radix.intValue(), uppercase);
        StringBuilder builder = new StringBuilder();
        if (maxDigits > 0) {
            if (maxDigits > choppedDigits) {
                AddressLargeDivision.toDefaultStringRecursive(val, radix, uppercase, choppedDigits, maxDigits, dig, true, builder);
            }
        } else {
            do {
                BigInteger[] divisorRemainder = val.divideAndRemainder(radix);
                BigInteger quotient = divisorRemainder[0];
                BigInteger remainder = divisorRemainder[1];
                if (choppedDigits > 0) {
                    --choppedDigits;
                    continue;
                }
                builder.append(dig[remainder.intValue()]);
                val = quotient;
            } while (!val.equals(BigInteger.ZERO));
            builder.reverse();
        }
        return builder.toString();
    }

    @Override
    protected String getDefaultString() {
        return AddressLargeDivision.toDefaultString(this.value, this.defaultRadix, false, 0, this.getMaxDigitCount());
    }

    @Override
    protected String getDefaultRangeString() {
        return String.valueOf(AddressLargeDivision.toDefaultString(this.value, this.defaultRadix, false, 0, this.getMaxDigitCount())) + this.getDefaultRangeSeparatorString() + AddressLargeDivision.toDefaultString(this.upperValue, this.defaultRadix, false, 0, this.getMaxDigitCount());
    }

    @Override
    protected String getDefaultSegmentWildcardString() {
        return this.isExtendedDigits() ? null : Address.SEGMENT_WILDCARD_STR;
    }

    @Override
    protected String getDefaultRangeSeparatorString() {
        return this.isExtendedDigits() ? EXTENDED_DIGITS_RANGE_SEPARATOR_STR : Address.RANGE_SEPARATOR_STR;
    }

    @Override
    protected int getLowerStringLength(int radix) {
        return AddressLargeDivision.getDigitCount(this.value, this.defaultRadix);
    }

    @Override
    protected int getUpperStringLength(int radix) {
        return AddressLargeDivision.getDigitCount(this.upperValue, this.defaultRadix);
    }

    @Override
    protected void getLowerString(int radix, boolean uppercase, StringBuilder appendable) {
        appendable.append(this.toDefaultString(this.value, radix, uppercase, 0));
    }

    @Override
    protected void getLowerString(int radix, int choppedDigits, boolean uppercase, StringBuilder appendable) {
        appendable.append(this.toDefaultString(this.value, radix, uppercase, choppedDigits));
    }

    @Override
    protected void getUpperString(int radix, boolean uppercase, StringBuilder appendable) {
        appendable.append(this.toDefaultString(this.upperValue, radix, uppercase, 0));
    }

    @Override
    protected void getUpperStringMasked(int radix, boolean uppercase, StringBuilder appendable) {
        appendable.append(this.toDefaultString(this.upperValueMasked, radix, uppercase, 0));
    }

    @Override
    protected void getSplitLowerString(int radix, int choppedDigits, boolean uppercase, char splitDigitSeparator, boolean reverseSplitDigits, String stringPrefix, StringBuilder appendable) {
        StringBuilder builder = new StringBuilder();
        this.getLowerString(radix, choppedDigits, uppercase, builder);
        int i = 0;
        while (i < builder.length()) {
            if (i > 0) {
                appendable.append(splitDigitSeparator);
            }
            if (stringPrefix != null) {
                appendable.append(stringPrefix);
            }
            appendable.append(builder.charAt(reverseSplitDigits ? builder.length() - i - 1 : i));
            ++i;
        }
    }

    @Override
    protected void getSplitRangeString(String rangeSeparator, String wildcard, int radix, boolean uppercase, char splitDigitSeparator, boolean reverseSplitDigits, String stringPrefix, StringBuilder appendable) {
        StringBuilder lowerBuilder = new StringBuilder();
        StringBuilder upperBuilder = new StringBuilder();
        this.getLowerString(radix, uppercase, lowerBuilder);
        this.getUpperString(radix, uppercase, upperBuilder);
        int diff = upperBuilder.length() - lowerBuilder.length();
        if (diff > 0) {
            StringBuilder newLowerBuilder = new StringBuilder();
            while (diff-- > 0) {
                newLowerBuilder.append('0');
            }
            newLowerBuilder.append((CharSequence)lowerBuilder);
            lowerBuilder = newLowerBuilder;
        }
        boolean previousWasFull = true;
        boolean nextMustBeFull = false;
        char[] dig = AddressLargeDivision.getDigits(radix, uppercase);
        char zeroDigit = dig[0];
        char highestDigit = dig[radix - 1];
        int len = lowerBuilder.length();
        int i = 0;
        while (i < len) {
            int index = reverseSplitDigits ? len - i - 1 : i;
            char lower = lowerBuilder.charAt(index);
            char upper = upperBuilder.charAt(index);
            if (i > 0) {
                appendable.append(splitDigitSeparator);
            }
            if (lower == upper) {
                if (nextMustBeFull) {
                    throw new AddressTypeException((long)lower, (long)upper, "ipaddress.error.splitMismatch");
                }
                if (stringPrefix != null) {
                    appendable.append(stringPrefix);
                }
                appendable.append(lower);
            } else {
                boolean isFullRange;
                boolean bl = isFullRange = lower == zeroDigit && upper == highestDigit;
                if (isFullRange) {
                    appendable.append(wildcard);
                } else {
                    if (nextMustBeFull) {
                        throw new AddressTypeException((long)lower, (long)upper, "ipaddress.error.splitMismatch");
                    }
                    if (stringPrefix != null) {
                        appendable.append(stringPrefix);
                    }
                    appendable.append(lower);
                    appendable.append(rangeSeparator);
                    appendable.append(upper);
                }
                if (reverseSplitDigits) {
                    if (!previousWasFull) {
                        throw new AddressTypeException((long)lower, (long)upper, "ipaddress.error.splitMismatch");
                    }
                    previousWasFull = isFullRange;
                } else {
                    nextMustBeFull = true;
                }
            }
            ++i;
        }
    }

    @Override
    protected int getSplitRangeStringLength(String rangeSeparator, String wildcard, int leadingZeroCount, int radix, boolean uppercase, char splitDigitSeparator, boolean reverseSplitDigits, String stringPrefix) {
        int digitsLength = -1;
        int stringPrefixLength = stringPrefix == null ? 0 : stringPrefix.length();
        StringBuilder lowerBuilder = new StringBuilder();
        StringBuilder upperBuilder = new StringBuilder();
        this.getLowerString(radix, uppercase, lowerBuilder);
        this.getUpperString(radix, uppercase, upperBuilder);
        char[] dig = AddressLargeDivision.getDigits(radix, uppercase);
        char zeroDigit = dig[0];
        char highestDigit = dig[radix - 1];
        int remainingAfterLoop = leadingZeroCount;
        int i = 1;
        while (i <= upperBuilder.length()) {
            boolean isFullRange;
            char lower = i <= lowerBuilder.length() ? lowerBuilder.charAt(lowerBuilder.length() - i) : (char)'\u0000';
            int upperIndex = upperBuilder.length() - i;
            char upper = upperBuilder.charAt(upperIndex);
            boolean bl = isFullRange = lower == zeroDigit && upper == highestDigit;
            if (isFullRange) {
                digitsLength += wildcard.length() + 1;
            } else if (lower != upper) {
                digitsLength += (stringPrefixLength << 1) + 4;
            } else {
                remainingAfterLoop += upperIndex + 1;
                break;
            }
            ++i;
        }
        if (remainingAfterLoop > 0) {
            digitsLength += remainingAfterLoop * (stringPrefixLength + 2);
        }
        return digitsLength;
    }

    @Override
    protected boolean lowerValueIsZero() {
        return this.value.equals(BigInteger.ZERO);
    }

    @Override
    protected int getRangeDigitCount(int radix) {
        if (!this.isMultiple()) {
            return 0;
        }
        BigInteger val = this.value;
        BigInteger upperVal = this.upperValue;
        int count = 1;
        BigInteger bigRadix = BigInteger.valueOf(radix);
        BigInteger bigUpper = BigInteger.valueOf(radix - 1);
        while (true) {
            BigInteger[] highLow = val.divideAndRemainder(bigRadix);
            BigInteger quotient = highLow[0];
            BigInteger remainder = highLow[1];
            if (!remainder.equals(BigInteger.ZERO)) break;
            highLow = upperVal.divideAndRemainder(bigRadix);
            BigInteger upperQuotient = highLow[0];
            remainder = highLow[1];
            if (!remainder.equals(bigUpper)) break;
            val = quotient;
            upperVal = upperQuotient;
            if (val.equals(upperVal)) {
                return count;
            }
            ++count;
        }
        return 0;
    }

    @Override
    public int getConfiguredString(int segmentIndex, AddressSegmentParams params, StringBuilder appendable) {
        if (params.preferWildcards() || params.isSplitDigits()) {
            return this.getStandardString(segmentIndex, params, appendable);
        }
        return this.getPrefixAdjustedString(segmentIndex, params, appendable);
    }

    @Override
    protected boolean isRangeAdjustedToPrefix() {
        return this.networkPrefixLength == null || this.networkPrefixLength == this.bitCount;
    }

    @Override
    protected boolean isRangeEquivalentToPrefix() {
        return this.isRangeEquivalentToPrefix;
    }
}

