/*
 * Decompiled with CFR 0.152.
 */
package com.github.npathai.hamcrestopt;

import java.util.Optional;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;
import org.hamcrest.core.IsEqual;

public class OptionalMatchers {
    public static Matcher<Optional<?>> isPresent() {
        return new PresenceMatcher();
    }

    public static Matcher<Optional<?>> isEmpty() {
        return new EmptyMatcher();
    }

    public static <T> Matcher<Optional<T>> isPresentAndIs(T operand) {
        return new HasValue(IsEqual.equalTo(operand));
    }

    public static <T> Matcher<Optional<T>> isPresentAnd(Matcher<? super T> matcher) {
        return new HasValue<T>(matcher);
    }

    private OptionalMatchers() {
    }

    private static class HasValue<T>
    extends TypeSafeMatcher<Optional<T>> {
        private Matcher<? super T> matcher;

        public HasValue(Matcher<? super T> matcher) {
            this.matcher = matcher;
        }

        public void describeTo(Description description) {
            description.appendText("has value that is ");
            this.matcher.describeTo(description);
        }

        protected boolean matchesSafely(Optional<T> item) {
            return item.isPresent() && this.matcher.matches(item.get());
        }

        protected void describeMismatchSafely(Optional<T> item, Description mismatchDescription) {
            if (item.isPresent()) {
                mismatchDescription.appendText("value ");
                this.matcher.describeMismatch(item.get(), mismatchDescription);
            } else {
                mismatchDescription.appendText("was <Empty>");
            }
        }
    }

    private static class EmptyMatcher
    extends TypeSafeMatcher<Optional<?>> {
        private EmptyMatcher() {
        }

        public void describeTo(Description description) {
            description.appendText("is <Empty>");
        }

        protected boolean matchesSafely(Optional<?> item) {
            return !item.isPresent();
        }

        protected void describeMismatchSafely(Optional<?> item, Description mismatchDescription) {
            mismatchDescription.appendText("had value ");
            mismatchDescription.appendValue(item.get());
        }
    }

    private static class PresenceMatcher
    extends TypeSafeMatcher<Optional<?>> {
        private PresenceMatcher() {
        }

        public void describeTo(Description description) {
            description.appendText("is <Present>");
        }

        protected boolean matchesSafely(Optional<?> item) {
            return item.isPresent();
        }

        protected void describeMismatchSafely(Optional<?> item, Description mismatchDescription) {
            mismatchDescription.appendText("was <Empty>");
        }
    }
}

