/*
 * Decompiled with CFR 0.152.
 */
package com.github.mvp4g.mvp4g2.processor.generator;

import com.github.mvp4g.mvp4g2.core.application.IsApplicationLoader;
import com.github.mvp4g.mvp4g2.core.internal.application.AbstractApplication;
import com.github.mvp4g.mvp4g2.processor.ProcessorException;
import com.github.mvp4g.mvp4g2.processor.ProcessorUtils;
import com.github.mvp4g.mvp4g2.processor.model.ApplicationMetaModel;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.io.IOException;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Modifier;

public class ApplicationGenerator {
    private static final String IMPL_NAME = "Impl";
    private ProcessorUtils processorUtils;
    private ProcessingEnvironment processingEnvironment;

    private ApplicationGenerator(Builder builder) {
        this.processingEnvironment = builder.processingEnvironment;
        this.setUp();
    }

    private void setUp() {
        this.processorUtils = ProcessorUtils.builder().processingEnvironment(this.processingEnvironment).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public void generate(ApplicationMetaModel metaModel) throws ProcessorException {
        if (!this.processorUtils.doesExist(metaModel.getApplication())) {
            return;
        }
        TypeSpec.Builder typeSpec = TypeSpec.classBuilder((String)(metaModel.getApplication().getSimpleName() + IMPL_NAME)).superclass((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(AbstractApplication.class), (TypeName[])new TypeName[]{metaModel.getEventBus().getTypeName()})).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addSuperinterface(metaModel.getApplication().getTypeName());
        MethodSpec constructor = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addStatement("super()", new Object[0]).addStatement("super.eventBus = new $N.$N()", new Object[]{metaModel.getEventBus().getPackage(), metaModel.getEventBus().getSimpleName() + IMPL_NAME}).addStatement("super.historyOnStart = $L", new Object[]{metaModel.getHistoryOnStart()}).addStatement("super.encodeToken = $L", new Object[]{metaModel.getEncodeToken()}).build();
        typeSpec.addMethod(constructor);
        MethodSpec getApplicaitonLaoderMethod = MethodSpec.methodBuilder((String)"getApplicationLoader").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).returns(IsApplicationLoader.class).addStatement("return new $T()", new Object[]{metaModel.getLoader().getTypeName()}).build();
        typeSpec.addMethod(getApplicaitonLaoderMethod);
        JavaFile javaFile = JavaFile.builder((String)metaModel.getEventBus().getPackage(), (TypeSpec)typeSpec.build()).build();
        try {
            javaFile.writeTo(this.processingEnvironment.getFiler());
        }
        catch (IOException e) {
            throw new ProcessorException("Unable to write generated file: >>" + metaModel.getEventBus().getSimpleName() + IMPL_NAME + "<< -> exception: " + e.getMessage());
        }
    }

    public static class Builder {
        ProcessingEnvironment processingEnvironment;

        public Builder processingEnvironment(ProcessingEnvironment processingEnvironment) {
            this.processingEnvironment = processingEnvironment;
            return this;
        }

        public ApplicationGenerator build() {
            return new ApplicationGenerator(this);
        }
    }
}

