/*
 * Decompiled with CFR 0.152.
 */
package com.github.microwww.redis.protocal.operation;

import com.github.microwww.redis.RequestParams;
import com.github.microwww.redis.database.AbstractValueData;
import com.github.microwww.redis.database.Bytes;
import com.github.microwww.redis.database.HashKey;
import com.github.microwww.redis.database.RedisDatabase;
import com.github.microwww.redis.protocal.AbstractOperation;
import com.github.microwww.redis.protocal.RedisArgumentsException;
import com.github.microwww.redis.protocal.RedisOutputProtocol;
import com.github.microwww.redis.protocal.RedisRequest;
import com.github.microwww.redis.protocal.ScanIterator;
import com.github.microwww.redis.protocal.jedis.Protocol;
import com.github.microwww.redis.util.Assert;
import com.github.microwww.redis.util.SafeEncoder;
import com.github.microwww.redis.util.StringUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;

public class KeyOperation
extends AbstractOperation {
    public void expire(RedisRequest request) throws IOException {
        RequestParams[] args = request.getParams();
        Assert.isTrue(args.length == 2, "Must has tow arguments");
        HashKey key = args[0].byteArray2hashKey();
        long exp = args[1].byteArray2long();
        this.exp(request, key, exp);
    }

    private void exp(RedisRequest request, HashKey key, long seconds) throws IOException {
        this.expMilliseconds(request, key, seconds * 1000L + System.currentTimeMillis());
    }

    private void expMilliseconds(RedisRequest request, HashKey key, long exp) throws IOException {
        RedisDatabase db = request.getDatabase();
        Optional<AbstractValueData<?>> opt = db.setExpire(key, exp <= 0L ? 0L : exp);
        int exist = opt.map(e -> 1).orElse(0);
        request.getOutputProtocol().writer(exist);
    }

    public void del(RedisRequest request) throws IOException {
        request.expectArgumentsCountBigger(0);
        int count = 0;
        for (RequestParams arg : request.getParams()) {
            AbstractValueData<?> val = request.getDatabase().remove(arg.byteArray2hashKey());
            if (val == null) continue;
            ++count;
        }
        request.getOutputProtocol().writer(count);
    }

    public void unlink(RedisRequest request) throws IOException {
        this.del(request);
    }

    public void exists(RedisRequest request) throws IOException {
        request.expectArgumentsCountBigger(0);
        RequestParams[] args = request.getParams();
        long count = Arrays.stream(args).map(e -> {
            HashKey key = e.byteArray2hashKey();
            return request.getDatabase().get(key);
        }).filter(Optional::isPresent).count();
        request.getOutputProtocol().writer(count);
    }

    public void expireat(RedisRequest request) throws IOException {
        request.expectArgumentsCount(2);
        HashKey key = request.getParams()[0].byteArray2hashKey();
        int time = Integer.parseInt(request.getParams()[1].getByteArray2string());
        long exp = (long)time * 1000L;
        this.expMilliseconds(request, key, exp);
    }

    public void keys(RedisRequest request) throws IOException {
        request.expectArgumentsCount(1);
        String patten = request.getParams()[0].getByteArray2string();
        Pattern compile = StringUtil.antPattern(patten);
        ArrayList<byte[]> list = new ArrayList<byte[]>();
        for (HashKey s : request.getDatabase().getUnmodifiableMap().keySet()) {
            byte[] k = s.getBytes();
            String key = SafeEncoder.encode(k);
            if (!compile.matcher(key).matches()) continue;
            list.add(k);
        }
        request.getOutputProtocol().writerMulti((byte[][])list.toArray((T[])new byte[list.size()][]));
    }

    public void move(RedisRequest request) throws IOException {
        request.expectArgumentsCount(2);
        HashKey key = request.getParams()[0].byteArray2hashKey();
        int index = request.getParams()[1].byteArray2int();
        RedisDatabase db = request.getDatabase();
        RedisDatabase rd = request.getServer().getSchema().getRedisDatabases(index);
        Integer sync = db.sync(() -> rd.sync(() -> {
            AbstractValueData<?> origin;
            Optional<AbstractValueData<?>> data = db.get(key);
            if (data.isPresent() && (origin = rd.putIfAbsent(key, data.get())) == null) {
                db.remove(key);
                return 1;
            }
            return 0;
        }));
        request.getOutputProtocol().writer(sync);
    }

    public void persist(RedisRequest request) throws IOException {
        request.expectArgumentsCount(1);
        HashKey key = request.getParams()[0].byteArray2hashKey();
        Optional<AbstractValueData<?>> opt = request.getDatabase().get(key);
        Integer re = opt.map(e -> request.getDatabase().sync(() -> {
            e.setExpire(-1L);
            return 1;
        })).orElse(0);
        request.getOutputProtocol().writer(re);
    }

    public void pexpire(RedisRequest request) throws IOException {
        request.expectArgumentsCount(2);
        HashKey key = request.getParams()[0].byteArray2hashKey();
        long time = Long.parseLong(request.getParams()[1].getByteArray2string());
        this.expMilliseconds(request, key, System.currentTimeMillis() + time);
    }

    public void pexpireat(RedisRequest request) throws IOException {
        request.expectArgumentsCount(2);
        HashKey key = request.getParams()[0].byteArray2hashKey();
        long time = request.getParams()[1].byteArray2long();
        this.expMilliseconds(request, key, time);
    }

    public void pttl(RedisRequest request) throws IOException {
        request.expectArgumentsCount(1);
        HashKey key = request.getParams()[0].byteArray2hashKey();
        Optional<AbstractValueData<?>> opt = request.getDatabase().get(key);
        Long time = opt.map(e -> {
            long ex = e.getExpire();
            if (ex > 0L) {
                return ex - System.currentTimeMillis();
            }
            return -1L;
        }).orElse(-2L);
        request.getOutputProtocol().writer(time);
    }

    public void randomkey(RedisRequest request) throws IOException {
        request.expectArgumentsCount(0);
        Map<HashKey, AbstractValueData<?>> map = request.getDatabase().getUnmodifiableMap();
        Set<HashKey> ks = map.keySet();
        if (ks.isEmpty()) {
            request.getOutputProtocol().writerNull();
            return;
        }
        int v = (int)(Math.random() * 2.147483647E9) % ks.size();
        Iterator<HashKey> iterator = ks.iterator();
        Bytes val = null;
        for (int i = 0; i < v && iterator.hasNext(); ++i) {
            val = iterator.next();
        }
        request.getOutputProtocol().writer(val == null ? null : val.getBytes());
    }

    public void rename(RedisRequest request) throws IOException {
        request.expectArgumentsCount(2);
        HashKey key = request.getParams()[0].byteArray2hashKey();
        HashKey target = request.getParams()[1].byteArray2hashKey();
        boolean ok = this.rename(request, key, target, true);
        Assert.isTrue(ok, "overwrite not false");
        request.getOutputProtocol().writer(Protocol.Keyword.OK.name());
    }

    public boolean rename(RedisRequest request, HashKey key, HashKey target, boolean overwrite) throws RedisArgumentsException {
        if (key.equals(target)) {
            throw new RedisArgumentsException("key / newkey has same name");
        }
        RedisDatabase db = request.getDatabase();
        return db.sync(() -> {
            Optional<AbstractValueData<?>> remove = db.get(key);
            if (remove.isPresent()) {
                if (overwrite) {
                    db.put(target, remove.get());
                    return true;
                }
                AbstractValueData<?> origin = db.putIfAbsent(target, remove.get());
                return origin == null;
            }
            throw new RedisArgumentsException("not find key");
        });
    }

    public void renamenx(RedisRequest request) throws IOException {
        request.expectArgumentsCount(2);
        HashKey key = request.getParams()[0].byteArray2hashKey();
        HashKey target = request.getParams()[1].byteArray2hashKey();
        boolean ok = this.rename(request, key, target, false);
        request.getOutputProtocol().writer(ok ? 1 : 0);
    }

    public void sort(RedisRequest request) throws IOException {
        request.getOutputProtocol().writerError(RedisOutputProtocol.Level.ERR, "Not support !");
    }

    public void ttl(RedisRequest request) throws IOException {
        request.expectArgumentsCount(1);
        HashKey key = request.getParams()[0].byteArray2hashKey();
        Optional<AbstractValueData<?>> opt = request.getDatabase().get(key);
        Long time = opt.map(e -> {
            long ex = e.getExpire();
            if (ex > 0L) {
                return (ex - System.currentTimeMillis()) / 1000L;
            }
            return -1L;
        }).orElse(-2L);
        request.getOutputProtocol().writer(time.intValue());
    }

    public void type(RedisRequest request) throws IOException {
        request.expectArgumentsCount(1);
        HashKey key = request.getParams()[0].byteArray2hashKey();
        Optional<AbstractValueData<?>> opt = request.getDatabase().get(key);
        String type = opt.map(e -> e.getType()).orElse("none");
        request.getOutputProtocol().writer(type);
    }

    public void scan(RedisRequest request) throws IOException {
        Iterator<HashKey> iterator = request.getDatabase().getUnmodifiableMap().keySet().iterator();
        new ScanIterator<HashKey>(request, 0).skip(iterator).continueWrite(iterator, e -> e.getBytes());
    }

    public static enum Scan {
        MATCH{

            @Override
            public int next(ScanParams params, RequestParams[] args, int i) {
                params.pattern = StringUtil.antPattern(args[i + 1].getByteArray2string());
                return i + 1;
            }
        }
        ,
        COUNT{

            @Override
            public int next(ScanParams params, RequestParams[] args, int i) {
                params.count = args[i + 1].byteArray2int();
                return i + 1;
            }
        };


        public abstract int next(ScanParams var1, RequestParams[] var2, int var3);
    }

    public static class ScanParams {
        private Pattern pattern = Pattern.compile(".*");
        private int count = 10;

        public Pattern getPattern() {
            return this.pattern;
        }

        public void setPattern(Pattern pattern) {
            this.pattern = pattern;
        }

        public int getCount() {
            return this.count;
        }

        public ScanParams setCount(int count) {
            Assert.isTrue(count > 0, "Count > 0");
            this.count = count;
            return this;
        }
    }

    public static enum SortArgument {
        BY(1){

            @Override
            public void parse(Sort sort, String[] args, int position) {
                sort.byPattern = args[position];
            }
        }
        ,
        LIMIT(2){

            @Override
            public void parse(Sort sort, String[] args, int position) {
                sort.offset = Integer.parseInt(args[position]);
                sort.count = Integer.parseInt(args[position + 1]);
            }
        }
        ,
        GET(1){

            @Override
            public void parse(Sort sort, String[] args, int position) {
                sort.getPattern.add(args[position]);
            }
        }
        ,
        ASC{

            @Override
            public void parse(Sort sort, String[] args, int position) {
                sort.order = Order.ASC;
            }
        }
        ,
        DESC{

            @Override
            public void parse(Sort sort, String[] args, int position) {
                sort.order = Order.DESC;
            }
        }
        ,
        ALPHA{

            @Override
            public void parse(Sort sort, String[] args, int position) {
                sort.alpha = true;
            }
        }
        ,
        STORE(1){

            @Override
            public void parse(Sort sort, String[] args, int position) {
                sort.destination = args[position];
            }
        };

        private int count = 0;
        private final List args = new ArrayList();

        private SortArgument() {
            this.count = 0;
        }

        private SortArgument(int count) {
            this.count = count;
        }

        public int getCount() {
            return this.count;
        }

        public abstract void parse(Sort var1, String[] var2, int var3);
    }

    public static class Sort {
        String byPattern;
        int offset;
        int count;
        List<String> getPattern = new ArrayList<String>();
        Order order = Order.ASC;
        boolean alpha = false;
        String destination;

        public static Sort parseString(String[] args, int from, int len) {
            Assert.isTrue(from >= 0, " >= 0");
            Assert.isTrue(len >= 0, " >= 0");
            int max = Math.min(from + len, args.length);
            Sort sort = new Sort();
            for (int i = from; i < max; ++i) {
                String key = args[i];
                SortArgument of = SortArgument.valueOf(key.toUpperCase());
                of.parse(sort, args, i);
                i += of.getCount();
            }
            return sort;
        }
    }

    public static enum Order {
        ASC,
        DESC;

    }
}

