/*
 * Decompiled with CFR 0.152.
 */
package com.github.microwww.redis.protocal;

import com.github.microwww.redis.database.Bytes;
import com.github.microwww.redis.protocal.jedis.JedisOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;

public class RedisOutputProtocol {
    protected final JedisOutputStream out;

    public RedisOutputProtocol(JedisOutputStream out) {
        this.out = out;
    }

    public void writer(String simple) throws IOException {
        this.out.write((byte)43);
        this.out.writeAsciiCrLf(simple);
    }

    public void writerError(Level level, String simple) throws IOException {
        this.out.write((byte)45);
        this.out.writeAsciiCrLf(level.name() + " " + simple);
    }

    public void writer(int val) throws IOException {
        this.out.write((byte)58);
        this.out.writeIntCrLf(val);
    }

    public void writer(long val) throws IOException {
        this.out.write((byte)58);
        this.out.writeAsciiCrLf(val + "");
    }

    public void writerNull() throws IOException {
        this.out.write((byte)36);
        this.out.writeIntCrLf(-1);
    }

    public void writer(Bytes val) throws IOException {
        this.writer(val == null ? null : val.getBytes());
    }

    public void writer(byte[] val) throws IOException {
        this.out.write((byte)36);
        if (val == null) {
            this.out.writeIntCrLf(-1);
        } else {
            this.out.writeIntCrLf(val.length);
            this.out.write(val);
            this.out.writeCrLf();
        }
    }

    public void writerNested(byte[] start, byte[][] args) throws IOException {
        this.out.write((byte)42);
        this.out.writeIntCrLf(2);
        this.out.write((byte)36);
        this.out.writeIntCrLf(start.length);
        this.out.write(start);
        this.out.writeCrLf();
        this.writerMulti(args);
    }

    public void writerMulti(byte[] ... args) throws IOException {
        this.writerComplexData((byte)42, (Object[])args);
    }

    public void sendToSubscribe(Object ... args) throws IOException {
        this.writerComplexData((byte)42, args);
    }

    public void writerComplex(Object ... args) throws IOException {
        this.writerComplexData((byte)42, args);
    }

    protected void writerComplexData(byte prefix, Object[] args) throws IOException {
        if (args == null) {
            this.writerNull();
            return;
        }
        this.out.write(prefix);
        this.out.writeIntCrLf(args.length);
        for (Object arg : args) {
            if (arg == null) {
                this.writerNull();
                continue;
            }
            if (arg instanceof byte[]) {
                byte[] val = (byte[])arg;
                this.writer(val);
                continue;
            }
            if (arg instanceof Bytes) {
                this.writer(((Bytes)arg).getBytes());
                continue;
            }
            if (arg instanceof Number) {
                this.writer(((Number)arg).longValue());
                continue;
            }
            throw new UnsupportedEncodingException("Not support type: " + arg.getClass().getName());
        }
    }

    public void flush() throws IOException {
        this.out.flush();
    }

    public JedisOutputStream getOut() {
        return this.out;
    }

    public static enum Level {
        ERR,
        NOPROTO,
        WARN,
        FAIL;

    }
}

