/*
 * Decompiled with CFR 0.152.
 */
package com.github.microwww.redis.database;

import java.util.BitSet;

public class BitArray {
    private final BitSet data;

    public BitArray(byte[] data) {
        this.data = BitSet.valueOf(data);
    }

    public byte[] toArray() {
        return this.data.toByteArray();
    }

    public int bitLength() {
        return this.data.size();
    }

    public int count(boolean one, int from, int includeTo) {
        int count = 0;
        if (this.bitLength() < 0) {
            return 0;
        }
        int len = this.bitLength();
        while (from < 0) {
            from = len + from;
        }
        if (includeTo < 0) {
            includeTo = len + includeTo;
        }
        for (int i = from; i < len && i <= includeTo; ++i) {
            boolean o = this.get(i);
            if (o != one) continue;
            ++count;
        }
        return count;
    }

    public boolean get(int position) {
        return this.data.get(position);
    }

    public BitArray set(int position) {
        this.data.set(position);
        return this;
    }

    public BitArray clean(int position) {
        this.data.clear(position);
        return this;
    }

    public String toString() {
        return this.data.toString();
    }
}

