/*
 * Decompiled with CFR 0.152.
 */
package com.github.microwww.redis;

import com.github.microwww.redis.ChannelContext;
import com.github.microwww.redis.ChannelSessionHandler;
import com.github.microwww.redis.RequestParams;
import com.github.microwww.redis.SelectSockets;
import com.github.microwww.redis.database.Schema;
import com.github.microwww.redis.logger.LogFactory;
import com.github.microwww.redis.logger.Logger;
import com.github.microwww.redis.protocal.AbstractOperation;
import com.github.microwww.redis.protocal.HalfPackException;
import com.github.microwww.redis.protocal.RedisRequest;
import com.github.microwww.redis.protocal.message.RedisMessage;
import com.github.microwww.redis.protocal.message.Type;
import com.github.microwww.redis.util.Assert;
import com.github.microwww.redis.util.StringUtil;
import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.nio.ByteBuffer;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class RedisServer
implements Closeable {
    public static final Logger log = LogFactory.getLogger(RedisServer.class);
    private final ExecutorService pool;
    private final SelectSockets sockets = new SelectSockets(this::handler);
    private Schema schema;

    public RedisServer() {
        this(5);
    }

    public RedisServer(int max) {
        this(Executors.newFixedThreadPool(max));
        Assert.isTrue(max > 2, "pool > 2");
    }

    public RedisServer(ExecutorService pool) {
        this.pool = pool;
    }

    public void configScheme(int size, AbstractOperation ... operation) {
        Assert.isTrue(this.schema == null, "Server is running, you can not modify it, please invoke it before `getSchema`");
        this.schema = new Schema(size, operation);
    }

    public void listener(String host, int port) throws IOException {
        this.sockets.bind(host, port);
        if (Thread.getDefaultUncaughtExceptionHandler() == null) {
            Thread.setDefaultUncaughtExceptionHandler((t, e) -> log.error("Thread runtime error {}", e));
        }
        ServerSocket ss = this.sockets.getServerSocket();
        InetSocketAddress address = (InetSocketAddress)ss.getLocalSocketAddress();
        log.info("Redis server start @ {}:{}", address.getHostName(), "" + address.getPort());
        this.pool.execute(this.sockets::sync);
    }

    private RedisHandler handler(ChannelContext context) {
        return new RedisHandler();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Schema getSchema() {
        if (this.schema == null) {
            RedisServer redisServer = this;
            synchronized (redisServer) {
                if (this.schema == null) {
                    this.schema = new Schema(16, new AbstractOperation[0]);
                }
            }
        }
        return this.schema;
    }

    public SelectSockets getSockets() {
        return this.sockets;
    }

    @Override
    public void close() throws IOException {
        try {
            this.sockets.close();
        }
        finally {
            try {
                if (this.schema != null) {
                    this.schema.close();
                }
            }
            finally {
                this.pool.shutdown();
            }
        }
    }

    public class RedisHandler
    extends ChannelSessionHandler.Adaptor {
        @Override
        public void readableHandler(ChannelContext context, ByteBuffer buffer) throws IOException {
            if (log.isDebugEnabled()) {
                log.debug("Get a request: {}", context.getRemoteHost());
                StringUtil.loggerBuffer(log, buffer.asReadOnlyBuffer());
            }
            while (buffer.remaining() > 0) {
                int start = buffer.position();
                try {
                    RedisMessage redisMessage = Type.parseOne(buffer);
                    this.readableHandler(context, redisMessage);
                }
                catch (HalfPackException ex) {
                    buffer.position(start);
                    break;
                }
            }
        }

        private void readableHandler(ChannelContext context, RedisMessage message) throws IOException {
            RequestParams[] req = RequestParams.convert(message);
            RedisRequest redisRequest = new RedisRequest(RedisServer.this, context, req);
            log.debug("Ready [{}], request: {}", redisRequest.getCommand(), context.getRemoteHost());
            RedisServer.this.getSchema().execute(redisRequest);
            log.debug("Over  [{}], request: {}", redisRequest.getCommand(), context.getRemoteHost());
        }
    }
}

