/*
 * Decompiled with CFR 0.152.
 */
package com.github.liaochong.myexcel.core;

import com.github.liaochong.myexcel.core.AbstractReadHandler;
import com.github.liaochong.myexcel.core.SaxExcelReader;
import com.github.liaochong.myexcel.core.XSSFSheetXMLHandler;
import java.util.List;
import org.apache.poi.ss.util.CellReference;
import org.apache.poi.xssf.usermodel.XSSFComment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class XSSFSaxReadHandler<T>
extends AbstractReadHandler<T>
implements XSSFSheetXMLHandler.SheetContentsHandler {
    private static final Logger log = LoggerFactory.getLogger(XSSFSaxReadHandler.class);
    private int count;
    private int blankCount;
    private boolean isBlank;

    public XSSFSaxReadHandler(List<T> result, SaxExcelReader.ReadConfig<T> readConfig) {
        super(false, result, readConfig);
    }

    @Override
    public void startRow(int rowNum) {
        this.newRow(rowNum);
        this.isBlank = true;
    }

    @Override
    public void endRow(int rowNum) {
        if (this.isBlank) {
            ++this.blankCount;
            return;
        }
        this.handleResult();
        ++this.count;
    }

    @Override
    public void cell(String cellReference, String formattedValue, XSSFComment comment) {
        this.isBlank = false;
        if (cellReference == null) {
            return;
        }
        short thisCol = new CellReference(cellReference).getCol();
        this.handleField(Integer.valueOf(thisCol), formattedValue);
    }

    @Override
    public void endSheet() {
        log.info("Import completed, total number of rows {},{} blank rows filtered.", (Object)this.count, (Object)this.blankCount);
    }
}

