/*
 * Decompiled with CFR 0.152.
 */
package com.github.liaochong.myexcel.core;

import com.github.liaochong.myexcel.core.AbstractSimpleExcelBuilder;
import com.github.liaochong.myexcel.core.HtmlToExcelStreamFactory;
import com.github.liaochong.myexcel.core.ListSupplier;
import com.github.liaochong.myexcel.core.SimpleStreamExcelBuilder;
import com.github.liaochong.myexcel.core.WorkbookType;
import com.github.liaochong.myexcel.core.container.Pair;
import com.github.liaochong.myexcel.core.parser.ParseConfig;
import com.github.liaochong.myexcel.core.parser.Table;
import com.github.liaochong.myexcel.core.parser.Tr;
import com.github.liaochong.myexcel.core.reflect.ClassFieldContainer;
import com.github.liaochong.myexcel.core.strategy.AutoWidthStrategy;
import com.github.liaochong.myexcel.core.strategy.WidthStrategy;
import com.github.liaochong.myexcel.core.templatehandler.TemplateHandler;
import com.github.liaochong.myexcel.utils.ReflectUtil;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.apache.poi.ss.usermodel.Workbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultStreamExcelBuilder<T>
extends AbstractSimpleExcelBuilder
implements SimpleStreamExcelBuilder<T> {
    private static final Logger log = LoggerFactory.getLogger(DefaultStreamExcelBuilder.class);
    private Class<T> dataType;
    private boolean fixedTitles;
    private ExecutorService executorService;
    private HtmlToExcelStreamFactory htmlToExcelStreamFactory;
    private Workbook workbook;
    private int capacity;
    private Consumer<Path> pathConsumer;
    private volatile boolean cancel;
    private Class<?>[] groups;
    private int waitQueueSize = Runtime.getRuntime().availableProcessors() * 2;
    private TemplateHandler templateHandler;
    private List<CompletableFuture<Void>> asyncAppendFutures = new LinkedList<CompletableFuture<Void>>();

    private DefaultStreamExcelBuilder(Class<T> dataType) {
        this(dataType, null);
    }

    private DefaultStreamExcelBuilder(Class<T> dataType, Workbook workbook) {
        super(false);
        this.dataType = dataType;
        this.workbook = workbook;
        this.configuration.setWidthStrategy(WidthStrategy.NO_AUTO);
        this.isMapBuild = dataType == Map.class;
    }

    public static <T> DefaultStreamExcelBuilder<T> of(@NonNull Class<T> dataType) {
        if (dataType == null) {
            throw new NullPointerException("dataType is marked non-null but is null");
        }
        return new DefaultStreamExcelBuilder<T>(dataType);
    }

    public static <T> DefaultStreamExcelBuilder<T> of(@NonNull Class<T> dataType, @NonNull Workbook workbook) {
        if (dataType == null) {
            throw new NullPointerException("dataType is marked non-null but is null");
        }
        if (workbook == null) {
            throw new NullPointerException("workbook is marked non-null but is null");
        }
        return new DefaultStreamExcelBuilder<T>(dataType, workbook);
    }

    @Deprecated
    public static DefaultStreamExcelBuilder<Map> getInstance() {
        return new DefaultStreamExcelBuilder<Map>(Map.class);
    }

    @Deprecated
    public static DefaultStreamExcelBuilder<Map> getInstance(Workbook workbook) {
        return new DefaultStreamExcelBuilder<Map>(Map.class, workbook);
    }

    public DefaultStreamExcelBuilder<T> titles(@NonNull List<String> titles) {
        if (titles == null) {
            throw new NullPointerException("titles is marked non-null but is null");
        }
        this.titles = titles;
        return this;
    }

    public DefaultStreamExcelBuilder<T> sheetName(@NonNull String sheetName) {
        if (sheetName == null) {
            throw new NullPointerException("sheetName is marked non-null but is null");
        }
        this.configuration.setSheetName(sheetName);
        return this;
    }

    public DefaultStreamExcelBuilder<T> fieldDisplayOrder(@NonNull List<String> fieldDisplayOrder) {
        if (fieldDisplayOrder == null) {
            throw new NullPointerException("fieldDisplayOrder is marked non-null but is null");
        }
        this.fieldDisplayOrder = fieldDisplayOrder;
        return this;
    }

    public DefaultStreamExcelBuilder<T> workbookType(@NonNull WorkbookType workbookType) {
        if (workbookType == null) {
            throw new NullPointerException("workbookType is marked non-null but is null");
        }
        if (this.workbook != null) {
            throw new IllegalArgumentException("Workbook type confirmed, not modifiable");
        }
        this.configuration.setWorkbookType(workbookType);
        return this;
    }

    public DefaultStreamExcelBuilder<T> noStyle() {
        this.styleParser.setNoStyle(true);
        return this;
    }

    public DefaultStreamExcelBuilder<T> widthStrategy(@NonNull WidthStrategy widthStrategy) {
        if (widthStrategy == null) {
            throw new NullPointerException("widthStrategy is marked non-null but is null");
        }
        this.configuration.setWidthStrategy(widthStrategy);
        return this;
    }

    @Deprecated
    public DefaultStreamExcelBuilder<T> autoWidthStrategy(@NonNull AutoWidthStrategy autoWidthStrategy) {
        if (autoWidthStrategy == null) {
            throw new NullPointerException("autoWidthStrategy is marked non-null but is null");
        }
        this.configuration.setWidthStrategy(AutoWidthStrategy.map(autoWidthStrategy));
        return this;
    }

    public DefaultStreamExcelBuilder<T> fixedTitles() {
        this.fixedTitles = true;
        return this;
    }

    public DefaultStreamExcelBuilder<T> widths(int ... widths) {
        for (int i = 0; i < widths.length; ++i) {
            this.customWidthMap.put(i, widths[i]);
        }
        return this;
    }

    public DefaultStreamExcelBuilder<T> width(int columnIndex, int width) {
        this.customWidthMap.put(columnIndex, width);
        return this;
    }

    public DefaultStreamExcelBuilder<T> hideColumns(int ... columnIndexs) {
        for (int columnIndex : columnIndexs) {
            this.width(columnIndex, 0);
        }
        return this;
    }

    @Override
    public DefaultStreamExcelBuilder<T> threadPool(ExecutorService executorService) {
        this.executorService = executorService;
        return this;
    }

    @Override
    public DefaultStreamExcelBuilder<T> hasStyle() {
        this.styleParser.setNoStyle(false);
        return this;
    }

    @Override
    public DefaultStreamExcelBuilder<T> capacity(int capacity) {
        if (capacity < 1) {
            throw new IllegalArgumentException("Capacity must be greater than 0");
        }
        this.capacity = capacity;
        return this;
    }

    @Override
    public DefaultStreamExcelBuilder<T> pathConsumer(Consumer<Path> pathConsumer) {
        this.pathConsumer = pathConsumer;
        return this;
    }

    @Override
    public DefaultStreamExcelBuilder<T> groups(Class<?> ... groups) {
        this.groups = groups;
        return this;
    }

    public DefaultStreamExcelBuilder<T> waitQueueSize(int waitQueueSize) {
        this.waitQueueSize = waitQueueSize;
        return this;
    }

    @Deprecated
    public DefaultStreamExcelBuilder<T> globalStyle(String ... styles) {
        return this.style(styles);
    }

    public DefaultStreamExcelBuilder<T> style(String ... styles) {
        this.styleParser.setNoStyle(false);
        this.configuration.setStyle(Arrays.stream(styles).collect(Collectors.toSet()));
        return this;
    }

    public DefaultStreamExcelBuilder<T> templateHandler(Class<? extends TemplateHandler> templateHandlerClass) {
        this.templateHandler = ReflectUtil.newInstance(templateHandlerClass);
        return this;
    }

    @Override
    public DefaultStreamExcelBuilder<T> start() {
        if (this.isMapBuild) {
            this.parseGlobalStyle();
        } else {
            ClassFieldContainer classFieldContainer = ReflectUtil.getAllFieldsOfClass(this.dataType);
            this.filteredFields = this.getFilteredFields(classFieldContainer, this.groups);
        }
        this.htmlToExcelStreamFactory = new HtmlToExcelStreamFactory(this.waitQueueSize, this.executorService, this.pathConsumer, this.capacity, this.fixedTitles, this.styleParser);
        this.htmlToExcelStreamFactory.widthStrategy(this.configuration.getWidthStrategy());
        if (this.workbook == null) {
            this.htmlToExcelStreamFactory.workbookType(this.configuration.getWorkbookType());
        }
        Table table = this.createTable();
        this.htmlToExcelStreamFactory.start(table, this.workbook);
        List<Tr> head = this.createThead();
        if (head != null) {
            this.htmlToExcelStreamFactory.appendTitles(head);
        }
        return this;
    }

    @Override
    public void append(List<T> dataList) {
        if (this.cancel) {
            log.info("Canceled build task");
            return;
        }
        if (dataList == null || dataList.isEmpty()) {
            return;
        }
        for (T data : dataList) {
            this.append(data);
        }
    }

    @Override
    public void append(T data) {
        if (this.cancel) {
            log.info("Canceled build task");
            return;
        }
        if (data == null) {
            return;
        }
        List<Pair<? extends Class, ?>> contents = this.isMapBuild ? this.assemblingMapContents((Map)data) : this.getRenderContent(data, this.filteredFields);
        Tr tr = this.createTr(contents);
        this.htmlToExcelStreamFactory.append(tr);
    }

    public <E> void append(String templateFilePath, Map<String, E> renderData) {
        this.templateHandler.classpathTemplate(templateFilePath);
        this.doAppend(renderData);
    }

    public <E> void append(String templateDir, String templateFileName, Map<String, E> renderData) {
        this.templateHandler.fileTemplate(templateDir, templateFileName);
        this.doAppend(renderData);
    }

    public void asyncAppend(ListSupplier<T> supplier) {
        CompletableFuture<Void> future = this.executorService == null ? CompletableFuture.runAsync(() -> this.append((T)supplier.getAsList())) : CompletableFuture.runAsync(() -> this.append((T)supplier.getAsList()), this.executorService);
        this.asyncAppendFutures.add(future);
    }

    public void asyncAppend(Supplier<T> supplier) {
        CompletableFuture<Void> future = this.executorService == null ? CompletableFuture.runAsync(() -> this.append(supplier.get())) : CompletableFuture.runAsync(() -> this.append(supplier.get()), this.executorService);
        this.asyncAppendFutures.add(future);
    }

    @Override
    public Workbook build() {
        this.joinAsyncAppendFutures();
        return this.htmlToExcelStreamFactory.build();
    }

    @Override
    public List<Path> buildAsPaths() {
        this.joinAsyncAppendFutures();
        return this.htmlToExcelStreamFactory.buildAsPaths();
    }

    @Override
    public Path buildAsZip(String fileName) {
        this.joinAsyncAppendFutures();
        return this.htmlToExcelStreamFactory.buildAsZip(fileName);
    }

    @Override
    public void close() throws IOException {
        if (this.htmlToExcelStreamFactory != null) {
            this.htmlToExcelStreamFactory.clear();
            this.htmlToExcelStreamFactory = null;
        }
    }

    public void cancel() {
        this.cancel = true;
        this.htmlToExcelStreamFactory.cancel();
    }

    public void clear() {
        this.htmlToExcelStreamFactory.clear();
    }

    private <E> void doAppend(Map<String, E> renderData) {
        List<Table> tables;
        try {
            tables = this.templateHandler.render(renderData, new ParseConfig(this.configuration.getWidthStrategy()));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (tables == null || tables.isEmpty()) {
            return;
        }
        for (Table table : tables) {
            table.getTrList().forEach(this.htmlToExcelStreamFactory::append);
        }
    }

    private void joinAsyncAppendFutures() {
        if (!this.asyncAppendFutures.isEmpty()) {
            this.asyncAppendFutures.forEach(CompletableFuture::join);
        }
    }
}

