/*
 * Decompiled with CFR 0.152.
 */
package com.github.joelittlejohn.embedmongo;

import de.flapdoodle.embed.mongo.distribution.Feature;
import de.flapdoodle.embed.mongo.distribution.IFeatureAwareVersion;
import de.flapdoodle.embed.mongo.distribution.Version;
import de.flapdoodle.embed.mongo.distribution.Versions;
import de.flapdoodle.embed.process.distribution.IVersion;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

public abstract class AbstractEmbeddedMongoMojo
extends AbstractMojo {
    @Parameter(property="embedmongo.skip", defaultValue="false")
    private boolean skip;
    @Parameter(property="embedmongo.port", defaultValue="27017")
    private int port;
    @Parameter(property="embedmongo.randomPort", defaultValue="false")
    private boolean randomPort;
    @Parameter(property="embedmongo.version", defaultValue="2.2.1")
    private String version;
    @Parameter(property="embedmongo.wait", defaultValue="false")
    private boolean wait;
    @Component
    protected MavenProject project;

    public AbstractEmbeddedMongoMojo() {
    }

    AbstractEmbeddedMongoMojo(int port) {
        this.port = port;
    }

    public final void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            this.onSkip();
        } else {
            this.executeStart();
        }
    }

    protected void onSkip() {
    }

    protected IFeatureAwareVersion getVersion() {
        String versionEnumName = this.version.toUpperCase().replaceAll("\\.", "_");
        if (versionEnumName.charAt(0) != 'V') {
            versionEnumName = "V" + versionEnumName;
        }
        try {
            return Version.valueOf((String)versionEnumName);
        }
        catch (IllegalArgumentException e) {
            this.getLog().warn((CharSequence)("Unrecognised MongoDB version '" + this.version + "', this might be a new version that we don't yet know about. Attemping download anyway..."));
            return Versions.withFeatures((IVersion)new IVersion(){

                public String asInDownloadPath() {
                    return AbstractEmbeddedMongoMojo.this.version;
                }
            }, (Feature[])new Feature[0]);
        }
    }

    protected Integer getPort() {
        String portStr = this.project.getProperties().getProperty("embedmongo.port");
        if (StringUtils.isNotBlank((CharSequence)portStr)) {
            return Integer.valueOf(portStr);
        }
        return this.port;
    }

    public abstract void executeStart() throws MojoExecutionException, MojoFailureException;

    protected void savePortToProjectProperties(int port) {
        this.project.getProperties().put("embedmongo.port", String.valueOf(port));
    }

    public boolean isSkip() {
        return this.skip;
    }

    public boolean isRandomPort() {
        return this.randomPort;
    }

    public boolean isWait() {
        return this.wait;
    }

    public MavenProject getProject() {
        return this.project;
    }
}

