/*
 * Decompiled with CFR 0.152.
 */
package git.semver.plugin.changelog;

import git.semver.plugin.changelog.ChangeLogFormatter;
import git.semver.plugin.changelog.ChangeLogTextFormatter;
import git.semver.plugin.changelog.ChangeLogTexts;
import git.semver.plugin.changelog.DocumentBuilder;
import git.semver.plugin.scm.Commit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\fJ\u0010\u0010\u000e\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\fJ\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\f0\u0010J\u0006\u0010\u0011\u001a\u00020\fJ\u0006\u0010\u0012\u001a\u00020\fJ\u0006\u0010\u0013\u001a\u00020\fJ\u0006\u0010\u0014\u001a\u00020\fJ\u0006\u0010\u0015\u001a\u00020\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0017"}, d2={"Lgit/semver/plugin/changelog/ChangeLogTextFormatter;", "Lgit/semver/plugin/changelog/DocumentBuilder;", "commitInfo", "Lgit/semver/plugin/changelog/ChangeLogFormatter$CommitInfo;", "constants", "Lgit/semver/plugin/changelog/ChangeLogTexts;", "(Lgit/semver/plugin/changelog/ChangeLogFormatter$CommitInfo;Lgit/semver/plugin/changelog/ChangeLogTexts;)V", "getCommitInfo", "()Lgit/semver/plugin/changelog/ChangeLogFormatter$CommitInfo;", "getConstants", "()Lgit/semver/plugin/changelog/ChangeLogTexts;", "authorName", "", "format", "authorNameAndEmail", "body", "Lkotlin/sequences/Sequence;", "fullHeader", "hash", "header", "scope", "type", "Companion", "git-semver-plugin"})
@SourceDebugExtension(value={"SMAP\nChangeLogBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChangeLogBuilder.kt\ngit/semver/plugin/changelog/ChangeLogTextFormatter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,216:1\n1557#2:217\n1628#2,3:218\n1557#2:221\n1628#2,3:222\n*S KotlinDebug\n*F\n+ 1 ChangeLogBuilder.kt\ngit/semver/plugin/changelog/ChangeLogTextFormatter\n*L\n189#1:217\n189#1:218,3\n192#1:221\n192#1:222,3\n*E\n"})
public final class ChangeLogTextFormatter
extends DocumentBuilder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ChangeLogFormatter.CommitInfo commitInfo;
    @NotNull
    private final ChangeLogTexts constants;

    public ChangeLogTextFormatter(@NotNull ChangeLogFormatter.CommitInfo commitInfo, @NotNull ChangeLogTexts constants) {
        Intrinsics.checkNotNullParameter((Object)commitInfo, (String)"commitInfo");
        Intrinsics.checkNotNullParameter((Object)constants, (String)"constants");
        this.commitInfo = commitInfo;
        this.constants = constants;
    }

    @NotNull
    public final ChangeLogFormatter.CommitInfo getCommitInfo() {
        return this.commitInfo;
    }

    @NotNull
    public final ChangeLogTexts getConstants() {
        return this.constants;
    }

    @NotNull
    public final String header() {
        return Companion.sanitizeHtml((String)this.constants.getHeaderFormat().invoke((Object)this.commitInfo));
    }

    @NotNull
    public final String fullHeader() {
        return Companion.sanitizeHtml((String)this.constants.getFullHeaderFormat().invoke((Object)this.commitInfo));
    }

    @NotNull
    public final String scope() {
        return (String)this.constants.getScopeFormat().invoke((Object)this.commitInfo);
    }

    @NotNull
    public final String type() {
        return (String)this.constants.getTypeFormat().invoke((Object)this.commitInfo);
    }

    @NotNull
    public final String hash() {
        return (String)this.constants.getHashFormat().invoke((Object)this.commitInfo);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String authorName(@NotNull String format) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        Iterable $this$map$iv = this.commitInfo.getCommits();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Commit commit = (Commit)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = format;
            Object[] objectArray = new Object[]{it.getAuthorName()};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
            collection.add(string2);
        }
        return CollectionsKt.joinToString$default((Iterable)CollectionsKt.distinct((Iterable)((List)destination$iv$iv)), (CharSequence)" ", (CharSequence)"", (CharSequence)"", (int)0, null, null, (int)56, null);
    }

    public static /* synthetic */ String authorName$default(ChangeLogTextFormatter changeLogTextFormatter, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = "%s";
        }
        return changeLogTextFormatter.authorName(string);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String authorNameAndEmail(@NotNull String format) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        Iterable $this$map$iv = this.commitInfo.getCommits();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Commit commit = (Commit)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = format;
            Object[] objectArray = new Object[]{it.getAuthorName(), it.getAuthorEmail()};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
            collection.add(string2);
        }
        return CollectionsKt.joinToString$default((Iterable)CollectionsKt.distinct((Iterable)((List)destination$iv$iv)), (CharSequence)" ", (CharSequence)"", (CharSequence)"", (int)0, null, null, (int)56, null);
    }

    public static /* synthetic */ String authorNameAndEmail$default(ChangeLogTextFormatter changeLogTextFormatter, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = "%s [%s]";
        }
        return changeLogTextFormatter.authorNameAndEmail(string);
    }

    @NotNull
    public final Sequence<String> body() {
        return SequencesKt.takeWhile((Sequence)SequencesKt.dropWhile((Sequence)SequencesKt.drop((Sequence)StringsKt.lineSequence((CharSequence)Companion.sanitizeHtml(this.commitInfo.getText())), (int)1), (Function1)body.1.INSTANCE), (Function1)body.2.INSTANCE);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004\u00a8\u0006\u0006"}, d2={"Lgit/semver/plugin/changelog/ChangeLogTextFormatter$Companion;", "", "()V", "sanitizeHtml", "", "str", "git-semver-plugin"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String sanitizeHtml(@NotNull String str) {
            Intrinsics.checkNotNullParameter((Object)str, (String)"str");
            if (StringsKt.indexOf$default((CharSequence)str, (char)'<', (int)0, (boolean)false, (int)6, null) == -1) {
                return str;
            }
            StringBuilder result = new StringBuilder(str.length());
            int backtickCount = 0;
            int index = 0;
            while (index < str.length()) {
                char token = str.charAt(index);
                if (token == '`') {
                    ++backtickCount;
                } else {
                    if (backtickCount > 0) {
                        int end = StringsKt.indexOf$default((CharSequence)str, (String)StringsKt.repeat((CharSequence)"`", (int)backtickCount), (int)index, (boolean)false, (int)4, null) + backtickCount;
                        if (end > index) {
                            result.append(str, index, end);
                            index = end;
                        }
                        backtickCount = 0;
                        continue;
                    }
                    if (token == '<') {
                        result.append("\\");
                    }
                }
                result.append(token);
                ++index;
            }
            String string = result.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return string;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

