/*
 * Decompiled with CFR 0.152.
 */
package com.king.zxing.util;

import android.app.Activity;
import android.content.Context;
import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import androidx.core.app.ActivityCompat;
import androidx.fragment.app.Fragment;

public class PermissionUtils {
    private PermissionUtils() {
        throw new AssertionError();
    }

    public static boolean checkPermission(@NonNull Context context, @NonNull String permission2) {
        return ActivityCompat.checkSelfPermission((Context)context, (String)permission2) == 0;
    }

    public static void requestPermission(@NonNull Activity activity, @NonNull String permission2, @IntRange(from=0L) int requestCode) {
        PermissionUtils.requestPermissions(activity, new String[]{permission2}, requestCode);
    }

    public static void requestPermission(@NonNull Fragment fragment, @NonNull String permission2, @IntRange(from=0L) int requestCode) {
        PermissionUtils.requestPermissions(fragment, new String[]{permission2}, requestCode);
    }

    public static void requestPermissions(@NonNull Activity activity, @NonNull String[] permissions, @IntRange(from=0L) int requestCode) {
        ActivityCompat.requestPermissions((Activity)activity, (String[])permissions, (int)requestCode);
    }

    public static void requestPermissions(@NonNull Fragment fragment, @NonNull String[] permissions, @IntRange(from=0L) int requestCode) {
        fragment.requestPermissions(permissions, requestCode);
    }

    public static boolean requestPermissionsResult(@NonNull String requestPermission, @NonNull String[] permissions, @NonNull int[] grantResults) {
        int length = permissions.length;
        for (int i = 0; i < length; ++i) {
            if (!requestPermission.equals(permissions[i]) || grantResults[i] != 0) continue;
            return true;
        }
        return false;
    }

    public static boolean requestPermissionsResult(@NonNull String[] requestPermissions, @NonNull String[] permissions, @NonNull int[] grantResults) {
        int length = permissions.length;
        for (int i = 0; i < length; ++i) {
            for (int j = 0; j < requestPermissions.length; ++j) {
                if (!requestPermissions[j].equals(permissions[i]) || grantResults[i] == 0) continue;
                return false;
            }
        }
        return true;
    }
}

