/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.apache.logging.log4j.core.pattern;

import shadow.org.apache.logging.log4j.core.LogEvent;
import shadow.org.apache.logging.log4j.core.config.Configuration;
import shadow.org.apache.logging.log4j.core.config.plugins.Plugin;
import shadow.org.apache.logging.log4j.core.impl.ThrowableProxy;
import shadow.org.apache.logging.log4j.core.pattern.ConverterKeys;
import shadow.org.apache.logging.log4j.core.pattern.ThrowablePatternConverter;

@Plugin(name="ExtendedThrowablePatternConverter", category="Converter")
@ConverterKeys(value={"xEx", "xThrowable", "xException"})
public final class ExtendedThrowablePatternConverter
extends ThrowablePatternConverter {
    private ExtendedThrowablePatternConverter(Configuration config, String[] options) {
        super("ExtendedThrowable", "throwable", options, config);
    }

    public static ExtendedThrowablePatternConverter newInstance(Configuration config, String[] options) {
        return new ExtendedThrowablePatternConverter(config, options);
    }

    @Override
    public void format(LogEvent event, StringBuilder toAppendTo) {
        ThrowableProxy proxy = event.getThrownProxy();
        Throwable throwable = event.getThrown();
        if ((throwable != null || proxy != null) && this.options.anyLines()) {
            if (proxy == null) {
                super.format(event, toAppendTo);
                return;
            }
            String extStackTrace = proxy.getExtendedStackTraceAsString(this.options.getIgnorePackages(), this.options.getTextRenderer(), this.getSuffix(event), this.options.getSeparator());
            int len = toAppendTo.length();
            if (len > 0 && !Character.isWhitespace(toAppendTo.charAt(len - 1))) {
                toAppendTo.append(' ');
            }
            toAppendTo.append(extStackTrace);
        }
    }
}

