/*
 * Decompiled with CFR 0.152.
 */
package com.github.jengelman.gradle.plugins.shadow.tasks;

import com.github.jengelman.gradle.plugins.shadow.ShadowStats;
import com.github.jengelman.gradle.plugins.shadow.internal.DefaultDependencyFilter;
import com.github.jengelman.gradle.plugins.shadow.internal.DependencyFilter;
import com.github.jengelman.gradle.plugins.shadow.internal.GradleVersionUtil;
import com.github.jengelman.gradle.plugins.shadow.internal.ZipCompressor;
import com.github.jengelman.gradle.plugins.shadow.relocation.Relocator;
import com.github.jengelman.gradle.plugins.shadow.relocation.SimpleRelocator;
import com.github.jengelman.gradle.plugins.shadow.tasks.DefaultInheritManifest;
import com.github.jengelman.gradle.plugins.shadow.tasks.InheritManifest;
import com.github.jengelman.gradle.plugins.shadow.tasks.ShadowCopyAction;
import com.github.jengelman.gradle.plugins.shadow.tasks.ShadowSpec;
import com.github.jengelman.gradle.plugins.shadow.transformers.AppendingTransformer;
import com.github.jengelman.gradle.plugins.shadow.transformers.GroovyExtensionModuleTransformer;
import com.github.jengelman.gradle.plugins.shadow.transformers.ServiceFileTransformer;
import com.github.jengelman.gradle.plugins.shadow.transformers.Transformer;
import groovy.lang.MetaClass;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.gradle.api.Action;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.DocumentationRegistry;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.internal.file.copy.CopyAction;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.bundling.Jar;
import org.gradle.api.tasks.util.PatternSet;

public class ShadowJar
extends Jar
implements ShadowSpec {
    private List<Transformer> transformers;
    private List<Relocator> relocators;
    private List<Configuration> configurations;
    private DependencyFilter dependencyFilter;
    private final ShadowStats shadowStats = new ShadowStats();
    private final GradleVersionUtil versionUtil;
    private transient MetaClass metaClass = InvokerHelper.getMetaClass(this.getClass());

    public ShadowJar() {
        this.versionUtil = new GradleVersionUtil(this.getProject().getGradle().getGradleVersion());
        this.dependencyFilter = new DefaultDependencyFilter(this.getProject());
        this.setManifest(new DefaultInheritManifest((FileResolver)this.getServices().get(FileResolver.class)));
        this.transformers = new ArrayList<Transformer>();
        this.relocators = new ArrayList<Relocator>();
        this.configurations = new ArrayList<Configuration>();
    }

    @Override
    @Internal
    public ShadowStats getStats() {
        return this.shadowStats;
    }

    public InheritManifest getManifest() {
        return (InheritManifest)super.getManifest();
    }

    protected CopyAction createCopyAction() {
        DocumentationRegistry documentationRegistry = (DocumentationRegistry)this.getServices().get(DocumentationRegistry.class);
        return new ShadowCopyAction(this.getArchivePath(), this.getInternalCompressor(), documentationRegistry, this.getMetadataCharset(), this.transformers, this.relocators, this.getRootPatternSet(), this.shadowStats, this.versionUtil);
    }

    @Internal
    protected ZipCompressor getInternalCompressor() {
        return this.versionUtil.getInternalCompressor(this.getEntryCompression(), this);
    }

    @TaskAction
    protected void copy() {
        this.from(new Object[]{this.getIncludedDependencies()});
        super.copy();
        this.getLogger().info(this.shadowStats.toString());
    }

    @InputFiles
    public FileCollection getIncludedDependencies() {
        return this.getProject().files(new Object[]{new Callable<FileCollection>(){

            @Override
            public FileCollection call() throws Exception {
                return ShadowJar.this.dependencyFilter.resolve(ShadowJar.this.configurations);
            }
        }});
    }

    @Internal
    protected PatternSet getRootPatternSet() {
        return this.versionUtil.getRootPatternSet(this.getMainSpec());
    }

    @Override
    public ShadowJar dependencies(Action<DependencyFilter> c) {
        if (c != null) {
            c.execute((Object)this.dependencyFilter);
        }
        return this;
    }

    @Override
    public ShadowJar transform(Class<? extends Transformer> clazz) throws InstantiationException, IllegalAccessException {
        return this.transform((Class)clazz, (Action)null);
    }

    @Override
    public <T extends Transformer> ShadowJar transform(Class<T> clazz, Action<T> c) throws InstantiationException, IllegalAccessException {
        Transformer transformer = (Transformer)clazz.newInstance();
        if (c != null) {
            c.execute((Object)transformer);
        }
        this.transformers.add(transformer);
        return this;
    }

    @Override
    public ShadowJar transform(Transformer transformer) {
        this.transformers.add(transformer);
        return this;
    }

    @Override
    public ShadowJar mergeServiceFiles() {
        try {
            this.transform(ServiceFileTransformer.class);
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InstantiationException instantiationException) {
            // empty catch block
        }
        return this;
    }

    @Override
    public ShadowJar mergeServiceFiles(final String rootPath) {
        try {
            this.transform(ServiceFileTransformer.class, (Action)new Action<ServiceFileTransformer>(){

                public void execute(ServiceFileTransformer serviceFileTransformer) {
                    serviceFileTransformer.setPath(rootPath);
                }
            });
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InstantiationException instantiationException) {
            // empty catch block
        }
        return this;
    }

    @Override
    public ShadowJar mergeServiceFiles(Action<ServiceFileTransformer> configureClosure) {
        try {
            this.transform(ServiceFileTransformer.class, (Action)configureClosure);
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InstantiationException instantiationException) {
            // empty catch block
        }
        return this;
    }

    @Override
    public ShadowJar mergeGroovyExtensionModules() {
        try {
            this.transform(GroovyExtensionModuleTransformer.class);
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InstantiationException instantiationException) {
            // empty catch block
        }
        return this;
    }

    @Override
    public ShadowJar append(final String resourcePath) {
        try {
            this.transform(AppendingTransformer.class, (Action)new Action<AppendingTransformer>(){

                public void execute(AppendingTransformer transformer) {
                    transformer.setResource(resourcePath);
                }
            });
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InstantiationException instantiationException) {
            // empty catch block
        }
        return this;
    }

    @Override
    public ShadowJar relocate(String pattern, String destination) {
        return this.relocate(pattern, destination, (Action)null);
    }

    @Override
    public ShadowJar relocate(String pattern, String destination, Action<SimpleRelocator> configure) {
        SimpleRelocator relocator = new SimpleRelocator(pattern, destination, new ArrayList<String>(), new ArrayList<String>());
        if (configure != null) {
            configure.execute((Object)relocator);
        }
        this.relocators.add(relocator);
        return this;
    }

    @Override
    public ShadowJar relocate(Relocator relocator) {
        this.relocators.add(relocator);
        return this;
    }

    @Override
    public ShadowJar relocate(Class<? extends Relocator> relocatorClass) throws InstantiationException, IllegalAccessException {
        return this.relocate(relocatorClass, (Action)null);
    }

    @Override
    public <R extends Relocator> ShadowJar relocate(Class<R> relocatorClass, Action<R> configure) throws InstantiationException, IllegalAccessException {
        Relocator relocator = (Relocator)relocatorClass.newInstance();
        if (configure != null) {
            configure.execute((Object)relocator);
        }
        this.relocators.add(relocator);
        return this;
    }

    @Internal
    public List<Transformer> getTransformers() {
        return this.transformers;
    }

    public void setTransformers(List<Transformer> transformers) {
        this.transformers = transformers;
    }

    @Internal
    public List<Relocator> getRelocators() {
        return this.relocators;
    }

    public void setRelocators(List<Relocator> relocators) {
        this.relocators = relocators;
    }

    @InputFiles
    @Optional
    public List<Configuration> getConfigurations() {
        return this.configurations;
    }

    public void setConfigurations(List<Configuration> configurations) {
        this.configurations = configurations;
    }

    @Internal
    public DependencyFilter getDependencyFilter() {
        return this.dependencyFilter;
    }

    public void setDependencyFilter(DependencyFilter filter) {
        this.dependencyFilter = filter;
    }

    public Object getProperty(String property) {
        return this.getMetaClass().getProperty((Object)this, property);
    }

    public void setProperty(String property, Object newValue) {
        this.getMetaClass().setProperty((Object)this, property, newValue);
    }

    public Object invokeMethod(String name, Object args) {
        return this.getMetaClass().invokeMethod((Object)this, name, args);
    }

    public MetaClass getMetaClass() {
        if (this.metaClass == null) {
            this.metaClass = InvokerHelper.getMetaClass(this.getClass());
        }
        return this.metaClass;
    }

    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }
}

