/*
 * Decompiled with CFR 0.152.
 */
package com.github.gmazzo.buildconfig;

import com.github.gmazzo.buildconfig.BuildConfigType;
import com.github.gmazzo.buildconfig.BuildConfigTypeUtilsKt;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Triple;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KType;
import kotlin.reflect.KTypeProjection;
import kotlin.reflect.jvm.ReflectJvmMapping;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000V\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010*\n\u0002\u0010\f\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\tH\u0000\u001a\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\bH\u0000\u001a\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0015H\u0000\u001a&\u0010\u0016\u001a\u00020\u00122\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\u000e\u0010\u001a\u001a\n\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u001bH\u0002\u001a\u0017\u0010\u001c\u001a\u0006\u0012\u0002\b\u00030\u001d*\u0004\u0018\u00010\u0004H\u0000\u00a2\u0006\u0002\u0010\u001e\u001a\u001e\u0010\u001f\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u000f0 *\u00020\bH\u0001\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\"\u0010\u0002\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0003*\u0004\u0018\u00010\u00048@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\"\u001e\u0010\u0007\u001a\u00020\b*\u00020\t8BX\u0082\u0004\u00a2\u0006\f\u0012\u0004\b\n\u0010\u000b\u001a\u0004\b\f\u0010\r\"\u0018\u0010\u000e\u001a\u00020\u000f*\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u0010\u00a8\u0006!"}, d2={"regEx", "Lkotlin/text/Regex;", "elements", "", "", "getElements", "(Ljava/lang/Object;)Ljava/util/List;", "genericName", "", "Ljava/lang/reflect/Type;", "getGenericName$annotations", "(Ljava/lang/reflect/Type;)V", "getGenericName", "(Ljava/lang/reflect/Type;)Ljava/lang/String;", "isArray", "", "(Ljava/lang/reflect/Type;)Z", "nameOf", "Lcom/github/gmazzo/buildconfig/BuildConfigType;", "type", "className", "Lkotlin/reflect/KType;", "parseName", "iterator", "", "", "parentParameters", "", "asVarArg", "", "(Ljava/lang/Object;)[Ljava/lang/Object;", "parseTypename", "Lkotlin/Triple;", "plugin"})
@SourceDebugExtension(value={"SMAP\nBuildConfigTypeUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BuildConfigTypeUtils.kt\ncom/github/gmazzo/buildconfig/BuildConfigTypeUtilsKt\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,165:1\n11065#2:166\n11400#2,3:167\n11065#2:170\n11400#2,3:171\n11065#2:174\n11400#2,3:175\n1#3:178\n1549#4:179\n1620#4,3:180\n37#5,2:183\n37#5,2:185\n37#5,2:187\n*S KotlinDebug\n*F\n+ 1 BuildConfigTypeUtils.kt\ncom/github/gmazzo/buildconfig/BuildConfigTypeUtilsKt\n*L\n54#1:166\n54#1:167,3\n65#1:170\n65#1:171,3\n74#1:174\n74#1:175,3\n88#1:179\n88#1:180,3\n160#1:183,2\n161#1:185,2\n162#1:187,2\n*E\n"})
public final class BuildConfigTypeUtilsKt {
    @NotNull
    private static final Regex regEx = new Regex("([^\\[\\]?]+?)(\\?)?(\\[])?");

    @VisibleForTesting
    @NotNull
    public static final Triple<String, Boolean, Boolean> parseTypename(@NotNull String $this$parseTypename) {
        Intrinsics.checkNotNullParameter((Object)$this$parseTypename, (String)"<this>");
        MatchResult match = regEx.matchEntire((CharSequence)$this$parseTypename);
        if (match == null) {
            boolean bl = false;
            String string = "Class name must be of one of these formats: 'ClassName', 'ClassName?', 'ClassName[]' or 'ClassName?[]'";
            throw new IllegalStateException(string.toString());
        }
        MatchResult.Destructured destructured = match.getDestructured();
        String type = (String)destructured.getMatch().getGroupValues().get(1);
        String nullable = (String)destructured.getMatch().getGroupValues().get(2);
        String array = (String)destructured.getMatch().getGroupValues().get(3);
        return new Triple((Object)type, (Object)(((CharSequence)nullable).length() > 0 ? 1 : 0), (Object)(((CharSequence)array).length() > 0 ? 1 : 0));
    }

    private static final String getGenericName(Type $this$genericName) {
        String string;
        Type type = $this$genericName;
        if ((Intrinsics.areEqual((Object)type, Boolean.TYPE) ? true : Intrinsics.areEqual((Object)type, Boolean.class)) ? true : Intrinsics.areEqual((Object)type, boolean[].class)) {
            string = "Boolean";
        } else if ((Intrinsics.areEqual((Object)type, Byte.TYPE) ? true : Intrinsics.areEqual((Object)type, Byte.class)) ? true : Intrinsics.areEqual((Object)type, byte[].class)) {
            string = "Byte";
        } else if ((Intrinsics.areEqual((Object)type, Short.TYPE) ? true : Intrinsics.areEqual((Object)type, Short.class)) ? true : Intrinsics.areEqual((Object)type, short[].class)) {
            string = "Short";
        } else if ((Intrinsics.areEqual((Object)type, Character.TYPE) ? true : Intrinsics.areEqual((Object)type, Character.class)) ? true : Intrinsics.areEqual((Object)type, char[].class)) {
            string = "Char";
        } else if ((Intrinsics.areEqual((Object)type, Integer.TYPE) ? true : Intrinsics.areEqual((Object)type, Integer.class)) ? true : Intrinsics.areEqual((Object)type, int[].class)) {
            string = "Int";
        } else if ((Intrinsics.areEqual((Object)type, Long.TYPE) ? true : Intrinsics.areEqual((Object)type, Long.class)) ? true : Intrinsics.areEqual((Object)type, long[].class)) {
            string = "Long";
        } else if ((Intrinsics.areEqual((Object)type, Float.TYPE) ? true : Intrinsics.areEqual((Object)type, Float.class)) ? true : Intrinsics.areEqual((Object)type, float[].class)) {
            string = "Float";
        } else if ((Intrinsics.areEqual((Object)type, Double.TYPE) ? true : Intrinsics.areEqual((Object)type, Double.class)) ? true : Intrinsics.areEqual((Object)type, double[].class)) {
            string = "Double";
        } else if (Intrinsics.areEqual((Object)type, String.class)) {
            string = "String";
        } else if (Intrinsics.areEqual((Object)type, List.class)) {
            string = "List";
        } else if (Intrinsics.areEqual((Object)type, Set.class)) {
            string = "Set";
        } else if (type instanceof GenericArrayType) {
            Type type2 = ((GenericArrayType)$this$genericName).getGenericComponentType();
            Intrinsics.checkNotNullExpressionValue((Object)type2, (String)"getGenericComponentType(...)");
            string = BuildConfigTypeUtilsKt.getGenericName(type2);
        } else if (type instanceof ParameterizedType) {
            Type type3 = ((ParameterizedType)$this$genericName).getRawType();
            Intrinsics.checkNotNullExpressionValue((Object)type3, (String)"getRawType(...)");
            string = BuildConfigTypeUtilsKt.getGenericName(type3);
        } else if (type instanceof Class) {
            String string2;
            if (((Class)$this$genericName).isArray()) {
                Class<?> clazz = ((Class)$this$genericName).getComponentType();
                Intrinsics.checkNotNullExpressionValue(clazz, (String)"getComponentType(...)");
                string2 = BuildConfigTypeUtilsKt.getGenericName(clazz);
            } else {
                string2 = ((Class)$this$genericName).getName();
            }
            String string3 = string2;
            Intrinsics.checkNotNull((Object)string3);
            string = string3;
        } else {
            throw new IllegalStateException(("Unsupported type: " + $this$genericName).toString());
        }
        return string;
    }

    private static /* synthetic */ void getGenericName$annotations(Type type) {
    }

    private static final boolean isArray(Type $this$isArray) {
        Type type = $this$isArray;
        return type instanceof Class ? ((Class)$this$isArray).isArray() : type instanceof GenericArrayType;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final BuildConfigType nameOf(@NotNull Type type) {
        BuildConfigType buildConfigType;
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Type type2 = type;
        if (type2 instanceof Class) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            String string = BuildConfigTypeUtilsKt.getGenericName(type);
            TypeVariable<Class<T>>[] typeVariableArray = ((Class)type).getTypeParameters();
            Intrinsics.checkNotNullExpressionValue(typeVariableArray, (String)"getTypeParameters(...)");
            Object[] objectArray = typeVariableArray;
            String string2 = string;
            boolean $i$f$map = false;
            void var4_13 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
            boolean $i$f$mapTo = false;
            for (void item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                TypeVariable typeVariable = (TypeVariable)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Type[] typeArray = it.getBounds();
                Intrinsics.checkNotNullExpressionValue((Object)typeArray, (String)"getBounds(...)");
                Object object = ArraysKt.singleOrNull((Object[])typeArray);
                if (object == null) {
                    boolean bl2 = false;
                    String string3 = "Types with complex parameters bounds are not supported: " + type;
                    throw new IllegalStateException(string3.toString());
                }
                collection.add(BuildConfigTypeUtilsKt.nameOf((Type)object));
            }
            boolean bl = ((Class)type).isArray();
            boolean bl3 = false;
            List list = (List)destination$iv$iv;
            String string4 = string2;
            buildConfigType = new BuildConfigType(string4, list, bl3, bl);
        } else if (type2 instanceof ParameterizedType) {
            Type type3 = ((ParameterizedType)type).getRawType();
            Intrinsics.checkNotNullExpressionValue((Object)type3, (String)"getRawType(...)");
            String string = BuildConfigTypeUtilsKt.getGenericName(type3);
            Type[] typeArray = ((ParameterizedType)type).getActualTypeArguments();
            Intrinsics.checkNotNullExpressionValue((Object)typeArray, (String)"getActualTypeArguments(...)");
            Object[] $this$map$iv = typeArray;
            String string5 = string;
            boolean $i$f$map = false;
            Object[] $this$mapTo$iv$iv = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.length);
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                Type it = (Type)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it);
                collection.add(BuildConfigTypeUtilsKt.nameOf(it));
            }
            boolean bl = false;
            boolean bl4 = false;
            List list = (List)destination$iv$iv;
            String string6 = string5;
            buildConfigType = new BuildConfigType(string6, list, bl4, bl);
        } else if (type2 instanceof GenericArrayType) {
            void $this$mapTo$iv$iv;
            Type type4 = ((GenericArrayType)type).getGenericComponentType();
            Intrinsics.checkNotNullExpressionValue((Object)type4, (String)"getGenericComponentType(...)");
            String string = BuildConfigTypeUtilsKt.getGenericName(type4);
            Type $i$f$map = ((GenericArrayType)type).getGenericComponentType();
            ParameterizedType parameterizedType = $i$f$map instanceof ParameterizedType ? (ParameterizedType)$i$f$map : null;
            if (parameterizedType == null) {
                String string7 = string;
                boolean $i$a$-checkNotNull-BuildConfigTypeUtilsKt$nameOf$42 = false;
                String string8 = string7;
                String $i$a$-checkNotNull-BuildConfigTypeUtilsKt$nameOf$42 = "Unsupported type: " + type;
                throw new IllegalStateException($i$a$-checkNotNull-BuildConfigTypeUtilsKt$nameOf$42.toString());
            }
            Object[] $this$map$iv = parameterizedType.getActualTypeArguments();
            Intrinsics.checkNotNullExpressionValue((Object)$this$map$iv, (String)"getActualTypeArguments(...)");
            $this$map$iv = $this$map$iv;
            String string9 = string;
            boolean $i$f$map2 = false;
            Object[] $i$a$-checkNotNull-BuildConfigTypeUtilsKt$nameOf$42 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.length);
            boolean $i$f$mapTo = false;
            for (void item$iv$iv : $this$mapTo$iv$iv) {
                Type it = (Type)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it);
                collection.add(BuildConfigTypeUtilsKt.nameOf(it));
            }
            boolean bl = true;
            boolean bl5 = false;
            List list = (List)destination$iv$iv;
            String string10 = string9;
            buildConfigType = new BuildConfigType(string10, list, bl5, bl);
        } else {
            throw new IllegalStateException(("Unsupported type: " + type).toString());
        }
        return buildConfigType;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final BuildConfigType nameOf(@NotNull KType type) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        KType kType;
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        boolean isArray = BuildConfigTypeUtilsKt.isArray(ReflectJvmMapping.getJavaType((KType)type));
        KType it = kType = type;
        boolean bl = false;
        Object object = isArray ? kType : null;
        if (object == null || (object = object.getArguments()) == null || (object = (KTypeProjection)CollectionsKt.singleOrNull((List)object)) == null || (object = object.getType()) == null) {
            object = type;
        }
        Object targetType = object;
        Iterable iterable = targetType.getArguments();
        String string = BuildConfigTypeUtilsKt.getGenericName(ReflectJvmMapping.getJavaType((KType)type));
        boolean $i$f$map = false;
        it = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Object object2;
            Collection collection;
            block6: {
                block5: {
                    void it2;
                    KTypeProjection kTypeProjection = (KTypeProjection)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl2 = false;
                    object2 = it2.getType();
                    if (object2 == null) break block5;
                    KType p0 = object2;
                    boolean bl3 = false;
                    BuildConfigType buildConfigType = BuildConfigTypeUtilsKt.nameOf(p0);
                    object2 = buildConfigType;
                    if (buildConfigType != null) break block6;
                }
                object2 = BuildConfigTypeUtilsKt.nameOf("*");
            }
            collection.add(object2);
        }
        boolean bl4 = isArray;
        boolean bl5 = targetType.isMarkedNullable();
        List list = (List)destination$iv$iv;
        String string2 = string;
        return new BuildConfigType(string2, list, bl5, bl4);
    }

    @NotNull
    public static final BuildConfigType nameOf(@NotNull String className) {
        Intrinsics.checkNotNullParameter((Object)className, (String)"className");
        ListIterator<Character> iterator2 = StringsKt.toList((CharSequence)className).listIterator();
        BuildConfigType nameRef = BuildConfigTypeUtilsKt.parseName(iterator2, null);
        if (!(!iterator2.hasNext())) {
            boolean bl = false;
            String string = "Failed to parse '" + className + "', input remaining: " + SequencesKt.joinToString$default((Sequence)SequencesKt.asSequence((Iterator)iterator2), (CharSequence)"", null, null, (int)0, null, null, (int)62, null);
            throw new IllegalStateException(string.toString());
        }
        return nameRef;
    }

    private static final BuildConfigType parseName(ListIterator<Character> iterator2, List<BuildConfigType> parentParameters) {
        Triple<String, Boolean, Boolean> triple;
        List parameters = new ArrayList();
        Triple<String, Boolean, Boolean> $this$parseName_u24lambda_u249 = triple = new Triple<String, Boolean, Boolean>();
        boolean bl = false;
        while (iterator2.hasNext()) {
            char ch = iterator2.next().charValue();
            if (ch == ' ') continue;
            if (ch == '<') {
                parameters.add(0, BuildConfigTypeUtilsKt.parseName(iterator2, parameters));
                continue;
            }
            if (ch == ',') {
                List<BuildConfigType> list = parentParameters;
                Intrinsics.checkNotNull(list);
                list.add(0, BuildConfigTypeUtilsKt.parseName(iterator2, parentParameters));
                iterator2.previous();
                continue;
            }
            if (ch == '>') break;
            $this$parseName_u24lambda_u249.append(ch);
        }
        String string = triple.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String name = string;
        triple = BuildConfigTypeUtilsKt.parseTypename(name);
        String typeName = (String)triple.component1();
        boolean nullable = (Boolean)triple.component2();
        boolean array = (Boolean)triple.component3();
        return new BuildConfigType(typeName, parameters, nullable, array);
    }

    @NotNull
    public static final List<Object> getElements(@Nullable Object $this$elements) {
        Object object = $this$elements;
        return object == null ? CollectionsKt.listOf(null) : (object instanceof Object[] ? ArraysKt.toList((Object[])((Object[])$this$elements)) : (object instanceof byte[] ? ArraysKt.toList((byte[])((byte[])$this$elements)) : (object instanceof short[] ? ArraysKt.toList((short[])((short[])$this$elements)) : (object instanceof char[] ? ArraysKt.toList((char[])((char[])$this$elements)) : (object instanceof int[] ? ArraysKt.toList((int[])((int[])$this$elements)) : (object instanceof long[] ? ArraysKt.toList((long[])((long[])$this$elements)) : (object instanceof float[] ? ArraysKt.toList((float[])((float[])$this$elements)) : (object instanceof double[] ? ArraysKt.toList((double[])((double[])$this$elements)) : (object instanceof boolean[] ? ArraysKt.toList((boolean[])((boolean[])$this$elements)) : (object instanceof Collection ? CollectionsKt.toList((Iterable)((Iterable)$this$elements)) : (object instanceof Map ? CollectionsKt.toList((Iterable)((Map)$this$elements).entrySet()) : CollectionsKt.listOf((Object)$this$elements))))))))))));
    }

    @NotNull
    public static final Object[] asVarArg(@Nullable Object $this$asVarArg) {
        Object[] objectArray;
        Object object = $this$asVarArg;
        if (object instanceof Object[]) {
            objectArray = (Object[])$this$asVarArg;
        } else if (object instanceof byte[]) {
            objectArray = ArraysKt.toTypedArray((byte[])((byte[])$this$asVarArg));
        } else if (object instanceof short[]) {
            objectArray = ArraysKt.toTypedArray((short[])((short[])$this$asVarArg));
        } else if (object instanceof char[]) {
            objectArray = ArraysKt.toTypedArray((char[])((char[])$this$asVarArg));
        } else if (object instanceof int[]) {
            objectArray = ArraysKt.toTypedArray((int[])((int[])$this$asVarArg));
        } else if (object instanceof long[]) {
            objectArray = ArraysKt.toTypedArray((long[])((long[])$this$asVarArg));
        } else if (object instanceof float[]) {
            objectArray = ArraysKt.toTypedArray((float[])((float[])$this$asVarArg));
        } else if (object instanceof double[]) {
            objectArray = ArraysKt.toTypedArray((double[])((double[])$this$asVarArg));
        } else if (object instanceof boolean[]) {
            objectArray = ArraysKt.toTypedArray((boolean[])((boolean[])$this$asVarArg));
        } else if (object instanceof List) {
            Collection $this$toTypedArray$iv = (Collection)$this$asVarArg;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            objectArray = thisCollection$iv.toArray(new Object[0]);
        } else if (object instanceof Iterable) {
            Collection $this$toTypedArray$iv = CollectionsKt.toList((Iterable)((Iterable)$this$asVarArg));
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            objectArray = thisCollection$iv.toArray(new Object[0]);
        } else if (object instanceof Map) {
            Collection $this$toTypedArray$iv = SequencesKt.toList((Sequence)SequencesKt.flatMap((Sequence)CollectionsKt.asSequence((Iterable)((Map)$this$asVarArg).entrySet()), (Function1)asVarArg.1.INSTANCE));
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            objectArray = thisCollection$iv.toArray(new Object[0]);
        } else {
            Object[] objectArray2 = new Object[]{$this$asVarArg};
            objectArray = objectArray2;
        }
        return objectArray;
    }
}

