/*
 * Decompiled with CFR 0.152.
 */
package com.github.gmazzo.buildconfig;

import com.github.gmazzo.buildconfig.BuildConfigClassSpec;
import com.github.gmazzo.buildconfig.BuildConfigTask;
import com.github.gmazzo.buildconfig.generators.BuildConfigGenerator;
import com.github.gmazzo.buildconfig.generators.BuildConfigGeneratorSpec;
import java.io.File;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.gradle.api.DefaultTask;
import org.gradle.api.Task;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.SetProperty;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.NotNull;

@CacheableTask
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\b'\u0018\u00002\u00020\u0001:\u0001\u0013B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0011\u001a\u00020\u0012H\u0007R\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\t8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0014"}, d2={"Lcom/github/gmazzo/buildconfig/BuildConfigTask;", "Lorg/gradle/api/DefaultTask;", "()V", "generator", "Lorg/gradle/api/provider/Property;", "Lcom/github/gmazzo/buildconfig/generators/BuildConfigGenerator;", "getGenerator", "()Lorg/gradle/api/provider/Property;", "outputDir", "Lorg/gradle/api/file/DirectoryProperty;", "getOutputDir", "()Lorg/gradle/api/file/DirectoryProperty;", "specs", "Lorg/gradle/api/provider/SetProperty;", "Lcom/github/gmazzo/buildconfig/BuildConfigClassSpec;", "getSpecs", "()Lorg/gradle/api/provider/SetProperty;", "generateBuildConfigFile", "", "HasFields", "plugin"})
@SourceDebugExtension(value={"SMAP\nBuildConfigTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BuildConfigTask.kt\ncom/github/gmazzo/buildconfig/BuildConfigTask\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,82:1\n1313#2:83\n1314#2:85\n1#3:84\n*S KotlinDebug\n*F\n+ 1 BuildConfigTask.kt\ncom/github/gmazzo/buildconfig/BuildConfigTask\n*L\n48#1:83\n48#1:85\n*E\n"})
public abstract class BuildConfigTask
extends DefaultTask {
    public BuildConfigTask() {
        if (GradleVersion.current().compareTo(GradleVersion.version((String)"7.6")) >= 0) {
            this.onlyIf("There are build config fields to generate", HasFields.INSTANCE);
        } else {
            this.onlyIf(HasFields.INSTANCE);
        }
    }

    @Nested
    @NotNull
    public abstract SetProperty<BuildConfigClassSpec> getSpecs();

    @Nested
    @NotNull
    public abstract Property<BuildConfigGenerator> getGenerator();

    @OutputDirectory
    @NotNull
    public abstract DirectoryProperty getOutputDir();

    /*
     * WARNING - void declaration
     */
    @TaskAction
    public final void generateBuildConfigFile() {
        File dir = ((Directory)this.getOutputDir().get()).getAsFile();
        Intrinsics.checkNotNull((Object)dir);
        FilesKt.deleteRecursively((File)dir);
        BuildConfigGenerator generator = (BuildConfigGenerator)this.getGenerator().get();
        Object object = this.getSpecs().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        Sequence $this$forEach$iv = SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)((Iterable)object)), (Function1)generateBuildConfigFile.1.INSTANCE);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void p0;
            File file;
            Pair pair;
            BuildConfigClassSpec it = (BuildConfigClassSpec)element$iv;
            boolean bl = false;
            String rawClassName = (String)it.getClassName().get();
            String rawPackage = (String)it.getPackageName().getOrNull();
            if (rawPackage == null) {
                Intrinsics.checkNotNull((Object)rawClassName);
                int i2 = StringsKt.lastIndexOf$default((CharSequence)rawClassName, (char)'.', (int)0, (boolean)false, (int)6, null);
                if (i2 == -1) {
                    pair = TuplesKt.to((Object)"", (Object)rawClassName);
                } else {
                    String string = rawClassName.substring(0, i2);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                    String string2 = rawClassName.substring(i2 + 1);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                    pair = TuplesKt.to((Object)string, (Object)string2);
                }
            } else {
                pair = TuplesKt.to((Object)rawPackage, (Object)rawClassName);
            }
            Pair pair2 = pair;
            String packageName = (String)pair2.component1();
            String className = (String)pair2.component2();
            Intrinsics.checkNotNull((Object)className);
            File file2 = file = dir;
            Collection collection = CollectionsKt.sortedWith((Iterable)((Iterable)it.getBuildConfigFields()), (arg_0, arg_1) -> BuildConfigTask.generateBuildConfigFile$lambda$1$lambda$0(generateBuildConfigFile.2.1.INSTANCE, arg_0, arg_1));
            String string = (String)it.getDocumentation().getOrNull();
            String string3 = packageName;
            String string4 = className;
            BuildConfigGenerator buildConfigGenerator = generator;
            boolean bl2 = false;
            p0.mkdirs();
            Unit unit = Unit.INSTANCE;
            File file3 = file;
            Collection collection2 = collection;
            String string5 = string;
            String string6 = string3;
            String string7 = string4;
            buildConfigGenerator.execute(new BuildConfigGeneratorSpec(string7, string6, string5, collection2, file3));
        }
    }

    private static final int generateBuildConfigFile$lambda$1$lambda$0(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return ((Number)$tmp0.invoke(p0, p1)).intValue();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/github/gmazzo/buildconfig/BuildConfigTask$HasFields;", "Lorg/gradle/api/specs/Spec;", "Lorg/gradle/api/Task;", "()V", "isSatisfiedBy", "", "task", "plugin"})
    @SourceDebugExtension(value={"SMAP\nBuildConfigTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BuildConfigTask.kt\ncom/github/gmazzo/buildconfig/BuildConfigTask$HasFields\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,82:1\n1747#2,3:83\n*S KotlinDebug\n*F\n+ 1 BuildConfigTask.kt\ncom/github/gmazzo/buildconfig/BuildConfigTask$HasFields\n*L\n78#1:83,3\n*E\n"})
    private static final class HasFields
    implements Spec<Task> {
        @NotNull
        public static final HasFields INSTANCE = new HasFields();

        private HasFields() {
        }

        public boolean isSatisfiedBy(@NotNull Task task) {
            boolean bl;
            block3: {
                Intrinsics.checkNotNullParameter((Object)task, (String)"task");
                Object object = ((BuildConfigTask)task).getSpecs().get();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
                Iterable $this$any$iv = (Iterable)object;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        BuildConfigClassSpec fields = (BuildConfigClassSpec)element$iv;
                        boolean bl2 = false;
                        boolean bl3 = !((Collection)fields.getBuildConfigFields()).isEmpty();
                        if (!bl3) continue;
                        bl = true;
                        break block3;
                    }
                    bl = false;
                }
            }
            return bl;
        }
    }
}

