/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.github.fakemongo.Fongo;
import com.github.fakemongo.impl.Aggregator;
import com.github.fakemongo.impl.ExpressionParser;
import com.github.fakemongo.impl.geo.GeoUtil;
import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.CommandResult;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBEncoder;
import com.mongodb.DBObject;
import com.mongodb.DuplicateKeyException;
import com.mongodb.FongoDBCollection;
import com.mongodb.MapReduceCommand;
import com.mongodb.MapReduceOutput;
import com.mongodb.Mongo;
import com.mongodb.MongoException;
import com.mongodb.ReadConcern;
import com.mongodb.ReadPreference;
import com.mongodb.WriteConcern;
import com.mongodb.WriteConcernException;
import com.mongodb.WriteConcernResult;
import com.vividsolutions.jts.geom.Coordinate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.bson.BsonBoolean;
import org.bson.BsonDocument;
import org.bson.BsonDouble;
import org.bson.BsonInt32;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FongoDB
extends DB {
    private static final Logger LOG = LoggerFactory.getLogger(FongoDB.class);
    public static final String SYSTEM_NAMESPACES = "system.namespaces";
    private final Map<String, FongoDBCollection> collMap = new ConcurrentHashMap<String, FongoDBCollection>();
    private final Set<String> namespaceDeclarated = Collections.synchronizedSet(new LinkedHashSet());
    final Fongo fongo;

    public FongoDB(Fongo fongo, String name) {
        super((Mongo)fongo.getMongo(), name);
        this.fongo = fongo;
        this.doGetCollection("system.users");
        this.doGetCollection("system.indexes");
        this.doGetCollection(SYSTEM_NAMESPACES);
    }

    public synchronized DBCollection createCollection(String collectionName, DBObject options) {
        if (options.get("size") != null && !(options.get("size") instanceof Number)) {
            throw new IllegalArgumentException("'size' should be Number");
        }
        if (options.get("max") != null && !(options.get("max") instanceof Number)) {
            throw new IllegalArgumentException("'max' should be Number");
        }
        if (options.get("capped") != null && !(options.get("capped") instanceof Boolean)) {
            throw new IllegalArgumentException("'capped' should be Boolean");
        }
        if (options.get("autoIndexId") != null && !(options.get("capped") instanceof Boolean)) {
            throw new IllegalArgumentException("'capped' should be Boolean");
        }
        if (options.get("storageEngine") != null && !(options.get("storageEngine") instanceof DBObject)) {
            throw new IllegalArgumentException("storageEngine' should be DBObject");
        }
        if (this.collMap.containsKey(collectionName)) {
            this.notOkErrorResult("collection already exists").throwOnError();
        }
        FongoDBCollection collection = this.getCollection(collectionName);
        this.addCollection(collection);
        return collection;
    }

    public FongoDBCollection getCollection(String name) {
        return this.doGetCollection(name);
    }

    protected synchronized FongoDBCollection doGetCollection(String name) {
        return this.doGetCollection(name, false);
    }

    public synchronized FongoDBCollection doGetCollection(String name, boolean idIsNotUniq) {
        FongoDBCollection coll = this.collMap.get(name);
        if (coll == null) {
            coll = new FongoDBCollection(this, name, idIsNotUniq);
            this.collMap.put(name, coll);
        }
        return coll;
    }

    private DBObject findAndModify(String collection, DBObject query, DBObject sort, boolean remove, DBObject update, boolean returnNew, DBObject fields, boolean upsert) {
        FongoDBCollection coll = this.doGetCollection(collection);
        return coll.findAndModify(query, fields, sort, remove, update, returnNew, upsert);
    }

    private List<DBObject> doAggregateCollection(String collection, List<DBObject> pipeline) {
        FongoDBCollection coll = this.doGetCollection(collection);
        Aggregator aggregator = new Aggregator(this, coll, pipeline);
        return aggregator.computeResult();
    }

    private MapReduceOutput doMapReduce(String collection, String map, String reduce, String finalize, Map<String, Object> scope, DBObject out, DBObject query, DBObject sort, Number limit) {
        FongoDBCollection coll = this.doGetCollection(collection);
        MapReduceCommand mapReduceCommand = new MapReduceCommand((DBCollection)coll, map, reduce, null, null, query);
        mapReduceCommand.setSort(sort);
        if (limit != null) {
            mapReduceCommand.setLimit(limit.intValue());
        }
        mapReduceCommand.setFinalize(finalize);
        mapReduceCommand.setOutputDB((String)out.get("db"));
        mapReduceCommand.setScope(scope);
        return coll.mapReduce(mapReduceCommand);
    }

    private List<DBObject> doGeoNearCollection(String collection, Coordinate near, DBObject query, Number limit, Number maxDistance, boolean spherical) {
        FongoDBCollection coll = this.doGetCollection(collection);
        return coll.geoNear(near, query, limit, maxDistance, spherical);
    }

    private DBObject doTextSearchInCollection(String collection, String search, Integer limit, DBObject project) {
        FongoDBCollection coll = this.doGetCollection(collection);
        return coll.text(search, limit, project);
    }

    public DB getSisterDB(String name) {
        return this.fongo.getDB(name);
    }

    public WriteConcern getWriteConcern() {
        return this.fongo.getWriteConcern();
    }

    public ReadConcern getReadConcern() {
        return this.fongo.getReadConcern();
    }

    public ReadPreference getReadPreference() {
        return ReadPreference.primaryPreferred();
    }

    public synchronized void dropDatabase() throws MongoException {
        this.fongo.dropDatabase(this.getName());
        for (FongoDBCollection c : new ArrayList<FongoDBCollection>(this.collMap.values())) {
            c.drop();
        }
    }

    public CommandResult command(DBObject cmd, ReadPreference readPreference, DBEncoder encoder) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Fongo got command " + cmd);
        }
        if (cmd.containsField("$eval")) {
            CommandResult commandResult = this.okResult();
            commandResult.append("retval", (Object)"null");
            return commandResult;
        }
        if (cmd.containsField("getlasterror") || cmd.containsField("getLastError")) {
            return this.okResult();
        }
        if (cmd.containsField("fsync")) {
            return this.okResult();
        }
        if (cmd.containsField("drop")) {
            this.getCollection(cmd.get("drop").toString()).drop();
            return this.okResult();
        }
        if (cmd.containsField("create")) {
            String collectionName = (String)cmd.get("create");
            this.doGetCollection(collectionName);
            return this.okResult();
        }
        if (cmd.containsField("count")) {
            String collectionName = (String)cmd.get("count");
            Number limit = (Number)cmd.get("limit");
            Number skip = (Number)cmd.get("skip");
            long result = this.doGetCollection(collectionName).getCount(ExpressionParser.toDbObject(cmd.get("query")), null, limit == null ? 0L : limit.longValue(), skip == null ? 0L : skip.longValue());
            CommandResult okResult = this.okResult();
            okResult.append("n", (Object)result);
            return okResult;
        }
        if (cmd.containsField("deleteIndexes")) {
            String collectionName = (String)cmd.get("deleteIndexes");
            String indexName = (String)cmd.get("index");
            if ("*".equals(indexName)) {
                this.doGetCollection(collectionName)._dropIndexes();
            } else {
                this.doGetCollection(collectionName)._dropIndex(indexName);
            }
            return this.okResult();
        }
        if (cmd.containsField("aggregate")) {
            List<DBObject> result = this.doAggregateCollection((String)cmd.get("aggregate"), (List)cmd.get("pipeline"));
            if (result == null) {
                return this.notOkErrorResult("can't aggregate");
            }
            CommandResult okResult = this.okResult();
            BasicDBList list = new BasicDBList();
            list.addAll(result);
            okResult.put((Object)"result", (Object)list);
            return okResult;
        }
        if (cmd.containsField("findAndModify")) {
            return this.runFindAndModify(cmd, "findAndModify");
        }
        if (cmd.containsField("findandmodify")) {
            return this.runFindAndModify(cmd, "findandmodify");
        }
        if (cmd.containsField("ping")) {
            return this.okResult();
        }
        if (cmd.containsField("validate")) {
            return this.okResult();
        }
        if (cmd.containsField("buildInfo") || cmd.containsField("buildinfo")) {
            CommandResult okResult = this.okResult();
            List versionList = this.fongo.getServerVersion().getVersionList();
            okResult.put((Object)"version", (Object)(versionList.get(0) + "." + versionList.get(1) + "." + versionList.get(2)));
            okResult.put((Object)"maxBsonObjectSize", (Object)0x1000000);
            return okResult;
        }
        if (cmd.containsField("forceerror")) {
            return this.notOkErrorResult(10038, null, "exception: forced error");
        }
        if (cmd.containsField("mapreduce")) {
            return this.runMapReduce(cmd, "mapreduce");
        }
        if (cmd.containsField("mapReduce")) {
            return this.runMapReduce(cmd, "mapReduce");
        }
        if (cmd.containsField("geoNear")) {
            try {
                List<DBObject> result = this.doGeoNearCollection((String)cmd.get("geoNear"), GeoUtil.coordinate(cmd.get("near")), ExpressionParser.toDbObject(cmd.get("query")), (Number)cmd.get("limit"), (Number)cmd.get("maxDistance"), Boolean.TRUE.equals(cmd.get("spherical")));
                if (result == null) {
                    return this.notOkErrorResult("can't geoNear");
                }
                CommandResult okResult = this.okResult();
                BasicDBList list = new BasicDBList();
                list.addAll(result);
                okResult.put((Object)"results", (Object)list);
                return okResult;
            }
            catch (MongoException me) {
                return this.errorResult(me.getCode(), me.getMessage());
            }
        }
        if (cmd.containsField("renameCollection")) {
            String renameCollection = (String)cmd.get("renameCollection");
            String to = (String)cmd.get("to");
            Boolean dropTarget = (Boolean)cmd.get("dropTarget");
            this.renameCollection(renameCollection, to, dropTarget);
            return this.okResult();
        }
        String collectionName = (String)cmd.toMap().entrySet().iterator().next().getKey();
        if (this.collectionExists(collectionName)) {
            DBObject newCmd = ExpressionParser.toDbObject(cmd.get(collectionName));
            if (newCmd.containsField("text") && ExpressionParser.toDbObject(newCmd.get("text")).containsField("search")) {
                DBObject resp = this.doTextSearchInCollection(collectionName, (String)ExpressionParser.toDbObject(newCmd.get("text")).get("search"), (Integer)ExpressionParser.toDbObject(newCmd.get("text")).get("limit"), ExpressionParser.toDbObject(((DBObject)newCmd.get("text")).get("project")));
                if (resp == null) {
                    return this.notOkErrorResult("can't perform text search");
                }
                CommandResult okResult = this.okResult();
                okResult.put((Object)"results", resp.get("results"));
                okResult.put((Object)"stats", resp.get("stats"));
                return okResult;
            }
            if (newCmd.containsField("$text") && ExpressionParser.toDbObject(newCmd.get("$text")).containsField("$search")) {
                DBObject resp = this.doTextSearchInCollection(collectionName, (String)ExpressionParser.toDbObject(newCmd.get("$text")).get("$search"), (Integer)ExpressionParser.toDbObject(newCmd.get("text")).get("limit"), ExpressionParser.toDbObject(((DBObject)newCmd.get("text")).get("project")));
                if (resp == null) {
                    return this.notOkErrorResult("can't perform text search");
                }
                CommandResult okResult = this.okResult();
                okResult.put((Object)"results", resp.get("results"));
                okResult.put((Object)"stats", resp.get("stats"));
                return okResult;
            }
        }
        String command = cmd.toString();
        if (!cmd.keySet().isEmpty()) {
            command = (String)cmd.keySet().iterator().next();
        }
        return this.notOkErrorResult(null, "no such cmd: " + command);
    }

    public void renameCollection(String renameCollection, String to, Boolean dropTarget) {
        String dbRename = renameCollection.substring(0, renameCollection.indexOf(46));
        String collectionRename = renameCollection.substring(renameCollection.indexOf(46) + 1);
        String dbTo = to.substring(0, to.indexOf(46));
        String collectionTo = to.substring(to.indexOf(46) + 1);
        FongoDBCollection rename = this.fongo.getDB(dbRename).getCollection(collectionRename);
        FongoDBCollection fongoDBCollection = new FongoDBCollection(this.fongo.getDB(dbTo), collectionTo);
        fongoDBCollection.insert(rename.find().toArray());
        for (DBObject index : rename.getIndexInfo()) {
            if (index.get("name").equals("_id_")) continue;
            System.out.println(index);
            Boolean unique = (Boolean)index.get("unique");
            fongoDBCollection.createIndex(ExpressionParser.toDbObject(index.get("key")), (String)index.get("name"), unique == null ? false : unique);
        }
        rename.dropIndexes();
        rename.remove((DBObject)new BasicDBObject());
    }

    public Set<String> getCollectionNames() {
        ArrayList<String> collectionNames = new ArrayList<String>();
        DBCursor collections = this.getCollection(SYSTEM_NAMESPACES).find((DBObject)new BasicDBObject());
        while (collections.hasNext()) {
            String collectionName = ((DBObject)collections.next()).get("name").toString();
            if (collectionName.contains("$")) continue;
            collectionNames.add(collectionName.substring(this.getName().length() + 1));
        }
        Collections.sort(collectionNames);
        return new LinkedHashSet<String>(collectionNames);
    }

    public CommandResult okResult() {
        BsonDocument result = new BsonDocument("ok", (BsonValue)new BsonDouble(1.0));
        return new CommandResult(result, this.fongo.getServerAddress());
    }

    public CommandResult okErrorResult(int code, String err) {
        BsonDocument result = new BsonDocument("ok", (BsonValue)new BsonDouble(1.0));
        result.put("code", (BsonValue)new BsonInt32(code));
        if (err != null) {
            result.put("err", (BsonValue)new BsonString(err));
        }
        return new CommandResult(result, this.fongo.getServerAddress());
    }

    private BsonDocument bsonResultNotOk(int code, String err) {
        BsonDocument result = new BsonDocument("ok", (BsonValue)new BsonDouble(0.0));
        if (err != null) {
            result.put("err", (BsonValue)new BsonString(err));
        }
        result.put("code", (BsonValue)new BsonInt32(code));
        return result;
    }

    public CommandResult notOkErrorResult(String err) {
        return this.notOkErrorResult(err, null);
    }

    public CommandResult notOkErrorResult(String err, String errmsg) {
        BsonDocument result = new BsonDocument("ok", (BsonValue)new BsonDouble(0.0));
        if (err != null) {
            result.put("err", (BsonValue)new BsonString(err));
        }
        if (errmsg != null) {
            result.put("errmsg", (BsonValue)new BsonString(errmsg));
        }
        return new CommandResult(result, this.fongo.getServerAddress());
    }

    public CommandResult notOkErrorResult(int code, String err) {
        BsonDocument result = this.bsonResultNotOk(code, err);
        return new CommandResult(result, this.fongo.getServerAddress());
    }

    public WriteConcernException writeConcernException(int code, String err) {
        BsonDocument result = this.bsonResultNotOk(code, err);
        return new WriteConcernException(result, this.fongo.getServerAddress(), WriteConcernResult.unacknowledged());
    }

    public WriteConcernException duplicateKeyException(int code, String err) {
        BsonDocument result = this.bsonResultNotOk(code, err);
        return new DuplicateKeyException(result, this.fongo.getServerAddress(), WriteConcernResult.unacknowledged());
    }

    public CommandResult notOkErrorResult(int code, String err, String errmsg) {
        CommandResult result = this.notOkErrorResult(err, errmsg);
        result.put((Object)"code", (Object)code);
        return result;
    }

    public CommandResult errorResult(int code, String err) {
        BsonDocument result = new BsonDocument();
        if (err != null) {
            result.put("err", (BsonValue)new BsonString(err));
        }
        result.put("code", (BsonValue)new BsonInt32(code));
        result.put("ok", (BsonValue)BsonBoolean.FALSE);
        return new CommandResult(result, this.fongo.getServerAddress());
    }

    public String toString() {
        return "FongoDB." + this.getName();
    }

    public synchronized void removeCollection(FongoDBCollection collection) {
        this.collMap.remove(collection.getName());
        this.getCollection(SYSTEM_NAMESPACES).remove((DBObject)new BasicDBObject("name", (Object)collection.getFullName()));
        this.namespaceDeclarated.remove(collection.getFullName());
    }

    public void addCollection(FongoDBCollection collection) {
        this.collMap.put(collection.getName(), collection);
        if (!collection.getName().startsWith("system.") && !this.namespaceDeclarated.contains(collection.getFullName())) {
            this.getCollection(SYSTEM_NAMESPACES).insert(new DBObject[]{new BasicDBObject("name", (Object)collection.getFullName()).append("options", (Object)new BasicDBObject())});
            if (this.namespaceDeclarated.size() == 0) {
                this.getCollection(SYSTEM_NAMESPACES).insert(new DBObject[]{new BasicDBObject("name", (Object)(collection.getDB().getName() + ".system.indexes")).append("options", (Object)new BasicDBObject())});
            }
            this.namespaceDeclarated.add(collection.getFullName());
        }
    }

    private CommandResult runFindAndModify(DBObject cmd, String key) {
        if (!cmd.containsField("remove") && !cmd.containsField("update")) {
            return this.notOkErrorResult(null, "need remove or update");
        }
        DBObject result = this.findAndModify((String)cmd.get(key), ExpressionParser.toDbObject(cmd.get("query")), ExpressionParser.toDbObject(cmd.get("sort")), Boolean.TRUE.equals(cmd.get("remove")), ExpressionParser.toDbObject(cmd.get("update")), Boolean.TRUE.equals(cmd.get("new")), ExpressionParser.toDbObject(cmd.get("fields")), Boolean.TRUE.equals(cmd.get("upsert")));
        CommandResult okResult = this.okResult();
        okResult.put((Object)"value", (Object)result);
        return okResult;
    }

    private CommandResult runMapReduce(DBObject cmd, String key) {
        MapReduceOutput result = this.doMapReduce((String)cmd.get(key), (String)cmd.get("map"), (String)cmd.get("reduce"), (String)cmd.get("finalize"), (Map)cmd.get("scope"), ExpressionParser.toDbObject(cmd.get("out")), ExpressionParser.toDbObject(cmd.get("query")), ExpressionParser.toDbObject(cmd.get("sort")), (Number)cmd.get("limit"));
        if (result == null) {
            return this.notOkErrorResult("can't mapReduce");
        }
        CommandResult okResult = this.okResult();
        if (result.results() instanceof List) {
            okResult.put((Object)"results", (Object)result.results());
        } else {
            okResult.put((Object)"result", (Object)result.getCommand());
        }
        return okResult;
    }
}

