/*
 * Decompiled with CFR 0.152.
 */
package com.github.fakemongo.impl.text;

import com.github.fakemongo.impl.index.IndexAbstract;
import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.FongoDB;
import com.mongodb.FongoDBCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TextSearch {
    private static final Logger LOG = LoggerFactory.getLogger(TextSearch.class);
    private static final double SCORE_INC = 0.75;
    private long nscanned = 0L;
    private long nscannedObjects = 0L;
    private final DBCollection collection;
    private final Set<String> textIndexFields;
    private final Map<DBObject, Double> results = new LinkedHashMap<DBObject, Double>();
    private String searchString;
    private DBObject project;
    private int limit;
    private List<String> allWords;
    private List<String> phrasesToSearch;
    private List<String> negatedWordsToSearch;
    private List<String> wordsToSearch;

    public TextSearch(DBCollection collection) {
        this.collection = collection;
        this.textIndexFields = this.searchTextIndexFields(collection, true);
    }

    private <T> List<T> subtractLists(List<T> list1, List<T> list2) {
        ArrayList<T> result = new ArrayList<T>();
        HashSet<T> set2 = new HashSet<T>(list2);
        for (T t1 : list1) {
            if (set2.contains(t1)) continue;
            result.add(t1);
        }
        return result;
    }

    private Set<String> searchTextIndexFields(DBCollection collection, boolean unique) {
        Collection<IndexAbstract> indexes = ((FongoDBCollection)collection).getIndexes();
        IndexAbstract result = null;
        TreeSet<String> indexFields = new TreeSet<String>();
        block0: for (IndexAbstract index : indexes) {
            DBObject keys = index.getKeys();
            for (String field : index.getFields()) {
                if (!keys.get(field).equals("text")) continue;
                if (result != null && unique) {
                    ((FongoDB)collection.getDB()).notOkErrorResult(-5, "more than one text index, not sure which to run text search on").throwOnError();
                }
                result = index;
                indexFields.add(field);
                if (unique) continue;
                continue block0;
            }
        }
        LOG.debug("searchTextIndex() found index {}", result);
        return indexFields;
    }

    private List<String> getWordsByRegex(String string, String regex) {
        ArrayList<String> result = new ArrayList<String>();
        Matcher matcherSW = Pattern.compile(regex).matcher(this.searchString);
        while (matcherSW.find()) {
            String matchPhrase = matcherSW.group(1);
            result.add(matchPhrase);
        }
        return result;
    }

    private List<DBObject> findMatchesInCollection(DBCollection collection, List<String> stringsToSearch, DBObject project) {
        Iterator<String> textKeyIterator = this.textIndexFields.iterator();
        BasicDBList ors = new BasicDBList();
        while (textKeyIterator.hasNext()) {
            String key = textKeyIterator.next();
            for (String aStringsToSearch : stringsToSearch) {
                ors.add((Object)new BasicDBObject(key, (Object)Pattern.compile("\\b" + aStringsToSearch + "\\b", 2)));
            }
        }
        ArrayList<DBObject> result = new ArrayList<DBObject>();
        if (!ors.isEmpty()) {
            BasicDBObject findQuery = new BasicDBObject("$or", (Object)ors);
            DBCursor searchResultCursor = collection.find((DBObject)findQuery, project);
            while (searchResultCursor.hasNext()) {
                result.add(searchResultCursor.next());
                ++this.nscannedObjects;
            }
        }
        return result;
    }

    private BasicDBList sortByScoreAndLimit(Map mapToSotr, int limit) {
        ArrayList sortedRes = new ArrayList(mapToSotr.entrySet());
        Collections.sort(sortedRes, new Comparator(){

            public int compare(Object o1, Object o2) {
                Map.Entry e1 = (Map.Entry)o1;
                Map.Entry e2 = (Map.Entry)o2;
                return ((Comparable)e2.getValue()).compareTo(e1.getValue());
            }
        });
        BasicDBList res = new BasicDBList();
        int till = 0;
        for (Map.Entry entry : sortedRes) {
            res.add((Object)new BasicDBObject("score", entry.getValue()).append("obj", entry.getKey()));
            if (++till < limit) continue;
            break;
        }
        return res;
    }

    private void buildResultsFromList(List<DBObject> resultsToInclude, List<DBObject> resultsNotToInclude) {
        for (DBObject result : resultsToInclude) {
            ++this.nscanned;
            if (resultsNotToInclude.contains(result)) continue;
            Double score = this.results.containsKey(result) ? Double.valueOf(this.results.get(result) + 0.75) : Double.valueOf(0.75);
            this.results.put(result, score);
        }
    }

    private DBObject buildResponce(BasicDBList results) {
        BasicDBObject res = new BasicDBObject("language", (Object)"english");
        res.put((Object)"results", (Object)results);
        res.put((Object)"stats", (Object)new BasicDBObject("nscannedObjects", (Object)this.nscannedObjects).append("nscanned", (Object)this.nscanned).append("n", (Object)results.size()).append("timeMicros", (Object)1));
        res.put((Object)"ok", (Object)1);
        return res;
    }

    public DBObject findByTextSearch(String searchString) {
        return this.findByTextSearch(searchString, null, 100);
    }

    public DBObject findByTextSearch(String searchString, DBObject project) {
        return this.findByTextSearch(searchString, project, 100);
    }

    public DBObject findByTextSearch(String searchString, DBObject project, int limit) {
        this.searchString = searchString;
        this.project = project;
        this.limit = limit <= 0 ? 100 : limit;
        this.allWords = this.getWordsByRegex(searchString, "([[^\\p{Space}\\\\\\\"-]&&\\p{Alnum}&&[^\\p{Space}\\\\\\\"]]+)");
        this.phrasesToSearch = this.getWordsByRegex(searchString, "\"\\s*(.*?)\\s*\"");
        this.phrasesToSearch.addAll(this.getWordsByRegex(searchString, "\\b((?!-)\\S+\\s(?!-)\\S+)\\b"));
        this.negatedWordsToSearch = this.getWordsByRegex(searchString, "-(.\\S*)\\s*");
        this.wordsToSearch = this.subtractLists(this.allWords, this.negatedWordsToSearch);
        List<DBObject> negatedSearchResults = this.findMatchesInCollection(this.collection, this.negatedWordsToSearch, project);
        List<DBObject> phrasesSearchResult = this.findMatchesInCollection(this.collection, this.phrasesToSearch, project);
        List<DBObject> wordsSearchResult = this.findMatchesInCollection(this.collection, this.wordsToSearch, project);
        this.buildResultsFromList(phrasesSearchResult, negatedSearchResults);
        this.buildResultsFromList(wordsSearchResult, negatedSearchResults);
        BasicDBList res = this.sortByScoreAndLimit(this.results, this.limit);
        return this.buildResponce(res);
    }
}

