/*
 * Decompiled with CFR 0.152.
 */
package com.github.fakemongo.impl.index;

import com.github.fakemongo.impl.Filter;
import com.github.fakemongo.impl.Util;
import com.github.fakemongo.impl.geo.GeoUtil;
import com.github.fakemongo.impl.index.IndexAbstract;
import com.github.fakemongo.impl.index.IndexedList;
import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import com.vividsolutions.jts.geom.Geometry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeoIndex
extends IndexAbstract<GeoUtil.GeoDBObject> {
    private static final Logger LOG = LoggerFactory.getLogger(GeoIndex.class);

    GeoIndex(String name, DBObject keys, boolean unique, String geoIndex) {
        super(name, keys, unique, new LinkedHashMap(), geoIndex);
    }

    @Override
    protected GeoUtil.GeoDBObject getKeyFor(DBObject object) {
        return new GeoUtil.GeoDBObject((DBObject)super.getKeyFor(object), this.geoIndex);
    }

    @Override
    public GeoUtil.GeoDBObject embedded(DBObject object) {
        return new GeoUtil.GeoDBObject(object, this.geoIndex);
    }

    public List<DBObject> geoNear(DBObject query, Geometry geometry, int limit, boolean spherical) {
        ++this.lookupCount;
        LOG.info("geoNear() query:{}, geometry:{}, limit:{}, spherical:{} (mapValues size:{})", new Object[]{query, geometry, limit, spherical, this.mapValues.size()});
        Filter filterValue = this.expressionParser.buildFilter(query);
        LinkedHashSet<DBObject> resultSet = new LinkedHashSet<DBObject>();
        this.geoNearCoverAll(this.mapValues, filterValue, geometry, spherical, resultSet);
        return this.sortAndLimit(resultSet, limit);
    }

    private void geoNearCoverAll(Map<GeoUtil.GeoDBObject, IndexedList<GeoUtil.GeoDBObject>> values, Filter filterValue, Geometry near, boolean spherical, LinkedHashSet<DBObject> resultSet) {
        for (Map.Entry<GeoUtil.GeoDBObject, IndexedList<GeoUtil.GeoDBObject>> entry : values.entrySet()) {
            this.geoNearResults(entry.getValue().getElements(), filterValue, near, resultSet, spherical);
        }
    }

    private List<DBObject> sortAndLimit(Collection<DBObject> resultSet, int limit) {
        ArrayList<DBObject> result = new ArrayList<DBObject>(resultSet);
        Collections.sort(result, new Comparator<DBObject>(){

            @Override
            public int compare(DBObject o1, DBObject o2) {
                return ((Double)o1.get("dis")).compareTo((Double)o2.get("dis"));
            }
        });
        return result.subList(0, Math.min(result.size(), limit));
    }

    private void geoNearResults(List<GeoUtil.GeoDBObject> values, Filter filterValue, Geometry near, Collection<DBObject> result, boolean spherical) {
        for (GeoUtil.GeoDBObject geoDBObject : values) {
            if (geoDBObject.getGeometry() == null || !filterValue.apply((DBObject)geoDBObject)) continue;
            double radians = GeoUtil.distanceInRadians(geoDBObject.getGeometry(), near, spherical);
            geoDBObject.removeField("$$$$$FONGO_ORDER_BY$$$$$");
            result.add((DBObject)new BasicDBObject("dis", (Object)radians).append("obj", (Object)Util.clone(geoDBObject)));
        }
    }
}

