/*
 * Decompiled with CFR 0.152.
 */
package com.github.fakemongo.impl;

import com.github.fakemongo.Fongo;
import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import com.mongodb.FongoDB;
import com.mongodb.FongoDBCollection;
import com.mongodb.FongoMapReduceOutput;
import com.mongodb.MapReduceCommand;
import com.mongodb.MapReduceOutput;
import com.mongodb.operation.MapReduceStatistics;
import com.mongodb.util.FongoJSON;
import com.mongodb.util.ObjectSerializer;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.mozilla.javascript.ConsString;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.NativeArray;
import org.mozilla.javascript.NativeJavaObject;
import org.mozilla.javascript.NativeObject;
import org.mozilla.javascript.RhinoException;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.tools.shell.Global;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapReduce {
    private static final Logger LOG = LoggerFactory.getLogger(MapReduce.class);
    private final FongoDB fongoDB;
    private final FongoDBCollection fongoDBCollection;
    private final String map;
    private final String reduce;
    private final String finalize;
    private final Map<String, Object> scope;
    private final DBObject out;
    private final DBObject query;
    private final DBObject sort;
    private final int limit;
    static final Map<Class<?>, ObjectSerializer> OBJECT_SERIALIZERS = new HashMap();

    public MapReduce(Fongo fongo, FongoDBCollection coll, String map, String reduce, String finalize, Map<String, Object> scope, DBObject out, DBObject query, DBObject sort, Number limit) {
        this.fongoDB = out.containsField("db") ? fongo.getDB((String)out.get("db")) : (FongoDB)coll.getDB();
        this.fongoDBCollection = coll;
        this.map = map;
        this.reduce = reduce;
        this.finalize = finalize;
        this.scope = scope;
        this.out = out;
        this.query = query;
        this.sort = sort;
        this.limit = limit == null ? 0 : limit.intValue();
    }

    public MapReduceOutput computeResult() {
        long startTime = System.currentTimeMillis();
        Outmode outmode = Outmode.valueFor(this.out);
        FongoDBCollection coll = this.fongoDB.getCollection(outmode.collectionName(this.out));
        outmode.initCollection(coll);
        MapReduceResult mapReduceResult = this.runInContext();
        outmode.newResults(this, coll, mapReduceResult.result);
        MapReduceStatistics mapReduceStatistics = new MapReduceStatistics(mapReduceResult.inputCount, mapReduceResult.outputCount, mapReduceResult.emitCount, (int)(System.currentTimeMillis() - startTime));
        MapReduceOutput result = outmode.createResult(this.query, coll, mapReduceStatistics);
        LOG.debug("computeResult() : {}", (Object)result);
        return result;
    }

    private MapReduceResult runInContext() {
        Context cx = Context.enter();
        try {
            Global scriptable = new Global(cx);
            cx.initStandardObjects();
            ScriptableObject.defineClass((Scriptable)scriptable, FongoNumberLong.class);
            ScriptableObject.defineClass((Scriptable)scriptable, FongoNumberInt.class);
            StringBuilder stringBuilder = new StringBuilder();
            this.addMongoFunctions(stringBuilder);
            this.addScopeObjects(stringBuilder);
            ArrayList<String> javascriptFunctions = new ArrayList<String>();
            javascriptFunctions.add(stringBuilder.toString());
            List objects = this.fongoDBCollection.find(this.query).sort(this.sort).limit(this.limit).toArray();
            this.constructJavascriptFunction(javascriptFunctions, objects);
            for (String jsFunction : javascriptFunctions) {
                try {
                    cx.evaluateString((Scriptable)scriptable, jsFunction, "MapReduce", 0, null);
                }
                catch (RhinoException e) {
                    LOG.error("Exception running script {}", (Object)jsFunction, (Object)e);
                    if (e.getMessage().contains("FongoAssertException")) {
                        this.fongoDB.notOkErrorResult(16722, "Error: assert failed: " + e.getMessage()).throwOnError();
                    }
                    this.fongoDB.notOkErrorResult(16722, "JavaScript execution failed: " + e.getMessage()).throwOnError();
                }
            }
            NativeArray outs = (NativeArray)scriptable.get("$$$fongoOuts$$$", (Scriptable)scriptable);
            ArrayList<DBObject> dbOuts = new ArrayList<DBObject>();
            int i = 0;
            while ((long)i < outs.getLength()) {
                NativeObject out = (NativeObject)outs.get(i, (Scriptable)outs);
                dbOuts.add(this.getObject((ScriptableObject)out));
                ++i;
            }
            MapReduceResult mapReduceResult = new MapReduceResult(objects.size(), dbOuts.size(), objects.size(), dbOuts);
            return mapReduceResult;
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        finally {
            Context.exit();
        }
    }

    private void addScopeObjects(StringBuilder stringBuilder) {
        if (this.scope != null) {
            for (Map.Entry<String, Object> entry : this.scope.entrySet()) {
                stringBuilder.append("var ").append(entry.getKey()).append(" = ");
                FongoJSON.serialize(entry.getValue(), stringBuilder, OBJECT_SERIALIZERS);
                stringBuilder.append(";\n");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<DBObject> reduceOutputStage(DBCollection coll, List<DBObject> mapReduceOutput) {
        Context cx = Context.enter();
        try {
            ScriptableObject scope = cx.initStandardObjects();
            List<String> jsFunctions = this.constructReduceOutputStageJavascriptFunction(coll, mapReduceOutput);
            for (String jsFunction : jsFunctions) {
                try {
                    cx.evaluateString((Scriptable)scope, jsFunction, "<reduce output stage>", 0, null);
                }
                catch (RhinoException e) {
                    LOG.error("Exception running script {}", (Object)jsFunction, (Object)e);
                    if (e.getMessage().contains("FongoAssertException")) {
                        this.fongoDB.notOkErrorResult(16722, "Error: assert failed: " + e.getMessage()).throwOnError();
                    }
                    this.fongoDB.notOkErrorResult(16722, "JavaScript execution failed: " + e.getMessage()).throwOnError();
                }
            }
            NativeArray outs = (NativeArray)scope.get("$$$fongoOuts$$$", (Scriptable)scope);
            ArrayList<DBObject> dbOuts = new ArrayList<DBObject>();
            int i = 0;
            while ((long)i < outs.getLength()) {
                NativeObject out = (NativeObject)outs.get(i, (Scriptable)outs);
                dbOuts.add(this.getObject((ScriptableObject)out));
                ++i;
            }
            LOG.debug("reduceOutputStage() : {}", dbOuts);
            ArrayList<DBObject> arrayList = dbOuts;
            return arrayList;
        }
        finally {
            Context.exit();
        }
    }

    DBObject getObject(ScriptableObject no) {
        Object[] propIds;
        if (no instanceof NativeArray) {
            BasicDBList ret = new BasicDBList();
            NativeArray noArray = (NativeArray)no;
            int i = 0;
            while ((long)i < noArray.getLength()) {
                Object value = noArray.get(i, (Scriptable)noArray);
                value = this.getObjectOrTransform(value);
                ret.add(value);
                ++i;
            }
            return ret;
        }
        BasicDBObject ret = new BasicDBObject();
        for (Object propId : propIds = no.getIds()) {
            String key = Context.toString((Object)propId);
            Object value = NativeObject.getProperty((Scriptable)no, (String)key);
            value = this.getObjectOrTransform(value);
            ret.put(key, value);
        }
        return ret;
    }

    private Object getObjectOrTransform(Object value) {
        if (value instanceof NativeObject || value instanceof NativeArray) {
            value = this.getObject((ScriptableObject)value);
        }
        if (value instanceof Integer) {
            value = ((Integer)value).doubleValue();
        }
        if (value instanceof ConsString) {
            value = value.toString();
        }
        if (value instanceof NativeJavaObject) {
            value = ((NativeJavaObject)value).unwrap();
        }
        if (value instanceof FongoNumberLong) {
            value = ((FongoNumberLong)((Object)value)).value;
        }
        if (value instanceof FongoNumberInt) {
            value = ((FongoNumberInt)((Object)value)).value;
        }
        return value;
    }

    private List<String> constructJavascriptFunction(List<String> result, List<DBObject> objects) {
        StringBuilder sb = new StringBuilder(80000);
        sb.append("var $$$fongoEmits$$$ = new Object();\n");
        sb.append("function emit(param1, param2) {\nvar toSource = param1.toSource();\nif(typeof $$$fongoEmits$$$[toSource] === 'undefined') {\n $$$fongoEmits$$$[toSource] = new Array();\n}\nvar val = {id: param1, value: param2};\n$$$fongoEmits$$$[toSource][$$$fongoEmits$$$[toSource].length] = val;\n};\n");
        sb.append("var fongoMapFunction = ").append(this.map).append(";\n");
        sb.append("var $$$fongoVars$$$ = new Object();\n");
        for (DBObject object : objects) {
            sb.append("$$$fongoVars$$$ = ");
            FongoJSON.serialize(object, sb, OBJECT_SERIALIZERS);
            sb.append(";\n");
            sb.append("$$$fongoVars$$$['fongoExecute'] = fongoMapFunction;\n");
            sb.append("$$$fongoVars$$$.fongoExecute();\n");
        }
        result.add(sb.toString());
        sb.setLength(0);
        sb.append("var reduce = ").append(this.reduce).append("\n");
        sb.append("var $$$fongoOuts$$$ = Array();\nfor(var i in $$$fongoEmits$$$) {\nvar elem = $$$fongoEmits$$$[i];\nvar values = []; id = null; for (var ii in elem) { values.push(elem[ii].value); id = elem[ii].id;}\n$$$fongoOuts$$$[$$$fongoOuts$$$.length] = { _id : id, value : reduce(id, values) };\n}\n");
        result.add(sb.toString());
        return result;
    }

    private List<String> constructReduceOutputStageJavascriptFunction(DBCollection coll, List<DBObject> objects) {
        ArrayList<String> result = new ArrayList<String>();
        StringBuilder sb = new StringBuilder(80000);
        this.addMongoFunctions(sb);
        sb.append("var reduce = ").append(this.reduce).append("\n");
        sb.append("var $$$fongoOuts$$$ = new Array();\n");
        for (DBObject object : objects) {
            String objectJson = FongoJSON.serialize(object);
            String objectValueJson = FongoJSON.serialize(object.get("value"));
            DBObject existing = coll.findOne((DBObject)new BasicDBObject().append("_id", object.get("_id")));
            if (existing == null || existing.get("value") == null) {
                sb.append("$$$fongoOuts$$$[$$$fongoOuts$$$.length] = ").append(objectJson).append(";\n");
            } else {
                String id = FongoJSON.serialize(object.get("_id"));
                String existingValueJson = FongoJSON.serialize(existing.get("value"));
                sb.append("$$$fongoId$$$ = ").append(id).append(";\n");
                sb.append("$$$fongoValues$$$ = [ ").append(existingValueJson).append(", ").append(objectValueJson).append("];\n");
                sb.append("$$$fongoReduced$$$ = { _id: $$$fongoId$$$, 'value': reduce($$$fongoId$$$, $$$fongoValues$$$)};").append(";\n");
                sb.append("$$$fongoOuts$$$[$$$fongoOuts$$$.length] = $$$fongoReduced$$$;\n");
            }
            if (sb.length() <= 65535) continue;
            result.add(sb.toString());
            sb.setLength(0);
        }
        result.add(sb.toString());
        return result;
    }

    private void addMongoFunctions(StringBuilder construct) {
        construct.append("Array.sum = function(array) {\n    var a = 0;\n    for (var i = 0; i < array.length; i++) {\n        a = a + array[i];\n    }\n    return a;};\n");
        construct.append("printjson = function(a) {    print(tojson(a));\n };\n");
        construct.append("printjsononeline = function(a) {\n    print(tojson(a));\n };\n");
        construct.append("assert = function(a) {\n    if (!a) throw new FongoAssertException();\n };\n");
        construct.append("isString = function(a) {\n    return typeof(a) === 'string';\n };\n");
        construct.append("isNumber = function(a) {\n    return typeof(a) === 'number';\n };\n");
        construct.append("isObject = function(a) {\n    return typeof(a) === 'object';\n };\n");
        construct.append("tojson = function(a) {\n    return JSON.stringify(a,null,0);\n };\n");
        construct.append("tojsononeline = function(a) {\n    return JSON.stringify(a,null,0);\n };\n");
        construct.append("NumberLong = function(a) {\n        return new FongoNumberLong(a);\n};\n");
        construct.append("NumberInt = function(a) {\n        return new FongoNumberInt(a);\n};\n");
    }

    static {
        OBJECT_SERIALIZERS.put(Long.class, new FongoLongSerializer());
        OBJECT_SERIALIZERS.put(Integer.class, new FongoIntegerSerializer());
    }

    private static class FongoIntegerSerializer
    implements ObjectSerializer {
        private FongoIntegerSerializer() {
        }

        public String serialize(Object obj) {
            StringBuilder builder = new StringBuilder();
            this.serialize(obj, builder);
            return builder.toString();
        }

        public void serialize(Object obj, StringBuilder buf) {
            buf.append("NumberInt(").append(obj.toString()).append(")");
        }
    }

    private static class FongoLongSerializer
    implements ObjectSerializer {
        private FongoLongSerializer() {
        }

        public String serialize(Object obj) {
            StringBuilder builder = new StringBuilder();
            this.serialize(obj, builder);
            return builder.toString();
        }

        public void serialize(Object obj, StringBuilder buf) {
            buf.append("NumberLong(").append(obj.toString()).append(")");
        }
    }

    public static class FongoNumberInt
    extends ScriptableObject {
        int value;

        public void jsConstructor(int a) {
            this.value = a;
        }

        public int jsFunction_toNumber() {
            return this.value;
        }

        public int jsFunction_valueOf() {
            return this.value;
        }

        public String getClassName() {
            return "FongoNumberInt";
        }

        public String jsFunction_toString() {
            return "NumberInt(" + this.value + ")";
        }
    }

    public static class FongoNumberLong
    extends ScriptableObject {
        long value;

        public FongoNumberLong() {
        }

        public FongoNumberLong(long value) {
            this.value = value;
        }

        public void jsConstructor(int a) {
            this.value = a;
        }

        public int jsFunction_toNumber() {
            return (int)this.value;
        }

        public int jsFunction_valueOf() {
            return this.jsFunction_toNumber();
        }

        public String getClassName() {
            return "FongoNumberLong";
        }

        public String jsFunction_toString() {
            return "NumberLong(" + this.value + ")";
        }
    }

    static class MapReduceResult {
        final int inputCount;
        final int outputCount;
        final int emitCount;
        final List<DBObject> result;

        public MapReduceResult(int inputCount, int outputCount, int emitCount, List<DBObject> result) {
            this.inputCount = inputCount;
            this.outputCount = outputCount;
            this.emitCount = emitCount;
            this.result = result;
        }
    }

    private static enum Outmode {
        REPLACE{

            @Override
            public void initCollection(DBCollection coll) {
                coll.remove((DBObject)new BasicDBObject());
            }

            @Override
            public void newResults(MapReduce mr, DBCollection coll, List<DBObject> results) {
                coll.insert(results);
            }
        }
        ,
        MERGE{

            @Override
            public void newResults(MapReduce mr, DBCollection coll, List<DBObject> results) {
                for (DBObject result : results) {
                    coll.update((DBObject)new BasicDBObject("_id", result.get("_id")), result, true, false);
                }
            }
        }
        ,
        REDUCE{

            @Override
            public void newResults(MapReduce mr, DBCollection coll, List<DBObject> results) {
                List reduced = mr.reduceOutputStage(coll, results);
                for (DBObject result : reduced) {
                    coll.update((DBObject)new BasicDBObject("_id", result.get("_id")), result, true, false);
                }
            }
        }
        ,
        INLINE{

            @Override
            public void initCollection(DBCollection coll) {
                coll.remove((DBObject)new BasicDBObject());
            }

            @Override
            public void newResults(MapReduce mr, DBCollection coll, List<DBObject> results) {
                coll.insert(results);
            }

            @Override
            public String collectionName(DBObject object) {
                return UUID.randomUUID().toString();
            }

            @Override
            public MapReduceOutput createResult(DBObject query, DBCollection coll, MapReduceStatistics ignored) {
                return new FongoMapReduceOutput(query, coll.find().toArray());
            }
        };


        public static Outmode valueFor(DBObject object) {
            for (Outmode outmode : Outmode.values()) {
                if (!object.containsField(outmode.name().toLowerCase())) continue;
                return outmode;
            }
            return null;
        }

        public static Outmode valueFor(MapReduceCommand.OutputType outputType) {
            for (Outmode outmode : Outmode.values()) {
                if (!outputType.name().equalsIgnoreCase(outmode.name().toLowerCase())) continue;
                return outmode;
            }
            return null;
        }

        public String collectionName(DBObject object) {
            return (String)object.get(this.name().toLowerCase());
        }

        public void initCollection(DBCollection coll) {
        }

        public abstract void newResults(MapReduce var1, DBCollection var2, List<DBObject> var3);

        public MapReduceOutput createResult(DBObject query, DBCollection coll, MapReduceStatistics mapReduceStatistics) {
            return new FongoMapReduceOutput(query, coll, mapReduceStatistics);
        }
    }
}

