/*
 * Decompiled with CFR 0.152.
 */
package com.github.fakemongo;

import com.github.fakemongo.Fongo;
import com.github.fakemongo.FongoConnection;
import com.mongodb.binding.ConnectionSource;
import com.mongodb.connection.Connection;
import com.mongodb.connection.ServerConnectionState;
import com.mongodb.connection.ServerDescription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class FongoConnectionSource
implements ConnectionSource {
    private static final Logger LOG = LoggerFactory.getLogger(FongoConnectionSource.class);
    private final Fongo fongo;

    public FongoConnectionSource(Fongo fongo) {
        this.fongo = fongo;
    }

    public ServerDescription getServerDescription() {
        return ServerDescription.builder().address(this.fongo.getServerAddress()).state(ServerConnectionState.CONNECTED).version(this.fongo.getServerVersion()).build();
    }

    public Connection getConnection() {
        return new FongoConnection(this.fongo);
    }

    public ConnectionSource retain() {
        return this;
    }

    public int getCount() {
        return 0;
    }

    public void release() {
    }
}

