/*
 * Decompiled with CFR 0.152.
 */
package oshi.json.software.os.impl;

import java.util.Properties;
import javax.json.Json;
import javax.json.JsonArrayBuilder;
import javax.json.JsonBuilderFactory;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonValue;
import oshi.json.json.AbstractOshiJsonObject;
import oshi.json.json.NullAwareJsonObjectBuilder;
import oshi.json.software.os.FileSystem;
import oshi.json.software.os.OSProcess;
import oshi.json.software.os.OperatingSystem;
import oshi.json.software.os.OperatingSystemVersion;
import oshi.json.software.os.impl.FileSystemImpl;
import oshi.json.software.os.impl.OSProcessImpl;
import oshi.json.software.os.impl.OperatingSystemVersionImpl;
import oshi.json.util.PropertiesUtil;
import oshi.software.os.OperatingSystem;

public class OperatingSystemImpl
extends AbstractOshiJsonObject
implements OperatingSystem {
    private static final long serialVersionUID = 1L;
    private transient JsonBuilderFactory jsonFactory = Json.createBuilderFactory(null);
    private oshi.software.os.OperatingSystem os;
    private OperatingSystemVersion version;

    public OperatingSystemImpl(oshi.software.os.OperatingSystem operatingSystem) {
        this.os = operatingSystem;
        this.version = new OperatingSystemVersionImpl(this.os.getVersion());
    }

    @Override
    public String getFamily() {
        return this.os.getFamily();
    }

    @Override
    public String getManufacturer() {
        return this.os.getManufacturer();
    }

    @Override
    public OperatingSystemVersion getVersion() {
        return this.version;
    }

    @Override
    public FileSystem getFileSystem() {
        return new FileSystemImpl(this.os.getFileSystem());
    }

    @Override
    public OSProcess[] getProcesses(int limit, OperatingSystem.ProcessSort sort) {
        oshi.software.os.OSProcess[] procs = this.os.getProcesses(limit, sort);
        OSProcess[] processes = new OSProcess[procs.length];
        for (int i = 0; i < procs.length; ++i) {
            processes[i] = new OSProcessImpl(procs[i]);
        }
        return processes;
    }

    @Override
    public OSProcess getProcess(int pid) {
        return new OSProcessImpl(this.os.getProcess(pid));
    }

    @Override
    public int getProcessId() {
        return this.os.getProcessId();
    }

    @Override
    public int getProcessCount() {
        return this.os.getProcessCount();
    }

    @Override
    public int getThreadCount() {
        return this.os.getThreadCount();
    }

    @Override
    public JsonObject toJSON(Properties properties) {
        JsonObjectBuilder json = NullAwareJsonObjectBuilder.wrap(this.jsonFactory.createObjectBuilder());
        if (PropertiesUtil.getBoolean(properties, "operatingSystem.manufacturer")) {
            json.add("manufacturer", this.getManufacturer());
        }
        if (PropertiesUtil.getBoolean(properties, "operatingSystem.family")) {
            json.add("family", this.getFamily());
        }
        if (PropertiesUtil.getBoolean(properties, "operatingSystem.version")) {
            json.add("version", (JsonValue)this.getVersion().toJSON(properties));
        }
        if (PropertiesUtil.getBoolean(properties, "operatingSystem.fileSystem")) {
            json.add("fileSystem", (JsonValue)this.getFileSystem().toJSON(properties));
        }
        if (PropertiesUtil.getBoolean(properties, "operatingSystem.processID")) {
            json.add("processID", this.getProcessId());
        }
        if (PropertiesUtil.getBoolean(properties, "operatingSystem.processCount")) {
            json.add("processCount", this.getProcessCount());
        }
        if (PropertiesUtil.getBoolean(properties, "operatingSystem.threadCount")) {
            json.add("threadCount", this.getThreadCount());
        }
        if (PropertiesUtil.getBoolean(properties, "operatingSystem.processes")) {
            JsonArrayBuilder processArrayBuilder = this.jsonFactory.createArrayBuilder();
            for (OSProcess proc : this.getProcesses(PropertiesUtil.getIntOrDefault(properties, "operatingSystem.processes.limit", 0), PropertiesUtil.getEnum(properties, "operatingSystem.processes.sort", OperatingSystem.ProcessSort.class))) {
                processArrayBuilder.add((JsonValue)proc.toJSON(properties));
            }
            json.add("processes", (JsonValue)processArrayBuilder.build());
        }
        return json.build();
    }

    @Override
    public String toString() {
        return this.os.toString();
    }
}

