/*
 * Decompiled with CFR 0.152.
 */
package org.bbottema.rtftohtml.impl;

import java.nio.charset.Charset;
import java.util.LinkedList;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bbottema.rtftohtml.RTF2HTMLConverter;
import org.bbottema.rtftohtml.impl.util.ByteUtil;
import org.bbottema.rtftohtml.impl.util.CharsetHelper;
import org.jetbrains.annotations.NotNull;

public class RTF2HTMLConverterRFCCompliant
implements RTF2HTMLConverter {
    public static final RTF2HTMLConverter INSTANCE = new RTF2HTMLConverterRFCCompliant();
    private static Pattern CONTROL_WORD = Pattern.compile("\\\\(([^a-zA-Z])|(([a-zA-Z]+)(-?[\\d]*) ?))");
    private static Pattern ENCODED_CHARACTER = Pattern.compile("\\\\'([0-9a-fA-F]{2})");

    private RTF2HTMLConverterRFCCompliant() {
    }

    @Override
    @NotNull
    public String rtf2html(@NotNull String rtf) {
        if (rtf == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/bbottema/rtftohtml/impl/RTF2HTMLConverterRFCCompliant.rtf2html must not be null");
        }
        Charset charset = CharsetHelper.WINDOWS_CHARSET;
        LinkedList<Group> groupStack = new LinkedList<Group>();
        groupStack.add(new Group());
        Matcher controlWordMatcher = CONTROL_WORD.matcher(rtf);
        Matcher encodedCharMatcher = ENCODED_CHARACTER.matcher(rtf);
        StringBuilder result = new StringBuilder();
        int length = rtf.length();
        int charIndex = 0;
        while (charIndex < length) {
            char c = rtf.charAt(charIndex);
            Group currentGroup = (Group)groupStack.getFirst();
            if (c == '\r' || c == '\n') {
                ++charIndex;
                continue;
            }
            if (c == '{') {
                groupStack.addFirst(currentGroup.copy());
                ++charIndex;
                continue;
            }
            if (c == '}') {
                groupStack.removeFirst();
                if (groupStack.size() == 1) break;
                ++charIndex;
                continue;
            }
            if (c == '\\') {
                encodedCharMatcher.region(charIndex, length);
                if (encodedCharMatcher.lookingAt()) {
                    StringBuilder encodedSequence = new StringBuilder();
                    while (encodedCharMatcher.lookingAt()) {
                        encodedSequence.append(encodedCharMatcher.group(1));
                        encodedCharMatcher.region(charIndex += 4, length);
                    }
                    String decoded = ByteUtil.hexToString(encodedSequence.toString(), charset);
                    this.append(result, decoded, currentGroup);
                    continue;
                }
                controlWordMatcher.region(charIndex, length);
                if (!controlWordMatcher.lookingAt()) {
                    throw new IllegalStateException("RTF file has invalid structure. Failed to match character '" + c + "' at [" + charIndex + "/" + length + "] to a control symbol or word.");
                }
                Integer controlNumber = null;
                String controlWord = controlWordMatcher.group(2);
                if (controlWord == null) {
                    controlWord = controlWordMatcher.group(4);
                    String controlNumberString = controlWordMatcher.group(5);
                    if (!"".equals(controlNumberString)) {
                        controlNumber = Integer.valueOf(controlNumberString);
                    }
                }
                charIndex += controlWordMatcher.end() - controlWordMatcher.start();
                switch (controlWord) {
                    case "par": {
                        this.append(result, "\n", currentGroup);
                        break;
                    }
                    case "tab": {
                        this.append(result, "\t", currentGroup);
                        break;
                    }
                    case "htmlrtf": {
                        currentGroup.htmlRtf = controlNumber == null;
                        break;
                    }
                    case "ansicpg": {
                        charset = CharsetHelper.findCharset(Objects.requireNonNull(controlNumber).toString());
                        break;
                    }
                    case "fonttbl": 
                    case "colortbl": {
                        currentGroup.ignore = true;
                        break;
                    }
                    case "uc": {
                        currentGroup.unicodeCharLength = controlNumber == null ? 1 : controlNumber;
                        break;
                    }
                    case "u": {
                        if (controlNumber == null) break;
                        char unicodeSymbol = (char)controlNumber.intValue();
                        this.append(result, Character.toString(unicodeSymbol), currentGroup);
                        charIndex += currentGroup.unicodeCharLength;
                        break;
                    }
                    case "{": 
                    case "}": 
                    case "\\": {
                        this.append(result, controlWord, currentGroup);
                        break;
                    }
                }
                continue;
            }
            this.append(result, c + "", currentGroup);
            ++charIndex;
        }
        String string = result.toString();
        if (string == null) {
            throw new IllegalStateException("NotNull method org/bbottema/rtftohtml/impl/RTF2HTMLConverterRFCCompliant.rtf2html must not return null");
        }
        return string;
    }

    private void append(StringBuilder result, String symbol, Group group) {
        if (result == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/bbottema/rtftohtml/impl/RTF2HTMLConverterRFCCompliant.append must not be null");
        }
        if (symbol == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 1 of org/bbottema/rtftohtml/impl/RTF2HTMLConverterRFCCompliant.append must not be null");
        }
        if (group == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 2 of org/bbottema/rtftohtml/impl/RTF2HTMLConverterRFCCompliant.append must not be null");
        }
        if (!group.ignore && !group.htmlRtf) {
            result.append(symbol);
        }
    }

    private static class Group {
        boolean ignore = false;
        int unicodeCharLength = 1;
        boolean htmlRtf = false;

        private Group() {
        }

        Group copy() {
            Group newGroup = new Group();
            newGroup.ignore = this.ignore;
            newGroup.unicodeCharLength = this.unicodeCharLength;
            newGroup.htmlRtf = this.htmlRtf;
            Group group = newGroup;
            if (group == null) {
                throw new IllegalStateException("NotNull method org/bbottema/rtftohtml/impl/RTF2HTMLConverterRFCCompliant$Group.copy must not return null");
            }
            return group;
        }
    }
}

