/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.module.kotlin;

import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.deser.Deserializers;
import com.fasterxml.jackson.module.kotlin.JavaToKotlinDurationConverter;
import com.fasterxml.jackson.module.kotlin.RegexDeserializer;
import com.fasterxml.jackson.module.kotlin.SequenceDeserializer;
import com.fasterxml.jackson.module.kotlin.UByteDeserializer;
import com.fasterxml.jackson.module.kotlin.UIntDeserializer;
import com.fasterxml.jackson.module.kotlin.ULongDeserializer;
import com.fasterxml.jackson.module.kotlin.UShortDeserializer;
import kotlin.Metadata;
import kotlin.UByte;
import kotlin.UInt;
import kotlin.ULong;
import kotlin.UShort;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.text.Regex;
import kotlin.time.Duration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J*\u0010\u0005\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/fasterxml/jackson/module/kotlin/KotlinDeserializers;", "Lcom/fasterxml/jackson/databind/deser/Deserializers$Base;", "useJavaDurationConversion", "", "(Z)V", "findBeanDeserializer", "Lcom/fasterxml/jackson/databind/JsonDeserializer;", "type", "Lcom/fasterxml/jackson/databind/JavaType;", "config", "Lcom/fasterxml/jackson/databind/DeserializationConfig;", "beanDesc", "Lcom/fasterxml/jackson/databind/BeanDescription;", "jackson-module-kotlin"})
public final class KotlinDeserializers
extends Deserializers.Base {
    private final boolean useJavaDurationConversion;

    public KotlinDeserializers(boolean useJavaDurationConversion) {
        this.useJavaDurationConversion = useJavaDurationConversion;
    }

    @Nullable
    public JsonDeserializer<?> findBeanDeserializer(@NotNull JavaType type, @Nullable DeserializationConfig config, @Nullable BeanDescription beanDesc) {
        JsonDeserializer jsonDeserializer;
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        if (type.isInterface() && Intrinsics.areEqual((Object)type.getRawClass(), Sequence.class)) {
            jsonDeserializer = (JsonDeserializer)SequenceDeserializer.INSTANCE;
        } else if (Intrinsics.areEqual((Object)type.getRawClass(), Regex.class)) {
            jsonDeserializer = (JsonDeserializer)RegexDeserializer.INSTANCE;
        } else if (Intrinsics.areEqual((Object)type.getRawClass(), UByte.class)) {
            jsonDeserializer = (JsonDeserializer)UByteDeserializer.INSTANCE;
        } else if (Intrinsics.areEqual((Object)type.getRawClass(), UShort.class)) {
            jsonDeserializer = (JsonDeserializer)UShortDeserializer.INSTANCE;
        } else if (Intrinsics.areEqual((Object)type.getRawClass(), UInt.class)) {
            jsonDeserializer = (JsonDeserializer)UIntDeserializer.INSTANCE;
        } else if (Intrinsics.areEqual((Object)type.getRawClass(), ULong.class)) {
            jsonDeserializer = (JsonDeserializer)ULongDeserializer.INSTANCE;
        } else if (Intrinsics.areEqual((Object)type.getRawClass(), Duration.class)) {
            JavaToKotlinDurationConverter javaToKotlinDurationConverter;
            JavaToKotlinDurationConverter it = javaToKotlinDurationConverter = JavaToKotlinDurationConverter.INSTANCE;
            boolean bl = false;
            JavaToKotlinDurationConverter javaToKotlinDurationConverter2 = this.useJavaDurationConversion ? javaToKotlinDurationConverter : null;
            jsonDeserializer = (JsonDeserializer)(javaToKotlinDurationConverter2 != null ? javaToKotlinDurationConverter2.getDelegatingDeserializer() : null);
        } else {
            jsonDeserializer = null;
        }
        return jsonDeserializer;
    }
}

