/*
 * Decompiled with CFR 0.152.
 */
package com.faendir.gradle;

import com.faendir.gradle.Bom;
import com.faendir.gradle.Dependency;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import com.fasterxml.jackson.module.kotlin.KotlinModule;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.nio.charset.Charset;
import java.util.function.Supplier;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.gradle.api.artifacts.ArtifactCollection;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.DependencyArtifact;
import org.gradle.api.artifacts.ExternalDependency;
import org.gradle.api.artifacts.result.ResolvedArtifactResult;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.attributes.Category;
import org.gradle.api.internal.artifacts.DependencyResolutionServices;
import org.gradle.api.internal.artifacts.dependencies.DefaultDependencyArtifact;
import org.gradle.api.model.ObjectFactory;
import org.gradle.configurationcache.extensions.CharSequenceExtensionsKt;
import org.gradle.internal.FileUtils;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0018\u0010\t\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n\u00a2\u0006\u0002\u0010\rJ\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0010\u001a\u00020\bH\u0002J\"\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0012\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020\f0\u001fJ\"\u0010\u001a\u001a\u00020\u001b2\u0006\u0010!\u001a\u00020\u00012\u0012\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020\f0\u001fJ\u0010\u0010\"\u001a\u00020 2\u0006\u0010#\u001a\u00020$H\u0002R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0010\u001a\u00020\b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0013\u0010\u0014\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\t\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0015\u001a\n \u0017*\u0004\u0018\u00010\u00160\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/faendir/gradle/BomDownloader;", "", "name", "", "objects", "Lorg/gradle/api/model/ObjectFactory;", "dependencyResolutionServicesSupplier", "Ljava/util/function/Supplier;", "Lorg/gradle/api/internal/artifacts/DependencyResolutionServices;", "withContext", "Lkotlin/Function2;", "Ljava/lang/Runnable;", "", "(Ljava/lang/String;Lorg/gradle/api/model/ObjectFactory;Ljava/util/function/Supplier;Lkotlin/jvm/functions/Function2;)V", "count", "", "drs", "getDrs", "()Lorg/gradle/api/internal/artifacts/DependencyResolutionServices;", "drs$delegate", "Lkotlin/Lazy;", "xml", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "kotlin.jvm.PlatformType", "createResolvableConfiguration", "Lorg/gradle/api/artifacts/Configuration;", "download", "Lorg/gradle/api/artifacts/Dependency;", "dependency", "Lcom/faendir/gradle/Dependency;", "process", "Lkotlin/Function1;", "Lcom/faendir/gradle/Bom;", "dependencyNotation", "loadBom", "modelFile", "Ljava/io/File;", "bom-version-catalog"})
@SourceDebugExtension(value={"SMAP\nBomDownloader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BomDownloader.kt\ncom/faendir/gradle/BomDownloader\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,67:1\n1855#2,2:68\n*S KotlinDebug\n*F\n+ 1 BomDownloader.kt\ncom/faendir/gradle/BomDownloader\n*L\n39#1:68,2\n*E\n"})
public final class BomDownloader {
    @NotNull
    private final String name;
    @NotNull
    private final ObjectFactory objects;
    @NotNull
    private final Supplier<DependencyResolutionServices> dependencyResolutionServicesSupplier;
    @NotNull
    private final Function2<String, Runnable, Unit> withContext;
    private int count;
    @NotNull
    private final Lazy drs$delegate;
    private final ObjectMapper xml;

    public BomDownloader(@NotNull String name, @NotNull ObjectFactory objects, @NotNull Supplier<DependencyResolutionServices> dependencyResolutionServicesSupplier, @NotNull Function2<? super String, ? super Runnable, Unit> withContext) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)objects, (String)"objects");
        Intrinsics.checkNotNullParameter(dependencyResolutionServicesSupplier, (String)"dependencyResolutionServicesSupplier");
        Intrinsics.checkNotNullParameter(withContext, (String)"withContext");
        this.name = name;
        this.objects = objects;
        this.dependencyResolutionServicesSupplier = dependencyResolutionServicesSupplier;
        this.withContext = withContext;
        this.drs$delegate = LazyKt.lazy((Function0)((Function0)new Function0<DependencyResolutionServices>(this){
            final /* synthetic */ BomDownloader this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final DependencyResolutionServices invoke() {
                return (DependencyResolutionServices)BomDownloader.access$getDependencyResolutionServicesSupplier$p(this.this$0).get();
            }
        }));
        this.xml = new XmlMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).registerModule((Module)new KotlinModule.Builder().build());
    }

    private final DependencyResolutionServices getDrs() {
        Lazy lazy = this.drs$delegate;
        return (DependencyResolutionServices)lazy.getValue();
    }

    @NotNull
    public final org.gradle.api.artifacts.Dependency download(@NotNull Dependency dependency2, @NotNull Function1<? super Bom, Unit> process) {
        Intrinsics.checkNotNullParameter((Object)dependency2, (String)"dependency");
        Intrinsics.checkNotNullParameter(process, (String)"process");
        return this.download(dependency2.getGroupId() + ':' + dependency2.getArtifactId() + ':' + dependency2.getVersion(), process);
    }

    @NotNull
    public final org.gradle.api.artifacts.Dependency download(@NotNull Object dependencyNotation, @NotNull Function1<? super Bom, Unit> process) {
        Intrinsics.checkNotNullParameter((Object)dependencyNotation, (String)"dependencyNotation");
        Intrinsics.checkNotNullParameter(process, (String)"process");
        DependencyResolutionServices dependencyResolutionServices = this.getDrs();
        Intrinsics.checkNotNullExpressionValue((Object)dependencyResolutionServices, (String)"<get-drs>(...)");
        Configuration cnf = this.createResolvableConfiguration(dependencyResolutionServices);
        org.gradle.api.artifacts.Dependency dependency2 = this.getDrs().getDependencyHandler().create(dependencyNotation);
        if (dependency2 instanceof ExternalDependency) {
            ((ExternalDependency)dependency2).addArtifact((DependencyArtifact)new DefaultDependencyArtifact(dependency2.getName(), "pom", "pom", null, null));
        }
        cnf.getDependencies().add((Object)dependency2);
        ArtifactCollection artifactCollection = cnf.getIncoming().getArtifacts();
        Intrinsics.checkNotNullExpressionValue((Object)artifactCollection, (String)"getArtifacts(...)");
        Iterable $this$forEach$iv = (Iterable)artifactCollection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ResolvedArtifactResult it = (ResolvedArtifactResult)element$iv;
            boolean bl = false;
            this.withContext.invoke((Object)("bom " + it.getVariant().getOwner()), () -> BomDownloader.download$lambda$1$lambda$0(process, this, it));
        }
        Intrinsics.checkNotNull((Object)dependency2);
        return dependency2;
    }

    private final Bom loadBom(File modelFile) {
        Object object;
        if (!FileUtils.hasExtensionIgnoresCase((String)modelFile.getName(), (String)"pom")) {
            throw new IllegalArgumentException("File " + modelFile.getName() + " isn't supported");
        }
        if (!modelFile.exists()) {
            throw new IllegalStateException("Import of external catalog file failed because File '" + modelFile + "' doesn't exist");
        }
        try {
            File file = modelFile;
            Charset charset = Charsets.UTF_8;
            int n = 8192;
            Object object2 = file;
            object2 = new InputStreamReader((InputStream)new FileInputStream((File)object2), charset);
            object = this.xml.readValue((Reader)(object2 instanceof BufferedReader ? (BufferedReader)object2 : new BufferedReader((Reader)object2, n)), Bom.class);
            Intrinsics.checkNotNull((Object)object);
            object = (Bom)object;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return object;
    }

    private final Configuration createResolvableConfiguration(DependencyResolutionServices drs2) {
        int n = this.count;
        this.count = n + 1;
        Configuration cnf = (Configuration)drs2.getConfigurationContainer().create("incomingBomFor" + CharSequenceExtensionsKt.capitalized((CharSequence)this.name) + n);
        cnf.getResolutionStrategy().activateDependencyLocking();
        cnf.attributes(arg_0 -> BomDownloader.createResolvableConfiguration$lambda$2((Function1)new Function1<AttributeContainer, Unit>(this){
            final /* synthetic */ BomDownloader this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(AttributeContainer it) {
                it.attribute(Category.CATEGORY_ATTRIBUTE, (Object)BomDownloader.access$getObjects$p(this.this$0).named(Category.class, "platform"));
            }
        }, arg_0));
        cnf.setCanBeResolved(true);
        cnf.setCanBeConsumed(false);
        Intrinsics.checkNotNull((Object)cnf);
        return cnf;
    }

    private static final void download$lambda$1$lambda$0(Function1 $process, BomDownloader this$0, ResolvedArtifactResult $it) {
        Intrinsics.checkNotNullParameter((Object)$process, (String)"$process");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        File file = $it.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getFile(...)");
        $process.invoke((Object)this$0.loadBom(file));
    }

    private static final void createResolvableConfiguration$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    public static final /* synthetic */ ObjectFactory access$getObjects$p(BomDownloader $this) {
        return $this.objects;
    }

    public static final /* synthetic */ Supplier access$getDependencyResolutionServicesSupplier$p(BomDownloader $this) {
        return $this.dependencyResolutionServicesSupplier;
    }
}

