/*
 * Decompiled with CFR 0.152.
 */
package com.epam.healenium.processor;

import com.epam.healenium.model.ReferenceElementsDto;
import com.epam.healenium.processor.BaseProcessor;
import com.epam.healenium.treecomparing.Node;
import java.util.List;
import java.util.stream.Collectors;
import org.openqa.selenium.WebElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HealingElementsProcessor
extends BaseProcessor {
    private static final Logger log = LoggerFactory.getLogger((String)"healenium");

    public HealingElementsProcessor(BaseProcessor nextProcessor) {
        super(nextProcessor);
    }

    @Override
    public boolean validate() {
        ReferenceElementsDto lastHealingData = this.context.getReferenceElementsDto();
        if (lastHealingData == null || lastHealingData.getPaths().isEmpty()) {
            if (this.context.getElements().isEmpty()) {
                log.warn("New element locator have not been found. There is no reference data to selector in the database.\nMake sure that: \n- There is selector on the page {}/selectors/ and type: multiple, if not then you have to run successful tests.\n- Your locator was changed on the page and not in code.", (Object)this.engine.getClient().getServerUrl());
            }
            return false;
        }
        return true;
    }

    @Override
    public void execute() {
        List<List<Node>> nodesFromDb = this.context.getReferenceElementsDto().getPaths();
        this.splitDbNodes(nodesFromDb);
        String targetPage = this.engine.pageSource();
        Node destination = this.engine.parseTree(targetPage);
        this.context.setPageContent(targetPage);
        List<List> nodesToHeal = nodesFromDb.stream().filter(nodes -> !this.context.getNewElementsToNodes().containsValue(nodes) && !this.context.getExistElementsToNodes().containsValue(nodes)).collect(Collectors.toList());
        if (!nodesToHeal.isEmpty()) {
            log.warn("Failed to find an elements using locator {}", (Object)this.context.getBy().toString());
            log.warn("Trying to heal...");
        }
        nodesToHeal.forEach(nodes -> this.healingService.findNewLocations((List<Node>)nodes, destination, this.context));
    }

    private void splitDbNodes(List<List<Node>> nodesFromDb) {
        for (WebElement webElement : this.context.getElements()) {
            List<Node> nodePath = this.engine.getNodeService().getNodePath(this.driver, webElement, this.context);
            if (!nodesFromDb.contains(nodePath)) {
                this.context.getNewElementsToNodes().put(webElement, nodePath);
                continue;
            }
            this.context.getExistElementsToNodes().put(webElement, nodePath);
        }
    }
}

