/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.esign.model;

import com.docusign.esign.model.AddressInformation;
import com.docusign.esign.model.AuthenticationMethod;
import com.docusign.esign.model.UsageHistory;
import com.docusign.esign.model.UserInformation;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class UserProfile {
    @JsonProperty(value="address")
    private AddressInformation address = null;
    @JsonProperty(value="authenticationMethods")
    private List<AuthenticationMethod> authenticationMethods = null;
    @JsonProperty(value="companyName")
    private String companyName = null;
    @JsonProperty(value="displayOrganizationInfo")
    private String displayOrganizationInfo = null;
    @JsonProperty(value="displayPersonalInfo")
    private String displayPersonalInfo = null;
    @JsonProperty(value="displayProfile")
    private String displayProfile = null;
    @JsonProperty(value="displayUsageHistory")
    private String displayUsageHistory = null;
    @JsonProperty(value="profileImageUri")
    private String profileImageUri = null;
    @JsonProperty(value="title")
    private String title = null;
    @JsonProperty(value="usageHistory")
    private UsageHistory usageHistory = null;
    @JsonProperty(value="userDetails")
    private UserInformation userDetails = null;
    @JsonProperty(value="userProfileLastModifiedDate")
    private String userProfileLastModifiedDate = null;

    public UserProfile address(AddressInformation address) {
        this.address = address;
        return this;
    }

    @Schema(description="The user's address.")
    public AddressInformation getAddress() {
        return this.address;
    }

    public void setAddress(AddressInformation address) {
        this.address = address;
    }

    public UserProfile authenticationMethods(List<AuthenticationMethod> authenticationMethods) {
        this.authenticationMethods = authenticationMethods;
        return this;
    }

    public UserProfile addAuthenticationMethodsItem(AuthenticationMethod authenticationMethodsItem) {
        if (this.authenticationMethods == null) {
            this.authenticationMethods = new ArrayList<AuthenticationMethod>();
        }
        this.authenticationMethods.add(authenticationMethodsItem);
        return this;
    }

    @Schema(description="These properties cannot be modified in the PUT.   Indicates the authentication methods used by the user.")
    public List<AuthenticationMethod> getAuthenticationMethods() {
        return this.authenticationMethods;
    }

    public void setAuthenticationMethods(List<AuthenticationMethod> authenticationMethods) {
        this.authenticationMethods = authenticationMethods;
    }

    public UserProfile companyName(String companyName) {
        this.companyName = companyName;
        return this;
    }

    @Schema(description="The name of the user's Company.")
    public String getCompanyName() {
        return this.companyName;
    }

    public void setCompanyName(String companyName) {
        this.companyName = companyName;
    }

    public UserProfile displayOrganizationInfo(String displayOrganizationInfo) {
        this.displayOrganizationInfo = displayOrganizationInfo;
        return this;
    }

    @Schema(description=" When set to **true**, the user's company and title information are shown on the ID card. ")
    public String getDisplayOrganizationInfo() {
        return this.displayOrganizationInfo;
    }

    public void setDisplayOrganizationInfo(String displayOrganizationInfo) {
        this.displayOrganizationInfo = displayOrganizationInfo;
    }

    public UserProfile displayPersonalInfo(String displayPersonalInfo) {
        this.displayPersonalInfo = displayPersonalInfo;
        return this;
    }

    @Schema(description="When set to **true**, the user's Address and Phone number are shown on the ID card.")
    public String getDisplayPersonalInfo() {
        return this.displayPersonalInfo;
    }

    public void setDisplayPersonalInfo(String displayPersonalInfo) {
        this.displayPersonalInfo = displayPersonalInfo;
    }

    public UserProfile displayProfile(String displayProfile) {
        this.displayProfile = displayProfile;
        return this;
    }

    @Schema(description="When set to **true**, the user's ID card can be viewed from signed documents and envelope history.")
    public String getDisplayProfile() {
        return this.displayProfile;
    }

    public void setDisplayProfile(String displayProfile) {
        this.displayProfile = displayProfile;
    }

    public UserProfile displayUsageHistory(String displayUsageHistory) {
        this.displayUsageHistory = displayUsageHistory;
        return this;
    }

    @Schema(description="When set to **true**, the user's usage information is shown on the ID card.")
    public String getDisplayUsageHistory() {
        return this.displayUsageHistory;
    }

    public void setDisplayUsageHistory(String displayUsageHistory) {
        this.displayUsageHistory = displayUsageHistory;
    }

    public UserProfile profileImageUri(String profileImageUri) {
        this.profileImageUri = profileImageUri;
        return this;
    }

    @Schema(description="")
    public String getProfileImageUri() {
        return this.profileImageUri;
    }

    public void setProfileImageUri(String profileImageUri) {
        this.profileImageUri = profileImageUri;
    }

    public UserProfile title(String title) {
        this.title = title;
        return this;
    }

    @Schema(description="")
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public UserProfile usageHistory(UsageHistory usageHistory) {
        this.usageHistory = usageHistory;
        return this;
    }

    @Schema(description="A complex element consisting of:   - `lastSentDateTime`: The date and time the user last sent an envelope.  - `lastSignedDateTime`: The date and time the user last signed an envelope. - `sentCount`: The number of envelopes the user has sent. - `signedCount`: The number of envelopes the user has signed.  ")
    public UsageHistory getUsageHistory() {
        return this.usageHistory;
    }

    public void setUsageHistory(UsageHistory usageHistory) {
        this.usageHistory = usageHistory;
    }

    public UserProfile userDetails(UserInformation userDetails) {
        this.userDetails = userDetails;
        return this;
    }

    @Schema(description="")
    public UserInformation getUserDetails() {
        return this.userDetails;
    }

    public void setUserDetails(UserInformation userDetails) {
        this.userDetails = userDetails;
    }

    public UserProfile userProfileLastModifiedDate(String userProfileLastModifiedDate) {
        this.userProfileLastModifiedDate = userProfileLastModifiedDate;
        return this;
    }

    @Schema(description="")
    public String getUserProfileLastModifiedDate() {
        return this.userProfileLastModifiedDate;
    }

    public void setUserProfileLastModifiedDate(String userProfileLastModifiedDate) {
        this.userProfileLastModifiedDate = userProfileLastModifiedDate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserProfile userProfile = (UserProfile)o;
        return Objects.equals(this.address, userProfile.address) && Objects.equals(this.authenticationMethods, userProfile.authenticationMethods) && Objects.equals(this.companyName, userProfile.companyName) && Objects.equals(this.displayOrganizationInfo, userProfile.displayOrganizationInfo) && Objects.equals(this.displayPersonalInfo, userProfile.displayPersonalInfo) && Objects.equals(this.displayProfile, userProfile.displayProfile) && Objects.equals(this.displayUsageHistory, userProfile.displayUsageHistory) && Objects.equals(this.profileImageUri, userProfile.profileImageUri) && Objects.equals(this.title, userProfile.title) && Objects.equals(this.usageHistory, userProfile.usageHistory) && Objects.equals(this.userDetails, userProfile.userDetails) && Objects.equals(this.userProfileLastModifiedDate, userProfile.userProfileLastModifiedDate);
    }

    public int hashCode() {
        return Objects.hash(this.address, this.authenticationMethods, this.companyName, this.displayOrganizationInfo, this.displayPersonalInfo, this.displayProfile, this.displayUsageHistory, this.profileImageUri, this.title, this.usageHistory, this.userDetails, this.userProfileLastModifiedDate);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UserProfile {\n");
        sb.append("    address: ").append(this.toIndentedString(this.address)).append("\n");
        sb.append("    authenticationMethods: ").append(this.toIndentedString(this.authenticationMethods)).append("\n");
        sb.append("    companyName: ").append(this.toIndentedString(this.companyName)).append("\n");
        sb.append("    displayOrganizationInfo: ").append(this.toIndentedString(this.displayOrganizationInfo)).append("\n");
        sb.append("    displayPersonalInfo: ").append(this.toIndentedString(this.displayPersonalInfo)).append("\n");
        sb.append("    displayProfile: ").append(this.toIndentedString(this.displayProfile)).append("\n");
        sb.append("    displayUsageHistory: ").append(this.toIndentedString(this.displayUsageHistory)).append("\n");
        sb.append("    profileImageUri: ").append(this.toIndentedString(this.profileImageUri)).append("\n");
        sb.append("    title: ").append(this.toIndentedString(this.title)).append("\n");
        sb.append("    usageHistory: ").append(this.toIndentedString(this.usageHistory)).append("\n");
        sb.append("    userDetails: ").append(this.toIndentedString(this.userDetails)).append("\n");
        sb.append("    userProfileLastModifiedDate: ").append(this.toIndentedString(this.userProfileLastModifiedDate)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

