/*
 * Decompiled with CFR 0.152.
 */
package com.c4_soft.springaddons.security.oidc;

import java.io.Serializable;
import java.security.Principal;
import java.util.Collection;
import java.util.Map;
import lombok.Generated;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.oauth2.core.OAuth2AuthenticatedPrincipal;
import org.springframework.security.oauth2.core.OAuth2Token;
import org.springframework.security.oauth2.server.resource.authentication.AbstractOAuth2TokenAuthenticationToken;
import org.springframework.util.StringUtils;

public class OAuthentication<T extends Map<String, Object> & Serializable & OAuth2Token>
extends AbstractOAuth2TokenAuthenticationToken<T>
implements OAuth2AuthenticatedPrincipal {
    private static final long serialVersionUID = 8193642106297738796L;
    private final T token;

    public OAuthentication(T token, Collection<? extends GrantedAuthority> authorities) {
        super(token, authorities);
        super.setAuthenticated(true);
        super.setDetails(token);
        this.token = token;
    }

    public T getTokenAttributes() {
        return this.token;
    }

    public void setDetails(Object details) {
        throw new RuntimeException("OAuthentication details are immutable");
    }

    public void setAuthenticated(boolean isAuthenticated) {
        throw new RuntimeException("OAuthentication authentication status is immutable");
    }

    public String getCredentials() {
        return ((OAuth2Token)this.token).getTokenValue();
    }

    public String getName() {
        return ((Principal)this.getPrincipal()).getName();
    }

    public T getPrincipal() {
        return this.token;
    }

    public T getAttributes() {
        return this.token;
    }

    public T getClaims() {
        return this.token;
    }

    public String getBearerHeader() {
        if (!StringUtils.hasText((String)((OAuth2Token)this.token).getTokenValue())) {
            return null;
        }
        return String.format("Bearer %s", ((OAuth2Token)this.token).getTokenValue());
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OAuthentication)) {
            return false;
        }
        OAuthentication other = (OAuthentication)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        T this$token = this.token;
        T other$token = other.token;
        return !(this$token == null ? other$token != null : !this$token.equals(other$token));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof OAuthentication;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        T $token = this.token;
        result = result * 59 + ($token == null ? 43 : $token.hashCode());
        return result;
    }
}

