/*
 * Decompiled with CFR 0.152.
 */
package com.c4_soft.springaddons.security.oauth2.test;

import com.c4_soft.springaddons.security.oauth2.test.AuthenticationBuilder;
import com.c4_soft.springaddons.security.oauth2.test.Defaults;
import com.c4_soft.springaddons.security.oauth2.test.OpenidTokenBuilder;
import com.c4_soft.springaddons.security.oidc.OAuthentication;
import com.c4_soft.springaddons.security.oidc.OpenidToken;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.springframework.security.core.authority.SimpleGrantedAuthority;

public class OAuthenticationTestingBuilder
implements AuthenticationBuilder<OAuthentication<OpenidToken>> {
    protected final OpenidTokenBuilder tokenBuilder = (OpenidTokenBuilder)((Object)((OpenidTokenBuilder)((Object)new OpenidTokenBuilder().subject("user"))).name("user"));
    private final Set<String> authorities = new HashSet<String>(Defaults.AUTHORITIES);

    @Override
    public OAuthentication<OpenidToken> build() {
        return new OAuthentication((Map)this.tokenBuilder.build(), (Collection)this.authorities.stream().map(SimpleGrantedAuthority::new).collect(Collectors.toSet()));
    }

    public OAuthenticationTestingBuilder authorities(String ... authorities) {
        this.authorities.clear();
        this.authorities.addAll(Arrays.asList(authorities));
        return this;
    }

    public OAuthenticationTestingBuilder token(Consumer<OpenidTokenBuilder> tokenBuilderConsumer) {
        tokenBuilderConsumer.accept(this.tokenBuilder);
        return this;
    }

    public OAuthenticationTestingBuilder bearerString(String bearerString) {
        this.tokenBuilder.tokenValue(bearerString);
        return this;
    }
}

