/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.api.command;

import com.bmuschko.gradle.docker.shaded.javax.annotation.CheckForNull;
import com.github.dockerjava.api.async.ResultCallback;
import com.github.dockerjava.api.exception.DockerClientException;
import com.github.dockerjava.api.model.PullResponseItem;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PullImageResultCallback
extends ResultCallback.Adapter<PullResponseItem> {
    private static final Logger LOGGER = LoggerFactory.getLogger(PullImageResultCallback.class);
    private boolean isSwarm = false;
    private Map<String, PullResponseItem> results = null;
    @CheckForNull
    private PullResponseItem latestItem = null;

    @Override
    public void onNext(PullResponseItem item) {
        if (this.results == null && this.latestItem == null) {
            this.checkForDockerSwarmResponse(item);
        }
        if (this.isSwarm) {
            this.handleDockerSwarmResponse(item);
        } else {
            this.handleDockerClientResponse(item);
        }
        LOGGER.debug("{}", (Object)item);
    }

    private void checkForDockerSwarmResponse(PullResponseItem item) {
        if (item.getStatus().matches("Pulling\\s.+\\.{3}$")) {
            this.isSwarm = true;
            LOGGER.debug("Communicating with Docker Swarm.");
        }
    }

    private void handleDockerSwarmResponse(PullResponseItem item) {
        PullResponseItem currentItem;
        if (this.results == null) {
            this.results = new HashMap<String, PullResponseItem>();
        }
        if ((currentItem = this.results.get(item.getId())) == null || !currentItem.isPullSuccessIndicated()) {
            this.results.put(item.getId(), item);
        }
    }

    private void handleDockerClientResponse(PullResponseItem item) {
        this.latestItem = item;
    }

    private void checkDockerSwarmPullSuccessful() {
        if (this.results.isEmpty()) {
            throw new DockerClientException("Could not pull image through Docker Swarm");
        }
        boolean pullFailed = false;
        StringBuilder sb = new StringBuilder();
        for (PullResponseItem pullResponseItem : this.results.values()) {
            if (pullResponseItem.isPullSuccessIndicated()) continue;
            pullFailed = true;
            sb.append("[" + pullResponseItem.getId() + ":" + this.messageFromPullResult(pullResponseItem) + "]");
        }
        if (pullFailed) {
            throw new DockerClientException("Could not pull image: " + sb.toString());
        }
    }

    private void checkDockerClientPullSuccessful() {
        if (this.latestItem == null) {
            return;
        }
        if (!this.latestItem.isPullSuccessIndicated()) {
            throw new DockerClientException("Could not pull image: " + this.messageFromPullResult(this.latestItem));
        }
    }

    private String messageFromPullResult(PullResponseItem pullResponseItem) {
        return pullResponseItem.getError() != null ? pullResponseItem.getError() : pullResponseItem.getStatus();
    }

    @Override
    protected void throwFirstError() {
        super.throwFirstError();
        if (this.isSwarm) {
            this.checkDockerSwarmPullSuccessful();
        } else {
            this.checkDockerClientPullSuccessful();
        }
    }
}

